/* copy this section to rob.ini
  
Input_File_Name = rob.pov
                   
width = 320
height = 240                   
                   
Antialias_Threshold = 0.1
Antialias_Depth = 3 // 2

Output_File_Type = T    
Output_File_Name = C:\cmpeg\robot\
     
Initial_Frame = 1455 // 768 // 0   // opening =0
Final_Frame =   1599 // 1499 //1299 //999   // 767 // 47

Initial_Clock = 10 // 0 // 0   // 0
Final_clock =   11 // 8 // 5     // 1

Cyclic_Animation = on
Pause_When_Done = off  

*/





// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1    ;

#include "colors.inc"

global_settings
{
  assumed_gamma 2.2
}

// ----------------------------------------

#if ( (clock >= 0) & (clock < 1) )

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-60, 30, -60>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <60, 200, -60>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 80, 00>
}                                


#end

#if (clock >=1)
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 0.0  blue 1.0  // light's color
  translate <-60, 30, -60>
}

light_source
{
  0*x // light's position (translated below)
  color red .0  green 1.0  blue 1.0  // light's color
  translate <60, 200, -60>
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 0.0  // light's color
  translate <-30, 80, 00>
}                                
#end

// ----------------------------------------

#if ( (clock >= 0) & (clock < .5) )

camera
{
  location  <-20.0, 5, -30.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}  

text { ttf "C:\windows\fonts\arialbd.ttf" "Matt Giwer" 1, 0
    pigment { color rgbt <.9,.4,.1,1-clock*2> } scale .25*z scale 2 translate <-10.0.0> 
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  } 

text { ttf "C:\windows\fonts\arialbd.ttf" "presents" 1, 0
    pigment { color rgbt <.9,.4,.1,1-clock*2> } scale .25*z scale 2 translate <-10.0.0> translate <0,-2.5,0>
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  }
  
text { ttf "C:\windows\fonts\arialbd.ttf" "Dances with Droids" 1, 0
    pigment { color rgbt <.9,.4,.1,1-clock*2> } scale .25*z scale 2 translate <-10.0.0> translate <0,-5,0>
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  }

#end

#if ( (clock >= .5) & (clock < 1) )

camera
{
  location  <-20.0, 5, -30.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}  

text { ttf "C:\windows\fonts\arialbd.ttf" "Matt Giwer" 1, 0
    pigment { color rgb <.9,.4,.1> } scale .25*z scale 2 translate <-10.0.0> 
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  } 

text { ttf "C:\windows\fonts\arialbd.ttf" "presents" 1, 0
    pigment { color rgb <.9,.4,.1> } scale .25*z scale 2 translate <-10.0.0> translate <0,-2.5,0>
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  }
  
text { ttf "C:\windows\fonts\arialbd.ttf" "Dances with Droids" 1, 0
    pigment { color rgb <.9,.4,.1> } scale .25*z scale 2 translate <-10.0.0> translate <0,-5,0>
    rotate 35*y translate <0,-15,0>
translate <0,clock*35,0>  }

#end


#if ( (clock >= 1) & ( clock <= 200) )

#declare i=0;
 
#if ( (clock >= 1) & ( clock <= 5) )

camera
{
  location  <-20.0, 3, -30.0> 
  direction 1.5*z
  right     4/3*x
  look_at   <-5.0, -8.0,  -10.0>
}
                                 
#end
//18, , 22 
#if ( (clock > 5) & ( clock < 6) )
camera
{
location<-20.0 + 38*sin((clock-5)*pi/2), 3-(clock-5)*11,-8.0 -22*cos((clock-5)*pi/2)>
  //<-20.0, 3, -30.0> 
  direction 1.5*z
  right     4/3*x
  look_at   <-5.0, -8.0,  -10.0>
}  
#end 

#if ( (clock >= 6) & ( clock < 7) )
camera
{
location<-20.0+38*sin((clock-5)*pi/2),3-11+(clock-6)*11,-8.0 +22*cos((clock-5)*pi/2)>
//location<-20.0+18-18*sin((clock-6)*pi/2),3-11+(clock-6)*11,-8.0 +22*cos(pi/2+(clock-6)*pi/2)>

//  location  <-20.0, 3, -30.0> 
  direction 1.5*z
  right     4/3*x
  look_at   <-5.0, -8.0,  -10.0>
}  
#end

#if ( (clock >= 7) & ( clock < 8) ) 
camera
{
  location  <-20.0, 3, -30.0> 
  direction 1.5*z
  right     4/3*x
  look_at   <-5.0, -8.0,  -10.0>
}                                   
#end 

#if ((clock >= 8) & (clock<11))
camera
{
  location <-20.0, 3, -30.0>
  direction 1.5*z
  right 4/3*x
  look_at <-5, -8 + (clock - 8)*40, -10.0>
}
#end

#if ((clock>=10) & (clock <11))
text { ttf "C:\windows\fonts\arialbd.ttf" "The End" 1, 0
    pigment { color rgbt <.9,.4,.1, #if (1-(clock-10)*2 < 1) 1-(clock-10)*2 #else 1 #end > } 
    scale .25*z scale 30 rotate -70*x rotate 37*y 
    translate <-45,0,40> 
    translate <0,200,0>
}
#end 

//center
sphere { 0.0, 1 scale <.5,30,.5> texture {pigment {radial frequency 4*clock} finish{specular 1}} }

//around
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(2*pi/12),0,60*cos(2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(2*2*pi/12),0,60*cos(2*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(3*2*pi/12),0,60*cos(3*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(4*2*pi/12),0,60*cos(4*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(5*2*pi/12),0,60*cos(5*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(6*2*pi/12),0,60*cos(6*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(7*2*pi/12),0,60*cos(7*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(8*2*pi/12),0,60*cos(8*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(9*2*pi/12),0,60*cos(9*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(10*2*pi/12),0,60*cos(10*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(11*2*pi/12),0,60*cos(11*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }
sphere { 0.0, 1 scale <.5,20,.5> translate <60*sin(12*2*pi/12),0,60*cos(12*2*pi/12)> texture {pigment {radial frequency 20} finish{specular 1}} }



plane { y, -10 pigment {color rgb <0.7,0.5,0.3>} normal { bumps 0.4 scale 2}}
/*plane { x, -10 pigment {color rgb <1,0,0>}}
plane { z, -10 pigment {color rgb <0,1,0>}}
  */
#declare rob1 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}

#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end


#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate clock*20*90*x translate -.95*x}
object {arm rotate clock*30*90*x translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object {head rotate  clock*10*y  } 

} // rob                

#if (clock<7)
object { rob1 rotate <0,60,0> translate <12*sin(clock*2*pi/6),-7.5,8*cos(clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob1 rotate clock*2*<0,60,0> translate <12*sin(clock*2*pi/6),-7.5+abs( 2*sin(6*(clock-7)*2*pi)),8*cos(2*clock*2*pi/6)>}
#end

#if ((clock>=8) & (clock<11))
object { rob1 rotate clock*2*<0,60,0> translate <12*sin(clock*2*pi/6),-7.5+abs( 2*sin(6*(clock-7)*2*pi))+(clock-8)*50,8*cos(2*clock*2*pi/6)>}
#end

#if ( clock > 1 + 1/6)

#declare rob2 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}
#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end                            

#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate clock * -90*10 *x translate -.95*x}
object {arm rotate clock * 90*10*x translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object { head rotate clock * -15*y }

} // rob                


#if (clock<7)
object { rob2 rotate <0,120,0> translate <8*sin(2*clock*2*pi/6),-7.5,13*cos(2*clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob2 rotate clock*2*<0,120,0> translate <8*sin(2*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi)),13*cos(2*2*clock*2*pi/6)>}
#end

#if ((clock>=8) & (clock<11))
object { rob2 rotate clock*2*<0,120,0> translate <8*sin(2*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi))+(clock-8)*50,13*cos(2*2*clock*2*pi/6)>}
#end

#if (clock > 1 + 2/6)
 
#declare rob3 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}
#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end                             

#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate clock*90*10*x translate -.95*x}
object {arm rotate clock*45*15*x translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object { head rotate clock*30*y }

} // rob                


#if (clock<7)
object { rob3 rotate <0,180,0> translate <9*sin(3*clock*2*pi/6),-7.5,13*cos(3*clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob3 rotate clock*2*<0,180,0> translate <9*sin(3*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi)),13*cos(3*2*clock*2*pi/6)>}
#end
 
#if ((clock>=8) & (clock<11))
object { rob3 rotate clock*2*<0,180,0> translate <9*sin(3*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi))+(clock-8)*50,13*cos(3*2*clock*2*pi/6)>}
#end

#if (clock > 1 +3/6 )

#declare rob4 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}
#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end                             

#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate clock*90*5*x translate -.95*x}
object {arm rotate -clock*90*15*x translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object {head rotate -clock*20*y}

} // rob                


#if (clock<7)
object { rob4 rotate <0,240,0> translate <10*sin(4*clock*2*pi/6),-7.5,15*cos(4*clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob4 rotate clock*2*<0,240,0> translate <10*sin(4*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi)),15*cos(4*2*clock*2*pi/6)>}
#end

#if ((clock>=8) & (clock<11))
object { rob4 rotate clock*2*<0,240,0> translate <10*sin(4*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi))+(clock-8)*50,15*cos(4*2*clock*2*pi/6)>}
#end

#if (clock > 1 + 4/6)  
 
#declare rob5 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}
#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end                              

#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate clock*145*2*x translate -.95*x}
object {arm rotate -clock*160*2.5*x translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object {head rotate clock*3*x}

} // rob                


#if (clock<7)
object { rob5 rotate <0,300,0> translate <6*sin(5*clock*2*pi/6),-7.5,12*cos(5*clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob5 rotate clock*2*<0,300,0> translate <6*sin(5*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi)),12*cos(5*2*clock*2*pi/6)>}
#end
 
#if ((clock>=8) & (clock<11))
object { rob5 rotate clock*2*<0,300,0> translate <6*sin(5*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi))+(clock-8)*50,12*cos(5*2*clock*2*pi/6)>}
#end

#if (clock > 1 + 5/6)

#declare rob6 = union {

sphere { 0.0, 1 texture {pigment {radial frequency 58} finish{specular 1}} }

#declare leg = union { 
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.70*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.80*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -.90*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.00*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.10*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.20*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.30*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.40*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.50*y}
torus { .25, .1  texture {pigment {radial frequency 8} finish{specular 1}} translate -1.60*y}

} // leg
                               
object {leg rotate 0*x translate <-.5,-.5,0>}
#if (clock < 7)
object {leg rotate 0*x translate <.5,-.5,0> }                              
#end

#if ( (clock>=7) & (clock <10))
object {leg rotate -90*x translate <.5,-.5,0> }
#end                             

#declare arm = union {

sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} }
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.375*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.5*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.625*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.75*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -.875*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.125*z}
sphere { 0, .25 texture {pigment {radial frequency 8} finish{specular 1}} translate -1.25*z}
}

object {arm rotate 90*clock*x*2.3 translate -.95*x}
object {arm rotate -180*clock*x*3.2 translate .95*x}

#declare head = union {
sphere { 0, .7 texture{pigment {radial frequency 28} finish{specular 1}} translate .9*y }

#declare eye = union {
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} }
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.05*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.10*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.25*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.30*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.35*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.40*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.45*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.50*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.55*y}
torus { .05, .03  texture {pigment {radial frequency 8} finish{specular 1}} translate -.60*y}

} // eye


object {eye rotate -90*x translate 1.25*y translate .25*x translate -.85*z}
object {eye rotate -90*x translate 1.25*y translate -.25*x translate -.85*z}

} // head

object {head rotate clock*15*y} 

} // rob                


#if (clock<7)
object { rob6 rotate <0,360,0> translate <13*sin(6*clock*2*pi/6),-7.5,9*cos(6*clock*2*pi/6)>}
#end

#if ((clock>=7) & (clock<8))
object { rob6 rotate clock*2*<0,360,0> translate <13*sin(6*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi)),9*cos(6*2*clock*2*pi/6)>}
#end

#if ((clock>=8) & (clock<11))
object { rob6 rotate clock*2*<0,360,0> translate <13*sin(6*clock*2*pi/6),-7.5+abs(2*sin(6*(clock-7)*2*pi))+(clock-8)*50,9*cos(6*2*clock*2*pi/6)>}
#end 

#end // if > 168

#end // if > 144

#end // if >120
 
#end // if >96 
 
#end // if >72
 
#end


