// outtakes.pov -- Random out-takes for The Runner (runner.pov)
// Copyright 2000 Jeffrey D. Shaffer -- All Rights Reserved.
// movie rate:  4 sec x 24 fps = 96 frames


#include "TOY-Boy.inc"
#include "saw.inc"

#declare loop = 8;     // should be 2 per second
#declare stop = 0;
#declare run = 1;


//
// -------------------- global objects -----------------------
//

light_source {
   <20, 60, -60>
   color rgb <1, 1, 1>
   }

light_source {
   <-20, 30, 20>
   color rgb <1, 1, 1>
   }
   

//
// ---------------------- animation -----------------------
//

#declare Duration = clock*48;
#switch (Duration)

//
// --------------------- OUT-TAKE 1 ------------------------
//

   #range (0, 1) // -------------- Flash --------------------
   // 1/10 second, frames 1 to 2
   // flash between outtakes
      camera {
         location <0, 15, -10>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 15, 0>
         rotate 0*y
      }
      background { color rgb 1 }
      box {<0, 0, 0>, <0, 0, 1>}
   #break // end Flash

   #range (1,48) // -------------- Scene 10 ------------------
   // ~4 seconds, frames 2 to 96
   // Runner's running, saw passes him, he looks at saw
      camera {
         location <15, 15, -26>
         direction 2*z 
         up y 
         right 2*x 
         look_at <0, 14, 5>
         rotate 0*y
      }
      plane { y, 0
         pigment {
            checker color rgb 1, color rgb <0, 0, 1>
            scale 10
         }
         translate clock*19.6*loop*z // in sync with TOY-Boy's running...
      }
      object {blade
         rotate -12*z
         rotate -90*y
         translate 1*y
         scale 5
         translate <-6, 0, 69-1.8*Duration>
      }
      #macro TOY_Boy (motion)   union {
         object { Leg (lft, motion)
            translate 1.55*x}
         object { Leg (rt, motion)
            translate -1.55*x}
         object { Torso (motion)  
            rotate -10*x*motion
            translate 7.75*y
            rotate -8*sin(2*pi*clock*loop)*motion*y
            }
         object { Head_with_Hat                 // rotate when sees saw blade
            #if (Duration < 20)
               rotate -10*x*motion
            #else 
               #if (Duration > 20 & Duration < 40 )
                  rotate 50*((Duration-20)*1/20)*y
                  rotate -10*x*motion
               #else
                  rotate 50*y
                  rotate -10*x*motion
               #end
            #end
            translate 7.75*y
            }
         translate 0.5*abs(sin(2*pi*clock*loop+0.3))*motion*y
         }
         #end
      #if (Duration < 33)
         object { TOY_Boy (run) }
      #else
         object { TOY_Boy ((run-(Duration-33)*1/20))}
      #end
   #break // end Scene 10

#end // close all scenes