#declare Scene=1;

// Configuration
//--------------
#if(Scene=1)
  #declare LightsOn=no;
#end

#if(Scene=2)
  #declare LightsOn=yes;
#end

#if(Scene=3)
  #declare Clock1=(1-cos(2*pi*clock))/2;
  #declare Clock2=(1-cos(pi*clock))/2;
  #declare CameraAngle1=30-10*Clock1;
  #declare CameraAngle2=-20-90*Clock2;
  #declare CameraDistance=18-5*Clock1;
  #declare LegAngleSteps=16;
  #declare LightsOn=yes;
#end

#declare Base=.5;
#declare MaxHeight=1.5;
#declare MaxHeightDiff=1;
#declare FieldLength=10;
#declare FieldWidth=20;


//===========================================================================
// Robot object and position calculation
//===========================================================================
#declare pLength=1.25;

#declare Chrome=
  texture
  { pigment { rgb .9 } finish { specular .8 metallic reflection .5 }
  }
#declare Metal=  
  texture
  { pigment { rgb <.3,.5,.8> } finish { specular .4 metallic }
    normal { bumps .2 scale .03 }
  }

#macro Leg(sPoint, ePoint)
  #local vec=ePoint-sPoint;
  #local len=vlength(vec);
  #local x1=(len-pLength)/2;
  #local y1=sqrt(pLength*pLength-x1*x1);
  #local Ang1=degrees(atan2(vec.y,sqrt(len*len-vec.y*vec.y)));
  #local Ang2=degrees(atan2(vec.z,vec.x));
  union
  { union
    {
      sphere { 0,.2 }
      difference
      { cylinder { -z*.25, z*.25, .15 }
        cylinder { -z*.26, -z*.22, .1 }
        cylinder { z*.26, z*.22, .1 }
      }
      cylinder { -z*.12, <x1,y1,-.12>, .1 texture { Chrome } }
      cylinder { z*.12, <x1,y1,.12>, .1 texture { Chrome } }
      cylinder { <x1/2, y1/2, -.12><x1/2, y1/2, .12>, .15 }
      cylinder { <x1,y1,-.1><x1,y1,.1>, .1 }
      difference
      { cylinder { <x1,y1,-.26><x1,y1,-.1>, .15 }
        cylinder { <x1,y1,-.27><x1,y1,-.22>, .1 }
      }
      difference
      { cylinder { <x1,y1,.26><x1,y1,.1>, .15 }
        cylinder { <x1,y1,.27><x1,y1,.22>, .1 }
      }
      cylinder { <x1,y1><len-x1,y1>, .1 texture { Chrome } }
      cylinder { <len-x1,y1,-.1><len-x1,y1,.1>, .1 }
      difference
      { cylinder { <len-x1,y1,-.25><len-x1,y1,-.1>, .15 }
        cylinder { <len-x1,y1,-.26><len-x1,y1,-.24>, .1 }
      }
      difference
      { cylinder { <len-x1,y1,.25><len-x1,y1,.1>, .15 }
        cylinder { <len-x1,y1,.26><len-x1,y1,.24>, .1 }
      }
      cylinder { <len-x1,y1,-.17>, <len,.05>, .07 texture { Chrome } }
      cylinder { <len-x1,y1,.17>, <len,.05>, .07 texture { Chrome } }
      cylinder { 0,y*.1,.25 rotate -z*Ang1 translate <len,0> }
      intersection
      { sphere { 0,.2 }
        box { <-.2,0,-.2>, .2 }
        translate <len,0>
      }
      
      rotate z*Ang1
      rotate -y*Ang2
      translate sPoint
    }
    #local midp=vrotate(vrotate(<x1,y1,0>/2, z*Ang1), -y*Ang2) + sPoint;
    sphere { sPoint+y*.75, .12 }
    cylinder { sPoint+y*.75, midp, .05 texture { Chrome } }
    #local vec=midp-(sPoint+y*.75);
    #local vec=.3*vec/vlength(vec)+sPoint+y*.75;
    cylinder { sPoint+y*.75, vec, .1 }
      
    texture { Metal }
  }
#end

#macro Light(Ang1, Ang2)
  union
  { union
    { difference
      { cylinder { <-.4,0,0><.4,0,0>, .3 }
        cylinder { <-.21,0,0><.41,0,0>, .2 }
      }
      cylinder { <.39,0,0><.4,0,0>,.2 no_shadow pigment { rgb 1 } finish { ambient 1 } }
      sphere { 0,.3 scale <.5,1,1> translate -x*.4 }
      torus { .25, .05 rotate z*90 translate x*.4 }
      #if(LightsOn)
        light_source
        { x*.2, 1 spotlight point_at x radius 25 falloff 30
          fade_distance 10 fade_power 2
        }
      #end
      translate -z*.4
      rotate z*Ang1 rotate y*Ang2
      translate z*.4
    }
    sphere { <0,0,.3>,.15 }
    cylinder { <0,0,.3><0,0,.8>,.1 texture { Chrome } }
    cylinder { z*.6, z*.8, .2 }
    translate -z*.8
    scale .75
  }
#end

#macro Robot(Leg1Pos, Leg2Pos, Leg3Pos, leg4Pos)
  #local Body=
    union
    { superellipsoid { <.1,.1> translate y scale <1,.5,1> }
      #local Ind=-.8;
      #while(Ind<1)
        sphere { 0,.04 scale <1,1,.5> translate <Ind,.85,-1> }
        sphere { 0,.04 scale <1,1,.5> translate <Ind,.15,-1> }
        sphere { 0,.04 scale <1,1,.5> translate <Ind,.85,1> }
        sphere { 0,.04 scale <1,1,.5> translate <Ind,.15,1> }
        sphere { 0,.04 scale <.5,1,1> translate <-1,.85,Ind> }
        sphere { 0,.04 scale <.5,1,1> translate <-1,.15,Ind> }
        sphere { 0,.04 scale <.5,1,1> translate <1,.85,Ind> }
        sphere { 0,.04 scale <.5,1,1> translate <1,.15,Ind> }
        #local Ind=Ind+.2;
      #end
      #local Ind=.35;
      #while(Ind<.8)
        sphere { 0,.04 scale <1,1,.5> translate <-.8,Ind,-1> }
        sphere { 0,.04 scale <1,1,.5> translate <.8,Ind,-1> }
        sphere { 0,.04 scale <1,1,.5> translate <-.8,Ind,1> }
        sphere { 0,.04 scale <1,1,.5> translate <.8,Ind,1> }
        sphere { 0,.04 scale <.5,1,1> translate <1,Ind,-.8> }
        sphere { 0,.04 scale <.5,1,1> translate <1,Ind,.8> }
        sphere { 0,.04 scale <.5,1,1> translate <-1,Ind,-.8> }
        sphere { 0,.04 scale <.5,1,1> translate <-1,Ind,.8> }
        #local Ind=Ind+(.85-.15)/4;
      #end
      intersection
      { box { <0,0,-1><1,2,1> rotate z*-60 translate -x }
        box { <0,0,-1><-1,2,1> rotate z*60 translate x }
        box { <-1,0,0><1,2,1> rotate x*60 translate -z }
        box { <-1,0,0><1,2,-1> rotate -x*60 translate z }
        box { <-1,0,-1><1,.25,1> }
        scale .95
        translate y*.95
      }
      object
      { Light(-10,-30) scale 1/.95
        translate <.5,.25> rotate x*60 translate -z scale.95 translate y*.95
      }
      object
      { Light(-10,-30) scale 1/.95
        translate <.5,.25> rotate x*60 translate -z scale.95 translate y*.95
        scale <1,1,-1>
      }
      cone { y,.05,y*3,.01 }
      sphere { y*3,.05 }
      sphere { <-.4,1.1,-.4>, .2 }
      sphere { <-.4,1.1,.4>, .2 }
      sphere { <.4,1.1,-.4>, .2 }
      sphere { <.4,1.1,.4>, .2 }
      texture { Metal }
    }
  
  #ifndef(BodyPosOffset) #local BodyPosOffset=0; #end
  #declare BodyPos=(Leg1Pos+Leg2Pos+Leg3Pos+Leg4Pos)/4+y*1.5 + BodyPosOffset;
  
  union
  { object { Body translate BodyPos }
    Leg(BodyPos+<1,0,1>, Leg1Pos)
    Leg(BodyPos+<-1,0,1>, Leg2Pos)
    Leg(BodyPos+<1,0,-1>, Leg3Pos)
    Leg(BodyPos+<-1,0,-1>, Leg4Pos)
  }
#end

//===========================================================================
// Heighfield calculation
//===========================================================================
#if(Scene>=2)
  #declare wr=seed(20);
  #declare Buildings=array[10]
  #declare ind=0;
  #while(ind<10)
    #declare Buildings[ind]=
      union
      { #local indX=-.3;
        #while(indX<.3)
          #local indY=0;
          #while(indY<.95)
            box
            { <indX, indY, -.30001><indX+.1, indY+.1, .30001>
              #if(rand(wr)<.2)
                pigment { rgb 1 } finish { ambient 1 reflection .3 }
              #else
                pigment { rgb .2 } finish { reflection .3 }
              #end
            }
            box
            { <-.30001, indY, indX><.30001, indY+.1, indX+.1>
              #if(rand(wr)<.2)
                pigment { rgb 1 } finish { ambient .5 reflection .3 }
              #else
                pigment { rgb .2 } finish { reflection .3 }
              #end
            }
            #local indY=indY+.1;
          #end
          #local indX=indX+.1;
        #end
        box { <-.3001,1.001,-.3001><.3001,.99,.3001> pigment { rgb .8 } }
        box { <-.4,0,-.4><.4,.02,.4> pigment { rgb .5 } }
        box
        { <-.5,0,-.5><.5,.01,.5>
          texture
          { pigment
            { gradient x color_map { [0 rgb 0][.98 rgb 0][.98 rgb 1][1 rgb 1] } }
            scale .5
          }
          texture
          { pigment
            { gradient z color_map { [0 rgbt 1][.98 rgbt 1][.98 rgb 1][1 rgb 1] } }
            scale .5
          }
        }
      }
    #declare ind=ind+1;
  #end
  
  #macro Building(xcoord, zcoord, height)
    object
    { Buildings[int(rand(wr)*9.9999)]
      scale <1,height,1>
      translate <xcoord,0,zcoord>
    }
  #end
  
  #declare Height=array[FieldLength][FieldWidth]
  #declare R=seed(0);
  #declare R2=seed(10);
  #declare Ind1=0;
  #while(Ind1<FieldLength)
    #declare Ind2=0;
    #declare xcoord=-2+4*Ind1/FieldLength;
    #while(Ind2<FieldWidth)
      #declare ycoord=-2+4*Ind2/FieldWidth;
      #declare heightfact=exp(-xcoord*xcoord-ycoord*ycoord);
      #declare Height[Ind1][Ind2] = Base +
        (MaxHeight-MaxHeightDiff)*heightfact + MaxHeightDiff*rand(R)*heightfact;
      #if(sqrt(xcoord*xcoord+ycoord*ycoord)+rand(R2) < 2.5)
        Building(Ind1, -FieldWidth/2+Ind2, Height[Ind1][Ind2])
      #end
      #declare Ind2=Ind2+1;
    #end
    #declare Ind1=Ind1+1;
  #end
  
  #macro HeightAt(vec)
    #local ind1=int(vec.x);
    #local ind2=int(vec.z+FieldWidth/2);
    #if (ind1>=0 & ind1<FieldLength & ind2>=0 & ind2<FieldWidth)
      #local retval=Height[ind1][ind2];
    #else
      #local retval=0;
    #end
    retval
  #end

#end

//===========================================================================
// Legs location
//===========================================================================
#if(Scene=1)
  #if(clock<=.9)
    #declare Clock=clock/.9;
    #declare YPos=0;
    #declare Leg1Pos=<1.5,YPos,1.5>;
    #declare Leg2Pos=<-1.5,YPos,1.5>;
    #declare Leg3Pos=<1.5,YPos,-1.5>;
    #declare Leg4Pos=<-1.5,YPos,-1.5>;
    #declare BodyPosOffset=<0,-1,0>;
  #else
    #declare Clock=(clock-.9)/.1;
    #declare lPos=1.5+.5*Clock;
    #declare Leg1Pos=<lPos,0,lPos>;
    #declare Leg2Pos=<-lPos,0,lPos>;
    #declare Leg3Pos=<lPos,0,-lPos>;
    #declare Leg4Pos=<-lPos,0,-lPos>;
    #declare BodyPosOffset=<0,-1+Clock,0>;
  #end
#end

#if(Scene=2)
  #if(clock<=.7)
    #declare Clock=clock/.7;
    #declare YPos=50-Clock*50;
    #declare Leg1Pos=<2,YPos,2>-x*3;
    #declare Leg2Pos=<-2,YPos,2>-x*3;
    #declare Leg3Pos=<2,YPos,-2>-x*3;
    #declare Leg4Pos=<-2,YPos,-2>-x*3;
  #else
    #declare Clock=(clock-.7)/.3;
    #declare Leg1Pos=<2,0,2>-x*3;
    #declare Leg2Pos=<-2,0,2>-x*3;
    #declare Leg3Pos=<2,0,-2>-x*3;
    #declare Leg4Pos=<-2,0,-2>-x*3;
    #if(Clock<.5)
      #declare BodyPosOffset=<0,-sin(Clock*pi),0>;
    #else
      #declare BodyPosOffset=<0,-1+(1-cos((Clock-.5)*2*pi))/2,0>;
    #end
  #end
#end

#if(Scene=3)
  #if(clock=0)
    #declare Leg1Pos=<2,0,2>-x*3;
    #declare Leg2Pos=<-2,0,2>-x*3;
    #declare Leg3Pos=<2,0,-2>-x*3;
    #declare Leg4Pos=<-2,0,-2>-x*3;
    #declare MovingLeg=0;
    #declare LegPos=0;
  #else
    #fopen inFile "Robot.dat" read
    #read(inFile,Leg1Pos)
    #read(inFile,Leg2Pos)
    #read(inFile,Leg3Pos)
    #read(inFile,Leg4Pos)
    #read(inFile,MovingLeg)
    #read(inFile,LegPos)
    #read(inFile,LegIPos)
    #read(inFile,LegFPos)
    #fclose inFile
  #end
#end

//===========================================================================
// Scene
//===========================================================================
#if(Scene=2)
  Robot(Leg1Pos,Leg2Pos,Leg3Pos,Leg4Pos)
  camera { ultra_wide_angle location <-.4,.1,-2> look_at <-2.2,2,0> angle 300 }
  #include "galaxy.sf"
#end
#if(Scene=3)
  Robot(Leg1Pos,Leg2Pos,Leg3Pos,Leg4Pos)
  camera
  { location -z*CameraDistance look_at 0 angle 35
    rotate x*CameraAngle1+y*CameraAngle2 translate <BodyPos.x, 1, BodyPos.z>
  }
#end

#if(Scene=1)
  #include "galaxy.sf"
  
  #declare Clock = (clock<.85 ? clock/.85 : 1);
  #declare Val = sin(Clock*pi/2);
  #declare UFOPos=<100-Val*300,20-Val*20,-Val*200>;
  #if(Clock>=.5)
    #declare Val = (1-cos(pi*(Clock-.5)/.5))/2;
    #declare UFOTilt = -90*Val;
  #else
    #declare UFOTilt = 0;
  #end
  
  #if(Clock<.5)
    #declare camera_location=<0,-2,-100>;
    #declare camera_look_at=UFOPos;
  #else
    #declare camera_location=<-Val*195,-2+20*Val,-100-80*Val>;
    #declare camera_look_at=UFOPos+z*Val*5;
  #end
  #declare camera_angle=45;
  #declare effect_type="Sun2"
  #declare effect_scale=1.5;
  #declare effect_location=x*1000+z*500;
  #include "lens.inc"
  
  light_source { effect_location, <1,.9,.7>*2 }

  #declare UFO =
    union
    { difference
      { sphere { 0,5 scale <1,.5,1> translate y*2.5 }
        sphere { 0,14 scale <1,.2,1> }
      }
      difference
      { sphere { 0,15 }
        sphere { 0,14 pigment { rgb 0 } }
        sphere { 0,15 scale <1,.5,1> translate -y*20 }
        scale <1,.2,1>
      }
      #declare PWidth=(clock>=.9 ? 6 : (clock>.8 & clock<.9 ? 6*(clock-.8)/.1 : .01) );
      difference
      { cylinder { -y*2.4,-y*1.5,7 }
        box { <-PWidth,-2.5,-7><PWidth,-1.4,7> }
      }
      #if(clock>.8)
        object
        { Robot(Leg1Pos,Leg2Pos,Leg3Pos,Leg4Pos)
          #if(clock>.85)
            translate -y*10*(clock-.8)/.2
          #end
        }
      #end
      pigment { rgb <.8,.6,.3> } finish { specular .2 }
      normal { granite .06 scale 1.5 }
    }
    
  object
  { UFO
    rotate x*UFOTilt
    translate UFOPos
  }
  sphere
  { 0,1000
    pigment
    { image_map { gif "Earth.gif" map_type 1 interpolate 2 } rotate y*120-z*20
    }
    translate -x*4000
  }
#end

#if(Scene>=2)

  light_source
  { <100,200,-150> <.3,.5,1>
    area_light (x+z)*17, y*17, 10, 10 adaptive 0
  }
  
  fog
  { fog_type 2 distance 50 rgb <.7,.8,.9>
    fog_alt 2
  }
  
  #declare Ground =
    texture
    { pigment { rgb <.8,.4,.1> }
      normal { granite .5 scale 2 }
    }
  #declare Forest =  
    texture
    { pigment { rgb <0,.7,0> }
      normal { granite .5 scale .25 }
    }
  #declare Water =  
    texture
    { pigment { rgb <.1,.3,.4> }
      finish { reflection .5 specular .5 }
      normal { bumps .2 scale .025/2 phase clock*2 }
    }
  
  plane { y,0 no_shadow texture { Ground } }
  plane
  { y,.00002 no_shadow
    texture
    { gradient z texture_map
      { [0 pigment { rgbt 1 }][.8 pigment { rgbt 1 }]
        [.8 Water][1 Water]
      }
      turbulence 1
      scale 20
    }
  }
  plane
  { y,.00001 no_shadow
    texture
    { bozo texture_map
      { [0 pigment { rgbt 1 }][.6 pigment { rgbt 1 }]
        [.6 Forest][1 Forest]
      }
      turbulence 1
      scale 5
    }
  }

#end

//===========================================================================
// Legs new locations calculation
//===========================================================================
#if(Scene=3)
  #if(LegPos=0)
    #switch(MovingLeg)
      #case(0) #declare LegIPos = Leg1Pos; #break
      #case(1) #declare LegIPos = Leg4Pos; #break
      #case(2) #declare LegIPos = Leg3Pos; #break
      #case(3) #declare LegIPos = Leg2Pos; #break
    #end
    #declare LegFPos=LegIPos+x*2;
    #declare LegFPos=<LegFPos.x, HeightAt(LegFPos), LegFPos.z>;
  #end
  #declare LegPos=LegPos+1;
  
  #declare LegNewPos = LegIPos*(1-LegPos/LegAngleSteps) + LegFPos*LegPos/LegAngleSteps +
                       y*sin(pi*LegPos/LegAngleSteps);
  
  #switch(MovingLeg)
    #case(0) #declare Leg1Pos = LegNewPos; #break
    #case(1) #declare Leg4Pos = LegNewPos; #break
    #case(2) #declare Leg3Pos = LegNewPos; #break
    #case(3) #declare Leg2Pos = LegNewPos; #break
  #end
  
  #if(LegPos=LegAngleSteps)
    #declare LegPos=0;
    #declare MovingLeg=MovingLeg+1;
    #if(MovingLeg=4) #declare MovingLeg=0; #end
  #end
  
  #fopen oFile "Robot.dat" write
  #write(oFile, Leg1Pos, ",", Leg2Pos, ",", Leg3Pos, ",", Leg4Pos, ",\n")
  #write(oFile, MovingLeg, ",", LegPos, ",\n")
  #write(oFile, LegIPos, ",", LegFPos)

#end
