/******************************************************************************************

  struct-Definitionen fr Listen

******************************************************************************************/

// Liste, die die Werte des INI-Files speichert
// (Namen der keyframe-files, Anzahl frames 
//  zwischen den Keyframes)
struct ini_list_struct
{
	char *keyframe;
	int frames;
	struct ini_list_struct *next;
};

// zweidimensionale Liste zum Speichern der Animationswerte
//
// einfach verkettete Liste enthlt double-arrays
// ein array enthlt die Werte eines AnimationValues aller keyframes
struct values_struct
{
	double *value_array;	// pointer to array of animation values
	struct values_struct *next; 	
};


// step 1 struct, store values found in a list
struct pos_of_numbers
{
	unsigned long line;  	// line number
	unsigned long number;	// value number xx in this line
					// values are numerated
	struct pos_of_number *next;
};

/******************************************************************************************

  Funktionen zum verwalten der Listen

******************************************************************************************/

/*******************************************************

  1. Liste fr Positionen der animationsrelevanten
     Werte

     value_exists, addvalue, delelte_value, 
     sort_values, count_list, print_list
     
*******************************************************/

// returns TRUE, if the given line/number exists, otherwise FALSE
int value_exists(struct pos_of_numbers *start, unsigned long line, unsigned long number)
{
	struct pos_of_numbers *run;
	
	run = start;
	while (run != NULL) 
	{
		if ((run->line == line) && (run->number == number)) return ( TRUE );
		else run = run->next;
	}
	return( FALSE );
}

// step 1 function: add value to value list
struct pos_of_numbers* add_value(struct pos_of_numbers *start, unsigned long line, unsigned long number)
{
	struct pos_of_numbers *run;
    struct pos_of_numbers *new;	
    
    new = (struct pos_of_numbers *)malloc (sizeof(struct pos_of_numbers));
    if (new == NULL)
    {
    	printf("\nERROR: out of memory!\nterminated.\n");
    	exit(1);
    }
    
    if (start == NULL)
    {
    	start = new;
    }
    else
    {	
    	run = start;
    	while (run->next != NULL)
    	{
    		//printf("\n line: %d", run->line);
    		//printf("\n number: %d", run->number);
    		//printf("\n ----");
    		run = (struct pos_of_numbers *)run->next;
    	}
    	run->next = new;

    }
	new->line = line;
	new->number = number;
	new->next = NULL;    
    
	return( start );
}

// delete one value from list
struct pos_of_numbers* delete_value(struct pos_of_numbers *list, struct pos_of_numbers *del)
{
	struct pos_of_numbers *run;
	
	if (del == list)
	{
		run = (struct pos_of_numbers*)list->next;
		free(del);
		return (run);
	}
	
	run = list;
	while ((run->next != del) && (run != NULL))
		run = run->next;
	
	if (run->next != NULL) 
	{
		run->next = del->next;
		free(del);
	}
	return( list );
}

// sortiert Positions-Liste aufsteigend
struct pos_of_numbers* sort_values(struct pos_of_numbers *list)
{
	struct pos_of_numbers *start = NULL;	// neue, sortierte Liste
    struct pos_of_numbers *run;	
    struct pos_of_numbers *act_pos;		// aktuelle Position auf alter Liste
	    
	if (list == NULL) return( NULL );
	
	while (list != NULL)
	{
		run = list;
		act_pos = run;

		run = run->next;
		
		while (run != NULL)
		{
			if (run->line < act_pos->line) 
			{
				act_pos = run;
			}	
			else 
				if (run->line == act_pos->line)
					if (run->number < act_pos->number)
						act_pos = run;
			run = run->next;
		}
		
		start = add_value(start, act_pos->line, act_pos->number);
		list = delete_value(list, act_pos);
	}	
	return( start );
}

// return value: Anzahl Elemente
int count_list(struct pos_of_numbers *start)
{
	int count = 0;
	
	while (start != NULL)
	{
		start = (struct pos_of_numbers *)start->next;
		count++;
	}
	return( count );
}


// Ausgabe der einfach verknpften Liste
// return value: Anzahl Elemente
int print_list(struct pos_of_numbers *start)
{
	int count = 0;
	
	while (start != NULL)
	{
		printf("\n%3i) line: %5lu  number: %5lu",count+1, start->line+1, start->number+1);
		start = (struct pos_of_numbers *)start->next;
		count++;
	}
	return( count );
}

/*******************************************************

  2. Array fr Animationswerte

     init_value_array, set_value, get_value
     
*******************************************************/

// erstellt ein leeres AnimationValue-Array
// (belegt den Speicher fr Listenknoten und 
//  eindimensionale arrays)
// return value: Zeiger auf den Anfang der Liste
struct values_struct *init_value_array(long value_count, long file_count)
{
	struct values_struct *start = NULL;
	struct values_struct *new;
	
	double *array;
	long n; // Zhlt Anzahl der Listenknoten = Anzahl der Animationswerte
	
	for (n = 0; n < value_count; n++)
	{
		// Speicher fr Listenknoten allokieren
		new = (struct values_struct *)malloc(sizeof(struct values_struct));
	    if (new == NULL)
	    {
	    	printf("\nERROR: out of memory!\nterminated.\n");
	    	exit(1);
	    }
	    
		// Speicher fr eindimensionales array allokieren
	    array = (double *)malloc((size_t)(file_count * sizeof(double)));
	    if (array == NULL)
	    {
	    	printf("\nERROR: out of memory!\nterminated.\n");
	    	exit(1);
	    }
		new->value_array = (double *)array;	    

		// Liste verketten (neuen Listenknoten vorne einfgen)
		new->next = start;
		start = new;
	}
	
	return (start);
}

// returns TRUE if value, was succesfully set
// otherwise FALSE (--> out of range!)
int set_value(struct values_struct *start, double value, int value_number, int file_number)
{
	struct values_struct *run = start;	
	int value_count = 0;

	// zu dem der value_number entsprechendem array gehen
	while ((run != NULL) && (value_count < value_number))			
	{
		run = run->next;
		value_count++;
	}	
	
	// Wert setzen
	if (run != NULL)
	{
		run->value_array[file_number] = value;
		return( TRUE );
	}
	else return( FALSE );
}

// returns the value on the given position
// if out of range -98765.4321 is returned
double get_value(struct values_struct *start, int value_number, int file_number)
{
	struct values_struct *run = start;	
	int value_count = 0;

	// zu dem der value_number entsprechendem array gehen
	while ((run != NULL) && (value_count < value_number))			
	{
		run = run->next;
		value_count++;
	}	
	
	// Wert holen
	if (run != NULL)
		return( run->value_array[file_number] );
	else 
		return( -98765.4321 );
}

/*******************************************************

  3. Liste fr Inhalt der INI-Files
     (Namen der keyframe-files, Anzahl frames 
      zwischen den Keyframes)

	 read_ini_file     
	 
*******************************************************/
/*
struct ini_list_struct
{
	char *keyframe;
	int frames;
	struct ini_list_struct *next;
};
*/

struct ini_list_struct *read_ini_file(char *filename, int *count)
{
	struct ini_list_struct *new;
	struct ini_list_struct *start = NULL;
	struct ini_list_struct *run;

    FILE *fp;
	char str[LINE_LEN];
	char *ptr;
	int line_count = 0;
	int keyframe_count = 0;
	int reached_last_line = FALSE;
	int no_more_keyframes = FALSE;
	int read_keyframe_name = TRUE;
	int ignore_line;
	     
    if( (fp = fopen( filename, "r" )) == NULL )
    {
    	printf("ERROR: could not open input file: %s", filename);
    	printf("\nterminated.");
    	exit(1);
    }               

	while (fgets(str, LINE_LEN-1, fp) != NULL)
	{
		ignore_line = FALSE;
        str[strlen(str)-1] = 0; // fgets reads always the line feed, delete it
		line_count++;
        
        // check for comment '//'
        ptr = strchr(str, '/');
        if (ptr != NULL)
        	if (*(ptr+1) == '/')
        		*ptr = '\0';  // set end of line to start of comment
		
		// ignore_line if it starts with space or with '//' or if it's empty (starting with '\n' or '\0')
		if ((isspace(str[0])) || (str[0] == '\n') || (str[0] == '\0'))
			ignore_line = TRUE;
					
		if (! ignore_line)
		{
			// read name of keyframe file
			if (read_keyframe_name)
			{
				keyframe_count++;
				read_keyframe_name = FALSE;

				// Add new list element
			    new = (struct ini_list_struct *)malloc (sizeof(struct ini_list_struct));
			    if (new == NULL)
			    {
			    	printf("\nERROR: out of memory!\nterminated.\n");
			    	exit(1);
			    }
			    if (start == NULL)
			    {
			    	start = new;
			    }
			    else
			    {	
			    	run = start;
			    	while (run->next != NULL)
			    	{
			    		//printf("\n line: %d", run->line);
			    		//printf("\n number: %d", run->number);
			    		//printf("\n ----");
			    		run = (struct ini_list_struct *)run->next;
			    	}
			    	run->next = new;
			
			    }
				new->next = NULL;    
				
				// save keyframe name to list		
			    new->keyframe = (char *)malloc (strlen(str)+1);
			    if (new->keyframe == NULL)
			    {
			    	printf("\nERROR: out of memory!\nterminated.\n");
			    	exit(1);
			    }
		        strcpy(new->keyframe, str);
		        //printf("\nkeyframe:  %s", new->keyframe);
		        //getch();
			}

			// read number of frames between keyframes
			else
			{
				new->frames = atoi(str);
				read_keyframe_name = TRUE;
		        //printf("\n# between: %i", new->frames);
		        //getch();
			}
		}
	}
	if (keyframe_count < 2)            	
	{
		printf("\nERROR: need at least 2 keyframes to do an animation\nterminated.\n");
		exit(1);
	}	
	if (read_keyframe_name == TRUE)
	{
		printf("\nWARNING: ini file should finish with name of keyframe file\n");
		printf("\n         last number will be ignored.\n");
	}

	*count = keyframe_count;
	return( start );
}	
/*
		// read name of keyframe file
		if (fgets(str, LINE_LEN-1, fp) == NULL)
		{
			if (keyframe_count == 0)
			{
				printf("\nERROR: no data in input file %s\nterminated.\n", filename);
				exit(1);
			}	
			if (keyframe_count < 2)
			{
				printf("\nERROR: need at least 2 keyframes to do an animation\nterminated.\n");
				exit(1);
			}
			reached_last_line = TRUE;
			no_more_keyframes = TRUE;
		}
		if (isspace(str[0]))
		{
			reached_last_line = TRUE;
			no_more_keyframes = TRUE;
		}
		else
		{
			str[strlen(str)-1] = 0; // fgets reads always the line feed, delete it
			line_count++;
			keyframe_count++;
//			printf("\nkeyframe: %s", str);
//			getch();
		}	
		
		// read number of frames between keyframes
		if (!reached_last_line)
		{
			if (fgets(frames, LINE_LEN-1, fp) == NULL)
			{
				if (keyframe_count < 2)            	
				{
					printf("\nERROR: need at least 2 keyframes to do an animation\nterminated.\n");
					exit(1);
				}	
				reached_last_line = TRUE;
				strcpy(frames, "000");
			}	
			if (isspace(frames[0]))
			{
				reached_last_line = TRUE;
				strcpy(frames, "000");
			}
			else
			{
				frames[strlen(frames)-1] = 0; // fgets reads always the line feed, delete it
				line_count++;
//				printf("\nframes: %s", frames);
//				getch();
			}	
		}
		
		if (!no_more_keyframes)
		{
	        
		}
	}
	//printf("\nfound %i kryframes", keyframe_count);
	//getch();
*/

// Errechnet Gesamtzahl der frames (keyframes + frames between)
long count_frames(struct ini_list_struct *ini_list)
{
	long count = 0;
	struct ini_list_struct *run = ini_list;
	
	while (run != NULL)
	{
		count++;
		if (run->next != NULL)
			count = count + run->frames;       	
		run = run->next;	
	}
	
	return( count );
}




