//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 4 lights, 27 materials and 450 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 05/20/2000    (20.05.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from XRedBulb.mdl:
This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

//
// *******  V A R I A B L E S *******
//                           

#declare duration = 6;
#declare start_time = 10;
#declare secs = start_time + (clock * duration);
#declare R1 = seed(75);

//
// *******  M A C R O S *******
//                     

#include "MyMacros.inc"

//
// *******  C A M E R A S *******
//                     

camera {  //  Camera StdCam
  #declare times = array [5] {12.5,13.1,13.7,14.3,14.9}
  #declare locations = array[5] {<0,-550,110>,<25,-400,110>,<25,-200,110>,<15,-50,150>,<0,50,150>}
  #declare starts = array[2] {10,14.9}
  #declare ends = array[2] {12.5,16}
  #declare positions = array[2] {<0,-550,110>,<0,50,150>}
  #declare MyLocation = (Bezier(times,locations,secs) + Position(starts,ends,positions,secs));
  location MyLocation
  #debug concat("Camera Location is:","\t",str(MyLocation.x,5,0),"\t",str(MyLocation.y,5,0),"\t",str(MyLocation.z,5,0),"\n")  
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,      100.000>
  #declare times = array [4] {12.5,13.1,14.9,16}
  #declare locations = array[4] {<0,0,100>,<100,150,100>,<100,150,100>,<0,150,0>}
  #declare starts = array[1] {10}
  #declare ends = array[1] {12.5}
  #declare positions = array[1] {<0,0,100>}
  #declare MyLookAt = (Bezier2(times,locations,locations,secs) + Position(starts,ends,positions,secs));
  look_at MyLookAt
  #debug concat("Camera Look_at is:","\t",str(MyLookAt.x,5,0),"\t",str(MyLookAt.y,5,0),"\t",str(MyLookAt.z,5,0),"\n")  
}

//
// *******  L I G H T S *******
//

#declare Arealight004 = light_source {   // Arealight Arealight004
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.1000, 0.1000>
//  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
//  adaptive 2
  fade_distance  300.0
  fade_power 3.0
  media_interaction off
  scale 0.5
}


light_source {   // Arealight Arealight003
  <0.0, 0.0, 0.0>
  color rgb <0.500, 0.500, 0.600>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 5, 5
  adaptive 0
  media_interaction off
  scale 10000.0
  rotate 45.0*x
  translate  <0.0, -30000.0, 30000.0>
}


#declare Arealight001 = light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.000, 0.000>*2.0000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 2, 2
  adaptive 1
  fade_distance  200.0
  fade_power 5.0
  media_interaction off
  translate  286.0*z
}


#declare Arealight002 = light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.900>
  area_light <0.100, 0.000, 0.000>, <0.000, 2.000, 0.000>, 1, 7
  adaptive 1
  fade_distance  1000.0
  fade_power 2.0
  media_interaction off
  scale <0.5, 3.0, 1.0>
  rotate <0.0, -45.0, -0.0>
}



//
// ********  MATERIALS  *******
//

#include "xenter.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

#declare Blob_Snow = blob {
  threshold 0.5
  sphere { // Sphere026
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <-2.75, 0.25, 0.0>
  }
  sphere { // Sphere027
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <0.25, 2.25, 0.0>
  }
  sphere { // Sphere028
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <2.75, 0.5, 0.0>
  }
  sphere { // Ground
    <0,0,0>,1,1
    scale <2,2,2>
    scale <100.0, 100.0, 1.0>
    translate  -1.2*z
  }
  sphere { // Sphere029
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.25, 0.25, 0.0>
  }
  sphere { // Sphere030
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.5, 1.5, 0.0>
  }
  sphere { // Sphere031
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.5, 1.25, 0.0>
  }
  sphere { // Sphere032
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.5, -1.0, -0.5>
  }
  sphere { // Sphere033
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.25, -1.25, -0.5>
  }
  sphere { // Sphere034
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-2.5, 2.5, -0.5>
  }
  sphere { // Sphere035
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <3.0, 3.0, -0.5>
  }
  sphere { // Sphere036
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <0.0, 4.0, 0.5>
  }
  sphere { // Sphere037
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-1.75, 1.5, 0.5>
  }
  sphere { // Sphere038
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <2.0, 1.25, 0.5>
  }
  sphere { // Sphere039
    <0,0,0>,1,1
    scale <2,2,2>
    scale <1.0, 0.5, 0.5>
    rotate -55.0*z
    translate  <-1.0, 1.75, 0.25>
  }
  sphere { // Sphere040
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.75, -0.75, -0.5>
  }
  sphere { // Sphere041
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <1.0, -2.25, -0.75>
  }
  sphere { // Sphere042
    <0,0,0>,1,1
    scale <2,2,2>
    scale 0.5
    translate  <-2.5, -1.25, -0.75>
  }
  sphere { // Sphere043
    <0,0,0>,1,1
    scale <2,2,2>
    scale <1.0, 1.0, 0.5>
    translate  <0.25, 1.75, 0.75>
  }
  sphere { // Sphere044
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 2.0>
    translate  <-15.5, -11.0, -1.0>
  }
  sphere { // Sphere045
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-14.5, 8.5, -3.25>
  }
  sphere { // Sphere046
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-22.0, 0.0, -1.0>
  }
  sphere { // Sphere047
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-7.0, -1.0, -0.5>
  }
  sphere { // Sphere048
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 2.0>
    translate  <8.5, 15.0, -1.5>
  }
  sphere { // Sphere049
    <0,0,0>,1,1
    scale <2,2,2>
    scale <7.5, 7.5, 5.0>
    translate  <-8.0, 16.25, -1.0>
  }
  sphere { // Sphere050
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-3.5, 9.25, -1.25>
  }
  sphere { // Sphere051
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-12.0, -33.25, -1.0>
  }
  sphere { // Sphere052
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <28.0, 15.5, -1.0>
  }
  sphere { // Sphere053
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <39.0, -10.0, -1.0>
  }
  sphere { // Sphere054
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <22.25, -6.5, -4.5>
  }
  sphere { // Sphere055
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-1.0, -25.5, -3.0>
  }
  sphere { // Sphere056
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <53.5, -24.0, -4.5>
  }
  sphere { // Sphere057
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <42.5, -48.0, -3.0>
  }
  sphere { // Sphere058
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <20.25, -46.0, -1.0>
  }
  sphere { // Sphere059
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-28.75, -15.75, -3.0>
  }
  sphere { // Sphere060
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <7.0, 28.25, -3.0>
  }
  sphere { // Sphere061
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-8.25, 36.75, -1.25>
  }
  sphere { // Sphere062
    <0,0,0>,1,1
    scale <2,2,2>
    scale <15.0, 15.0, 5.0>
    translate  <-33.25, 21.5, -1.25>
  }
  sphere { // Sphere063
    <0,0,0>,1,1
    scale <2,2,2>
    scale 2.0
    translate  <-4.75, -10.75, -1.5>
  }
  sphere { // Sphere064
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <-6.5, -6.0, -0.75>
  }
  sphere { // Sphere065
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <10.0, 3.75, -1.25>
  }
  sphere { // Sphere066
    <0,0,0>,1,1
    scale <2,2,2>
    scale <5.0, 5.0, 1.0>
    translate  <7.5, -12.25, -1.5>
  }
  sphere { // Sphere067
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <9.0, -1.0, -1.25>
  }
  sphere { // Sphere068
    <0,0,0>,1,1
    scale <2,2,2>
    scale <2.5, 2.5, 1.0>
    translate  <8.0, 2.5, -1.25>
  }
  sphere { // Sphere069
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <5.75, 1.0, -0.5>
  }
  sphere { // Sphere070
    <0,0,0>,1,1
    scale <2,2,2>
    translate  <-4.25, -1.0, -1.0>
  }
  sphere { // Sphere071
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.5, 0.2, 0.05>
    rotate -15.0*z
    translate  <0.25, -0.15, 1.0>
  }
  sphere { // Sphere072
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.5, 0.3, 0.075>
    translate  <0.0, 0.25, 1.0>
  }
  sphere { // Sphere073
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.25, 0.1, 0.025>
    translate  <-0.5, -0.25, 1.0>
  }
  sphere { // Sphere074
    <0,0,0>,1,1
    scale <2,2,2>
    scale <0.3, 0.3, 0.075>
    translate  <0.0, 0.75, 1.0>
  }
  material {
    Snow
  }
  scale 250.0
  translate  -20.0*z
}
difference { // CSG090
  object { Blob_Snow }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    material {
      Snow
    }
    scale <200.0, 150.0, 500.0>
    translate  <0.0, 50.0, -285.0>
  }
}


#declare Pillars = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-100.0, 200.0, 100.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <0.0, 200.0, 100.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <100.0, 200.0, 100.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Beams = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, 200.0, -15.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Walls = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 12.0, 127.0>
    translate  <0.0, 200.0, 100.0>
  }
  material {
    Aluminum
  }
}
#declare Floor = difference {
  box { // Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <230.0, 180.0, 12.0>
    translate  <0.0, 50.0, -30.0>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 80.0, 20.0>
    translate  <0.0, 90.0, -30.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG007 = difference {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG008 = intersection {
  object { CSG007 }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
}
#declare CSG005 = difference {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG006 = intersection {
  object { CSG005 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate 180.0*z
}
#declare CSG004 = difference {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG009 = intersection {
  object { CSG004 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate -90.0*z
}
#declare CSG010 = difference {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG011 = intersection {
  object { CSG010 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate 90.0*z
}
#declare Poles = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <-50.0, -100.0, 0.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <50.0, -100.0, 0.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <50.0, 100.0, 0.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <-50.0, 100.0, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  -100.0*x
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  100.0*x
  }
  material {
    T_Chrome_2E
  }
}
#declare Joints = union {
  sphere { // Sphere010
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, -100.0, 120.0>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale 3.0
    translate  <50.0, -100.0, 120.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale 3.0
    translate  <50.0, 100.0, 120.0>
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, 100.0, 120.0>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, 0.0, 120.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 3.0
    translate  <100.0, 0.0, 120.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, -100.0, 120.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 3.0
    translate  <100.0, -100.0, 120.0>
  }
  sphere { // Sphere011
    <0,0,0>,1
    scale 3.0
    translate  <100.0, 100.0, 120.0>
  }
  sphere { // Sphere012
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, 100.0, 120.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare Rails = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <50.0, 100.0, 120.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <50.0, -100.0, 120.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-100.0, -100.0, 120.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-100.0, 100.0, 120.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 200.0>
    rotate 90.0*x
    translate  <100.0, 100.0, 120.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 200.0>
    rotate 90.0*x
    translate  <-100.0, 100.0, 120.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare ElevatorSuround = union {
  object { CSG008 }
  object { CSG006 }
  object { CSG009 }
  object { CSG011 }
  object { Poles }
  object { Joints }
  object { Rails }
  material {
    Metal
  }
  scale 0.75
  translate  <0.0, 90.0, -25.0>
}
#declare Base = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <81.0, 81.0, 10.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <85.0, 85.0, 2.5>
    translate  10.0*z
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <85.0, 85.0, 2.5>
    translate  -10.0*z
  }
  material {
    Metal
  }
}
#declare CSG012 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
}
#declare CSG013 = difference {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate -90.0*z
}
#declare CSG014 = difference {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate 180.0*z
}
#declare CSG015 = difference {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate 90.0*z
}
#declare CSG016 = difference {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -90.0*z
}
#declare CSG017 = difference {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -180.0*z
}
#declare CSG018 = difference {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -270.0*z
}
#declare CSG019 = difference {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
}
#declare Walls1 = union {
  object { CSG012 }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-70.0, 70.0, 40.0>
  }
  object { CSG013 }
  object { CSG014 }
  object { CSG015 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <70.0, 70.0, 40.0>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <70.0, -70.0, 40.0>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-70.0, -70.0, 40.0>
  }
  object { CSG016 }
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
}
#declare Rails1 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-70.0, 50.0, 0.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <70.0, 50.0, 0.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-50.0, 70.0, 0.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-70.0, -50.0, 0.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <50.0, -70.0, 0.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <50.0, 70.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-50.0, -70.0, 0.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <70.0, -50.0, 0.0>
  }
  sphere { // Sphere013
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, 70.0, 100.0>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale 3.0
    translate  <70.0, 70.0, 100.0>
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale 3.0
    translate  <70.0, -70.0, 100.0>
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, -70.0, 100.0>
  }
  sphere { // Sphere017
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, 50.0, 100.0>
  }
  sphere { // Sphere018
    <0,0,0>,1
    scale 3.0
    translate  <50.0, 70.0, 100.0>
  }
  sphere { // Sphere019
    <0,0,0>,1
    scale 3.0
    translate  <70.0, -50.0, 100.0>
  }
  sphere { // Sphere020
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, -70.0, 100.0>
  }
  sphere { // Sphere021
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, 70.0, 100.0>
  }
  sphere { // Sphere022
    <0,0,0>,1
    scale 3.0
    translate  <70.0, 50.0, 100.0>
  }
  sphere { // Sphere023
    <0,0,0>,1
    scale 3.0
    translate  <50.0, -70.0, 100.0>
  }
  sphere { // Sphere024
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, -50.0, 100.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*x
    translate  <70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <-90.0, -0.0, 0.0>
    translate  <70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -180.0>
    translate  <-70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*x
    translate  <-70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -270.0>
    translate  <-70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -270.0>
    translate  <-70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, 270.0>
    translate  <70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -90.0>
    translate  <70.0, -70.0, 100.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare Elevator = union {
  object { Base }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 1000.0>
    rotate <-0.0, -180.0, -0.0>
  }
  object { Walls1 }
  object { Rails1 }
  material {
    T_Chrome_1B
  }
  scale 0.75
  translate  <0.0, 90.0, -25.0>
}
#declare CSG020 = union {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 3.5, 1.0>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <5.0, 3.0, 1.0>
    translate  0.25*z
  }
}
#declare CSG021 = difference {
  object { CSG020 }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 1.6, 1.0>
    translate  <2.0, 0.0, 1.0>
  }
}
#declare CSG022 = difference {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    translate  <4.0, 0.0, 0.75>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  <4.0, 0.0, 1.0>
  }
  translate  <-2.0, 0.0, -0.25>
}
#declare Switch = union {
  object { CSG021 }
  object { CSG022 }
  sphere { // Sphere025
    <0,0,0>,1
    scale <1.25, 1.25, 0.5>
#declare times = array[5] {10,14.7,14.8,14.9,16}
#declare locations = array[5] {<2.0, 0.0, 1.25>,<2.0, 0.0, 1.25>,<2,0,1>,<2.0, 0.0, 1.25>,<2.0, 0.0, 1.25>}
    translate  Linear(times,locations,secs)
  }
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <2.0, 0.0, 1.25>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 15)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  hollow
  rotate 45.0*x
  translate  20.0*z
}
#declare SwitchStand = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Rubber
    }
    scale <5.5, 3.5, 1.0>
    translate  1.0*z
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 10.0>
    translate  <3.0, 0.0, 10.0>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 10.0>
    translate  <-3.0, 0.0, 10.0>
  }
  object { Switch }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 3.0, 1.0>
    translate  1.25*z
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 10.0>
    translate  <3.0, 0.0, 10.0>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 10.0>
    translate  <-3.0, 0.0, 10.0>
  }
  material {
    T_Chrome_1A
  }
  hollow
  scale 2.0
  rotate <-90.0, 0.0, -180.0>
  translate  <100.0, 185.0, 100.0>
}
#declare CSG001 = union {
  torus { // Torus001
    1.75, 0.2  rotate -x*90
    rotate 90.0*x
    translate  -1.0*z
    no_shadow
  }
  torus { // Torus002
    1.75, 0.2  rotate -x*90
    rotate <90.0, 0.0, -90.0>
    translate  -1.0*z
    no_shadow
  }
  no_shadow
}
#declare CSG002 = difference {
  object { CSG001 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    no_shadow
  }
  no_shadow
}
#declare CSG003 = merge {
  sphere { // Sphere002
    <0,0,0>,1
    no_shadow
    scale 1.8
    translate  -1.0*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <1.8, 1.8, 3.0>
    translate  -1.0*z
  }
  no_shadow
}
#declare CSG091 = merge {
  sphere { // Sphere086
    <0,0,0>,1
    no_shadow
    scale 1.7
    translate  -1.0*z
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <1.7, 1.7, 3.0>
    translate  -1.0*z
  }
  no_shadow
}
#declare CSG092 = difference {
  object { CSG003 }
  object { CSG091 }
  material {
    Thin_Glass_2
  }
  no_shadow
}
#declare RedBulb = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <1.75, 0.0, -1.0>
    no_shadow
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <-1.75, 0.0, -1.0>
    no_shadow
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.75, -1.0>
    no_shadow
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <0.0, 1.75, -1.0>
    no_shadow
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.5>
    translate  2.0*z
  }
  cone { // Cone001
    <0,0,0>, 0.25, <0,0,1>, 0.5
    material {
      Black_Plastic
    }
    rotate <0.0, -180.0, -180.0>
    translate  2.0*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Bulb
    }
    no_shadow
  }
  object { CSG002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 0.5>
    translate  2.25*z
  }
  object { Arealight004 }
  object { CSG092 }
  material {
    T_Chrome_1A
  }
  scale 5.0
  translate  <0.0, 50.0, 189.0>
}
union { // Hut
  object { Pillars }
  object { Beams }
  object { Walls }
  object { Floor }
  object { ElevatorSuround }
  object { Elevator }
  object { SwitchStand }
  object { RedBulb }
  material {
    T_Chrome_1A
  }
  hollow
}




union { // Sky
  sphere { // Horizon
    <0,0,0>,1
    material {
      Snow
    }
    scale 12000.0
    translate  -12000.04*z
  }
  sphere { // LowCloud
    <0,0,0>,1
    material {
      T_Cloud2
    }
    no_shadow
    hollow
    scale 12020.0
    translate  -12000.04*z
  }
  sphere { // MediumCloud
    <0,0,0>,1
    material {
      Stormy_Cloud_Sky
    }
    no_shadow
    hollow
    scale 12050.0
    translate  -12000.04*z
  }
  sphere { // HighCloud
    <0,0,0>,1
    material {
      nimrod
    }
    no_shadow
    hollow
    scale 12070.0
    translate  -12000.04*z
  }
  no_shadow
  hollow
  scale 1000.0
}


#declare Pillars1 = union {
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-100.0, -100.0, 100.0>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 0.0, 100.0>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 100.0, 100.0>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 0.0, 100.0>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 100.0, 100.0>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 200.0, 100.0>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 200.0, 100.0>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, -100.0, 100.0>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, -100.0, 100.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Beams1 = union {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, 215.0>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, 200.0, 215.0>
  }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    translate  <200.0, 200.0, -15.0>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, -15.0>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, -15.0>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, -15.0>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, 215.0>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, 215.0>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale 15.0
    translate  <-200.0, 200.0, -15.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG023 = difference {
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 12.0, 127.0>
    translate  <0.0, -100.0, 100.0>
  }
  box { // Door_Spacer
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 20.0, 81.0>
    translate  <50.0, -100.0, 81.0>
  }
}
#declare CSG024 = difference {
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 167.0, 12.0>
    translate  <0.0, 50.0, -15.0>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 170.0, 30.0>
    translate  <0.0, 70.0, -15.0>
  }
}
#declare Walls2 = union {
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <200.0, 50.0, 100.0>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <-200.0, 50.0, 100.0>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 167.0, 12.0>
    translate  <0.0, 50.0, 215.0>
  }
  object { CSG023 }
  object { CSG024 }
  material {
    Aluminum
  }
}
#declare CSG025 = union {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
}
#declare CSG026 = difference {
  object { CSG025 }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
}
#declare CSG027 = intersection {
  object { CSG026 }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Door = union {
  object { CSG027 }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
#declare times = array[4] {11,13,14,16}
#declare locations = array[4] {<0,0,0>,<-95.5,0,0>,<-95.5,0,0>,<0,0,0>}
  translate  Linear(times,locations,secs)
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  material {
    T_Chrome_1A
  }
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG028 = union {
  object { TransSweep001 }
  object { TransSweep002 }
}
#declare CSG029 = difference {
  object { CSG028 }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Parts = union {
  object { CSG029 }
  material {
    Black_Rubber
  }
  // All transformations fixed
}
#declare Doorway = union {
  object { Door }
  object { Parts }
  material {
    T_Chrome_1A
  }
  translate  <50.0, -100.0, 0.0>
}
#declare Parts1 = union {
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 180.0>
    translate  240.0*z
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 90.0>
    translate  240.0*z
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, 0.0>
    translate  240.0*z
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 240.0>
    rotate <172.5, 7.5, -90.0>
    translate  240.0*z
  }
  sphere { // Sphere075
    <0,0,0>,1
    translate  240.0*z
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 45.0>
    translate  240.0*z
  }
  sphere { // Sphere076
    <0,0,0>,1
    material {
      Bulb
    }
    hollow
    scale 1.5
    translate  286.0*z
  }
  object { Arealight001 }
  sphere { // Glow
    <0,0,0>,1
    material {
      RedGlow
    }
    hollow
    scale 50.0
    translate  286.0*z
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  translate  5.0*z
}
#declare CSG030 = union {
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG031 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG032 = union {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG033 = union {
  object { CSG030 }
  object { CSG031 }
  object { CSG032 }
}
#declare CSG034 = union {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG035 = union {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG036 = union {
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG037 = union {
  object { CSG034 }
  object { CSG035 }
  object { CSG036 }
  scale 0.875
  translate  30.0*z
}
#declare CSG038 = union {
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG039 = union {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG040 = union {
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG041 = union {
  object { CSG038 }
  object { CSG039 }
  object { CSG040 }
  scale <0.765625, 0.76562, 0.76562>
  translate  56.25*z
}
#declare CSG042 = union {
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG043 = union {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG044 = union {
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG045 = union {
  object { CSG042 }
  object { CSG043 }
  object { CSG044 }
  scale <0.669925, 0.66992, 0.669917>
  translate  79.21875*z
}
#declare CSG046 = union {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG047 = union {
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG048 = union {
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG049 = union {
  object { CSG046 }
  object { CSG047 }
  object { CSG048 }
  scale <0.586185, 0.58618, 0.586177>
  translate  99.316406*z
}
#declare CSG050 = union {
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG051 = union {
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG052 = union {
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG053 = union {
  object { CSG050 }
  object { CSG051 }
  object { CSG052 }
  scale <0.512915, 0.51291, 0.512904>
  translate  116.901855*z
}
#declare CSG054 = union {
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG055 = union {
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG056 = union {
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG057 = union {
  object { CSG054 }
  object { CSG055 }
  object { CSG056 }
  scale <0.448801, 0.4488, 0.448794>
  translate  132.289123*z
}
#declare CSG058 = union {
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG059 = union {
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG060 = union {
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG061 = union {
  object { CSG058 }
  object { CSG059 }
  object { CSG060 }
  scale <0.392701, 0.3927, 0.392695>
  translate  145.752983*z
}
#declare CSG062 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG063 = union {
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG064 = union {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG065 = union {
  object { CSG062 }
  object { CSG063 }
  object { CSG064 }
  scale <0.343611, 0.34361, 0.343608>
  translate  157.533861*z
}
#declare CSG066 = union {
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG067 = union {
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG068 = union {
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG069 = union {
  object { CSG066 }
  object { CSG067 }
  object { CSG068 }
  scale <0.300661, 0.30066, 0.300654>
  translate  167.842129*z
}
#declare CSG070 = union {
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG071 = union {
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG072 = union {
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG073 = union {
  object { CSG070 }
  object { CSG071 }
  object { CSG072 }
  scale <0.263077, 0.26308, 0.263074>
  translate  176.861865*z
}
#declare CSG074 = union {
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG075 = union {
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG076 = union {
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG077 = union {
  object { CSG074 }
  object { CSG075 }
  object { CSG076 }
  scale <0.230187, 0.23019, 0.230188>
  translate  184.754134*z
}
#declare CSG078 = union {
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG079 = union {
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
}
#declare CSG080 = union {
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -0.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -90.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -180.682755>
    translate  5.0*z
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <13.340186, 29.440242, -0.455684>
    scale <1.0, 1.0, 65.0>
    rotate <3.859573, -64.179733, -270.682739>
    translate  5.0*z
  }
  scale <-1.0, 1.0, 1.0>
}
#declare CSG081 = union {
  object { CSG078 }
  object { CSG079 }
  object { CSG080 }
  scale <0.201411, 0.20141, 0.201408>
  translate  191.65987*z
}
#declare CSG082 = union {
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, 31.0, 4.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate 90.0*y
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <-90.0, 90.0, 0.0>
    translate  <-31.0, -31.0, 4.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 61.5>
    rotate <90.0, 90.0, 0.0>
    translate  <31.0, 31.0, 4.0>
  }
}
#declare CSG083 = union {
  object { CSG082 }
  scale <0.176232, 0.17623, 0.176228>
  translate  197.702388*z
}
#declare Struts = union {
  object { CSG033 }
  object { CSG037 }
  object { CSG041 }
  object { CSG045 }
  object { CSG049 }
  object { CSG053 }
  object { CSG057 }
  object { CSG061 }
  object { CSG065 }
  object { CSG069 }
  object { CSG073 }
  object { CSG077 }
  object { CSG081 }
  object { CSG083 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  translate  5.0*z
}
#declare CSG084 = difference {
  sphere { // Sphere077
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere078
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar = union {
  object { CSG084 }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere079
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Translation fixed
  translate  240.0*z
}
#declare CSG085 = difference {
  sphere { // Sphere080
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere081
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar1 = union {
  object { CSG085 }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere082
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-30.0 to   0.0)
  // Translation fixed
  rotate <-30.0, 0.0, -120.0>
  translate  240.0*z
}
#declare CSG086 = difference {
  sphere { // Sphere083
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere084
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar2 = union {
  object { CSG086 }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere085
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  // Scaling fixed
  // Rot X limited (-15.0 to   15.0)
  // Translation fixed
  rotate <15.0, 0.0, 120.0>
  translate  240.0*z
}
#declare Radars = union {
  object { Radar }
  object { Radar1 }
  object { Radar2 }
  material {
    T_Chrome_3E
  }
  // All transformations fixed
  translate  5.0*z
}
#declare Antenna = union {
  box { // Base1
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <40.0, 40.0, 5.0>
    translate  5.0*z
  }
  object { Parts1 }
  object { Struts }
  object { Radars }
  translate  <-140.0, -40.0, 225.0>
}
#declare CSG087 = difference {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    translate  <4.5, 0.1, -2.5>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <0.8, 2.0, 0.8>
    translate  <4.5, 0.25, -2.5>
  }
  material {
    Black_Rubber
  }
}
#declare CSG088 = union {
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <6.0, 1.0, 3.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-5.0, -1.0, 3.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <5.0, -1.0, -3.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <-5.0, -1.0, -3.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  <5.0, -1.0, 3.0>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <5.0, 1.0, 4.0>
  }
}
#declare CSG089 = difference {
  object { CSG088 }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale <1.0, 0.5, 1.0>
    translate  <4.0, 1.0, 2.0>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-3.5, 1.0, -2.5>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-2.0, 1.0, -2.5>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <-0.5, 1.0, -2.5>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <1.0, 1.0, -2.5>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    hollow
    scale 0.5
    translate  <2.5, 1.0, -2.5>
  }
  material {
    Aluminum
  }
}
#declare CardReader = union {
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <2.1, 0.35, 0.5>
    translate  <-1.75, 1.25, -0.5>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <2.0, 0.05, 1.5>
    translate  <-1.75, 1.5, 0.75>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 10.55)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale 0.5
    translate  <-3.5, 1.0, -2.5>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <6.5, 0.75, 4.5>
    translate  -0.25*y
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <2.0, 0.05, 1.5>
    translate  <-1.75, 1.25, 0.75>
  }
  object { CSG087 }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Galaxy
    }
    scale <0.9, 0.05, 0.9>
    translate  <4.5, 1.0, -2.5>
  }
  object { CSG089 }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 11)
      RedLight
#else
      Plexiglas
#end
    }
    hollow
    scale <1.0, 0.5, 1.0>
    translate  <4.0, 1.0, 2.0>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 10.65)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale 0.5
    translate  <-2.0, 1.0, -2.5>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 10.75)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale 0.5
    translate  <-0.5, 1.0, -2.5>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 10.85)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale 0.5
    translate  <1.0, 1.0, -2.5>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    material {
#if (secs < 10.95)
      Plexiglas
#else
      BlueLight
#end
    }
    hollow
    scale 0.5
    translate  <2.5, 1.0, -2.5>
  }
  scale <3.0, -3.0, 3.0>
  translate  <-50.0, -112.0, 115.0>
}
#declare SmallFluoro = union {
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      FluoroTube
    }
    hollow
    scale <1.0, 1.0, 10.0>
    rotate 90.0*x
    translate  5.0*y
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*x
    translate  <0.0, -4.0, 0.75>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate -90.0*x
    translate  <0.0, 4.0, 0.75>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 1.0>
    translate  1.75*z
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate -90.0*x
    translate  <0.0, 4.5, 0.75>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <0.0, -4.5, 0.75>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 6.5, 1.0>
    translate  1.75*z
  }
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass
    }
    scale <2.25, 2.25, 0.5>
    rotate -90.0*x
    translate  <0.0, 4.75, 0.75>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    material {
      Tinny_Brass
    }
    scale <2.25, 2.25, 0.5>
    rotate -90.0*x
    translate  <0.0, -5.25, 0.75>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 5.25, 0.25>
    translate  1.75*z
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 0.25, 1.125>
    translate  <0.0, -5.0, 1.875>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    material {
      Tinny_Brass
    }
    scale <2.25, 0.25, 1.125>
    translate  <0.0, 5.0, 1.875>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      Thin_Glass
    }
    hollow
    scale <1.9, 1.9, 10.0>
    rotate 90.0*x
    translate  <0.0, 5.0, 0.75>
  }
  object { Arealight002 }
  material {
    T_Chrome_1A
  }
  hollow
  scale 3.0
  rotate <90.0, -270.0, 180.0>
  translate  <50.0, -121.0, 193.0>
}
union { // Hut1
  object { Pillars1 }
  object { Beams1 }
  object { Walls2 }
  box { // Step
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_1A
    }
    scale <75.0, 20.0, 15.0>
    translate  <50.0, -125.0, -27.0>
  }
  object { Doorway }
  object { Antenna }
  object { CardReader }
  object { SmallFluoro }
  material {
    T_Chrome_1A
  }
  hollow
}


