//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 7 lights, 52 materials and 3471 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 06/26/2000    (26.06.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from XLoading.mdl:
This scene was created with Moray V3.2 For Windows.
Comment merged from XTransporter.mdl:
This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 3
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

//
// *******  V A R I A B L E S *******
//                           

#declare duration = 45;
#declare start_time = 16;
#declare secs = start_time + (clock * duration);
#declare R1 = seed(75);

//
// *******  M A C R O S *******
//                     

#include "MyMacros.inc"

//
// *******  A N I M A T I O N *******
//                     

  #declare times = array [7] {16,20,24,28,36,38,46}
  #declare locations = array[7] {<0,50,150>,<0,90,-150>,<0,130,-400>,<0,130,-400>,<0,130,-900>,<0,130,-900>,<0,90,-1400>}
  #declare times2 = array[18] {46,47,48,49,49.5,50,50.5,52,53,54,55,56,57,58,59,60,61,100}
  #declare locations2 = array[18] {<0,90,-1400>,<0,390,-1400>,<0,690,-1400>,<200,690,-1450>,<300,690,-1500>,<400,690,-1500>,<400,790,-1500>,<400,1190,-1500>,<600,1390,-1500>,<500,1490,-1500>,<300,1590,-1500>,<0,1590,-1500>,<0,1590,-1500>,<0,1490,-1500>,<0,1490,-1500>,<0,1490,-1500>,<0,1490,-1500>,<0,1490,-1500>}
#declare CameraLocation = (Linear(times,locations,secs) + Bezier(times2,locations2,secs));
//  #debug concat("Camera Location is:","\t",str(CameraLocation.x,5,0),"\t",str(CameraLocation.y,5,0),"\t",str(CameraLocation.z,5,0),"\n")  

#declare SpillLightLocation = CameraLocation;
  #declare times = array[4] {16,18,19,100}
  #declare locations = array[4] {0,0,0.3,0.3}
#declare SpillLightStrength = (Bezier2(times,locations,locations,secs));

  #declare times = array [43] {16,18,19,20,21.5,22.5,23.5,24,25,26,27,28,30,31,32,34,36,38,39,40,41,42,43,44,45,46,47,48,49,49.5,50,50.5,52,53,54,55,56,57,58,59,60,61,100}
  #declare locations = array[43] {<0,1050,-1350>,<-50,1190,-750>,<-200,1790,-200>,<600,1790,-450>,<600,1090,-500>,<-300,1090,-500>,<-300,390,-450>,<-300,290,-450>,<-200,-110,-475>,<-150,-110,-475>,<0,-110,-475>,<0,40,-450>,<100,-10,-575>,<1000,90,-900>,<1000,890,-900>,<400,1090,-900>,<100,1090,-900>,<-200,1090,-900>,<-400,1090,-1000>,<-400,1090,-1500>,<-100,1090,-1500>,<200,890,-1300>,<200,890,-1300>,<100,890,-1200>,<50,890,-1200>,<10,390,-1450>,<10,940,-1400>,<10,940,-1325>,<500,940,-1475>,<800,940,-1450>,<800,90,-1200>,<800,90,-1450>,<800,490,-1450>,<1000,1890,-1450>,<525,1890,-1475>,<-200,1990,-1500>,<-400,1690,-1500>,<-400,1590,-1500>,<-300,1090,-1300>,<-200,490,-800>,<0,0,0>,<0,0,0>,<0,0,0>}
#declare CameraLookAt = (Bezier(times,locations,secs));
//  #debug concat("Camera Look_at is:","\t",str(CameraLookAt.x,5,0),"\t",str(CameraLookAt.y,5,0),"\t",str(CameraLookAt.z,5,0),"\n")  

  #declare times = array[6] {16,18.5,20.5,21.5,23.5,100}
  #declare locations = array[6] {0*z,0*z,157*z,157*z,0*z,0*z}
#declare Door5Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,22.5,24.5,25.5,27.5,100}
#declare Door8Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,16.5,18.5,19.5,21.5,100}
#declare Door18Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,27,29,31,32,100}
#declare Door16Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,37,39,40,42,100}
#declare Door17Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,41,43,44,46,100}
#declare Door19Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,37,39,40,42,100}
#declare Door11Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,50,52,53,55,100}
#declare Door14Location = (Linear(times,locations,secs));

  #declare times = array[6] {16,52,54,55,57,100}
#declare Door13Location = (Linear(times,locations,secs));

  #declare times = array[4] {16,35,37,100}
  #declare locations = array[4] {157*z,157*z,0*z,0*z}
#declare Door2Location = (Linear(times,locations,secs));

  #declare times = array[4] {16,38,40,100}
  #declare locations = array[4] {0*z,0*z,157*z,157*z}
#declare Door9Location = (Linear(times,locations,secs));

  #declare times = array[4] {16,50.5,53,100}
  #declare locations = array[4] {-157*z,-157*z,0*z,0*z}
#declare Door1Location = (Linear(times,locations,secs));

  #declare times = array[4] {16,55,61,100}
  #declare locations = array[4] {0*z,0*z,157*z,157*z}
#declare Door4Location = (Linear(times,locations,secs));

  #declare times = array [12] {16,20,20.5,21,21.5,22,22.5,23,23.5,24,24.5,100}
  #declare locations = array[12] {<1250,1890,-518.5>,<1250,1890,-518.5>,<1000,1890,-518.5>,<1000,1490,-518.5>,<950,1090,-518.5>,<200,1090,-518.5>,<-550,1090,-518.5>,<-600,790,-518.5>,<-600,490,-518.5>,<-700,490,-518.5>,<-850,490,-518.5>,<-850,490,-518.5>}
#declare BuggyLocation = (Bezier(times,locations,secs));
//TestBezier(times,locations,80,1/1000,20)
#declare BuggyAlign = (BezierDeriv(times,locations,secs));
  #declare locations = array[10] {y*360*0,y*360*250/(12*pi),y*360*650/(12*pi),y*360*1053/(12*pi),y*360*1803/(12*pi),y*360*2553/(12*pi),y*360*2857/(12*pi),y*360*3157/(12*pi),y*360*3257/(12*pi),y*360*3407/(12*pi)}
#declare BuggyWheelRotation = (- Bezier(times,locations,secs));
#declare BuggyAntennaRotation = <10*sin(2*pi*secs),0,0>;

  #declare times = array [9] {16,24,28,36,38,46,50,58,66}
  #declare locations = array[9] {<0,90,-25>,<0,90,-525>,<0,90,-525>,<0,90,-1025>,<0,90,-1025>,<0,90,-1525>,<0,90,-1525>,<0,90,-1025>,<0,90,-525>}
#declare ElevatorLocation = (Linear(times,locations,secs));

  #declare starts = array[1] {16}
  #declare ends = array[1] {26}
  #declare positions = array[1] {<-150.0, -110.0, -518.5>}
  #declare times = array [5] {26,26,27,28,28}
  #declare locations = array[5] {<-200,-110,-518.5>,<-150,-110,-518.5>,<0,-110,-518.5>,<0,40,-518.5>,<0,90,-518.5>}
  #declare times2 = array [2] {28,36}
  #declare locations2 = array[2] {<0,40,-518.5>,<0,40,-1018.5>}
  #declare times3 = array [5] {36,36,37,38,38}
  #declare locations3 = array[5] {<0,90,-1018.5>,<0,40,-1018.5>,<0,-110,-1018.5>,<150,-110,-1018.5>,<200,-110,-1018.5>}
  #declare times4 = array[8] {38,39,40,41,42,43,44,100}
  #declare locations4 = array[8] {<150,-110,-1018.5>,<-200,-110,-1018.5>,<-600,-110,-1018.5>,<-600,290,-1018.5>,<-600,590,-1018.5>,<-600,890,-1018.5>,<-450,890,-1018.5>,<-400,890,-1018.5>}
#declare R2D2Location = (Position(starts,ends,positions,secs) + Bezier(times,locations,secs) + Linear(times2,locations2,secs) + Bezier(times3,locations3,secs) + Bezier(times4,locations4,secs));
//TestBezier(times,locations,20,1/250,10)
//TestLinear(times2,locations2,20,10)
//TestBezier(times3,locations3,20,1/250,10)
//#debug concat("Location is:","\t",str(MyLocation.x,5,0),"\t",str(MyLocation.y,5,0),"\t",str(MyLocation.z,5,0),"\n")  
  #declare starts = array[2] {16,28}
  #declare ends = array[2] {26,36}
  #declare positions = array[2] {<1,0,0>,<0,1,0>}
#declare R2D2Align = (BezierDeriv(times,locations,secs) + Position(starts,ends,positions,secs) - BezierDeriv(times3,locations3,secs) + BezierDeriv(times4,locations4,secs));
  #declare times = array[8] {16,25,26,28,29,35,36,100}
  #declare locations = array[8] {0*x,0*x,-15*x,-15*x,0*x,0*x,-15*x,-15*x}
#declare R2D2LegsRotation = (Linear(times,locations,secs));
  #declare locations = array[8] {0*x,0*x,30*x,30*x,0*x,0*x,30*x,30*x}
#declare R2D2BodyRotation = (Linear(times,locations,secs));
  #declare locations = array[8] {36*z,36*z,23*z,23*z,36*z,36*z,23*z,23*z}
#declare R2D2ThirdLegLocation = (Linear(times,locations,secs));
  #declare locations = array[8] {0*x,0*x,-15*x,-15*x,0*x,0*x,-15*x,-15*x}
#declare R2D2ThirdFootRotation = (Linear(times,locations,secs));
  #declare times = array[7] {16,25,26,26.5,27,28,100}
  #declare locations = array[7] {-180*z,-180*z,-120*z,-90*z,-135*z,-180*z,-180*z}
#declare R2D2HeadRotation = (Linear(times,locations,secs));

  #declare times = array[6] {15.5,16.5,17.5,18.5,19.5,100}
  #declare locations = array[6] {<-600,1290,-438.5>,<-600,1490,-438.5>,<-600,1660,-438.5>,<-630,1690,-438.5>,<-850,1690,-438.5>,<-850,1690,-438.5>}
#declare UnknownLocation = (Bezier(times,locations,secs));
#declare UnknownAlign = (BezierDeriv(times,locations,secs));

#declare FanRotation = z*secs*360*4;

  #declare times = array[6] {16,29.5,32.5,34,37,100}
  #declare locations = array[6] {<1250,1290,-918.5>,<1250,1290,-918.5>,<650,1290,-918.5>,<650,1290,-918.5>,<-118,1290,-918.5>,<-118,1290,-918.5>}
#declare MissileLocation = (Linear(times,locations,secs));

  #declare times = array[6] {16,29.5,32.5,33,36,100}
  #declare locations = array[6] {<1400.0, 1290.0, -1018.5>,<1400.0, 1290.0, -1018.5>,<800.0, 1290.0, -1018.5>,<800.0, 1290.0, -1018.5>,<1400.0, 1290.0, -1018.5>,<1400.0, 1290.0, -1018.5>}
#declare ForkLiftLocation = (Linear(times,locations,secs));
  #declare locations = array[6] {<1400.0, 1290.0, -917.5>,<1400.0, 1290.0, -917.5>,<800.0, 1290.0, -917.5>,<800.0, 1290.0, -917.5>,<1400.0, 1290.0, -917.5>,<1400.0, 1290.0, -917.5>}
#declare KongBotLocation = (Linear(times,locations,secs));
  #declare times = array[4] {16,32.5,33,100}
  #declare locations = array[4] {<135.0, 90.0, 0.0>,<135.0, 90.0, 0.0>,<90.0, 90.0, 0.0>,<90.0, 90.0, 0.0>}
#declare ForkLiftClawRotation = (Linear(times,locations,secs));
  #declare starts = array [5] {16,29.5,32.5,33,36}
  #declare ends = array[5] {29.5,32.5,33,36,100}
  #declare positions = array[5] {<0,0,0>,<0,12.5*sin(8*pi*secs),abs((5*cos(8*pi*secs)))>,<0,0,0>,<0,-12.5*sin(8*pi*secs),abs((5*cos(8*pi*secs)))>,<0,0,0>}
#declare KongBotPerturbation = (Position(starts,ends,positions,secs));
  #declare positions = array[5] {<0,0,0>,<0,-2.5*sin(8*pi*secs),cos(8*pi*secs)>,<0,0,0>,<0,2.5*sin(8*pi*secs),cos(8*pi*secs)>,<0,0,0>}
#declare KongBotLeftLegPerturbation = (Position(starts,ends,positions,secs));
  #declare positions = array[5] {<0,0,0>,<0,-2.5*sin(8*pi*secs + pi),cos(8*pi*secs + pi)>,<0,0,0>,<0,2.5*sin(8*pi*secs + pi),cos(8*pi*secs + pi)>,<0,0,0>}
#declare KongBotRightLegPerturbation = (Position(starts,ends,positions,secs));
  #declare positions = array[5] {-93*x,<-93 + abs((cos(8*pi*secs))),0,0>,-93*x,<-93 + abs((cos(8*pi*secs))),0,0>,-93*x}
#declare KongBotArmRotation = (Position(starts,ends,positions,secs));

  #declare times = array[14] {16,29,30,31,32,33,34,35,36,37,38,39,40,100}
  #declare locations = array[14] {<1000.0, -510.0, -938.5>,<1000.0, -510.0, -938.5>,<1000.0, -310.0, -938.5>,<1000.0, -110.0, -938.5>,<800.0, -110.0, -938.5>,<600.0, -110.0, -938.5>,<400.0, -110.0, -938.5>,<200.0, -110.0, -938.5>,<0.0, -110.0, -938.5>,<-200.0, -110.0, -938.5>,<-400.0, -110.0, -938.5>,<-600.0, -110.0, -938.5>,<-600.0, -310.0, -938.5>,<-600.0, -310.0, -938.5>}
#declare UnknownBLocation = (Bezier(times,locations,secs));
#declare UnknownBAlign = (BezierDeriv(times,locations,secs));

  #declare times = array[7] {16,29,30,31,32,33,100}
  #declare locations = array [7] {<1000.0, -360.0, -1018.5>,<1000.0, -360.0, -1018.5>,<1000.0, -110.0, -1018.5>,<1000.0, 190.0, -1018.5>,<1000.0, 690.0, -1018.5>,<1000.0, 1090.0, -1018.5>,<1000.0, 1090.0, -1018.5>}
#declare TransporterLocation = (Bezier(times,locations,secs));
#declare TransporterTrackPerturbation = <0,-mod(2*(TransporterLocation.y + 15500),15.5),0>;
#declare TransporterTrackBPerturbation = <mod(2*(TransporterLocation.y + 15500),15.5)*60/15.5,0,0>;
#declare TransporterWheelRotation = <2*(TransporterLocation.y)*60/15.5,0,0>;
  #declare times = array[4] {16,33,34,100}
  #declare locations = array[4] {<0,0,0>,<0,0,0>,<0,0,180>,<0,0,180>}
#declare TransporterArmRotation = (Linear(times,locations,secs));
  #declare locations = array[4] {<0,0,24>,<0,0,24>,<0,0,59>,<0,0,59>}
#declare TransporterPostLocation = (Linear(times,locations,secs));
  #declare locations = array[4] {<0,0,0>,<0,0,0>,<-45,0,0>,<-45,0,0>}
#declare TransporterHingeRotation = (Linear(times,locations,secs));
  #declare locations = array[4] {<-90,0,0>,<-90,0,0>,<-120,0,0>,<-120,0,0>}
#declare TransporterClawRotation = (Linear(times,locations,secs));

  #declare times = array[7] {16,28.5,30,31.5,33,34.5,100}
  #declare locations = array[7] {<1300.0, 90.0, -983.5>,<1300.0, 90.0, -983.5>,<1300.0, 490.0, -983.5>,<1300.0, 890.0, -983.5>,<1300.0, 1290.0, -983.5>,<1300.0, 1690.0, -983.5>,<1300.0, 1690.0, -983.5>}
#declare LegoBLocation = (Linear(times,locations,secs));
#declare LegoBWheelRotation = <-90,LegoBLocation.y*360/(65*pi),90>;

  #declare times = array[4] {16,34,37,100}
  #declare locations = array[4] {784.0*x,784.0*x,16.0*x,16.0*x}
#declare ShifterCarriageLocation = (Linear(times,locations,secs));

  #declare times = array[4] {16,34,37,39}
  #declare times2 = array[3] {39,41,100}
  #declare locations = array[4] {<550.0, 1290.0, -1018.5>,<550.0, 1290.0, -1018.5>,<-218.0, 1290.0, -1018.5>,<-218.0, 1290.0, -1018.5>}
  #declare locations2 = array[3] {<-218.0, 1290.0, -1018.5>,<-408.0, 1290.0, -1018.5>,<-408.0, 1290.0, -1018.5>}
#declare EngineLocation = (Linear(times,locations,secs) + Bezier2(times2,locations2,locations2,secs));

  #declare times = array[6] {16,37,38,39,41,100}
  #declare locations = array[6] {<-530,1290,-1018.5>,<-530,1290,-1018.5>,<-340.0, 1290.0, -1018.5>,<-340.0, 1290.0, -1018.5>,<-530,1290,-1018.5>,<-530,1290,-1018.5>}
#declare ForkLiftBLocation = (Bezier2(times,locations,locations,secs));
  #declare locations = array[6] {<-590.0, 1290.0, -983.5>,<-590.0, 1290.0, -983.5>,<-400.0, 1290.0, -983.5>,<-400.0, 1290.0, -983.5>,<-590.0, 1290.0, -983.5>,<-590.0, 1290.0, -983.5>}
#declare LegoLocation = (Bezier2(times,locations,locations,secs));
#declare LegoWheelRotation = <-90,LegoLocation.y*360/(65*pi),90>;
  #declare times = array[4] {16,38,39,100}
  #declare locations = array[4] {120*x,120*x,-120*x,-120*x}
#declare LegoWrenchRotation = (Linear(times,locations,secs));

  #declare times = array[10] {16,33,34,35,38.5,39.5,40,41,43,44}
  #declare locations = array[10] {<0.0, 2090.0, -750.0>,<0.0, 2090.0, -750.0>,<-400.0, 2090.0, -750.0>,<0.0, 2090.0, -750.0>,<0.0, 2090.0, -750.0>,<-200.0, 2090.0, -890.0>,<-200.0, 2090.0, -890.0>,<-200.0, 2090.0, -1500.0>,<-200.0, 2090.0, -1500.0>,<-200.0, 1890.0, -1500.0>}
  #declare times2 = array[8] {44,46.5,49,49.5,50,50.5,51,100}
  #declare locations2 = array[8] {<-200.0, 1890.0, -1500.0>,<600,1890,-1500>,<600,1090,-1500>,<600,790,-1450>,<600,290,-1200>,<600,90,-850>,<600,-110,-850>,<600,-110,-850>}
#declare VINcentLocation = (Linear(times,locations,secs) + Bezier(times2,locations2,secs));
  #declare times = array[16] {16,31,32,33,34,35,36,38,44,45,46,49,49.5,50.5,51,100}
  #declare locations = array[16] {-180*z,-180*z,-210*z,-150*z,-210*z,-150*z,-180*z,<0,360,-180>,<0,360,-180>,<0,360,-270>,<0,360,-180>,<0,360,-210>,<0,360,-250>,<0,360,-250>,<0,360,-270>,<0,360,-270>}
#declare VINcentRotation = (Linear(times,locations,secs));
  #declare times = array[6] {16,48.5,49.5,50,51,100}
  #declare locations = array[6] {0*z,0*z,-24*z,-24*z,0*z,0*z}
#declare VINcentLeftFootLocation = (Linear(times,locations,secs));
  #declare locations = array[6] {0*z,0*z,24*z,24*z,0*z,0*z}
#declare VINcentRightFootLocation = (Linear(times,locations,secs));
  #declare locations = array[6] {0*y,0*y,8.5*y,8.5*y,0*y,0*y}
#declare VINcentLeftPhaserLocation = (Linear(times,locations,secs));
#declare VINcentRightPhaserLocation = (Linear(times,locations,secs));

  #declare times = array [13] {16,38.5,39,39.5,40,40.5,41,41.5,42,42.5,43,43.5,100}
  #declare locations = array[13] {<-850.0, -110.0, -1518.5>,<-850.0, -110.0, -1518.5>,<-400.0, -110.0, -1518.5>,<-400.0, 290.0, -1518.5>,<-400.0, 690.0, -1570>,<-400.0, 1090.0, -1600>,<-400.0, 1490.0, -1600>,<0.0, 1490.0, -1600>,<300.0, 1490.0, -1600>,<300.0, 1890.0, -1600>,<300.0, 2340.0, -1600>,<700.0, 2340.0, -1600>,<700.0, 2340.0, -1600>}
#declare BuggyBLocation = (Bezier(times,locations,secs));
#declare BuggyBAlign = (BezierDeriv(times,locations,secs));
  #declare times = array[11] {39,39.5,40,40.5,41,41.5,42,42.5,43,43.5,44}
  #declare locations = array[11] {y*360*0,y*360*450/(12*pi),y*360*850/(12*pi),y*360*1253/(12*pi),y*360*1654/(12*pi),y*360*2054/(12*pi),y*360*2454/(12*pi),y*360*2754/(12*pi),y*360*3154/(12*pi),y*360*3604/(12*pi),y*360*4004/(12*pi)}
#declare BuggyBWheelRotation = (- Bezier(times,locations,secs));
#declare BuggyBAntennaRotation = <10*sin(2*pi*secs),0,0>;

  #declare times = array[4] {16,42,43,100}
  #declare locations = array[4] {15*z,15*z,0*z,0*z}
#declare MissileCCableRotation = (Linear(times,locations,secs));
  #declare times = array[7] {16,43,44,46,47,48,100}
  #declare locations = array[7] {<200.0, 897.0, -1377.0>,<200.0, 897.0, -1377.0>,<200.0, 897.0, -1177.0>,<-40.0, 897.0, -1177.0>,<-40.0, 897.0, -1277.0>,<-40.0, 897.0, -1327.0>,<-40.0, 897.0, -1327.0>}
#declare MissileCLocation = (Bezier2(times,locations,locations,secs));
  #declare locations = array[7] {<0.0, 180.0, -2200.0>,<0.0, 180.0, -2200.0>,<0.0, 180.0, -1800.0>,<0.0, 180.0, -1800.0>,<0.0, 180.0, -2000.0>,<0.0, 180.0, -2100.0>,<0.0, 180.0, -2100.0>}
#declare CranePulleysMovableLocation = (Bezier2(times,locations,locations,secs));
  #declare times = array[4] {16,44,46,100}
  #declare locations = array[4] {300*x,300*x,60*x,60*x}
#declare CraneCarriageLocation = (Bezier2(times,locations,locations,secs));

  #declare times = array[4] {16,42.5,43,100}
  #declare locations = array[4] {-82.882301*x,-82.882301*x,-120*x,-120*x}
#declare TransporterCClawRotation = (Linear(times,locations,secs));
  #declare times = array[4] {16,44,45,100}
  #declare locations = array[4] {-60*x,-60*x,-30*x,-30*x}
#declare TransporterCHingeRotation = (Bezier2(times,locations,locations,secs));
  #declare locations = array[4] {0*x,0*x,60*x,60*x}
#declare TransporterCElbowRotation = (Bezier2(times,locations,locations,secs));
  #declare locations = array[4] {-45*z,-45*z,-15*z,-15*z}
#declare TransporterCArmRotation = (Bezier2(times,locations,locations,secs));

  #declare times = array[6] {16,42,43,44,46,100}
  #declare locations = array[6] {<284.0, 915.0, -1245.0>,<284.0, 915.0, -1245.0>,<250.0, 915.0, -1245.0>,<284.0, 915.0, -1245.0>,<44.0, 1015.0, -1300.0>,<44.0, 1015.0, -1300.0>}
#declare VINcentBLocation = (Linear(times,locations,secs));
  #declare times = array[4] {16,46,47,100}
  #declare locations = array[4] {<-13.5, 9.0, -0.5>,<-13.5, 9.0, -0.5>,<-13.5, 21.5, -0.5>,<-13.5, 21.5, -0.5>}
#declare VINcentBLeftClawLocation = (Linear(times,locations,secs));
  #declare times = array[4] {16,47,48,100}
  #declare locations = array[4] {0*z,0*z,45*z,45*z}
#declare VINcentBHeadRotation = (Bezier2(times,locations,locations,secs));

  #declare times = array[6] {16,49.5,50.5,52,53,100}
  #declare locations = array[6] {<800.0, -200.0, -1600.0>,<800.0, -200.0, -1600.0>,<800.0, 0.0, -1600.0>,<800.0, 400.0, -1600.0>, <800.0, 600.0, -1600.0>,<800.0, 600.0, -1600.0>}
#declare TankBLocation = (Bezier(times,locations,secs));
  #declare locations = array[6] {-10*x,-5*x,-10*x,-15*x,-10*x,-10*x}
#declare TankBGunRotation = (Linear(times,locations,secs));
  #declare times = array[4] {16,50.5,52,100}
  #declare locations = array[4] {0*z,0*z,45*z,45*z}
#declare TankBTurretRotation = (Linear(times,locations,secs));
  #declare locations = array[4] {0*x,0*x,-15*x,-15*x}
#declare TankBTrayRotation = (Linear(times,locations,secs));
#declare TankBTrackPerturbation = <0,-mod(4/9*(TankBLocation.y + 15500),15.5),0>;
#declare TankBTrackBPerturbation = <mod(4/9*(TankBLocation.y + 15500),15.5)*60/15.5,0,0>;
#declare TankBWheelRotation = <4/9*(TankBLocation.y)*60/15.5,0,0>;

  #declare times = array[7] {16,52,53,54,55,56,100}
  #declare locations = array[7] {<1250.0, 1890.0, -1438.5>,<1250.0, 1890.0, -1438.5>,<1000.0, 1890.0, -1438.5>,<650.0, 1890.0, -1438.5>,<650.0, 2140.0, -1438.5>,<1000.0, 2140.0, -1438.5>,<1000.0, 2140.0, -1438.5>}
#declare UnknownCLocation = (Bezier(times,locations,secs));
#declare UnknownCAlign = (BezierDeriv(times,locations,secs));

  #declare times = array[9] {16,52,53,54,55,56,57,58,100}
  #declare locations = array[9] {<0.0, 2340.0, -1600.0>,<0.0, 2340.0, -1600.0>,<300.0, 2340.0, -1600.0>,<300.0, 1890.0, -1600.0>,<-100.0, 1890.0, -1600.0>,<-400.0, 1690.0, -1600.0>,<-600.0, 1490.0, -1600.0>,<-600.0, 1290.0, -1600.0>,<-600.0, 1290.0, -1600.0>}
#declare R2D2CLocation = (Bezier(times,locations,secs));
#declare R2D2CAlign = (BezierDeriv(times,locations,secs));
  
  #declare times = array[4] {16,42.5,52,100}
  #declare locations = array[4] {<300,3090,-1500>,<300,3090,-1500>,<300,1190,-1500>,<300,1190,-1500>}
#declare KongBotBLocation = (Linear(times,locations,secs));
  #declare starts = array [3] {16,42.5,52}
  #declare ends = array[3] {42.5,52,100}
  #declare positions = array[3] {<0,0,0>,<0,12.5*sin(8*pi*secs),abs((5*cos(8*pi*secs)))>,<0,0,0>}
#declare KongBotBPerturbation = (Position(starts,ends,positions,secs));
  #declare positions = array[3] {<0,0,0>,<0,-2.5*sin(8*pi*secs),cos(8*pi*secs)>,<0,0,0>}
#declare KongBotBLeftLegPerturbation = (Position(starts,ends,positions,secs));
  #declare positions = array[3] {<0,0,0>,<0,-2.5*sin(8*pi*secs + pi),cos(8*pi*secs + pi)>,<0,0,0>}
#declare KongBotBRightLegPerturbation = (Position(starts,ends,positions,secs));


//
// *******  C A M E R A S *******
//                     
camera {  //  Camera StdCam
  location CameraLocation
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      0.000,       0.000,      100.000>
  look_at CameraLookAt
}

//
// *******  L I G H T S *******
//

#if (secs >= 55) 
  light_source {   // Spotlight GreenLight
    <0.0, 0.0, 0.0>
    color rgb <0.000, 1.000, 0.000>
    spotlight
      point_at  <0.0, 0.0, -2.000>
      falloff    45.000  // outer radius (in deg)
      radius     45.000  // inner radius
      tightness  0.000
    rotate -45.0*y
    translate  <-1200.0, 1590.0, -1100.0>
  }
#end

#declare Arealight004 = light_source {   // Arealight Arealight004 is redbulb
  <0.0, 0.0, 0.0>
  color rgb <1.000, 0.100, 0.100>
  fade_distance  300.0
  fade_power 3.0
}

#declare Spotlight001 = light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.6000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    85.000  // outer radius (in deg)
    radius     80.000  // inner radius
    tightness  0.000
  translate  <200.0, 490.0, 0.0>
}

#declare Spotlight002 = light_source {   // Spotlight Spotlight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.6000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    85.000  // outer radius (in deg)
    radius     80.000  // inner radius
    tightness  0.000
  translate  <200.0, 490.0, 0.0>
}

#declare Spill_Light = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*SpillLightStrength
  shadowless
  translate  SpillLightLocation
}

#declare Spotlight003 = light_source {   // Spotlight Spotlight003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.4000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    85.000  // outer radius (in deg)
    radius     80.000  // inner radius
    tightness  0.000
  fade_distance  500.0
  fade_power 1.0
  translate  -10.0*z
}

#declare Spotlight004 = light_source {   // Spotlight Spotlight004
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.4000
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    85.000  // outer radius (in deg)
    radius     80.000  // inner radius
    tightness  0.000
  fade_distance  500.0
  fade_power 1.0
  translate  -10.0*z
}


//
// ********  MATERIALS  *******
//

#include "xfinal.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare CSG007 = difference {
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG008 = intersection {
  object { CSG007 }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
}
#declare CSG005 = difference {
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG006 = intersection {
  object { CSG005 }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate 180.0*z
}
#declare CSG004 = difference {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG009 = intersection {
  object { CSG004 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate -90.0*z
}
#declare CSG010 = difference {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <120.0, 120.0, 15.0>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    scale <90.0, 90.0, 30.0>
  }
}
#declare CSG011 = intersection {
  object { CSG010 }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 30.0>
    rotate -45.0*z
    translate  -142.0*x
  }
  rotate 90.0*z
}
#declare Poles = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <-50.0, -100.0, 0.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <50.0, -100.0, 0.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <50.0, 100.0, 0.0>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  <-50.0, 100.0, 0.0>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  -100.0*x
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 120.0>
    translate  100.0*x
  }
  material {
    T_Chrome_2E
  }
}
#declare Joints = union {
  sphere { // Sphere010
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, -100.0, 120.0>
  }
  sphere { // Sphere009
    <0,0,0>,1
    scale 3.0
    translate  <50.0, -100.0, 120.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale 3.0
    translate  <50.0, 100.0, 120.0>
  }
  sphere { // Sphere007
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, 100.0, 120.0>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, 0.0, 120.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    scale 3.0
    translate  <100.0, 0.0, 120.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, -100.0, 120.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 3.0
    translate  <100.0, -100.0, 120.0>
  }
  sphere { // Sphere011
    <0,0,0>,1
    scale 3.0
    translate  <100.0, 100.0, 120.0>
  }
  sphere { // Sphere012
    <0,0,0>,1
    scale 3.0
    translate  <-100.0, 100.0, 120.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare Rails = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <50.0, 100.0, 120.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <50.0, -100.0, 120.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-100.0, -100.0, 120.0>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 50.0>
    rotate <90.0, -0.0, 90.0>
    translate  <-100.0, 100.0, 120.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 200.0>
    rotate 90.0*x
    translate  <100.0, 100.0, 120.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 200.0>
    rotate 90.0*x
    translate  <-100.0, 100.0, 120.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare ElevatorSuround = union {
  object { CSG008 }
  object { CSG006 }
  object { CSG009 }
  object { CSG011 }
  object { Poles }
  object { Joints }
  object { Rails }
  material {
    Metal
  }
  scale 0.75
  translate  <0.0, 90.0, -25.0>
}
#declare CSG030 = union {
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 3.5, 1.0>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <5.0, 3.0, 1.0>
    translate  0.25*z
  }
}
#declare CSG031 = difference {
  object { CSG030 }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 1.6, 1.0>
    translate  <2.0, 0.0, 1.0>
  }
}
#declare CSG032 = difference {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    translate  <4.0, 0.0, 0.75>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  <4.0, 0.0, 1.0>
  }
  translate  <-2.0, 0.0, -0.25>
}
#declare Switch1 = union {
  object { CSG031 }
  object { CSG032 }
  sphere { // Sphere032
    <0,0,0>,1
    scale <1.25, 1.25, 0.5>
    translate  <2.0, 0.0, 1.25>
  }
  torus { // Torus004
    1.75, 0.25  rotate -x*90
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <2.0, 0.0, 1.25>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    material {
      BlueLight
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  hollow
  rotate 45.0*x
  translate  40.0*z
}
#declare SwitchStand1 = union {
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Rubber
    }
    scale <5.5, 3.5, 1.0>
    translate  1.0*z
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 20.0>
    translate  <3.0, 0.0, 20.0>
  }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 20.0>
    translate  <-3.0, 0.0, 20.0>
  }
  object { Switch1 }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 3.0, 1.0>
    translate  1.25*z
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 20.0>
    translate  <3.0, 0.0, 20.0>
  }
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 20.0>
    translate  <-3.0, 0.0, 20.0>
  }
  material {
    T_Chrome_1A
  }
  hollow
  scale 2.0
  translate  <-105.0, 0.0, -506.0>
}
#declare Beam = union {
  box { // Cube1310
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 10.0, 1000.0>
    translate  <-110.0, 20.0, -1025.0>
  }
  box { // Cube1311
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 1000.0>
    translate  <-110.0, 30.0, -1025.0>
  }
  box { // Cube1312
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 1.0, 1000.0>
    translate  <-110.0, 10.0, -1025.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Support = union {
  box { // Cube1313
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 1.0>
  }
  box { // Cube1314
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 5.0, 1.0>
  }
  cylinder { // Cylndr1005
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <-2.5, 5.0, -1.0>
  }
  cylinder { // Cylndr1006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <2.5, -5.0, -1.0>
  }
  cylinder { // Cylndr1007
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <-2.5, -5.0, -1.0>
  }
  cylinder { // Cylndr1008
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    translate  <2.5, 5.0, -1.0>
  }
  scale <7.5, 17.5, 20.0>
  translate  <-110.0, 90.0, -525.0>
}


#declare SideRail = union {
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 202.0>
    rotate 90.0*y
    translate  <-101.0, 80.0, 75.0>
  }
  sphere { // Sphere026
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  translate  <400.0, -110.0, -500.0>
}
#declare SideRailB = union {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 181.0>
    rotate 90.0*y
    translate  <-80.0, 80.0, 75.0>
  }
  sphere { // Sphere028
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  sphere { // Sphere029
    <0,0,0>,1
    scale 2.0
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-80.0, 80.0, -25.0>
  }
  translate  <200.0, -110.0, -500.0>
}
#declare SideRailC = union {
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 196.0>
    rotate 90.0*y
    translate  <-95.0, 80.0, 75.0>
  }
  sphere { // Sphere030
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  sphere { // Sphere031
    <0,0,0>,1
    scale 2.0
    translate  <-95.0, 80.0, 75.0>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <-95.0, 80.0, 75.0>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-95.0, 80.0, -25.0>
  }
  rotate -90.0*z
  translate  <-200.0, 90.0, -500.0>
}
#declare CornerRail = union {
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate -90.0*x
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate 90.0*y
    translate  <-101.0, 80.0, 75.0>
  }
  sphere { // Sphere027
    <0,0,0>,1
    scale 2.0
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-80.0, 80.0, -25.0>
  }
  translate  <1000.0, -110.0, -500.0>
}
#declare SideRailE = union {
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 181.0>
    rotate 90.0*y
    translate  <-80.0, 80.0, 75.0>
  }
  sphere { // Sphere033
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  sphere { // Sphere034
    <0,0,0>,1
    scale 2.0
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <-80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-80.0, 80.0, -25.0>
  }
  rotate -90.0*z
  translate  <840.0, 290.0, -500.0>
}
#declare SideRailF = union {
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 182.0>
    rotate 90.0*y
    translate  <-81.0, 80.0, 75.0>
  }
  sphere { // Sphere038
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  translate  <1000.0, 290.0, -500.0>
}
#declare SideRailG = union {
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -39.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 21.0>
    rotate -90.0*y
    translate  <101.0, 80.0, 75.0>
  }
  sphere { // Sphere040
    <0,0,0>,1
    scale 2.0
    translate  <80.0, 80.0, 75.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <-0.0, -100.0, 0.0>
    translate  <80.0, 80.0, 75.0>
  }
  sphere { // Sphere041
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 61.0>
  }
  rotate -90.0*z
  translate  <0.0, 290.0, -500.0>
}
#declare SideRailH = union {
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <80.0, 80.0, -60.25>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    rotate <-0.0, -0.0, -0.0>
    translate  <0.0, 0.0, -1.886139>
    scale <2.0, 2.0, 193.800003>
    rotate <-0.0, 80.0, -0.0>
    translate  <280.0, 80.0, 75.0>
  }
  sphere { // Sphere039
    <0,0,0>,1
    scale 2.0
    translate  <80.0, 80.0, 39.75>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-80.0, 80.0, -88.5>
  }
  sphere { // Sphere042
    <0,0,0>,1
    scale 2.0
    translate  <-80.0, 80.0, 11.5>
  }
  rotate -90.0*z
  translate  <0.0, 490.0, -500.0>
}
#declare FloorSupport = union {
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 180.0>
    rotate -90.0*x
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -270.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate -75.0*x
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -90.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -180.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, 90.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -0.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 60.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 60.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 60.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 60.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -180.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, 0.0, 45.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, -0.0, -45.0>
    translate  <-90.0, -90.0, -90.0>
  }
  material {
    Metal
  }
  translate  <-600.0, -110.0, -500.0>
}
#declare CSG041 = union {
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  material {
    Metal
  }
  translate  <0.0, 90.0, -500.0>
}
#declare LiftFloor = difference {
  object { CSG041 }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    scale <85.0, 85.0, 30.0>
    translate  <0.0, 90.0, -525.0>
  }
}
#declare FloorPanel = union {
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  rotate -0.0*x
  translate  <0.0, 99.0, 36.5>
  rotate -10.0*x
  translate  <0.0, -99.0, -36.5>
}
#declare Ramp = union {
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate -90.0*x
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -270.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate -85.0*x
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-85.0, -0.0, -90.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -180.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-85.0, 0.0, 90.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-85.0, -0.0, -0.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 60.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 60.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 30.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 30.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 185.0>
    rotate <-75.0, 0.0, -180.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, 0.0, 45.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, -0.0, -45.0>
    translate  <-90.0, -90.0, -90.0>
  }
  object { FloorPanel }
  translate  <0.0, 290.0, -500.0>
}
#declare FloorPanel1 = union {
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  rotate -0.0*x
  translate  <0.0, 299.0, 36.5>
  rotate -10.0*x
  translate  <0.0, -299.0, -36.5>
}
#declare RampB = union {
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate -90.0*x
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <-90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <90.0, 90.0, -90.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-85.0, -0.0, 90.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 60.0>
    rotate <-75.0, -0.0, -0.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 30.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 30.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 180.0>
    rotate <-85.0, -0.0, -90.0>
    translate  <-90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, 0.0, 45.0>
    translate  <90.0, -90.0, -90.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 254.0>
    rotate <-90.0, -0.0, -45.0>
    translate  <-90.0, -90.0, -90.0>
  }
  object { FloorPanel1 }
  translate  <0.0, 490.0, -500.0>
}


#declare SideRailD = union {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 202.0>
    rotate 90.0*y
    translate  <-101.0, 75.0, 75.0>
  }
  translate  <0.0, 110.0, -500.0>
}


#declare CSG175 = difference {
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    scale <130.0, 130.0, 30.0>
    rotate 90.0*x
    translate  <1015.0, -225.0, -125.0>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    scale <100.0, 100.0, 40.0>
    rotate 90.0*x
    translate  <1015.0, -220.0, -125.0>
  }
  box { // Cube546
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <150.0, 20.0, 150.0>
    rotate <0.0, -45.0, -0.0>
    translate  <1015.0, -240.0, -125.0>
  }
  box { // Cube547
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 20.0, 150.0>
    translate  <1015.0, -240.0, -275.0>
  }
  translate  30.0*y
}
#declare CSG176 = difference {
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    scale <130.0, 130.0, 30.0>
    rotate 90.0*x
    translate  <1015.0, -225.0, -125.0>
  }
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    scale <100.0, 100.0, 40.0>
    rotate 90.0*x
    translate  <1015.0, -220.0, -125.0>
  }
  box { // Cube549
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <150.0, 20.0, 150.0>
    rotate <0.0, -45.0, -0.0>
    translate  <1015.0, -240.0, -125.0>
  }
  box { // Cube550
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 20.0, 150.0>
    translate  <865.0, -240.0, -125.0>
  }
  translate  <-110.0, 30.0, 110.0>
}
#declare Rafter = union {
  box { // Cube543
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 200.0>
    translate  <-730.0, -210.0, -85.0>
  }
  box { // Cube544
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 200.0>
    translate  <1130.0, -210.0, -85.0>
  }
  box { // Cube545
    <-1, -1, -1>, <1, 1, 1>
    scale <945.0, 15.0, 15.0>
    translate  <200.0, -210.0, 100.0>
  }
  object { CSG175 }
  box { // Cube548
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.8, 0.0, -7.666667>
    scale <100.0, 15.0, 15.0>
    rotate <-0.0, -135.0, -0.0>
    translate  <1015.0, -210.0, -125.0>
  }
  object { CSG176 }
  object { // CSG177->CSG175
    CSG175
    scale <-1.0, 1.0, 1.0>
    translate  400.0*x
  }
  object { // CSG178->CSG176
    CSG176
    scale -1.0
    rotate -180.0*x
    translate  400.0*x
  }
  box { // Cube551
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.8, 0.0, -7.666667>
    scale <100.0, 15.0, 15.0>
    rotate <-0.0, -225.0, -0.0>
    translate  <-615.0, -210.0, -125.0>
  }
}


#declare CSG191 = difference {
  sphere { // Sphere045
    <0,0,0>,1
    scale <2.5, 2.5, 5.0>
    translate  1.0*z
  }
  box { // Cube578
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  -1.0*z
  }
}
#declare CSG192 = difference {
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 10.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 11.0>
    translate  -6.5*z
  }
}
#declare CSG193 = difference {
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    scale <12.5, 12.5, 5.0>
    translate  2.0*z
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 6.0>
    translate  1.5*z
  }
  material {
    T_Chrome_1A
  }
}
#declare Parts20 = union {
  object { CSG191 }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 10.0>
    translate  -5.0*z
  }
  object { CSG192 }
  box { // Cube579
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    translate  3.0*z
  }
  box { // Cube580
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -120.0*z
    translate  3.0*z
  }
  box { // Cube581
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -240.0*z
    translate  3.0*z
  }
  object { CSG193 }
  // All transformations fixed
}
#declare CSG194 = intersection {
  box { // Cube583
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  1.428571*y
    scale <5.0, 7.0, 5.0>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale 10.0
  }
}
#declare Blade = intersection {
  box { // Cube582
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 0.1>
    rotate 15.0*y
  }
  object { CSG194 }
}
#declare Blades = union {
  object { Blade }
  object { // Blade1->Blade
    Blade
    rotate -90.0*z
  }
  object { // Blade2->Blade
    Blade
    rotate 180.0*z
  }
  object { // Blade3->Blade
    Blade
    rotate 90.0*z
  }
  torus { // Torus005
    2.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  1.0*z
  }
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -1.0*z
  }
  cone { // Cone006
    <0,0,0>, 2.0, <0,0,1>, 2.5
    open
    scale <1.0, 1.0, 2.0>
    translate  -1.0*z
  }
  // Scaling fixed
  // Translation fixed
  rotate FanRotation
}
#declare Fan = union {
  object { Parts20 }
  object { Blades }
  material {
    T_Chrome_3A
  }
  rotate 90.0*x
  translate  <13.5, -0.1, 15.0>
}


#declare CSG203 = difference {
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    scale 15.0
    rotate 90.0*x
    translate  7.5*y
  }
  cone { // Cone007
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate 90.0*x
    translate  7.0*y
  }
  cone { // Cone008
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate -90.0*x
    translate  -7.0*y
  }
}
#declare Wheel = union {
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 12.0>
    rotate 90.0*x
    translate  6.0*y
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
    translate  7.5*y
  }
  object { CSG203 }
  // Scaling fixed
  // Translation fixed
  translate  <-280.0, 5.0, -519.0>
}
#declare WheelGroup = union {
  object { Wheel }
  object { // Wheel1->Wheel
    Wheel
    translate  35.0*x
  }
  object { // Wheel2->Wheel
    Wheel
    translate  125.0*x
  }
  object { // Wheel3->Wheel
    Wheel
    translate  160.0*x
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG204 = difference {
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube617
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube618
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  translate  -7.0*x
}
#declare CSG205 = difference {
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube619
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube620
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  scale <-1.0, 1.0, 1.0>
  translate  -518.0*x
}
#declare WheelArch = union {
  box { // Cube616
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 10.0, 1.0>
    translate  <-262.5, 5.0, -500.0>
  }
  object { CSG204 }
  object { CSG205 }
  material {
    Metal_Smooth
  }
}
#declare CSG206 = difference {
  box { // Cube621
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 14.14, 14.14>
    rotate 45.0*x
    translate  <-262.5, 15.0, -519.0>
  }
  box { // Cube622
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 11.0, 20.0>
    translate  <-262.0, 4.0, -519.0>
  }
}
#declare Straps = union {
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-280.0, 35.0, -519.0>
  }
  cone { // Cone010
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-245.0, 35.0, -519.0>
  }
  object { CSG206 }
  material {
    Metal_Smooth
  }
}


#declare CSG213 = difference {
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    scale 15.0
    rotate 90.0*x
    translate  7.5*y
  }
  cone { // Cone011
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate 90.0*x
    translate  7.0*y
  }
  cone { // Cone012
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate -90.0*x
    translate  -7.0*y
  }
}
#declare Wheel4 = union {
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 12.0>
    rotate 90.0*x
    translate  6.0*y
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
    translate  7.5*y
  }
  object { CSG213 }
  // Scaling fixed
  // Translation fixed
  translate  <-280.0, 5.0, -519.0>
}
#declare WheelGroup2 = union {
  object { Wheel4 }
  object { // Wheel5->Wheel4
    Wheel4
    translate  35.0*x
  }
  object { // Wheel6->Wheel4
    Wheel4
    translate  125.0*x
  }
  object { // Wheel7->Wheel4
    Wheel4
    translate  160.0*x
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG214 = difference {
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube653
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube654
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  translate  -7.0*x
}
#declare CSG215 = difference {
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube655
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube656
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  scale <-1.0, 1.0, 1.0>
  translate  -518.0*x
}
#declare WheelArch4 = union {
  box { // Cube652
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 10.0, 1.0>
    translate  <-262.5, 5.0, -500.0>
  }
  object { CSG214 }
  object { CSG215 }
}
#declare CSG216 = difference {
  box { // Cube657
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 14.14, 14.14>
    rotate 45.0*x
    translate  <-262.5, 15.0, -519.0>
  }
  box { // Cube658
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 11.0, 20.0>
    translate  <-262.0, 4.0, -519.0>
  }
}
#declare Straps4 = union {
  cone { // Cone013
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-280.0, 35.0, -519.0>
  }
  cone { // Cone014
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-245.0, 35.0, -519.0>
  }
  object { CSG216 }
}


#declare CSG232 = difference {
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 30.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  11.0*x
  }
}
#declare Wheel12 = union {
  object { CSG232 }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 15.0>
    rotate 90.0*y
    translate  -7.5*x
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  box { // Cube685
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <-30.0, 0.0, 0.0>
    translate  0.0*y
  }
  box { // Cube686
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 14.0>
    rotate 0.0*z
    translate  0.0*y
  }
  box { // Cube687
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <30.0, -0.0, -0.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Rot X limited (0.0 to   60.0)
  // Translation fixed
  rotate TransporterWheelRotation
  translate  <60.0, -15.5, -5.0>
}
#declare Track = union {
  box { // Cube697
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate -45.0*x
    translate  <-60.0, 77.5, 10.75>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-15.5 to   0.0)
  translate TransporterTrackPerturbation
}
#declare Other_Tracks = union {
  object { // Track1->Track
    Track
    translate  -15.5*y
  }
  object { // Track2->Track
    Track
    translate  -31.0*y
  }
  object { // Track3->Track
    Track
    translate  -46.5*y
  }
  object { // Track4->Track
    Track
    translate  -62.0*y
  }
  object { // Track5->Track
    Track
    translate  -77.5*y
  }
  object { // Track6->Track
    Track
    translate  -93.0*y
  }
  object { // Track7->Track
    Track
    translate  -108.5*y
  }
  object { // Track8->Track
    Track
    translate  -124.0*y
  }
  object { // Track9->Track
    Track
    translate  -139.5*y
  }
  // All transformations fixed
}
#declare Trackside = union {
  object { Track }
  object { Other_Tracks }
  // All transformations fixed
}
#declare TrackB = union {
  box { // Cube698
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate <135.0, 0.0, -0.0>
    translate  <-60.0, 0.0, -15.75>
  }
  // Scaling fixed
  // Rot X limited (-180.0 to   -120.0)
  // Translation fixed
  rotate <-180.0, -180.0, -180.0>
  rotate TransporterTrackBPerturbation
  translate  <0.0, 77.5, -5.0>
}
#declare Other_TrackBs = union {
  object { // TrackB2->TrackB
    TrackB
    rotate <120.0, 0.0, -0.0>
    translate  <0.0, 111.919873, -74.616969>
  }
  object { // TrackB1->TrackB
    TrackB
    rotate <60.0, -0.0, -0.0>
    translate  <-0.0, 34.419873, -69.616969>
  }
  // All transformations fixed
}
#declare Trackend = union {
  object { TrackB }
  object { Other_TrackBs }
  // All transformations fixed
}
#declare Claw = union {
  box { // Cube699
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    translate  <0.0, -7.0, -11.0>
  }
  box { // Cube700
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate -45.0*x
    translate  <0.0, -1.0, 1.0>
  }
  box { // Cube701
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate 45.0*x
    translate  <0.0, -8.0, -16.0>
  }
  box { // Cube702
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  -22.0*z
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate -90.0*y
    translate  1.0*x
  }
  // Scaling fixed
  // Rot X limited (-120.0 to   -75.0)
  // Translation fixed
  rotate TransporterClawRotation
  translate  <0.0, -1.0, 7.0>
}


#declare Cylndr312 = object {
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <6.0, 6.0, 0.5>
  }
}
#declare CSG239 = union {
  object { Cylndr312 }
  object { // Cylndr313->Cylndr312
    Cylndr312
    rotate -10.0*y
  }
  object { // Cylndr314->Cylndr312
    Cylndr312
    rotate -20.0*y
  }
  object { // Cylndr315->Cylndr312
    Cylndr312
    rotate -30.0*y
  }
  object { // Cylndr316->Cylndr312
    Cylndr312
    rotate -40.0*y
  }
  object { // Cylndr317->Cylndr312
    Cylndr312
    rotate -50.0*y
  }
  object { // Cylndr318->Cylndr312
    Cylndr312
    rotate -60.0*y
  }
  object { // Cylndr319->Cylndr312
    Cylndr312
    rotate -70.0*y
  }
  object { // Cylndr320->Cylndr312
    Cylndr312
    rotate -80.0*y
  }
  object { // Cylndr321->Cylndr312
    Cylndr312
    rotate -90.0*y
  }
  object { // Cylndr322->Cylndr312
    Cylndr312
    rotate <180.0, -80.0, 180.0>
  }
  object { // Cylndr323->Cylndr312
    Cylndr312
    rotate <180.0, -70.0, 180.0>
  }
  object { // Cylndr324->Cylndr312
    Cylndr312
    rotate <180.0, -60.0, 180.0>
  }
  object { // Cylndr325->Cylndr312
    Cylndr312
    rotate <180.0, -50.0, 180.0>
  }
  object { // Cylndr326->Cylndr312
    Cylndr312
    rotate <180.0, -40.0, 180.0>
  }
  object { // Cylndr327->Cylndr312
    Cylndr312
    rotate <180.0, -30.0, 180.0>
  }
  object { // Cylndr328->Cylndr312
    Cylndr312
    rotate <180.0, -20.0, 180.0>
  }
  object { // Cylndr329->Cylndr312
    Cylndr312
    rotate <180.0, -10.0, 180.0>
  }
}
#declare CSG240 = intersection {
  object { CSG239 }
  box { // Cube721
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 4.0, 6.0>
  }
  translate  -0.1*z
}
#declare Wheel24 = union {
  object { CSG240 }
  sphere { // Sphere061
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    scale 5.5
    translate  -0.1*z
  }
  // Scaling fixed
  // Translation fixed
  rotate BuggyWheelRotation
}
#declare Wheels1 = union {
  object { Wheel24 }
  object { // Wheel25->Wheel24
    Wheel24
    rotate <180.0, -60.0, 180.0>
    translate  13.0*x
  }
  object { // Wheel26->Wheel24
    Wheel24
    rotate <180.0, 60.0, 180.0>
    translate  26.0*x
  }
  material {
    Black
  }
  // All transformations fixed
  translate  <-13.0, -12.5, 6.5>
}
#declare Cube731 = object {
  box { // Cube731
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 7.0, 5.0>
    translate  <-2.0, 0.0, 5.0>
  }
}


#declare Claw3 = object {
  cylinder { // Claw3
    <0,0,1>, <0,0,0>, 1 
    // Scaling fixed
    // Rot X limited (90.0 to     135.0)
    // Translation fixed
    scale <0.2, 0.5, 10.0>
    rotate ForkLiftClawRotation
    translate  <8.5, -29.0, 1.0>
  }
}


// The following include file contains the definition for TaperSweep001
#include "xfinal.in1"
#declare TaperSweep001 = object {
  TaperSweep001_Raw
  scale <1.0, 3.0, 12.0>
  rotate -180.0*x
  translate  12.0*z
}
#declare CSG250 = difference {
  object { TaperSweep001 }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 2.5>
    rotate 90.0*y
    translate  <-1.25, 0.0, 0.25>
  }
  translate  -14.0*z
}
#declare CSG251 = union {
  box { // Cube746
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 2.5, 1.5>
    translate  12.5*z
  }
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    scale 2.5
    rotate 90.0*y
    translate  <-1.25, 0.0, 14.0>
  }
}
#declare CSG252 = difference {
  object { CSG251 }
  box { // Cube747
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    scale <1.00001, 1.5, 1.0>
    translate  <1.0, 0.0, 12.0>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*y
    translate  14.0*z
  }
  translate  -14.0*z
}
#declare Arm1 = union {
  object { CSG250 }
  box { // Cube743
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  -10.0*z
  }
  box { // Cube744
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 1.0, 4.0>
    translate  -6.0*z
  }
  box { // Cube745
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  -3.0*z
  }
  object { CSG252 }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
  scale 1.2
  rotate KongBotArmRotation
  translate  10.2*x
}


#declare CSG261 = difference {
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 5.0>
    rotate 90.0*x
    translate  <6.0, 2.5, -6.0>
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, 4.25, -6.0>
  }
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, -2.25, -6.0>
  }
}
#declare Arm3 = union {
  sphere { // Sphere092
    <0,0,0>,1
    scale 3.0
  }
  sphere { // Sphere093
    <0,0,0>,1
    scale 0.5
    translate  <5.0, 1.0, -15.5>
  }
  sphere { // Sphere094
    <0,0,0>,1
    scale 0.5
    translate  <7.0, 1.0, -15.5>
  }
  sphere { // Sphere095
    <0,0,0>,1
    scale 0.5
    translate  <8.0, 1.0, -14.5>
  }
  sphere { // Sphere096
    <0,0,0>,1
    scale 0.5
    translate  <4.0, 1.0, -14.5>
  }
  sphere { // Sphere097
    <0,0,0>,1
    scale <2.5, 2.5, 1.5>
    translate  <6.0, 0.0, -14.0>
  }
  cone { // Cone022
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    translate  <6.0, 0.0, -6.0>
  }
  cone { // Cone023
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    rotate -45.0*y
  }
  object { CSG261 }
  sphere { // Sphere098
    <0,0,0>,1
    scale 0.833333
    rotate 0.0*y
    translate  <1.666667, 0.0, 2.5>
  }
  // Scaling fixed
  // Rot Y limited (0.0 to   20.0)
  // Translation fixed
  scale 1.2
  rotate <30.0, 20.0, 0.0>
  translate  <14.0, 0.0, -8.0>
}
#declare CSG262 = difference {
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    scale <3.5, 3.5, 4.0>
    translate  -15.5*z
  }
  box { // Cube769
    <-1, -1, -1>, <1, 1, 1>
    scale 4.0
    translate  <-5.0, 0.0, -14.0>
  }
}
#declare Leg2 = union {
  object { CSG262 }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*y
    translate  <3.0, 0.0, -13.5>
  }
  box { // Cube770
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 6.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -9.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 9.0, -18.0>
    material {
      Black
    }
  }
  box { // Cube771
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <-45.0, -0.0, 0.0>
    translate  <2.5, 11.0, -16.0>
  }
  box { // Cube772
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <45.0, -0.0, 0.0>
    translate  <2.5, -11.0, -16.0>
  }
  box { // Cube773
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 10.0, 0.5>
    translate  <2.5, 0.0, -15.0>
  }
  // All transformations fixed
  translate  <8.0, 0.0, -20.0>
}


#declare CSG263 = difference {
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 4.5>
    translate  0.25*z
  }
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    translate  -0.5*z
  }
}
#declare CSG264 = difference {
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 5.0>
  }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 6.0>
    translate  -0.5*z
  }
  material {
    White
  }
}
#declare Cube785 = object {
  box { // Cube785
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    translate  <6.0, 0.0, 1.0>
  }
}
#declare Cube795 = object {
  box { // Cube795
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    rotate -18.0*z
    translate  <5.706339, -1.854102, 4.0>
  }
}
#declare Wheel27 = union {
  object { CSG263 }
  object { CSG264 }
  box { // Cube783
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <0.5, 3.0, 2.0>
    translate  2.5*z
  }
  box { // Cube784
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <3.0, 0.5, 2.0>
    translate  2.5*z
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <1.0, 1.0, 5.0>
  }
  object { Cube785 }
  object { // Cube786->Cube785
    Cube785
    rotate -36.0*z
  }
  object { // Cube787->Cube785
    Cube785
    rotate -72.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube788->Cube785
    Cube785
    rotate -108.0*z
    translate  0.0*x
  }
  object { // Cube789->Cube785
    Cube785
    rotate -144.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube790->Cube785
    Cube785
    rotate 180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube791->Cube785
    Cube785
    rotate 144.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube792->Cube785
    Cube785
    rotate 108.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube793->Cube785
    Cube785
    rotate 72.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube794->Cube785
    Cube785
    rotate 36.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { Cube795 }
  object { // Cube796->Cube795
    Cube795
    rotate <-0.0, 0.0, -36.0>
    translate  0.0*x
  }
  object { // Cube797->Cube795
    Cube795
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube798->Cube795
    Cube795
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube799->Cube795
    Cube795
    rotate <0.0, 0.0, -144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube800->Cube795
    Cube795
    rotate <0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube801->Cube795
    Cube795
    rotate <0.0, 0.0, 144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube802->Cube795
    Cube795
    rotate <0.0, 0.0, 108.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube803->Cube795
    Cube795
    rotate <0.0, 0.0, 72.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube804->Cube795
    Cube795
    rotate <-0.0, 0.0, 36.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Translation fixed
  rotate LegoWheelRotation
  translate  <-10.0, -9.0, 0.0>
}
#declare Wheelset = union {
  object { Wheel27 }
  object { // Wheel28->Wheel27
    Wheel27
    // All transformations fixed
    rotate -0.0*z
    translate  18.0*y
  }
  material {
    Black
  }
  // All transformations fixed
}
#declare CSG265 = difference {
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    rotate 90.0*y
    translate  <11.0, 21.0, 10.0>
  }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <10.0, 22.0, 11.0>
  }
  material {
    Black
  }
  translate  3.0*y
}
#declare CSG266 = difference {
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <8.0, 3.0, 18.0>
  }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 6.0>
    rotate 90.0*y
    translate  <9.0, 3.0, 18.0>
  }
}
#declare CSG267 = difference {
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    scale 2.7
    rotate 90.0*y
    translate  <-1.35, 0.0, 17.0>
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    scale <1.8, 1.8, 4.0>
    rotate 90.0*y
    translate  <-2.0, 0.0, 18.5>
  }
}
#declare Wrench = union {
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 15.0>
  }
  object { CSG267 }
  // Scaling fixed
  // Rot X limited (-120.0 to   120.0)
  // Translation fixed
  rotate LegoWrenchRotation
  translate  <12.5, 3.0, 18.0>
}
#declare Attachments = union {
  box { // Cube805
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    translate  <9.0, 13.0, 10.0>
  }
  box { // Cube806
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    translate  <9.0, 1.0, 10.0>
  }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <1.5, 1.5, 23.0>
    rotate -90.0*x
    translate  <12.0, -1.0, 10.0>
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale 2.5
    rotate -90.0*x
    translate  <12.0, 12.0, 10.0>
  }
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale 2.5
    rotate -90.0*x
    translate  <12.0, 0.0, 10.0>
  }
  box { // Cube807
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.5>
    translate  <9.0, -8.0, 15.0>
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.9, 6.0>
    rotate 90.0*y
    translate  <6.0, 3.0, 18.0>
  }
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 13.0>
    rotate 90.0*x
    translate  <10.0, -5.0, 15.0>
  }
  object { CSG265 }
  object { CSG266 }
  cone { // Cone024
    <0,0,0>, 3.8, <0,0,1>, 2.0
    scale <1.0, 1.0, 3.0>
    rotate 90.0*y
    translate  <8.0, 3.0, 18.0>
  }
  object { Wrench }
  // All transformations fixed
}


#declare Claw5 = object {
  cylinder { // Claw5
    <0,0,1>, <0,0,0>, 1 
    // Scaling fixed
    // Rot X limited (90.0 to     135.0)
    // Translation fixed
    scale <0.2, 0.5, 10.0>
    rotate <90.0, 90.0, 0.0>
    translate  <8.5, -29.0, 1.0>
  }
}


#declare Cylndr428 = object {
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <2.0, 2.0, 20.0>
    translate  <0.0, -17.0, 70.0>
  }
}
#declare Group002 = union {
  cone { // Cone025
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
}
#declare Group003 = union {
  cone { // Cone026
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  scale <1.0, 1.0, -1.0>
  translate  80.0*z
}
#declare Group004 = union {
  object { Group002 }
  object { Group003 }
  torus { // Torus028
    1.5, 0.5  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 4.0
    translate  <0.0, -29.5, 40.0>
  }
  torus { // Torus029
    1.5, 1.0  rotate -x*90
    scale 4.0
    rotate -90.0*y
    translate  <0.0, -15.0, 57.0>
  }
  sphere { // Sphere100
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <2.0, 2.0, 6.0>
    rotate -25.0*x
    translate  <0.0, -30.0, 49.0>
  }
}
#declare Torus030 = object {
  torus { // Torus030
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <24.0, 0.0, 8.0>
  }
}
#declare Torus033 = object {
  torus { // Torus033
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <22.0, 0.0, 68.0>
  }
}
#declare CSG271 = intersection {
  box { // Cube815
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  1.428571*y
    scale <5.0, 7.0, 5.0>
  }
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale 10.0
  }
}
#declare Blade4 = intersection {
  box { // Cube814
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 0.1>
    rotate 15.0*y
  }
  object { CSG271 }
  material {
    White
  }
}


#declare CSG272 = difference {
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 30.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  11.0*x
  }
}
#declare Wheel29 = union {
  object { CSG272 }
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <13.0, 13.0, 15.0>
    rotate 90.0*y
    translate  -7.5*x
  }
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  box { // Cube816
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <-30.0, 0.0, 0.0>
    translate  0.0*y
  }
  box { // Cube817
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 14.0>
    rotate 0.0*z
    translate  0.0*y
  }
  box { // Cube818
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <30.0, -0.0, -0.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Rot X limited (0.0 to   60.0)
  // Translation fixed
  translate  <60.0, -15.5, -5.0>
}
#declare Track10 = union {
  box { // Cube828
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate -45.0*x
    translate  <-60.0, 77.5, 10.75>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-15.5 to   0.0)
}
#declare Other_Tracks1 = union {
  object { // Track11->Track10
    Track10
    translate  -15.5*y
  }
  object { // Track12->Track10
    Track10
    translate  -31.0*y
  }
  object { // Track13->Track10
    Track10
    translate  -46.5*y
  }
  object { // Track14->Track10
    Track10
    translate  -62.0*y
  }
  object { // Track15->Track10
    Track10
    translate  -77.5*y
  }
  object { // Track16->Track10
    Track10
    translate  -93.0*y
  }
  object { // Track17->Track10
    Track10
    translate  -108.5*y
  }
  object { // Track18->Track10
    Track10
    translate  -124.0*y
  }
  object { // Track19->Track10
    Track10
    translate  -139.5*y
  }
  // All transformations fixed
}
#declare Trackside4 = union {
  object { Track10 }
  object { Other_Tracks1 }
  // All transformations fixed
}
#declare TrackB3 = union {
  box { // Cube829
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate <135.0, 0.0, -0.0>
    translate  <-60.0, 0.0, -15.75>
  }
  // Scaling fixed
  // Rot X limited (-180.0 to   -120.0)
  // Translation fixed
  rotate <-180.0, -180.0, -180.0>
  translate  <0.0, 77.5, -5.0>
}
#declare Other_TrackBs1 = union {
  object { // TrackB4->TrackB3
    TrackB3
    rotate <120.0, 0.0, -0.0>
    translate  <0.0, 111.919873, -74.616969>
  }
  object { // TrackB5->TrackB3
    TrackB3
    rotate <60.0, -0.0, -0.0>
    translate  <-0.0, 34.419873, -69.616969>
  }
  // All transformations fixed
}
#declare Trackend4 = union {
  object { TrackB3 }
  object { Other_TrackBs1 }
  // All transformations fixed
}
#declare CSG277 = difference {
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG278 = intersection {
  object { CSG277 }
  box { // Cube833
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate 30.0*x
    translate  <60.0, -80.0, -3.0>
  }
}
#declare CSG279 = difference {
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG280 = intersection {
  object { CSG279 }
  box { // Cube834
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate -150.0*x
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 50.0, 30.0>
}
#declare CSG281 = difference {
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG282 = intersection {
  object { CSG281 }
  box { // Cube835
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate <30.0, 0.0, -0.0>
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 76.0, 15.0>
}
#declare CSG283 = difference {
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG284 = intersection {
  object { CSG283 }
  box { // Cube836
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate <-30.0, -0.0, -0.0>
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 146.0, 15.0>
}
#declare CSG285 = union {
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -93.0, 4.5>
  }
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 30.0>
    rotate 90.0*y
    translate  <45.0, 89.0, 2.25>
  }
  box { // Cube830
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 10.0>
    rotate 30.0*x
    translate  <60.0, 89.0, 2.25>
  }
  box { // Cube831
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 35.0>
    rotate 90.0*x
    translate  <60.0, 66.0, 27.0>
  }
  box { // Cube832
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 25.0>
    rotate 90.0*x
    translate  <60.0, -30.0, 12.0>
  }
  object { CSG278 }
  object { CSG280 }
  object { CSG282 }
  object { CSG284 }
  scale <1.0, 1.0, 0.5>
  translate  5.0*z
}
#declare CSG286 = intersection {
  torus { // Torus039
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube837
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <150.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 146.0, 15.0>
}
#declare CSG287 = intersection {
  torus { // Torus040
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube838
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <210.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 76.0, 15.0>
}
#declare CSG288 = intersection {
  torus { // Torus041
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube839
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <30.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 50.0, 30.0>
}
#declare CSG289 = intersection {
  torus { // Torus042
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube840
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate 30.0*x
    translate  <75.0, -80.0, -3.0>
  }
}
#declare CSG290 = union {
  object { CSG286 }
  object { CSG287 }
  object { CSG288 }
  object { CSG289 }
  sphere { // Sphere102
    <0,0,0>,1
    scale 5.0
    translate  <75.0, -93.0, 4.5>
  }
  sphere { // Sphere103
    <0,0,0>,1
    scale 5.0
    translate  <75.0, 89.0, 2.25>
  }
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 50.0>
    rotate 90.0*x
    translate  <75.0, -30.0, 12.0>
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 70.0>
    rotate 90.0*x
    translate  <75.0, 66.0, 27.0>
  }
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 20.0>
    rotate <-150.0, 0.0, -0.0>
    translate  <75.0, 79.0, 19.5>
  }
  scale <1.0, 1.0, 0.5>
  translate  5.0*z
}
#declare CSG292 = union {
  object { CSG285 }
  object { CSG290 }
  object { // CSG291->CSG290
    CSG290
    translate  -30.0*x
  }
}
#declare CSG294 = difference {
  object { CSG292 }
  object { // CSG293->CSG292
    CSG292
    translate  -2.0*z
  }
}
#declare CSG295 = difference {
  sphere { // Sphere106
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere107
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube843
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar = union {
  object { CSG295 }
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere108
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone030
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  material {
    T_Chrome_3A
  }
  scale 0.8
  rotate <-30.0, 0.0, -30.0>
  translate  <-60.0, -31.0, 17.0>
}
#declare CSG296 = difference {
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    scale 5.0
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare MudGuard = union {
  object { CSG294 }
  cone { // Cone028
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      T_Chrome_3A
    }
    scale <10.0, 3.0, 15.0>
    rotate <-90.0, 0.0, -0.0>
    translate  <60.0, 58.0, 21.0>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <2.0, 1.0, 15.0>
    rotate 90.0*x
    translate  <60.0, 62.0, 21.0>
  }
  sphere { // Sphere104
    <0,0,0>,1
    material {
      Black_Rubber
    }
    scale <2.0, 1.0, 1.0>
    translate  <60.0, 47.0, 21.0>
  }
  sphere { // Sphere105
    <0,0,0>,1
    material {
      Black_Rubber
    }
    scale <2.0, 1.0, 1.0>
    translate  <60.0, 62.0, 21.0>
  }
  cone { // Cone029
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      T_Chrome_3A
    }
    scale <5.0, 5.0, 15.0>
    rotate 90.0*x
    translate  <-65.0, -55.0, 13.0>
  }
  box { // Cube841
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-69.0, 12.0, 21.0>
  }
  box { // Cube842
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-69.0, 47.0, 21.0>
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-69.0, 50.0, 26.0>
  }
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-69.0, 15.0, 26.0>
  }
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <2.0, 2.0, 47.0>
    rotate 90.0*x
    translate  <-69.0, 53.0, 26.0>
  }
  object { Radar }
  sphere { // Sphere109
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    scale <2.0, 2.0, 10.0>
    translate  <-60.0, -31.0, 9.0>
  }
  object { CSG296 }
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    material {
      Translucent
    }
    scale 4.0
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  // All transformations fixed
  translate  22.16*z
}
#declare Cylndr502 = object {
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 1.0>
    rotate 90.0*x
    translate  -80.0*y
  }
}
#declare Cylndr510 = object {
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    material {
      RedClear
    }
    scale <5.0, 5.0, 0.5>
    rotate 90.0*x
    translate  -80.25*y
  }
}
#declare Cylndr518 = object {
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 100.0>
    rotate 90.0*x
    translate  2.0*z
  }
}
#declare CSG297 = difference {
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    rotate 90.0*x
  }
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 101.0>
    rotate 90.0*x
  }
}
#declare Gun = union {
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <4.0, 4.0, 30.0>
    rotate 90.0*x
  }
  object { Cylndr502 }
  object { // Cylndr503->Cylndr502
    Cylndr502
    translate  -2.0*y
  }
  object { // Cylndr504->Cylndr502
    Cylndr502
    translate  -4.0*y
  }
  object { // Cylndr505->Cylndr502
    Cylndr502
    translate  -6.0*y
  }
  object { // Cylndr506->Cylndr502
    Cylndr502
    translate  -8.0*y
  }
  object { // Cylndr507->Cylndr502
    Cylndr502
    translate  -10.0*y
  }
  object { // Cylndr508->Cylndr502
    Cylndr502
    translate  -12.0*y
  }
  object { // Cylndr509->Cylndr502
    Cylndr502
    material {
      RedClear
    }
    translate  -14.0*y
  }
  object { Cylndr510 }
  object { // Cylndr511->Cylndr510
    Cylndr510
    translate  -2.0*y
  }
  object { // Cylndr512->Cylndr510
    Cylndr510
    translate  -4.0*y
  }
  object { // Cylndr513->Cylndr510
    Cylndr510
    translate  -6.0*y
  }
  object { // Cylndr514->Cylndr510
    Cylndr510
    translate  -8.0*y
  }
  object { // Cylndr515->Cylndr510
    Cylndr510
    translate  -10.0*y
  }
  object { // Cylndr516->Cylndr510
    Cylndr510
    translate  -12.0*y
  }
  object { // Cylndr517->Cylndr510
    Cylndr510
    translate  -14.0*y
  }
  object { Cylndr518 }
  object { // Cylndr519->Cylndr518
    Cylndr518
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr520->Cylndr518
    Cylndr518
    rotate <-180.0, -60.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr521->Cylndr518
    Cylndr518
    rotate <180.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr522->Cylndr518
    Cylndr518
    rotate <-180.0, 60.0, 180.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr523->Cylndr518
    Cylndr518
    rotate 60.0*y
    translate  <0.0, -0.0, -0.0>
  }
  object { CSG297 }
  material {
    T_Chrome_3A
  }
  // Scaling fixed
  // Rot X limited (-25.0 to   0.0)
  // Translation fixed
  rotate -10.0*x
  translate  <25.0, 0.0, 45.0>
}
#declare CSG308 = difference {
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 40.0>
    rotate 90.0*x
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 42.0>
    rotate 90.0*x
    translate  1.0*y
  }
  box { // Cube868
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 24.0, 7.0>
    translate  <0.0, -20.0, 7.0>
  }
  material {
    T_Chrome_3A
  }
  translate  <-30.0, 15.0, 12.0>
}
#declare CSG309 = intersection {
  torus { // Torus048
    9.0, 2.0  rotate -x*90
    rotate -90.0*y
    translate  <-30.0, 20.0, 3.0>
  }
  box { // Cube869
    <-1, -1, -1>, <1, 1, 1>
    scale 6.0
    translate  <-30.0, 26.0, 9.0>
  }
}
#declare Group016 = union {
  box { // Cube867
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-30.0, 12.0, 4.0>
  }
  object { CSG308 }
  object { CSG309 }
  cylinder { // Cylndr531
    <0,0,1>, <0,0,0>, 1 
    material {
      RedClear
    }
    scale <4.0, 4.0, 1.0>
    rotate 90.0*x
    translate  <-30.0, 20.0, 12.0>
  }
  cylinder { // Cylndr532
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <7.0, 7.0, 1.0>
    rotate 90.0*x
    translate  <-30.0, 19.0, 12.0>
  }
}
#declare Cube871 = object {
  box { // Cube871
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  <0.0, -5.0, -11.5>
  }
}
#declare CSG310 = difference {
  cylinder { // Cylndr537
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.0>
    translate  -38.0*z
  }
  cylinder { // Cylndr538
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <2.5, 2.5, 3.0>
    translate  -39.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Fuselage1 = union {
  cylinder { // Cylndr535
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <4.0, 4.0, 30.0>
    translate  -36.0*z
  }
  sphere { // Sphere112
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 15.0>
    translate  25.0*z
  }
  cylinder { // Cylndr536
    <0,0,1>, <0,0,0>, 1 
    material {
      ForeSection
    }
    scale <5.0, 5.0, 25.0>
  }
  sphere { // Sphere113
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 40.0>
  }
  sphere { // Sphere114
    <0,0,0>,1
    material {
      JetBlack
    }
    scale 2.0
    translate  38.5*z
  }
  object { CSG310 }
  object { Cube871 }
  object { // Cube872->Cube871
    Cube871
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube873->Cube871
    Cube871
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube874->Cube871
    Cube871
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube875->Cube871
    Cube871
    rotate 0.0*x
    translate  <0.0, -0.0, -16.0>
  }
  object { // Cube876->Cube871
    Cube871
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -16.0>
  }
  object { // Cube877->Cube871
    Cube871
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -16.0>
  }
  object { // Cube878->Cube871
    Cube871
    rotate <0.0, 0.0, -270.0>
    translate  <0.0, -0.0, -16.0>
  }
  material {
    White
  }
  // All transformations fixed
}
#declare CSG311 = difference {
  box { // Cube879
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 10.0>
    translate  <0.0, -10.0, -12.0>
  }
  box { // Cube880
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.4, 15.0, 7.0>
    rotate 60.0*x
    translate  <0.0, -15.0, -22.0>
  }
  // All transformations fixed
}
#declare Rudder1 = union {
  box { // Cube882
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 2.0>
    translate  <0.0, -10.0, -34.5>
  }
  translate  <0.0, 10.0, 32.5>
  material {
    Grey
  }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  translate  <0.0, -10.0, -33.0>
}
#declare RearFin4 = union {
  object { CSG311 }
  box { // Cube881
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.2, 5.0, 5.0>
    translate  <0.0, -10.0, -27.0>
  }
  object { Rudder1 }
  cylinder { // Cylndr539
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -28.0>
  }
  cylinder { // Cylndr540
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -12.0>
  }
  translate  6.0*y
  material {
    FinMarkings
  }
  // Scaling fixed
  // Rot Z limited (-125.0 to   0.0)
  // Translation fixed
  rotate -125.0*z
  translate  -6.0*y
}
#declare FrontFin4 = union {
  box { // Cube883
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 4.0, 2.0>
    rotate -60.0*x
    translate  <0.0, -8.0, 23.0>
  }
  box { // Cube884
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 2.0, 3.0>
    rotate -45.0*x
    translate  <0.0, -8.0, 27.0>
  }
  box { // Cube885
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 2.0>
    translate  <0.0, -6.0, 25.0>
  }
  material {
    Grey
  }
  // All transformations fixed
}
#declare Missile = union {
  object { Fuselage1 }
  object { RearFin4 }
  object { FrontFin4 }
  object { // FrontFin5->FrontFin4
    FrontFin4
    // All transformations fixed
    rotate -90.0*z
  }
  object { // FrontFin6->FrontFin4
    FrontFin4
    // All transformations fixed
    rotate 180.0*z
  }
  object { // FrontFin7->FrontFin4
    FrontFin4
    // All transformations fixed
    rotate 90.0*z
  }
  object { // RearFin5->RearFin4
    RearFin4
    // All transformations fixed
    rotate -90.0*z
  }
  object { // RearFin6->RearFin4
    RearFin4
    // All transformations fixed
    rotate 180.0*z
  }
  object { // RearFin7->RearFin4
    RearFin4
    // All transformations fixed
    rotate 90.0*z
  }
  scale <0.7, 0.7, 1.0>
  rotate 90.0*x
  translate  <30.0, -22.0, 12.0>
}
#declare TransSweep041 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, -1.0>,
  <1.0, -1.0>,
  <0.0, 1.0>,
  <-1.0, 1.0>,
  <-0.5, -1.0>
  rotate -x*90
  scale <10.0, 6.0, 2.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-22.0, 15.0, 9.0>
}
#declare CSG312 = difference {
  object { TransSweep041 }
  cylinder { // Cylndr542
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 15.0, 6.0>
  }
  cylinder { // Cylndr543
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 17.0, 9.0>
  }
  cylinder { // Cylndr544
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 19.0, 12.0>
  }
}
#declare Stand = union {
  object { CSG312 }
  box { // Cube887
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 6.0, 1.0>
    translate  <-23.0, 20.0, 15.0>
  }
  box { // Cube888
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 8.0, 1.0>
    translate  <-23.0, 13.0, 3.0>
  }
  cylinder { // Cylndr545
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 20.0, 18.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}


#declare Cube889 = object {
  box { // Cube889
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  <0.0, -5.0, -11.5>
  }
}
#declare CSG314 = difference {
  box { // Cube897
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 10.0>
    translate  <0.0, -10.0, -12.0>
  }
  box { // Cube898
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.4, 15.0, 7.0>
    rotate 60.0*x
    translate  <0.0, -15.0, -22.0>
  }
  // All transformations fixed
}
#declare Rudder = union {
  box { // Cube900
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 2.0>
    translate  <0.0, -10.0, -34.5>
  }
  translate  <0.0, 10.0, 32.5>
  material {
    Grey
  }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  translate  <0.0, -10.0, -33.0>
}
#declare RearFin = union {
  object { CSG314 }
  box { // Cube899
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.2, 5.0, 5.0>
    translate  <0.0, -10.0, -27.0>
  }
  object { Rudder }
  cylinder { // Cylndr550
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -28.0>
  }
  cylinder { // Cylndr551
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -12.0>
  }
  translate  6.0*y
  material {
    FinMarkings
  }
  // Scaling fixed
  // Rot Z limited (-125.0 to   0.0)
  // Translation fixed
  translate  -6.0*y
}
#declare FrontFin = union {
  box { // Cube901
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 4.0, 2.0>
    rotate -60.0*x
    translate  <0.0, -8.0, 23.0>
  }
  box { // Cube902
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 2.0, 3.0>
    rotate -45.0*x
    translate  <0.0, -8.0, 27.0>
  }
  box { // Cube903
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 2.0>
    translate  <0.0, -6.0, 25.0>
  }
  material {
    Grey
  }
  // All transformations fixed
}


#declare CSG357 = difference {
  cylinder { // Cylndr618
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 5.0>
    rotate 90.0*x
    translate  <6.0, 2.5, -6.0>
  }
  cylinder { // Cylndr619
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, 4.25, -6.0>
  }
  cylinder { // Cylndr620
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, -2.25, -6.0>
  }
}
#declare Arm5 = union {
  sphere { // Sphere140
    <0,0,0>,1
    scale 3.0
  }
  sphere { // Sphere141
    <0,0,0>,1
    scale 0.5
    translate  <5.0, 1.0, -15.5>
  }
  sphere { // Sphere142
    <0,0,0>,1
    scale 0.5
    translate  <7.0, 1.0, -15.5>
  }
  sphere { // Sphere143
    <0,0,0>,1
    scale 0.5
    translate  <8.0, 1.0, -14.5>
  }
  sphere { // Sphere144
    <0,0,0>,1
    scale 0.5
    translate  <4.0, 1.0, -14.5>
  }
  sphere { // Sphere145
    <0,0,0>,1
    scale <2.5, 2.5, 1.5>
    translate  <6.0, 0.0, -14.0>
  }
  cone { // Cone040
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    translate  <6.0, 0.0, -6.0>
  }
  cone { // Cone041
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    rotate -45.0*y
  }
  object { CSG357 }
  sphere { // Sphere146
    <0,0,0>,1
    scale 0.833333
    rotate 0.0*y
    translate  <1.666667, 0.0, 2.5>
  }
  // Scaling fixed
  // Rot Y limited (0.0 to   20.0)
  // Translation fixed
  scale 1.2
  rotate <30.0, 20.0, 0.0>
  translate  <14.0, 0.0, -8.0>
}
#declare CSG358 = difference {
  cylinder { // Cylndr621
    <0,0,1>, <0,0,0>, 1 
    scale <3.5, 3.5, 4.0>
    translate  -15.5*z
  }
  box { // Cube975
    <-1, -1, -1>, <1, 1, 1>
    scale 4.0
    translate  <-5.0, 0.0, -14.0>
  }
}
#declare Leg8 = union {
  object { CSG358 }
  cylinder { // Cylndr622
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*y
    translate  <3.0, 0.0, -13.5>
  }
  box { // Cube976
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 6.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr623
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr624
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr625
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -9.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr626
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 9.0, -18.0>
    material {
      Black
    }
  }
  box { // Cube977
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <-45.0, -0.0, 0.0>
    translate  <2.5, 11.0, -16.0>
  }
  box { // Cube978
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <45.0, -0.0, 0.0>
    translate  <2.5, -11.0, -16.0>
  }
  box { // Cube979
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 10.0, 0.5>
    translate  <2.5, 0.0, -15.0>
  }
  // All transformations fixed
  translate  <8.0, 0.0, -20.0>
}


#declare Cylndr627 = object {
  cylinder { // Cylndr627
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <2.0, 2.0, 20.0>
    translate  <0.0, -17.0, 70.0>
  }
}
#declare Group020 = union {
  cone { // Cone042
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr651
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
}
#declare Group021 = union {
  cone { // Cone043
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr652
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  scale <1.0, 1.0, -1.0>
  translate  80.0*z
}
#declare Group022 = union {
  object { Group020 }
  object { Group021 }
  torus { // Torus059
    1.5, 0.5  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 4.0
    translate  <0.0, -29.5, 40.0>
  }
  torus { // Torus060
    1.5, 1.0  rotate -x*90
    scale 4.0
    rotate -90.0*y
    translate  <0.0, -15.0, 57.0>
  }
  sphere { // Sphere148
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <2.0, 2.0, 6.0>
    rotate -25.0*x
    translate  <0.0, -30.0, 49.0>
  }
}
#declare Torus061 = object {
  torus { // Torus061
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <24.0, 0.0, 8.0>
  }
}
#declare Torus064 = object {
  torus { // Torus064
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <22.0, 0.0, 68.0>
  }
}
#declare CSG362 = intersection {
  box { // Cube985
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  1.428571*y
    scale <5.0, 7.0, 5.0>
  }
  cylinder { // Cylndr661
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale 10.0
  }
}
#declare Blade8 = intersection {
  box { // Cube984
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 0.1>
    rotate 15.0*y
  }
  object { CSG362 }
  material {
    White
  }
}


#declare Cylndr662 = object {
  cylinder { // Cylndr662
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <2.0, 2.0, 20.0>
    translate  <0.0, -17.0, 70.0>
  }
}
#declare Group034 = union {
  cone { // Cone045
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr686
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
}
#declare Group035 = union {
  cone { // Cone046
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <7.0, 7.0, 25.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  cylinder { // Cylndr687
    <0,0,1>, <0,0,0>, 1 
    material {
      Aluminum
    }
    scale <6.0, 6.0, 2.0>
    rotate 25.0*x
    translate  <0.0, -20.0, 20.0>
  }
  scale <1.0, 1.0, -1.0>
  translate  80.0*z
}
#declare Group036 = union {
  object { Group034 }
  object { Group035 }
  torus { // Torus070
    1.5, 0.5  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 4.0
    translate  <0.0, -29.5, 40.0>
  }
  torus { // Torus071
    1.5, 1.0  rotate -x*90
    scale 4.0
    rotate -90.0*y
    translate  <0.0, -15.0, 57.0>
  }
  sphere { // Sphere151
    <0,0,0>,1
    material {
      Aluminum
    }
    scale <2.0, 2.0, 6.0>
    rotate -25.0*x
    translate  <0.0, -30.0, 49.0>
  }
}
#declare Torus072 = object {
  torus { // Torus072
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <24.0, 0.0, 8.0>
  }
}
#declare Torus075 = object {
  torus { // Torus075
    1.5, 0.2  rotate -x*90
    material {
      Tinny_Brass
    }
    scale 3.0
    translate  <22.0, 0.0, 68.0>
  }
}
#declare CSG366 = intersection {
  box { // Cube991
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*z
    translate  1.428571*y
    scale <5.0, 7.0, 5.0>
  }
  cylinder { // Cylndr696
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale 10.0
  }
}
#declare Blade12 = intersection {
  box { // Cube990
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 0.1>
    rotate 15.0*y
  }
  object { CSG366 }
  material {
    White
  }
}


#declare CSG373 = difference {
  cylinder { // Cylndr710
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 5.0>
    rotate 90.0*x
    translate  <6.0, 2.5, -6.0>
  }
  cylinder { // Cylndr711
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, 4.25, -6.0>
  }
  cylinder { // Cylndr712
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 2.0>
    rotate 90.0*x
    translate  <6.0, -2.25, -6.0>
  }
}
#declare Arm7 = union {
  sphere { // Sphere160
    <0,0,0>,1
    scale 3.0
  }
  sphere { // Sphere161
    <0,0,0>,1
    scale 0.5
    translate  <5.0, 1.0, -15.5>
  }
  sphere { // Sphere162
    <0,0,0>,1
    scale 0.5
    translate  <7.0, 1.0, -15.5>
  }
  sphere { // Sphere163
    <0,0,0>,1
    scale 0.5
    translate  <8.0, 1.0, -14.5>
  }
  sphere { // Sphere164
    <0,0,0>,1
    scale 0.5
    translate  <4.0, 1.0, -14.5>
  }
  sphere { // Sphere165
    <0,0,0>,1
    scale <2.5, 2.5, 1.5>
    translate  <6.0, 0.0, -14.0>
  }
  cone { // Cone050
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    translate  <6.0, 0.0, -6.0>
  }
  cone { // Cone051
    <0,0,0>, 1.2, <0,0,1>, 1.5
    translate  -1.0*z
    scale <1.5, 1.5, 8.0>
    rotate -45.0*y
  }
  object { CSG373 }
  sphere { // Sphere166
    <0,0,0>,1
    scale 0.833333
    rotate 0.0*y
    translate  <1.666667, 0.0, 2.5>
  }
  // Scaling fixed
  // Rot Y limited (0.0 to   20.0)
  // Translation fixed
  scale 1.2
  rotate <30.0, 20.0, 0.0>
  translate  <14.0, 0.0, -8.0>
}
#declare CSG374 = difference {
  cylinder { // Cylndr713
    <0,0,1>, <0,0,0>, 1 
    scale <3.5, 3.5, 4.0>
    translate  -15.5*z
  }
  box { // Cube1001
    <-1, -1, -1>, <1, 1, 1>
    scale 4.0
    translate  <-5.0, 0.0, -14.0>
  }
}
#declare Leg10 = union {
  object { CSG374 }
  cylinder { // Cylndr714
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*y
    translate  <3.0, 0.0, -13.5>
  }
  box { // Cube1002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 6.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr715
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr716
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -3.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr717
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, -9.0, -18.0>
    material {
      Black
    }
  }
  cylinder { // Cylndr718
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <0.0, 9.0, -18.0>
    material {
      Black
    }
  }
  box { // Cube1003
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <-45.0, -0.0, 0.0>
    translate  <2.5, 11.0, -16.0>
  }
  box { // Cube1004
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.5>
    rotate <45.0, -0.0, 0.0>
    translate  <2.5, -11.0, -16.0>
  }
  box { // Cube1005
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 10.0, 0.5>
    translate  <2.5, 0.0, -15.0>
  }
  // All transformations fixed
  translate  <8.0, 0.0, -20.0>
}


#declare Cylndr719 = object {
  cylinder { // Cylndr719
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <6.0, 6.0, 0.5>
  }
}
#declare CSG375 = union {
  object { Cylndr719 }
  object { // Cylndr720->Cylndr719
    Cylndr719
    rotate -10.0*y
  }
  object { // Cylndr721->Cylndr719
    Cylndr719
    rotate -20.0*y
  }
  object { // Cylndr722->Cylndr719
    Cylndr719
    rotate -30.0*y
  }
  object { // Cylndr723->Cylndr719
    Cylndr719
    rotate -40.0*y
  }
  object { // Cylndr724->Cylndr719
    Cylndr719
    rotate -50.0*y
  }
  object { // Cylndr725->Cylndr719
    Cylndr719
    rotate -60.0*y
  }
  object { // Cylndr726->Cylndr719
    Cylndr719
    rotate -70.0*y
  }
  object { // Cylndr727->Cylndr719
    Cylndr719
    rotate -80.0*y
  }
  object { // Cylndr728->Cylndr719
    Cylndr719
    rotate -90.0*y
  }
  object { // Cylndr729->Cylndr719
    Cylndr719
    rotate <180.0, -80.0, 180.0>
  }
  object { // Cylndr730->Cylndr719
    Cylndr719
    rotate <180.0, -70.0, 180.0>
  }
  object { // Cylndr731->Cylndr719
    Cylndr719
    rotate <180.0, -60.0, 180.0>
  }
  object { // Cylndr732->Cylndr719
    Cylndr719
    rotate <180.0, -50.0, 180.0>
  }
  object { // Cylndr733->Cylndr719
    Cylndr719
    rotate <180.0, -40.0, 180.0>
  }
  object { // Cylndr734->Cylndr719
    Cylndr719
    rotate <180.0, -30.0, 180.0>
  }
  object { // Cylndr735->Cylndr719
    Cylndr719
    rotate <180.0, -20.0, 180.0>
  }
  object { // Cylndr736->Cylndr719
    Cylndr719
    rotate <180.0, -10.0, 180.0>
  }
}
#declare CSG376 = intersection {
  object { CSG375 }
  box { // Cube1006
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 4.0, 6.0>
  }
  translate  -0.1*z
}
#declare Wheel41 = union {
  object { CSG376 }
  sphere { // Sphere167
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    scale 5.5
    translate  -0.1*z
  }
  // Scaling fixed
  // Translation fixed
  rotate BuggyBWheelRotation
}
#declare Wheels4 = union {
  object { Wheel41 }
  object { // Wheel42->Wheel41
    Wheel41
    rotate <180.0, -60.0, 180.0>
    translate  13.0*x
  }
  object { // Wheel43->Wheel41
    Wheel41
    rotate <180.0, 60.0, 180.0>
    translate  26.0*x
  }
  material {
    Black
  }
  // All transformations fixed
  translate  <-13.0, -12.5, 6.5>
}
#declare Cube1016 = object {
  box { // Cube1016
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 7.0, 5.0>
    translate  <-2.0, 0.0, 5.0>
  }
}


#declare Cube1022 = object {
  box { // Cube1022
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  <0.0, -5.0, -11.5>
  }
}
#declare CSG385 = difference {
  box { // Cube1030
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 10.0>
    translate  <0.0, -10.0, -12.0>
  }
  box { // Cube1031
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.4, 15.0, 7.0>
    rotate 60.0*x
    translate  <0.0, -15.0, -22.0>
  }
  // All transformations fixed
}
#declare Rudder2 = union {
  box { // Cube1033
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 2.0>
    translate  <0.0, -10.0, -34.5>
  }
  translate  <0.0, 10.0, 32.5>
  material {
    Grey
  }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  translate  <0.0, -10.0, -33.0>
}
#declare RearFin8 = union {
  object { CSG385 }
  box { // Cube1032
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.2, 5.0, 5.0>
    translate  <0.0, -10.0, -27.0>
  }
  object { Rudder2 }
  cylinder { // Cylndr746
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -28.0>
  }
  cylinder { // Cylndr747
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -12.0>
  }
  translate  6.0*y
  material {
    FinMarkings
  }
  // Scaling fixed
  // Rot Z limited (-125.0 to   0.0)
  // Translation fixed
  translate  -6.0*y
}
#declare FrontFin8 = union {
  box { // Cube1034
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 4.0, 2.0>
    rotate -60.0*x
    translate  <0.0, -8.0, 23.0>
  }
  box { // Cube1035
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 2.0, 3.0>
    rotate -45.0*x
    translate  <0.0, -8.0, 27.0>
  }
  box { // Cube1036
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 2.0>
    translate  <0.0, -6.0, 25.0>
  }
  material {
    Grey
  }
  // All transformations fixed
}


#declare CSG420 = difference {
  cylinder { // Cylndr794
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  cylinder { // Cylndr795
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 30.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr796
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr797
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  11.0*x
  }
}
#declare Wheel44 = union {
  object { CSG420 }
  cylinder { // Cylndr798
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 15.0>
    rotate 90.0*y
    translate  -7.5*x
  }
  cylinder { // Cylndr799
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
  cylinder { // Cylndr800
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  box { // Cube1097
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <-30.0, 0.0, 0.0>
    translate  0.0*y
  }
  box { // Cube1098
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 14.0>
    rotate 0.0*z
    translate  0.0*y
  }
  box { // Cube1099
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <30.0, -0.0, -0.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Rot X limited (0.0 to   60.0)
  // Translation fixed
  translate  <60.0, -15.5, -5.0>
}
#declare Track20 = union {
  box { // Cube1109
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate -45.0*x
    translate  <-60.0, 77.5, 10.75>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-15.5 to   0.0)
}
#declare Other_Tracks2 = union {
  object { // Track21->Track20
    Track20
    translate  -15.5*y
  }
  object { // Track22->Track20
    Track20
    translate  -31.0*y
  }
  object { // Track23->Track20
    Track20
    translate  -46.5*y
  }
  object { // Track24->Track20
    Track20
    translate  -62.0*y
  }
  object { // Track25->Track20
    Track20
    translate  -77.5*y
  }
  object { // Track26->Track20
    Track20
    translate  -93.0*y
  }
  object { // Track27->Track20
    Track20
    translate  -108.5*y
  }
  object { // Track28->Track20
    Track20
    translate  -124.0*y
  }
  object { // Track29->Track20
    Track20
    translate  -139.5*y
  }
  // All transformations fixed
}
#declare Trackside8 = union {
  object { Track20 }
  object { Other_Tracks2 }
  // All transformations fixed
}
#declare TrackB6 = union {
  box { // Cube1110
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate <135.0, 0.0, -0.0>
    translate  <-60.0, 0.0, -15.75>
  }
  // Scaling fixed
  // Rot X limited (-180.0 to   -120.0)
  // Translation fixed
  rotate <-180.0, -180.0, -180.0>
  translate  <0.0, 77.5, -5.0>
}
#declare Other_TrackBs2 = union {
  object { // TrackB7->TrackB6
    TrackB6
    rotate <120.0, 0.0, -0.0>
    translate  <0.0, 111.919873, -74.616969>
  }
  object { // TrackB8->TrackB6
    TrackB6
    rotate <60.0, -0.0, -0.0>
    translate  <-0.0, 34.419873, -69.616969>
  }
  // All transformations fixed
}
#declare Trackend8 = union {
  object { TrackB6 }
  object { Other_TrackBs2 }
  // All transformations fixed
}
#declare Claw7 = union {
  box { // Cube1111
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    translate  <0.0, -7.0, -11.0>
  }
  box { // Cube1112
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate -45.0*x
    translate  <0.0, -1.0, 1.0>
  }
  box { // Cube1113
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate 45.0*x
    translate  <0.0, -8.0, -16.0>
  }
  box { // Cube1114
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  -22.0*z
  }
  cylinder { // Cylndr818
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate -90.0*y
    translate  1.0*x
  }
  // Scaling fixed
  // Rot X limited (-120.0 to   -75.0)
  // Translation fixed
  rotate -120.0*x
  translate  <0.0, -1.0, 7.0>
}


// The following include file contains the definition for TaperSweep015
#include "xfinal.in2"
#declare TaperSweep015 = object {
  TaperSweep015_Raw
  scale <1.0, 3.0, 12.0>
  rotate -180.0*x
  translate  12.0*z
}
#declare CSG431 = difference {
  object { TaperSweep015 }
  cylinder { // Cylndr860
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 2.5>
    rotate 90.0*y
    translate  <-1.25, 0.0, 0.25>
  }
  translate  -14.0*z
}
#declare CSG432 = union {
  box { // Cube1142
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 2.5, 1.5>
    translate  12.5*z
  }
  cylinder { // Cylndr861
    <0,0,1>, <0,0,0>, 1 
    scale 2.5
    rotate 90.0*y
    translate  <-1.25, 0.0, 14.0>
  }
}
#declare CSG433 = difference {
  object { CSG432 }
  box { // Cube1143
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    scale <1.00001, 1.5, 1.0>
    translate  <1.0, 0.0, 12.0>
  }
  cylinder { // Cylndr862
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate 90.0*y
    translate  14.0*z
  }
  translate  -14.0*z
}
#declare Arm10 = union {
  object { CSG431 }
  box { // Cube1139
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  -10.0*z
  }
  box { // Cube1140
    <-1, -1, -1>, <1, 1, 1>
    scale <0.75, 1.0, 4.0>
    translate  -6.0*z
  }
  box { // Cube1141
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.5, 0.5>
    translate  -3.0*z
  }
  object { CSG433 }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
  scale 1.2
  translate  10.2*x
}


#declare CSG436 = difference {
  cylinder { // Cylndr831
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  cylinder { // Cylndr832
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 30.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr833
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr834
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  11.0*x
  }
}
#declare Wheel56 = union {
  object { CSG436 }
  cylinder { // Cylndr835
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <13.0, 13.0, 15.0>
    rotate 90.0*y
    translate  -7.5*x
  }
  cylinder { // Cylndr836
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
  cylinder { // Cylndr837
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  box { // Cube1133
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <-30.0, 0.0, 0.0>
    translate  0.0*y
  }
  box { // Cube1134
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 14.0>
    rotate 0.0*z
    translate  0.0*y
  }
  box { // Cube1156
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <30.0, -0.0, -0.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Rot X limited (0.0 to   60.0)
  // Translation fixed
  rotate TankBWheelRotation
  translate  <60.0, -15.5, -5.0>
}
#declare Track30 = union {
  box { // Cube1166
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate -45.0*x
    translate  <-60.0, 77.5, 10.75>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-15.5 to   0.0)
  translate TankBTrackPerturbation
}
#declare Other_Tracks3 = union {
  object { // Track31->Track30
    Track30
    translate  -15.5*y
  }
  object { // Track32->Track30
    Track30
    translate  -31.0*y
  }
  object { // Track33->Track30
    Track30
    translate  -46.5*y
  }
  object { // Track34->Track30
    Track30
    translate  -62.0*y
  }
  object { // Track35->Track30
    Track30
    translate  -77.5*y
  }
  object { // Track36->Track30
    Track30
    translate  -93.0*y
  }
  object { // Track37->Track30
    Track30
    translate  -108.5*y
  }
  object { // Track38->Track30
    Track30
    translate  -124.0*y
  }
  object { // Track39->Track30
    Track30
    translate  -139.5*y
  }
  // All transformations fixed
}
#declare Trackside12 = union {
  object { Track30 }
  object { Other_Tracks3 }
  // All transformations fixed
}
#declare TrackB9 = union {
  box { // Cube1167
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate <135.0, 0.0, -0.0>
    translate  <-60.0, 0.0, -15.75>
  }
  // Scaling fixed
  // Rot X limited (-180.0 to   -120.0)
  // Translation fixed
  rotate <-180.0, -180.0, -180.0>
  rotate TankBTrackBPerturbation
  translate  <0.0, 77.5, -5.0>
}
#declare Other_TrackBs3 = union {
  object { // TrackB10->TrackB9
    TrackB9
    rotate <120.0, 0.0, -0.0>
    translate  <0.0, 111.919873, -74.616969>
  }
  object { // TrackB11->TrackB9
    TrackB9
    rotate <60.0, -0.0, -0.0>
    translate  <-0.0, 34.419873, -69.616969>
  }
  // All transformations fixed
}
#declare Trackend12 = union {
  object { TrackB9 }
  object { Other_TrackBs3 }
  // All transformations fixed
}
#declare CSG441 = difference {
  cylinder { // Cylndr872
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr873
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG442 = intersection {
  object { CSG441 }
  box { // Cube1171
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate 30.0*x
    translate  <60.0, -80.0, -3.0>
  }
}
#declare CSG443 = difference {
  cylinder { // Cylndr874
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr875
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG444 = intersection {
  object { CSG443 }
  box { // Cube1172
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate -150.0*x
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 50.0, 30.0>
}
#declare CSG445 = difference {
  cylinder { // Cylndr876
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr877
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG446 = intersection {
  object { CSG445 }
  box { // Cube1173
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate <30.0, 0.0, -0.0>
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 76.0, 15.0>
}
#declare CSG447 = difference {
  cylinder { // Cylndr878
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -80.0, -3.0>
  }
  cylinder { // Cylndr879
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 40.0>
    rotate 90.0*y
    translate  <40.0, -80.0, -3.0>
  }
}
#declare CSG448 = intersection {
  object { CSG447 }
  box { // Cube1174
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <20.0, 8.660255, 15.0>
    rotate <-30.0, -0.0, -0.0>
    translate  <60.0, -80.0, -3.0>
  }
  translate  <0.0, 146.0, 15.0>
}
#declare CSG449 = union {
  cylinder { // Cylndr870
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 30.0>
    rotate 90.0*y
    translate  <45.0, -93.0, 4.5>
  }
  cylinder { // Cylndr871
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 30.0>
    rotate 90.0*y
    translate  <45.0, 89.0, 2.25>
  }
  box { // Cube1168
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 10.0>
    rotate 30.0*x
    translate  <60.0, 89.0, 2.25>
  }
  box { // Cube1169
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 35.0>
    rotate 90.0*x
    translate  <60.0, 66.0, 27.0>
  }
  box { // Cube1170
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <15.0, 5.0, 25.0>
    rotate 90.0*x
    translate  <60.0, -30.0, 12.0>
  }
  object { CSG442 }
  object { CSG444 }
  object { CSG446 }
  object { CSG448 }
  scale <1.0, 1.0, 0.5>
  translate  5.0*z
}
#declare CSG450 = intersection {
  torus { // Torus092
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube1175
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <150.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 146.0, 15.0>
}
#declare CSG451 = intersection {
  torus { // Torus093
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube1176
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <210.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 76.0, 15.0>
}
#declare CSG452 = intersection {
  torus { // Torus094
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube1177
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate <30.0, -180.0, -180.0>
    translate  <75.0, -80.0, -3.0>
  }
  translate  <0.0, 50.0, 30.0>
}
#declare CSG453 = intersection {
  torus { // Torus095
    1.5, 0.5  rotate -x*90
    scale 10.0
    rotate <0.0, 90.0, 0.0>
    translate  <75.0, -80.0, -3.0>
  }
  box { // Cube1178
    <-1, -1, -1>, <1, 1, 1>
    rotate -45.0*x
    translate  1.414214*z
    scale <7.0, 8.660255, 15.0>
    rotate 30.0*x
    translate  <75.0, -80.0, -3.0>
  }
}
#declare CSG454 = union {
  object { CSG450 }
  object { CSG451 }
  object { CSG452 }
  object { CSG453 }
  sphere { // Sphere203
    <0,0,0>,1
    scale 5.0
    translate  <75.0, -93.0, 4.5>
  }
  sphere { // Sphere204
    <0,0,0>,1
    scale 5.0
    translate  <75.0, 89.0, 2.25>
  }
  cylinder { // Cylndr880
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 50.0>
    rotate 90.0*x
    translate  <75.0, -30.0, 12.0>
  }
  cylinder { // Cylndr881
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 70.0>
    rotate 90.0*x
    translate  <75.0, 66.0, 27.0>
  }
  cylinder { // Cylndr882
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 20.0>
    rotate <-150.0, 0.0, -0.0>
    translate  <75.0, 79.0, 19.5>
  }
  scale <1.0, 1.0, 0.5>
  translate  5.0*z
}
#declare CSG456 = union {
  object { CSG449 }
  object { CSG454 }
  object { // CSG455->CSG454
    CSG454
    translate  -30.0*x
  }
}
#declare CSG458 = difference {
  object { CSG456 }
  object { // CSG457->CSG456
    CSG456
    translate  -2.0*z
  }
}
#declare CSG459 = difference {
  sphere { // Sphere207
    <0,0,0>,1
    scale 10.0
  }
  sphere { // Sphere208
    <0,0,0>,1
    scale 9.0
  }
  box { // Cube1181
    <-1, -1, -1>, <1, 1, 1>
    scale 10.0
    translate  -7.0*y
  }
  translate  -15.0*y
}
#declare Radar1 = union {
  object { CSG459 }
  cylinder { // Cylndr887
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 9.0>
    rotate -90.0*x
    translate  -15.0*y
  }
  sphere { // Sphere209
    <0,0,0>,1
    scale 1.5
    translate  -15.0*y
  }
  cone { // Cone063
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <3.0, 3.0, 6.0>
    rotate 90.0*x
  }
  material {
    T_Chrome_3A
  }
  scale 0.8
  rotate <-30.0, 0.0, -30.0>
  translate  <-60.0, -31.0, 17.0>
}
#declare CSG460 = difference {
  cylinder { // Cylndr888
    <0,0,1>, <0,0,0>, 1 
    scale 5.0
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  cylinder { // Cylndr889
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare MudGuard2 = union {
  object { CSG458 }
  cone { // Cone061
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      T_Chrome_3A
    }
    scale <10.0, 3.0, 15.0>
    rotate <-90.0, 0.0, -0.0>
    translate  <60.0, 58.0, 21.0>
  }
  cylinder { // Cylndr883
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <2.0, 1.0, 15.0>
    rotate 90.0*x
    translate  <60.0, 62.0, 21.0>
  }
  sphere { // Sphere205
    <0,0,0>,1
    material {
      Black_Rubber
    }
    scale <2.0, 1.0, 1.0>
    translate  <60.0, 47.0, 21.0>
  }
  sphere { // Sphere206
    <0,0,0>,1
    material {
      Black_Rubber
    }
    scale <2.0, 1.0, 1.0>
    translate  <60.0, 62.0, 21.0>
  }
  cone { // Cone062
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      T_Chrome_3A
    }
    scale <5.0, 5.0, 15.0>
    rotate 90.0*x
    translate  <-65.0, -55.0, 13.0>
  }
  box { // Cube1179
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-69.0, 12.0, 21.0>
  }
  box { // Cube1180
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-69.0, 47.0, 21.0>
  }
  cylinder { // Cylndr884
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-69.0, 50.0, 26.0>
  }
  cylinder { // Cylndr885
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*x
    translate  <-69.0, 15.0, 26.0>
  }
  cylinder { // Cylndr886
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <2.0, 2.0, 47.0>
    rotate 90.0*x
    translate  <-69.0, 53.0, 26.0>
  }
  object { Radar1 }
  sphere { // Sphere210
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    scale <2.0, 2.0, 10.0>
    translate  <-60.0, -31.0, 9.0>
  }
  object { CSG460 }
  cylinder { // Cylndr890
    <0,0,1>, <0,0,0>, 1 
    material {
      Translucent
    }
    scale 4.0
    rotate 90.0*x
    translate  <-65.0, -70.0, 13.0>
  }
  // All transformations fixed
  translate  22.16*z
}
#declare Cylndr892 = object {
  cylinder { // Cylndr892
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 1.0>
    rotate 90.0*x
    translate  -80.0*y
  }
}
#declare Cylndr900 = object {
  cylinder { // Cylndr900
    <0,0,1>, <0,0,0>, 1 
    material {
      RedClear
    }
    scale <5.0, 5.0, 0.5>
    rotate 90.0*x
    translate  -80.25*y
  }
}
#declare Cylndr908 = object {
  cylinder { // Cylndr908
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 100.0>
    rotate 90.0*x
    translate  2.0*z
  }
}
#declare CSG461 = difference {
  cylinder { // Cylndr914
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    rotate 90.0*x
  }
  cylinder { // Cylndr915
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 101.0>
    rotate 90.0*x
  }
}
#declare Gun2 = union {
  cylinder { // Cylndr891
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <4.0, 4.0, 30.0>
    rotate 90.0*x
  }
  object { Cylndr892 }
  object { // Cylndr893->Cylndr892
    Cylndr892
    translate  -2.0*y
  }
  object { // Cylndr894->Cylndr892
    Cylndr892
    translate  -4.0*y
  }
  object { // Cylndr895->Cylndr892
    Cylndr892
    translate  -6.0*y
  }
  object { // Cylndr896->Cylndr892
    Cylndr892
    translate  -8.0*y
  }
  object { // Cylndr897->Cylndr892
    Cylndr892
    translate  -10.0*y
  }
  object { // Cylndr898->Cylndr892
    Cylndr892
    translate  -12.0*y
  }
  object { // Cylndr899->Cylndr892
    Cylndr892
    material {
      RedClear
    }
    translate  -14.0*y
  }
  object { Cylndr900 }
  object { // Cylndr901->Cylndr900
    Cylndr900
    translate  -2.0*y
  }
  object { // Cylndr902->Cylndr900
    Cylndr900
    translate  -4.0*y
  }
  object { // Cylndr903->Cylndr900
    Cylndr900
    translate  -6.0*y
  }
  object { // Cylndr904->Cylndr900
    Cylndr900
    translate  -8.0*y
  }
  object { // Cylndr905->Cylndr900
    Cylndr900
    translate  -10.0*y
  }
  object { // Cylndr906->Cylndr900
    Cylndr900
    translate  -12.0*y
  }
  object { // Cylndr907->Cylndr900
    Cylndr900
    translate  -14.0*y
  }
  object { Cylndr908 }
  object { // Cylndr909->Cylndr908
    Cylndr908
    rotate <0.0, -60.0, 0.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr910->Cylndr908
    Cylndr908
    rotate <-180.0, -60.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr911->Cylndr908
    Cylndr908
    rotate <180.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr912->Cylndr908
    Cylndr908
    rotate <-180.0, 60.0, 180.0>
    translate  <0.0, -0.0, -0.0>
  }
  object { // Cylndr913->Cylndr908
    Cylndr908
    rotate 60.0*y
    translate  <0.0, -0.0, -0.0>
  }
  object { CSG461 }
  material {
    T_Chrome_3A
  }
  // Scaling fixed
  // Rot X limited (-25.0 to   0.0)
  // Translation fixed
  rotate TankBGunRotation
  translate  <25.0, 0.0, 45.0>
}
#declare CSG472 = difference {
  cylinder { // Cylndr919
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 40.0>
    rotate 90.0*x
  }
  cylinder { // Cylndr920
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 42.0>
    rotate 90.0*x
    translate  1.0*y
  }
  box { // Cube1206
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 24.0, 7.0>
    translate  <0.0, -20.0, 7.0>
  }
  material {
    T_Chrome_3A
  }
  translate  <-30.0, 15.0, 12.0>
}
#declare CSG473 = intersection {
  torus { // Torus101
    9.0, 2.0  rotate -x*90
    rotate -90.0*y
    translate  <-30.0, 20.0, 3.0>
  }
  box { // Cube1207
    <-1, -1, -1>, <1, 1, 1>
    scale 6.0
    translate  <-30.0, 26.0, 9.0>
  }
}
#declare Group049 = union {
  box { // Cube1205
    <-1, -1, -1>, <1, 1, 1>
    scale 2.0
    translate  <-30.0, 12.0, 4.0>
  }
  object { CSG472 }
  object { CSG473 }
  cylinder { // Cylndr921
    <0,0,1>, <0,0,0>, 1 
    material {
      RedClear
    }
    scale <4.0, 4.0, 1.0>
    rotate 90.0*x
    translate  <-30.0, 20.0, 12.0>
  }
  cylinder { // Cylndr922
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <7.0, 7.0, 1.0>
    rotate 90.0*x
    translate  <-30.0, 19.0, 12.0>
  }
}
#declare Cube1209 = object {
  box { // Cube1209
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  <0.0, -5.0, -11.5>
  }
}
#declare CSG474 = difference {
  cylinder { // Cylndr927
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.0>
    translate  -38.0*z
  }
  cylinder { // Cylndr928
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <2.5, 2.5, 3.0>
    translate  -39.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Fuselage3 = union {
  cylinder { // Cylndr925
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <4.0, 4.0, 30.0>
    translate  -36.0*z
  }
  sphere { // Sphere213
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 15.0>
    translate  25.0*z
  }
  cylinder { // Cylndr926
    <0,0,1>, <0,0,0>, 1 
    material {
      ForeSection
    }
    scale <5.0, 5.0, 25.0>
  }
  sphere { // Sphere214
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 40.0>
  }
  sphere { // Sphere215
    <0,0,0>,1
    material {
      JetBlack
    }
    scale 2.0
    translate  38.5*z
  }
  object { CSG474 }
  object { Cube1209 }
  object { // Cube1210->Cube1209
    Cube1209
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube1211->Cube1209
    Cube1209
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube1212->Cube1209
    Cube1209
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1213->Cube1209
    Cube1209
    rotate 0.0*x
    translate  <0.0, -0.0, -16.0>
  }
  object { // Cube1214->Cube1209
    Cube1209
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -16.0>
  }
  object { // Cube1215->Cube1209
    Cube1209
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -16.0>
  }
  object { // Cube1216->Cube1209
    Cube1209
    rotate <0.0, 0.0, -270.0>
    translate  <0.0, -0.0, -16.0>
  }
  material {
    White
  }
  // All transformations fixed
}
#declare CSG475 = difference {
  box { // Cube1217
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 10.0>
    translate  <0.0, -10.0, -12.0>
  }
  box { // Cube1218
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.4, 15.0, 7.0>
    rotate 60.0*x
    translate  <0.0, -15.0, -22.0>
  }
  // All transformations fixed
}
#declare Rudder3 = union {
  box { // Cube1220
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 2.0>
    translate  <0.0, -10.0, -34.5>
  }
  translate  <0.0, 10.0, 32.5>
  material {
    Grey
  }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  translate  <0.0, -10.0, -33.0>
}
#declare RearFin12 = union {
  object { CSG475 }
  box { // Cube1219
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.2, 5.0, 5.0>
    translate  <0.0, -10.0, -27.0>
  }
  object { Rudder3 }
  cylinder { // Cylndr929
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -28.0>
  }
  cylinder { // Cylndr930
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -12.0>
  }
  translate  6.0*y
  material {
    FinMarkings
  }
  // Scaling fixed
  // Rot Z limited (-125.0 to   0.0)
  // Translation fixed
  rotate -125.0*z
  translate  -6.0*y
}
#declare FrontFin12 = union {
  box { // Cube1221
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 4.0, 2.0>
    rotate -60.0*x
    translate  <0.0, -8.0, 23.0>
  }
  box { // Cube1222
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 2.0, 3.0>
    rotate -45.0*x
    translate  <0.0, -8.0, 27.0>
  }
  box { // Cube1223
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 2.0>
    translate  <0.0, -6.0, 25.0>
  }
  material {
    Grey
  }
  // All transformations fixed
}
#declare Missile5 = union {
  object { Fuselage3 }
  object { RearFin12 }
  object { FrontFin12 }
  object { // FrontFin13->FrontFin12
    FrontFin12
    // All transformations fixed
    rotate -90.0*z
  }
  object { // FrontFin14->FrontFin12
    FrontFin12
    // All transformations fixed
    rotate 180.0*z
  }
  object { // FrontFin15->FrontFin12
    FrontFin12
    // All transformations fixed
    rotate 90.0*z
  }
  object { // RearFin13->RearFin12
    RearFin12
    // All transformations fixed
    rotate -90.0*z
  }
  object { // RearFin14->RearFin12
    RearFin12
    // All transformations fixed
    rotate 180.0*z
  }
  object { // RearFin15->RearFin12
    RearFin12
    // All transformations fixed
    rotate 90.0*z
  }
  scale <0.7, 0.7, 1.0>
  rotate 90.0*x
  translate  <30.0, -22.0, 12.0>
}
#declare TransSweep097 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, -1.0>,
  <1.0, -1.0>,
  <0.0, 1.0>,
  <-1.0, 1.0>,
  <-0.5, -1.0>
  rotate -x*90
  scale <10.0, 6.0, 2.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-22.0, 15.0, 9.0>
}
#declare CSG476 = difference {
  object { TransSweep097 }
  cylinder { // Cylndr932
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 15.0, 6.0>
  }
  cylinder { // Cylndr933
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 17.0, 9.0>
  }
  cylinder { // Cylndr934
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 19.0, 12.0>
  }
}
#declare Stand2 = union {
  object { CSG476 }
  box { // Cube1225
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 6.0, 1.0>
    translate  <-23.0, 20.0, 15.0>
  }
  box { // Cube1226
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 8.0, 1.0>
    translate  <-23.0, 13.0, 3.0>
  }
  cylinder { // Cylndr935
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    rotate 90.0*y
    translate  <-26.0, 20.0, 18.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}


#declare CSG477 = difference {
  cylinder { // Cylndr936
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  cylinder { // Cylndr937
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 30.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr938
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  -15.0*x
  }
  cylinder { // Cylndr939
    <0,0,1>, <0,0,0>, 1 
    scale <13.5, 13.5, 4.0>
    rotate 90.0*y
    translate  11.0*x
  }
}
#declare Wheel68 = union {
  object { CSG477 }
  cylinder { // Cylndr940
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 15.0>
    rotate 90.0*y
    translate  -7.5*x
  }
  cylinder { // Cylndr941
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
  cylinder { // Cylndr942
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 25.0>
    rotate 90.0*y
    translate  -12.5*x
  }
  box { // Cube1227
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <-30.0, 0.0, 0.0>
    translate  0.0*y
  }
  box { // Cube1228
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 1.0, 14.0>
    rotate 0.0*z
    translate  0.0*y
  }
  box { // Cube1229
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 14.0, 1.0>
    rotate <30.0, -0.0, -0.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Rot X limited (0.0 to   60.0)
  // Translation fixed
  translate  <60.0, -15.5, -5.0>
}
#declare Track40 = union {
  box { // Cube1239
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate -45.0*x
    translate  <-60.0, 77.5, 10.75>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-15.5 to   0.0)
}
#declare Other_Tracks4 = union {
  object { // Track41->Track40
    Track40
    translate  -15.5*y
  }
  object { // Track42->Track40
    Track40
    translate  -31.0*y
  }
  object { // Track43->Track40
    Track40
    translate  -46.5*y
  }
  object { // Track44->Track40
    Track40
    translate  -62.0*y
  }
  object { // Track45->Track40
    Track40
    translate  -77.5*y
  }
  object { // Track46->Track40
    Track40
    translate  -93.0*y
  }
  object { // Track47->Track40
    Track40
    translate  -108.5*y
  }
  object { // Track48->Track40
    Track40
    translate  -124.0*y
  }
  object { // Track49->Track40
    Track40
    translate  -139.5*y
  }
  // All transformations fixed
}
#declare Trackside16 = union {
  object { Track40 }
  object { Other_Tracks4 }
  // All transformations fixed
}
#declare TrackB12 = union {
  box { // Cube1240
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 1.0, 1.0>
    rotate <135.0, 0.0, -0.0>
    translate  <-60.0, 0.0, -15.75>
  }
  // Scaling fixed
  // Rot X limited (-180.0 to   -120.0)
  // Translation fixed
  rotate <-180.0, -180.0, -180.0>
  translate  <0.0, 77.5, -5.0>
}
#declare Other_TrackBs4 = union {
  object { // TrackB13->TrackB12
    TrackB12
    rotate <120.0, 0.0, -0.0>
    translate  <0.0, 111.919873, -74.616969>
  }
  object { // TrackB14->TrackB12
    TrackB12
    rotate <60.0, -0.0, -0.0>
    translate  <-0.0, 34.419873, -69.616969>
  }
  // All transformations fixed
}
#declare Trackend16 = union {
  object { TrackB12 }
  object { Other_TrackBs4 }
  no_shadow
  // All transformations fixed
}
#declare Claw10 = union {
  box { // Cube1241
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 5.0>
    translate  <0.0, -7.0, -11.0>
  }
  box { // Cube1242
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate -45.0*x
    translate  <0.0, -1.0, 1.0>
  }
  box { // Cube1243
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <1.0, 1.0, 5.0>
    rotate 45.0*x
    translate  <0.0, -8.0, -16.0>
  }
  box { // Cube1244
    <-1, -1, -1>, <1, 1, 1>
    rotate -0.0*x
    translate  -22.0*z
  }
  cylinder { // Cylndr960
    <0,0,1>, <0,0,0>, 1 
    scale 2.0
    rotate -90.0*y
    translate  1.0*x
  }
  // Scaling fixed
  // Rot X limited (-120.0 to   -75.0)
  // Translation fixed
  rotate TransporterCClawRotation
  translate  <0.0, -1.0, 7.0>
}


#declare Cube1295 = object {
  box { // Cube1295
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.5>
    translate  <0.0, -5.0, -11.5>
  }
}
#declare CSG504 = difference {
  box { // Cube1303
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 10.0>
    translate  <0.0, -10.0, -12.0>
  }
  box { // Cube1304
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.4, 15.0, 7.0>
    rotate 60.0*x
    translate  <0.0, -15.0, -22.0>
  }
  // All transformations fixed
}
#declare Rudder4 = union {
  box { // Cube1306
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 5.0, 2.0>
    translate  <0.0, -10.0, -34.5>
  }
  translate  <0.0, 10.0, 32.5>
  material {
    Grey
  }
  // Scaling fixed
  // Rot Y limited (-60.0 to   60.0)
  // Translation fixed
  translate  <0.0, -10.0, -33.0>
}
#declare RearFin16 = union {
  object { CSG504 }
  box { // Cube1305
    <-1, -1, -1>, <1, 1, 1>
    // All transformations fixed
    scale <0.2, 5.0, 5.0>
    translate  <0.0, -10.0, -27.0>
  }
  object { Rudder4 }
  cylinder { // Cylndr1001
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -28.0>
  }
  cylinder { // Cylndr1002
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -6.0, -12.0>
  }
  translate  6.0*y
  material {
    FinMarkings
  }
  // Scaling fixed
  // Rot Z limited (-125.0 to   0.0)
  // Translation fixed
  rotate -125.0*z
  translate  -6.0*y
}
#declare FrontFin16 = union {
  box { // Cube1307
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 4.0, 2.0>
    rotate -60.0*x
    translate  <0.0, -8.0, 23.0>
  }
  box { // Cube1308
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <0.2, 2.0, 3.0>
    rotate -45.0*x
    translate  <0.0, -8.0, 27.0>
  }
  box { // Cube1309
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 2.0>
    translate  <0.0, -6.0, 25.0>
  }
  material {
    Grey
  }
  // All transformations fixed
}




//
// ********  OBJECTS  *******
//



#declare Pillars1 = union {
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-100.0, -100.0, 100.0>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 0.0, 100.0>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 100.0, 100.0>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 0.0, 100.0>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 100.0, 100.0>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, 200.0, 100.0>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, 200.0, 100.0>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-200.0, -100.0, 100.0>
  }
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <200.0, -100.0, 100.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Beams1 = union {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, 215.0>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, 200.0, 215.0>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, -100.0, -15.0>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, -15.0>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, -15.0>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <200.0, 50.0, 215.0>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 165.0, 15.0>
    translate  <-200.0, 50.0, 215.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG023 = difference {
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 12.0, 127.0>
    translate  <0.0, -100.0, 100.0>
  }
  box { // Door_Spacer
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 20.0, 81.0>
    translate  <50.0, -100.0, 81.0>
  }
}
#declare Walls2 = union {
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <200.0, 50.0, 100.0>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 167.0, 127.0>
    translate  <-200.0, 50.0, 100.0>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 167.0, 12.0>
    translate  <0.0, 50.0, 215.0>
  }
  object { CSG023 }
  material {
    Aluminum
  }
}
#declare CSG025 = union {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
}
#declare CSG026 = difference {
  object { CSG025 }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
}
#declare CSG027 = intersection {
  object { CSG026 }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Door = union {
  object { CSG027 }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep002 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  material {
    T_Chrome_1A
  }
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG028 = union {
  object { TransSweep001 }
  object { TransSweep002 }
}
#declare CSG029 = difference {
  object { CSG028 }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
}
#declare Parts = union {
  object { CSG029 }
  material {
    Black_Rubber
  }
  // All transformations fixed
}
#declare Doorway = union {
  object { Door }
  object { Parts }
  material {
    T_Chrome_1A
  }
  translate  <50.0, -100.0, 0.0>
}
#declare Pillars = union {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <-100.0, 200.0, 100.0>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <0.0, 200.0, 100.0>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 100.0>
    translate  <100.0, 200.0, 100.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Beams = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 15.0, 15.0>
    translate  <0.0, 200.0, -15.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Walls = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <213.0, 12.0, 127.0>
    translate  <0.0, 200.0, 100.0>
  }
  material {
    Aluminum
  }
}
#declare Floor = difference {
  box { // Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <230.0, 180.0, 12.0>
    translate  <0.0, 50.0, -30.0>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 80.0, 20.0>
    translate  <0.0, 90.0, -30.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare CSG020 = union {
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 3.5, 1.0>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <5.0, 3.0, 1.0>
    translate  0.25*z
  }
}
#declare CSG021 = difference {
  object { CSG020 }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      BlueLight
    }
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    scale <1.6, 1.6, 1.0>
    translate  <2.0, 0.0, 1.0>
  }
}
#declare CSG022 = difference {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
    translate  <4.0, 0.0, 0.75>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 2.0>
    translate  <4.0, 0.0, 1.0>
  }
  translate  <-2.0, 0.0, -0.25>
}
#declare Switch = union {
  object { CSG021 }
  object { CSG022 }
  sphere { // Sphere025
    <0,0,0>,1
    scale <1.25, 1.25, 0.5>
    translate  <2.0, 0.0, 1.25>
  }
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 0.5>
    translate  <2.0, 0.0, 1.25>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      Plexiglas
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, -1.5, 1.0>
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      BlueLight
    }
    hollow
    scale <1.0, 1.0, 0.5>
    translate  <-2.5, 1.5, 1.0>
  }
  hollow
  rotate 45.0*x
  translate  20.0*z
}
#declare SwitchStand = union {
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black_Rubber
    }
    scale <5.5, 3.5, 1.0>
    translate  1.0*z
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 10.0>
    translate  <3.0, 0.0, 10.0>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 10.0>
    translate  <-3.0, 0.0, 10.0>
  }
  object { Switch }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 3.0, 1.0>
    translate  1.25*z
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 10.0>
    translate  <3.0, 0.0, 10.0>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <0.5, 1.5, 10.0>
    translate  <-3.0, 0.0, 10.0>
  }
  material {
    T_Chrome_1A
  }
  hollow
  scale 2.0
  rotate <-90.0, 0.0, -180.0>
  translate  <100.0, 185.0, 100.0>
}
#declare CSG001 = union {
  torus { // Torus001
    1.75, 0.2  rotate -x*90
    rotate 90.0*x
    translate  -1.0*z
  }
  torus { // Torus002
    1.75, 0.2  rotate -x*90
    rotate <90.0, 0.0, -90.0>
    translate  -1.0*z
  }
}
#declare CSG002 = difference {
  object { CSG001 }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.0>
  }
}
#declare CSG003 = merge {
  sphere { // Sphere002
    <0,0,0>,1
    no_shadow
    scale 1.8
    translate  -1.0*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <1.8, 1.8, 3.0>
    translate  -1.0*z
  }
  no_shadow
}
#declare CSG091 = merge {
  sphere { // Sphere086
    <0,0,0>,1
    no_shadow
    scale 1.7
    translate  -1.0*z
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 open
    no_shadow
    scale <1.7, 1.7, 3.0>
    translate  -1.0*z
  }
  no_shadow
}
#declare CSG092 = difference {
  object { CSG003 }
  object { CSG091 }
  material {
    Thin_Glass_2
  }
  no_shadow
}
#declare RedBulb = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <1.75, 0.0, -1.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <-1.75, 0.0, -1.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -1.75, -1.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    translate  <0.0, 1.75, -1.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 0.5>
    translate  2.0*z
  }
  cone { // Cone001
    <0,0,0>, 0.25, <0,0,1>, 0.5
    material {
      Black_Plastic
    }
    rotate <0.0, -180.0, -180.0>
    translate  2.0*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Bulb
    }
    no_shadow
  }
  object { CSG002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 0.5>
    translate  2.25*z
  }
  object { Arealight004 }
  object { CSG092 }
  material {
    T_Chrome_1A
  }
  no_shadow
  scale 5.0
  translate  <0.0, 50.0, 189.0>
}
#declare Hut = union {
  object { Pillars }
  object { Beams }
  object { Walls }
  object { Floor }
  object { SwitchStand }
  object { RedBulb }
  material {
    T_Chrome_1A
  }
}
union { // Hut1
  object { Pillars1 }
  object { Beams1 }
  object { Walls2 }
  object { Doorway }
  object { Hut }
  material {
    T_Chrome_1A
  }
  hollow
}


#declare Base = union {
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <81.0, 81.0, 10.0>
  }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <85.0, 85.0, 2.5>
    translate  10.0*z
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <85.0, 85.0, 2.5>
    translate  -10.0*z
  }
  material {
    Metal
  }
}
#declare CSG012 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
}
#declare CSG013 = difference {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate -90.0*z
}
#declare CSG014 = difference {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate 180.0*z
}
#declare CSG015 = difference {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  rotate 90.0*z
}
#declare CSG016 = difference {
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -90.0*z
}
#declare CSG017 = difference {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -180.0*z
}
#declare CSG018 = difference {
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
  scale <1.0, -1.0, 1.0>
  rotate -270.0*z
}
#declare CSG019 = difference {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-50.0, 70.0, 40.0>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    scale <10.0, 20.0, 40.0>
    rotate -26.5*y
    translate  <-40.0, 70.0, 40.0>
  }
}
#declare Walls1 = union {
  object { CSG012 }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-70.0, 70.0, 40.0>
  }
  object { CSG013 }
  object { CSG014 }
  object { CSG015 }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <70.0, 70.0, 40.0>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <70.0, -70.0, 40.0>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 10.0, 40.0>
    translate  <-70.0, -70.0, 40.0>
  }
  object { CSG016 }
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
}
#declare Rails1 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-70.0, 50.0, 0.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <70.0, 50.0, 0.0>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-50.0, 70.0, 0.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-70.0, -50.0, 0.0>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <50.0, -70.0, 0.0>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <50.0, 70.0, 0.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <-50.0, -70.0, 0.0>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 100.0>
    translate  <70.0, -50.0, 0.0>
  }
  sphere { // Sphere013
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, 70.0, 100.0>
  }
  sphere { // Sphere014
    <0,0,0>,1
    scale 3.0
    translate  <70.0, 70.0, 100.0>
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale 3.0
    translate  <70.0, -70.0, 100.0>
  }
  sphere { // Sphere016
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, -70.0, 100.0>
  }
  sphere { // Sphere017
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, 50.0, 100.0>
  }
  sphere { // Sphere018
    <0,0,0>,1
    scale 3.0
    translate  <50.0, 70.0, 100.0>
  }
  sphere { // Sphere019
    <0,0,0>,1
    scale 3.0
    translate  <70.0, -50.0, 100.0>
  }
  sphere { // Sphere020
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, -70.0, 100.0>
  }
  sphere { // Sphere021
    <0,0,0>,1
    scale 3.0
    translate  <-50.0, 70.0, 100.0>
  }
  sphere { // Sphere022
    <0,0,0>,1
    scale 3.0
    translate  <70.0, 50.0, 100.0>
  }
  sphere { // Sphere023
    <0,0,0>,1
    scale 3.0
    translate  <50.0, -70.0, 100.0>
  }
  sphere { // Sphere024
    <0,0,0>,1
    scale 3.0
    translate  <-70.0, -50.0, 100.0>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*x
    translate  <70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <-90.0, -0.0, 0.0>
    translate  <70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -180.0>
    translate  <-70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate 90.0*x
    translate  <-70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -270.0>
    translate  <-70.0, -70.0, 100.0>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -270.0>
    translate  <-70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, 270.0>
    translate  <70.0, 70.0, 100.0>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 20.0>
    rotate <90.0, -180.0, -90.0>
    translate  <70.0, -70.0, 100.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare Elevator = union {
  object { Base }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 3000.0>
    rotate <-0.0, -180.0, -0.0>
  }
  object { Walls1 }
  object { Rails1 }
  material {
    T_Chrome_1B
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-1525.0 to   -25.0)
  scale 0.75
  translate  ElevatorLocation
}
#declare ElevatorSupport = union {
  object { Beam }
  object { // Beam1->Beam
    Beam
    translate  140.0*y
  }
  object { // Beam2->Beam
    Beam
    translate  <220.0, 140.0, 0.0>
  }
  object { // Beam3->Beam
    Beam
    translate  220.0*x
  }
  object { Support }
  object { // Support1->Support
    Support
    rotate <0.0, 0.0, 0.0>
    translate  <220.0, 0.0, -0.0>
  }
  object { // Support2->Support
    Support
    rotate <0.0, 0.0, 0.0>
    translate  <220.0, 0.0, -500.0>
  }
  object { // Support3->Support
    Support
    rotate <0.0, 0.0, 0.0>
    translate  <220.0, 0.0, -1000.0>
  }
  object { // Support4->Support
    Support
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, -500.0>
  }
  object { // Support5->Support
    Support
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, -1000.0>
  }
  material {
    Black_Rubber
  }
}
union { // Lift
  object { ElevatorSuround }
  object { Elevator }
  object { // ElevatorSuround1->ElevatorSuround
    ElevatorSuround
    translate  -500.0*z
  }
  object { // ElevatorSuround2->ElevatorSuround
    ElevatorSuround
    translate  -1000.0*z
  }
  object { // ElevatorSuround3->ElevatorSuround
    ElevatorSuround
    translate  -1500.0*z
  }
  object { SwitchStand1 }
  object { // SwitchStand2->SwitchStand1
    SwitchStand1
    translate  -500.0*z
  }
  object { // SwitchStand3->SwitchStand1
    SwitchStand1
    translate  -1000.0*z
  }
  object { ElevatorSupport }
  hollow
}


#declare SideRailI = union {
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <0.0, 80.0, -25.0>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 160.0>
    rotate 90.0*y
    translate  <-80.0, 80.0, 75.0>
  }
  sphere { // Sphere035
    <0,0,0>,1
    scale 2.0
    translate  <0.0, 80.0, 75.0>
  }
  translate  <400.0, 290.0, -500.0>
}
#declare SideRailJ = union {
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-60.0, 80.0, -25.0>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*y
    translate  <-80.0, 80.0, 75.0>
  }
  sphere { // Sphere036
    <0,0,0>,1
    scale 2.0
    translate  <60.0, 80.0, 75.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <60.0, 81.0, -25.0>
  }
  sphere { // Sphere037
    <0,0,0>,1
    scale 2.0
    translate  <-60.0, 80.0, 75.0>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 40.0>
    rotate 90.0*y
    translate  <60.0, 80.0, 75.0>
  }
  rotate -90.0*z
  translate  <400.0, 290.0, -500.0>
}
#declare BalconyRail2 = union {
  object { // SideRail70->SideRail
    SideRail
    rotate 90.0*z
    translate  <450.0, -510.0, 0.0>
  }
  object { // SideRail72->SideRail
    SideRail
    rotate -90.0*z
    translate  <-290.0, 490.0, 0.0>
  }
  object { // SideRail74->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 890.0, 0.0>
  }
  object { // SideRail75->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1090.0, 0.0>
  }
  object { // SideRail95->SideRail
    SideRail
    rotate 180.0*z
    translate  <1200.0, 1780.0, 0.0>
  }
  object { // SideRail97->SideRail
    SideRail
    rotate 90.0*z
    translate  <290.0, -310.0, 0.0>
  }
  object { // SideRailB5->SideRailB
    SideRailB
    scale -1.0
    rotate -180.0*x
    translate  0.0*y
  }
  object { // SideRailC5->SideRailC
    SideRailC
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  0.0*y
  }
  object { // CornerRail13->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-290.0, 890.0, 0.0>
  }
  object { // CornerRail15->CornerRail
    CornerRail
    translate  <-1400.0, 400.0, 0.0>
  }
  object { // CornerRail16->CornerRail
    CornerRail
    rotate <-0.0, 0.0, -90.0>
    translate  <550.0, 2730.0, 0.0>
  }
  object { // SideRail101->SideRail
    SideRail
    rotate 180.0*z
    translate  <1400.0, 1780.0, 0.0>
  }
  object { // CornerRail19->CornerRail
    CornerRail
    translate  -600.0*x
  }
  object { // SideRailB7->SideRailB
    SideRailB
  }
  object { // SideRailC7->SideRailC
    SideRailC
    rotate 0.0*z
  }
  object { // SideRailE4->SideRailE
    SideRailE
    translate  -600.0*x
  }
  object { // SideRailF5->SideRailF
    SideRailF
    rotate -180.0*z
    translate  <1621.0, 2180.0, 0.0>
  }
  object { // SideRailF6->SideRailF
    SideRailF
    rotate 90.0*z
    translate  <890.0, 891.0, 0.0>
  }
  object { // SideRail96->SideRail
    SideRail
    rotate 90.0*z
    translate  <450.0, -310.0, 0.0>
  }
  object { // CornerRail22->CornerRail
    CornerRail
    rotate 90.0*z
    translate  <450.0, -550.0, 0.0>
  }
  object { // CornerRail23->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-490.0, 1290.0, 0.0>
  }
  object { // CornerRail17->CornerRail
    CornerRail
    translate  <-1000.0, 215.0, 0.0>
  }
  object { // CornerRail24->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <110.0, 1105.0, 0.0>
  }
  object { // SideRail73->SideRail
    SideRail
    rotate -90.0*z
    translate  <-290.0, 690.0, 0.0>
  }
  object { SideRailI }
  object { SideRailJ }
  object { SideRailG }
  object { SideRailH }
  object { // SideRailG1->SideRailG
    SideRailG
    translate  <-400.0, 200.0, 0.0>
  }
  object { // SideRailG2->SideRailG
    SideRailG
    translate  <-600.0, 600.0, 0.0>
  }
  object { // SideRailH1->SideRailH
    SideRailH
    translate  <-400.0, 200.0, 0.0>
  }
  object { // SideRailH2->SideRailH
    SideRailH
    translate  <-600.0, 600.0, 0.0>
  }
  object { // SideRailG3->SideRailG
    SideRailG
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // SideRailG4->SideRailG
    SideRailG
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  <-400.0, 200.0, 0.0>
  }
  object { // SideRailH3->SideRailH
    SideRailH
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  -0.0*x
  }
  object { // SideRailH4->SideRailH
    SideRailH
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  <-400.0, 200.0, 0.0>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate <-90.0, 0.0, -180.0>
    translate  <480.0, -209.0, -425.0>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate -90.0*x
    translate  <520.0, 1989.0, -425.0>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*y
    translate  <1099.0, 1810.0, -425.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare BalconySupport2 = union {
  object { // FloorSupport74->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1200.0, 2000.0, 0.0>
  }
  object { // FloorSupport75->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1400.0, 2000.0, 0.0>
  }
  object { // FloorSupport76->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 2000.0, 0.0>
  }
  object { // FloorSupport86->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1000.0*x
  }
  object { // FloorSupport87->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*x
  }
  object { // FloorSupport88->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*x
  }
  object { // FloorSupport89->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*x
  }
  object { // FloorSupport90->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*x
  }
  object { // FloorSupport96->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*y
  }
  object { // FloorSupport97->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*y
  }
  object { // FloorSupport98->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*y
  }
  object { // FloorSupport99->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*y
  }
  object { // LiftFloor4->LiftFloor
    LiftFloor
  }
  object { // FloorSupport109->FloorSupport
    FloorSupport
    rotate 0.0*z
  }
  object { // FloorSupport101->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <200.0, 200.0, 0.0>
  }
  object { // FloorSupport102->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <200.0, 400.0, 0.0>
  }
  object { // FloorSupport91->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1000.0, 200.0, 0.0>
  }
  object { // FloorSupport92->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1000.0, 400.0, 0.0>
  }
  object { Ramp }
  object { RampB }
  object { // RampB2->RampB
    RampB
    translate  <-400.0, 200.0, 0.0>
  }
  object { // Ramp3->Ramp
    Ramp
    translate  <-400.0, 200.0, 0.0>
  }
  object { // RampB4->RampB
    RampB
    translate  <-600.0, 600.0, 0.0>
  }
  object { // Ramp5->Ramp
    Ramp
    translate  <-600.0, 600.0, 0.0>
  }
}
#declare Skirting29 = difference {
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <40.900002, 1.0, 1.0>
  rotate -180.0*z
  translate  <-300.0, 1795.0, -555.0>
}
#declare Skirting30 = difference {
  object { Skirting29 }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -90.0>
    translate  <120.0, 1795.0, -590.0>
  }
  box { // Bob
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-200.0, 1720.0, -500.0>
  }
  translate  200.0*y
}
#declare Skirting42 = difference {
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate -90.0*z
  translate  <95.0, 2090.0, -555.0>
}
#declare Skirting43 = difference {
  object { Skirting42 }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <100.0, 1970.0, -590.0>
  }
}
#declare Skirting24 = difference {
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <90.900002, 1.0, 1.0>
  translate  <200.0, -215.0, -555.0>
}
#declare CSG024 = difference {
  object { Skirting24 }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    scale 200.0
    rotate -45.0*z
    translate  <800.0, -150.0, -600.0>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <385.0, -140.0, -500.0>
  }
}
#declare Skirting25 = difference {
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate -90.0*z
  translate  <-705.0, 890.0, -555.0>
}
#declare CSG033 = difference {
  object { Skirting25 }
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    scale 300.0
    rotate -45.0*z
    translate  <-615.0, 1600.0, -600.0>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-630.0, 505.0, -500.0>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-630.0, -110.0, -500.0>
  }
}
#declare Skirting26 = difference {
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate 90.0*z
  translate  <1105.0, 890.0, -555.0>
}
#declare CSG034 = difference {
  object { Skirting26 }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <1030.0, 1890.0, -500.0>
  }
}
#declare Skirting31 = difference {
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <30.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <800.0, 1995.0, -555.0>
}
#declare Skirting41 = difference {
  object { Skirting31 }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, 90.0>
    translate  <480.0, 1991.0, -590.0>
  }
}
#declare CSG035 = difference {
  object { Skirting41 }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <650.0, 1920.0, -500.0>
  }
}
#declare Skirting28 = difference {
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate 90.0*z
  translate  <505.0, 2090.0, -555.0>
}
#declare Skirting40 = difference {
  object { Skirting28 }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <508.0, 1970.0, -590.0>
  }
}
#declare CSG036 = difference {
  object { Skirting40 }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <650.0, 1920.0, -500.0>
  }
}
#declare Skirting27 = difference {
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <20.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <300.0, 2195.0, -555.0>
}
#declare CSG037 = difference {
  object { Skirting27 }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    scale 250.0
    rotate -45.0*z
    translate  <315.0, 2000.0, -500.0>
  }
}
#declare SkirtingMCornice3 = union {
  object { Skirting30 }
  object { Skirting43 }
  object { CSG024 }
  object { CSG033 }
  object { CSG034 }
  object { CSG035 }
  object { CSG036 }
  object { CSG037 }
  material {
    Black_Rubber
  }
}
union { // Balcony2
  object { BalconyRail2 }
  object { BalconySupport2 }
  object { SkirtingMCornice3 }
  material {
    T_Chrome_3A
  }
  translate  -1000.0*z
}


#declare BalconyRail1 = union {
  object { // SideRail35->SideRail
    SideRail
    translate  <200.0, 0.0, 0.0>
  }
  object { // SideRail36->SideRail
    SideRail
    translate  <400.0, 0.0, 0.0>
  }
  object { // SideRail37->SideRail
    SideRail
    translate  <-800.0, 0.0, 0.0>
  }
  object { // SideRail38->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 490.0, 0.0>
  }
  object { // SideRail39->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 690.0, 0.0>
  }
  object { // SideRail40->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 890.0, 0.0>
  }
  object { // SideRail42->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1090.0, 0.0>
  }
  object { // SideRail45->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 2090.0, 0.0>
  }
  object { // SideRail61->SideRail
    SideRail
    rotate 180.0*z
    translate  <1200.0, 1780.0, 0.0>
  }
  object { // SideRail62->SideRail
    SideRail
    rotate 180.0*z
    translate  <1000.0, 1780.0, 0.0>
  }
  object { // SideRail63->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, -310.0, 0.0>
  }
  object { // SideRail66->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 1290.0, 0.0>
  }
  object { // SideRailB3->SideRailB
    SideRailB
    scale -1.0
    rotate -180.0*x
    translate  0.0*y
  }
  object { // SideRailC3->SideRailC
    SideRailC
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  0.0*y
  }
  object { // CornerRail7->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-490.0, 890.0, 0.0>
  }
  object { // CornerRail8->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-490.0, 2490.0, 0.0>
  }
  object { // CornerRail10->CornerRail
    CornerRail
    rotate 90.0*z
    translate  <890.0, 890.0, 0.0>
  }
  object { // CornerRail11->CornerRail
    CornerRail
    rotate 180.0*z
    translate  <400.0, 780.0, 0.0>
  }
  object { // SideRail67->SideRail
    SideRail
    rotate 180.0*z
    translate  <800.0, 1780.0, 0.0>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate <-90.0, -0.0, -0.0>
    translate  <-320.0, 980.0, -425.0>
  }
  object { // SideRail102->SideRail
    SideRail
  }
  object { // CornerRail18->CornerRail
    CornerRail
  }
  object { // SideRailB6->SideRailB
    SideRailB
  }
  object { // SideRailC6->SideRailC
    SideRailC
    rotate 0.0*z
  }
  object { // SideRailD3->SideRailD
    SideRailD
    rotate 0.0*x
  }
  object { // SideRail68->SideRail
    SideRail
    rotate 180.0*z
    translate  <600.0, 1780.0, 0.0>
  }
  object { // SideRail104->SideRail
    SideRail
    rotate 180.0*z
    translate  <400.0, 1780.0, 0.0>
  }
  object { // SideRail105->SideRail
    SideRail
    rotate 180.0*z
    translate  <200.0, 1780.0, 0.0>
  }
  object { // SideRail106->SideRail
    SideRail
    rotate 180.0*z
    translate  1780.0*y
  }
  object { // SideRail107->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, -110.0, 0.0>
  }
  object { // SideRail108->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 90.0, 0.0>
  }
  object { // SideRail109->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 290.0, 0.0>
  }
  object { // CornerRail12->CornerRail
    CornerRail
    rotate 180.0*z
    translate  <400.0, 1780.0, 0.0>
  }
  object { // CornerRail20->CornerRail
    CornerRail
    translate  1600.0*y
  }
  object { // CornerRail21->CornerRail
    CornerRail
    rotate 90.0*z
    translate  <890.0, -110.0, 0.0>
  }
  object { // SideRailE1->SideRailE
    SideRailE
    rotate <0.0, 0.0, 90.0>
    translate  <1090.0, -110.0, 0.0>
  }
  object { // SideRailF1->SideRailF
    SideRailF
    rotate 90.0*z
    translate  <1090.0, -109.0, 0.0>
  }
  object { // SideRailE2->SideRailE
    SideRailE
    scale <1.0, -1.0, 1.0>
    rotate 90.0*z
    translate  <-690.0, -110.0, 0.0>
  }
  object { // SideRailF2->SideRailF
    SideRailF
    scale <1.0, -1.0, 1.0>
    rotate 90.0*z
    translate  <-690.0, -109.0, 0.0>
  }
  object { // SideRailE3->SideRailE
    SideRailE
    rotate -90.0*z
    translate  <-690.0, 2490.0, 0.0>
  }
  object { // SideRailE5->SideRailE
    SideRailE
    scale <1.0, -1.0, 1.0>
    rotate -90.0*z
    translate  <1090.0, 2490.0, 0.0>
  }
  object { // SideRailB8->SideRailB
    SideRailB
    scale <1.0, -1.0, 1.0>
    rotate 90.0*z
    translate  <-290.0, 1269.0, 0.0>
  }
  object { // SideRailB9->SideRailB
    SideRailB
    rotate 90.0*z
    translate  <690.0, 1269.0, 0.0>
  }
  object { // SideRailC8->SideRailC
    SideRailC
    rotate 0.0*z
    translate  <-200.0, 1006.0, 0.0>
  }
  object { // SideRailC4->SideRailC
    SideRailC
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  <600.0, 1006.0, 0.0>
  }
  object { // SideRail41->SideRail
    SideRail
    translate  <200.0, 1221.0, 0.0>
  }
  object { // SideRail43->SideRail
    SideRail
    translate  1221.0*y
  }
  object { // SideRail44->SideRail
    SideRail
    translate  <-200.0, 1221.0, 0.0>
  }
  object { // SideRail46->SideRail
    SideRail
    translate  <-400.0, 1221.0, 0.0>
  }
  object { // SideRail47->SideRail
    SideRail
    translate  <-600.0, 1221.0, 0.0>
  }
  object { // SideRail48->SideRail
    SideRail
    rotate -180.0*z
    translate  <200.0, 1359.0, 0.0>
  }
  object { // SideRail49->SideRail
    SideRail
    rotate -180.0*z
    translate  <400.0, 1359.0, 0.0>
  }
  object { // SideRail50->SideRail
    SideRail
    rotate -180.0*z
    translate  <600.0, 1359.0, 0.0>
  }
  object { // SideRail51->SideRail
    SideRail
    rotate -180.0*z
    translate  <800.0, 1359.0, 0.0>
  }
  object { // SideRail52->SideRail
    SideRail
    rotate -180.0*z
    translate  <1000.0, 1359.0, 0.0>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate <-90.0, -0.0, -0.0>
    translate  <720.0, 980.0, -425.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare BalconySupport1 = union {
  object { // FloorSupport40->FloorSupport
    FloorSupport
    translate  <1000.0, 2200.0, 0.0>
  }
  object { // FloorSupport41->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1000.0, 2000.0, 0.0>
  }
  object { // FloorSupport42->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1200.0, 2000.0, 0.0>
  }
  object { // FloorSupport43->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1400.0, 2000.0, 0.0>
  }
  object { // FloorSupport44->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 2000.0, 0.0>
  }
  object { // FloorSupport45->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1800.0, 0.0>
  }
  object { // FloorSupport46->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1600.0, 0.0>
  }
  object { // FloorSupport48->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1200.0, 0.0>
  }
  object { // FloorSupport21->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 400.0, 0.0>
  }
  object { // FloorSupport22->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 200.0, 0.0>
  }
  object { // FloorSupport23->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1600.0*x
  }
  object { // FloorSupport49->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1400.0*x
  }
  object { // FloorSupport50->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1200.0*x
  }
  object { // FloorSupport51->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1000.0*x
  }
  object { // FloorSupport52->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*x
  }
  object { // FloorSupport53->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*x
  }
  object { // FloorSupport54->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*x
  }
  object { // FloorSupport55->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*x
  }
  object { // FloorSupport10->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1800.0*y
  }
  object { // FloorSupport56->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1600.0*y
  }
  object { // FloorSupport58->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1200.0*y
  }
  object { // FloorSupport59->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1000.0*y
  }
  object { // FloorSupport60->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*y
  }
  object { // FloorSupport61->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*y
  }
  object { // FloorSupport62->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*y
  }
  object { // FloorSupport63->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*y
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2200.0>
    rotate -90.0*x
    translate  <-510.0, -210.0, -590.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2200.0>
    rotate -90.0*x
    translate  <910.0, -210.0, -590.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, -20.0, -590.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, 1800.0, -590.0>
  }
  object { // FloorSupport108->FloorSupport
    FloorSupport
    rotate 0.0*z
  }
  object { // LiftFloor3->LiftFloor
    LiftFloor
  }
  object { // FloorSupport64->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  2000.0*y
  }
  object { // FloorSupport100->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <200.0, 2000.0, 0.0>
  }
  object { // FloorSupport110->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <400.0, 2000.0, 0.0>
  }
  object { // FloorSupport111->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <600.0, 2000.0, 0.0>
  }
  object { // FloorSupport112->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <800.0, 2000.0, 0.0>
  }
  object { // FloorSupport113->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <800.0, 2200.0, 0.0>
  }
  object { // FloorSupport65->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1000.0, 0.0>
  }
  object { // FloorSupport47->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 600.0, 0.0>
  }
  object { // FloorSupport57->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 800.0, 0.0>
  }
  object { // FloorSupport66->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1400.0, 1000.0, 0.0>
  }
  object { // FloorSupport67->FloorSupport
    FloorSupport
    translate  <200.0, 1000.0, 0.0>
  }
  object { // FloorSupport68->FloorSupport
    FloorSupport
    translate  <200.0, 1200.0, 0.0>
  }
  object { // FloorSupport69->FloorSupport
    FloorSupport
    translate  <200.0, 1600.0, 0.0>
  }
  object { // FloorSupport70->FloorSupport
    FloorSupport
    translate  <1400.0, 1600.0, 0.0>
  }
  object { // FloorSupport71->FloorSupport
    FloorSupport
    translate  <1400.0, 1200.0, 0.0>
  }
}
#declare Skirting13 = difference {
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <20.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <300.0, 2195.0, -555.0>
}
#declare Skirting15 = difference {
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate 90.0*z
  translate  <505.0, 2090.0, -555.0>
}
#declare Skirting36 = difference {
  object { Skirting15 }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <508.0, 1970.0, -590.0>
  }
}
#declare Skirting11 = difference {
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <40.900002, 1.0, 1.0>
  rotate -180.0*z
  translate  <-300.0, 1795.0, -555.0>
}
#declare Skirting21 = difference {
  object { Skirting11 }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -90.0>
    translate  <120.0, 1795.0, -590.0>
  }
  translate  200.0*y
}
#declare Skirting12 = difference {
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <30.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <800.0, 1995.0, -555.0>
}
#declare Skirting23 = difference {
  object { Skirting12 }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, 90.0>
    translate  <480.0, 1991.0, -590.0>
  }
}
#declare Skirting14 = difference {
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate -90.0*z
  translate  <95.0, 2090.0, -555.0>
}
#declare Skirting37 = difference {
  object { Skirting14 }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <100.0, 1970.0, -590.0>
  }
}
#declare Skirting10 = difference {
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate 90.0*z
  translate  <1105.0, 890.0, -555.0>
}
#declare CSG038 = difference {
  object { Skirting10 }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 300.0, 200.0>
    rotate -45.0*z
    translate  <1015.0, 1200.0, -500.0>
  }
}
#declare Skirting8 = difference {
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <90.900002, 1.0, 1.0>
  translate  <200.0, -215.0, -555.0>
}
#declare CSG039 = difference {
  object { Skirting8 }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-600.0, -140.0, -500.0>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <1000.0, -140.0, -500.0>
  }
}
#declare Skirting9 = difference {
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate -90.0*z
  translate  <-705.0, 890.0, -555.0>
}
#declare CSG040 = difference {
  object { Skirting9 }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    scale 200.0
    rotate -45.0*z
    translate  <-640.0, 890.0, -600.0>
  }
}
#declare SkirtingMCornice1 = union {
  object { Skirting13 }
  object { Skirting36 }
  object { Skirting21 }
  object { Skirting23 }
  object { Skirting37 }
  object { CSG038 }
  object { CSG039 }
  object { CSG040 }
  material {
    Black_Rubber
  }
}
union { // Balcony1
  object { BalconyRail1 }
  object { BalconySupport1 }
  object { SkirtingMCornice1 }
  material {
    T_Chrome_3A
  }
  translate  -500.0*z
}


#declare BalconyRail = union {
  object { SideRail }
  object { CornerRail }
  object { SideRailB }
  object { SideRailC }
  object { SideRailD }
  object { // SideRail1->SideRail
    SideRail
    translate  <200.0, 0.0, 0.0>
  }
  object { // SideRail2->SideRail
    SideRail
    translate  <400.0, 0.0, 0.0>
  }
  object { // SideRail3->SideRail
    SideRail
    translate  <-800.0, 0.0, 0.0>
  }
  object { // SideRail4->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 490.0, 0.0>
  }
  object { // SideRail5->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 690.0, 0.0>
  }
  object { // SideRail6->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 890.0, 0.0>
  }
  object { // SideRail7->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1090.0, 0.0>
  }
  object { // SideRail8->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1290.0, 0.0>
  }
  object { // SideRail9->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1690.0, 0.0>
  }
  object { // SideRail10->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 1890.0, 0.0>
  }
  object { // SideRail11->SideRail
    SideRail
    rotate -90.0*z
    translate  <-490.0, 2090.0, 0.0>
  }
  object { // SideRail12->SideRail
    SideRail
    translate  1200.0*y
  }
  object { // SideRail13->SideRail
    SideRail
    translate  <200.0, 1200.0, 0.0>
  }
  object { // SideRail14->SideRail
    SideRail
    translate  <400.0, 1200.0, 0.0>
  }
  object { // SideRail15->SideRail
    SideRail
    translate  <-200.0, 1200.0, 0.0>
  }
  object { // SideRail16->SideRail
    SideRail
    translate  <-400.0, 1200.0, 0.0>
  }
  object { // SideRail17->SideRail
    SideRail
    translate  <-600.0, 1200.0, 0.0>
  }
  object { // SideRail18->SideRail
    SideRail
    translate  <-800.0, 1200.0, 0.0>
  }
  object { // SideRail19->SideRail
    SideRail
    rotate 180.0*z
    translate  <1400.0, 980.0, 0.0>
  }
  object { // SideRail20->SideRail
    SideRail
    rotate 180.0*z
    translate  <1200.0, 980.0, 0.0>
  }
  object { // SideRail21->SideRail
    SideRail
    rotate 180.0*z
    translate  <1000.0, 980.0, 0.0>
  }
  object { // SideRail22->SideRail
    SideRail
    rotate 180.0*z
    translate  <800.0, 980.0, 0.0>
  }
  object { // SideRail23->SideRail
    SideRail
    rotate 180.0*z
    translate  <600.0, 980.0, 0.0>
  }
  object { // SideRail24->SideRail
    SideRail
    rotate 180.0*z
    translate  <400.0, 980.0, 0.0>
  }
  object { // SideRail25->SideRail
    SideRail
    rotate 180.0*z
    translate  <200.0, 980.0, 0.0>
  }
  object { // SideRail26->SideRail
    SideRail
    rotate 180.0*z
    translate  980.0*y
  }
  object { // SideRail27->SideRail
    SideRail
    rotate 180.0*z
    translate  <1200.0, 1780.0, 0.0>
  }
  object { // SideRail28->SideRail
    SideRail
    rotate 180.0*z
    translate  <1000.0, 1780.0, 0.0>
  }
  object { // SideRail30->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, -310.0, 0.0>
  }
  object { // SideRail32->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 890.0, 0.0>
  }
  object { // SideRail33->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 1090.0, 0.0>
  }
  object { // SideRail34->SideRail
    SideRail
    rotate 90.0*z
    translate  <890.0, 1290.0, 0.0>
  }
  object { // SideRailB1->SideRailB
    SideRailB
    scale -1.0
    rotate -180.0*x
    translate  0.0*y
  }
  object { // SideRailC1->SideRailC
    SideRailC
    scale -1.0
    rotate <180.0, 0.0, -0.0>
    translate  0.0*y
  }
  object { SideRailE }
  object { SideRailF }
  object { // CornerRail1->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-490.0, 890.0, 0.0>
  }
  object { // CornerRail2->CornerRail
    CornerRail
    rotate -90.0*z
    translate  <-490.0, 2090.0, 0.0>
  }
  object { // CornerRail3->CornerRail
    CornerRail
    translate  1200.0*y
  }
  object { // CornerRail4->CornerRail
    CornerRail
    rotate 90.0*z
    translate  <890.0, 890.0, 0.0>
  }
  object { // CornerRail5->CornerRail
    CornerRail
    rotate 180.0*z
    translate  <400.0, 980.0, 0.0>
  }
  object { // SideRail29->SideRail
    SideRail
    rotate 180.0*z
    translate  <800.0, 1780.0, 0.0>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate -90.0*y
    translate  <302.0, 1810.0, -425.0>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate -90.0*y
    translate  <1119.0, 1010.0, -425.0>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate -90.0*y
    translate  <1119.0, 370.0, -425.0>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate -90.0*x
    translate  <-520.0, 1789.0, -425.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare BalconySupport = union {
  object { // FloorSupport32->FloorSupport
    FloorSupport
    translate  <1000.0, 2200.0, 0.0>
  }
  object { // FloorSupport31->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1000.0, 2000.0, 0.0>
  }
  object { // FloorSupport30->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1200.0, 2000.0, 0.0>
  }
  object { // FloorSupport29->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1400.0, 2000.0, 0.0>
  }
  object { // FloorSupport28->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 2000.0, 0.0>
  }
  object { // FloorSupport27->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1800.0, 0.0>
  }
  object { // FloorSupport26->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1600.0, 0.0>
  }
  object { // FloorSupport25->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1400.0, 0.0>
  }
  object { // FloorSupport24->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 1200.0, 0.0>
  }
  object { // FloorSupport20->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 400.0, 0.0>
  }
  object { // FloorSupport19->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1600.0, 200.0, 0.0>
  }
  object { // FloorSupport18->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1600.0*x
  }
  object { // FloorSupport17->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1400.0*x
  }
  object { // FloorSupport16->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1200.0*x
  }
  object { // FloorSupport15->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1000.0*x
  }
  object { // FloorSupport14->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*x
  }
  object { // FloorSupport13->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*x
  }
  object { // FloorSupport12->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*x
  }
  object { // FloorSupport11->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*x
  }
  object { // FloorSupport9->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1800.0*y
  }
  object { // FloorSupport8->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1600.0*y
  }
  object { // FloorSupport7->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1400.0*y
  }
  object { // FloorSupport6->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1200.0*y
  }
  object { // FloorSupport5->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  1000.0*y
  }
  object { // FloorSupport4->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  800.0*y
  }
  object { // FloorSupport3->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  600.0*y
  }
  object { // FloorSupport2->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  400.0*y
  }
  object { // FloorSupport1->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  200.0*y
  }
  object { FloorSupport }
  object { LiftFloor }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2200.0>
    rotate -90.0*x
    translate  <-510.0, -210.0, -590.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1000.0>
    rotate -90.0*x
    translate  <910.0, 1000.0, -590.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, -20.0, -590.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, 1800.0, -590.0>
  }
  object { // FloorSupport33->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1400.0, 1200.0, 0.0>
  }
  object { // FloorSupport34->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1200.0, 1200.0, 0.0>
  }
  object { // FloorSupport35->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <1000.0, 1200.0, 0.0>
  }
  object { // FloorSupport36->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <800.0, 1200.0, 0.0>
  }
  object { // FloorSupport37->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <600.0, 1200.0, 0.0>
  }
  object { // FloorSupport38->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <400.0, 1200.0, 0.0>
  }
  object { // FloorSupport39->FloorSupport
    FloorSupport
    rotate 0.0*z
    translate  <200.0, 1200.0, 0.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, 1000.0, -590.0>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1800.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <1100.0, 1180.0, -590.0>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 600.0>
    rotate -90.0*x
    translate  <910.0, -220.0, -590.0>
  }
  object { // FloorSupport72->FloorSupport
    FloorSupport
    translate  <1200.0, 2200.0, 0.0>
  }
}
#declare Skirting = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <90.900002, 1.0, 1.0>
  translate  <200.0, -215.0, -555.0>
}
#declare Skirting5 = difference {
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <400.0, 2195.0, -555.0>
}
#declare Skirting3 = difference {
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <50.900002, 1.0, 1.0>
  rotate -180.0*z
  translate  <-200.0, 1795.0, -555.0>
}
#declare Skirting19 = difference {
  object { Skirting3 }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -90.0>
    translate  <320.0, 1795.0, -590.0>
  }
}
#declare Skirting4 = difference {
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <30.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <800.0, 1995.0, -555.0>
}
#declare Skirting22 = difference {
  object { Skirting4 }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, 90.0>
    translate  <480.0, 1991.0, -590.0>
  }
}
#declare Skirting6 = difference {
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <20.9, 1.0, 1.0>
  rotate -90.0*z
  translate  <295.0, 1990.0, -555.0>
}
#declare Skirting32 = difference {
  object { Skirting6 }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <301.0, 1770.0, -590.0>
  }
}
#declare Skirting7 = difference {
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate 90.0*z
  translate  <505.0, 2090.0, -555.0>
}
#declare Skirting33 = difference {
  object { Skirting7 }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <508.0, 1970.0, -590.0>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <425.0, 2120.0, -500.0>
  }
}
#declare Skirting1 = difference {
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <100.900002, 1.0, 1.0>
  rotate -90.0*z
  translate  <-705.0, 790.0, -555.0>
}
#declare CSG042 = difference {
  object { Skirting1 }
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-630.0, 505.0, -500.0>
  }
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-630.0, -110.0, -500.0>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <-630.0, 1690.0, -500.0>
  }
}
#declare Skirting2 = difference {
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate 90.0*z
  translate  <1105.0, 890.0, -555.0>
}
#declare CSG043 = difference {
  object { Skirting2 }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <1030.0, 275.0, -500.0>
  }
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    scale <100.0, 100.0, 200.0>
    rotate -45.0*z
    translate  <1030.0, 1890.0, -500.0>
  }
}
#declare SkirtingMCornice = union {
  object { Skirting }
  object { Skirting5 }
  object { Skirting19 }
  object { Skirting22 }
  object { Skirting32 }
  object { Skirting33 }
  object { CSG042 }
  object { CSG043 }
  material {
    Black_Rubber
  }
}
union { // Balcony
  object { BalconyRail }
  object { BalconySupport }
  object { SkirtingMCornice }
  material {
    T_Chrome_3A
  }
}


union { // Windows
  box { // Window
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 1720.0, -375.0>
  }
  box { // Window1
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 90.0, -375.0>
  }
  box { // Window2
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, -95.0, -375.0>
  }
  box { // Window4
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 1520.0, -375.0>
  }
  box { // Window5
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 1330.0, -375.0>
  }
  box { // Window6
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 520.0, -875.0>
  }
  box { // Window3
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 1720.0, -875.0>
  }
  box { // Window7
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 660.0, -875.0>
  }
  box { // Window8
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 675.0, -1375.0>
  }
  box { // Window9
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 60.0, -1375.0>
  }
  box { // Window10
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 10.0, 60.0>
    translate  <200.0, -240.0, -1375.0>
  }
  material {
    KongDome
  }
}


#declare CSG044 = difference {
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 415.0, 300.0>
    translate  <-730.0, 1605.0, -1325.0>
  }
  box { // Door_Spacer1
    <-1, -1, -1>, <1, 1, 1>
    scale <302.0, 25.0, 162.0>
    rotate 90.0*z
    translate  <-730.0, 1590.0, -1440.0>
  }
}
#declare CSG045 = difference {
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 250.0>
    translate  <1130.0, 1190.0, -775.0>
  }
  box { // Door_Spacer2
    <-1, -1, -1>, <1, 1, 1>
    scale <302.0, 25.0, 162.0>
    rotate 90.0*z
    translate  <1130.0, 1190.0, -858.5>
  }
}
#declare CSG046 = difference {
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 300.0>
    translate  <815.0, -240.0, -1325.0>
  }
  box { // Door_Spacer3
    <-1, -1, -1>, <1, 1, 1>
    scale <202.0, 25.0, 162.0>
    translate  <800.0, -240.0, -1440.0>
  }
}
#declare CSG047 = difference {
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 100.0, 375.0>
    translate  <530.0, 2120.0, -150.0>
  }
  box { // Door_Spacer4
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <530.0, 2120.0, -438.5>
  }
}
#declare CSG048 = difference {
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 215.0, 250.0>
    translate  <1130.0, 1805.0, -275.0>
  }
  box { // Door_Spacer5
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <1130.0, 1890.0, -438.5>
  }
  box { // Window11
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 1720.0, -375.0>
  }
}
#declare CSG049 = difference {
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 250.0>
    translate  <1130.0, 75.0, -275.0>
  }
  box { // Door_Spacer6
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <1130.0, 275.0, -438.5>
  }
  box { // Window12
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 90.0, -375.0>
  }
  box { // Window13
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, -95.0, -375.0>
  }
}
#declare CSG052 = difference {
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 250.0>
    translate  <-730.0, 75.0, -275.0>
  }
  box { // Door_Spacer7
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <-730.0, -110.0, -438.5>
  }
}
#declare CSG058 = difference {
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 250.0>
    translate  <-730.0, 790.0, -275.0>
  }
  box { // Door_Spacer8
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <-730.0, 505.0, -438.5>
  }
}
#declare CSG064 = difference {
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 250.0>
    translate  <-730.0, 790.0, -775.0>
  }
  box { // Door_Spacer9
    <-1, -1, -1>, <1, 1, 1>
    scale <202.0, 25.0, 162.0>
    rotate 90.0*z
    translate  <-730.0, 890.0, -858.5>
  }
  box { // Window16
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 520.0, -875.0>
  }
}
#declare CSG070 = difference {
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 300.0>
    translate  <-730.0, 790.0, -1325.0>
  }
  box { // Door_Spacer10
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <-730.0, 505.0, -1438.5>
  }
  box { // Window19
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 675.0, -1375.0>
  }
}
#declare CSG071 = difference {
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 300.0>
    translate  <-730.0, 75.0, -1325.0>
  }
  box { // Door_Spacer11
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <-730.0, -110.0, -1438.5>
  }
  box { // Window20
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 60.0, -1375.0>
  }
}
#declare CSG082 = difference {
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 300.0>
    translate  <200.0, -240.0, -1325.0>
  }
  box { // Door_Spacer12
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    translate  <385.0, -240.0, -1438.5>
  }
  box { // Window21
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    translate  <200.0, -240.0, -1375.0>
  }
}
#declare CSG094 = difference {
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 215.0, 300.0>
    translate  <1130.0, 1805.0, -1325.0>
  }
  box { // Door_Spacer13
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <1130.0, 1890.0, -1438.5>
  }
}
#declare CSG095 = difference {
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 300.0>
    translate  <830.0, 2020.0, -1325.0>
  }
  box { // Door_Spacer14
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    translate  <650.0, 2020.0, -1438.5>
  }
}
#declare CSG100 = difference {
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 20.0, 300.0>
    translate  <315.0, 2220.0, -1325.0>
  }
  box { // Door_Spacer15
    <-1, -1, -1>, <1, 1, 1>
    scale <126.0, 25.0, 201.0>
    translate  <315.0, 2220.0, -1400.0>
  }
}
#declare CSG111 = difference {
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 250.0>
    translate  <815.0, -240.0, -775.0>
  }
  box { // Door_Spacer16
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    translate  <1000.0, -240.0, -938.5>
  }
}
#declare CSG112 = difference {
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 250.0>
    translate  <-415.0, -240.0, -775.0>
  }
  box { // Door_Spacer17
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    translate  <-600.0, -240.0, -938.5>
  }
}
#declare CSG118 = difference {
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 415.0, 250.0>
    translate  <-730.0, 1605.0, -275.0>
  }
  box { // Door_Spacer18
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 25.0, 81.0>
    rotate -90.0*z
    translate  <-730.0, 1690.0, -438.5>
  }
  box { // Window14
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 1520.0, -375.0>
  }
  box { // Window15
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <-730.0, 1330.0, -375.0>
  }
}
#declare CSG119 = difference {
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 215.0, 250.0>
    translate  <1130.0, 1805.0, -775.0>
  }
  box { // Window17
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 1720.0, -875.0>
  }
}
#declare CSG120 = difference {
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 200.0, 250.0>
    translate  <1130.0, 590.0, -775.0>
  }
  box { // Window18
    <-1, -1, -1>, <1, 1, 1>
    scale <80.0, 30.0, 60.0>
    rotate -90.0*z
    translate  <1130.0, 660.0, -875.0>
  }
}
#declare CSG122 = difference {
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 200.0, 250.0>
    translate  <1130.0, 590.0, -275.0>
  }
  box { // ExhaustSpacer1
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 150.0, 125.0>
    rotate -90.0*z
    translate  <1229.0, 588.0, -400.0>
  }
}
#declare Walls3 = union {
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    scale <130.0, 20.0, 250.0>
    translate  <400.0, 2220.0, -275.0>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 250.0>
    translate  <830.0, 2020.0, -775.0>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 250.0>
    translate  <815.0, -240.0, -275.0>
  }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    scale <215.0, 20.0, 250.0>
    translate  <315.0, 2220.0, -775.0>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 100.0, 250.0>
    translate  <530.0, 2120.0, -775.0>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 375.0>
    translate  <830.0, 2020.0, -150.0>
  }
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 250.0>
    translate  <1130.0, 1190.0, -275.0>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 400.0, 300.0>
    translate  <1130.0, 1190.0, -1325.0>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 200.0, 300.0>
    translate  <1130.0, 590.0, -1325.0>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 300.0>
    translate  <1130.0, 75.0, -1325.0>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 250.0>
    translate  <1130.0, 75.0, -775.0>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 250.0>
    translate  <-415.0, -240.0, -275.0>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <315.0, 20.0, 300.0>
    translate  <-415.0, -240.0, -1325.0>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 250.0>
    translate  <200.0, -240.0, -775.0>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 20.0, 250.0>
    translate  <200.0, -240.0, -275.0>
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 315.0, 250.0>
    translate  <-730.0, 75.0, -775.0>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 415.0, 250.0>
    translate  <-730.0, 1605.0, -775.0>
  }
  object { CSG044 }
  object { CSG045 }
  object { CSG046 }
  object { CSG047 }
  object { CSG048 }
  object { CSG049 }
  object { CSG052 }
  object { CSG058 }
  object { CSG064 }
  object { CSG070 }
  object { CSG071 }
  object { CSG082 }
  object { CSG094 }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 100.0, 300.0>
    translate  <530.0, 2120.0, -1325.0>
  }
  object { CSG095 }
  object { CSG100 }
  object { CSG111 }
  object { CSG112 }
  object { CSG118 }
  object { CSG119 }
  object { CSG120 }
  object { CSG122 }
  material {
    White
  }
}
#declare Pillars2 = union {
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <-730.0, -240.0, -800.0>
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <-100.0, -240.0, -800.0>
  }
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <500.0, -240.0, -800.0>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <1130.0, -240.0, -800.0>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <-730.0, 390.0, -800.0>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <-730.0, 1190.0, -800.0>
  }
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <1130.0, 2020.0, -800.0>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 900.0>
    translate  <530.0, 2020.0, -700.0>
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <70.0, 2220.0, -800.0>
  }
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 900.0>
    translate  <530.0, 2220.0, -700.0>
  }
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <-730.0, 2020.0, -800.0>
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <1130.0, 1590.0, -800.0>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <1130.0, 790.0, -800.0>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 800.0>
    translate  <1130.0, 390.0, -800.0>
  }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 280.0>
    translate  <70.0, 2020.0, -1325.0>
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 350.0>
    translate  <270.0, 2220.0, -150.0>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 250.0>
    translate  <270.0, 2220.0, -250.0>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 350.0>
    translate  <270.0, 1820.0, -150.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG050 = difference {
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 200.0, 900.0>
    translate  <-200.0, 1990.0, -700.0>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <550.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -180.0>
    translate  <-200.0, 1990.0, -1000.0>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    scale <550.0, 200.0, 350.0>
    translate  <-200.0, 1790.0, -1350.0>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <220.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -90.0>
    translate  <100.0, 1990.0, -1000.0>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 200.0, 350.0>
    rotate -90.0*z
    translate  <300.0, 1990.0, -1350.0>
  }
}
#declare CSG051 = difference {
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 200.0, 300.0>
    translate  <-200.0, 1990.0, -800.0>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <550.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -180.0>
    translate  <-200.0, 1990.0, -1000.0>
  }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    scale <550.0, 200.0, 300.0>
    translate  <-200.0, 1790.0, -1300.0>
  }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <220.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -90.0>
    translate  <100.0, 1990.0, -1000.0>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 200.0, 300.0>
    rotate -90.0*z
    translate  <300.0, 1990.0, -1300.0>
  }
  scale <0.95, 0.9, 1.0>
  translate  <-10.0, 200.0, 0.0>
}
#declare CSG053 = difference {
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    scale <250.0, 200.0, 125.0>
    translate  <50.0, 1900.0, -750.0>
  }
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <220.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -90.0>
    translate  <50.0, 1990.0, -1000.0>
  }
}
#declare CSG054 = difference {
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    scale <250.0, 200.0, 125.0>
    translate  <50.0, 1950.0, -750.0>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <550.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -180.0>
    translate  <-200.0, 2040.0, -1000.0>
  }
}
#declare CSG055 = difference {
  object { CSG050 }
  object { CSG051 }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 200.0, 125.0>
    translate  <-450.0, 1900.0, -750.0>
  }
  object { CSG053 }
  object { CSG054 }
  box { // ExhaustSpacer
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 200.0, 163.333328>
    translate  <-200.0, 1950.0, -200.0>
  }
  box { // Door_Spacer19
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 100.0, 81.0>
    translate  <-190.0, 2055.0, -1520.0>
  }
  box { // Door_Spacer20
    <-1, -1, -1>, <1, 1, 1>
    scale <51.0, 50.0, 200.0>
    translate  <-190.0, 2102.0, -1184.0>
  }
}
#declare CSG056 = difference {
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 200.0, 300.0>
    translate  <-200.0, 1990.0, -800.0>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <550.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -180.0>
    translate  <-200.0, 1990.0, -1000.0>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    scale <550.0, 200.0, 350.0>
    translate  <-200.0, 1790.0, -1350.0>
  }
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <220.0, 500.0, 100.0>
    rotate <-62.5, -180.0, -90.0>
    translate  <100.0, 1990.0, -1000.0>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 200.0, 350.0>
    rotate -90.0*z
    translate  <300.0, 1990.0, -1350.0>
  }
  material {
    KongDome
  }
  scale <0.98, 0.98, 0.99>
  translate  <-4.0, 40.0, 0.0>
}
#declare Observation = union {
  object { CSG055 }
  object { CSG056 }
  material {
    White
  }
  translate  <-10.0, 10.0, 0.0>
}
#declare CSG057 = difference {
  box { // Floor2
    <-1, -1, -1>, <1, 1, 1>
    scale <2055.0, 2455.0, 30.0>
    translate  <200.0, 990.0, -1050.0>
  }
  box { // Floor3
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 1200.0, 40.0>
    translate  <200.0, 990.0, -1050.0>
  }
}
#declare CSG059 = difference {
  box { // Floor4
    <-1, -1, -1>, <1, 1, 1>
    scale <2055.0, 2455.0, 30.0>
    translate  <200.0, 990.0, -1050.0>
  }
  box { // Floor5
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 1200.0, 40.0>
    translate  <200.0, 990.0, -1050.0>
  }
  translate  500.0*z
}
#declare CSG121 = difference {
  box { // Floor6
    <-1, -1, -1>, <1, 1, 1>
    scale <2055.0, 2455.0, 30.0>
    translate  <200.0, 990.0, -1050.0>
  }
  box { // Floor7
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 1200.0, 40.0>
    translate  <200.0, 990.0, -1050.0>
  }
  translate  850.0*z
}
union { // Factory_Walls
  object { Walls3 }
  object { Pillars2 }
  object { Observation }
  box { // Floor1
    <-1, -1, -1>, <1, 1, 1>
    scale <2055.0, 2455.0, 30.0>
    translate  <200.0, 990.0, -1630.0>
  }
  object { CSG057 }
  object { CSG059 }
  object { CSG121 }
  material {
    FloorTiles
  }
}


#declare CSG060 = union {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG061 = difference {
  object { CSG060 }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG062 = intersection {
  object { CSG061 }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door1 = union {
  object { CSG062 }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-157.0 to   157.0)
  translate  Door1Location
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.05, 0.85>,
  <-1.05, 0.2>,
  <-1.1, 0.1>,
  <-1.1, -0.1>,
  <-1.05, -0.2>,
  <-1.05, -0.7>,
  <-1.1, -0.8>,
  <-1.1, -1.0>,
  <-0.85, -1.0>,
  <-0.95, -0.8>,
  <-0.95, 0.85>,
  <-0.85, 0.95>,
  <0.85, 0.95>,
  <0.95, 0.85>,
  <0.95, -0.8>,
  <0.85, -1.0>,
  <1.1, -1.0>,
  <1.1, -0.8>,
  <1.05, -0.7>,
  <1.05, -0.2>,
  <1.1, -0.1>,
  <1.1, 0.1>,
  <1.05, 0.2>,
  <1.05, 0.85>,
  <1.1, 0.95>,
  <0.9, 1.15>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.15>,
  <-1.1, 0.95>,
  <-1.05, 0.85>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.875>,
  <-1.025, 0.2>,
  <-1.075, 0.1>,
  <-1.075, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.725>,
  <-1.075, -0.8>,
  <-1.075, -0.95>,
  <-0.925, -0.95>,
  <-0.975, -0.85>,
  <-0.975, 0.875>,
  <-0.85, 0.975>,
  <0.85, 0.975>,
  <0.975, 0.875>,
  <0.975, -0.85>,
  <0.925, -0.95>,
  <1.075, -0.95>,
  <1.075, -0.8>,
  <1.025, -0.725>,
  <1.025, -0.2>,
  <1.075, -0.1>,
  <1.075, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.875>,
  <1.05, 0.95>,
  <0.9, 1.1>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.1>,
  <-1.05, 0.95>,
  <-1.025, 0.875>
  rotate -x*90
  scale <50.0, 80.0, 34.0>
  rotate 90.0*x
  translate  <0.0, 17.0, 80.0>
}
#declare CSG063 = union {
  object { TransSweep003 }
  object { TransSweep004 }
  material {
    T_Chrome_3A
  }
}
#declare CSG065 = difference {
  object { CSG063 }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts1 = union {
  object { CSG065 }
  // All transformations fixed
}
#declare Doorway1 = union {
  object { Door1 }
  object { Parts1 }
  scale <4.0, 1.9, 2.0>
  translate  <800.0, -240.0, -1600.0>
}
#declare CSG066 = union {
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG067 = difference {
  object { CSG066 }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG068 = intersection {
  object { CSG067 }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door2 = union {
  object { CSG068 }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate 80*z 
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door2Location
}
#declare TransSweep005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.05, 0.8>,
  <-1.05, 0.2>,
  <-1.1, 0.1>,
  <-1.1, -0.1>,
  <-1.05, -0.2>,
  <-1.05, -0.7>,
  <-1.1, -0.8>,
  <-1.1, -1.0>,
  <-0.85, -1.0>,
  <-0.95, -0.8>,
  <-0.95, 0.8>,
  <-0.9, 0.9>,
  <0.9, 0.9>,
  <0.95, 0.8>,
  <0.95, -0.8>,
  <0.85, -1.0>,
  <1.1, -1.0>,
  <1.1, -0.8>,
  <1.05, -0.7>,
  <1.05, -0.2>,
  <1.1, -0.1>,
  <1.1, 0.1>,
  <1.05, 0.2>,
  <1.05, 0.8>,
  <1.1, 0.9>,
  <0.9, 1.2>,
  <0.8, 1.1>,
  <-0.8, 1.1>,
  <-0.9, 1.2>,
  <-1.1, 0.9>,
  <-1.05, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.825>,
  <-1.025, 0.2>,
  <-1.075, 0.1>,
  <-1.075, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.725>,
  <-1.075, -0.8>,
  <-1.075, -0.95>,
  <-0.925, -0.95>,
  <-0.975, -0.85>,
  <-0.975, 0.85>,
  <-0.9, 0.95>,
  <0.9, 0.95>,
  <0.975, 0.85>,
  <0.975, -0.85>,
  <0.925, -0.95>,
  <1.075, -0.95>,
  <1.075, -0.8>,
  <1.025, -0.725>,
  <1.025, -0.2>,
  <1.075, -0.1>,
  <1.075, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.825>,
  <1.05, 0.9>,
  <0.9, 1.125>,
  <0.825, 1.05>,
  <-0.825, 1.05>,
  <-0.9, 1.15>,
  <-1.05, 0.9>,
  <-1.025, 0.825>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare CSG069 = union {
  object { TransSweep005 }
  object { TransSweep006 }
  material {
    T_Chrome_3A
  }
}
#declare CSG072 = difference {
  object { CSG069 }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts2 = union {
  object { CSG072 }
  // All transformations fixed
}
#declare Doorway2 = union {
  object { Door2 }
  object { Parts2 }
  scale <6.0, 1.9, 2.0>
  rotate 90.0*z
  translate  <1130.0, 1190.0, -1018.5>
}
#declare CSG073 = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG074 = difference {
  object { CSG073 }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG075 = intersection {
  object { CSG074 }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door3 = union {
  object { CSG075 }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG076 = union {
  object { TransSweep007 }
  object { TransSweep008 }
  material {
    T_Chrome_3A
  }
}
#declare CSG077 = difference {
  object { CSG076 }
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts3 = union {
  object { CSG077 }
  // All transformations fixed
}
#declare Doorway3 = union {
  object { Door3 }
  object { Parts3 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <530.0, 2120.0, -518.5>
}
#declare CSG078 = union {
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG079 = difference {
  object { CSG078 }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG080 = intersection {
  object { CSG079 }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door4 = union {
  object { CSG080 }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door4Location
}
#declare TransSweep009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.05, 0.8>,
  <-1.05, 0.2>,
  <-1.1, 0.1>,
  <-1.1, -0.1>,
  <-1.05, -0.2>,
  <-1.05, -0.7>,
  <-1.1, -0.8>,
  <-1.1, -1.0>,
  <-0.85, -1.0>,
  <-0.95, -0.8>,
  <-0.95, 0.8>,
  <-0.9, 0.9>,
  <0.9, 0.9>,
  <0.95, 0.8>,
  <0.95, -0.8>,
  <0.85, -1.0>,
  <1.1, -1.0>,
  <1.1, -0.8>,
  <1.05, -0.7>,
  <1.05, -0.2>,
  <1.1, -0.1>,
  <1.1, 0.1>,
  <1.05, 0.2>,
  <1.05, 0.8>,
  <1.1, 0.9>,
  <0.9, 1.2>,
  <0.8, 1.1>,
  <-0.8, 1.1>,
  <-0.9, 1.2>,
  <-1.1, 0.9>,
  <-1.05, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.825>,
  <-1.025, 0.2>,
  <-1.075, 0.1>,
  <-1.075, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.725>,
  <-1.075, -0.8>,
  <-1.075, -0.95>,
  <-0.925, -0.95>,
  <-0.975, -0.85>,
  <-0.975, 0.85>,
  <-0.9, 0.95>,
  <0.9, 0.95>,
  <0.975, 0.85>,
  <0.975, -0.85>,
  <0.925, -0.95>,
  <1.075, -0.95>,
  <1.075, -0.8>,
  <1.025, -0.725>,
  <1.025, -0.2>,
  <1.075, -0.1>,
  <1.075, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.825>,
  <1.05, 0.9>,
  <0.9, 1.125>,
  <0.825, 1.05>,
  <-0.825, 1.05>,
  <-0.9, 1.15>,
  <-1.05, 0.9>,
  <-1.025, 0.825>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare CSG081 = union {
  object { TransSweep009 }
  object { TransSweep010 }
  material {
    T_Chrome_3A
  }
}
#declare CSG083 = difference {
  object { CSG081 }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts4 = union {
  object { CSG083 }
  // All transformations fixed
}
#declare Doorway4 = union {
  object { Door4 }
  object { Parts4 }
  scale <6.0, 1.9, 2.0>
  rotate 90.0*z
  translate  <-730.0, 1590.0, -1600.0>
}
#declare CSG084 = union {
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG085 = difference {
  object { CSG084 }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG086 = intersection {
  object { CSG085 }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door5 = union {
  object { CSG086 }
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate 80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door5Location
}
#declare TransSweep011 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep012 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG087 = union {
  object { TransSweep011 }
  object { TransSweep012 }
  material {
    T_Chrome_3A
  }
}
#declare CSG088 = difference {
  object { CSG087 }
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts5 = union {
  object { CSG088 }
  // All transformations fixed
}
#declare Doorway5 = union {
  object { Door5 }
  object { Parts5 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <1130.0, 1890.0, -518.5>
}
#declare CSG089 = union {
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG090 = difference {
  object { CSG089 }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG093 = intersection {
  object { CSG090 }
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door6 = union {
  object { CSG093 }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep013 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep014 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG096 = union {
  object { TransSweep013 }
  object { TransSweep014 }
  material {
    T_Chrome_3A
  }
}
#declare CSG097 = difference {
  object { CSG096 }
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts6 = union {
  object { CSG097 }
  // All transformations fixed
}
#declare Doorway6 = union {
  object { Door6 }
  object { Parts6 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <1130.0, 275.0, -518.5>
}
#declare CSG098 = union {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG099 = difference {
  object { CSG098 }
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG101 = intersection {
  object { CSG099 }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door7 = union {
  object { CSG101 }
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep015 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep016 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG102 = union {
  object { TransSweep015 }
  object { TransSweep016 }
  material {
    T_Chrome_3A
  }
}
#declare CSG103 = difference {
  object { CSG102 }
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts7 = union {
  object { CSG103 }
  // All transformations fixed
}
#declare Doorway7 = union {
  object { Door7 }
  object { Parts7 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <-730.0, -110.0, -518.5>
}
#declare CSG104 = union {
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG105 = difference {
  object { CSG104 }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG106 = intersection {
  object { CSG105 }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door8 = union {
  object { CSG106 }
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door8Location
}
#declare TransSweep017 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep018 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG107 = union {
  object { TransSweep017 }
  object { TransSweep018 }
  material {
    T_Chrome_3A
  }
}
#declare CSG108 = difference {
  object { CSG107 }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts8 = union {
  object { CSG108 }
  // All transformations fixed
}
#declare Doorway8 = union {
  object { Door8 }
  object { Parts8 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <-730.0, 505.0, -518.5>
}
#declare CSG109 = union {
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG110 = difference {
  object { CSG109 }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG113 = intersection {
  object { CSG110 }
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door9 = union {
  object { CSG113 }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door9Location
}
#declare TransSweep019 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.05, 0.85>,
  <-1.05, 0.2>,
  <-1.1, 0.1>,
  <-1.1, -0.1>,
  <-1.05, -0.2>,
  <-1.05, -0.7>,
  <-1.1, -0.8>,
  <-1.1, -1.0>,
  <-0.85, -1.0>,
  <-0.95, -0.8>,
  <-0.95, 0.85>,
  <-0.85, 0.95>,
  <0.85, 0.95>,
  <0.95, 0.85>,
  <0.95, -0.8>,
  <0.85, -1.0>,
  <1.1, -1.0>,
  <1.1, -0.8>,
  <1.05, -0.7>,
  <1.05, -0.2>,
  <1.1, -0.1>,
  <1.1, 0.1>,
  <1.05, 0.2>,
  <1.05, 0.85>,
  <1.1, 0.95>,
  <0.9, 1.15>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.15>,
  <-1.1, 0.95>,
  <-1.05, 0.85>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep020 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.875>,
  <-1.025, 0.2>,
  <-1.075, 0.1>,
  <-1.075, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.725>,
  <-1.075, -0.8>,
  <-1.075, -0.95>,
  <-0.925, -0.95>,
  <-0.975, -0.85>,
  <-0.975, 0.875>,
  <-0.85, 0.975>,
  <0.85, 0.975>,
  <0.975, 0.875>,
  <0.975, -0.85>,
  <0.925, -0.95>,
  <1.075, -0.95>,
  <1.075, -0.8>,
  <1.025, -0.725>,
  <1.025, -0.2>,
  <1.075, -0.1>,
  <1.075, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.875>,
  <1.05, 0.95>,
  <0.9, 1.1>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.1>,
  <-1.05, 0.95>,
  <-1.025, 0.875>
  rotate -x*90
  scale <50.0, 80.0, 34.0>
  rotate 90.0*x
  translate  <0.0, 17.0, 80.0>
}
#declare CSG114 = union {
  object { TransSweep019 }
  object { TransSweep020 }
  material {
    T_Chrome_3A
  }
}
#declare CSG115 = difference {
  object { CSG114 }
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts9 = union {
  object { CSG115 }
  // All transformations fixed
}
#declare Doorway9 = union {
  object { Door9 }
  object { Parts9 }
  scale <4.0, 1.9, 2.0>
  rotate 90.0*z
  translate  <-730.0, 890.0, -1018.5>
}
#declare CSG116 = union {
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube420
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube421
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube422
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube423
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube424
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube425
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube426
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube427
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG117 = difference {
  object { CSG116 }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG123 = intersection {
  object { CSG117 }
  box { // Cube428
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door10 = union {
  object { CSG123 }
  box { // Cube429
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep021 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep022 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG124 = union {
  object { TransSweep021 }
  object { TransSweep022 }
  material {
    T_Chrome_3A
  }
}
#declare CSG125 = difference {
  object { CSG124 }
  box { // Cube430
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts10 = union {
  object { CSG125 }
  // All transformations fixed
}
#declare Doorway10 = union {
  object { Door10 }
  object { Parts10 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <-730.0, 505.0, -1518.5>
}
#declare CSG126 = union {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube431
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube432
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube433
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube434
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube435
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube436
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube437
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube438
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG127 = difference {
  object { CSG126 }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG128 = intersection {
  object { CSG127 }
  box { // Cube439
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door11 = union {
  object { CSG128 }
  box { // Cube440
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door11Location
}
#declare TransSweep023 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep024 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG129 = union {
  object { TransSweep023 }
  object { TransSweep024 }
  material {
    T_Chrome_3A
  }
}
#declare CSG130 = difference {
  object { CSG129 }
  box { // Cube441
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts11 = union {
  object { CSG130 }
  // All transformations fixed
}
#declare Doorway11 = union {
  object { Door11 }
  object { Parts11 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <-730.0, -110.0, -1518.5>
}
#declare CSG131 = union {
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube442
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube443
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube444
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube445
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube446
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube447
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube448
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube449
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG132 = difference {
  object { CSG131 }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG133 = intersection {
  object { CSG132 }
  box { // Cube450
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door12 = union {
  object { CSG133 }
  box { // Cube451
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
}
#declare TransSweep025 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep026 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG134 = union {
  object { TransSweep025 }
  object { TransSweep026 }
  material {
    T_Chrome_3A
  }
}
#declare CSG135 = difference {
  object { CSG134 }
  box { // Cube452
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts12 = union {
  object { CSG135 }
  // All transformations fixed
}
#declare Doorway12 = union {
  object { Door12 }
  object { Parts12 }
  scale <1.0, 1.9, 1.0>
  translate  <385.0, -240.0, -1518.0>
}
#declare CSG136 = union {
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube453
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube454
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube455
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube456
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube457
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube458
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube459
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube460
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG137 = difference {
  object { CSG136 }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG138 = intersection {
  object { CSG137 }
  box { // Cube461
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door13 = union {
  object { CSG138 }
  box { // Cube462
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door13Location
}
#declare TransSweep027 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep028 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG139 = union {
  object { TransSweep027 }
  object { TransSweep028 }
  material {
    T_Chrome_3A
  }
}
#declare CSG140 = difference {
  object { CSG139 }
  box { // Cube463
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts13 = union {
  object { CSG140 }
  // All transformations fixed
}
#declare Doorway13 = union {
  object { Door13 }
  object { Parts13 }
  scale <1.0, 1.9, 1.0>
  translate  <650.0, 2020.0, -1518.5>
}
#declare CSG141 = union {
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube464
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube465
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube466
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube467
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube468
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube469
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube470
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube471
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG142 = difference {
  object { CSG141 }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG143 = intersection {
  object { CSG142 }
  box { // Cube472
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door14 = union {
  object { CSG143 }
  box { // Cube473
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door14Location
}
#declare TransSweep029 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep030 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG144 = union {
  object { TransSweep029 }
  object { TransSweep030 }
  material {
    T_Chrome_3A
  }
}
#declare CSG145 = difference {
  object { CSG144 }
  box { // Cube474
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts14 = union {
  object { CSG145 }
  // All transformations fixed
}
#declare Doorway14 = union {
  object { Door14 }
  object { Parts14 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <1130.0, 1890.0, -1518.5>
}
#declare CSG146 = union {
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube475
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube476
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube477
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube478
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube479
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube480
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube481
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube482
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG147 = difference {
  object { CSG146 }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG148 = intersection {
  object { CSG147 }
  box { // Cube483
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door15 = union {
  object { CSG148 }
  box { // Cube484
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80.0*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  157.0*z
}
#declare TransSweep031 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep032 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG149 = union {
  object { TransSweep031 }
  object { TransSweep032 }
  material {
    T_Chrome_3A
  }
}
#declare CSG150 = difference {
  object { CSG149 }
  box { // Cube485
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts15 = union {
  object { CSG150 }
  // All transformations fixed
}
#declare Doorway15 = union {
  object { Door15 }
  object { Parts15 }
  scale <2.5, 1.9, 2.5>
  translate  <315.0, 2220.0, -1600.0>
}
#declare CSG151 = union {
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube486
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube487
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube488
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube489
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube490
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube491
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube492
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube493
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG152 = difference {
  object { CSG151 }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG153 = intersection {
  object { CSG152 }
  box { // Cube494
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door16 = union {
  object { CSG153 }
  box { // Cube495
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door16Location
}
#declare TransSweep033 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep034 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG154 = union {
  object { TransSweep033 }
  object { TransSweep034 }
  material {
    T_Chrome_3A
  }
}
#declare CSG155 = difference {
  object { CSG154 }
  box { // Cube496
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts16 = union {
  object { CSG155 }
  // All transformations fixed
}
#declare Doorway16 = union {
  object { Door16 }
  object { Parts16 }
  scale <1.0, 1.9, 1.0>
  translate  <1000.0, -240.0, -1018.5>
}
#declare CSG156 = union {
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube497
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube498
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube499
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube500
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube501
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube502
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube503
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube504
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG157 = difference {
  object { CSG156 }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG158 = intersection {
  object { CSG157 }
  box { // Cube505
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door17 = union {
  object { CSG158 }
  box { // Cube506
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door17Location
}
#declare TransSweep035 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep036 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG159 = union {
  object { TransSweep035 }
  object { TransSweep036 }
  material {
    T_Chrome_3A
  }
}
#declare CSG160 = difference {
  object { CSG159 }
  box { // Cube507
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts17 = union {
  object { CSG160 }
  // All transformations fixed
}
#declare Doorway17 = union {
  object { Door17 }
  object { Parts17 }
  scale <1.0, 1.9, 1.0>
  translate  <-600.0, -240.0, -1018.5>
}
#declare CSG161 = union {
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube508
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube509
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube510
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube511
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube512
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube513
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube514
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube515
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG162 = difference {
  object { CSG161 }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG163 = intersection {
  object { CSG162 }
  box { // Cube516
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door18 = union {
  object { CSG163 }
  box { // Cube517
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door18Location
}
#declare TransSweep037 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep038 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG164 = union {
  object { TransSweep037 }
  object { TransSweep038 }
  material {
    T_Chrome_3A
  }
}
#declare CSG165 = difference {
  object { CSG164 }
  box { // Cube518
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts18 = union {
  object { CSG165 }
  // All transformations fixed
}
#declare Doorway18 = union {
  object { Door18 }
  object { Parts18 }
  scale <1.0, 1.9, 1.0>
  rotate -90.0*z
  translate  <-730.0, 1690.0, -518.5>
}
#declare CSG166 = union {
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
    rotate 90.0*x
    translate  <0.0, 12.5, 80.0>
  }
  box { // Cube519
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    translate  80.0*z
  }
  box { // Cube520
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -60.0*y
    translate  80.0*z
  }
  box { // Cube521
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate -90.0*y
    translate  80.0*z
  }
  box { // Cube522
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, -60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube523
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  80.0*z
  }
  box { // Cube524
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 90.0*y
    translate  80.0*z
  }
  box { // Cube525
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate <180.0, 60.0, 180.0>
    translate  80.0*z
  }
  box { // Cube526
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*x
    scale <50.0, 12.5, 10.0>
    rotate 60.0*y
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG167 = difference {
  object { CSG166 }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate 90.0*x
    translate  <0.0, 15.0, 80.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG168 = intersection {
  object { CSG167 }
  box { // Cube527
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Door19 = union {
  object { CSG168 }
  box { // Cube528
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 9.0, 80.0>
    translate  80*z
  }
  material {
    Aluminum
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-95.5 to   0.0)
  // Trans Z limited (0.0 to   157.0)
  translate  Door19Location
}
#declare TransSweep039 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.1, 0.8>,
  <-1.1, 0.2>,
  <-1.2, 0.1>,
  <-1.2, -0.1>,
  <-1.1, -0.2>,
  <-1.1, -0.7>,
  <-1.2, -0.8>,
  <-1.2, -1.0>,
  <-0.8, -1.0>,
  <-0.9, -0.9>,
  <-0.9, 0.85>,
  <-0.8, 0.95>,
  <0.8, 0.95>,
  <0.9, 0.85>,
  <0.9, -0.9>,
  <0.8, -1.0>,
  <1.2, -1.0>,
  <1.2, -0.8>,
  <1.1, -0.7>,
  <1.1, -0.2>,
  <1.2, -0.1>,
  <1.2, 0.1>,
  <1.1, 0.2>,
  <1.1, 0.8>,
  <1.2, 0.9>,
  <0.9, 1.1>,
  <0.8, 1.05>,
  <-0.8, 1.05>,
  <-0.9, 1.1>,
  <-1.2, 0.9>,
  <-1.1, 0.8>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <50.0, 80.0, 30.0>
  rotate 90.0*x
  translate  <0.0, 15.0, 80.0>
}
#declare TransSweep040 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  31  // control points
  <-1.025, 0.775>,
  <-1.025, 0.2>,
  <-1.125, 0.1>,
  <-1.125, -0.1>,
  <-1.025, -0.2>,
  <-1.025, -0.675>,
  <-1.125, -0.775>,
  <-1.125, -0.975>,
  <-0.825, -0.975>,
  <-0.925, -0.875>,
  <-0.925, 0.875>,
  <-0.825, 0.975>,
  <0.825, 0.975>,
  <0.925, 0.875>,
  <0.925, -0.875>,
  <0.825, -0.975>,
  <1.125, -0.975>,
  <1.125, -0.775>,
  <1.025, -0.675>,
  <1.025, -0.2>,
  <1.125, -0.1>,
  <1.125, 0.1>,
  <1.025, 0.2>,
  <1.025, 0.775>,
  <1.125, 0.875>,
  <0.9, 1.05>,
  <0.825, 1.025>,
  <-0.825, 1.025>,
  <-0.9, 1.05>,
  <-1.125, 0.875>,
  <-1.025, 0.775>
  rotate -x*90
  scale <50.0, 80.0, 32.0>
  rotate 90.0*x
  translate  <0.0, 16.0, 80.0>
}
#declare CSG169 = union {
  object { TransSweep039 }
  object { TransSweep040 }
  material {
    T_Chrome_3A
  }
}
#declare CSG170 = difference {
  object { CSG169 }
  box { // Cube529
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 10.0, 80.0>
    translate  80.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Parts19 = union {
  object { CSG170 }
  // All transformations fixed
}
#declare Doorway19 = union {
  object { Door19 }
  object { Parts19 }
  scale <1.0, 1.9, 1.0>
  translate  <-200.0, 2020.0, -1600.0>
}
union { // Doors
  object { Doorway1 }
  object { Doorway2 }
  object { Doorway3 }
  object { Doorway4 }
  object { Doorway5 }
  object { Doorway6 }
  object { Doorway7 }
  object { Doorway8 }
  object { Doorway9 }
  object { Doorway10 }
  object { Doorway11 }
  object { Doorway12 }
  object { Doorway13 }
  object { Doorway14 }
  object { Doorway15 }
  object { Doorway16 }
  object { Doorway17 }
  object { Doorway18 }
  object { Doorway19 }
}


#declare Downlight = union {
  cone { // Cone002
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale 30.0
    translate  <200.0, 490.0, 0.0>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <200.0, 490.0, 30.0>
  }
  cone { // Cone003
    <0,0,0>, 2.0, <0,0,1>, 1.0
    open
    scale <2.0, 2.0, 5.0>
    translate  <200.0, 490.0, 25.0>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 20.0>
    translate  <200.0, 490.0, 100.0>
  }
  object { Spotlight001 }
  cone { // Lit
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    material {
      LitShade
    }
    scale 29.0
    translate  <200.0, 490.0, 0.0>
  }
  sphere { // Sphere043
    <0,0,0>,1
    material {
      WhiteBulb
    }
    scale 5.0
    translate  <200.0, 490.0, 6.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Downlight1 = union {
  cone { // Cone004
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    scale 30.0
    translate  <200.0, 490.0, 0.0>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <200.0, 490.0, 30.0>
  }
  cone { // Cone005
    <0,0,0>, 2.0, <0,0,1>, 1.0
    open
    scale <2.0, 2.0, 5.0>
    translate  <200.0, 490.0, 25.0>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 20.0>
    translate  <200.0, 490.0, 100.0>
  }
  object { Spotlight002 }
  cone { // Lit1
    <0,0,0>, 1.0, <0,0,1>, 0.0
    open
    material {
      LitShade
    }
    scale 29.0
    translate  <200.0, 490.0, 0.0>
  }
  sphere { // Sphere044
    <0,0,0>,1
    material {
      WhiteBulb
    }
    scale 5.0
    translate  <200.0, 490.0, 6.0>
  }
  material {
    T_Chrome_1A
  }
  translate  800.0*y
}
#declare End = union {
  box { // Cube530
    <-1, -1, -1>, <1, 1, 1>
    scale <1000.0, 15.0, 75.0>
    translate  <200.0, -240.0, 75.0>
  }
  box { // Cube531
    <-1, -1, -1>, <1, 1, 1>
    scale <1000.0, 30.0, 20.0>
    translate  <200.0, -240.0, 0.0>
  }
}
#declare End1 = union {
  box { // Cube532
    <-1, -1, -1>, <1, 1, 1>
    scale <1000.0, 15.0, 75.0>
    translate  <200.0, -180.0, 75.0>
  }
  box { // Cube533
    <-1, -1, -1>, <1, 1, 1>
    scale <1000.0, 30.0, 20.0>
    translate  <200.0, -180.0, 0.0>
  }
  translate  2400.0*y
}
#declare CSG171 = difference {
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale <130.0, 130.0, 30.0>
    rotate 90.0*x
    translate  <1015.0, -225.0, -125.0>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <100.0, 100.0, 40.0>
    rotate 90.0*x
    translate  <1015.0, -220.0, -125.0>
  }
  box { // Cube537
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    scale <150.0, 20.0, 150.0>
    rotate <0.0, -45.0, -0.0>
    translate  <1015.0, -240.0, -125.0>
  }
  box { // Cube538
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 20.0, 150.0>
    translate  <1015.0, -240.0, -275.0>
  }
  translate  <25.0, 240.0, 0.0>
}
#declare CSG172 = difference {
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale <130.0, 130.0, 30.0>
    rotate 90.0*x
    translate  <1015.0, -225.0, -125.0>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <100.0, 100.0, 40.0>
    rotate 90.0*x
    translate  <1015.0, -220.0, -125.0>
  }
  box { // Cube540
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    scale <150.0, 20.0, 150.0>
    rotate <0.0, -45.0, -0.0>
    translate  <1015.0, -240.0, -125.0>
  }
  box { // Cube541
    <-1, -1, -1>, <1, 1, 1>
    scale <150.0, 20.0, 150.0>
    translate  <865.0, -240.0, -125.0>
  }
  translate  <-110.0, 240.0, 135.0>
}
#declare Ceiling = union {
  box { // Cube534
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 200.0>
    translate  <-755.0, 0.0, -85.0>
  }
  box { // Cube535
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 15.0, 200.0>
    translate  <1155.0, 0.0, -85.0>
  }
  box { // Cube536
    <-1, -1, -1>, <1, 1, 1>
    scale <945.0, 15.0, 15.0>
    translate  <200.0, 0.0, 125.0>
  }
  object { CSG171 }
  box { // Cube539
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.8, 0.0, -7.666667>
    scale <100.0, 15.0, 15.0>
    rotate <-0.0, -135.0, -0.0>
    translate  <1027.5, 0.0, -112.5>
  }
  object { CSG172 }
  object { // CSG173->CSG175
    CSG175
    scale <-1.0, 1.0, 1.0>
    translate  <375.0, 210.0, 0.0>
  }
  object { // CSG174->CSG176
    CSG176
    scale -1.0
    rotate -180.0*x
    translate  <400.0, 210.0, 25.0>
  }
  box { // Cube542
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.8, 0.0, -7.666667>
    scale <100.0, 15.0, 15.0>
    rotate <-0.0, -225.0, -0.0>
    translate  <-627.5, 0.0, -112.5>
  }
  scale <1.0, 90.0, 1.0>
  translate  990.0*y
}
#declare RoofParts = difference {
  object { Ceiling }
  box { // HutSpacer2
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 170.0, 200.0>
    translate  <0.0, 50.0, 70.0>
  }
}
#declare Rafters = union {
  object { Rafter }
  object { // CSG179->Rafter
    Rafter
    translate  200.0*y
  }
  object { // CSG180->Rafter
    Rafter
    translate  400.0*y
  }
  object { // CSG181->Rafter
    Rafter
    translate  600.0*y
  }
  object { // CSG182->Rafter
    Rafter
    translate  800.0*y
  }
  object { // CSG183->Rafter
    Rafter
    translate  1000.0*y
  }
  object { // CSG184->Rafter
    Rafter
    translate  1200.0*y
  }
  object { // CSG185->Rafter
    Rafter
    translate  1400.0*y
  }
  object { // CSG186->Rafter
    Rafter
    translate  1600.0*y
  }
  object { // CSG187->Rafter
    Rafter
    translate  1800.0*y
  }
  object { // CSG188->Rafter
    Rafter
    translate  2000.0*y
  }
  object { // CSG189->Rafter
    Rafter
    translate  2200.0*y
  }
  object { // CSG190->Rafter
    Rafter
    translate  2400.0*y
  }
}
#declare RoofSupport = difference {
  object { Rafters }
  box { // HutSpacer
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 170.0, 200.0>
    translate  <0.0, 50.0, 70.0>
  }
  material {
    T_Chrome_1A
  }
}
#declare Hut_Support = difference {
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <300.0, 300.0, 150.0>
    translate  120.0*z
  }
  box { // HutSpacer1
    <-1, -1, -1>, <1, 1, 1>
    scale <220.0, 170.0, 200.0>
    translate  <0.0, 50.0, 70.0>
  }
}
#declare Skirting16 = difference {
  box { // Cube552
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube553
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube554
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube555
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <90.900002, 1.0, 1.0>
  translate  <200.0, -215.0, -555.0>
}
#declare Skirting17 = difference {
  box { // Cube556
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube557
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube558
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube559
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <100.900002, 1.0, 1.0>
  rotate -90.0*z
  translate  <-705.0, 790.0, -555.0>
}
#declare Skirting18 = difference {
  box { // Cube560
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube561
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube562
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube563
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <110.900002, 1.0, 1.0>
  rotate 90.0*z
  translate  <1105.0, 890.0, -555.0>
}
#declare Skirting20 = difference {
  box { // Cube564
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube565
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube566
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube567
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <400.0, 2195.0, -555.0>
}
#declare Skirting34 = difference {
  box { // Cube568
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube569
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube570
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube571
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <30.9, 1.0, 1.0>
  rotate -180.0*z
  translate  <800.0, 1995.0, -555.0>
}
#declare Skirting35 = difference {
  object { Skirting34 }
  box { // Cube572
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, 90.0>
    translate  <480.0, 1991.0, -590.0>
  }
}
#declare Skirting38 = difference {
  box { // Cube573
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 15.0, 50.0>
  }
  box { // Cube574
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 15.0, 50.0>
    rotate -22.5*x
    translate  <0.0, 25.0, -35.0>
  }
  box { // Cube575
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 15.0, 50.0>
  }
  box { // Cube576
    <-1, -1, -1>, <1, 1, 1>
    scale <10.1, 2.5, 2.5>
    translate  <0.0, 2.5, -50.0>
  }
  scale <10.9, 1.0, 1.0>
  rotate 90.0*z
  translate  <505.0, 2090.0, -555.0>
}
#declare Skirting39 = difference {
  object { Skirting38 }
  box { // Cube577
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 15.0, 50.0>
    rotate <-22.5, 0.0, -180.0>
    translate  <508.0, 1970.0, -590.0>
  }
}
#declare SkirtingMCornice2 = union {
  object { Skirting16 }
  object { Skirting17 }
  object { Skirting18 }
  object { Skirting20 }
  object { Skirting35 }
  object { Skirting39 }
  material {
    Black_Rubber
  }
  translate  300.0*z
}
union { // Roof
  object { Downlight }
  object { Downlight1 }
  object { End }
  object { End1 }
  object { Spill_Light }
  object { RoofParts }
  object { RoofSupport }
  object { Hut_Support }
  object { SkirtingMCornice2 }
  material {
    White
  }
}


#declare CSG195 = difference {
  box { // Cube584
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 25.0>
    translate  <0.0, 30.0, 6.0>
  }
  box { // Cube585
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 15.0, 7.0>
    translate  <-13.0, 8.0, -6.0>
  }
  box { // Cube586
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    scale <25.0, 15.0, 7.0>
    rotate 45.0*x
    translate  <0.0, 23.0, -13.0>
  }
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <10.75, 10.75, 70.0>
    rotate 90.0*x
    translate  <13.5, 30.0, 15.0>
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    scale <10.75, 10.75, 70.0>
    rotate 90.0*x
    translate  <-13.5, 30.0, 15.0>
  }
  box { // Cube587
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 15.0, 7.0>
    translate  <13.0, 8.0, -6.0>
  }
  box { // Cube588
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 2.0, 8.0>
    translate  <13.0, 0.0, -6.0>
  }
  box { // Cube589
    <-1, -1, -1>, <1, 1, 1>
    scale <13.0, 2.0, 8.0>
    translate  <-13.0, 0.0, -6.0>
  }
  translate  -7.0*y
}
#declare CSG196 = intersection {
  box { // Cube590
    <-1, -1, -1>, <1, 1, 1>
    scale 38.0
    rotate 45.0*y
    translate  <0.0, 20.0, 6.0>
  }
  box { // Cube591
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 30.0, 25.0>
    translate  <0.0, 20.0, 6.0>
  }
}
#declare CSG197 = intersection {
  box { // Cube592
    <-1, -1, -1>, <1, 1, 1>
    scale <27.0, 27.0, 22.0>
    translate  6.0*z
  }
  box { // Cube593
    <-1, -1, -1>, <1, 1, 1>
    scale 32.0
    rotate 45.0*y
    translate  6.0*z
  }
}
#declare CSG198 = difference {
  object { CSG196 }
  object { CSG197 }
  material {
    Black_Rubber
  }
}
union { // Exhaust
  object { Fan }
  object { // Fan1->Fan
    Fan
    translate  -27.0*x
  }
  object { CSG195 }
  object { CSG198 }
  box { // Cube594
    <-1, -1, -1>, <1, 1, 1>
    material {
      FlyWire
    }
    scale <26.0, 0.1, 8.0>
    translate  <0.0, -4.0, -6.0>
  }
  material {
    T_Chrome_3A
  }
  scale 7.5
  translate  <-210.0, 1853.0, -245.0>
}


#declare CSG199 = union {
  box { // Cube595
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube596
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube597
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  material {
    Metal
  }
  translate  <-400.0, 90.0, -500.0>
}
#declare CSG200 = union {
  box { // Cube598
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube599
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube600
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  material {
    Metal
  }
  translate  <800.0, 90.0, -500.0>
}
#declare CSG201 = union {
  box { // Cube601
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube602
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube603
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  material {
    Metal
  }
  translate  <1000.0, 90.0, -500.0>
}
#declare CSG202 = union {
  box { // Cube604
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 95.0, 8.0>
    translate  -28.25*z
  }
  box { // Cube605
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -20.0*z
  }
  box { // Cube606
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 99.0, 1.5>
    translate  -35.0*z
  }
  material {
    Metal
  }
  translate  <-600.0, 90.0, -500.0>
}
#declare Flooring = union {
  object { CSG199 }
  object { CSG200 }
  object { CSG201 }
  object { CSG202 }
}
#declare HBeam = union {
  box { // Cube607
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 2.5, 30.0>
    translate  <200.0, 20.0, -575.0>
  }
  box { // Cube608
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -547.5>
  }
  box { // Cube609
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -602.5>
  }
  material {
    T_Chrome_1A
  }
  translate  <0.0, -15.0, 8.5>
}
#declare HBeam1 = union {
  box { // Cube610
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 2.5, 30.0>
    translate  <200.0, 20.0, -575.0>
  }
  box { // Cube611
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -547.5>
  }
  box { // Cube612
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -602.5>
  }
  material {
    T_Chrome_1A
  }
  translate  <0.0, 155.0, 8.5>
}
#declare Rail = union {
  sphere { // Sphere046
    <0,0,0>,1
    scale 2.0
    translate  <-200.0, 30.0, -445.0>
  }
  sphere { // Sphere047
    <0,0,0>,1
    scale 2.0
    translate  <-290.0, 50.0, -445.0>
  }
  sphere { // Sphere048
    <0,0,0>,1
    scale 2.0
    translate  <-110.0, 50.0, -445.0>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 180.0>
    rotate <90.0, 0.0, -90.0>
    translate  <-110.0, 30.0, -445.0>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*x
    translate  <-110.0, 50.0, -445.0>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*x
    translate  <-290.0, 50.0, -445.0>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-290.0, 50.0, -520.0>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-110.0, 50.0, -520.0>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-200.0, 30.0, -520.0>
  }
  sphere { // Sphere049
    <0,0,0>,1
    scale 2.0
    translate  <-290.0, 30.0, -445.0>
  }
  sphere { // Sphere050
    <0,0,0>,1
    scale 2.0
    translate  <-110.0, 30.0, -445.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare Rail1 = union {
  sphere { // Sphere051
    <0,0,0>,1
    scale 2.0
    translate  <-200.0, 30.0, -445.0>
  }
  sphere { // Sphere052
    <0,0,0>,1
    scale 2.0
    translate  <-290.0, 50.0, -445.0>
  }
  sphere { // Sphere053
    <0,0,0>,1
    scale 2.0
    translate  <-110.0, 50.0, -445.0>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 180.0>
    rotate <90.0, 0.0, -90.0>
    translate  <-110.0, 30.0, -445.0>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*x
    translate  <-110.0, 50.0, -445.0>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 20.0>
    rotate 90.0*x
    translate  <-290.0, 50.0, -445.0>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-290.0, 50.0, -520.0>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-110.0, 50.0, -520.0>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 75.0>
    translate  <-200.0, 30.0, -520.0>
  }
  sphere { // Sphere054
    <0,0,0>,1
    scale 2.0
    translate  <-290.0, 30.0, -445.0>
  }
  sphere { // Sphere055
    <0,0,0>,1
    scale 2.0
    translate  <-110.0, 30.0, -445.0>
  }
  material {
    T_Chrome_2E
  }
  scale <1.0, -1.0, 1.0>
  translate  180.0*y
}
#declare Carriage = union {
  box { // Cube613
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_3A
    }
    scale <95.0, 71.0, 8.0>
    translate  <-200.0, 90.0, -528.25>
  }
  box { // Cube614
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -520.0>
  }
  box { // Cube615
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -535.0>
  }
  object { WheelGroup }
  object { // WheelGroup1->WheelGroup
    WheelGroup
    translate  170.0*y
  }
  object { WheelArch }
  object { // WheelArch1->WheelArch
    WheelArch
    translate  170.0*y
  }
  object { // WheelArch2->WheelArch
    WheelArch
    translate  <125.0, 170.0, 0.0>
  }
  object { // WheelArch3->WheelArch
    WheelArch
    translate  125.0*x
  }
  object { Straps }
  object { // Straps1->Straps
    Straps
    translate  125.0*x
  }
  object { // Straps2->Straps
    Straps
    scale <1.0, -1.0, 1.0>
    translate  <125.0, 180.0, 0.0>
  }
  object { // Straps3->Straps
    Straps
    scale <1.0, -1.0, 1.0>
    translate  180.0*y
  }
  object { Rail }
  object { Rail1 }
  material {
    Metal
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (16.0 to   784.0)
  translate  ShifterCarriageLocation
}
#declare CSG207 = difference {
  box { // Cube623
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube624
    <-1, -1, -1>, <1, 1, 1>
    scale <501.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG208 = difference {
  box { // Cube625
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube626
    <-1, -1, -1>, <1, 1, 1>
    scale <501.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
  translate  170.0*y
}
#declare EndRail = union {
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 70.0>
    rotate <-90.0, -180.0, -180.0>
    translate  <-320.0, 30.0, -425.0>
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 70.0>
    rotate <90.0, -180.0, -180.0>
    translate  <-320.0, 150.0, -425.0>
  }
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-320.0, 150.0, -525.0>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-320.0, 30.0, -525.0>
  }
  sphere { // Sphere056
    <0,0,0>,1
    scale 2.0
    translate  <-320.0, 30.0, -425.0>
  }
  sphere { // Sphere057
    <0,0,0>,1
    scale 2.0
    translate  <-320.0, 150.0, -425.0>
  }
  material {
    T_Chrome_2E
  }
}
#declare EndRail1 = union {
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 70.0>
    rotate <-90.0, -180.0, -180.0>
    translate  <-320.0, 30.0, -425.0>
  }
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 70.0>
    rotate <90.0, -180.0, -180.0>
    translate  <-320.0, 150.0, -425.0>
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-320.0, 150.0, -525.0>
  }
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 100.0>
    translate  <-320.0, 30.0, -525.0>
  }
  sphere { // Sphere058
    <0,0,0>,1
    scale 2.0
    translate  <-320.0, 30.0, -425.0>
  }
  sphere { // Sphere059
    <0,0,0>,1
    scale 2.0
    translate  <-320.0, 150.0, -425.0>
  }
  material {
    T_Chrome_2E
  }
  scale <-1.0, 1.0, 1.0>
  translate  400.0*x
}
#declare Bumpers = union {
  box { // Cube627
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 15.0, 10.0>
    translate  <200.0, -20.0, -527.5>
  }
  box { // Cube628
    <-1, -1, -1>, <1, 1, 1>
    scale <500.0, 15.0, 10.0>
    translate  <200.0, 200.0, -527.5>
  }
  box { // Cube629
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <700.0, 90.0, -527.5>
  }
  box { // Cube630
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <-300.0, 90.0, -527.5>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <700.0, 200.0, -537.5>
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <700.0, -20.0, -537.5>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-300.0, -20.0, -537.5>
  }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-300.0, 200.0, -537.5>
  }
  material {
    Black_Rubber
  }
}
union { // Shifter
  object { Flooring }
  object { HBeam }
  object { HBeam1 }
  object { Carriage }
  object { CSG207 }
  object { CSG208 }
  object { EndRail }
  object { EndRail1 }
  object { Bumpers }
  translate  <0.0, 1190.0, -500.0>
}


#declare HBeam2 = union {
  box { // Cube631
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 2.5, 30.0>
    translate  <200.0, 20.0, -575.0>
  }
  box { // Cube632
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -547.5>
  }
  box { // Cube633
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -602.5>
  }
  material {
    T_Chrome_1A
  }
  // All transformations fixed
  translate  <0.0, -15.0, 8.5>
}
#declare HBeam3 = union {
  box { // Cube634
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 2.5, 30.0>
    translate  <200.0, 20.0, -575.0>
  }
  box { // Cube635
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -547.5>
  }
  box { // Cube636
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 2.5>
    translate  <200.0, 20.0, -602.5>
  }
  material {
    T_Chrome_1A
  }
  // All transformations fixed
  translate  <0.0, 155.0, 8.5>
}
#declare CSG209 = difference {
  box { // Cube637
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube638
    <-1, -1, -1>, <1, 1, 1>
    scale <901.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare CSG210 = difference {
  box { // Cube639
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube640
    <-1, -1, -1>, <1, 1, 1>
    scale <901.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  translate  170.0*y
}
#declare Bumpers1 = union {
  box { // Cube641
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <1100.0, 90.0, -527.5>
  }
  box { // Cube642
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <-700.0, 90.0, -527.5>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <1100.0, 200.0, -537.5>
  }
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <1100.0, -20.0, -537.5>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-700.0, -20.0, -537.5>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-700.0, 200.0, -537.5>
  }
  material {
    Black_Rubber
  }
  // All transformations fixed
  scale <1.0, 1.0, 5.0>
  translate  2070.5*z
}
#declare CSG211 = difference {
  box { // Cube643
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube644
    <-1, -1, -1>, <1, 1, 1>
    scale <901.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  scale <1.0, 1.0, -1.0>
  translate  -1133.0*z
}
#declare CSG212 = difference {
  box { // Cube645
    <-1, -1, -1>, <1, 1, 1>
    scale <900.0, 10.0, 5.0>
    translate  <200.0, 5.0, -531.0>
  }
  box { // Cube646
    <-1, -1, -1>, <1, 1, 1>
    scale <901.0, 8.0, 5.0>
    translate  <200.0, 5.0, -529.0>
  }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
  scale <1.0, 1.0, -1.0>
  translate  <0.0, 170.0, -1133.0>
}
#declare Bumpers2 = union {
  box { // Cube647
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <1100.0, 90.0, -527.5>
  }
  box { // Cube648
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 110.0, 10.0>
    translate  <-700.0, 90.0, -527.5>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <1100.0, 200.0, -537.5>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <1100.0, -20.0, -537.5>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-700.0, -20.0, -537.5>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 20.0>
    translate  <-700.0, 200.0, -537.5>
  }
  material {
    Black_Rubber
  }
  // All transformations fixed
  scale <1.0, 1.0, 5.0>
  translate  2070.5*z
}
#declare Carriage1 = union {
  box { // Cube649
    <-1, -1, -1>, <1, 1, 1>
    scale <95.0, 71.0, 8.0>
    translate  <-200.0, 90.0, -528.25>
  }
  box { // Cube650
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -520.0>
  }
  box { // Cube651
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -535.0>
  }
  object { WheelGroup2 }
  object { // WheelGroup3->WheelGroup2
    WheelGroup2
    translate  170.0*y
  }
  object { WheelArch4 }
  object { // WheelArch5->WheelArch4
    WheelArch4
    translate  170.0*y
  }
  object { // WheelArch6->WheelArch4
    WheelArch4
    translate  <125.0, 170.0, 0.0>
  }
  object { // WheelArch7->WheelArch4
    WheelArch4
    translate  125.0*x
  }
  object { Straps4 }
  object { // Straps5->Straps4
    Straps4
    translate  125.0*x
  }
  object { // Straps6->Straps4
    Straps4
    scale <1.0, -1.0, 1.0>
    translate  <125.0, 180.0, 0.0>
  }
  object { // Straps7->Straps4
    Straps4
    scale <1.0, -1.0, 1.0>
    translate  180.0*y
  }
  // All transformations fixed
  scale <0.5, 1.0, 1.0>
}
#declare CSG217 = difference {
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    scale 15.0
    rotate 90.0*x
    translate  7.5*y
  }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate 90.0*x
    translate  7.0*y
  }
  cone { // Cone016
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <13.0, 13.0, 15.0>
    rotate -90.0*x
    translate  -7.0*y
  }
}
#declare Wheel8 = union {
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 12.0>
    rotate 90.0*x
    translate  6.0*y
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    scale <13.0, 13.0, 8.0>
    rotate 90.0*x
    translate  4.0*y
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
    translate  7.5*y
  }
  object { CSG217 }
  // Scaling fixed
  // Translation fixed
  translate  <-280.0, 5.0, -519.0>
}
#declare WheelGroup4 = union {
  object { Wheel8 }
  object { // Wheel9->Wheel4
    Wheel4
    translate  35.0*x
  }
  object { // Wheel10->Wheel4
    Wheel4
    translate  125.0*x
  }
  object { // Wheel11->Wheel4
    Wheel4
    translate  160.0*x
  }
  material {
    T_Chrome_3A
  }
}
#declare CSG218 = difference {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube663
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube664
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  translate  -7.0*x
}
#declare CSG219 = difference {
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    scale 20.0
    rotate 90.0*x
    translate  <-238.0, 15.0, -519.0>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 22.0>
    rotate 90.0*x
    translate  <-238.0, 16.0, -519.0>
  }
  box { // Cube665
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 11.0, 21.0>
    translate  <-253.0, 5.0, -519.0>
  }
  box { // Cube666
    <-1, -1, -1>, <1, 1, 1>
    scale <21.0, 11.0, 15.0>
    translate  <-238.0, 5.0, -534.0>
  }
  scale <-1.0, 1.0, 1.0>
  translate  -518.0*x
}
#declare WheelArch8 = union {
  box { // Cube662
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 10.0, 1.0>
    translate  <-262.5, 5.0, -500.0>
  }
  object { CSG218 }
  object { CSG219 }
}
#declare CSG220 = difference {
  box { // Cube667
    <-1, -1, -1>, <1, 1, 1>
    scale <17.5, 14.14, 14.14>
    rotate 45.0*x
    translate  <-262.5, 15.0, -519.0>
  }
  box { // Cube668
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 11.0, 20.0>
    translate  <-262.0, 4.0, -519.0>
  }
}
#declare Straps8 = union {
  cone { // Cone017
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-280.0, 35.0, -519.0>
  }
  cone { // Cone018
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 20.0
    rotate 90.0*x
    translate  <-245.0, 35.0, -519.0>
  }
  object { CSG220 }
}
#declare Carriage2 = union {
  box { // Cube659
    <-1, -1, -1>, <1, 1, 1>
    scale <95.0, 71.0, 8.0>
    translate  <-200.0, 90.0, -528.25>
  }
  box { // Cube660
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -520.0>
  }
  box { // Cube661
    <-1, -1, -1>, <1, 1, 1>
    scale <99.0, 75.0, 1.5>
    translate  <-200.0, 90.0, -535.0>
  }
  object { WheelGroup4 }
  object { // WheelGroup5->WheelGroup2
    WheelGroup2
    translate  170.0*y
  }
  object { WheelArch8 }
  object { // WheelArch9->WheelArch4
    WheelArch4
    translate  170.0*y
  }
  object { // WheelArch10->WheelArch4
    WheelArch4
    translate  <125.0, 170.0, 0.0>
  }
  object { // WheelArch11->WheelArch4
    WheelArch4
    translate  125.0*x
  }
  object { Straps8 }
  object { // Straps9->Straps4
    Straps4
    translate  125.0*x
  }
  object { // Straps10->Straps4
    Straps4
    scale <1.0, -1.0, 1.0>
    translate  <125.0, 180.0, 0.0>
  }
  object { // Straps11->Straps4
    Straps4
    scale <1.0, -1.0, 1.0>
    translate  180.0*y
  }
  // All transformations fixed
  scale <0.5, 1.0, -1.0>
  translate  -1133.0*z
}
#declare CSG221 = difference {
  box { // Cube669
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 60.0, 60.0>
    translate  <-100.0, 90.0, -595.0>
  }
  box { // Cube670
    <-1, -1, -1>, <1, 1, 1>
    scale <35.0, 50.0, 50.0>
    translate  <-100.0, 90.0, -610.0>
  }
  // All transformations fixed
}
#declare CSG222 = difference {
  torus { // Torus007
    1.03, 0.1  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
  box { // Cube671
    <-1, -1, -1>, <1, 1, 1>
    scale <23.0, 5.0, 13.0>
    translate  <-100.0, 50.0, -363.0>
  }
}
#declare CSG223 = difference {
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    scale <21.0, 21.0, 8.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 54.0, -350.0>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    scale <17.0, 17.0, 10.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 55.0, -350.0>
  }
  torus { // Torus008
    1.03, 0.125  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
}
#declare Pullley = union {
  object { CSG222 }
  object { CSG223 }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 6.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 53.0, -350.0>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 15.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 57.5, -350.0>
  }
  box { // Cube672
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 57.0, -320.0>
  }
  box { // Cube673
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 43.5, -320.0>
  }
  rotate -0.0*z
  translate  <100.0, -50.0, 0.0>
  material {
    T_Chrome_3A
  }
  rotate <0.0, -0.0, 14.0>
  translate  <-100.0, 50.0, 0.0>
}
#declare CSG224 = difference {
  torus { // Torus009
    1.03, 0.1  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
  box { // Cube674
    <-1, -1, -1>, <1, 1, 1>
    scale <23.0, 5.0, 13.0>
    translate  <-100.0, 50.0, -363.0>
  }
}
#declare CSG225 = difference {
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    scale <21.0, 21.0, 8.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 54.0, -350.0>
  }
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    scale <17.0, 17.0, 10.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 55.0, -350.0>
  }
  torus { // Torus010
    1.03, 0.125  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
}
#declare Pullley1 = union {
  object { CSG224 }
  object { CSG225 }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 6.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 53.0, -350.0>
  }
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 15.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 57.5, -350.0>
  }
  box { // Cube675
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 57.0, -320.0>
  }
  box { // Cube676
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 43.5, -320.0>
  }
  rotate -0.0*z
  translate  <100.0, -50.0, 0.0>
  material {
    T_Chrome_3A
  }
  rotate <0.0, -0.0, 14.0>
  translate  <-100.0, 30.0, 0.0>
}
#declare Pulleys = union {
  object { Pullley }
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 250.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 65.0, -300.0>
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-80.0, 55.0, -350.0>
  }
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-80.0, 35.0, -350.0>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 45.0, -350.0>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 25.0, -350.0>
  }
  object { Pullley1 }
  material {
    T_Chrome_2E
  }
  // All transformations fixed
  scale <1.0, 2.0, 2.0>
}
#declare CSG226 = difference {
  torus { // Torus011
    1.03, 0.1  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
  box { // Cube677
    <-1, -1, -1>, <1, 1, 1>
    scale <23.0, 5.0, 13.0>
    translate  <-100.0, 50.0, -363.0>
  }
}
#declare CSG227 = difference {
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    scale <21.0, 21.0, 8.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 54.0, -350.0>
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    scale <17.0, 17.0, 10.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 55.0, -350.0>
  }
  torus { // Torus012
    1.03, 0.125  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
}
#declare Pullley2 = union {
  object { CSG226 }
  object { CSG227 }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 6.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 53.0, -350.0>
  }
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 15.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 57.5, -350.0>
  }
  box { // Cube678
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 57.0, -320.0>
  }
  box { // Cube679
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 43.5, -320.0>
  }
  rotate -0.0*z
  translate  <100.0, -50.0, 0.0>
  material {
    T_Chrome_3A
  }
  rotate <0.0, -0.0, 14.0>
  translate  <-100.0, 50.0, 0.0>
}
#declare CSG228 = difference {
  torus { // Torus013
    1.03, 0.1  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
  box { // Cube680
    <-1, -1, -1>, <1, 1, 1>
    scale <23.0, 5.0, 13.0>
    translate  <-100.0, 50.0, -363.0>
  }
}
#declare CSG229 = difference {
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    scale <21.0, 21.0, 8.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 54.0, -350.0>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    scale <17.0, 17.0, 10.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 55.0, -350.0>
  }
  torus { // Torus014
    1.03, 0.125  rotate -x*90
    scale 20.0
    rotate <90.0, -0.0, 0.0>
    translate  <-100.0, 50.0, -350.0>
  }
}
#declare Pullley3 = union {
  object { CSG228 }
  object { CSG229 }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 18.0, 6.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 53.0, -350.0>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 15.0>
    rotate <90.0, 0.0, -0.0>
    translate  <-100.0, 57.5, -350.0>
  }
  box { // Cube681
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 57.0, -320.0>
  }
  box { // Cube682
    <-1, -1, -1>, <1, 1, 1>
    material {
      Aluminum
    }
    scale <3.0, 1.0, 30.0>
    translate  <-100.0, 43.5, -320.0>
  }
  rotate -0.0*z
  translate  <100.0, -50.0, 0.0>
  material {
    T_Chrome_3A
  }
  rotate <0.0, -0.0, 14.0>
  translate  <-100.0, 30.0, 0.0>
}
#declare CSG230 = union {
  torus { // Torus015
    1.5, 0.25  rotate -x*90
    scale <20.0, 20.0, 30.0>
    rotate 90.0*x
  }
  torus { // Torus016
    1.5, 0.5  rotate -x*90
    scale <20.0, 20.0, 5.0>
    rotate 90.0*x
  }
}
#declare CSG231 = difference {
  object { CSG230 }
  box { // Cube684
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 15.0, 30.0>
    translate  <20.0, 0.0, 22.0>
  }
  material {
    Aluminum
  }
}
#declare Hook = union {
  box { // Cube683
    <-1, -1, -1>, <1, 1, 1>
    material {
      Metal_Smooth
    }
    scale <35.0, 35.0, 30.0>
    translate  105.0*z
  }
  object { CSG231 }
  sphere { // Sphere060
    <0,0,0>,1
    scale 10.0
    translate  30.0*z
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    translate  30.0*z
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 30.0>
    translate  50.0*z
  }
  scale <0.75, 0.75, -0.75>
  translate  <-100.0, 45.0, -206.0>
}
#declare PulleysMovable = union {
  object { Pullley2 }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 250.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 65.0, -300.0>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-80.0, 55.0, -350.0>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-80.0, 35.0, -350.0>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 45.0, -350.0>
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 200.0>
    rotate <0.0, -180.0, -180.0>
    translate  <-120.0, 25.0, -350.0>
  }
  object { Pullley3 }
  object { Hook }
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-2200.0 to   -1800.0)
  scale <1.0, -2.0, -2.0>
  translate  CranePulleysMovableLocation
}
#declare CraneCarriage = union {
  object { Carriage1 }
  object { Carriage2 }
  object { CSG221 }
  object { Pulleys }
  object { PulleysMovable }
  material {
    Metal_Smooth
  }
  // Scaling fixed
  // Rotation fixed
  // Trans X limited (-535.0 to   1135.0)
  translate  CraneCarriageLocation
}
union { // Crane
  object { HBeam2 }
  object { HBeam3 }
  object { CSG209 }
  object { CSG210 }
  object { Bumpers1 }
  object { CSG211 }
  object { CSG212 }
  object { Bumpers2 }
  object { CraneCarriage }
  scale <1.0, 0.5, 0.5>
  translate  <0.0, 845.0, -350.0>
}


#declare Other_Wheels = union {
  object { // Wheel13->Wheel12
    Wheel12
    translate  93.0*y
  }
  object { // Wheel14->Wheel12
    Wheel12
    translate  62.0*y
  }
  object { // Wheel15->Wheel12
    Wheel12
    translate  31.0*y
  }
  object { // Wheel16->Wheel12
    Wheel12
    translate  -31.0*y
  }
  object { // Wheel17->Wheel12
    Wheel12
    translate  -62.0*y
  }
  object { // Wheel18->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, 93.0, 0.0>
  }
  object { // Wheel19->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, 62.0, 0.0>
  }
  object { // Wheel20->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, 31.0, 0.0>
  }
  object { // Wheel21->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, -31.0, 0.0>
  }
  object { // Wheel22->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, -0.0, 0.0>
  }
  object { // Wheel23->Wheel12
    Wheel12
    rotate 0.0*z
    translate  <-120.0, -62.0, 0.0>
  }
  // All transformations fixed
}
#declare Wheels = union {
  object { Wheel12 }
  object { Other_Wheels }
  // All transformations fixed
}
#declare CSG233 = difference {
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube689
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
}
#declare CSG234 = difference {
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube690
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  translate  120.0*x
}
#declare CSG235 = difference {
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube691
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
}
#declare CSG236 = difference {
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube692
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
  translate  -120.0*x
}
#declare Parts21 = union {
  box { // Cube688
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 80.0, 10.0>
  }
  object { CSG233 }
  object { CSG234 }
  object { CSG235 }
  object { CSG236 }
  box { // Cube693
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, 11.0>
  }
  box { // Cube694
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, 11.0>
  }
  box { // Cube695
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, -21.0>
  }
  box { // Cube696
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, -21.0>
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, -80.0, 0.0>
  }
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 80.0, 0.0>
  }
  // All transformations fixed
}
#declare Other_Tracksides = union {
  object { // Trackside1->Trackside
    Trackside
    translate  120.0*x
  }
  object { // Trackside2->Trackside
    Trackside
    rotate <0.0, -180.0, -180.0>
    translate  -10.0*z
  }
  object { // Trackside3->Trackside
    Trackside
    rotate <-0.0, -180.0, -180.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Tracksides = union {
  object { Trackside }
  object { Other_Tracksides }
  // All transformations fixed
}
#declare Other_Trackends = union {
  object { // Trackend1->Trackend
    Trackend
    rotate <180.0, 0.0, -0.0>
    translate  -10.0*z
  }
  object { // Trackend2->Trackend
    Trackend
    translate  120.0*x
  }
  object { // Trackend3->Trackend
    Trackend
    rotate <-180.0, 0.0, -0.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Trackends = union {
  object { Trackend }
  object { Other_Trackends }
  // All transformations fixed
}
#declare Track_Set = union {
  object { Wheels }
  object { Parts21 }
  object { Tracksides }
  object { Trackends }
  translate  22.0*z
}
#declare Wrist = union {
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
    rotate -90.0*x
  }
  object { Claw }
  object { // Claw1->Claw
    Claw
    rotate <0.0, -120.0, -0.0>
  }
  object { // Claw2->Claw
    Claw
    rotate <0.0, 120.0, -0.0>
  }
  // Scaling fixed
  // Translation fixed
  translate  -39.0*y
}
#declare Elbow = union {
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 25.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { Wrist }
  // Scaling fixed
  // Rot X limited (-5.0 to   95.0)
  // Translation fixed
  rotate 90.0*x
  translate  -60.0*y
}
#declare CSG237 = difference {
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube703
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  rotate 90.0*x
  translate  -60.0*y
}
#declare Hinge = union {
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  object { Elbow }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    scale <7.5, 7.5, 47.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { CSG237 }
  // Scaling fixed
  // Rot X limited (-90.0 to   0.0)
  // Translation fixed
  rotate TransporterHingeRotation
  translate  50.0*z
}
#declare CSG238 = difference {
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    scale <14.0, 14.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube704
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  translate  50.0*z
}
#declare Post = union {
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 61.0>
    translate  -20.0*z
  }
  object { Hinge }
  object { CSG238 }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (24.0 to   59.0)
  translate  TransporterPostLocation
}
#declare Arm = union {
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 40.0>
  }
  object { Post }
  // Scaling fixed
  // Translation fixed
  rotate TransporterArmRotation
  translate  <0.0, -30.0, 22.0>
}
#declare Basket = union {
  box { // Cube705
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 10.0, 34.0>
  }
  box { // Cube706
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 10.0, 34.0>
  }
  box { // Cube707
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 70.0, 34.0>
  }
  box { // Cube708
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 70.0, 34.0>
  }
  box { // Cube709
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 10.0, 40.0>
  }
  box { // Cube710
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 70.0, 40.0>
  }
  box { // Cube711
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 90.0, 70.0>
  }
  box { // Cube712
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, -10.0, 70.0>
  }
  box { // Cube713
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <30.0, 40.0, 40.0>
  }
  box { // Cube714
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <-57.0, 40.0, 70.0>
  }
  box { // Cube715
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <57.0, 40.0, 70.0>
  }
  box { // Cube716
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <-30.0, 40.0, 40.0>
  }
  box { // Cube717
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 70.0, 55.0>
  }
  box { // Cube718
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 70.0, 55.0>
  }
  box { // Cube719
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 10.0, 55.0>
  }
  box { // Cube720
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 10.0, 55.0>
  }
  material {
    T_Chrome_2E
  }
}
union { // Transporter
  object { Track_Set }
  object { Arm }
  object { Basket }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    scale <35.0, 35.0, 20.0>
    translate  <0.0, -30.0, 22.0>
  }
  material {
    BLUE_METAL
  }
  scale 0.5
  rotate -180.0*z
  translate  TransporterLocation
}


#declare CSG241 = intersection {
  torus { // Torus017
    10.0, 0.15  rotate -x*90
    scale <1.0, 3.0, 1.0>
    rotate -90.0*x
  }
  box { // Cube722
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 18.0>
    translate  <-7.0, 0.0, 18.0>
  }
}
#declare Antenna = union {
  object { CSG241 }
  sphere { // Sphere062
    <0,0,0>,1
    scale 0.5
    translate  30.0*z
  }
  translate  10.0*x
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Rot X limited (-10.0 to   10.0)
  // Rot Y limited (-10.0 to   10.0)
  // Rot Z limited (-10.0 to   10.0)
  // Translation fixed
  rotate BuggyAntennaRotation
  translate  <16.0, 0.0, 5.0>
}
#declare CSG242 = difference {
  sphere { // Sphere063
    <0,0,0>,1
    scale 12.0
    translate  -12.0*x
  }
  box { // Cube723
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <-12.0, 0.0, -9.0>
  }
  sphere { // Sphere064
    <0,0,0>,1
    scale 7.0
    translate  <-13.0, 12.5, 0.0>
  }
  sphere { // Sphere065
    <0,0,0>,1
    scale 7.0
    translate  <-13.0, -12.5, 0.0>
  }
  box { // Cube724
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 2.5, 2.5>
    translate  <-16.0, -4.0, 6.0>
  }
  box { // Cube725
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 2.5, 2.5>
    translate  <-16.0, 4.0, 6.0>
  }
  material {
    Tinny_Brass
  }
}
#declare CSG243 = difference {
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 50.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 0.0>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 60.0>
    rotate -90.0*y
    translate  <30.0, -5.0, 0.0>
  }
  translate  -1.0*y
}
#declare CSG244 = difference {
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 50.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 0.0>
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 60.0>
    rotate -90.0*y
    translate  <30.0, -5.0, 0.0>
  }
  translate  11.0*y
}
#declare CSG245 = difference {
  sphere { // Sphere066
    <0,0,0>,1
    scale 11.0
    translate  -12.0*x
  }
  box { // Cube726
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <-12.0, 0.0, -8.0>
  }
  material {
    RedClear
  }
}
#declare CSG246 = difference {
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 10.0, 30.0>
    rotate -90.0*y
    translate  15.0*x
  }
  sphere { // Sphere067
    <0,0,0>,1
    scale 7.0
    translate  <13.0, 12.5, 0.0>
  }
  sphere { // Sphere068
    <0,0,0>,1
    scale 7.0
    translate  <13.0, -12.5, 0.0>
  }
  sphere { // Sphere069
    <0,0,0>,1
    scale 7.0
    translate  -12.5*y
  }
  sphere { // Sphere070
    <0,0,0>,1
    scale 7.0
    translate  12.5*y
  }
  box { // Cube727
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 16.0, 10.666667>
    translate  -9.0*z
  }
  box { // Cube728
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 8.0, 5.0>
    translate  <5.0, 0.0, 4.0>
  }
  material {
    Tinny_Brass
  }
}
#declare CSG247 = difference {
  sphere { // Sphere071
    <0,0,0>,1
    scale <7.0, 10.0, 7.0>
    translate  15.0*x
  }
  box { // Cube729
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <12.0, 0.0, -9.0>
  }
  sphere { // Sphere072
    <0,0,0>,1
    scale 7.0
    translate  <13.0, 12.5, 0.0>
  }
  sphere { // Sphere073
    <0,0,0>,1
    scale 7.0
    translate  <13.0, -12.5, 0.0>
  }
  box { // Cube730
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 8.0, 5.0>
    translate  <5.0, 0.0, 4.0>
  }
  material {
    Tinny_Brass
  }
}
#declare Group001 = union {
  object { Cube731 }
  object { // Cube732->Cube731
    Cube731
    translate  3.0*x
  }
  object { // Cube733->Cube731
    Cube731
    translate  6.0*x
  }
  object { // Cube734->Cube731
    Cube731
    translate  9.0*x
  }
  object { // Cube735->Cube731
    Cube731
    translate  12.0*x
  }
  object { // Cube736->Cube731
    Cube731
    translate  15.0*x
  }
}
#declare Parts22 = union {
  object { CSG242 }
  object { CSG243 }
  object { CSG244 }
  object { CSG245 }
  object { CSG246 }
  object { CSG247 }
  object { Group001 }
  material {
    T_Chrome_2E
  }
  // All transformations fixed
  translate  6.5*z
}
union { // Buggy
  object { Wheels1 }
  object { // Wheels2->Wheels1
    Wheels1
    // All transformations fixed
    translate  25.0*y
  }
  object { Antenna }
  object { Parts22 }
  scale 2.0
  rotate -180.0*z
  matrix align(BuggyAlign,<0,0,0>,<0,0,0>)
  translate  BuggyLocation
}


union { // Forklift
  torus { // Torus018
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <8.0, -22.0, 2.0>
  }
  torus { // Torus019
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <-8.0, -22.0, 2.0>
  }
  torus { // Torus020
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <-8.0, -18.0, 2.0>
  }
  torus { // Torus021
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <8.0, -18.0, 2.0>
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <-5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 20.0>
    translate  <-5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 20.0>
    translate  <5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.5, 10.0>
    rotate <70.0, 90.0, 0.0>
    translate  <5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.5, 10.0>
    rotate <110.0, 90.0, 0.0>
    translate  <-5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    rotate 90.0*y
    translate  <-7.5, -20.0, 1.0>
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate 90.0*y
    translate  <-5.0, -20.0, 11.0>
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate 90.0*y
    translate  <-5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    rotate 90.0*y
    translate  <-15.0, -16.0, 21.0>
  }
  object { Claw3 }
  object { // Claw4->Claw3
    Claw3
    scale <1.0, -1.0, -1.0>
    rotate <0.0, -0.0, 180.0>
    translate  <0.0, 0.0, 2.0>
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, -22.0, 2.0>
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, -18.0, 2.0>
  }
  box { // Cube737
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 2.0>
    translate  <5.0, -20.0, 3.0>
  }
  box { // Cube738
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 2.0>
    translate  <-5.0, -20.0, 3.0>
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*y
    translate  <-15.0, -16.0, 21.0>
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*y
    translate  <13.0, -16.0, 21.0>
  }
  material {
    T_Chrome_3A
  }
  scale 5.0
  rotate -90.0*z
  translate  ForkLiftLocation
}


#declare CSG248 = union {
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 1.5>
    translate  2.5*z
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 0.5>
    translate  2.0*z
  }
  box { // Cube739
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 6.0, 1.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    scale <8.7, 8.7, 0.5>
    translate  -3.0*z
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 7.2, 0.5>
    translate  -14.0*z
  }
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 9.0>
    translate  -14.5*z
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    scale <8.5, 8.5, 6.0>
    translate  -4.0*z
  }
  cone { // Cone019
    <0,0,0>, 7.0, <0,0,1>, 8.5
    scale <1.0, 1.0, 2.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    scale <8.7, 8.7, 0.5>
    translate  0.5*z
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 7.2, 0.5>
    translate  -12.0*z
  }
  sphere { // Sphere074
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <-6.0, -5.5, -1.0>
  }
  sphere { // Sphere075
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <6.0, -5.5, -1.0>
  }
  sphere { // Sphere076
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <-4.0, -7.0, -1.0>
  }
  sphere { // Sphere077
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <4.0, -7.0, -1.0>
  }
}
#declare CSG249 = difference {
  object { CSG248 }
  box { // Cube740
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_2E
    }
    scale <2.5, 1.0, 1.0>
    translate  <0.0, -8.0, -1.0>
  }
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 5.5, 9.0>
    translate  -15.0*z
  }
}
#declare Body = union {
  object { CSG249 }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 4.0>
    translate  -3.0*z
  }
  box { // Cube741
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.5>
    translate  <-6.0, 0.0, -13.0>
  }
  box { // Cube742
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.5>
    translate  <6.0, 0.0, -13.0>
  }
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <-2.0, -7.5, -1.0>
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <-1.0, -7.5, -1.0>
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <1.0, -7.5, -1.0>
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <2.0, -7.5, -1.0>
  }
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 23.0>
    rotate 90.0*y
    translate  -11.5*x
  }
  // All transformations fixed
}
#declare TaperSweep002 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 5.0, 15.0>
  rotate -180.0*x
  translate  7.0*z
}
#declare CSG253 = difference {
  object { TaperSweep002 }
  sphere { // Sphere078
    <0,0,0>,1
    scale <1.0, 5.0, 1.5>
    translate  <2.0, 0.0, -6.0>
  }
  box { // Cube748
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 2.0>
    translate  <-2.5, 0.0, -5.5>
  }
  scale <1.5, 1.0, 1.0>
}
#declare Leg = union {
  object { CSG253 }
  box { // Cube749
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 4.0>
    translate  -1.0*z
  }
  box { // Cube750
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, 4.0, -7.75>
  }
  box { // Cube751
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, -4.0, -7.75>
  }
  material {
    White
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-2.5 to   2.5)
  // Trans Z limited (-13.0 to   -11.0)
  translate KongBotLeftLegPerturbation
  translate  <5.0, 0.0, -12.0>
}
#declare TaperSweep003 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 5.0, 15.0>
  rotate -180.0*x
  translate  7.0*z
}
#declare CSG254 = difference {
  object { TaperSweep003 }
  sphere { // Sphere079
    <0,0,0>,1
    scale <1.0, 5.0, 1.5>
    translate  <2.0, 0.0, -6.0>
  }
  box { // Cube752
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 2.0>
    translate  <-2.5, 0.0, -5.5>
  }
  scale <1.5, 1.0, 1.0>
}
#declare Leg1 = union {
  object { CSG254 }
  box { // Cube753
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 4.0>
    translate  -1.0*z
  }
  box { // Cube754
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, 4.0, -7.75>
  }
  box { // Cube755
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, -4.0, -7.75>
  }
  material {
    White
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-2.5 to   2.5)
  // Trans Z limited (-13.0 to   -11.0)
  scale <-1.0, 1.0, 1.0>
  translate KongBotRightLegPerturbation
  translate  <-5.0, 0.0, -12.0>
}
#declare Head = union {
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    translate  4.0*z
  }
  box { // Cube756
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.2, 0.75>
    translate  <0.0, -2.0, 5.0>
  }
  box { // Cube757
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 1.0>
    rotate -15.0*x
    translate  <0.0, 2.0, 4.0>
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    rotate 90.0*y
    translate  <-3.25, 0.0, 5.5>
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    rotate 90.0*y
    translate  <2.75, 0.0, 5.5>
  }
  box { // Cube758
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <-3.0, 0.0, 5.0>
  }
  box { // Cube759
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <3.0, 0.0, 5.0>
  }
  sphere { // Sphere080
    <0,0,0>,1
    translate  <3.0, -2.0, 5.0>
  }
  sphere { // Sphere081
    <0,0,0>,1
    translate  <-3.0, -2.0, 5.0>
  }
  sphere { // Sphere082
    <0,0,0>,1
    scale <2.0, 2.0, 0.25>
    translate  8.0*z
  }
  sphere { // Sphere083
    <0,0,0>,1
    material {
      KongDome
    }
    scale 6.0
    translate  4.0*z
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 5.5, 0.5>
    translate  4.0*z
  }
  material {
    T_Chrome_2E
  }
  // All transformations fixed
}
union { // KongBot
  object { Body }
  object { Arm1 }
  object { // Arm2->Arm1
    Arm1
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Leg }
  object { Leg1 }
  object { Head }
  material {
    Red_1
  }
  scale 5.0
  rotate -90.0*z
  translate KongBotPerturbation
  translate  KongBotLocation
}


#declare CSG255 = intersection {
  box { // Cube760
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 2.0, 8.0>
    translate  <0.0, 12.0, -12.0>
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 10.0, 2.0>
    rotate -90.0*x
    translate  <0.0, 11.0, -15.0>
  }
}
#declare CSG256 = difference {
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    translate  -23.1*z
  }
  object { CSG255 }
}
#declare CSG257 = difference {
  box { // Cube761
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <0.0, 9.5, -15.5>
  }
  box { // Cube762
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <0.0, 9.5, -15.5>
  }
  material {
    Black
  }
}
#declare Body1 = union {
  sphere { // Sphere084
    <0,0,0>,1
    scale <12.0, 12.0, 4.0>
    translate  -23.1*z
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    material {
      Belt
    }
    scale <12.25, 12.25, 5.0>
    translate  -18.0*z
  }
  object { CSG256 }
  torus { // Torus022
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <-12.0, 0.0, -8.0>
  }
  torus { // Torus023
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <12.0, 0.0, -8.0>
  }
  sphere { // Sphere085
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, 20.0, 15.0>
    translate  <7.0, 9.0, -8.0>
  }
  sphere { // Sphere087
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, -20.0, -15.0>
    translate  <-7.0, 9.0, -8.0>
  }
  sphere { // Sphere088
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <9.0, 0.0, -24.0>
  }
  sphere { // Sphere089
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <-9.0, 0.0, -24.0>
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <9.0, 0.0, -28.0>
  }
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <-9.0, 0.0, -28.0>
  }
  cone { // Cone020
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate -90.0*y
    translate  <-13.0, 0.0, -24.0>
  }
  cone { // Cone021
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate 90.0*y
    translate  <13.0, 0.0, -24.0>
  }
  object { CSG257 }
  // All transformations fixed
}
#declare CSG258 = difference {
  sphere { // Sphere090
    <0,0,0>,1
    scale 12.0
  }
  box { // Cube763
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 13.0, 7.0>
    translate  7.0*z
  }
  box { // Cube764
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <-10.0, 0.0, 7.0>
  }
  box { // Cube765
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <10.0, 0.0, 7.0>
  }
}
#declare CSG259 = union {
  box { // Cube766
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <-4.0, -10.0, 10.0>
  }
  box { // Cube767
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <4.0, -10.0, 10.0>
  }
  box { // Cube768
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <0.0, -10.0, 10.0>
  }
}
#declare CSG260 = intersection {
  object { CSG259 }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 16.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
}
#declare Head1 = union {
  object { CSG258 }
  object { CSG260 }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 3.0>
    translate  -2.9*z
  }
  sphere { // Sphere091
    <0,0,0>,1
    material {
      Black
    }
    scale 11.0
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, -60.0, -15.0>
  }
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, 60.0, 15.0>
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  // Scaling fixed
  // Translation fixed
}
union { // Unknown
  object { Body1 }
  object { Head1 }
  object { Arm3 }
  object { // Arm4->Arm3
    Arm3
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Leg2 }
  object { // Leg3->Leg2
    Leg2
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  material {
    Red_2
  }
  scale 2.0
  rotate -90.0*z       
  matrix align(UnknownAlign,<0,0,0>,<0,0,0>)
  translate  UnknownLocation
}


#declare Chassis = union {
  box { // Cube774
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 1.0>
    translate  <0.0, -8.0, 15.0>
  }
  box { // Cube775
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 8.0, 1.0>
    translate  <0.0, -1.0, 27.0>
  }
  box { // Cube776
    <-1, -1, -1>, <1, 1, 1>
    material {
      RedClear
    }
    scale <8.0, 4.0, 1.0>
    translate  <0.0, -5.0, 25.0>
  }
  box { // Cube777
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 8.0, 1.0>
    translate  <0.0, -1.0, 23.0>
  }
  box { // Cube778
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 4.0>
    translate  <0.0, 3.0, 18.0>
  }
  box { // Cube779
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 10.0, 4.0>
    translate  <0.0, 6.0, 10.0>
  }
  box { // Cube780
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 8.0, 4.0>
    translate  <0.0, -12.0, 10.0>
  }
  box { // Cube781
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 12.0, 4.0>
    translate  2.0*z
  }
  box { // Cube782
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 1.0>
    translate  <0.0, 3.0, 25.0>
  }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <6.0, 18.0, 6.0>
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <2.0, 18.0, 6.0>
  }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <-2.0, 18.0, 6.0>
  }
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <-6.0, 18.0, 6.0>
  }
  material {
    White
  }
  // All transformations fixed
}
union { // Lego
  object { Chassis }
  object { // Wheelset1->Wheelset
    Wheelset
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Wheelset }
  object { // Attachments1->Attachments
    Attachments
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Attachments }
  material {
    White
  }
  scale 5.0
  rotate -90.0*z
  translate  LegoLocation
}


union { // ForkliftB
  torus { // Torus024
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <8.0, -22.0, 2.0>
  }
  torus { // Torus025
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <-8.0, -22.0, 2.0>
  }
  torus { // Torus026
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <-8.0, -18.0, 2.0>
  }
  torus { // Torus027
    1.5, 0.5  rotate -x*90
    material {
      Black_Rubber
    }
    rotate 90.0*y
    translate  <8.0, -18.0, 2.0>
  }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <-5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 20.0>
    translate  <-5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 20.0>
    translate  <5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.5, 10.0>
    rotate <70.0, 90.0, 0.0>
    translate  <5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.5, 10.0>
    rotate <110.0, 90.0, 0.0>
    translate  <-5.0, -20.0, 1.0>
  }
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 15.0>
    rotate 90.0*y
    translate  <-7.5, -20.0, 1.0>
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate 90.0*y
    translate  <-5.0, -20.0, 11.0>
  }
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate 90.0*y
    translate  <-5.0, -20.0, 21.0>
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 30.0>
    rotate 90.0*y
    translate  <-15.0, -16.0, 21.0>
  }
  object { Claw5 }
  object { // Claw6->Claw5
    Claw5
    scale <1.0, -1.0, -1.0>
    rotate <0.0, -0.0, 180.0>
    translate  <0.0, 0.0, 2.0>
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, -22.0, 2.0>
  }
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, -18.0, 2.0>
  }
  box { // Cube808
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 2.0>
    translate  <5.0, -20.0, 3.0>
  }
  box { // Cube809
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 3.0, 2.0>
    translate  <-5.0, -20.0, 3.0>
  }
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*y
    translate  <-15.0, -16.0, 21.0>
  }
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 2.0>
    rotate 90.0*y
    translate  <13.0, -16.0, 21.0>
  }
  material {
    T_Chrome_3A
  }
  scale 4.25
  rotate 90.0*z
  translate  ForkLiftBLocation
}


#declare CSG268 = difference {
  sphere { // Sphere101
    <0,0,0>,1
    scale <2.5, 2.5, 5.0>
    translate  1.0*z
  }
  box { // Cube810
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  -1.0*z
  }
}
#declare CSG269 = difference {
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 10.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 11.0>
    translate  -6.5*z
  }
}
#declare CSG270 = difference {
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    scale <12.5, 12.5, 5.0>
    translate  2.0*z
  }
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 6.0>
    translate  1.5*z
  }
  material {
    Black_Rubber
  }
}
#declare Parts23 = union {
  object { CSG268 }
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 10.0>
    translate  -5.0*z
  }
  object { CSG269 }
  box { // Cube811
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    translate  3.0*z
  }
  box { // Cube812
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -120.0*z
    translate  3.0*z
  }
  box { // Cube813
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -240.0*z
    translate  3.0*z
  }
  object { CSG270 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Blades1 = union {
  object { Blade4 }
  object { // Blade5->Blade4
    Blade4
    rotate -90.0*z
  }
  object { // Blade6->Blade4
    Blade4
    rotate 180.0*z
  }
  object { // Blade7->Blade4
    Blade4
    rotate 90.0*z
  }
  torus { // Torus037
    2.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  1.0*z
  }
  torus { // Torus038
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -1.0*z
  }
  cone { // Cone027
    <0,0,0>, 2.0, <0,0,1>, 2.5
    open
    scale <1.0, 1.0, 2.0>
    translate  -1.0*z
  }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
}
#declare Fan2 = union {
  object { Parts23 }
  object { Blades1 }
  scale <1.8, 1.8, 1.0>
  translate  100.0*z
}
union { // Engine
  object { Cylndr428 }
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 5.0>
    translate  90.0*z
  }
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 35.0>
    translate  60.0*z
  }
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 10.0>
    translate  60.0*z
  }
  sphere { // Sphere099
    <0,0,0>,1
    scale <25.0, 25.0, 30.0>
    translate  40.0*z
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    scale <22.5, 22.5, 20.0>
  }
  object { // Cylndr433->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -18.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr434->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -36.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr435->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -54.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr436->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -72.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr437->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr438->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -108.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr439->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -126.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr440->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -144.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr441->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, -162.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr442->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr443->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr444->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr445->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr446->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr447->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr448->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr449->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 54.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr450->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 36.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr451->Cylndr428
    Cylndr428
    rotate <-0.0, 0.0, 18.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { Group004 }
  object { // Group005->Group004
    Group004
    rotate -30.0*z
  }
  object { // Group006->Group004
    Group004
    rotate -60.0*z
  }
  object { // Group007->Group004
    Group004
    rotate -90.0*z
  }
  object { // Group008->Group004
    Group004
    rotate -120.0*z
  }
  object { // Group009->Group004
    Group004
    rotate -150.0*z
  }
  object { // Group010->Group004
    Group004
    rotate 180.0*z
  }
  object { // Group011->Group004
    Group004
    rotate 150.0*z
  }
  object { // Group012->Group004
    Group004
    rotate 120.0*z
  }
  object { // Group013->Group004
    Group004
    rotate 90.0*z
  }
  object { // Group014->Group004
    Group004
    rotate 60.0*z
  }
  object { // Group015->Group004
    Group004
    rotate 30.0*z
  }
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <22.0, 22.0, 3.333333>
    translate  93.333333*z
  }
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  10.0*z
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  3.333333*z
  }
  object { Torus030 }
  object { // Torus031->Torus030
    Torus030
    rotate -120.0*z
  }
  object { // Torus032->Torus030
    Torus030
    rotate 120.0*z
    translate  0.0*x
  }
  object { Torus033 }
  object { // Torus034->Torus033
    Torus033
    rotate -90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Torus035->Torus033
    Torus033
    rotate 180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Torus036->Torus033
    Torus033
    rotate 90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { Fan2 }
  material {
    T_Chrome_3A
  }
  scale 1.5
  translate  EngineLocation
}


#declare Other_Wheels1 = union {
  object { // Wheel30->Wheel29
    Wheel29
    translate  93.0*y
  }
  object { // Wheel31->Wheel29
    Wheel29
    translate  62.0*y
  }
  object { // Wheel32->Wheel29
    Wheel29
    translate  31.0*y
  }
  object { // Wheel33->Wheel29
    Wheel29
    translate  -31.0*y
  }
  object { // Wheel34->Wheel29
    Wheel29
    translate  -62.0*y
  }
  object { // Wheel35->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, 93.0, 0.0>
  }
  object { // Wheel36->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, 62.0, 0.0>
  }
  object { // Wheel37->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, 31.0, 0.0>
  }
  object { // Wheel38->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, -31.0, 0.0>
  }
  object { // Wheel39->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, -0.0, 0.0>
  }
  object { // Wheel40->Wheel29
    Wheel29
    rotate 0.0*z
    translate  <-120.0, -62.0, 0.0>
  }
  // All transformations fixed
}
#declare Wheels3 = union {
  object { Wheel29 }
  object { Other_Wheels1 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare CSG273 = difference {
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube820
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
}
#declare CSG274 = difference {
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube821
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  translate  120.0*x
}
#declare CSG275 = difference {
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube822
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
}
#declare CSG276 = difference {
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube823
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
  translate  -120.0*x
}
#declare Parts24 = union {
  box { // Cube819
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 80.0, 10.0>
  }
  object { CSG273 }
  object { CSG274 }
  object { CSG275 }
  object { CSG276 }
  box { // Cube824
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, 11.0>
  }
  box { // Cube825
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, 11.0>
  }
  box { // Cube826
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, -21.0>
  }
  box { // Cube827
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, -21.0>
  }
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, -80.0, 0.0>
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 80.0, 0.0>
  }
  material {
    Black_Rubber
  }
  // All transformations fixed
}
#declare Other_Tracksides1 = union {
  object { // Trackside5->Trackside4
    Trackside4
    translate  120.0*x
  }
  object { // Trackside6->Trackside4
    Trackside4
    rotate <0.0, -180.0, -180.0>
    translate  -10.0*z
  }
  object { // Trackside7->Trackside4
    Trackside4
    rotate <-0.0, -180.0, -180.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Tracksides1 = union {
  object { Trackside4 }
  object { Other_Tracksides1 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Other_Trackends1 = union {
  object { // Trackend5->Trackend4
    Trackend4
    rotate <180.0, 0.0, -0.0>
    translate  -10.0*z
  }
  object { // Trackend6->Trackend4
    Trackend4
    translate  120.0*x
  }
  object { // Trackend7->Trackend4
    Trackend4
    rotate <-180.0, 0.0, -0.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Trackends1 = union {
  object { Trackend4 }
  object { Other_Trackends1 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Track_Set1 = union {
  object { Wheels3 }
  object { Parts24 }
  object { Tracksides1 }
  object { Trackends1 }
  // All transformations fixed
  translate  22.16*z
}
#declare CSG298 = intersection {
  box { // Cube845
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 30.0, 50.0>
    rotate 25.0*y
    translate  <0.0, 21.0, 40.0>
  }
  box { // Cube846
    <-1, -1, -1>, <1, 1, 1>
    scale <55.0, 55.0, 10.0>
    rotate -45.0*z
    translate  <0.0, 21.0, 50.0>
  }
  box { // Cube847
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 30.01, 50.0>
    rotate -25.0*y
    translate  <0.0, 21.0, 40.0>
  }
}
#declare CSG299 = difference {
  box { // Cube848
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.0, -1.0>
    scale <47.5, 30.0, 10.0>
    rotate 25.0*x
    translate  <0.0, -9.0, 60.0>
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <8.0, 8.0, 50.0>
    rotate 90.0*x
    translate  <-25.0, 0.0, 50.0>
  }
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <8.0, 8.0, 50.0>
    rotate 90.0*x
    translate  <25.0, 0.0, 50.0>
  }
}
#declare ArtooHolder = union {
  box { // Cube850
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 4.25, 15.0>
    translate  5.0*x
  }
  box { // Cube851
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 4.25, 15.0>
    translate  -5.0*x
  }
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 30.0>
    translate  -15.0*z
  }
  material {
    T_Chrome_3A
  }
  scale 1.5
  translate  <0.0, 70.0, 45.0>
}
#declare CSG300 = difference {
  box { // Cube849
    <-1, -1, -1>, <1, 1, 1>
    scale <35.0, 20.0, 10.0>
    translate  <0.0, 70.0, 41.0>
  }
  object { ArtooHolder }
}
#declare CSG301 = union {
  box { // Cube854
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <15.0, 5.0, 10.0>
    rotate 60.0*x
    translate  <0.0, -73.0, 47.0>
  }
  box { // Cube855
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 5.0, 5.0>
    translate  <0.0, -78.0, 42.0>
  }
}
#declare CSG302 = difference {
  object { CSG301 }
  box { // Cube856
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <14.0, 4.0, 10.0>
    rotate 60.0*x
    translate  <0.0, -74.0, 46.0>
  }
  box { // Cube857
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 5.0, 4.0>
    translate  <0.0, -79.0, 42.0>
  }
}
#declare CSG303 = intersection {
  box { // Cube858
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus043
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -72.0, 34.0>
}
#declare CSG304 = intersection {
  box { // Cube859
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus044
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -80.0, 34.0>
}
#declare CSG305 = intersection {
  box { // Cube860
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus045
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -76.0, 34.0>
}
#declare Body2 = union {
  box { // Cube844
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 85.0, 5.0>
    translate  33.0*z
  }
  object { CSG298 }
  object { CSG299 }
  object { CSG300 }
  box { // Cube852
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 6.0>
    rotate 25.0*y
    translate  <-60.0, 24.0, 53.0>
  }
  box { // Cube853
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 6.0>
    rotate -25.0*y
    translate  <60.0, 24.0, 53.0>
  }
  object { CSG302 }
  object { CSG303 }
  object { CSG304 }
  object { CSG305 }
  box { // Cube861
    <-1, -1, -1>, <1, 1, 1>
    material {
      Translucent
    }
    scale <14.1, 3.1, 4.1>
    translate  <0.0, -79.0, 42.0>
  }
  // All transformations fixed
}
#declare CSG306 = intersection {
  torus { // Torus046
    30.0, 4.0  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube862
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 20.0, 10.0>
    translate  <0.0, -20.0, -17.0>
  }
  translate  <0.0, 20.0, 20.0>
}
#declare CSG307 = intersection {
  torus { // Torus047
    30.0, 2.0  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube864
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 20.0, 15.0>
    translate  <0.0, -20.0, -15.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare Movable = union {
  box { // Cube863
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 30.0, 1.0>
    translate  <0.0, -10.0, 2.0>
  }
  object { CSG307 }
  box { // Cube865
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 1.0>
    rotate 75.0*y
    translate  <-41.0, -10.0, 11.0>
  }
  box { // Cube866
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 1.0>
    rotate -75.0*y
    translate  <41.0, -10.0, 11.0>
  }
  object { Group016 }
  object { // Group017->Group016
    Group016
    translate  15.0*x
  }
  object { // Group018->Group016
    Group016
    translate  45.0*x
  }
  object { // Group019->Group016
    Group016
    translate  60.0*x
  }
  box { // Cube870
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 12.0, 2.0>
    translate  <0.0, 20.0, 1.0>
  }
  cylinder { // Cylndr533
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 20.0>
    rotate -15.0*y
    translate  <-43.0, 0.0, 18.0>
  }
  sphere { // Sphere110
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    translate  <-48.0, 0.0, 37.0>
  }
  sphere { // Sphere111
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    translate  <48.0, 0.0, 37.0>
  }
  cylinder { // Cylndr534
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 20.0>
    rotate 15.0*y
    translate  <43.0, 0.0, 18.0>
  }
  object { Missile }
  object { // Missile1->Missile
    Missile
    translate  <-15.0, 0.0, 0.0>
  }
  // Scaling fixed
  // Rot X limited (-30.0 to   0.0)
  // Translation fixed
  translate  <0.0, 20.0, 20.0>
}
#declare MissileTurret = union {
  object { CSG306 }
  object { Movable }
  box { // Cube886
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 22.0, 1.0>
    translate  2.0*z
  }
  cylinder { // Cylndr541
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <20.0, 20.0, 6.0>
    translate  -4.0*z
  }
  object { Stand }
  object { // Stand1->Stand
    Stand
    scale -1.0
    rotate -180.0*x
  }
  // Scaling fixed
  // Translation fixed
  translate  <0.0, 20.0, 63.0>
}
union { // Tank
  object { Track_Set1 }
  object { MudGuard }
  object { // MudGuard1->MudGuard
    MudGuard
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Gun }
  object { // Gun1->Gun
    Gun
    // All transformations fixed
    scale -1.0
    rotate <0.0, -180.0, -180.0>
  }
  object { Body2 }
  object { MissileTurret }
  material {
    TankArmour
  }
  scale 2.25
  rotate -180.0*z
  translate  <-80.0, 990.0, -1600.0>
}


#declare CSG313 = difference {
  cylinder { // Cylndr548
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.0>
    translate  -38.0*z
  }
  cylinder { // Cylndr549
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <2.5, 2.5, 3.0>
    translate  -39.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Fuselage = union {
  cylinder { // Cylndr546
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <4.0, 4.0, 30.0>
    translate  -36.0*z
  }
  sphere { // Sphere115
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 15.0>
    translate  25.0*z
  }
  cylinder { // Cylndr547
    <0,0,1>, <0,0,0>, 1 
    material {
      ForeSection
    }
    scale <5.0, 5.0, 25.0>
  }
  sphere { // Sphere116
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 40.0>
  }
  sphere { // Sphere117
    <0,0,0>,1
    material {
      JetBlack
    }
    scale 2.0
    translate  38.5*z
  }
  object { CSG313 }
  object { Cube889 }
  object { // Cube890->Cube889
    Cube889
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube891->Cube889
    Cube889
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube892->Cube889
    Cube889
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube893->Cube889
    Cube889
    rotate 0.0*x
    translate  <0.0, -0.0, -16.0>
  }
  object { // Cube894->Cube889
    Cube889
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -16.0>
  }
  object { // Cube895->Cube889
    Cube889
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -16.0>
  }
  object { // Cube896->Cube889
    Cube889
    rotate <0.0, 0.0, -270.0>
    translate  <0.0, -0.0, -16.0>
  }
  material {
    White
  }
  // All transformations fixed
}
union { // Missile4
  object { Fuselage }
  object { RearFin }
  object { FrontFin }
  object { // FrontFin1->FrontFin
    FrontFin
    // All transformations fixed
    rotate -90.0*z
  }
  object { // FrontFin2->FrontFin
    FrontFin
    // All transformations fixed
    rotate 180.0*z
  }
  object { // FrontFin3->FrontFin
    FrontFin
    // All transformations fixed
    rotate 90.0*z
  }
  object { // RearFin1->RearFin
    RearFin
    // All transformations fixed
    rotate -90.0*z
  }
  object { // RearFin2->RearFin
    RearFin
    // All transformations fixed
    rotate 180.0*z
  }
  object { // RearFin3->RearFin
    RearFin
    // All transformations fixed
    rotate 90.0*z
  }
  scale <1.75, 1.75, 2.5>
  rotate -45.0*z
  translate  MissileLocation
}


#declare CSG315 = union {
  cone { // Cone031
    <0,0,0>, 9.0, <0,0,1>, 11.0
    scale <1.0, 1.0, 2.0>
    translate  -2.0*z
  }
  cylinder { // Cylndr552
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Body
      rotate 90.0*z
    }
    scale <12.0, 12.0, 30.0>
  }
}
#declare CSG316 = difference {
  object { CSG315 }
  cylinder { // Cylndr553
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 20.0>
    translate  -2.5*z
  }
}
#declare Dome = difference {
  sphere { // Sphere118
    <0,0,0>,1
    material {
      R2D2Dome
      rotate -90.0*z
    }
    scale 12.0
    translate  30.0*z
  }
  box { // Cube904
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 6.0>
    translate  24.0*z
  }
}
// Include contains 'TransSweep042'
#include "xfinal.in3"

#declare TransSweep042 = object {
  TransSweep042_Raw
  scale <4.0, 4.0, 2.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare TransSweep043 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.8, -0.6>,
  <0.8, -0.6>,
  <0.5, 0.5>,
  <-0.5, 0.5>,
  <-0.8, -0.6>
  rotate -x*90
  scale <2.0, 2.0, 3.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare EyeSocket = difference {
  object { TransSweep042 }
  object { TransSweep043 }
  material {
    BLUE_METAL
  }
}
#declare Projector = difference {
  cone { // Cone032
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere119
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -8.0*z
  translate  -1.0*z
}
#declare Projector1 = difference {
  cone { // Cone033
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere120
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -210.0*z
}
#declare Projector2 = difference {
  cone { // Cone034
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere121
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  rotate 0.0*x
  translate  <0.0, 0.0, -30.0>
  material {
    T_Chrome_2E
  }
  rotate <-90.0, -0.0, -20.0>
  translate  30.0*z
}
#declare Head2 = union {
  object { Dome }
  object { EyeSocket }
  sphere { // Eye
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale 1.5
    translate  <0.0, -9.75, 35.0>
  }
  object { Projector }
  object { Projector1 }
  object { Projector2 }
  // Scaling fixed
  // Translation fixed
  rotate R2D2HeadRotation
  translate  0.1*z
}
#declare TransSweep044 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep045 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG317 = intersection {
  object { TransSweep044 }
  object { TransSweep045 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG318 = difference {
  object { CSG317 }
  box { // Cube905
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube906
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube907
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
  translate  -3.0*x
}
#declare ThirdFoot = union {
  object { CSG318 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  rotate R2D2ThirdFootRotation
  translate  -26.0*z
}
#declare TaperSweep004 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG319 = union {
  box { // Cube908
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube909
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep004 }
  scale <0.95, 1.0, 1.0>
  translate  -2.85*x
}
#declare ThirdLeg = union {
  object { ThirdFoot }
  object { CSG319 }
  cylinder { // Cylndr554
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <-0.5, 0.0, -26.0>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (23.0 to   36.0)
  translate  R2D2ThirdLegLocation
}
#declare Body3 = union {
  object { CSG316 }
  object { Head2 }
  object { ThirdLeg }
  translate  -23.0*z
  // Scaling fixed
  // Rot X limited (-5.0 to   30.0)
  // Translation fixed
  rotate R2D2BodyRotation
}
#declare TransSweep046 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep047 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep048 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep005 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG320 = union {
  cylinder { // Cylndr556
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube910
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep047 }
  cylinder { // Cylndr557
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube911
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep048 }
  box { // Cube912
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube913
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep005 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG321 = difference {
  object { CSG320 }
  cylinder { // Cylndr558
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg4 = union {
  object { TransSweep046 }
  cylinder { // Cylndr555
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG321 }
  cylinder { // Cylndr559
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr560
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  translate  13.0*x
}
#declare TransSweep049 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep050 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep051 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep006 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG322 = union {
  cylinder { // Cylndr562
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube914
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep050 }
  cylinder { // Cylndr563
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube915
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep051 }
  box { // Cube916
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube917
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep006 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG323 = difference {
  object { CSG322 }
  cylinder { // Cylndr564
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg5 = union {
  object { TransSweep049 }
  cylinder { // Cylndr561
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG323 }
  cylinder { // Cylndr565
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr566
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  rotate 180.0*z
  translate  -12.0*x
}
#declare Legs = union {
  object { Body3 }
  object { Leg4 }
  object { Leg5 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  rotate R2D2LegsRotation
  translate  -26.0*z
}
#declare TransSweep052 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep053 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG324 = intersection {
  object { TransSweep052 }
  object { TransSweep053 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG325 = difference {
  object { CSG324 }
  box { // Cube918
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube919
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr567
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube920
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube921
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube922
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG326 = difference {
  torus { // Torus049
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube924
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
}
#declare CSG327 = difference {
  torus { // Torus050
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube925
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
}
#declare Foot = union {
  object { CSG325 }
  box { // Cube923
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr568
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr569
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.0, -32.5>
  }
  cylinder { // Cylndr570
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.5, -34.5>
  }
  object { CSG326 }
  object { CSG327 }
  translate  12.0*x
}
#declare TransSweep054 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep055 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG328 = intersection {
  object { TransSweep054 }
  object { TransSweep055 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG329 = difference {
  object { CSG328 }
  box { // Cube926
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube927
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr571
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube928
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube929
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube930
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG330 = difference {
  torus { // Torus051
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube932
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare CSG331 = difference {
  torus { // Torus052
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube933
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare Foot1 = union {
  object { CSG329 }
  box { // Cube931
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr572
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr573
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -5.5, -32.5>
  }
  cylinder { // Cylndr574
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -6.5, -34.5>
  }
  object { CSG330 }
  object { CSG331 }
  rotate 180.0*z
  translate  -12.0*x
}
#declare Feet = union {
  object { Legs }
  object { Foot }
  object { Foot1 }
  // All transformations fixed
  translate  37.9*z
}
union { // R2D2
  object { Feet }
  material {
    White
  }
  scale 1.5
  rotate -90.0*z
  matrix align(R2D2Align,<0,0,0>,<0,0,0>)
  translate  R2D2Location
}


#declare TransSweep056 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.5, 6.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 5.0>
}
#declare Top = difference {
  sphere { // Sphere123
    <0,0,0>,1
    scale 24.0
  }
  box { // Cube934
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 6.0>
    translate  22.0*z
  }
  box { // Cube935
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 18.0>
    translate  -10.0*z
  }
  object { TransSweep056 }
  material {
    VINcentBodyTop
    scale <23.0, 23.0, 8.0>
    rotate 90.0*z
    translate <0.000000, 0.000000, 8.000000>
  }
}
#declare CSG332 = union {
  cone { // Cone035
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 30.0>
    rotate <90.0, 0.0, -15.0>
    translate  <-18.0, 34.0, -1.0>
  }
  cone { // Cone036
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 30.0>
    rotate <90.0, 0.0, 15.0>
    translate  <18.0, 34.0, -1.0>
  }
}
#declare CSG333 = union {
  sphere { // Sphere124
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  cone { // Cone037
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 20.0>
    rotate 90.0*x
    translate  <0.0, 30.0, -1.0>
  }
}
#declare ForeArms = intersection {
  box { // Cube936
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 10.0, 6.0>
    translate  <0.0, 14.0, -1.9>
  }
  object { CSG332 }
  object { CSG333 }
  box { // Cube937
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, 1.0, 1.0>
    scale <24.0, 14.0, 10.0>
    rotate 5.0*x
    translate  <0.0, 6.8, -7.9>
  }
  box { // Cube938
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <24.0, 14.0, 10.0>
    rotate -5.0*x
    translate  <0.0, 6.8, 4.1>
  }
}
#declare TransSweep057 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.8, -1.0>,
  <-0.8, -1.4>,
  <0.8, -1.4>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <8.5, 8.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare Shoulders = intersection {
  sphere { // Sphere125
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  object { TransSweep057 }
  box { // Cube939
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 18.0>
    translate  -11.5*z
  }
  material {
    VINcentArm
    scale <4.0, 6.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -3.000000, -7.000000>
  }
}
#declare CSG334 = union {
  object { ForeArms }
  object { Shoulders }
}
#declare TransSweep058 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.5, 6.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare Arms = difference {
  object { CSG334 }
  object { TransSweep058 }
  box { // Cube940
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 30.0, 3.0>
    translate  <13.125, 0.0, -1.5>
  }
  box { // Cube941
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 30.0, 3.0>
    translate  <9.0, 0.0, -1.5>
  }
  box { // Cube942
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 30.0, 3.0>
    translate  <-13.125, 0.0, -1.5>
  }
  box { // Cube943
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 30.0, 3.0>
    translate  <-9.0, 0.0, -1.5>
  }
  translate  1.0*z
}
#declare Rear = intersection {
  sphere { // Sphere126
    <0,0,0>,1
    scale 24.0
  }
  box { // Cube944
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 10.0>
    translate  <0.0, -12.0, -4.5>
  }
  material {
    VINcentRear
    scale <24.0, 20.0, 20.0>
    rotate 90.0*x
    translate <-12.000000, 0.000000, -14.500000>
  }
}
#declare CSG335 = intersection {
  sphere { // Sphere127
    <0,0,0>,1
    scale 20.0
    translate  1.0*y
  }
  box { // Cube945
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    rotate -90.0*x
    translate  <0.0, 20.0, -1.0>
  }
  material {
    VINcentSpeaker
    scale 10.0
    rotate <90.0, 0.0, -180.0>
    translate <5.000000, 0.000000, -6.000000>
  }
}
#declare TransSweep059 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-0.6, -1.0>
  rotate -x*90
  scale <5.0, 1.5, 10.0>
  rotate 90.0*x
  translate  <0.0, 25.0, -9.0>
}
#declare CSG336 = intersection {
  sphere { // Sphere128
    <0,0,0>,1
    scale 20.0
    translate  1.0*y
  }
  object { TransSweep059 }
  material {
    VINcentLower
    scale <10.0, 3.0, 10.0>
    rotate <90.0, 0.0, -180.0>
    translate <5.000000, 0.000000, -10.500000>
  }
}
#declare TransSweep060 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.0, 6.0, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare InnerClawHolder = intersection {
  sphere { // Sphere129
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  object { TransSweep060 }
}
#declare TransSweep061 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.1, 0.1>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.1, 0.1>,
  <-0.6, -1.0>
  rotate -x*90
  scale <4.5, 4.5, 50.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-25.0, 0.0, 4.5>
}
#declare TransSweep062 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.1, 0.1>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.1, 0.1>,
  <-0.6, -1.0>
  rotate -x*90
  scale <4.0, 4.0, 50.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-25.0, 0.0, 4.5>
}
#declare CSG337 = difference {
  object { TransSweep061 }
  object { TransSweep062 }
}
#declare SideDoors = difference {
  object { InnerClawHolder }
  cylinder { // Cylndr575
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 50.0>
    rotate 90.0*y
    translate  <-25.0, 0.0, 6.0>
  }
  box { // Cube946
    <-1, -1, -1>, <1, 1, 1>
    scale <25.0, 0.666667, 3.0>
    translate  3.0*z
  }
  object { CSG337 }
  box { // Cube947
    <-1, -1, -1>, <1, 1, 1>
    scale <25.0, 0.25, 1.5>
    translate  7.5*z
  }
  translate  1.0*z
}
#declare CSG338 = union {
  cylinder { // Cylndr576
    <0,0,1>, <0,0,0>, 1 
    scale 8.0
  }
  torus { // Torus053
    7.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  8.0*z
  }
}
#declare CSG339 = difference {
  object { CSG338 }
  cylinder { // Cylndr577
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 10.0>
  }
}
#declare Leg6 = union {
  object { CSG339 }
  translate  16.0*z
  material {
    VINcentLeg
    scale <8.0, 8.0, 8.5>
    rotate -135.0*z
    translate <0.000000, 0.000000, 16.000000>
  }
  rotate <-0.0, -220.0, -0.0>
}
#declare CSG340 = union {
  cylinder { // Cylndr578
    <0,0,1>, <0,0,0>, 1 
    scale 8.0
  }
  torus { // Torus054
    7.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  8.0*z
  }
}
#declare CSG341 = difference {
  object { CSG340 }
  cylinder { // Cylndr579
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 10.0>
  }
}
#declare Leg7 = union {
  object { CSG341 }
  translate  16.0*z
  material {
    VINcentLeg
    scale <8.0, 8.0, 8.5>
    rotate 45.0*z
    translate <0.000000, 0.000000, 16.000000>
  }
  rotate <-0.0, -140.0, -0.0>
}
#declare BodyParts = union {
  sphere { // Sphere122
    <0,0,0>,1
    material {
      Black
    }
    scale 20.0
  }
  object { Top }
  object { Arms }
  object { Rear }
  object { CSG335 }
  object { CSG336 }
  object { SideDoors }
  object { Leg6 }
  object { Leg7 }
  // All transformations fixed
}
#declare TaperSweep007 = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Light_Orange
  }
  scale <2.0, 3.0, 50.0>
  rotate 90.0*x
  translate  <-9.0, 64.0, -0.5>
}
#declare CSG342 = union {
  box { // Cube949
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.25, 3.15>
    translate  <-9.0, 24.5, -0.5>
  }
  box { // Cube950
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <-9.0, 24.5, -2.5>
  }
  box { // Cube951
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <-9.0, 24.5, 1.5>
  }
}
#declare CSG343 = intersection {
  box { // Cube948
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate <45.0, 90.0, 0.0>
    translate  <-9.0, 24.5, -0.5>
  }
  object { CSG342 }
  box { // Cube952
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate 90.0*y
    translate  <-9.0, 26.25, -0.5>
  }
}
#declare LeftPhaser = union {
  object { TaperSweep007 }
  object { CSG343 }
  cylinder { // Cylndr580
    <0,0,1>, <0,0,0>, 1 
    material {
      Orange
    }
    rotate <-90.0, 0.0, -0.0>
    translate  <-9.0, 24.5, -0.5>
  }
  material {
    Red_3
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (0.0 to   8.5)
  translate VINcentLeftPhaserLocation
}
#declare TaperSweep008 = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Light_Orange
  }
  scale <2.0, 3.0, 50.0>
  rotate 90.0*x
  translate  <9.0, 64.0, -0.5>
}
#declare CSG344 = union {
  box { // Cube954
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.25, 3.15>
    translate  <9.0, 24.5, -0.5>
  }
  box { // Cube955
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <9.0, 24.5, -2.5>
  }
  box { // Cube956
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <9.0, 24.5, 1.5>
  }
}
#declare CSG345 = intersection {
  box { // Cube953
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate <45.0, 90.0, 0.0>
    translate  <9.0, 24.5, -0.5>
  }
  object { CSG344 }
  box { // Cube957
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate 90.0*y
    translate  <9.0, 26.25, -0.5>
  }
}
#declare RightPhaser = union {
  object { TaperSweep008 }
  object { CSG345 }
  cylinder { // Cylndr581
    <0,0,1>, <0,0,0>, 1 
    material {
      Orange
    }
    rotate <-90.0, 0.0, -0.0>
    translate  <9.0, 24.5, -0.5>
  }
  material {
    Red_3
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (0.0 to   8.5)
  translate VINcentRightPhaserLocation
}
#declare TransSweep063 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-1.0, 0.3>,
  <-1.0, -0.3>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.3>,
  <0.6, -0.3>,
  <0.4, -0.6>,
  <-0.3, -0.6>,
  <-0.7, 0.0>,
  <-0.3, 0.6>,
  <0.4, 0.6>,
  <0.6, 0.3>,
  <0.6, 0.3>,
  <1.0, 0.3>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.3>
  rotate -x*90
  scale <2.5, 2.5, 2.0>
  rotate <-270.0, -180.0, 270.0>
  translate  <1.0, 12.5, 0.0>
}
#declare LeftClaw = union {
  cylinder { // Cylndr582
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  cylinder { // Cylndr583
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*x
  }
  object { TransSweep063 }
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Trans Y limited (9.0 to   21.5)
  translate  <-13.5, 9.0, -0.5>
}
#declare TransSweep064 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-1.0, 0.3>,
  <-1.0, -0.3>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.3>,
  <0.6, -0.3>,
  <0.4, -0.6>,
  <-0.3, -0.6>,
  <-0.7, 0.0>,
  <-0.3, 0.6>,
  <0.4, 0.6>,
  <0.6, 0.3>,
  <0.6, 0.3>,
  <1.0, 0.3>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.3>
  rotate -x*90
  scale <2.5, 2.5, 2.0>
  rotate <-270.0, -180.0, 270.0>
  translate  <1.0, 12.5, 0.0>
}
#declare RightClaw = union {
  cylinder { // Cylndr584
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  cylinder { // Cylndr585
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*x
  }
  object { TransSweep064 }
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Trans Y limited (9.0 to   21.5)
  translate  <13.0, 9.0, -0.5>
}
#declare LeftFoot = union {
  sphere { // Sphere130
    <0,0,0>,1
    scale 6.0
    translate  6.0*z
  }
  cylinder { // Cylndr586
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 16.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr587
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 12.0>
    translate  -22.0*z
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 16.0>
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-24.0 to   0.0)
  rotate <-180.0, 0.0, -180.0>
  translate VINcentLeftFootLocation
}
#declare LeftLeg = union {
  object { LeftFoot }
  material {
    Black
  }
  // All transformations fixed
  rotate 40.0*y
}
#declare RightFoot = union {
  sphere { // Sphere131
    <0,0,0>,1
    scale 6.0
    translate  6.0*z
  }
  cylinder { // Cylndr588
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 16.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr589
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 12.0>
    translate  -22.0*z
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (0.0 to   24.0)
  translate VINcentRightFootLocation
}
#declare RightLeg = union {
  object { RightFoot }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 16.0>
  material {
    Black
  }
  // All transformations fixed
  rotate <-180.0, 40.0, -180.0>
}
#declare CSG346 = difference {
  torus { // Torus055
    12.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  20.0*z
  }
  box { // Cube958
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 2.5>
    translate  <-3.5, 11.0, 20.0>
  }
  box { // Cube959
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 3.0, 1.5>
    translate  <-3.5, 11.0, 20.0>
  }
  cylinder { // Cylndr591
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-2.0, 8.0, 18.5>
  }
  cylinder { // Cylndr592
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-5.0, 8.0, 18.5>
  }
  cylinder { // Cylndr593
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-5.0, 8.0, 21.5>
  }
  cylinder { // Cylndr594
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-2.0, 8.0, 21.5>
  }
  box { // Cube960
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 2.5>
    translate  <3.5, 11.0, 20.0>
  }
  box { // Cube961
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 3.0, 1.5>
    translate  <3.5, 11.0, 20.0>
  }
  cylinder { // Cylndr595
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <2.0, 8.0, 18.5>
  }
  cylinder { // Cylndr596
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <5.0, 8.0, 18.5>
  }
  cylinder { // Cylndr597
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <5.0, 8.0, 21.5>
  }
  cylinder { // Cylndr598
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <2.0, 8.0, 21.5>
  }
}
#declare TransSweep065 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <2.25, 2.25, 4.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-9.0, 0.0, 20.0>
}
#declare TransSweep066 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <2.25, 2.25, 4.0>
  rotate <90.0, 0.0, 90.0>
  translate  <9.0, 0.0, 20.0>
}
#declare CSG347 = union {
  cylinder { // Cylndr590
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <12.0, 12.0, 8.0>
    translate  16.0*z
  }
  object { CSG346 }
  cylinder { // Cylndr599
    <0,0,1>, <0,0,0>, 1 
    rotate 0.0*x
    translate  <0.0, -0.0, 1.083333>
    material {
      Black
    }
    scale <1.0, 1.0, 6.0>
    rotate <-90.0, 0.0, -17.0>
    translate  20.0*z
  }
  cylinder { // Cylndr600
    <0,0,1>, <0,0,0>, 1 
    rotate 0.0*x
    translate  <0.0, -0.0, 1.083333>
    material {
      Black
    }
    scale <1.0, 1.0, 6.0>
    rotate <-90.0, 0.0, 17.0>
    translate  20.0*z
  }
  object { TransSweep065 }
  object { TransSweep066 }
  material {
    Red_3
  }
}
#declare TransSweep067 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  scale <1.75, 1.75, 4.0>
  rotate <90.0, 0.0, 90.0>
  translate  <10.0, 0.0, 20.0>
}
#declare TransSweep068 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  scale <1.75, 1.75, 4.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-10.0, 0.0, 20.0>
}
#declare CSG348 = difference {
  object { CSG347 }
  object { TransSweep067 }
  object { TransSweep068 }
  material {
    Black_Rubber
  }
}
#declare Face = union {
  object { CSG348 }
  // All transformations fixed
}
#declare CSG349 = union {
  cylinder { // Cylndr601
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 4.0>
    translate  23.5*z
  }
  torus { // Torus056
    1.5, 0.5  rotate -x*90
    scale 8.0
    translate  27.5*z
  }
  cylinder { // Cylndr602
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 7.0>
    translate  24.0*z
  }
  material {
    VINcentHat
    scale <16.0, 16.0, 8.0>
    rotate 90.0*z
    translate <0.000000, 0.000000, 23.500000>
  }
}
#declare CSG350 = difference {
  object { CSG349 }
  cylinder { // Cylndr603
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 1.0>
    translate  30.5*z
  }
  box { // Cube962
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <0.0, 16.5, 26.0>
  }
  box { // Cube963
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <0.0, -16.5, 26.0>
  }
  box { // Cube964
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <16.5, 0.0, 26.0>
  }
  box { // Cube965
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <-16.5, 0.0, 26.0>
  }
  cylinder { // Cylndr604
    <0,0,1>, <0,0,0>, 1 
    scale <14.0, 14.0, 5.0>
    translate  23.0*z
  }
}
#declare Hat = union {
  object { CSG350 }
  sphere { // Sphere132
    <0,0,0>,1
    scale <2.5, 2.5, 0.5>
    translate  31.0*z
  }
  material {
    Red_3
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-0.5 to   0.0)
}
#declare Head3 = union {
  object { Face }
  object { Hat }
  // Scaling fixed
  // Trans Z limited (-6.5 to   0.0)
}
#declare Body4 = union {
  object { BodyParts }
  object { LeftPhaser }
  object { RightPhaser }
  object { LeftClaw }
  object { RightClaw }
  object { LeftLeg }
  object { RightLeg }
  object { Head3 }
  // All transformations fixed
}
union { // VINcent
  object { Body4 }
  material {
    White
  }
  scale 1.5
  rotate VINcentRotation
  translate  VINcentLocation
}


#declare CSG351 = intersection {
  box { // Cube966
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 2.0, 8.0>
    translate  <0.0, 12.0, -12.0>
  }
  cylinder { // Cylndr607
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 10.0, 2.0>
    rotate -90.0*x
    translate  <0.0, 11.0, -15.0>
  }
}
#declare CSG352 = difference {
  cylinder { // Cylndr606
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    translate  -23.1*z
  }
  object { CSG351 }
}
#declare CSG353 = difference {
  box { // Cube967
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <0.0, 9.5, -15.5>
  }
  box { // Cube968
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <0.0, 9.5, -15.5>
  }
  material {
    Black
  }
}
#declare Body5 = union {
  sphere { // Sphere133
    <0,0,0>,1
    scale <12.0, 12.0, 4.0>
    translate  -23.1*z
  }
  cylinder { // Cylndr605
    <0,0,1>, <0,0,0>, 1 
    material {
      Belt
    }
    scale <12.25, 12.25, 5.0>
    translate  -18.0*z
  }
  object { CSG352 }
  torus { // Torus057
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <-12.0, 0.0, -8.0>
  }
  torus { // Torus058
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <12.0, 0.0, -8.0>
  }
  sphere { // Sphere134
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, 20.0, 15.0>
    translate  <7.0, 9.0, -8.0>
  }
  sphere { // Sphere135
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, -20.0, -15.0>
    translate  <-7.0, 9.0, -8.0>
  }
  sphere { // Sphere136
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <9.0, 0.0, -24.0>
  }
  sphere { // Sphere137
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <-9.0, 0.0, -24.0>
  }
  cylinder { // Cylndr608
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <9.0, 0.0, -28.0>
  }
  cylinder { // Cylndr609
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <-9.0, 0.0, -28.0>
  }
  cone { // Cone038
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate -90.0*y
    translate  <-13.0, 0.0, -24.0>
  }
  cone { // Cone039
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate 90.0*y
    translate  <13.0, 0.0, -24.0>
  }
  object { CSG353 }
  // All transformations fixed
}
#declare CSG354 = difference {
  sphere { // Sphere138
    <0,0,0>,1
    scale 12.0
  }
  box { // Cube969
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 13.0, 7.0>
    translate  7.0*z
  }
  box { // Cube970
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <-10.0, 0.0, 7.0>
  }
  box { // Cube971
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <10.0, 0.0, 7.0>
  }
}
#declare CSG355 = union {
  box { // Cube972
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <-4.0, -10.0, 10.0>
  }
  box { // Cube973
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <4.0, -10.0, 10.0>
  }
  box { // Cube974
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <0.0, -10.0, 10.0>
  }
}
#declare CSG356 = intersection {
  object { CSG355 }
  cylinder { // Cylndr610
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 16.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
}
#declare Head4 = union {
  object { CSG354 }
  object { CSG356 }
  cylinder { // Cylndr611
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 3.0>
    translate  -2.9*z
  }
  sphere { // Sphere139
    <0,0,0>,1
    material {
      Black
    }
    scale 11.0
  }
  cylinder { // Cylndr612
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, -60.0, -15.0>
  }
  cylinder { // Cylndr613
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, 60.0, 15.0>
  }
  cylinder { // Cylndr614
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr615
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr616
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr617
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  // Scaling fixed
  // Translation fixed
}
union { // UnknownB
  object { Body5 }
  object { Head4 }
  object { Arm5 }
  object { // Arm6->Arm5
    Arm5
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Leg8 }
  object { // Leg9->Leg8
    Leg8
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  material {
    Red_4
  }
  scale 2.0
  rotate -90.0*z
  matrix align(UnknownBAlign,<0,0,0>,<0,0,0>)
  translate  UnknownBLocation
}


#declare CSG359 = difference {
  sphere { // Sphere149
    <0,0,0>,1
    scale <2.5, 2.5, 5.0>
    translate  1.0*z
  }
  box { // Cube980
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  -1.0*z
  }
}
#declare CSG360 = difference {
  cylinder { // Cylndr657
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 10.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr658
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 11.0>
    translate  -6.5*z
  }
}
#declare CSG361 = difference {
  cylinder { // Cylndr659
    <0,0,1>, <0,0,0>, 1 
    scale <12.5, 12.5, 5.0>
    translate  2.0*z
  }
  cylinder { // Cylndr660
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 6.0>
    translate  1.5*z
  }
  material {
    Black_Rubber
  }
}
#declare Parts25 = union {
  object { CSG359 }
  cylinder { // Cylndr656
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 10.0>
    translate  -5.0*z
  }
  object { CSG360 }
  box { // Cube981
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    translate  3.0*z
  }
  box { // Cube982
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -120.0*z
    translate  3.0*z
  }
  box { // Cube983
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -240.0*z
    translate  3.0*z
  }
  object { CSG361 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Blades2 = union {
  object { Blade8 }
  object { // Blade9->Blade8
    Blade8
    rotate -90.0*z
  }
  object { // Blade10->Blade8
    Blade8
    rotate 180.0*z
  }
  object { // Blade11->Blade8
    Blade8
    rotate 90.0*z
  }
  torus { // Torus068
    2.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  1.0*z
  }
  torus { // Torus069
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -1.0*z
  }
  cone { // Cone044
    <0,0,0>, 2.0, <0,0,1>, 2.5
    open
    scale <1.0, 1.0, 2.0>
    translate  -1.0*z
  }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
}
#declare Fan3 = union {
  object { Parts25 }
  object { Blades2 }
  scale <1.8, 1.8, 1.0>
  translate  100.0*z
}
union { // EngineB
  object { Cylndr627 }
  cylinder { // Cylndr628
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 5.0>
    translate  90.0*z
  }
  cylinder { // Cylndr629
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 35.0>
    translate  60.0*z
  }
  cylinder { // Cylndr630
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 10.0>
    translate  60.0*z
  }
  sphere { // Sphere147
    <0,0,0>,1
    scale <25.0, 25.0, 30.0>
    translate  40.0*z
  }
  cylinder { // Cylndr631
    <0,0,1>, <0,0,0>, 1 
    scale <22.5, 22.5, 20.0>
  }
  object { // Cylndr632->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -18.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr633->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -36.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr634->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -54.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr635->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -72.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr636->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr637->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -108.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr638->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -126.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr639->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -144.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr640->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, -162.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr641->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr642->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr643->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr644->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr645->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr646->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr647->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr648->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 54.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr649->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 36.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr650->Cylndr627
    Cylndr627
    rotate <-0.0, 0.0, 18.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { Group022 }
  object { // Group023->Group022
    Group022
    rotate -30.0*z
  }
  object { // Group024->Group022
    Group022
    rotate -60.0*z
  }
  object { // Group025->Group022
    Group022
    rotate -90.0*z
  }
  object { // Group026->Group022
    Group022
    rotate -120.0*z
  }
  object { // Group027->Group022
    Group022
    rotate -150.0*z
  }
  object { // Group028->Group022
    Group022
    rotate 180.0*z
  }
  object { // Group029->Group022
    Group022
    rotate 150.0*z
  }
  object { // Group030->Group022
    Group022
    rotate 120.0*z
  }
  object { // Group031->Group022
    Group022
    rotate 90.0*z
  }
  object { // Group032->Group022
    Group022
    rotate 60.0*z
  }
  object { // Group033->Group022
    Group022
    rotate 30.0*z
  }
  cylinder { // Cylndr653
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <22.0, 22.0, 3.333333>
    translate  93.333333*z
  }
  cylinder { // Cylndr654
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  10.0*z
  }
  cylinder { // Cylndr655
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  3.333333*z
  }
  object { Torus061 }
  object { // Torus062->Torus061
    Torus061
    rotate -120.0*z
  }
  object { // Torus063->Torus061
    Torus061
    rotate 120.0*z
    translate  0.0*x
  }
  object { Torus064 }
  object { // Torus065->Torus064
    Torus064
    rotate -90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Torus066->Torus064
    Torus064
    rotate 180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Torus067->Torus064
    Torus064
    rotate 90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { Fan3 }
  material {
    T_Chrome_3A
  }
  scale 1.5
  translate  <1000.0, 1290.0, -1600.0>
}


#declare CSG363 = difference {
  sphere { // Sphere152
    <0,0,0>,1
    scale <2.5, 2.5, 5.0>
    translate  1.0*z
  }
  box { // Cube986
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  -1.0*z
  }
}
#declare CSG364 = difference {
  cylinder { // Cylndr692
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 10.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr693
    <0,0,1>, <0,0,0>, 1 
    scale <10.5, 10.5, 11.0>
    translate  -6.5*z
  }
}
#declare CSG365 = difference {
  cylinder { // Cylndr694
    <0,0,1>, <0,0,0>, 1 
    scale <12.5, 12.5, 5.0>
    translate  2.0*z
  }
  cylinder { // Cylndr695
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 6.0>
    translate  1.5*z
  }
  material {
    Black_Rubber
  }
}
#declare Parts26 = union {
  object { CSG363 }
  cylinder { // Cylndr691
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 10.0>
    translate  -5.0*z
  }
  object { CSG364 }
  box { // Cube987
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    translate  3.0*z
  }
  box { // Cube988
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -120.0*z
    translate  3.0*z
  }
  box { // Cube989
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.2, 0.5>
    scale <0.5, 5.0, 0.5>
    rotate -240.0*z
    translate  3.0*z
  }
  object { CSG365 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Blades3 = union {
  object { Blade12 }
  object { // Blade13->Blade12
    Blade12
    rotate -90.0*z
  }
  object { // Blade14->Blade12
    Blade12
    rotate 180.0*z
  }
  object { // Blade15->Blade12
    Blade12
    rotate 90.0*z
  }
  torus { // Torus079
    2.0, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  1.0*z
  }
  torus { // Torus080
    1.5, 0.5  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  -1.0*z
  }
  cone { // Cone047
    <0,0,0>, 2.0, <0,0,1>, 2.5
    open
    scale <1.0, 1.0, 2.0>
    translate  -1.0*z
  }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
}
#declare Fan4 = union {
  object { Parts26 }
  object { Blades3 }
  scale <1.8, 1.8, 1.0>
  translate  100.0*z
}
union { // EngineC
  object { Cylndr662 }
  cylinder { // Cylndr663
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 5.0>
    translate  90.0*z
  }
  cylinder { // Cylndr664
    <0,0,1>, <0,0,0>, 1 
    scale <15.0, 15.0, 35.0>
    translate  60.0*z
  }
  cylinder { // Cylndr665
    <0,0,1>, <0,0,0>, 1 
    scale <20.0, 20.0, 10.0>
    translate  60.0*z
  }
  sphere { // Sphere150
    <0,0,0>,1
    scale <25.0, 25.0, 30.0>
    translate  40.0*z
  }
  cylinder { // Cylndr666
    <0,0,1>, <0,0,0>, 1 
    scale <22.5, 22.5, 20.0>
  }
  object { // Cylndr667->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -18.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr668->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -36.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr669->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -54.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr670->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -72.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr671->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -90.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr672->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -108.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cylndr673->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -126.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr674->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -144.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr675->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, -162.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr676->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cylndr677->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 162.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr678->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 144.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr679->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 126.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr680->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 108.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr681->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 90.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cylndr682->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr683->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 54.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr684->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 36.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cylndr685->Cylndr662
    Cylndr662
    rotate <-0.0, 0.0, 18.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { Group036 }
  object { // Group037->Group036
    Group036
    rotate -30.0*z
  }
  object { // Group038->Group036
    Group036
    rotate -60.0*z
  }
  object { // Group039->Group036
    Group036
    rotate -90.0*z
  }
  object { // Group040->Group036
    Group036
    rotate -120.0*z
  }
  object { // Group041->Group036
    Group036
    rotate -150.0*z
  }
  object { // Group042->Group036
    Group036
    rotate 180.0*z
  }
  object { // Group043->Group036
    Group036
    rotate 150.0*z
  }
  object { // Group044->Group036
    Group036
    rotate 120.0*z
  }
  object { // Group045->Group036
    Group036
    rotate 90.0*z
  }
  object { // Group046->Group036
    Group036
    rotate 60.0*z
  }
  object { // Group047->Group036
    Group036
    rotate 30.0*z
  }
  cylinder { // Cylndr688
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <22.0, 22.0, 3.333333>
    translate  93.333333*z
  }
  cylinder { // Cylndr689
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  10.0*z
  }
  cylinder { // Cylndr690
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <25.0, 25.0, 3.333333>
    translate  3.333333*z
  }
  object { Torus072 }
  object { // Torus073->Torus072
    Torus072
    rotate -120.0*z
  }
  object { // Torus074->Torus072
    Torus072
    rotate 120.0*z
    translate  0.0*x
  }
  object { Torus075 }
  object { // Torus076->Torus075
    Torus075
    rotate -90.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Torus077->Torus075
    Torus075
    rotate 180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Torus078->Torus075
    Torus075
    rotate 90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { Fan4 }
  material {
    T_Chrome_3A
  }
  scale 1.5
  rotate <71.0, 0.0, -15.0>
  translate  <1000.0, 1190.0, -1566.0>
}


#declare CSG367 = intersection {
  box { // Cube992
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 2.0, 8.0>
    translate  <0.0, 12.0, -12.0>
  }
  cylinder { // Cylndr699
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 10.0, 2.0>
    rotate -90.0*x
    translate  <0.0, 11.0, -15.0>
  }
}
#declare CSG368 = difference {
  cylinder { // Cylndr698
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    translate  -23.1*z
  }
  object { CSG367 }
}
#declare CSG369 = difference {
  box { // Cube993
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <0.0, 9.5, -15.5>
  }
  box { // Cube994
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <0.0, 9.5, -15.5>
  }
  material {
    Black
  }
}
#declare Body6 = union {
  sphere { // Sphere153
    <0,0,0>,1
    scale <12.0, 12.0, 4.0>
    translate  -23.1*z
  }
  cylinder { // Cylndr697
    <0,0,1>, <0,0,0>, 1 
    material {
      Belt
    }
    scale <12.25, 12.25, 5.0>
    translate  -18.0*z
  }
  object { CSG368 }
  torus { // Torus081
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <-12.0, 0.0, -8.0>
  }
  torus { // Torus082
    1.5, 0.5  rotate -x*90
    scale <2.0, 2.0, 1.0>
    rotate 90.0*y
    translate  <12.0, 0.0, -8.0>
  }
  sphere { // Sphere154
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, 20.0, 15.0>
    translate  <7.0, 9.0, -8.0>
  }
  sphere { // Sphere155
    <0,0,0>,1
    scale <1.0, 1.0, 3.0>
    rotate <-10.0, -20.0, -15.0>
    translate  <-7.0, 9.0, -8.0>
  }
  sphere { // Sphere156
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <9.0, 0.0, -24.0>
  }
  sphere { // Sphere157
    <0,0,0>,1
    scale <5.0, 7.0, 4.0>
    translate  <-9.0, 0.0, -24.0>
  }
  cylinder { // Cylndr700
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <9.0, 0.0, -28.0>
  }
  cylinder { // Cylndr701
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    translate  <-9.0, 0.0, -28.0>
  }
  cone { // Cone048
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate -90.0*y
    translate  <-13.0, 0.0, -24.0>
  }
  cone { // Cone049
    <0,0,0>, 2.5, <0,0,1>, 1.5
    scale <1.0, 1.0, 1.5>
    rotate 90.0*y
    translate  <13.0, 0.0, -24.0>
  }
  object { CSG369 }
  // All transformations fixed
}
#declare CSG370 = difference {
  sphere { // Sphere158
    <0,0,0>,1
    scale 12.0
  }
  box { // Cube995
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 13.0, 7.0>
    translate  7.0*z
  }
  box { // Cube996
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <-10.0, 0.0, 7.0>
  }
  box { // Cube997
    <-1, -1, -1>, <1, 1, 1>
    scale <5.5, 13.0, 7.0>
    translate  <10.0, 0.0, 7.0>
  }
}
#declare CSG371 = union {
  box { // Cube998
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <-4.0, -10.0, 10.0>
  }
  box { // Cube999
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <4.0, -10.0, 10.0>
  }
  box { // Cube1000
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.0, 10.0>
    translate  <0.0, -10.0, 10.0>
  }
}
#declare CSG372 = intersection {
  object { CSG371 }
  cylinder { // Cylndr702
    <0,0,1>, <0,0,0>, 1 
    scale <18.0, 16.0, 20.0>
    rotate 90.0*y
    translate  -10.0*x
  }
}
#declare Head5 = union {
  object { CSG370 }
  object { CSG372 }
  cylinder { // Cylndr703
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 3.0>
    translate  -2.9*z
  }
  sphere { // Sphere159
    <0,0,0>,1
    material {
      Black
    }
    scale 11.0
  }
  cylinder { // Cylndr704
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, -60.0, -15.0>
  }
  cylinder { // Cylndr705
    <0,0,1>, <0,0,0>, 1 
    translate  10.1*z
    scale <2.5, 2.5, 1.0>
    rotate <0.0, 60.0, 15.0>
  }
  cylinder { // Cylndr706
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr707
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 7.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr708
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate -30.0*y
    translate  <-11.0, 0.0, -3.0>
  }
  cylinder { // Cylndr709
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 5.0>
    rotate 30.0*y
    translate  <11.0, 0.0, -3.0>
  }
  // Scaling fixed
  // Translation fixed
}
union { // UnknownC
  object { Body6 }
  object { Head5 }
  object { Arm7 }
  object { // Arm8->Arm7
    Arm7
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Leg10 }
  object { // Leg11->Leg10
    Leg10
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  material {
    Red_5
  }
  scale 2.0
  rotate -90.0*z
  matrix align(UnknownCAlign,<0,0,0>,<0,0,0>)
  translate  UnknownCLocation
}


#declare CSG377 = intersection {
  torus { // Torus083
    10.0, 0.15  rotate -x*90
    scale <1.0, 3.0, 1.0>
    rotate -90.0*x
  }
  box { // Cube1007
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 18.0>
    translate  <-7.0, 0.0, 18.0>
  }
}
#declare Antenna1 = union {
  object { CSG377 }
  sphere { // Sphere168
    <0,0,0>,1
    scale 0.5
    translate  30.0*z
  }
  translate  10.0*x
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Rot X limited (-10.0 to   10.0)
  // Rot Y limited (-10.0 to   10.0)
  // Rot Z limited (-10.0 to   10.0)
  // Translation fixed
  rotate BuggyBAntennaRotation
  translate  <16.0, 0.0, 5.0>
}
#declare CSG378 = difference {
  sphere { // Sphere169
    <0,0,0>,1
    scale 12.0
    translate  -12.0*x
  }
  box { // Cube1008
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <-12.0, 0.0, -9.0>
  }
  sphere { // Sphere170
    <0,0,0>,1
    scale 7.0
    translate  <-13.0, 12.5, 0.0>
  }
  sphere { // Sphere171
    <0,0,0>,1
    scale 7.0
    translate  <-13.0, -12.5, 0.0>
  }
  box { // Cube1009
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 2.5, 2.5>
    translate  <-16.0, -4.0, 6.0>
  }
  box { // Cube1010
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 2.5, 2.5>
    translate  <-16.0, 4.0, 6.0>
  }
  material {
    Tinny_Brass
  }
}
#declare CSG379 = difference {
  cylinder { // Cylndr737
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 50.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 0.0>
  }
  cylinder { // Cylndr738
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 60.0>
    rotate -90.0*y
    translate  <30.0, -5.0, 0.0>
  }
  translate  -1.0*y
}
#declare CSG380 = difference {
  cylinder { // Cylndr739
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 50.0>
    rotate -90.0*y
    translate  <25.0, -5.0, 0.0>
  }
  cylinder { // Cylndr740
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 60.0>
    rotate -90.0*y
    translate  <30.0, -5.0, 0.0>
  }
  translate  11.0*y
}
#declare CSG381 = difference {
  sphere { // Sphere172
    <0,0,0>,1
    scale 11.0
    translate  -12.0*x
  }
  box { // Cube1011
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <-12.0, 0.0, -8.0>
  }
  material {
    RedClear
  }
}
#declare CSG382 = difference {
  cylinder { // Cylndr741
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 10.0, 30.0>
    rotate -90.0*y
    translate  15.0*x
  }
  sphere { // Sphere173
    <0,0,0>,1
    scale 7.0
    translate  <13.0, 12.5, 0.0>
  }
  sphere { // Sphere174
    <0,0,0>,1
    scale 7.0
    translate  <13.0, -12.5, 0.0>
  }
  sphere { // Sphere175
    <0,0,0>,1
    scale 7.0
    translate  -12.5*y
  }
  sphere { // Sphere176
    <0,0,0>,1
    scale 7.0
    translate  12.5*y
  }
  box { // Cube1012
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 16.0, 10.666667>
    translate  -9.0*z
  }
  box { // Cube1013
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 8.0, 5.0>
    translate  <5.0, 0.0, 4.0>
  }
  material {
    Tinny_Brass
  }
}
#declare CSG383 = difference {
  sphere { // Sphere177
    <0,0,0>,1
    scale <7.0, 10.0, 7.0>
    translate  15.0*x
  }
  box { // Cube1014
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 12.0, 8.0>
    translate  <12.0, 0.0, -9.0>
  }
  sphere { // Sphere178
    <0,0,0>,1
    scale 7.0
    translate  <13.0, 12.5, 0.0>
  }
  sphere { // Sphere179
    <0,0,0>,1
    scale 7.0
    translate  <13.0, -12.5, 0.0>
  }
  box { // Cube1015
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 8.0, 5.0>
    translate  <5.0, 0.0, 4.0>
  }
  material {
    Tinny_Brass
  }
}
#declare Group048 = union {
  object { Cube1016 }
  object { // Cube1017->Cube1016
    Cube1016
    translate  3.0*x
  }
  object { // Cube1018->Cube1016
    Cube1016
    translate  6.0*x
  }
  object { // Cube1019->Cube1016
    Cube1016
    translate  9.0*x
  }
  object { // Cube1020->Cube1016
    Cube1016
    translate  12.0*x
  }
  object { // Cube1021->Cube1016
    Cube1016
    translate  15.0*x
  }
}
#declare Parts27 = union {
  object { CSG378 }
  object { CSG379 }
  object { CSG380 }
  object { CSG381 }
  object { CSG382 }
  object { CSG383 }
  object { Group048 }
  material {
    T_Chrome_2E
  }
  // All transformations fixed
  translate  6.5*z
}
union { // BuggyB
  object { Wheels4 }
  object { // Wheels5->Wheels4
    Wheels4
    // All transformations fixed
    translate  25.0*y
  }
  object { Antenna1 }
  object { Parts27 }
  scale 2.0
  rotate -180.0*z
  matrix align(BuggyBAlign,<0,0,0>,<0,0,0>)
  translate  BuggyBLocation
}


#declare CSG384 = difference {
  cylinder { // Cylndr744
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.0>
    translate  -38.0*z
  }
  cylinder { // Cylndr745
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <2.5, 2.5, 3.0>
    translate  -39.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Fuselage2 = union {
  cylinder { // Cylndr742
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <4.0, 4.0, 30.0>
    translate  -36.0*z
  }
  sphere { // Sphere180
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 15.0>
    translate  25.0*z
  }
  cylinder { // Cylndr743
    <0,0,1>, <0,0,0>, 1 
    material {
      ForeSection
    }
    scale <5.0, 5.0, 25.0>
  }
  sphere { // Sphere181
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 40.0>
  }
  sphere { // Sphere182
    <0,0,0>,1
    material {
      JetBlack
    }
    scale 2.0
    translate  38.5*z
  }
  object { CSG384 }
  object { Cube1022 }
  object { // Cube1023->Cube1022
    Cube1022
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube1024->Cube1022
    Cube1022
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube1025->Cube1022
    Cube1022
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1026->Cube1022
    Cube1022
    rotate 0.0*x
    translate  <0.0, -0.0, -16.0>
  }
  object { // Cube1027->Cube1022
    Cube1022
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -16.0>
  }
  object { // Cube1028->Cube1022
    Cube1022
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -16.0>
  }
  object { // Cube1029->Cube1022
    Cube1022
    rotate <0.0, 0.0, -270.0>
    translate  <0.0, -0.0, -16.0>
  }
  material {
    White
  }
  // All transformations fixed
}
union { // Missile4B
  object { Fuselage2 }
  object { RearFin8 }
  object { FrontFin8 }
  object { // FrontFin9->FrontFin8
    FrontFin8
    // All transformations fixed
    rotate -90.0*z
  }
  object { // FrontFin10->FrontFin8
    FrontFin8
    // All transformations fixed
    rotate 180.0*z
  }
  object { // FrontFin11->FrontFin8
    FrontFin8
    // All transformations fixed
    rotate 90.0*z
  }
  object { // RearFin9->RearFin8
    RearFin8
    // All transformations fixed
    rotate -90.0*z
  }
  object { // RearFin10->RearFin8
    RearFin8
    // All transformations fixed
    rotate 180.0*z
  }
  object { // RearFin11->RearFin8
    RearFin8
    // All transformations fixed
    rotate 90.0*z
  }
  scale <1.575, 1.575, 2.25>
  rotate -45.0*z
  translate  <200.0, 790.0, -1510.0>
}


#declare CSG386 = union {
  cone { // Cone052
    <0,0,0>, 9.0, <0,0,1>, 11.0
    scale <1.0, 1.0, 2.0>
    translate  -2.0*z
  }
  cylinder { // Cylndr748
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Body
      rotate 90.0*z
    }
    scale <12.0, 12.0, 30.0>
  }
}
#declare CSG387 = difference {
  object { CSG386 }
  cylinder { // Cylndr749
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 20.0>
    translate  -2.5*z
  }
}
#declare Dome1 = difference {
  sphere { // Sphere183
    <0,0,0>,1
    material {
      R2D2Dome
      rotate -90.0*z
    }
    scale 12.0
    translate  30.0*z
  }
  box { // Cube1037
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 6.0>
    translate  24.0*z
  }
}
// Include contains 'TransSweep069'
#include "xfinal.in4"

#declare TransSweep069 = object {
  TransSweep069_Raw
  scale <4.0, 4.0, 2.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare TransSweep070 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.8, -0.6>,
  <0.8, -0.6>,
  <0.5, 0.5>,
  <-0.5, 0.5>,
  <-0.8, -0.6>
  rotate -x*90
  scale <2.0, 2.0, 3.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare EyeSocket1 = difference {
  object { TransSweep069 }
  object { TransSweep070 }
  material {
    BLUE_METAL
  }
}
#declare Projector3 = difference {
  cone { // Cone053
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere184
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -8.0*z
  translate  -1.0*z
}
#declare Projector4 = difference {
  cone { // Cone054
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere185
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -210.0*z
}
#declare Projector5 = difference {
  cone { // Cone055
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere186
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  rotate 0.0*x
  translate  <0.0, 0.0, -30.0>
  material {
    T_Chrome_2E
  }
  rotate <-90.0, -0.0, -20.0>
  translate  30.0*z
}
#declare Head6 = union {
  object { Dome1 }
  object { EyeSocket1 }
  sphere { // Eye1
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale 1.5
    translate  <0.0, -9.75, 35.0>
  }
  object { Projector3 }
  object { Projector4 }
  object { Projector5 }
  // Scaling fixed
  // Translation fixed
  rotate -180.0*z
  translate  0.1*z
}
#declare TransSweep071 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep072 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG388 = intersection {
  object { TransSweep071 }
  object { TransSweep072 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG389 = difference {
  object { CSG388 }
  box { // Cube1038
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1039
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1040
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
  translate  -3.0*x
}
#declare ThirdFoot1 = union {
  object { CSG389 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  translate  -26.0*z
}
#declare TaperSweep009 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG390 = union {
  box { // Cube1041
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1042
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep009 }
  scale <0.95, 1.0, 1.0>
  translate  -2.85*x
}
#declare ThirdLeg1 = union {
  object { ThirdFoot1 }
  object { CSG390 }
  cylinder { // Cylndr750
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <-0.5, 0.0, -26.0>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (23.0 to   36.0)
  translate  36.0*z
}
#declare Body7 = union {
  object { CSG387 }
  object { Head6 }
  object { ThirdLeg1 }
  translate  -23.0*z
  // Scaling fixed
  // Rot X limited (-5.0 to   30.0)
  // Translation fixed
}
#declare TransSweep073 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep074 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep075 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep010 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG391 = union {
  cylinder { // Cylndr752
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1043
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep074 }
  cylinder { // Cylndr753
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1044
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep075 }
  box { // Cube1045
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1046
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep010 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG392 = difference {
  object { CSG391 }
  cylinder { // Cylndr754
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg12 = union {
  object { TransSweep073 }
  cylinder { // Cylndr751
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG392 }
  cylinder { // Cylndr755
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr756
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  translate  13.0*x
}
#declare TransSweep076 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep077 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep078 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep011 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG393 = union {
  cylinder { // Cylndr758
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1047
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep077 }
  cylinder { // Cylndr759
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1048
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep078 }
  box { // Cube1049
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1050
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep011 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG394 = difference {
  object { CSG393 }
  cylinder { // Cylndr760
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg13 = union {
  object { TransSweep076 }
  cylinder { // Cylndr757
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG394 }
  cylinder { // Cylndr761
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr762
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  rotate 180.0*z
  translate  -12.0*x
}
#declare Legs1 = union {
  object { Body7 }
  object { Leg12 }
  object { Leg13 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  translate  -26.0*z
}
#declare TransSweep079 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep080 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG395 = intersection {
  object { TransSweep079 }
  object { TransSweep080 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG396 = difference {
  object { CSG395 }
  box { // Cube1051
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube1052
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr763
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube1053
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1054
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1055
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG397 = difference {
  torus { // Torus084
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube1057
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
}
#declare CSG398 = difference {
  torus { // Torus085
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube1058
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
}
#declare Foot2 = union {
  object { CSG396 }
  box { // Cube1056
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr764
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr765
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.0, -32.5>
  }
  cylinder { // Cylndr766
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.5, -34.5>
  }
  object { CSG397 }
  object { CSG398 }
  translate  12.0*x
}
#declare TransSweep081 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep082 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG399 = intersection {
  object { TransSweep081 }
  object { TransSweep082 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG400 = difference {
  object { CSG399 }
  box { // Cube1059
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube1060
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr767
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube1061
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1062
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG401 = difference {
  torus { // Torus086
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube1065
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare CSG402 = difference {
  torus { // Torus087
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube1066
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare Foot3 = union {
  object { CSG400 }
  box { // Cube1064
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr768
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr769
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -5.5, -32.5>
  }
  cylinder { // Cylndr770
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -6.5, -34.5>
  }
  object { CSG401 }
  object { CSG402 }
  rotate 180.0*z
  translate  -12.0*x
}
#declare Feet1 = union {
  object { Legs1 }
  object { Foot2 }
  object { Foot3 }
  // All transformations fixed
  translate  37.9*z
}
union { // R2D2B
  object { Feet1 }
  material {
    White
  }
  scale 1.5
  rotate -180.0*z
  translate  <-80.0, 832.5, -1547.5>
}


#declare CSG403 = union {
  cone { // Cone056
    <0,0,0>, 9.0, <0,0,1>, 11.0
    scale <1.0, 1.0, 2.0>
    translate  -2.0*z
  }
  cylinder { // Cylndr771
    <0,0,1>, <0,0,0>, 1 
    material {
      R2D2Body
      rotate 90.0*z
    }
    scale <12.0, 12.0, 30.0>
  }
}
#declare CSG404 = difference {
  object { CSG403 }
  cylinder { // Cylndr772
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 20.0>
    translate  -2.5*z
  }
}
#declare Dome2 = difference {
  sphere { // Sphere187
    <0,0,0>,1
    material {
      R2D2Dome
      rotate -90.0*z
    }
    scale 12.0
    translate  30.0*z
  }
  box { // Cube1067
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 6.0>
    translate  24.0*z
  }
}
// Include contains 'TransSweep083'
#include "xfinal.in5"

#declare TransSweep083 = object {
  TransSweep083_Raw
  scale <4.0, 4.0, 2.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare TransSweep084 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.8, -0.6>,
  <0.8, -0.6>,
  <0.5, 0.5>,
  <-0.5, 0.5>,
  <-0.8, -0.6>
  rotate -x*90
  scale <2.0, 2.0, 3.0>
  rotate <-115.0, -180.0, -180.0>
  translate  <0.0, -9.0, 35.0>
}
#declare EyeSocket2 = difference {
  object { TransSweep083 }
  object { TransSweep084 }
  material {
    BLUE_METAL
  }
}
#declare Projector6 = difference {
  cone { // Cone057
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere188
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -8.0*z
  translate  -1.0*z
}
#declare Projector7 = difference {
  cone { // Cone058
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere189
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  material {
    T_Chrome_2E
  }
  rotate -210.0*z
}
#declare Projector8 = difference {
  cone { // Cone059
    <0,0,0>, 0.8, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    rotate <-100.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  sphere { // Sphere190
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale <0.75, 0.15, 0.75>
    rotate <-10.0, 0.0, 15.0>
    translate  <5.0, -11.5, 33.0>
  }
  rotate 0.0*x
  translate  <0.0, 0.0, -30.0>
  material {
    T_Chrome_2E
  }
  rotate <-90.0, -0.0, -20.0>
  translate  30.0*z
}
#declare Head7 = union {
  object { Dome2 }
  object { EyeSocket2 }
  sphere { // Eye2
    <0,0,0>,1
    material {
      T_Vicksbottle_Glass
    }
    scale 1.5
    translate  <0.0, -9.75, 35.0>
  }
  object { Projector6 }
  object { Projector7 }
  object { Projector8 }
  // Scaling fixed
  // Translation fixed
  rotate -180.0*z
  translate  0.1*z
}
#declare TransSweep085 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep086 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG405 = intersection {
  object { TransSweep085 }
  object { TransSweep086 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG406 = difference {
  object { CSG405 }
  box { // Cube1068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1069
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1070
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
  translate  -3.0*x
}
#declare ThirdFoot2 = union {
  object { CSG406 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  rotate -15.0*x
  translate  -26.0*z
}
#declare TaperSweep012 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG407 = union {
  box { // Cube1071
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1072
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep012 }
  scale <0.95, 1.0, 1.0>
  translate  -2.85*x
}
#declare ThirdLeg2 = union {
  object { ThirdFoot2 }
  object { CSG407 }
  cylinder { // Cylndr773
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <-0.5, 0.0, -26.0>
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (23.0 to   36.0)
  translate  23.0*z
}
#declare Body8 = union {
  object { CSG404 }
  object { Head7 }
  object { ThirdLeg2 }
  translate  -23.0*z
  // Scaling fixed
  // Rot X limited (-5.0 to   30.0)
  // Translation fixed
  rotate 30.0*x
}
#declare TransSweep087 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep088 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep089 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep013 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG408 = union {
  cylinder { // Cylndr775
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1073
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep088 }
  cylinder { // Cylndr776
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1074
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep089 }
  box { // Cube1075
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1076
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep013 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG409 = difference {
  object { CSG408 }
  cylinder { // Cylndr777
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg14 = union {
  object { TransSweep087 }
  cylinder { // Cylndr774
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG409 }
  cylinder { // Cylndr778
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr779
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  translate  13.0*x
}
#declare TransSweep090 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.1, -1.0>,
  <0.05, -1.0>,
  <0.1, -0.9>,
  <0.2, 0.35>,
  <0.1, 0.4>,
  <0.2, 0.6>,
  <0.2, 0.9>,
  <0.1, 1.0>,
  <-0.1, 1.0>,
  <-0.1, -1.0>
  rotate -x*90
  material {
    BLUE_METAL
  }
  scale <4.0, 8.75, 4.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <4.5, 2.0, -11.0>
}
#declare TransSweep091 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TransSweep092 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <1.0, 0.5>,
  <-1.0, 0.5>,
  <-0.5, 0.0>
  rotate -x*90
  scale <6.0, 6.0, 5.0>
  rotate <90.0, 0.0, 90.0>
  translate  -9.0*z
}
#declare TaperSweep014 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 4.0, 6.0>
  translate  <3.0, 0.0, -30.0>
}
#declare CSG410 = union {
  cylinder { // Cylndr781
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1077
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep091 }
  cylinder { // Cylndr782
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 5.0>
    rotate 90.0*y
  }
  box { // Cube1078
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 6.0, 3.0>
    translate  <2.5, 0.0, -3.0>
  }
  object { TransSweep092 }
  box { // Cube1079
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 10.0>
    translate  <3.0, 0.0, -13.0>
  }
  box { // Cube1080
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 4.0, 2.0>
    translate  <3.0, 0.0, -22.0>
  }
  object { TaperSweep014 }
  material {
    R2D2Leg
    scale <32.0, 12.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 6.000000, -26.000000>
  }
  scale <0.95, 1.0, 1.0>
}
#declare CSG411 = difference {
  object { CSG410 }
  cylinder { // Cylndr783
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale 2.0
    rotate 90.0*y
    translate  3.5*x
  }
}
#declare Leg15 = union {
  object { TransSweep090 }
  cylinder { // Cylndr780
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 1.0>
    rotate 90.0*y
    translate  <2.5, 0.0, -26.0>
  }
  object { CSG411 }
  cylinder { // Cylndr784
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <1.0, 1.0, 3.0>
    rotate 90.0*x
    translate  <5.0, 1.5, -26.0>
  }
  cylinder { // Cylndr785
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 7.0>
    rotate 90.0*x
    translate  <5.0, 3.5, -26.0>
  }
  // All transformations fixed
  rotate 180.0*z
  translate  -12.0*x
}
#declare Legs2 = union {
  object { Body8 }
  object { Leg14 }
  object { Leg15 }
  translate  26.0*z
  // Scaling fixed
  // Rot X limited (-15.0 to   5.0)
  // Translation fixed
  rotate -15.0*x
  translate  -26.0*z
}
#declare TransSweep093 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep094 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG412 = intersection {
  object { TransSweep093 }
  object { TransSweep094 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG413 = difference {
  object { CSG412 }
  box { // Cube1081
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube1082
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr786
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube1083
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1084
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1085
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG414 = difference {
  torus { // Torus088
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube1087
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
}
#declare CSG415 = difference {
  torus { // Torus089
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube1088
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
}
#declare Foot4 = union {
  object { CSG413 }
  box { // Cube1086
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr787
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr788
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.0, -32.5>
  }
  cylinder { // Cylndr789
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, 1.5, -34.5>
  }
  object { CSG414 }
  object { CSG415 }
  translate  12.0*x
}
#declare TransSweep095 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <8.0, 8.0, 10.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-3.0, 0.0, -31.5>
}
#declare TransSweep096 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -0.8>,
  <0.8, -0.8>,
  <1.0, -0.6>,
  <0.5, 0.3>,
  <-0.5, 0.3>,
  <-1.0, -0.6>,
  <-0.8, -0.8>
  rotate -x*90
  scale <5.0, 8.0, 16.0>
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 8.0, -31.5>
}
#declare CSG416 = intersection {
  object { TransSweep095 }
  object { TransSweep096 }
  material {
    R2D2Foot
    scale <9.0, 16.0, 1.0>
    rotate <0.0, -90.0, -180.0>
    translate <0.000000, 8.000000, -38.000000>
  }
  translate  1.0*x
}
#declare CSG417 = difference {
  object { CSG416 }
  box { // Cube1089
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 9.0, 4.0>
    translate  <-0.5, 0.0, -31.0>
  }
  box { // Cube1090
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, -9.0, 1.0>
    translate  <-1.0, 0.0, -35.0>
  }
  cylinder { // Cylndr790
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 18.0>
    rotate -90.0*x
    translate  <0.0, -9.0, -35.0>
  }
  box { // Cube1091
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate -62.0*x
    translate  <3.0, 5.5, -31.5>
  }
  box { // Cube1092
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    translate  <3.0, 0.0, -29.0>
  }
  box { // Cube1093
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 5.0, 0.5>
    rotate <62.0, -0.0, 0.0>
    translate  <3.0, -5.5, -31.5>
  }
}
#declare CSG418 = difference {
  torus { // Torus090
    1.75, 0.25  rotate -x*90
    translate  <1.0, 6.5, -34.5>
  }
  box { // Cube1095
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.5, -34.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare CSG419 = difference {
  torus { // Torus091
    1.75, 0.25  rotate -x*90
    translate  <1.0, 5.5, -32.5>
  }
  box { // Cube1096
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 1.0, 0.5>
    translate  <1.0, 5.0, -32.5>
  }
  material {
    Black_Rubber
  }
  rotate -180.0*z
  translate  2.0*x
}
#declare Foot5 = union {
  object { CSG417 }
  box { // Cube1094
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 4.0, 2.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cylinder { // Cylndr791
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 8.0>
    rotate -90.0*x
    translate  <-0.5, -4.0, -32.0>
  }
  cylinder { // Cylndr792
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -5.5, -32.5>
  }
  cylinder { // Cylndr793
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <0.25, 0.25, 5.0>
    rotate -90.0*x
    translate  <-0.75, -6.5, -34.5>
  }
  object { CSG418 }
  object { CSG419 }
  rotate 180.0*z
  translate  -12.0*x
}
#declare Feet2 = union {
  object { Legs2 }
  object { Foot4 }
  object { Foot5 }
  // All transformations fixed
  translate  37.9*z
}
union { // R2D2C
  object { Feet2 }
  material {
    White
  }
  scale 1.5
  rotate -90.0*z
  matrix align(R2D2CAlign,<0,0,0>,<0,0,0>)
  translate  R2D2CLocation
}


#declare Other_Wheels2 = union {
  object { // Wheel45->Wheel44
    Wheel44
    translate  93.0*y
  }
  object { // Wheel46->Wheel44
    Wheel44
    translate  62.0*y
  }
  object { // Wheel47->Wheel44
    Wheel44
    translate  31.0*y
  }
  object { // Wheel48->Wheel44
    Wheel44
    translate  -31.0*y
  }
  object { // Wheel49->Wheel44
    Wheel44
    translate  -62.0*y
  }
  object { // Wheel50->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, 93.0, 0.0>
  }
  object { // Wheel51->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, 62.0, 0.0>
  }
  object { // Wheel52->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, 31.0, 0.0>
  }
  object { // Wheel53->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, -31.0, 0.0>
  }
  object { // Wheel54->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, -0.0, 0.0>
  }
  object { // Wheel55->Wheel44
    Wheel44
    rotate 0.0*z
    translate  <-120.0, -62.0, 0.0>
  }
  // All transformations fixed
}
#declare Wheels6 = union {
  object { Wheel44 }
  object { Other_Wheels2 }
  // All transformations fixed
}
#declare CSG421 = difference {
  cylinder { // Cylndr801
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr802
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1101
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
}
#declare CSG422 = difference {
  cylinder { // Cylndr803
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr804
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1102
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  translate  120.0*x
}
#declare CSG423 = difference {
  cylinder { // Cylndr805
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr806
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1103
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
}
#declare CSG424 = difference {
  cylinder { // Cylndr807
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr808
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1104
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
  translate  -120.0*x
}
#declare Parts28 = union {
  box { // Cube1100
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 80.0, 10.0>
  }
  object { CSG421 }
  object { CSG422 }
  object { CSG423 }
  object { CSG424 }
  box { // Cube1105
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, 11.0>
  }
  box { // Cube1106
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, 11.0>
  }
  box { // Cube1107
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, -21.0>
  }
  box { // Cube1108
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, -21.0>
  }
  cylinder { // Cylndr809
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, -80.0, 0.0>
  }
  cylinder { // Cylndr810
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 80.0, 0.0>
  }
  // All transformations fixed
}
#declare Other_Tracksides2 = union {
  object { // Trackside9->Trackside8
    Trackside8
    translate  120.0*x
  }
  object { // Trackside10->Trackside8
    Trackside8
    rotate <0.0, -180.0, -180.0>
    translate  -10.0*z
  }
  object { // Trackside11->Trackside8
    Trackside8
    rotate <-0.0, -180.0, -180.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Tracksides2 = union {
  object { Trackside8 }
  object { Other_Tracksides2 }
  // All transformations fixed
}
#declare Other_Trackends2 = union {
  object { // Trackend9->Trackend8
    Trackend8
    rotate <180.0, 0.0, -0.0>
    translate  -10.0*z
  }
  object { // Trackend10->Trackend8
    Trackend8
    translate  120.0*x
  }
  object { // Trackend11->Trackend8
    Trackend8
    rotate <-180.0, 0.0, -0.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Trackends2 = union {
  object { Trackend8 }
  object { Other_Trackends2 }
  // All transformations fixed
}
#declare Track_Set2 = union {
  object { Wheels6 }
  object { Parts28 }
  object { Tracksides2 }
  object { Trackends2 }
  translate  22.0*z
}
#declare Wrist1 = union {
  cylinder { // Cylndr817
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
    rotate -90.0*x
  }
  object { Claw7 }
  object { // Claw8->Claw7
    Claw7
    rotate <0.0, -120.0, -0.0>
  }
  object { // Claw9->Claw7
    Claw7
    rotate <0.0, 120.0, -0.0>
  }
  // Scaling fixed
  // Translation fixed
  rotate -0.0*y
  translate  -39.0*y
}
#declare Elbow1 = union {
  cylinder { // Cylndr815
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr816
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 25.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { Wrist1 }
  // Scaling fixed
  // Rot X limited (-5.0 to   95.0)
  // Translation fixed
  rotate 56.642101*x
  translate  -60.0*y
}
#declare CSG425 = difference {
  cylinder { // Cylndr820
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr821
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube1115
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  rotate 90.0*x
  translate  -60.0*y
}
#declare Hinge1 = union {
  cylinder { // Cylndr814
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  object { Elbow1 }
  cylinder { // Cylndr819
    <0,0,1>, <0,0,0>, 1 
    scale <7.5, 7.5, 47.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { CSG425 }
  // Scaling fixed
  // Rot X limited (-90.0 to   0.0)
  // Translation fixed
  rotate -10.148837*x
  translate  50.0*z
}
#declare CSG426 = difference {
  cylinder { // Cylndr822
    <0,0,1>, <0,0,0>, 1 
    scale <14.0, 14.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  cylinder { // Cylndr823
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube1116
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  translate  50.0*z
}
#declare Post1 = union {
  cylinder { // Cylndr813
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 61.0>
    translate  -20.0*z
  }
  object { Hinge1 }
  object { CSG426 }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (24.0 to   59.0)
  translate  32.670177*z
}
#declare Arm9 = union {
  cylinder { // Cylndr811
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
  }
  cylinder { // Cylndr812
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 40.0>
  }
  object { Post1 }
  // Scaling fixed
  // Translation fixed
  rotate -20.0*z
  translate  <0.0, -30.0, 22.0>
}
#declare Basket1 = union {
  box { // Cube1117
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 10.0, 34.0>
  }
  box { // Cube1118
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 10.0, 34.0>
  }
  box { // Cube1119
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 70.0, 34.0>
  }
  box { // Cube1120
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 70.0, 34.0>
  }
  box { // Cube1121
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 10.0, 40.0>
  }
  box { // Cube1122
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 70.0, 40.0>
  }
  box { // Cube1123
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 90.0, 70.0>
  }
  box { // Cube1124
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, -10.0, 70.0>
  }
  box { // Cube1125
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <30.0, 40.0, 40.0>
  }
  box { // Cube1126
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <-57.0, 40.0, 70.0>
  }
  box { // Cube1127
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <57.0, 40.0, 70.0>
  }
  box { // Cube1128
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <-30.0, 40.0, 40.0>
  }
  box { // Cube1129
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 70.0, 55.0>
  }
  box { // Cube1130
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 70.0, 55.0>
  }
  box { // Cube1131
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 10.0, 55.0>
  }
  box { // Cube1132
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 10.0, 55.0>
  }
  material {
    T_Chrome_2E
  }
}
union { // TransporterB
  object { Track_Set2 }
  object { Arm9 }
  object { Basket1 }
  cylinder { // Cylndr824
    <0,0,1>, <0,0,0>, 1 
    scale <35.0, 35.0, 20.0>
    translate  <0.0, -30.0, 22.0>
  }
  material {
    BLUE_METAL
  }
  scale 0.5
  rotate 90.0*z
  translate  <-400.0, 1910.0, -1600.0>
}


#declare CSG427 = difference {
  cylinder { // Cylndr825
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
  }
  cylinder { // Cylndr826
    <0,0,1>, <0,0,0>, 1 
    material {
      LitShade
    }
    scale <8.0, 8.0, 10.0>
    translate  -2.0*z
  }
  translate  -10.0*z
}
union { // LittleLight
  object { CSG427 }
  sphere { // Sphere191
    <0,0,0>,1
    material {
      WhiteBulb
    }
    no_shadow
    scale 2.0
    translate  -7.0*z
  }
  cylinder { // Cylndr827
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 70.0>
  }
  object { Spotlight003 }
  material {
    T_Chrome_1A
  }
  translate  <200.0, 1090.0, -600.0>
}


#declare CSG428 = difference {
  cylinder { // Cylndr828
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
  }
  cylinder { // Cylndr829
    <0,0,1>, <0,0,0>, 1 
    material {
      LitShade
    }
    scale <8.0, 8.0, 10.0>
    translate  -2.0*z
  }
  translate  -10.0*z
}
union { // LittleLightB
  object { CSG428 }
  sphere { // Sphere192
    <0,0,0>,1
    material {
      WhiteBulb
    }
    no_shadow
    scale 2.0
    translate  -7.0*z
  }
  cylinder { // Cylndr830
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 50.0>
  }
  object { Spotlight004 }
  material {
    T_Chrome_1A
  }
  translate  <200.0, 1205.0, -1100.0>
}


#declare CSG429 = union {
  cylinder { // Cylndr845
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 1.5>
    translate  2.5*z
  }
  cylinder { // Cylndr846
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 0.5>
    translate  2.0*z
  }
  box { // Cube1135
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 6.0, 1.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr847
    <0,0,1>, <0,0,0>, 1 
    scale <8.7, 8.7, 0.5>
    translate  -3.0*z
  }
  cylinder { // Cylndr848
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 7.2, 0.5>
    translate  -14.0*z
  }
  cylinder { // Cylndr849
    <0,0,1>, <0,0,0>, 1 
    scale <7.0, 7.0, 9.0>
    translate  -14.5*z
  }
  cylinder { // Cylndr850
    <0,0,1>, <0,0,0>, 1 
    scale <8.5, 8.5, 6.0>
    translate  -4.0*z
  }
  cone { // Cone060
    <0,0,0>, 7.0, <0,0,1>, 8.5
    scale <1.0, 1.0, 2.0>
    translate  -6.0*z
  }
  cylinder { // Cylndr851
    <0,0,1>, <0,0,0>, 1 
    scale <8.7, 8.7, 0.5>
    translate  0.5*z
  }
  cylinder { // Cylndr852
    <0,0,1>, <0,0,0>, 1 
    scale <7.2, 7.2, 0.5>
    translate  -12.0*z
  }
  sphere { // Sphere193
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <-6.0, -5.5, -1.0>
  }
  sphere { // Sphere194
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <6.0, -5.5, -1.0>
  }
  sphere { // Sphere195
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <-4.0, -7.0, -1.0>
  }
  sphere { // Sphere196
    <0,0,0>,1
    material {
      T_Chrome_3A
    }
    translate  <4.0, -7.0, -1.0>
  }
}
#declare CSG430 = difference {
  object { CSG429 }
  box { // Cube1136
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Chrome_2E
    }
    scale <2.5, 1.0, 1.0>
    translate  <0.0, -8.0, -1.0>
  }
  cylinder { // Cylndr853
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 5.5, 9.0>
    translate  -15.0*z
  }
}
#declare Body9 = union {
  object { CSG430 }
  cylinder { // Cylndr854
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 4.0>
    translate  -3.0*z
  }
  box { // Cube1137
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.5>
    translate  <-6.0, 0.0, -13.0>
  }
  box { // Cube1138
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.0, 1.5>
    translate  <6.0, 0.0, -13.0>
  }
  cylinder { // Cylndr855
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <-2.0, -7.5, -1.0>
  }
  cylinder { // Cylndr856
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <-1.0, -7.5, -1.0>
  }
  cylinder { // Cylndr857
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <1.0, -7.5, -1.0>
  }
  cylinder { // Cylndr858
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.3, 0.3, 1.0>
    rotate 90.0*x
    translate  <2.0, -7.5, -1.0>
  }
  cylinder { // Cylndr859
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 23.0>
    rotate 90.0*y
    translate  -11.5*x
  }
  // All transformations fixed
}
#declare TaperSweep016 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 5.0, 15.0>
  rotate -180.0*x
  translate  7.0*z
}
#declare CSG434 = difference {
  object { TaperSweep016 }
  sphere { // Sphere197
    <0,0,0>,1
    scale <1.0, 5.0, 1.5>
    translate  <2.0, 0.0, -6.0>
  }
  box { // Cube1144
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 2.0>
    translate  <-2.5, 0.0, -5.5>
  }
  scale <1.5, 1.0, 1.0>
}
#declare Leg16 = union {
  object { CSG434 }
  box { // Cube1145
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 4.0>
    translate  -1.0*z
  }
  box { // Cube1146
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, 4.0, -7.75>
  }
  box { // Cube1147
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, -4.0, -7.75>
  }
  material {
    White
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-2.5 to   2.5)
  // Trans Z limited (-13.0 to   -11.0)
  translate KongBotBLeftLegPerturbation
  translate  <5.0, 0.0, -13.0>
}
#declare TaperSweep017 = prism {
  conic_sweep
  linear_spline
  0.75,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <2.0, 5.0, 15.0>
  rotate -180.0*x
  translate  7.0*z
}
#declare CSG435 = difference {
  object { TaperSweep017 }
  sphere { // Sphere198
    <0,0,0>,1
    scale <1.0, 5.0, 1.5>
    translate  <2.0, 0.0, -6.0>
  }
  box { // Cube1148
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 6.0, 2.0>
    translate  <-2.5, 0.0, -5.5>
  }
  scale <1.5, 1.0, 1.0>
}
#declare Leg17 = union {
  object { CSG435 }
  box { // Cube1149
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.5, 4.0>
    translate  -1.0*z
  }
  box { // Cube1150
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, 4.0, -7.75>
  }
  box { // Cube1151
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.25>
    translate  <-3.0, -4.0, -7.75>
  }
  material {
    White
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (-2.5 to   2.5)
  // Trans Z limited (-13.0 to   -11.0)
  scale <-1.0, 1.0, 1.0>
  translate KongBotBRightLegPerturbation
  translate  <-5.0, 0.0, -13.0>
}
#declare Head8 = union {
  cylinder { // Cylndr863
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 4.0>
    translate  4.0*z
  }
  box { // Cube1152
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.2, 0.75>
    translate  <0.0, -2.0, 5.0>
  }
  box { // Cube1153
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 1.0>
    rotate -15.0*x
    translate  <0.0, 2.0, 4.0>
  }
  cylinder { // Cylndr864
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    rotate 90.0*y
    translate  <-3.25, 0.0, 5.5>
  }
  cylinder { // Cylndr865
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    rotate 90.0*y
    translate  <2.75, 0.0, 5.5>
  }
  box { // Cube1154
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <-3.0, 0.0, 5.0>
  }
  box { // Cube1155
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.5, 1.0>
    translate  <3.0, 0.0, 5.0>
  }
  sphere { // Sphere199
    <0,0,0>,1
    translate  <3.0, -2.0, 5.0>
  }
  sphere { // Sphere200
    <0,0,0>,1
    translate  <-3.0, -2.0, 5.0>
  }
  sphere { // Sphere201
    <0,0,0>,1
    scale <2.0, 2.0, 0.25>
    translate  8.0*z
  }
  sphere { // Sphere202
    <0,0,0>,1
    material {
      KongDome
    }
    scale 6.0
    translate  4.0*z
  }
  cylinder { // Cylndr866
    <0,0,1>, <0,0,0>, 1 
    scale <5.5, 5.5, 0.5>
    translate  4.0*z
  }
  material {
    T_Chrome_2E
  }
  // All transformations fixed
}
union { // KongBotB
  object { Body9 }
  object { Arm10 }
  object { // Arm11->Arm10
    Arm10
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Leg16 }
  object { Leg17 }
  object { Head8 }
  material {
    Red_6
  }
  scale 5.0
  translate KongBotBPerturbation
  translate  KongBotBLocation
}


#declare Other_Wheels3 = union {
  object { // Wheel57->Wheel56
    Wheel56
    translate  93.0*y
  }
  object { // Wheel58->Wheel56
    Wheel56
    translate  62.0*y
  }
  object { // Wheel59->Wheel56
    Wheel56
    translate  31.0*y
  }
  object { // Wheel60->Wheel56
    Wheel56
    translate  -31.0*y
  }
  object { // Wheel61->Wheel56
    Wheel56
    translate  -62.0*y
  }
  object { // Wheel62->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, 93.0, 0.0>
  }
  object { // Wheel63->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, 62.0, 0.0>
  }
  object { // Wheel64->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, 31.0, 0.0>
  }
  object { // Wheel65->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, -31.0, 0.0>
  }
  object { // Wheel66->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, -0.0, 0.0>
  }
  object { // Wheel67->Wheel56
    Wheel56
    rotate 0.0*z
    translate  <-120.0, -62.0, 0.0>
  }
  // All transformations fixed
}
#declare Wheels7 = union {
  object { Wheel56 }
  object { Other_Wheels3 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare CSG437 = difference {
  cylinder { // Cylndr838
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr839
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1158
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
}
#declare CSG438 = difference {
  cylinder { // Cylndr840
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr841
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1159
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  translate  120.0*x
}
#declare CSG439 = difference {
  cylinder { // Cylndr842
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr843
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1160
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
}
#declare CSG440 = difference {
  cylinder { // Cylndr844
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr867
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1161
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
  translate  -120.0*x
}
#declare Parts29 = union {
  box { // Cube1157
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 80.0, 10.0>
  }
  object { CSG437 }
  object { CSG438 }
  object { CSG439 }
  object { CSG440 }
  box { // Cube1162
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, 11.0>
  }
  box { // Cube1163
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, 11.0>
  }
  box { // Cube1164
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, -21.0>
  }
  box { // Cube1165
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, -21.0>
  }
  cylinder { // Cylndr868
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, -80.0, 0.0>
  }
  cylinder { // Cylndr869
    <0,0,1>, <0,0,0>, 1 
    material {
      TankArmour
    }
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 80.0, 0.0>
  }
  material {
    Black_Rubber
  }
  // All transformations fixed
}
#declare Other_Tracksides3 = union {
  object { // Trackside13->Trackside12
    Trackside12
    translate  120.0*x
  }
  object { // Trackside14->Trackside12
    Trackside12
    rotate <0.0, -180.0, -180.0>
    translate  -10.0*z
  }
  object { // Trackside15->Trackside12
    Trackside12
    rotate <-0.0, -180.0, -180.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Tracksides3 = union {
  object { Trackside12 }
  object { Other_Tracksides3 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Other_Trackends3 = union {
  object { // Trackend13->Trackend12
    Trackend12
    rotate <180.0, 0.0, -0.0>
    translate  -10.0*z
  }
  object { // Trackend14->Trackend12
    Trackend12
    translate  120.0*x
  }
  object { // Trackend15->Trackend12
    Trackend12
    rotate <-180.0, 0.0, -0.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Trackends3 = union {
  object { Trackend12 }
  object { Other_Trackends3 }
  material {
    T_Chrome_3A
  }
  // All transformations fixed
}
#declare Track_Set3 = union {
  object { Wheels7 }
  object { Parts29 }
  object { Tracksides3 }
  object { Trackends3 }
  // All transformations fixed
  translate  22.16*z
}
#declare CSG462 = intersection {
  box { // Cube1183
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 30.0, 50.0>
    rotate 25.0*y
    translate  <0.0, 21.0, 40.0>
  }
  box { // Cube1184
    <-1, -1, -1>, <1, 1, 1>
    scale <55.0, 55.0, 10.0>
    rotate -45.0*z
    translate  <0.0, 21.0, 50.0>
  }
  box { // Cube1185
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 30.01, 50.0>
    rotate -25.0*y
    translate  <0.0, 21.0, 40.0>
  }
}
#declare CSG463 = difference {
  box { // Cube1186
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, -1.0, -1.0>
    scale <47.5, 30.0, 10.0>
    rotate 25.0*x
    translate  <0.0, -9.0, 60.0>
  }
  cylinder { // Cylndr916
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <8.0, 8.0, 50.0>
    rotate 90.0*x
    translate  <-25.0, 0.0, 50.0>
  }
  cylinder { // Cylndr917
    <0,0,1>, <0,0,0>, 1 
    material {
      Black_Rubber
    }
    scale <8.0, 8.0, 50.0>
    rotate 90.0*x
    translate  <25.0, 0.0, 50.0>
  }
}
#declare ArtooHolder1 = union {
  box { // Cube1188
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 4.25, 15.0>
    translate  5.0*x
  }
  box { // Cube1189
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 4.25, 15.0>
    translate  -5.0*x
  }
  cylinder { // Cylndr918
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 30.0>
    translate  -15.0*z
  }
  material {
    T_Chrome_3A
  }
  scale 1.5
  translate  <0.0, 70.0, 45.0>
}
#declare CSG464 = difference {
  box { // Cube1187
    <-1, -1, -1>, <1, 1, 1>
    scale <35.0, 20.0, 10.0>
    translate  <0.0, 70.0, 41.0>
  }
  object { ArtooHolder1 }
}
#declare CSG465 = union {
  box { // Cube1192
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <15.0, 5.0, 10.0>
    rotate 60.0*x
    translate  <0.0, -73.0, 47.0>
  }
  box { // Cube1193
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 5.0, 5.0>
    translate  <0.0, -78.0, 42.0>
  }
}
#declare CSG466 = difference {
  object { CSG465 }
  box { // Cube1194
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    scale <14.0, 4.0, 10.0>
    rotate 60.0*x
    translate  <0.0, -74.0, 46.0>
  }
  box { // Cube1195
    <-1, -1, -1>, <1, 1, 1>
    scale <14.0, 5.0, 4.0>
    translate  <0.0, -79.0, 42.0>
  }
}
#declare CSG467 = intersection {
  box { // Cube1196
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus096
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -72.0, 34.0>
}
#declare CSG468 = intersection {
  box { // Cube1197
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus097
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -80.0, 34.0>
}
#declare CSG469 = intersection {
  box { // Cube1198
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    translate  <5.0, 5.0, 0.0>
  }
  torus { // Torus098
    1.5, 0.25  rotate -x*90
    scale 5.0
  }
  material {
    Black_Rubber
  }
  rotate <90.0, 0.0, -180.0>
  translate  <-14.0, -76.0, 34.0>
}
#declare Body10 = union {
  box { // Cube1182
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 85.0, 5.0>
    translate  33.0*z
  }
  object { CSG462 }
  object { CSG463 }
  object { CSG464 }
  box { // Cube1190
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 6.0>
    rotate 25.0*y
    translate  <-60.0, 24.0, 53.0>
  }
  box { // Cube1191
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 6.0>
    rotate -25.0*y
    translate  <60.0, 24.0, 53.0>
  }
  object { CSG466 }
  object { CSG467 }
  object { CSG468 }
  object { CSG469 }
  box { // Cube1199
    <-1, -1, -1>, <1, 1, 1>
    material {
      Translucent
    }
    scale <14.1, 3.1, 4.1>
    translate  <0.0, -79.0, 42.0>
  }
  // All transformations fixed
}
#declare CSG470 = intersection {
  torus { // Torus099
    30.0, 4.0  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube1200
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 20.0, 10.0>
    translate  <0.0, -20.0, -17.0>
  }
  translate  <0.0, 20.0, 20.0>
}
#declare CSG471 = intersection {
  torus { // Torus100
    30.0, 2.0  rotate -x*90
    rotate -90.0*y
  }
  box { // Cube1202
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 20.0, 15.0>
    translate  <0.0, -20.0, -15.0>
  }
  material {
    T_Chrome_3A
  }
}
#declare Movable1 = union {
  box { // Cube1201
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 30.0, 1.0>
    translate  <0.0, -10.0, 2.0>
  }
  object { CSG471 }
  box { // Cube1203
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 1.0>
    rotate 75.0*y
    translate  <-41.0, -10.0, 11.0>
  }
  box { // Cube1204
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 30.0, 1.0>
    rotate -75.0*y
    translate  <41.0, -10.0, 11.0>
  }
  object { Group049 }
  object { // Group050->Group049
    Group049
    translate  15.0*x
  }
  object { // Group051->Group049
    Group049
    translate  45.0*x
  }
  object { // Group052->Group049
    Group049
    translate  60.0*x
  }
  box { // Cube1208
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 12.0, 2.0>
    translate  <0.0, 20.0, 1.0>
  }
  cylinder { // Cylndr923
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 20.0>
    rotate -15.0*y
    translate  <-43.0, 0.0, 18.0>
  }
  sphere { // Sphere211
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    translate  <-48.0, 0.0, 37.0>
  }
  sphere { // Sphere212
    <0,0,0>,1
    material {
      T_Chrome_2E
    }
    translate  <48.0, 0.0, 37.0>
  }
  cylinder { // Cylndr924
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_2E
    }
    scale <0.5, 0.5, 20.0>
    rotate 15.0*y
    translate  <43.0, 0.0, 18.0>
  }
  object { Missile5 }
  object { // Missile6->Missile5
    Missile5
    translate  <-15.0, 0.0, 0.0>
  }
  object { // Missile7->Missile5
    Missile5
    translate  <-45.0, 0.0, 0.0>
  }
  object { // Missile8->Missile5
    Missile5
    translate  <-60.0, 0.0, 0.0>
  }
  // Scaling fixed
  // Rot X limited (-30.0 to   0.0)
  // Translation fixed
  rotate TankBTrayRotation
  translate  <0.0, 20.0, 20.0>
}
#declare MissileTurret1 = union {
  object { CSG470 }
  object { Movable1 }
  box { // Cube1224
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 22.0, 1.0>
    translate  2.0*z
  }
  cylinder { // Cylndr931
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <20.0, 20.0, 6.0>
    translate  -4.0*z
  }
  object { Stand2 }
  object { // Stand3->Stand2
    Stand2
    scale -1.0
    rotate -180.0*x
  }
  // Scaling fixed
  // Translation fixed
  rotate TankBTurretRotation
  translate  <0.0, 20.0, 63.0>
}
union { // TankB
  object { Track_Set3 }
  object { MudGuard2 }
  object { // MudGuard3->MudGuard2
    MudGuard2
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Gun2 }
  object { // Gun3->Gun2
    Gun2
    // All transformations fixed
    scale -1.0
    rotate <0.0, -180.0, -180.0>
  }
  object { Body10 }
  object { MissileTurret1 }
  material {
    TankArmour
  }
  scale 2.25
  rotate -180.0*z
  translate  TankBLocation
}


#declare Other_Wheels4 = union {
  object { // Wheel69->Wheel68
    Wheel68
    translate  93.0*y
  }
  object { // Wheel70->Wheel68
    Wheel68
    translate  62.0*y
  }
  object { // Wheel71->Wheel68
    Wheel68
    translate  31.0*y
  }
  object { // Wheel72->Wheel68
    Wheel68
    translate  -31.0*y
  }
  object { // Wheel73->Wheel68
    Wheel68
    translate  -62.0*y
  }
  object { // Wheel74->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, 93.0, 0.0>
  }
  object { // Wheel75->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, 62.0, 0.0>
  }
  object { // Wheel76->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, 31.0, 0.0>
  }
  object { // Wheel77->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, -31.0, 0.0>
  }
  object { // Wheel78->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, -0.0, 0.0>
  }
  object { // Wheel79->Wheel68
    Wheel68
    rotate 0.0*z
    translate  <-120.0, -62.0, 0.0>
  }
  // All transformations fixed
}
#declare Wheels8 = union {
  object { Wheel68 }
  object { Other_Wheels4 }
  // All transformations fixed
}
#declare CSG478 = difference {
  cylinder { // Cylndr943
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr944
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1231
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
}
#declare CSG479 = difference {
  cylinder { // Cylndr945
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr946
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1232
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  translate  120.0*x
}
#declare CSG480 = difference {
  cylinder { // Cylndr947
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr948
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1233
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
}
#declare CSG481 = difference {
  cylinder { // Cylndr949
    <0,0,1>, <0,0,0>, 1 
    scale <16.25, 16.25, 32.0>
    rotate -90.0*y
    translate  <-44.0, -77.5, -5.0>
  }
  cylinder { // Cylndr950
    <0,0,1>, <0,0,0>, 1 
    scale <15.75, 15.75, 34.0>
    rotate -90.0*y
    translate  <-43.0, -77.5, -5.0>
  }
  box { // Cube1234
    <-1, -1, -1>, <1, 1, 1>
    scale 20.0
    translate  <-60.0, -57.5, -5.0>
  }
  rotate -180.0*z
  translate  -120.0*x
}
#declare Parts30 = union {
  box { // Cube1230
    <-1, -1, -1>, <1, 1, 1>
    scale <40.0, 80.0, 10.0>
  }
  object { CSG478 }
  object { CSG479 }
  object { CSG480 }
  object { CSG481 }
  box { // Cube1235
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, 11.0>
  }
  box { // Cube1236
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, 11.0>
  }
  box { // Cube1237
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <60.0, 0.0, -21.0>
  }
  box { // Cube1238
    <-1, -1, -1>, <1, 1, 1>
    scale <16.0, 77.5, 0.25>
    translate  <-60.0, 0.0, -21.0>
  }
  cylinder { // Cylndr951
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, -80.0, 0.0>
  }
  cylinder { // Cylndr952
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 80.0>
    rotate -90.0*y
    translate  <40.0, 80.0, 0.0>
  }
  // All transformations fixed
}
#declare Other_Tracksides4 = union {
  object { // Trackside17->Trackside16
    Trackside16
    translate  120.0*x
  }
  object { // Trackside18->Trackside16
    Trackside16
    rotate <0.0, -180.0, -180.0>
    translate  -10.0*z
  }
  object { // Trackside19->Trackside16
    Trackside16
    rotate <-0.0, -180.0, -180.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Tracksides4 = union {
  object { Trackside16 }
  object { Other_Tracksides4 }
  // All transformations fixed
}
#declare Other_Trackends4 = union {
  object { // Trackend17->Trackend16
    Trackend16
    rotate <180.0, 0.0, -0.0>
    translate  -10.0*z
  }
  object { // Trackend18->Trackend16
    Trackend16
    translate  120.0*x
  }
  object { // Trackend19->Trackend16
    Trackend16
    rotate <-180.0, 0.0, -0.0>
    translate  <120.0, 0.0, -10.0>
  }
  // All transformations fixed
}
#declare Trackends4 = union {
  object { Trackend16 }
  object { Other_Trackends4 }
  // All transformations fixed
}
#declare Track_Set4 = union {
  object { Wheels8 }
  object { Parts30 }
  object { Tracksides4 }
  object { Trackends4 }
  material {
    White
  }
  translate  22.0*z
}
#declare Wrist2 = union {
  cylinder { // Cylndr959
    <0,0,1>, <0,0,0>, 1 
    scale 10.0
    rotate -90.0*x
  }
  object { Claw10 }
  object { // Claw11->Claw10
    Claw10
    rotate <0.0, -120.0, -0.0>
  }
  object { // Claw12->Claw10
    Claw10
    rotate <0.0, 120.0, -0.0>
  }
  // Scaling fixed
  // Translation fixed
  rotate 47.5*y
  translate  -39.0*y
}
#declare Elbow2 = union {
  cylinder { // Cylndr957
    <0,0,1>, <0,0,0>, 1 
    scale <8.0, 8.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr958
    <0,0,1>, <0,0,0>, 1 
    scale <5.0, 5.0, 25.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { Wrist2 }
  // Scaling fixed
  // Rot X limited (-5.0 to   95.0)
  // Translation fixed
  rotate TransporterCElbowRotation
  translate  -60.0*y
}
#declare CSG482 = difference {
  cylinder { // Cylndr962
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 20.0>
    rotate <-0.0, -90.0, 0.0>
    translate  10.0*x
  }
  cylinder { // Cylndr963
    <0,0,1>, <0,0,0>, 1 
    scale <9.0, 9.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube1245
    <-1, -1, -1>, <1, 1, 1>
    scale <6.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  rotate 90.0*x
  translate  -60.0*y
}
#declare Hinge2 = union {
  cylinder { // Cylndr956
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  object { Elbow2 }
  cylinder { // Cylndr961
    <0,0,1>, <0,0,0>, 1 
    scale <7.5, 7.5, 47.0>
    rotate 90.0*x
    translate  -5.0*y
  }
  object { CSG482 }
  // Scaling fixed
  // Rot X limited (-90.0 to   0.0)
  // Translation fixed
  rotate TransporterCHingeRotation
  translate  50.0*z
}
#declare CSG483 = difference {
  cylinder { // Cylndr964
    <0,0,1>, <0,0,0>, 1 
    scale <14.0, 14.0, 30.0>
    rotate <-0.0, -90.0, 0.0>
    translate  15.0*x
  }
  cylinder { // Cylndr965
    <0,0,1>, <0,0,0>, 1 
    scale <11.0, 11.0, 40.0>
    rotate <-0.0, -90.0, 0.0>
    translate  20.0*x
  }
  box { // Cube1246
    <-1, -1, -1>, <1, 1, 1>
    scale <9.0, 15.0, 15.0>
    translate  <0.0, -7.0, 7.0>
  }
  translate  50.0*z
}
#declare Post2 = union {
  cylinder { // Cylndr955
    <0,0,1>, <0,0,0>, 1 
    scale <10.0, 10.0, 61.0>
    translate  -20.0*z
  }
  object { Hinge2 }
  object { CSG483 }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (24.0 to   59.0)
  translate  59.0*z
}
#declare Arm12 = union {
  cylinder { // Cylndr953
    <0,0,1>, <0,0,0>, 1 
    scale 25.0
  }
  cylinder { // Cylndr954
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 40.0>
  }
  object { Post2 }
  material {
    White
  }
  // Scaling fixed
  // Translation fixed
  rotate TransporterCArmRotation
  translate  <0.0, -30.0, 22.0>
}
#declare Basket2 = union {
  box { // Cube1247
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 10.0, 34.0>
  }
  box { // Cube1248
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 10.0, 34.0>
  }
  box { // Cube1249
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <30.0, 70.0, 34.0>
  }
  box { // Cube1250
    <-1, -1, -1>, <1, 1, 1>
    scale 3.0
    translate  <-30.0, 70.0, 34.0>
  }
  box { // Cube1251
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 10.0, 40.0>
  }
  box { // Cube1252
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 70.0, 40.0>
  }
  box { // Cube1253
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, 90.0, 70.0>
  }
  box { // Cube1254
    <-1, -1, -1>, <1, 1, 1>
    scale <60.0, 3.0, 3.0>
    translate  <0.0, -10.0, 70.0>
  }
  box { // Cube1255
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <30.0, 40.0, 40.0>
  }
  box { // Cube1256
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <-57.0, 40.0, 70.0>
  }
  box { // Cube1257
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 53.0, 3.0>
    translate  <57.0, 40.0, 70.0>
  }
  box { // Cube1258
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 33.0, 3.0>
    translate  <-30.0, 40.0, 40.0>
  }
  box { // Cube1259
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 70.0, 55.0>
  }
  box { // Cube1260
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 70.0, 55.0>
  }
  box { // Cube1261
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <-57.0, 10.0, 55.0>
  }
  box { // Cube1262
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 3.0, 18.0>
    translate  <57.0, 10.0, 55.0>
  }
  material {
    T_Chrome_2E
  }
}
union { // TransporterC
  object { Track_Set4 }
  object { Arm12 }
  object { Basket2 }
  cylinder { // Cylndr966
    <0,0,1>, <0,0,0>, 1 
    scale <35.0, 35.0, 20.0>
    translate  <0.0, -30.0, 22.0>
  }
  material {
    BLUE_METAL
  }
  translate  <237.5, 980.0, -1600.0>
}


#declare TransSweep098 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.5, 6.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 5.0>
}
#declare Top1 = difference {
  sphere { // Sphere217
    <0,0,0>,1
    scale 24.0
  }
  box { // Cube1263
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 6.0>
    translate  22.0*z
  }
  box { // Cube1264
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 18.0>
    translate  -10.0*z
  }
  object { TransSweep098 }
  material {
    VINcentBodyTop
    scale <23.0, 23.0, 8.0>
    rotate 90.0*z
    translate <0.000000, 0.000000, 8.000000>
  }
}
#declare CSG484 = union {
  cone { // Cone064
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 30.0>
    rotate <90.0, 0.0, -15.0>
    translate  <-18.0, 34.0, -1.0>
  }
  cone { // Cone065
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 30.0>
    rotate <90.0, 0.0, 15.0>
    translate  <18.0, 34.0, -1.0>
  }
}
#declare CSG485 = union {
  sphere { // Sphere218
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  cone { // Cone066
    <0,0,0>, 13.0, <0,0,1>, 21.82
    scale <1.0, 1.0, 20.0>
    rotate 90.0*x
    translate  <0.0, 30.0, -1.0>
  }
}
#declare ForeArms1 = intersection {
  box { // Cube1265
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 10.0, 6.0>
    translate  <0.0, 14.0, -1.9>
  }
  object { CSG484 }
  object { CSG485 }
  box { // Cube1266
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, 1.0, 1.0>
    scale <24.0, 14.0, 10.0>
    rotate 5.0*x
    translate  <0.0, 6.8, -7.9>
  }
  box { // Cube1267
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*x
    translate  <0.0, 1.0, -1.0>
    scale <24.0, 14.0, 10.0>
    rotate -5.0*x
    translate  <0.0, 6.8, 4.1>
  }
}
#declare TransSweep099 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.8, -1.0>,
  <-0.8, -1.4>,
  <0.8, -1.4>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <8.5, 8.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare Shoulders1 = intersection {
  sphere { // Sphere219
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  object { TransSweep099 }
  box { // Cube1268
    <-1, -1, -1>, <1, 1, 1>
    scale <24.0, 24.0, 18.0>
    translate  -11.5*z
  }
  material {
    VINcentArm
    scale <4.0, 6.0, 10.0>
    rotate -90.0*y
    translate <0.000000, -3.000000, -7.000000>
  }
}
#declare CSG486 = union {
  object { ForeArms1 }
  object { Shoulders1 }
}
#declare TransSweep100 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.5, 6.5, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare Arms1 = difference {
  object { CSG486 }
  object { TransSweep100 }
  box { // Cube1269
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 30.0, 3.0>
    translate  <13.125, 0.0, -1.5>
  }
  box { // Cube1270
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 30.0, 3.0>
    translate  <9.0, 0.0, -1.5>
  }
  box { // Cube1271
    <-1, -1, -1>, <1, 1, 1>
    scale <1.25, 30.0, 3.0>
    translate  <-13.125, 0.0, -1.5>
  }
  box { // Cube1272
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 30.0, 3.0>
    translate  <-9.0, 0.0, -1.5>
  }
  translate  1.0*z
}
#declare Rear1 = intersection {
  sphere { // Sphere220
    <0,0,0>,1
    scale 24.0
  }
  box { // Cube1273
    <-1, -1, -1>, <1, 1, 1>
    scale <12.0, 12.0, 10.0>
    translate  <0.0, -12.0, -4.5>
  }
  material {
    VINcentRear
    scale <24.0, 20.0, 20.0>
    rotate 90.0*x
    translate <-12.000000, 0.000000, -14.500000>
  }
}
#declare CSG487 = intersection {
  sphere { // Sphere221
    <0,0,0>,1
    scale 20.0
    translate  1.0*y
  }
  box { // Cube1274
    <-1, -1, -1>, <1, 1, 1>
    scale 5.0
    rotate -90.0*x
    translate  <0.0, 20.0, -1.0>
  }
  material {
    VINcentSpeaker
    scale 10.0
    rotate <90.0, 0.0, -180.0>
    translate <5.000000, 0.000000, -6.000000>
  }
}
#declare TransSweep101 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-0.6, -1.0>
  rotate -x*90
  scale <5.0, 1.5, 10.0>
  rotate 90.0*x
  translate  <0.0, 25.0, -9.0>
}
#declare CSG488 = intersection {
  sphere { // Sphere222
    <0,0,0>,1
    scale 20.0
    translate  1.0*y
  }
  object { TransSweep101 }
  material {
    VINcentLower
    scale <10.0, 3.0, 10.0>
    rotate <90.0, 0.0, -180.0>
    translate <5.000000, 0.000000, -10.500000>
  }
}
#declare TransSweep102 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.2, 0.7>,
  <1.2, 1.0>,
  <-1.2, 1.0>,
  <-1.2, 0.7>,
  <-0.8, -1.0>
  rotate -x*90
  scale <6.0, 6.0, 48.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-24.0, 0.0, 4.0>
}
#declare InnerClawHolder1 = intersection {
  sphere { // Sphere223
    <0,0,0>,1
    scale 24.0
    translate  -1.0*z
  }
  object { TransSweep102 }
}
#declare TransSweep103 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.1, 0.1>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.1, 0.1>,
  <-0.6, -1.0>
  rotate -x*90
  scale <4.5, 4.5, 50.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-25.0, 0.0, 4.5>
}
#declare TransSweep104 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-0.6, -1.0>,
  <0.6, -1.0>,
  <1.1, 0.1>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.1, 0.1>,
  <-0.6, -1.0>
  rotate -x*90
  scale <4.0, 4.0, 50.0>
  rotate <-90.0, -180.0, -90.0>
  translate  <-25.0, 0.0, 4.5>
}
#declare CSG489 = difference {
  object { TransSweep103 }
  object { TransSweep104 }
}
#declare SideDoors1 = difference {
  object { InnerClawHolder1 }
  cylinder { // Cylndr967
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 50.0>
    rotate 90.0*y
    translate  <-25.0, 0.0, 6.0>
  }
  box { // Cube1275
    <-1, -1, -1>, <1, 1, 1>
    scale <25.0, 0.666667, 3.0>
    translate  3.0*z
  }
  object { CSG489 }
  box { // Cube1276
    <-1, -1, -1>, <1, 1, 1>
    scale <25.0, 0.25, 1.5>
    translate  7.5*z
  }
  translate  1.0*z
}
#declare CSG490 = union {
  cylinder { // Cylndr968
    <0,0,1>, <0,0,0>, 1 
    scale 8.0
  }
  torus { // Torus102
    7.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  8.0*z
  }
}
#declare CSG491 = difference {
  object { CSG490 }
  cylinder { // Cylndr969
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 10.0>
  }
}
#declare Leg18 = union {
  object { CSG491 }
  translate  16.0*z
  material {
    VINcentLeg
    scale <8.0, 8.0, 8.5>
    rotate -135.0*z
    translate <0.000000, 0.000000, 16.000000>
  }
  rotate <-0.0, -220.0, -0.0>
}
#declare CSG492 = union {
  cylinder { // Cylndr970
    <0,0,1>, <0,0,0>, 1 
    scale 8.0
  }
  torus { // Torus103
    7.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 0.5>
    translate  8.0*z
  }
}
#declare CSG493 = difference {
  object { CSG492 }
  cylinder { // Cylndr971
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 10.0>
  }
}
#declare Leg19 = union {
  object { CSG493 }
  translate  16.0*z
  material {
    VINcentLeg
    scale <8.0, 8.0, 8.5>
    rotate 45.0*z
    translate <0.000000, 0.000000, 16.000000>
  }
  rotate <-0.0, -140.0, -0.0>
}
#declare BodyParts1 = union {
  sphere { // Sphere216
    <0,0,0>,1
    material {
      Black
    }
    scale 20.0
  }
  object { Top1 }
  object { Arms1 }
  object { Rear1 }
  object { CSG487 }
  object { CSG488 }
  object { SideDoors1 }
  object { Leg18 }
  object { Leg19 }
  // All transformations fixed
}
#declare TaperSweep018 = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Light_Orange
  }
  scale <2.0, 3.0, 50.0>
  rotate 90.0*x
  translate  <-9.0, 64.0, -0.5>
}
#declare CSG494 = union {
  box { // Cube1278
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.25, 3.15>
    translate  <-9.0, 24.5, -0.5>
  }
  box { // Cube1279
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <-9.0, 24.5, -2.5>
  }
  box { // Cube1280
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <-9.0, 24.5, 1.5>
  }
}
#declare CSG495 = intersection {
  box { // Cube1277
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate <45.0, 90.0, 0.0>
    translate  <-9.0, 24.5, -0.5>
  }
  object { CSG494 }
  box { // Cube1281
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate 90.0*y
    translate  <-9.0, 26.25, -0.5>
  }
}
#declare LeftPhaser1 = union {
  object { TaperSweep018 }
  object { CSG495 }
  cylinder { // Cylndr972
    <0,0,1>, <0,0,0>, 1 
    material {
      Orange
    }
    rotate <-90.0, 0.0, -0.0>
    translate  <-9.0, 24.5, -0.5>
  }
  material {
    Red_7
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (0.0 to   8.5)
}
#declare TaperSweep019 = prism {
  conic_sweep
  linear_spline
  0.8,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  material {
    Light_Orange
  }
  scale <2.0, 3.0, 50.0>
  rotate 90.0*x
  translate  <9.0, 64.0, -0.5>
}
#declare CSG496 = union {
  box { // Cube1283
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 0.25, 3.15>
    translate  <9.0, 24.5, -0.5>
  }
  box { // Cube1284
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <9.0, 24.5, -2.5>
  }
  box { // Cube1285
    <-1, -1, -1>, <1, 1, 1>
    scale <2.2, 1.0, 1.0>
    rotate <45.0, -0.0, -0.0>
    translate  <9.0, 24.5, 1.5>
  }
}
#declare CSG497 = intersection {
  box { // Cube1282
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate <45.0, 90.0, 0.0>
    translate  <9.0, 24.5, -0.5>
  }
  object { CSG496 }
  box { // Cube1286
    <-1, -1, -1>, <1, 1, 1>
    scale <3.3, 2.0, 2.0>
    rotate 90.0*y
    translate  <9.0, 26.25, -0.5>
  }
}
#declare RightPhaser1 = union {
  object { TaperSweep019 }
  object { CSG497 }
  cylinder { // Cylndr973
    <0,0,1>, <0,0,0>, 1 
    material {
      Orange
    }
    rotate <-90.0, 0.0, -0.0>
    translate  <9.0, 24.5, -0.5>
  }
  material {
    Red_7
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Y limited (0.0 to   8.5)
}
#declare TransSweep105 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-1.0, 0.3>,
  <-1.0, -0.3>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.3>,
  <0.6, -0.3>,
  <0.4, -0.6>,
  <-0.3, -0.6>,
  <-0.7, 0.0>,
  <-0.3, 0.6>,
  <0.4, 0.6>,
  <0.6, 0.3>,
  <0.6, 0.3>,
  <1.0, 0.3>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.3>
  rotate -x*90
  scale <2.5, 2.5, 2.0>
  rotate <-270.0, -180.0, 270.0>
  translate  <1.0, 12.5, 0.0>
}
#declare LeftClaw1 = union {
  cylinder { // Cylndr974
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  cylinder { // Cylndr975
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*x
  }
  object { TransSweep105 }
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Trans Y limited (9.0 to   21.5)
  translate  VINcentBLeftClawLocation
}
#declare TransSweep106 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  17  // control points
  <-1.0, 0.3>,
  <-1.0, -0.3>,
  <-0.5, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.3>,
  <0.6, -0.3>,
  <0.4, -0.6>,
  <-0.3, -0.6>,
  <-0.7, 0.0>,
  <-0.3, 0.6>,
  <0.4, 0.6>,
  <0.6, 0.3>,
  <0.6, 0.3>,
  <1.0, 0.3>,
  <0.5, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.3>
  rotate -x*90
  scale <2.5, 2.5, 2.0>
  rotate <-270.0, -180.0, 270.0>
  translate  <1.0, 12.5, 0.0>
}
#declare RightClaw1 = union {
  cylinder { // Cylndr976
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
  }
  cylinder { // Cylndr977
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 10.0>
    rotate -90.0*x
  }
  object { TransSweep106 }
  material {
    T_Chrome_2E
  }
  // Scaling fixed
  // Trans Y limited (9.0 to   21.5)
  translate  <13.0, 21.5, -0.5>
}
#declare LeftFoot1 = union {
  sphere { // Sphere224
    <0,0,0>,1
    scale 6.0
    translate  6.0*z
  }
  cylinder { // Cylndr978
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 16.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr979
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 12.0>
    translate  -22.0*z
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 16.0>
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-24.0 to   0.0)
  rotate <-180.0, 0.0, -180.0>
}
#declare LeftLeg1 = union {
  object { LeftFoot1 }
  material {
    Black
  }
  // All transformations fixed
  rotate 40.0*y
}
#declare RightFoot1 = union {
  sphere { // Sphere225
    <0,0,0>,1
    scale 6.0
    translate  6.0*z
  }
  cylinder { // Cylndr980
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 16.0>
    translate  -15.0*z
  }
  cylinder { // Cylndr981
    <0,0,1>, <0,0,0>, 1 
    scale <2.5, 2.5, 12.0>
    translate  -22.0*z
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (0.0 to   24.0)
}
#declare RightLeg1 = union {
  object { RightFoot1 }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 16.0>
  material {
    Black
  }
  // All transformations fixed
  rotate <-180.0, 40.0, -180.0>
}
#declare CSG498 = difference {
  torus { // Torus104
    12.0, 1.0  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  20.0*z
  }
  box { // Cube1287
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 2.5>
    translate  <-3.5, 11.0, 20.0>
  }
  box { // Cube1288
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 3.0, 1.5>
    translate  <-3.5, 11.0, 20.0>
  }
  cylinder { // Cylndr983
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-2.0, 8.0, 18.5>
  }
  cylinder { // Cylndr984
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-5.0, 8.0, 18.5>
  }
  cylinder { // Cylndr985
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-5.0, 8.0, 21.5>
  }
  cylinder { // Cylndr986
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <-2.0, 8.0, 21.5>
  }
  box { // Cube1289
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 3.0, 2.5>
    translate  <3.5, 11.0, 20.0>
  }
  box { // Cube1290
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 3.0, 1.5>
    translate  <3.5, 11.0, 20.0>
  }
  cylinder { // Cylndr987
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <2.0, 8.0, 18.5>
  }
  cylinder { // Cylndr988
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <5.0, 8.0, 18.5>
  }
  cylinder { // Cylndr989
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <5.0, 8.0, 21.5>
  }
  cylinder { // Cylndr990
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 6.0>
    rotate -90.0*x
    translate  <2.0, 8.0, 21.5>
  }
}
#declare TransSweep107 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <2.25, 2.25, 4.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-9.0, 0.0, 20.0>
}
#declare TransSweep108 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  material {
    Black_Rubber
  }
  scale <2.25, 2.25, 4.0>
  rotate <90.0, 0.0, 90.0>
  translate  <9.0, 0.0, 20.0>
}
#declare CSG499 = union {
  cylinder { // Cylndr982
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <12.0, 12.0, 8.0>
    translate  16.0*z
  }
  object { CSG498 }
  cylinder { // Cylndr991
    <0,0,1>, <0,0,0>, 1 
    rotate 0.0*x
    translate  <0.0, -0.0, 1.083333>
    material {
      Black
    }
    scale <1.0, 1.0, 6.0>
    rotate <-90.0, 0.0, -17.0>
    translate  20.0*z
  }
  cylinder { // Cylndr992
    <0,0,1>, <0,0,0>, 1 
    rotate 0.0*x
    translate  <0.0, -0.0, 1.083333>
    material {
      Black
    }
    scale <1.0, 1.0, 6.0>
    rotate <-90.0, 0.0, 17.0>
    translate  20.0*z
  }
  object { TransSweep107 }
  object { TransSweep108 }
  material {
    Red_7
  }
}
#declare TransSweep109 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  scale <1.75, 1.75, 4.0>
  rotate <90.0, 0.0, 90.0>
  translate  <10.0, 0.0, 20.0>
}
#declare TransSweep110 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <-1.0, -0.3>,
  <0.0, -1.0>,
  <1.0, -0.3>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -0.3>
  rotate -x*90
  scale <1.75, 1.75, 4.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-10.0, 0.0, 20.0>
}
#declare CSG500 = difference {
  object { CSG499 }
  object { TransSweep109 }
  object { TransSweep110 }
  material {
    Black_Rubber
  }
}
#declare Face1 = union {
  object { CSG500 }
  // All transformations fixed
}
#declare CSG501 = union {
  cylinder { // Cylndr993
    <0,0,1>, <0,0,0>, 1 
    scale <16.0, 16.0, 4.0>
    translate  23.5*z
  }
  torus { // Torus105
    1.5, 0.5  rotate -x*90
    scale 8.0
    translate  27.5*z
  }
  cylinder { // Cylndr994
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 7.0>
    translate  24.0*z
  }
  material {
    VINcentHat
    scale <16.0, 16.0, 8.0>
    rotate 90.0*z
    translate <0.000000, 0.000000, 23.500000>
  }
}
#declare CSG502 = difference {
  object { CSG501 }
  cylinder { // Cylndr995
    <0,0,1>, <0,0,0>, 1 
    scale <12.0, 12.0, 1.0>
    translate  30.5*z
  }
  box { // Cube1291
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <0.0, 16.5, 26.0>
  }
  box { // Cube1292
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <0.0, -16.5, 26.0>
  }
  box { // Cube1293
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <16.5, 0.0, 26.0>
  }
  box { // Cube1294
    <-1, -1, -1>, <1, 1, 1>
    scale 1.5
    translate  <-16.5, 0.0, 26.0>
  }
  cylinder { // Cylndr996
    <0,0,1>, <0,0,0>, 1 
    scale <14.0, 14.0, 5.0>
    translate  23.0*z
  }
}
#declare Hat1 = union {
  object { CSG502 }
  sphere { // Sphere226
    <0,0,0>,1
    scale <2.5, 2.5, 0.5>
    translate  31.0*z
  }
  material {
    Red_7
  }
  // Scaling fixed
  // Rotation fixed
  // Trans Z limited (-0.5 to   0.0)
}
#declare Head9 = union {
  object { Face1 }
  object { Hat1 }
  // Scaling fixed
  // Trans Z limited (-6.5 to   0.0)
  rotate VINcentBHeadRotation
}
#declare Body11 = union {
  object { BodyParts1 }
  object { LeftPhaser1 }
  object { RightPhaser1 }
  object { LeftClaw1 }
  object { RightClaw1 }
  object { LeftLeg1 }
  object { RightLeg1 }
  object { Head9 }
  // All transformations fixed
}
union { // VINcentB
  object { Body11 }
  material {
    White
  }
  scale 1.5
  rotate 135.0*z
  translate  VINcentBLocation
}


#declare CSG503 = difference {
  cylinder { // Cylndr999
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 2.0>
    translate  -38.0*z
  }
  cylinder { // Cylndr1000
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <2.5, 2.5, 3.0>
    translate  -39.0*z
  }
  material {
    T_Chrome_3A
  }
}
#declare Fuselage4 = union {
  cylinder { // Cylndr997
    <0,0,1>, <0,0,0>, 1 
    material {
      JetBlack
    }
    scale <4.0, 4.0, 30.0>
    translate  -36.0*z
  }
  sphere { // Sphere227
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 15.0>
    translate  25.0*z
  }
  cylinder { // Cylndr998
    <0,0,1>, <0,0,0>, 1 
    material {
      ForeSection
    }
    scale <5.0, 5.0, 25.0>
  }
  sphere { // Sphere228
    <0,0,0>,1
    material {
      NoseCone
    }
    scale <5.0, 5.0, 40.0>
  }
  sphere { // Sphere229
    <0,0,0>,1
    material {
      JetBlack
    }
    scale 2.0
    translate  38.5*z
  }
  object { CSG503 }
  object { Cube1295 }
  object { // Cube1296->Cube1295
    Cube1295
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube1297->Cube1295
    Cube1295
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube1298->Cube1295
    Cube1295
    rotate <0.0, 0.0, 90.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1299->Cube1295
    Cube1295
    rotate 0.0*x
    translate  <0.0, -0.0, -16.0>
  }
  object { // Cube1300->Cube1295
    Cube1295
    rotate <0.0, 0.0, -90.0>
    translate  <-0.0, 0.0, -16.0>
  }
  object { // Cube1301->Cube1295
    Cube1295
    rotate <0.0, 0.0, -180.0>
    translate  <0.0, 0.0, -16.0>
  }
  object { // Cube1302->Cube1295
    Cube1295
    rotate <0.0, 0.0, -270.0>
    translate  <0.0, -0.0, -16.0>
  }
  material {
    White
  }
  // All transformations fixed
}
#declare Cable1 = union {
  torus { // Torus106
    4.0, 0.5  rotate -x*90
    scale <1.0, 2.5, 1.0>
    rotate <-270.0, -100.0, 270.0>
    translate  <0.0, -74.0, 10.6>
  }
  cylinder { // Cylndr1003
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 65.0>
    rotate <106.0, -0.0, -0.0>
    translate  <0.0, -1.0, 27.0>
  }
  cylinder { // Cylndr1004
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 66.0>
    rotate 71.0*x
    translate  <0.0, -1.0, -13.0>
  }
  material {
    T_Chrome_3A
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   15.0)
  // Translation fixed
  rotate MissileCCableRotation
}
union { // Missile4C
  object { Fuselage4 }
  object { RearFin16 }
  object { FrontFin16 }
  object { // FrontFin17->FrontFin16
    FrontFin16
    // All transformations fixed
    rotate -90.0*z
  }
  object { // FrontFin18->FrontFin16
    FrontFin16
    // All transformations fixed
    rotate 180.0*z
  }
  object { // FrontFin19->FrontFin16
    FrontFin16
    // All transformations fixed
    rotate 90.0*z
  }
  object { // RearFin17->RearFin16
    RearFin16
    // All transformations fixed
    rotate -90.0*z
  }
  object { // RearFin18->RearFin16
    RearFin16
    // All transformations fixed
    rotate 180.0*z
  }
  object { // RearFin19->RearFin16
    RearFin16
    // All transformations fixed
    rotate 90.0*z
  }
  object { Cable1 }
  scale <1.575, 1.575, 2.25>
  rotate -75.0*x
  translate  MissileCLocation
}                            

/////////////////////////////////////////////// Below here was added manually

#declare CSG505 = difference {
  cylinder { // Cylndr1013
    <0,0,1>, <0,0,0>, 1 
    scale <6.0, 6.0, 4.5>
    translate  0.25*z
  }
  cylinder { // Cylndr1014
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 6.0>
    translate  -0.5*z
  }
}
#declare CSG506 = difference {
  cylinder { // Cylndr1015
    <0,0,1>, <0,0,0>, 1 
    scale <4.0, 4.0, 5.0>
  }
  cylinder { // Cylndr1016
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 6.0>
    translate  -0.5*z
  }
  material {
    White
  }
}
#declare Cube1326 = object {
  box { // Cube1326
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    translate  <6.0, 0.0, 1.0>
  }
}
#declare Cube1336 = object {
  box { // Cube1336
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 1.5>
    rotate -18.0*z
    translate  <5.706339, -1.854102, 4.0>
  }
}
#declare Wheel80 = union {
  object { CSG505 }
  object { CSG506 }
  box { // Cube1324
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <0.5, 3.0, 2.0>
    translate  2.5*z
  }
  box { // Cube1325
    <-1, -1, -1>, <1, 1, 1>
    material {
      White
    }
    scale <3.0, 0.5, 2.0>
    translate  2.5*z
  }
  cylinder { // Cylndr1017
    <0,0,1>, <0,0,0>, 1 
    material {
      White
    }
    scale <1.0, 1.0, 5.0>
  }
  object { Cube1326 }
  object { // Cube1327->Cube1326
    Cube1326
    rotate -36.0*z
  }
  object { // Cube1328->Cube1326
    Cube1326
    rotate -72.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Cube1329->Cube1326
    Cube1326
    rotate -108.0*z
    translate  0.0*x
  }
  object { // Cube1330->Cube1326
    Cube1326
    rotate -144.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1331->Cube1326
    Cube1326
    rotate 180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1332->Cube1326
    Cube1326
    rotate 144.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1333->Cube1326
    Cube1326
    rotate 108.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1334->Cube1326
    Cube1326
    rotate 72.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1335->Cube1326
    Cube1326
    rotate 36.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { Cube1336 }
  object { // Cube1337->Cube1336
    Cube1336
    rotate <-0.0, 0.0, -36.0>
    translate  0.0*x
  }
  object { // Cube1338->Cube1336
    Cube1336
    rotate <0.0, 0.0, -72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1339->Cube1336
    Cube1336
    rotate <0.0, 0.0, -108.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube1340->Cube1336
    Cube1336
    rotate <0.0, 0.0, -144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1341->Cube1336
    Cube1336
    rotate <0.0, 0.0, 180.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1342->Cube1336
    Cube1336
    rotate <0.0, 0.0, 144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube1343->Cube1336
    Cube1336
    rotate <0.0, 0.0, 108.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube1344->Cube1336
    Cube1336
    rotate <0.0, 0.0, 72.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Cube1345->Cube1336
    Cube1336
    rotate <-0.0, 0.0, 36.0>
    translate  0.0*y
  }
  // Scaling fixed
  // Translation fixed
  rotate LegoBWheelRotation
  translate  <-10.0, -9.0, 0.0>
}
#declare Wheelset3 = union {
  object { Wheel80 }
  object { // Wheel81->Wheel80
    Wheel80
    // All transformations fixed
    rotate -0.0*z
    translate  18.0*y
  }
  material {
    Black
  }
  // All transformations fixed
}
#declare CSG507 = difference {
  cylinder { // Cylndr1023
    <0,0,1>, <0,0,0>, 1 
    scale 3.0
    rotate 90.0*y
    translate  <11.0, 21.0, 10.0>
  }
  cylinder { // Cylndr1024
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 5.0>
    rotate 90.0*y
    translate  <10.0, 22.0, 11.0>
  }
  material {
    Black
  }
  translate  3.0*y
}
#declare CSG508 = difference {
  cylinder { // Cylndr1025
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 6.0>
    rotate 90.0*y
    translate  <8.0, 3.0, 18.0>
  }
  cylinder { // Cylndr1026
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 6.0>
    rotate 90.0*y
    translate  <9.0, 3.0, 18.0>
  }
}
#declare CSG509 = difference {
  cylinder { // Cylndr1028
    <0,0,1>, <0,0,0>, 1 
    scale 2.7
    rotate 90.0*y
    translate  <-1.35, 0.0, 17.0>
  }
  cylinder { // Cylndr1029
    <0,0,1>, <0,0,0>, 1 
    scale <1.8, 1.8, 4.0>
    rotate 90.0*y
    translate  <-2.0, 0.0, 18.5>
  }
}
#declare Wrench1 = union {
  cylinder { // Cylndr1027
    <0,0,1>, <0,0,0>, 1 
    scale <1.3, 1.3, 15.0>
  }
  object { CSG509 }
  // Scaling fixed
  // Rot X limited (-120.0 to   120.0)
  // Translation fixed
  rotate 120.0*x
  translate  <12.5, 3.0, 18.0>
}
#declare Attachments3 = union {
  box { // Cube1346
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    translate  <9.0, 13.0, 10.0>
  }
  box { // Cube1347
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    translate  <9.0, 1.0, 10.0>
  }
  cylinder { // Cylndr1018
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale <1.5, 1.5, 23.0>
    rotate -90.0*x
    translate  <12.0, -1.0, 10.0>
  }
  cylinder { // Cylndr1019
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale 2.5
    rotate -90.0*x
    translate  <12.0, 12.0, 10.0>
  }
  cylinder { // Cylndr1020
    <0,0,1>, <0,0,0>, 1 
    material {
      Black
    }
    scale 2.5
    rotate -90.0*x
    translate  <12.0, 0.0, 10.0>
  }
  box { // Cube1348
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.5>
    translate  <9.0, -8.0, 15.0>
  }
  cylinder { // Cylndr1021
    <0,0,1>, <0,0,0>, 1 
    scale <1.9, 1.9, 6.0>
    rotate 90.0*y
    translate  <6.0, 3.0, 18.0>
  }
  cylinder { // Cylndr1022
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 13.0>
    rotate 90.0*x
    translate  <10.0, -5.0, 15.0>
  }
  object { CSG507 }
  object { CSG508 }
  cone { // Cone067
    <0,0,0>, 3.8, <0,0,1>, 2.0
    scale <1.0, 1.0, 3.0>
    rotate 90.0*y
    translate  <8.0, 3.0, 18.0>
  }
  object { Wrench1 }
  // All transformations fixed
}
#declare Chassis1 = union {
  box { // Cube1315
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 1.0>
    translate  <0.0, -8.0, 15.0>
  }
  box { // Cube1316
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 8.0, 1.0>
    translate  <0.0, -1.0, 27.0>
  }
  box { // Cube1317
    <-1, -1, -1>, <1, 1, 1>
    material {
      RedClear
    }
    scale <8.0, 4.0, 1.0>
    translate  <0.0, -5.0, 25.0>
  }
  box { // Cube1318
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 8.0, 1.0>
    translate  <0.0, -1.0, 23.0>
  }
  box { // Cube1319
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 4.0>
    translate  <0.0, 3.0, 18.0>
  }
  box { // Cube1320
    <-1, -1, -1>, <1, 1, 1>
    material {
      Black
    }
    scale <8.0, 10.0, 4.0>
    translate  <0.0, 6.0, 10.0>
  }
  box { // Cube1321
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 8.0, 4.0>
    translate  <0.0, -12.0, 10.0>
  }
  box { // Cube1322
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 12.0, 4.0>
    translate  2.0*z
  }
  box { // Cube1323
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 4.0, 1.0>
    translate  <0.0, 3.0, 25.0>
  }
  cylinder { // Cylndr1009
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <6.0, 18.0, 6.0>
  }
  cylinder { // Cylndr1010
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <2.0, 18.0, 6.0>
  }
  cylinder { // Cylndr1011
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <-2.0, 18.0, 6.0>
  }
  cylinder { // Cylndr1012
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 8.0>
    translate  <-6.0, 18.0, 6.0>
  }
  material {
    White
  }
  // All transformations fixed
}
union { // LegoB
  object { Chassis1 }
  object { // Wheelset2->Wheelset3
    Wheelset3
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Wheelset3 }
  object { // Attachments2->Attachments3
    Attachments3
    // All transformations fixed
    scale -1.0
    rotate -180.0*x
  }
  object { Attachments3 }
  material {
    White
  }
  scale 5.0
  translate  LegoBLocation
}

