#include <ri.h>
#include <math.h>

#define PI 3.14159265359
#define FRAMES 96.

main()
{
  RtInt frame;
  RtFloat fov = 25;
  RtColor color;
  char filename[20];

  RiBegin(RI_NULL);
    RiPixelSamples(1, 1);
    RiFormat(320, 240, 1);
    RiDisplay(filename, RI_FILE, RI_RGB, RI_NULL);
    RiProjection("perspective", RI_FOV, &fov, RI_NULL);
    RiLightSource("distantlight", RI_NULL);
    RiSurface("matte", RI_NULL);
    RiTranslate(-.1, 0., 5.);
    RiRotate(30., 1., 0., 0.);
    for (frame=1; frame<=FRAMES; frame++) {
      RiFrameBegin(frame);
        sprintf(filename, "frames_gear/gear_%d", frame);
        RiDisplay(filename, RI_FILE, RI_RGB, RI_NULL);
        RiWorldBegin();
          color[0] = 0.;
          color[1] = 1.;
          color[2] = 0.;
          RiColor(color);
          RiTransformBegin();
            RiRotate((RtFloat)frame*90./FRAMES, 0., 0., 1.);
            Gear(96, .03, .1, .07, .15, .05, .15, .1, .6);
          RiTransformEnd();
          RiTranslate(1.+1./12.+.36/12., 0., 0.);
          RiScale(1./12., 1./12., 1.);
          RiRotate(360./16.-(RtFloat)frame*90./FRAMES*12., 0., 0., 1.);
          color[0] = 1.;
          color[1] = 0.;
          color[2] = 0.;
          RiColor(color);
          Gear(8, .36, 1., .07, .36, .05, .5, .1, .6);
        RiWorldEnd();
      RiFrameEnd();
    }
  RiEnd();
}

/* a gear wheel
 * notches ... number of notches
 * notch ... height of each notch
 * rim ... width of the rim
 * thick ... thickness of the gear wheel
 * spokeswidth ... base width of spokes
 * spokesthick ... thickness of spokes
 * hub ... radius of the hub
 * hubthick ... thickness of the hub
 * tapering ... tapering of the spokes
 */
Gear(notches, notch, rim, thick, spokeswidth, spokesthick, hub, hubthick, tapering)
int notches;
float notch, rim, thick, spokeswidth, spokesthick, hub, hubthick, tapering;
{
  int i;
  float angle;
  
  RiSolidBegin(RI_DIFFERENCE);
    RiSolidBegin(RI_UNION);
      RiSolidBegin(RI_PRIMITIVE);
        RiScale(1., 1., thick/2);
        ClosedCylinder();
      RiSolidEnd();      
      RiSolidBegin(RI_PRIMITIVE);
        angle = 2.*PI/(float)notches;
        for (i=0; i<notches; i++) {
          RiTransformBegin();
            RiRotate((float)i*angle*180./PI, 0., 0., 1.);
            RiTranslate(0., cos(angle/3.5), 0.);
            RiScale(sin(angle/3.5)*2., notch, thick);
            Notch(sin(angle/4.)/sin(angle/3.));
          RiTransformEnd();
        }
      RiSolidEnd();
    RiSolidEnd();
    if (rim<1.) {
      RiSolidBegin(RI_PRIMITIVE);
        RiScale(1.-rim, 1.-rim, thick);
        ClosedCylinder();
      RiSolidEnd();  
    }
  RiSolidEnd();
  if (rim<1.) {
    RiTransformBegin();
      RiScale(hub, hub, hubthick/2);
      ClosedCylinder();
    RiTransformEnd();  
    for (i=0; i<4; i++) {
      RiRotate(90., 0., 0., 1.);
      RiTransformBegin();
        RiScale(spokeswidth, cos(asin(thick/2)), spokesthick);
        Notch(tapering);
      RiTransformEnd();
    }
  }
}

/* closed cylinder radius 1 from -1 to 1 in z-direction */
ClosedCylinder()
{
  RiCylinder(1., -1., 1., 360., RI_NULL);
  RiDisk(-1., 1., 360., RI_NULL);
  RiDisk(1., 1., 360., RI_NULL);
}

/* prism with narrower top */
Notch(ratio)
float ratio;
{
  RtInt nverts[6] = {4, 4, 4, 4, 4, 4},
        verts[24] = {0, 1, 2, 3,
                     7, 6, 5, 4,
                     2, 1, 5, 6,
                     0, 3, 7, 4,
                     3, 2, 6, 7,
                     1, 0, 4, 5};
  RtPoint cube[8] = {{-.5*ratio, 1., .5}, {.5*ratio, 1., .5}, {.5*ratio, 1., -.5}, {-.5*ratio, 1., -.5},
                     {-.5, 0., .5}, {.5, 0., .5}, {.5, 0., -.5}, {-.5, 0., -.5}};

  RiPointsPolygons(6, nverts, verts, RI_P, (RtPointer)cube, RI_NULL);
}

