#include <ri.h>
#include <math.h>

/* Tree(): create a recursive tree in z-direction with base at {0, 0, 0}
 * parameters:
 *   level        - level of recursion
 *   rbase        - radius at the basis of the trunk
 *   rbasechange  - change of rbase from one level to the next
 *   size         - overall height of the trunk (not the whole tree)
 *   sizechange   - change of size from one level to the next
 *   bole         - height to the first branch
 *   bolechange   - change of bole from one level to the next
 *                  (note that bole is also affected by sizechange)
 *   leafhandle   - an objecthandle to a leaf object, created by RiObjectBegin
 *                  -> if level is 0, this object will be drawn
 */
Tree(level, rbase, rbasechange, size, sizechange, leafhandle)
             int level;
         RtFloat rbase, rbasechange,
                 size, sizechange;
  RtObjectHandle leafhandle;
{
  RtPoint baseP, topP;
  RtFloat Ka, Kd;
      int i;

  rbase = rbase*level/5;
  baseP[0] = rbase;
  baseP[1] = baseP[2] = 0.;
  topP[0]  = rbase*rbasechange*(level-1)/5;
  topP[1]  = 0.;
  topP[2]  = size;
  RiColor(rainbow[level]);
  if (level) {
    if (level==2) {
      RiRotate(sin(time/2)*2, 1., 0., 0.);
      RiRotate(cos(time/2)*2, 0., 1., 0.);
    }
    if (level==3) {
      RiRotate(sin(time/2), 1., 0., 0.);
      RiRotate(cos(time/2), 0., 1., 0.);
    }
    RiHyperboloid(baseP, topP, 360., RI_NULL);
    if (level>1) {
      RiTransformBegin();
        RiTranslate(0., 0., size/4);
        for(i=0; i<10; i++) {
          RiTranslate(0, 0, size*3/4/10);
          RiRotate(100., 0., 0., 1.);
          RiTransformBegin();
            RiRotate(45., 0., 1., 0.);
            Tree(level-1, rbase*rbasechange*((rbasechange-1)/7*i+1), rbasechange, size*sizechange, sizechange, leafhandle, leaves);
          RiTransformEnd();
        }
      RiTransformEnd();
    }
    RiTranslate(0., 0., size);
    RiRotate(60, 0., 0., 1.);
    RiRotate(20., 0., 1., 0.);
    Tree(level-1, rbase*rbasechange, rbasechange, size*sizechange, sizechange, leafhandle, leaves);
  }  
  else RiObjectInstance(leafhandle); 
}

/***
 * RtColor rainbow[6] is a global variable, that holds the colors for each
 * level of recursion. The name comes from the test phase, when I used
 * different rainbow colors to display the levels of recursion.
 * rainbow[0] is the color of the leaves; rainbow[1...5] is the wood.
 *
 * In the animation the following parameters are used:
 *   RtPoint leaf[4] = {{0., 0., 0.}, {-.1, 0., .1}, {.1, 0., .1}, {0., 0., .3}};
 *   RtObjectHandle leafobject = RiObjectBegin();
 *     RiPatch(RI_BILINEAR, RI_P, (RtPointer)leaf, RI_NULL);
 *   RiObjectEnd();
 *   Tree(5, .8, .5, 15., .4, leafobject);
 ***
 * RtFloat time is a global variable representing the temporal position inside
 * the animation. It is used here as argument of sine and cosine to move the
 * branches and twigs to simulate the effects of a gentle breeze.
 *
 * The animation calculates time from 2*PI/fps*frame, which means it goes
 * from 0 to 2*PI in one second. The Tree() function uses it divided by 2.
 * So the twigs describe one full circle in two seconds.
 ***/

