
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "skies.inc"

background { SkyBlue }

#declare Trace_Skeleton = 1;
#declare Trace_Ground = 1; 
#declare Animate_Title = 0;
#declare Trace_Sky = 1;
#declare Trace_Tree = 1;

camera {
        location  <0, 15, -65>  //Scene View
        //location <0, 20, -110>  //Debug
        direction <0, 0,  1>
        up        <0, 1,  0>
        right   <400/400, 0,  0>
        look_at   <0, 15, 0>  //Scene View
        //look_at <0, 0, 0 >  //Debug 
        //angle 18  //Debug
}

light_source {<0, 100, -150> color White*.8}
light_source {<50, 100, -150> color White*.6}
light_source {<-50, 100, -150> color White*.6}

// Skeleton ------------------------------------
#if (Trace_Skeleton = 1)
#declare FrameCounter = 6.0200; // 6 --> 7

// Roadkill Skell
#declare TimeFrame = 0; 
#declare Grow = TimeFrame+.00001; //Set with time-frame counter
#declare MaxHeight = .786*2; 
#declare BrakePoint = 1-TimeFrame;
#declare Layer1 =  texture { Soft_Silver }  
#declare Layer2 =  texture { pigment { color Red } finish { Shiny } }
#declare Layer3 =  texture { pigment { color (BrightGold+Red)/2 } finish { Shiny } }
#declare BlendTexture = texture { gradient y  turbulence .5
                                  texture_map { [ 0.0 Layer1 ]
                                                [ BrakePoint/2 Layer2 ]
                                                [ BrakePoint Layer3 ]
                                                [1.0 Layer3 ]   
                                              }             
                                  translate <0,-.5,0>
                                  scale <1,MaxHeight,1>
                                  rotate <90,0,0>
                                }
#include "M_skel1.inc"
#declare Man = object { M_skel1 rotate <-90,0,0> rotate <0,-180,0> translate <0,.786,0> scale 1.14*20 }
// Bend Parameters
#declare object_axis1 = <0, 0, 0>;
#declare object_axis2 = <0,MaxHeight*20>;
#declare bend_angle = 180 - 180*TimeFrame;
#declare twist_angle = 90 - 90*TimeFrame;
#declare bend_direction = -z;
#declare bend_smoothness = 100; //0 --> 100
   object {
           #declare bend_object = object { Man }         
           #include "Bend.inc"
           scale <1,Grow,1>
           #declare Expand=.85*(FrameCounter-6+00.00001);
           scale <Expand,1,Expand>
           translate <0,0,-20>
          }

//Ending Skell
//#declare FrameCounter = 6.0000; //6.0000 --> 7.0
//#declare Clock = FrameCounter-6; //clock;
//#declare MClock = .5 + Clock * 5;
//#if (Trace_Skeleton = 1)
#declare MaxHeight = .786*2; 
#declare BlendTexture = texture { pigment { color (BrightGold+Red)/2 } 
                                  finish { Shiny ambient .1+.9*(FrameCounter-3.2) } 
                                }
#include "M_skel1.inc"
#declare Man = object { M_skel1 rotate <-90,0,0> rotate <0,-180,0> 
                        translate <0,.786,0> scale 1.14*20 }
// Bend Parameters
//#declare object_axis1 = <0, 0, 0>;
//#declare object_axis2 = <0,MaxHeight*1.14*20>;
//#declare bend_angle = -180 + (mod(MClock, 1) * 360);
//#declare bend_direction = z;
//#declare bend_smoothness = 100; //0 --> 100
//#declare stride_length = 2 * vlength(object_axis2 - object_axis1) / pi;
   object { Man
           //// USE UPSIDE-DOWN MAN FOR EVERY SECOND STEP
           //#if (mod(int(MClock), 2) = 0) #declare bend_object = object {Man}
           //#else #declare bend_object = object {Man scale <1, -1, 1> 
           //                                     translate y * MaxHeight*1.14*20}
           //#end
           //#include "Bend.inc"
           #declare Shrink=7-FrameCounter+0.00001;
           scale <1+Expand,Shrink,1+Expand>
           translate <0,0,-20>
           // TRANSLATE FOR EACH STEP
           translate z * 6*22.817 //int(MClock) * stride_length
          }

#end          

//Ground -----------------------------------------------
#if (Trace_Ground = 1)
plane { y, 0 
        texture { T_Stone21 rotate x*90 scale 400 } 
        texture { pigment { image_map { gif "parm006e.gif" interpolate 2 once filter 15, 1.0 }
                            rotate x*90
                            translate <-.5,0,-.5>
                            scale <300, 1, 500>
                            translate <0, 0, 25>
                          }
                  finish {crand 0.05 reflection 0.2 diffuse 0.7 ambient 0.3}
                }
      }
#end

// Title ------------------------
#if (Animate_Title)
//#declare TextTime = 1.9800;
height_field { gif "Title1.gif" water_level 5/255
               texture { pigment { image_map { gif "Title1.gif" interpolate 2 }
                                    rotate x*90
                                 }
                          finish {crand 0.05 reflection 0.2 diffuse 0.7 ambient 0.3}
                       }
                //smooth             // comment out this line to speed rendering
                translate <-.54, -5/255, 0>
                scale <34, 3, 13>
                translate <0, 0, -37.1478>
                translate <0, 0, -10*(1-TimeFrame)> 
             }
#end
        
// The Sky
#if (Trace_Sky=1)
sphere { 0, 5000
         hollow
         pigment {
                  gradient y
                  pigment_map {
                               [0.00 rgb <0.184, 0.184, 0.309> ]
                               [0.15 P_Cloud3 scale <0.05, 0.40, 0.05> rotate z*30 ]
                               [0.45 P_Cloud3 scale <0.25, 0.15, 0.50> ]
                              }
                  scale 2000
                 }
         scale <1,1.15,1>        
       }
#end

#if (Trace_Tree=1)
height_field { gif "Ztreeb.gif" water_level (14*(7-FrameCounter)+7)/255
                 texture { pigment { image_map { gif "Ztreeb.gif" interpolate 2 }
                                     rotate x*90
                                   }
                           finish {ambient 1}
                         }
                //smooth             // comment out this line to speed rendering
                translate <-.5, 0, 0>
                rotate <-90, 0, 0>
                scale <150, 100, 10>
                translate <0, 0, 100> 
             }
#end


       