   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/

#declare sub_image = true;

#ifndef ( __fire_inc )
	#include "fire.inc"
#end


 /*************
 * Constants *
*************/

//values
#declare nose_curve_radius = 12;



 /************
 * Textures *
************/

#declare p1_decal1 =
	pigment {
		image_map {
			gif "decal1.gif"
			once
		}
		rotate <90,0,0>
		translate <-0.5, 0, -0.5>
	}


#declare p1_decal2 =
	pigment {
		image_map {
			gif "decal2.gif"
			once
		}
		rotate <90,0,0>
		translate <-0.5, 0, -0.5>
	}


#declare booster_metal = 
		texture {
			pigment {
//				rgb <0.9,0.90,1.2>
				rgb <0.9,0.91,0.93>
			}
			finish {
				diffuse 0.1
				ambient 0.35
				reflection 0.65
				specular 1.5
				roughness 0.01
			}
		}
		
#declare burn_tex =
	texture {
		pigment {
			rgb 1.0
		}
		finish {
			metallic
			ambient 0.06
			diffuse 0.14
			specular 0.4 roughness 0.2 //very rough.
		}
	}
		

#declare p1_shiny_finish =
	finish {
		diffuse 0.8
		ambient 0.2
		specular 1.0 roughness 0.01
//		reflection 0.1
	}
	
#declare white_stuff =
	texture {
		pigment { rgb <1,1,1> }
		finish {
			p1_shiny_finish
		}
	}


#declare window_glass =
	texture {
		pigment { rgb <0.05, 0.06, 0.15> }
		finish {
			ambient 0.5
			diffuse 0.5
			reflection 0.7
			specular 1.0 roughness 0.001
		}
	}	                   	


 /***********
 * Objects *
***********/

#declare fin =
	intersection {
		plane { <0,1,0>, 0.1 rotate <0,0,0.85> }
		plane { <0,-1,0>, 0.05 rotate <0,0,-0.85> }
		plane { <1,0,0>, 0.5 }
		plane { <-1,0,0>, 4.0 }
		plane { <0,0,1>, -0.8 rotate <0,-8,0> }
		plane { <0,0,-1>, 6.4 rotate <0,30,0> }
		scale <0.3,0.3,-0.3>
		rotate <0,0,-45>
		translate <-1.5, 0.95, -7>
		texture { white_stuff }
	}


#declare body = 
	/*box {
		<-2,1.5,0>, <2,-0.5,-7>
		texture { debug_obj_tex }
	}*/
	union {
		intersection {
			plane { <0,1,0>, 1.0 rotate <0,0,0> }
			plane { <0,1,0>, 1.8 rotate <0,0,70> }
			plane { <0,1,0>, 1.8 rotate <0,0,110> }
			plane { <0,1,0>, 1.0 rotate <0,0,180> }
			plane { <0,1,0>, 1.8 rotate <0,0,250> }
			plane { <0,1,0>, 1.8 rotate <0,0,290> }
			plane { <0,0,1>, 0.0 rotate <0,-20,0> }
			plane { <0,0,1>, 0.0 rotate <0,20,0> }
			plane { <0,0,-1>, 7.5*sqrt(3)/2 rotate <30,0,0> }
			plane { <0,0,-1>, 7.5/sqrt(2) rotate <-45,0,0> }
		}
		union {
			object { fin }
			object { fin scale <-1,1,1> }
		}
		translate <0, 0.5, 0>
		rotate <-2,0,0>
		texture { white_stuff }
	}


#declare engine = 
	/*box {
		<-2,1.0,0.5>, <-3,-0.5,-7.5>
		texture { debug_obj_tex }
	}*/
	intersection {
		plane { <0,1,0>, 1.0 rotate <0,0,10> }
		plane { <0,1,0>, 0.5 rotate <0,0,190> }
		plane { <0,1,0>, 0.4 rotate <0,0,-45> }
		plane { <0,1,0>, -0.2 rotate <0,0,-120> }
		plane { <0,1,0>, 1.5 rotate <0,0,70> }
		plane { <0,1,0>, 1.2 rotate <0,0,145> }
		plane { <0,0,1>, 0.2 rotate <2,-30,0> }
		plane { <0,0,-1>, 7.5 }
		translate <-1.7, 0.3, 0>
		texture { white_stuff }
	}


#declare large_booster = 
	/*box {
		<-1,0.5,-7>, <-2,-0.5,-8>
		texture { debug_obj_tex }
	}*/
	union {
		intersection {
			difference {
				quadric { <1,1,0>,<0,0,0>,<0,0,1>,0 }
				quadric { <1,1,0>,<0,0,0>,<0,0,1>,0 translate<0,0,-0.1>}
			}
			plane { <0,0,-1>,1 }
			texture {
				gradient z
				scale <1,1,0.1>
				warp {
					turbulence 0.03
				}
				scale <1,1,20>
				texture_map {
					[0.35	booster_metal]
					[0.6	burn_tex]
				}
			}
		}
		object {
			fire //yeah! yeah! fire!
			scale <2.5,2.5,-6>
			translate <0,0,-0.9>
		}
		scale<0.5,0.5,0.75>
		translate<-2.8, 0.25, -7.35>
	}


#declare small_booster = 
	/*box {
		<-2.2,1.0,-7.5>, <-2.8,0.4,-8>
		texture { debug_obj_tex }
	}*/
	intersection {
		difference {
			quadric { <1,1,0>,<0,0,0>,<0,0,1>,0 }
			quadric { <1,1,0>,<0,0,0>,<0,0,1>,0 translate<0,0,-0.1>}
		}
		plane { <0,0,-1>,1 }
		texture {
			gradient z
			scale <1,1,0.1>
			warp {
				turbulence 0.03
			}
			scale <1,1,20>
			texture_map {
				[0.35	booster_metal]
				[0.6	burn_tex]
			}
		}
		scale<0.3,0.3,0.5>
		translate<-2.2, 0.85, -7.45>
	}


#declare left_wing = 
	/*box {
		<-3,0.1,-0.5>, <-7,-0.05,-7>
		texture { debug_obj_tex }
	}*/
	intersection {
		intersection {
			plane { <0,-1,0>, 0.05 rotate <0,0,-0.85> }
			plane { <1,0,0>, 0.5 }
			plane { <-1,0,0>, 4.0 }
			plane { <0,0,1>, -0.8 rotate <0,-8,0> }
			plane { <0,0,-1>, 6.4 rotate <0,30,0> }
			texture { white_stuff }
		}
		plane {
			<0,1,0>, 0.1 rotate <0,0,0.85>
			texture { white_stuff }
			texture {
				pigment {
					p1_decal2
					rotate <0,90,0>
					scale 2.5
					translate <-2,0,-3.6>
				}
				finish {
					p1_shiny_finish
				}
			}
		}
		rotate <0,0,10>
		translate <-3, 0, 0>
	}


#declare right_wing = 
	/*box {
		<-3,0.1,-0.5>, <-7,-0.05,-7>
		texture { debug_obj_tex }
	}*/
	intersection {
		intersection {
			plane { <0,-1,0>, 0.05 rotate <0,0,-0.85> }
			plane { <1,0,0>, 0.5 }
			plane { <-1,0,0>, 4.0 }
			plane { <0,0,1>, -0.8 rotate <0,-8,0> }
			plane { <0,0,-1>, 6.4 rotate <0,30,0> }
			texture { white_stuff }
		}
		plane {
			<0,1,0>, 0.1 rotate <0,0,0.85>
			texture { white_stuff }
			texture {
				pigment {
					p1_decal2
					rotate <0,90,0>
					scale <2.5,1,-2.5>
					translate <-2,0,-3.6>
				}
				finish {
					p1_shiny_finish
				}
			}
		}
		rotate <0,0,10>
		translate <-3, 0, 0>
	}


#declare nose = 
	/*box {
		<-2.3,1.0,0>, <2.3,-0.5,8>
		texture { debug_obj_tex }
	}*/
	union {
		//straight bit
		intersection {
			plane { <0,1,0>, 0.75 rotate <0,0,0> }
			plane { <0,1,0>, 2.6*sqrt(3)/2 rotate <0,0,60> }
			plane { <0,1,0>, 2.6*sqrt(3)/2 rotate <0,0,120> }
			plane { <0,1,0>, 0.75 rotate <0,0,180> }
			plane { <0,1,0>, 2.6*sqrt(3)/2 rotate <0,0,-60> }
			plane { <0,1,0>, 2.6*sqrt(3)/2 rotate <0,0,-120> }
			plane { <0,0,1>, 4 }
			plane { <0,0,-1>, 1 }
			texture { white_stuff }
		}
		//curved bit
		difference {
			intersection {
				plane { <0,0,-1>, -4 }
				plane { <0,0,1>, 0 rotate <0,10,0> rotate <60,0,0> translate <0,0.75-nose_curve_radius*(1-cos(asin(4/nose_curve_radius))),8> }
				plane { <0,0,1>, 0 rotate<0,-10,0> rotate <60,0,0> translate <0,0.75-nose_curve_radius*(1-cos(asin(4/nose_curve_radius))),8> }
				cylinder { <-3,0.75-nose_curve_radius,4>, <3,0.75-nose_curve_radius,4>, nose_curve_radius }
				cylinder {
					<-8,0,4>, <8,0,4>, nose_curve_radius
					rotate <0,0,-45>
					scale <tan(radians(15))/tan(radians(45)),1,1>
					rotate <0,0,15>
					scale <cos(radians(15))/cos(radians(45)),cos(radians(15))/cos(radians(45)),1>
					translate <0,2.6*sqrt(3)-nose_curve_radius,0>
				}
				cylinder {
					<-8,0,4>, <8,0,4>, nose_curve_radius
					rotate <0,0,45>
					scale <tan(radians(15))/tan(radians(45)),1,1>
					rotate <0,0,-15>
					scale <cos(radians(15))/cos(radians(45)),cos(radians(15))/cos(radians(45)),1>
					translate <0,2.6*sqrt(3)-nose_curve_radius,0>
				}
			}
			union {
				cylinder { <-5,-0.75-nose_curve_radius,4>, <5,-0.75-nose_curve_radius,4>, nose_curve_radius }
				cylinder {
					<-8,0,4>, <8,0,4>, nose_curve_radius
					rotate <0,0,-45>
					scale <tan(radians(15))/tan(radians(45)),1,1>
					rotate <0,0,15>
					scale <cos(radians(15))/cos(radians(45)),cos(radians(15))/cos(radians(45)),1>
					translate <0,-2.6*sqrt(3)-nose_curve_radius,0>
				}
				cylinder {
					<-8,0,4>, <8,0,4>, nose_curve_radius
					rotate <0,0,45>
					scale <tan(radians(15))/tan(radians(45)),1,1>
					rotate <0,0,-15>
					scale <cos(radians(15))/cos(radians(45)),cos(radians(15))/cos(radians(45)),1>
					translate <0,-2.6*sqrt(3)-nose_curve_radius,0>
				}
			}
			texture { white_stuff }
		}
		//cockpit
		intersection {
			intersection {
				plane { <0,1,0>, 1.15 }
				plane { <0,-1,0>, -0.75 }
				plane { <0,0,-1>, 1 }
				plane { <1,0,0>, 1.9 rotate <0,0,0> }
				plane { <-1,0,0>, 1.9 rotate <0,0,0> }
				texture { white_stuff }
			}
			intersection {
				plane { <0,0,1>, 1.9 rotate <0,-67.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
				plane { <0,0,1>, 1.9 rotate <0,-22.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
				plane { <0,0,1>, 1.9 rotate <0,22.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
				plane { <0,0,1>, 1.9 rotate <0,67.5,0> scale <1,1,1/sqrt(2)> rotate <-45,0,0> }
				translate <0,0,1.8>
				texture { window_glass }
			}
		}
		translate <0, 0, 0>
		rotate <3,0,0>
	}



/* all of the above unified in one glorious whole (what you might call a "whole in one", ahahahaha) */

#declare P1 =
	union {
		object { body }
		object { engine }
		object { engine scale <-1,1,1> }
		object { large_booster }
		object { large_booster scale <-1,1,1> }
		object { small_booster }
		object { small_booster scale <-1,1,1> }
		object { left_wing }
		object { right_wing scale <-1,1,1> }
		object { nose }
		
		scale 1/14
	}

/*
#declare P1 =
	triangle {
		<0,0,1>, <1,0,-0.5>, <-1,0,-0.5>
		pigment {
			rgb 1
		}
		finish {
			diffuse 0.5
			ambient 0.5
			specular 1.0 roughness 0.01
		}
		scale 0.5
	}
*/


#ifndef ( final_image )
	//do a test render
	
	#declare group_rotate = <20,-45,0>;

	camera {
//		right x*4/3
//		up y
//		direction z
		right x*4/3
		up z
		direction -y*10//0.5
		
//		location <-0.8,1.15,0.6>*0.6
//		location <0.0,1.0,0.0>*2
		location <0.0,1.0,0.0>*40//2
		look_at <0,0,0>
		rotate group_rotate
	}


	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }
/*
	#include "ground.inc"
  
	object { ground }
*/
	
	object { P1 scale 1.5 translate <-1.1,0,-0.6> rotate group_rotate }
	object { P1 scale 1.5 rotate <90,0,0> translate <-1.1,0,0.6> rotate group_rotate }
	object { P1 scale 1.5 rotate <90,0,90> translate <1.1,0,0.6> rotate group_rotate }
	object { P1 scale 1.5 rotate <120,0,225> translate <1.1,0.1,-0.6> rotate group_rotate }

#end
