   /******************************************
   * Include file                           *
  * by tek                                 *
 * defining macros & objects for a scene. *
******************************************/


 /*************
 * Constants *
*************/

#declare canyon_width = 0.5*4;
//#declare canyon_height = 20;
#declare canyon_length = 20*4;



 /************
 * Textures *
************/

#declare canyon_gold_stuff =
	texture {
		pigment {
			rgb <1.00,0.75,0.25>
		}
		finish {
			ambient 0.3
			diffuse 0.4
			reflection 0.3
			specular 1.0 roughness 0.01
			metallic
		}
	}
	

#declare white_paint =
	texture {
		pigment { rgb 1 }
		finish {
			ambient 0.5
			diffuse 0.5
			specular 1.0 roughness 0.01
		}
	}

#declare black_paint =
	texture {
		pigment { rgb 0.1 }
		finish {
			ambient 0.3
			diffuse 0.7
			specular 0.75 roughness 0.01
		}
	}


#declare left_decal =
	texture {
		material_map {
			gif "leftsymbol.gif"
			once
			texture { canyon_gold_stuff }
			texture { black_paint }
		}
		translate <-1,0,0>
		scale <360,60,1>*0.042
		translate <-canyon_width/2,55,0>
	}


#declare right_decal =
	texture {
		material_map {
			gif "rightsymbol.gif"
			once
			texture { canyon_gold_stuff }
			texture { white_paint }
			texture { black_paint }
		}
		scale <99,119,1>*0.043
		translate <3,20,0>
	}


#declare canyon_blue_glass_layer1 =
		texture {
			pigment {
				rgb <0.0,0.0,1.0>
			}
			finish {
				ambient 0.3
				diffuse 0.2
				specular 0.5 roughness 0.2
				metallic
			}
		}

#declare canyon_blue_glass_layer2 =
		texture {
			pigment {
				rgbt <0.0,0.0,0.0,1.0>
			}
			finish {
				ambient 0.0
				diffuse 0.0
				specular 0.8 roughness 0.01
				reflection 0.3
			}
		}

#declare canyon_white =
	texture {
		pigment {
			rgb <1,1,1>
		}
		finish {
			ambient 0.7
			diffuse 0.2
			specular 1.0 roughness 0.02
		}
	}

#declare canyon_grey =
	texture {
		pigment {
			rgb <0.3,0.3,0.3>
		}
		finish {
			ambient 0.3
			diffuse 0.7
		}
	}


 /***********
 * Objects *
***********/

#declare canyon_spike =
	intersection {
		//box { <canyon_width/2,5,-canyon_length/2>, <25,80,canyon_length/2> }
		plane { x, 25 }
		plane { -x, -canyon_width/2 }
		plane { y, 80 }
		plane { -y, -5 }
		plane { z, canyon_length/2 rotate <-1,0,0> } //rotate just a touch to throw off the reflections
		plane { -z, canyon_length/2 rotate <1,0,0> }

		plane { <1,15/50,0>, 0 translate <25,30,0> }
		union {
			plane { -y, -10 }
			plane { <-1,-1,0>, 0 translate <0,15,0> }
		}
	}


#declare canyon_glass_rad    = 4.5;
#declare canyon_glass_height = 4;
#declare canyon_glass_length2= canyon_length/2;

#declare canyon_glass =
	//box { <-8,0,-canyon_length/2-4>, <8,15,canyon_length/2+4> }
	union {
		box { <-canyon_glass_rad,0,-canyon_glass_length2>, <canyon_glass_rad,canyon_glass_height,canyon_glass_length2> }
		cylinder { <0,0,canyon_glass_length2>, <0,canyon_glass_height,canyon_glass_length2>, canyon_glass_rad }
		cylinder { <0,0,-canyon_glass_length2>, <0,canyon_glass_height,-canyon_glass_length2>, canyon_glass_rad }
		cylinder { <0,canyon_glass_height,-canyon_glass_length2>, <0,canyon_glass_height,canyon_glass_length2>, canyon_glass_rad }
		sphere { <0,canyon_glass_height,canyon_glass_length2>, canyon_glass_rad }
		sphere { <0,canyon_glass_height,-canyon_glass_length2>, canyon_glass_rad }
	}

#declare canyon_frames_rad = canyon_glass_rad+0.1;

#declare slicex =
	intersection {
		plane { x, 0.1 }
		plane { -x, 0.1 }
	}

#declare slicey =
	intersection {
		plane { y, 0.1 }
		plane { -y, 0.1 }
	}

#declare slicez =
	intersection {
		plane { z, 0.1 }
		plane { -z, 0.1 }
	}


#declare canyon_frames =
	//box { <-8.5,0,-canyon_length/2>, <8.5,15.5,canyon_length/2> }
	intersection {
		union {
			box { <-canyon_frames_rad,0,-canyon_glass_length2>, <canyon_frames_rad,canyon_glass_height,canyon_glass_length2> }
			cylinder { <0,0,canyon_glass_length2>, <0,canyon_glass_height,canyon_glass_length2>, canyon_frames_rad }
			cylinder { <0,0,-canyon_glass_length2>, <0,canyon_glass_height,-canyon_glass_length2>, canyon_frames_rad }
			cylinder { <0,canyon_glass_height,-canyon_glass_length2>, <0,canyon_glass_height,canyon_glass_length2>, canyon_frames_rad }
			sphere { <0,canyon_glass_height,canyon_glass_length2>, canyon_frames_rad }
			sphere { <0,canyon_glass_height,-canyon_glass_length2>, canyon_frames_rad }
		}
		union {
			object { slicex }
			intersection {
				union {
					object { slicex rotate <0,0,45> translate <0,canyon_glass_height,0> }
					object { slicex rotate <0,0,-45> translate <0,canyon_glass_height,0> }
				}
				plane { -y, -canyon_glass_height }
			}
			intersection {
				union {
					object { slicex rotate <0,45,0> translate <0,0,canyon_glass_length2> }
					object { slicex rotate <0,-45,0> translate <0,0,canyon_glass_length2> }
				}
				plane { -z, -canyon_glass_length2 }
			}
			intersection {
				union {
					object { slicex rotate <0,45,0> translate <0,0,-canyon_glass_length2> }
					object { slicex rotate <0,-45,0> translate <0,0,-canyon_glass_length2> }
				}
				plane { z, -canyon_glass_length2 }
			}
			object { slicey }
			object { slicey translate <0,canyon_glass_height/2,0> }
			object { slicey translate <0,canyon_glass_height,0> }
			object { slicez translate <0,0,canyon_glass_length2*2/10> }
			object { slicez translate <0,0,canyon_glass_length2*6/10> }
			object { slicez translate <0,0,canyon_glass_length2> }
			object { slicez translate <0,0,-canyon_glass_length2*2/10> }
			object { slicez translate <0,0,-canyon_glass_length2*6/10> }
			object { slicez translate <0,0,-canyon_glass_length2> }
		}
	}

#declare canyon_base =
//	box { <-20,0,-canyon_length/2+4>, <20,7.5,canyon_length/2-4> }
	union {
		box { <2,0,-canyon_length/2+2>, <20,20,canyon_length/2-2> }
		box { <-2,0,-canyon_length/2+2>, <-20,20,canyon_length/2-2> }
	}
	

#declare canyon =
	union {
		object {
			canyon_spike
			scale <-1,1,1>
			texture { left_decal }
		}
		object {
			canyon_spike
			texture { right_decal }
		}
		object {
			canyon_glass
			texture { canyon_blue_glass_layer1 }
			texture { canyon_blue_glass_layer2 }
		}
		object {
			canyon_frames
			texture { canyon_white }
		}
		object {
			canyon_base
			texture { canyon_grey }
		}

		scale 1/4 		
		rotate <0,90,0>		
		translate <42,-15/4,51> //<30,0,60>
	}

/*
#declare canyon =
	union {
		box {
			<canyon_width/2,0,-canyon_length/2>, <20,canyon_height,canyon_length/2>
		}
		box {
			<-canyon_width/2,0,-canyon_length/2>, <-20,canyon_height,canyon_length/2>
		}
		pigment {
			checker rgb <0.1,0.3,1>, rgb 0.6
			translate <0, 0.5, 0.5>
		}
		finish {
			diffuse 0.5
			ambient 0.5
		}

		rotate <0,90,0>		
		translate <42,0,51> //<30,0,60>
	}
*/	



 /***************
 * Test Render *
***************/

#ifndef ( final_image )
	//do a test render
	camera {
		right x*5/4
		up y
		direction z
		
		location <42,-15,51> + <-1,0.1,0.2>*60
//		location <42,20,51> + <-1,0.0,1>*60
		look_at <42,20,51>
		angle 83
	}

	#declare final_image = true;

	#include "environment.inc"
	
	object { lights }
	
	sky_sphere { skydome }

	#include "ground.inc"

	object { ground }

	
	object {
		canyon
	}
#end
	