#declare light_loc = <-10000, 5000, -7000>; //light lower to cast shadows on canyon for longer


#declare lights =
	union {
		light_source {
			light_loc
		
			rgb 0.9
		}

		//add subtle additional lights for definition
		light_source {
			<0,-200000,0>
			rgb <0.3,0.3,0.4>
			shadowless
		}

		light_source {
			<0,200000,0>
			rgb <0.2,0.2,0.2>
			shadowless
		}
	}


//very nice sunset fx

#declare sunset_layer1 =
  //blue
  pigment {
    gradient y
    cubic_wave //use a cubic wave to avoid mach banding.
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }

#declare sunset_layer2 =
  //green
  pigment {
    boxed
    scale <1, 0.7, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
        }
      ]
    }
  }

#declare sunset_layer3 =
  //red
  pigment {
    boxed
    scale <1, 0.6, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
        }
      ]
    }
  }

#declare skydome =
	sky_sphere {
	  pigment { sunset_layer1 }
	  pigment { sunset_layer2 }
		pigment {
	  	bozo
	  	turbulence 0.5
	  	scale <0.2, 0.1, 0.2>
		  scale 1/1.8
	  	translate <2.85,0,0>
	//  	translate <-0.22,0,0.3>
	//  	rotate <1,0,0>
	  	cubic_wave
	  	colour_map {
		    [-0.10 rgbt <0.9, 0.95, 0.95, 0.0>]
		    [0.30 rgbt <1.0, 1.0, 1.0, 1.0>]
		  }
		}
	  pigment { sunset_layer3 }
	  scale 1.8
	//  translate -0.15*y
	}


/*sky_sphere {
  pigment {
//		rgb <0.1, 0.2, 0.625>
//		rgb 0.1//0.2
		rgb sky_colour
	}
  pigment {
  	bozo
  	turbulence 0.5
  	scale 2*<0.2, 0.1, 0.2>
  	translate <-0.22,0,0.3>
  	rotate <5,8,9>
  	cubic_wave
  	colour_map {
	    [0.00 rgb cloud_colour_dark transmit 0]
	    [0.40 rgb cloud_colour_light transmit 1]
	  }
	}*/
/* framing yin/yang
  pigment {
  	bozo
  	turbulence 0.5
  	scale 2*<0.2, 0.1, 0.2>
  	translate <-0.22,0,0.3>
  	rotate <1,0,0>
  	cubic_wave
  	colour_map {
	    [0.00 rgbt <0.9, 0.9, 0.9, 0.0>]
	    [0.40 rgbt <1.0, 1.0, 1.0, 1.0>]
	  }
	}
*/
/* old
  pigment {
    gradient y
    scale 2
    translate -0.5*y
    sine_wave
    colour_map {
      [0.3 rgbt rgbt <0.1, 0.2, 0.625, 1.0>]
      [1.0 rgbt rgbt <0.4, 0.5, 1.0, 0.0>]
    }
  }*/
/*  pigment {
    boxed
//    scale <1, 0.2, 1>
    scale <1, 0.8, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        translate -y
        poly_wave 0.35
        //cubic_wave
        colour_map {
          [0.00 rgb sky_bright transmit 0]
          [1.00 rgb sky_bright transmit 1]
        }
      ]
    }
  }
}*/
