#declare clockl = clock;
//#declare clockl = (312/25)*1;
/*
SCENE 0 - LOOOOOOOOOOONG OPENING SHOT.

P1 flying through the city,
shown from the side so flight is left to right.
Camera passes on the far side of some buildings so P1 gets obscured occaisionally.
*/


 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.02
  max_trace_level 80
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);

#declare final_image = true; //for include files to turn off test render stuff

//#declare high_quality_gases = true; //set detail of gaseous fx.

#if ( mod( clockl*2, 2 ) < 1 )
	#declare left_light_on = true;
#else
	#declare right_light_on = true;
#end

 /************
 * Includes *
************/

#include "P1.inc"
//#include "P2.inc"
#include "ground.inc"
#include "canyon.inc"
#include "environment.inc"

 /******************
 * scene switches *
******************/


//camera type
#declare CAM_FINAL = 0;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

#declare P1_vel = <-8,0,0>;
#declare P1_start_pos = <100,3.5,-100>;

#declare P1_pos = clockl*P1_vel + P1_start_pos;
#declare P1_rot = <0,-90,0>;

//camera position and orientation
#declare cam_loc = P1_pos - 10*z;
#declare lookat  = P1_pos;
//#declare cam_angle = 90;
#declare sky_vect = y;

#declare rock = 5*sin(clockl*pi/2)+5*sin(clockl*pi/5);
#declare bob = <1*sin((clockl+0.5)*pi/7)+0.25*sin((clockl+0.7)*pi/3), 0.2*sin((clockl+0.3)*pi/6), 0.7*sin(clockl*pi/4.3)>;
#declare P1_pos = P1_pos + bob;
#declare P1_rot = P1_rot + <0,0,rock>;



 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
	right x*4/3
	up y
	direction z*3//1.5 //I prefer this to the "angle" command, it gives me more control.
             
  #switch (camera_type)
  
	  #case (CAM_FINAL)
			location cam_loc
			look_at lookat
		#break
		
	#end //switch(camera_type)
}

          
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/

object { lights }

#declare flare_type = "35mm"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


sky_sphere { skydome }


 /*****************************************************************************************************************
 * SCENERY *
***********/

union {
	object { ground }
	object { canyon }
}


 /*****************************************************************************************************************
 * FLYING THINGS *
*****************/

object {
	P1
	rotate P1_rot.z*z
	rotate P1_rot.x*x
	rotate P1_rot.y*y
	translate P1_pos
}

/*object {
	P2
	rotate P2_rot
	translate P2_pos
}*/




