#declare clockl = clock;
//#declare clockl = (47/175)*7; //47//115
/*
SCENE 2

P1 spots P2 and makes evasive maneuvers.
*/


 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.0
  max_trace_level 80
}
//random seed
#declare rs = seed(132);//116,124,132 //seed(113);

#declare final_image = true; //for include files to turn off test render stuff

#declare high_quality_gases = true; //set detail of gaseous fx.

#if ( mod( clockl*2, 2 ) < 1 )
	#declare left_light_on = true;
#else
	#declare right_light_on = true;
#end

 /************
 * Includes *
************/

#include "blend.inc"
#include "P1.inc"
#include "P2.inc"
#include "ground.inc"
#include "canyon.inc"
#include "environment.inc"

 /******************
 * scene switches *
******************/


//camera type
#declare CAM_FINAL = 0;
#declare CAM_DEBUG = 1;

#declare camera_type = CAM_FINAL;


 /********************
 * object positions *
********************/

//blend together a series of movements
#macro compute_P1_pos_rot(time)
	
	#declare P1_vel = <0,0,5>;
	#declare P1_start_pos = <0,15,20>; //z = 20, end position from scene1
	#declare P1_pos1 = time*P1_vel + P1_start_pos;
	#declare P1_rot1 = <0,0,0>;
	
	#declare P1_vel = <0,0,5>;
	#declare P1_start_pos = <-2,18,20>;
	#declare P1_pos2 = time*P1_vel + P1_start_pos;
	#declare P1_rot2 = <0,0,90>;
	
	#declare P1_vel = <4,0,4>;
	#declare P1_start_pos = <-4,14,20> + <0,0,5*3> - P1_vel*3;//<-4,14,47.5> - P1_vel*4;
	#declare P1_pos3 = time*P1_vel + P1_start_pos;
	#declare P1_rot3 = <0,45,-90>;
	
	#declare P1_vel = <5,0,-1.5>;
	#declare P1_start_pos = <-4,18,20> + <0,0,5*3> + <4*4,0,4*4> - P1_vel*7;  //scene3 start: <17,15,51>
	#declare P1_posl = time*P1_vel + P1_start_pos;
	#declare P1_rotl = <0,90,0>;

	blend( P1_pos1, P1_pos2, time, 1.0, 4.5 )
	blend( blended, P1_pos3, time, 4.0, 6.0 )
	blend( blended, P1_posl, time, 5.0, 7.3 )
	#declare computed_pos = blended;

	//blend( P1_rot1, P1_rotl, time, 2.0, 8.0 )
	blend( P1_rot1, P1_rot2, time, 1.0, 3.5 )
	blend( blended, P1_rot3, time, 2.0, 6.0 )
	blend( blended, P1_rotl, time, 5.0, 7.3 )
	#declare computed_rot = blended;
#end


//get the position and rotation of player 1
compute_P1_pos_rot(clockl)
#declare P1_pos = computed_pos - 11*y;
#declare P1_rot = computed_rot;

//camera position and orientation
#declare cam_loc = P1_pos1+<0.03,-0.15,1> - 11*y; //track pos 1, so we pull back. cunning
#declare lookat = P1_pos;
//#declare cam_angle = 90;
#declare sky_vect = y;



//now, make p2 chase him, using a function of the old position of P1
#declare P2_vel = <0,0,5.5>;
#declare P2_start_pos = <-1,17,17>;//<0,20,18.5>;
#declare P2_pos1 = clockl*P2_vel + P2_start_pos;

compute_P1_pos_rot(clockl*0.95 - 0.5)
#declare P2_pos2 = computed_pos;

blend( P2_pos1, P2_pos2, clockl, 1.0, 2.5 )
#declare P2_pos = blended - 11*y;
#declare P2_rot = computed_rot;




 /********************************************************************************************************************
 * CAMERA *
**********/


camera {         
  #switch (camera_type)

		#case (CAM_DEBUG)
			orthographic

			right 40*x*4/3
			up 40*y
			direction z

			location <-1000,1000,1000>+<0,15,50>
			look_at <0,15,50>
		#break
  
	  #case (CAM_FINAL)
			right x*4/3
			up y
			direction z*3/4 //I prefer this to the "angle" command, it gives me more control.

			location cam_loc
			look_at lookat
		#break
		
	#end //switch(camera_type)
}

          
 /********************************************************************************************************************
 * LIGHTS AND ATMOSPHERE *
*************************/

object { lights }

#declare flare_type = "35mm"
#declare flare_size = 4;//1.8;
#declare flare_brightness = 0.2;
#include "nkflare.inc"


sky_sphere { skydome }


 /*****************************************************************************************************************
 * SCENERY *
***********/

union {
	object { ground }
	object { canyon }
}


 /*****************************************************************************************************************
 * FLYING THINGS *
*****************/

object {
	P1
	rotate P1_rot.z*z
	rotate P1_rot.x*x
	rotate P1_rot.y*y
	translate P1_pos
}

object {
	P2
	rotate P2_rot.z*z
	rotate P2_rot.x*x
	rotate P2_rot.y*y
	translate P2_pos
}




