// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.
//
#declare foot_def=array[6] { <.28,.0,-.15>,<.30,.0,.0>,<.29,.0,.17>,<-.28,.0,-.15>,<-.30,.0,-.01>,<-.29,.0,.17> }

#macro step_to(tgt_pos,dr_leg_num,lift_time,l_clock,a_pos)
  flight_spline(a_pos[dr_leg_num],<a_pos[dr_leg_num].x,a_pos[dr_leg_num].y+.1,a_pos[dr_leg_num].z>,<tgt_pos.x,tgt_pos.y+.05,tgt_pos.z>,tgt_pos,lift_time,lift_time+.18,l_clock) // +.18 secs for step duration
#end

#macro slow_step(tgt_pos,dr_leg_num,lift_time,l_clock,a_pos)
  flight_spline(a_pos[dr_leg_num],<a_pos[dr_leg_num].x,a_pos[dr_leg_num].y+.1,a_pos[dr_leg_num].z>,<tgt_pos.x,tgt_pos.y+.05,tgt_pos.z>,tgt_pos,lift_time,lift_time+.27,l_clock) // +.18 secs for step duration
#end

#macro heading_of(foot_array)
  // calculates the x,y and z angles of the bug based on the foot positions.
  //      copy foot positions, but based on land height (ie ignores the effect of lifting a foot)
  #local foot_loc=array[6] //{ <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
  #local index=0;
  #while ( index < 6 )
    #local foot_loc[index]=<foot_array[index].x,0,foot_array[index].z>;
    #local foot_loc[index]=(foot_loc[index]+foot_array[index])/2;
    #local index=index+1;
  #end
  
  #local p1_pos=( foot_loc[0]+foot_loc[3] ) / 2;
  #local p2_pos=( foot_loc[2]+foot_loc[5] ) / 2;
  #local fr_vect=p1_pos-p2_pos;
  
  #local bug_yaw=(180+180*atan2(fr_vect.x,fr_vect.z)/pi);
  #local bug_pitch=atan2(fr_vect.y,vlength(fr_vect))*130/pi;
  
            
  #local p1_pos=( foot_loc[0]+foot_loc[1]+foot_loc[2] ) / 3;
  #local p2_pos=( foot_loc[3]+foot_loc[4]+foot_loc[5] ) / 3;    
  #local lr_vect=p1_pos-p2_pos;
  
  #local bug_roll=atan2(lr_vect.y,vlength(lr_vect))*180/pi;
  
  <bug_pitch,bug_yaw,bug_roll> 
#end

#macro position_of(foot_array)
  // calculates the median of the foot positions (centre of bug)
  ( foot_array[0]+
    foot_array[1]+
    foot_array[2]+
    foot_array[3]+
    foot_array[4]+
    foot_array[5] ) / 6
#end


#declare subs_th=box { <-2,0,-2>,<2,2,2> }  
#declare subs_rh=box { <0,-2,-2>,<2,2,2> }

#declare bug_fin=finish { ambient amb_light diffuse dif_light roughness .1 specular .2 }      
#declare bug_green_hue=color rgb<.1,.5,.1>;
#declare bug_yellow_hue=color rgb<.6,.6,.1>;

#declare bug_green=texture { 
  pigment { color bug_green_hue } 
  finish { bug_fin } 
} 

#declare bug_tiger=
  texture { 
    pigment {
      spherical
      frequency 1
      color_map {
        [ 0 color rgb<.9,.9,.1> ]
        [ 0.2 color rgb<.9,.9,.1> ]
        [ 0.55 color rgb<.1,.1,.1> ]
        [ 0.555 color rgb<.9,.9,.1> ]
        [ 0.75 color rgb<.1,.1,.1> ]
        [ 0.755 color rgb<.9,.9,.1> ]
        [ 0.86 color rgb<.1,.1,.1> ]
        [ .865 color rgb<.9,.9,.1> ]
        [ 1 color rgb<.9,.9,.1> ]
      }
    }
    finish { 
      bug_fin
    }
  }
#declare bug_tiger1=
  texture {      
    pigment {
      cylindrical
      color_map {
        [ 0 color bug_green_hue ]
        [ 0.5 color bug_green_hue ]       
        [ .759 color bug_green_hue*.05 ]
        [ .76 color bug_yellow_hue ]
        [ .779 color bug_yellow_hue ]
        [ .78 color bug_green_hue*.05 ]
        [ .79 color bug_green_hue*.05 ]
        [ .80 color bug_green_hue ]
        [ 1 color bug_green_hue ]
      }
    }
    finish { 
      bug_fin
    }
  }
#declare bug_tiger2=
  texture {      
    pigment {
      cylindrical
      color_map {
        [ 0.0 color <0,0,0,1>+bug_green_hue ]
        [ 0.5 color <0,0,0,1>+bug_green_hue*.05 ]       
        [ .759 color <0,0,0,0>+bug_green_hue*.05 ]
        [ .76 color <0,0,0,0>+bug_yellow_hue ]
        [ .78 color <0,0,0,0>+bug_yellow_hue ]
        //[ .79 color <0,0,0,0>+bug_green_hue*.05]
        [ 1.0 color <0,0,0,0>+bug_green_hue*.05 ]
      }
    }
    finish { 
      bug_fin
    }
  }
#declare shell_suit=
  texture { bug_tiger1 rotate <-40,70,0> scale <.42,.4,.2>*4.5 translate <-.01,-.1,-.55> }
  texture { bug_tiger2 rotate <-60,0,-25> scale <.95,.4,.5> translate <.0,.2,.1> }

#declare abdo_tex=
  texture {
    pigment {
      cylindrical
      frequency 16
      poly_wave .8
      color_map {
        [ 0 color bug_green_hue ]
        //[ .49 color bug_green_hue*.2 ]
        //[ .51 color bug_green_hue ]
        [ 1 color bug_green_hue*.4 ]
      }
      scale 2
    }
    finish { 
      bug_fin
    }
    rotate <-45,0,0>
    translate <0,0,-.75>
  }

#declare shell_qtr=intersection {                
    sphere { 0,1 scale <.4,.2,.7> translate <.1,0,0> }
    object { subs_rh }
  }
  
#declare b_body_r=
    difference {
      object { shell_qtr texture { shell_suit } }      
      object { shell_qtr scale .95 translate <-.01,-.05,0> texture { bug_green } }
      sphere { 0,1 scale <.41,.4,.2> translate <0,-.2,-.55> texture { bug_green } }
      
      matrix < 1,0,0,
               0,1,0,
               0,.3,1,
               0,0,0 >
    }                 

#declare b_abdo_t=
  intersection {
    sphere { 0,1 scale <.42,.2,.55> translate <0,0,.1> }
    object { subs_th }
  } 

#declare b_abdo=
  union {
    object { b_abdo_t }
    object { b_abdo_t scale <1,-.5,1> }
    texture { abdo_tex }
    translate <0,.0,0> 
  } 

#macro b_body(flaps)
  union {
    object { b_body_r translate <-.15,-.15,.45> rotate<0,65*flaps,20*flaps> translate <.15,.15,-.45> rotate<15,0,0> }
    object { b_body_r scale <-1,1,1> translate <.15,-.15,.45> rotate<0,-65*flaps,-20*flaps> translate <-.15,.15,-.45> rotate<15,0,0> }
    object { b_abdo translate <0,-.05,0> }
  }
#end

#declare b_head_r=
  intersection {
    sphere { 0,1 scale <.3,.2,.2> translate <0,0,0> }
    object { subs_rh }
    matrix < 1,0,.2,
             0,1,.2,
             0,0,1,
             0,0,0 >
  }  


#macro b_eye(l_eye_r,l_eye_u,l_eye_i)
    sphere {
      0,1
      texture { 
        pigment {
          cylindrical
          rotate x*90
          color_map {
            [ 0 color rgb<1,1,1> ]
            [ .9-(l_eye_i)/2 color rgb<1,1,1> ]
            [ .9-(l_eye_i)/2+.01 color rgb<0,0,0> ]
            [ 1 color rgb<0,0,0> ]
          }
        }
        finish { 
          bug_fin
        }
      }
      rotate <l_eye_u*30+20,l_eye_r*45,0>
    }
#end
  
#declare b_head_t=
  intersection {
    union {
      object { b_head_r }
      object { b_head_r scale <-1,1,1> }
    }
    object { subs_th }
  }

#declare b_eyelid_half=
  intersection {
    sphere { 0,1 }
    object { subs_th }
  }    
//#declare b_head=
#macro b_head(bug_eye_vars,bug_head_vars,bug_eyelid_vars)
  union {
    object { b_head_t texture { bug_green } }
    object { b_head_t scale <1,-.2,1> texture { bug_green } }
    object { b_eye(bug_eye_vars.x,bug_eye_vars.y,bug_eye_vars.z) scale .075 translate <.12,.13,-.05> }
    object { b_eye(bug_eye_vars.x,bug_eye_vars.y,bug_eye_vars.z) scale .075 translate <-.12,.13,-.05> }    
    
    object { b_eyelid_half scale <.076,.076,.076>     rotate <0,-10,bug_eyelid_vars.y*30> rotate <10+(1-bug_eyelid_vars.x)*35,0,0> translate <.12,.13,-.05> texture { bug_green } }
    object { b_eyelid_half scale <.0755,-.0755,.0755> rotate <0,-10,bug_eyelid_vars.z*30> rotate <10-(1-bug_eyelid_vars.x)*30,0,0> translate <.12,.13,-.05> texture { bug_green } }
    
    object { b_eyelid_half scale <.076,.076,.076>     rotate <0,10,-bug_eyelid_vars.y*30> rotate <10+(1-bug_eyelid_vars.x)*35,0,0> translate <-.12,.13,-.05> texture { bug_green } }
    object { b_eyelid_half scale <.0755,-.0755,.0755> rotate <0,10,-bug_eyelid_vars.z*30> rotate <10-(1-bug_eyelid_vars.x)*30,0,0> translate <-.12,.13,-.05> texture { bug_green } }
    
    rotate <bug_head_vars.x*30,0,bug_head_vars.z*45>
    rotate <0,bug_head_vars.y*45,0>
  } 
#end

#macro bug_leg(p_sholder,p_ankle,p_pos,p_ang,dr_u_len,dr_l_len)
// n.b. when rotating by p_ang, strict order must be maintained: x,z,y when +ve y,z,x when -ve
  #local dr_rel_sholder=vrotate(vrotate(p_sholder,<p_ang.x,0,p_ang.z>),<0,p_ang.y,0>)+p_pos;
  #local dr_rel_ankle=y*.01+p_ankle-dr_rel_sholder; //vrotate(p_ankle,-ang)-p_sholder-p_pos; // pre adjust desired foot target to account for bug movement
  #local dr_reach=vlength(dr_rel_ankle); //vlength(vrotate(p_ankle,-ang)-(p_sholder+p_pos));
  #if (dr_reach>dr_u_len+dr_l_len-.001)
    #local dr_reach=dr_u_len+dr_l_len-.001;
    #render "Leg Reach Warning has been corrected\n"
  #else
    #if (dr_reach<dr_l_len-dr_u_len+.001)    //      largest first
      #local dr_reach=dr_l_len-dr_u_len+.001;
      #render "Leg Compression Warning - objects may impact\n"
    #end
  #end  
  #local dr_leg_yr=-degrees(atan2(dr_rel_ankle.z,dr_rel_ankle.x));
  #local dr_rel_ankle=vrotate(dr_rel_ankle,<0,-dr_leg_yr,0>);
  //#render concat("<",str(dr_rel_ankle.x,0,0),",",str(dr_rel_ankle.y,0,0),",",str(dr_rel_ankle.z,0,0),"> ")
  #local dr_leg_zr=-degrees(atan2(dr_rel_ankle.y,dr_rel_ankle.x));                                         
  
  #local dr_leg_solution=( pow(dr_reach,2) + pow(dr_l_len,2) - pow(dr_u_len,2) ) / (2*dr_reach);
      
  #local dr_v_off=sqrt( abs ( dr_l_len*dr_l_len - pow( dr_leg_solution,2) ) );

  #local dr_alpha=degrees(asin(dr_v_off/dr_u_len));                       // n.b. the shorter of these two limbs  
  #local dr_beta=degrees(asin(dr_v_off/dr_l_len));                        // will miss-calculate. use the longer        
  
  #local dr_b_node=vrotate(<dr_u_len,0,0>,<0,0,90+dr_alpha>);//<dr_reach,0,0>+vrotate(<-dr_l_len,0,0>,<0,0,-dr_beta>);
  #local dr_a_node=vrotate(<dr_u_len,0,0>,<0,0,dr_alpha>);
  #if ( abs(vlength(dr_b_node)-dr_u_len)<.02 )
    #render "B_NODE OK "
  #end
  #if ( abs(vlength(<dr_reach,0,0>-dr_a_node)-dr_l_len)<.02 )
    #render "A_NODE OK "
    #local dr_b_node=dr_a_node;
  #end
  union {
  union {
    sphere { <0,0,0>,.03 }
    cone { <0,0,0>,.03,dr_b_node,.025 }
    sphere { dr_b_node,.025 }
    cone { dr_b_node,.025,<dr_reach,0,0>,.01 }
    sphere { <dr_reach,0,0>,.01 }

    //cylinder { 0,<dr_u_len,0,0>,.2 rotate <0,0,dr_alpha> }
    //cylinder { 0,<-dr_l_len,0,0>,.2 rotate <0,0,-dr_beta> translate <dr_reach,0,0> }
    rotate <0,0,-dr_leg_zr>
    rotate <0,dr_leg_yr,0>
     
    rotate <0,-p_ang.y,0> //      n.b. strict rotation order must be maintained
    rotate <0,0,-p_ang.z>
    rotate <-p_ang.x,0,0>
    
    translate p_sholder
    }
    cone { <0,.05,0>,.05,p_sholder,.03 }
    texture { bug_green }
    
  }
  #render "\n"
#end

#macro bug_macro(bug_pos,bug_ang,bug_clock,foot_pos,bug_eye_vars,bug_eyelid_vars,bug_head_vars)
  union {
    #render "Processing Bug\n"
    #render concat("  Position <",str(bug_pos.x,0,5),",",str(bug_pos.y,0,5),",",str(bug_pos.z,0,5),">\n")
    #render concat("  Attitude <",str(bug_ang.x,0,5),",",str(bug_ang.y,0,5),",",str(bug_ang.z,0,5),">\n")
    #render "  Foot Positions:\n"
    #render concat("    Foot[0] (FL)<",str(foot_pos[0].x,0,5),",",str(foot_pos[0].y,0,5),",",str(foot_pos[0].z,0,5),">\n")
    #render concat("    Foot[1] (CL)<",str(foot_pos[1].x,0,5),",",str(foot_pos[1].y,0,5),",",str(foot_pos[1].z,0,5),">\n")
    #render concat("    Foot[2] (BL)<",str(foot_pos[2].x,0,5),",",str(foot_pos[2].y,0,5),",",str(foot_pos[2].z,0,5),">\n")
    #render concat("    Foot[3] (FR)<",str(foot_pos[3].x,0,5),",",str(foot_pos[3].y,0,5),",",str(foot_pos[3].z,0,5),">\n")
    #render concat("    Foot[4] (CR)<",str(foot_pos[4].x,0,5),",",str(foot_pos[4].y,0,5),",",str(foot_pos[4].z,0,5),">\n")
    #render concat("    Foot[5] (BR)<",str(foot_pos[5].x,0,5),",",str(foot_pos[5].y,0,5),",",str(foot_pos[5].z,0,5),">\n")
    
    object { b_body(0) scale .5 translate <0,.075,0> }             
    object { b_head(bug_eye_vars,bug_head_vars,bug_eyelid_vars) translate <0,.05,-.55> scale .5 rotate <-15,0,0> translate <0,.075,0> }
    
    object { bug_leg(<.15,0,-.11>,foot_pos[0],bug_pos,bug_ang,.15,.12) }
    object { bug_leg(<.17,0,0>,foot_pos[1],bug_pos,bug_ang,.15,.12) }
    object { bug_leg(<.16,0,.13>,foot_pos[2],bug_pos,bug_ang,.15,.12) }
    
    object { bug_leg(<-.15,0,-.11>,foot_pos[3],bug_pos,bug_ang,.15,.12) }
    object { bug_leg(<-.17,0,0>,foot_pos[4],bug_pos,bug_ang,.15,.12) }
    object { bug_leg(<-.16,0,.13>,foot_pos[5],bug_pos,bug_ang,.15,.12) }
    
    sphere { <0,.05,0>,.05 texture { bug_green } }

    #ifdef(numbers)
    text {
      ttf "c:\winnt\fonts\arial.ttf"
      str("1",0,0)
      1,0
      scale <.2,.2,.001>
      translate .25*y
      texture { pigment { color White } finish { ambient 1 diffuse 0 } }
    }
    #end
    
    rotate <bug_ang.x,0,bug_ang.z>
    rotate <0,bug_ang.y,0>
    translate bug_pos
  }
#end


