// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.
//
// T209.inc:

// T209 - the chaser
#macro ivrotate(pos,ang)
//      vrotates in opposite order (for deconstruction of coords)
  vrotate(vrotate(vrotate(pos,z*ang.z),y*ang.y),x*ang.x)
#end
#declare t209_tex=       //basic_t09_body_chrome
  texture {
    pigment {
      color rgb<.7,.7,.75>
    }
    finish {
      ambient amb_light/2
      diffuse dif_light
      brilliance 2
      metallic
      specular 0.2
      roughness .01
      reflection 0.3
    }
    normal {
      bumps .05
      scale .005
    }
  }
#declare dpm_finish=
  finish {
    ambient amb_light
    diffuse dif_light
    roughness .1
    specular .1
  }
#declare dpm_pigment=
  //pigment { color rgb<.6,.6,.65> }  //      Blue-Grey
  //pigment { color rgb<.1,.6,.2> }   //      Green
  //pigment { color rgb<.1,.4,.1> }   //      Drab Green
  //pigment { color rgb<.25,.5,.75> } //      Blue
  pigment { color rgb<.2,.5,.8> }   //      Blue
  //pigment { color rgb<.8,.4,.2> }   //      Bronze-red
  //pigment { color rgb<.9,.9,.1> }   //      Yellow (Yuck!)  
#declare dpm_underlayer=
  texture {
    pigment { dpm_pigment }
    finish { dpm_finish }
  }

#declare dpm_layer1=
  texture {
    pigment {   
      crackle
      scale .4
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ .15 color rgbt<1,1,1,1> ]
        [ .15 color rgbt<1,1,1,.6> ]
        [ .4 color rgbt<1,1,1,1> ]
        [ 1 color rgbt<1,1,1,1> ]
      }
    }
    finish { dpm_finish }
  }

#declare dpm_layer2=
  texture {
    pigment {   
      crackle
      scale .3
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ .15 color rgbt<1,1,1,1> ]
        [ .15 color rgbt<0,0,0,.7> ]
        [ .4 color rgbt<0,0,0,1> ]
        [ 1 color rgbt<0,0,0,1> ]
      }
      translate <0,0,-10>
      //rotate <-45,30,120>
    }
    finish { dpm_finish }
  }

#ifdef (quickrender)
#declare t209_tex=
  texture { dpm_underlayer }
#else
  #declare t209_tex=
  texture { dpm_underlayer }
  texture { dpm_layer1 }
  texture { dpm_layer2 }  
#end
/*
#declare t209_tex=       //basic_t09_body_chrome
  texture {
    pigment { dpm_pigment }
    finish {
      ambient amb_light/2
      diffuse dif_light
      brilliance 2
      metallic
      specular 0.2
      roughness .01
      reflection 0.3
    }
  }*/
    
#declare t209_cuttex=       //texture for 'cut' metal rather than shaped
  texture {
    pigment {
      color rgb<.5,.5,.55>
    }
    finish {
      ambient amb_light/2
      diffuse dif_light
      brilliance 1
      metallic
      specular 0.4
      roughness .005
      reflection 0.4
    }    
  }
#declare t209_legtex=
  texture { 
    pigment { color rgb<.3,.3,.3> }
    finish { 
      ambient amb_light
      diffuse dif_light
      roughness .01
      specular .5
    }
  }
#declare t209_cyltex=
  texture {
    pigment {
      color rgb<1.00, 0.875, 0.575>
    }
    finish {
      brilliance 5
      ambient amb_light
      diffuse dif_light
      reflection <1.00, 0.875, 0.575>/2
      metallic 
      specular 0.70
      roughness .001
    }    
  }
#declare t209_pistex=
  texture {
    pigment {
      color rgb<.8,.8,.8>
    }
    finish {
      ambient amb_light/2
      diffuse dif_light
      brilliance 1
      metallic
      specular 0.4
      roughness .005
      reflection 0.6
    }    
  }
#declare t209_black_met=
  texture { 
    pigment { color rgb<.2,.2,.2> }
    finish { 
      ambient amb_light
      diffuse dif_light
      roughness .001
      specular .9
    }
  }

#declare eye_rotate=<0,0,0>;

//------------------------------------------------
#declare head_full=
  intersection {
    blob {
      threshold .5
      sphere { 0,2,1 }
      sphere { 0,2,1 scale .5 translate <.3,.28,.0> }
      sphere { 0,2,1 scale .5 translate <-.3,.28,.0> }
            
      sphere { 0,1,.15 scale <.35,.25,.25> translate <0,.46,.76> }
      
      cylinder { <-.6,.9,.55>,<.6,.9,.55>,.52,.1 }
      cylinder { <-.4,.43,.52>,<.4,.43,.52>,.52,-.45 }
                 
      translate <0,0,-.6>
    }
    box { <-2,-2,-1>,<2,2,2> rotate <0,10,0> }
    box { <-2,-2,-1>,<2,2,2> rotate <0,-10,0> }
  }
  
#declare visor_obj=
  intersection {
    sphere { 0,1 }
    box { <-1.1,0,-1.1>,<1.1,1.1,.75> }
      
    scale <.85,.5,1>
    translate <0,.25,0>
    rotate <35,0,0>
    translate <0,0,-.7>
  }

#declare eyeless_head=
  difference {
    union {
      intersection { object { head_full } box { <-2,0,-2>,<2,2,2> } }
      intersection { object { head_full } box { <-2,0,-2>,<2,-2,2> } scale <1,.5,1> }
      matrix < 1, 0, 0,
               0, 1, -.25,
               0, 0, 1,
               0, 0, -.2 >
      scale <1,.9,1.5>
    }
    object { visor_obj translate <0,-.001,-.001> }
  }

#declare eye_tex=
  texture {
    pigment {
      cylindrical rotate x*90
      rotate eye_rotate
      pigment_map {
        [ 0.00 color rgbt<.2,.1,.1,1> ]
        [ 0.95 color rgbt<.2,.1,.1,1> ]
        [ 0.96 color rgbt<1,.2,.2,0> ]
        [ 1.00 color rgbt<1,.2,.2,0> ]
      }        
    }
    finish { ambient amb_light diffuse dif_light roughness .001 specular .9 }
  }     
      
#declare visor=
  object { visor_obj
    
    texture { 
      pigment { color rgb<.1,.1,.1> }
      finish { ambient amb_light diffuse dif_light roughness .001 specular .9 }
    }
    texture { eye_tex translate <.45,.45,0> }
    texture { eye_tex translate <-.45,.45,0> }
  }
      
#declare head=
  union {
    object { eyeless_head }
    object { visor }
      
    scale <.85,1,1>
    scale .3 
    texture { t209_tex }
    translate <0,-.025,.2>
    
    rotate <0,0,0>  // head rotate
     
  }
//------------------------------------------------

#declare tail_spike=
  intersection {
    difference {
      torus { 1.2,.2 rotate <0,0,90> scale <.3,1,1> translate <0,0,-.15> }
      torus { 1.1,.6 rotate <0,0,90> translate <.55,-.1,.25> scale <2,1,1> texture { t209_cuttex } }
      torus { 1.1,.6 rotate <0,0,90> translate <-.55,-.1,.25> scale <2,1,1> texture { t209_cuttex } }
    }
    box { <-.4,-.1,0>,<.4,1.1,1.2> }
    translate <0,0,-1>
    scale <1,2,1>
  }
#declare tail_seg_quarter=
  intersection {
    sphere { 0,1 }
    box { <0,0,-1.1>,<1.1,1.1,.6> }
    box { <-.1,-.1,-.3>,<2,2,2> rotate <0,-10,0> }
    matrix < 1, 0, 0,
             0, 1, -.25,
             0, 0, 1,
             0, 0, -.2 >
    scale <1,1,2>
  }
#declare tail_seg_top=
  union {
    object { tail_seg_quarter }
    object { tail_seg_quarter scale <-1,1,1> }
  }
#declare tail_seg=
  union {
    object { tail_seg_top scale <1,1,1> }
    object { tail_seg_top scale <1,-.75,1> }
  }
#declare tail_tip_quarter=
  intersection {
    sphere { 0,1 }
    box { <0,0,-1.1>,<1.1,1.1,1.1> }
    matrix < 1, 0, 0,
             0, 1, 0,
             0, 0, 1,
             0, 0, -.3 >
    scale <1,1,2>
  }
#declare tail_tip_top=
  union {
    object { tail_tip_quarter }
    object { tail_tip_quarter scale <-1,1,1> }
  }
#declare tail_tip=
  union {
    object { tail_tip_top scale <1,1,1> }
    object { tail_tip_top scale <1,-.75,1> }
  }




#declare side_vent=box { <0,-.01,-.7>,<.75,.015,.7> rotate <0,0,-20> translate <.25,0,0> texture { t209_black_met } }
#declare front_vent=box { <-.85,-1.1,-.05>,<.85,-.8,.05> texture { t209_black_met } }
#declare lower_leg_bracket=
  union {
    cylinder { <-.01,0,0>,<.01,0,0>,.07 }
    box { <-.01,0,-.07>,<.01,.16,.07> rotate <90,0,0> }
    box { <-.01,0,-.07>,<.01,.4,.07> rotate <160,0,0> }
    texture { t209_tex }
  }






#macro piston(thick_end,thin_end,thick_start,thick_len,thick,thin)
  #local oe=thin_end-thick_end;
  #local te=vnormalize(oe)*thick_len;
  union {
    cylinder { 0,oe,thin texture { t209_pistex } }
    cylinder { te*thick_start,te,thick texture { t209_cyltex } }
    sphere { 0,thin+thick/2 texture { t209_black_met } }
    sphere { oe,thin+thick/2 texture { t209_black_met } } 
    translate thick_end
  }
#end

#declare upper_leg=     //      upper leg is built from the sholder @ 0,0,0 direction up (knee @ +y)
  union {
    difference {
      union {
        intersection {
          #ifdef (quickrender)
            box { -1,1 }
          #else
            superellipsoid { <.25,.45> }
          #end
          box { <0,0,-1.1>,<3,-1.1,1.1> rotate <0,0,-6> translate <-1.1,.1,0> }
        }
        #ifdef (quickrender)
          box { -1,1 scale <.9,.3,.9> translate <0,.1,0> 
        #else
          superellipsoid { <.25,.45> scale <.9,.3,.9> translate <0,.1,0> 
        #end
          matrix < 1,-.05,0,
                   0,1,0,
                   0,0,1,
                   0,0,0> 
          
        }
      }
      #ifdef (quickrender)
        box { -1,1 scale <.65,1,.65> translate <0,.2,0> texture { t209_legtex} }
      #else
        superellipsoid { <.25,.45> scale <.65,1,.65> translate <0,.2,0> texture { t209_legtex} }
      #end

      object { side_vent translate <.5,-.20,0> }
      object { side_vent translate <.5,-.25,0> }
      object { side_vent translate <.5,-.30,0> }
      object { side_vent translate <.5,-.35,0> }
      object { side_vent translate <.5,-.40,0> }
      object { side_vent translate <.5,-.45,0> }
      
      object { front_vent translate <0,0,-.4> }
      object { front_vent translate <0,0,-.2> }
      object { front_vent translate <0,0,0> }
      object { front_vent translate <0,0,.2> }
      object { front_vent translate <0,0,.4> }
      object { front_vent translate <0,0,.6> }
      
      scale <.15,.7,.17>
      rotate <10,0,0>
      translate <0,.5,.15>    
      matrix < 1, 0, 0,
               0, 1, 0,
               0, .5, 1,
               0, 0, 0 >
    }
    difference {
      cone { <0,0,0>,1,<0,-3,0>,.5 }
      cone { <0,0,0>,1,<0,-3,0>,.5 translate <0,.1,0> }
      texture { pigment { color rgb<.2,.2,.2> } finish { ambient amb_light diffuse dif_light roughness .1 specular .4 } }
      scale .1
      translate <0,.9,.18>
    }
    cylinder { <-.105,.75,0>,<.105,.75,0>,.03 texture { t209_legtex } }
    cone { <-.105,.75,0>,.03,<-.110,.75,0>,.025 texture { t209_legtex } }
    cone { <.105,.75,0>,.03,<.110,.75,0>,.025 texture { t209_legtex } }
    
    object { lower_leg_bracket translate <-.092,.75,0> }
    object { lower_leg_bracket translate <.092,.75,0> }
    texture { t209_tex }
  }
    
#declare lower_leg=     //      upper leg is built from the knee @ 0,0,0 direction down (ankle @ -y)
  difference {
    union {
      #ifdef (quickrender)
        object { box { -1,1 } scale <.08,.55,.06> translate <0,-.5,0> rotate <-1.5,0,0> }
      #else
        superellipsoid { <.4,.2> rotate <90,0,0> scale <.08,.55,.06> translate <0,-.5,0> rotate <-1.5,0,0> }
      #end
      sphere { <0,-1,0>,.1 }
    }
    box { <-1,-1,-1>,<1,1,0> rotate <-45,-5,0> translate <0,-1,.035> }
    texture { t209_tex }
  }

#declare half_toe=
  intersection {
    box { -1,1
      matrix < 1,0,0,
               0,1,-.1,
               -.25,-.8,1,
               0,0,0  >
      scale <.065,.05,.11>
      translate <0,.05,0>
    }
    box { <0,0,-1>,<1,1,1> }
    box { <0,-1,-.02>,<1,1,1> rotate <20,0,0> }
    translate <0,-.05,0>
  }
#declare half_front_toe=
  intersection {
    superellipsoid { <.2,.4>
      matrix < 1,0,0,
               0,1,-.1,
               -.2,-.8,1,
               0,0,0  >
      scale <.065,.05,.2>
      translate <0,.05,0>
    }
    box { <0,0,-1>,<1,1,1> }
    box { <0,-1,-.02>,<1,1,1> rotate <20,0,0> }
    translate <0,-.05,0>
  }  
#declare full_toe=
  union {
    difference {
      union {
        object { half_toe scale < 1,1,1> }
        object { half_toe scale <-1,1,1> }
      }
      cylinder { <-.04,0,0>,<.04,0,0>,.05 }
    }
    cylinder { <-.06,0,0>,<.06,0,0>,.025 texture { t209_legtex } }
    scale <1,.8,1>    
  }
#declare full_front_toe=
  union {
    difference {
      union {
        object { half_front_toe scale < 1,1,1> }
        object { half_front_toe scale <-1,1,1> }
      }
      box { <-.05,0,-.1>,<.05,-.1,.1> }
    }
    cylinder { <-.062,0,0>,<.062,0,0>,.025 texture { t209_legtex } } 
    texture { t209_tex } 
  }
#declare toe_plate=
  union {
    box { <-.04,0.04,0>,<.04,-.04,-.15> }
    cylinder { <-.04,0,0>,<.04,0,0>,.04 }
    translate <0,-.08,0>
    texture { t209_tex }    
  }
#macro toe(ang,tex_jitter)
  union {
    object { full_front_toe scale <1,1,1> texture { t209_tex translate tex_jitter rotate tex_jitter } rotate <135*ang,0,0> translate <0,-.02,.12> rotate <45*ang,0,0> }
    object { full_toe texture { t209_tex translate tex_jitter*2 rotate tex_jitter } rotate <45*ang,0,0> }
    translate <0,-.08,0>
    texture { t209_tex }
  }
#end  
#macro foot_plate(foot_open,lr,foot_ang,foot_pos)
  union {
    object { toe(foot_open,1+5*lr) rotate <0,180,0> translate <0,0,-.15> }
    object { toe(foot_open,2+5*lr) scale <.8,1,1> translate <0,0,.11> rotate <0,35,0> translate < .03,0,0> }
    object { toe(foot_open,3+5*lr) scale <.8,1,1> translate <0,0,.11> rotate <0,-35,0> translate <-.03,0,0> }
    cone { <0,-.03,0>,.098,<0,-.1,0>,.085 texture { t209_tex } } 
    object { toe_plate rotate <0,180,0> translate <0,0,-.15> }
    object { toe_plate translate <0,0,.11> rotate <0, 35,0> translate < .03,0,0> }
    object { toe_plate translate <0,0,.11> rotate <0,-35,0> translate <-.03,0,0> }
    sphere { 0,.09 texture { t209_legtex } }
    #if (lr=0)
      scale <-1,1,1>
    #end
    rotate <0,foot_ang.y,0>
    rotate <foot_ang.x,0,foot_ang.z>
    translate foot_pos
  }
#end

#macro mac_tail(c_tail,c_spine,c_head)
  #local rnd=seed(10);
  union {
    #local cog_segment=0;
    #local head_end=-2;
    #local tail_end=20;
    #local te=head_end;
    #local hip_segment=0;
    #local sholder_segment=head_end+1;
    #local tp=<0,0,0>;
    #while (te<=tail_end)
      #local lp=tp;
      #local tr=(flight_spline(.27,.27,.26,.25,head_end,0,te));
      #local tr=(flight_spline(tr,.15,.07,.05,0,tail_end,te));
      #local ta=c_tail[0]+(flight_spline(c_head,c_head*2/3,c_head/3,c_tail[0],head_end,0,te)); //<0,0,0>,head_end,0,te));
      #local ta=(flight_spline(ta,c_tail[1],c_tail[2],c_tail[3],0,tail_end,te));
      #local tss=tr*(flight_spline(.8,3,1.5,-.05,head_end+1,-head_end+3,te));
      #local tsa=(flight_spline(c_spine[0],c_spine[1],c_spine[2],c_spine[3],0,6,te));
      #local tp=lp+vrotate(<0,0,-tr>,ta);  
      
      #if (te>head_end & tss>0)
        object { tail_spike scale tss texture { t209_tex } rotate tsa rotate ta translate vrotate(<0,.95,-1>*tr,ta) translate lp }
        //cylinder { <-1,0,0>,<1,0,0>,.01 translate vrotate(<0,.95,-.8>*tr,ta) translate lp } // axis - for alignment purposes
      #end
      #if (te<=hip_segment)
        #declare hip_ang=ta;
        #declare hip_pos=lp+vrotate(<0,0,-.1>,ta);//-<0,0,.1>;
      #end
      #if (te<=cog_segment)
        #declare cog_ang=ta;
        #declare cog_pos=lp+vrotate(<0,0,-.1>,ta);//-<0,0,.1>;
      #end
      #if (te<=sholder_segment)
        #declare sho_ang=ta;
        #declare sho_pos=lp+vrotate(<0,0,-.1>,ta);//-<0,0,.1>;
      #end
      #if (te=head_end)
        object { head rotate ta translate lp }
      #else         
        object { tail_seg scale tr texture { t209_tex translate <rand(rnd),rand(rnd),rand(rnd)>*10 } rotate ta translate lp }
      #end

      #local te=te+1;
    #end
    object { tail_tip scale tr*.85 rotate ta translate lp }
    sphere { lp,tr }
    //cylinder { <-.5,0,0>,<.5,0,0>,.075 rotate hip_ang translate hip_pos }
    texture { t209_tex }
    #declare hip_pos=hip_pos-cog_pos;
    #declare sho_pos=sho_pos-cog_pos;
  }
#end
#declare gaiterspline=union {
    cone { <-.025,0,0>,.05,<0,0,0>,.1 }
    cone { <.025,0,0>,.05,<0,0,0>,.1 }
  }
#macro gaitor(p1,p2,a1,a2,r,c)
  union {
  #local gc=0;
  #while (gc<=1)
    #local gp=p1+(p2-p1)*gc;
    #local ga=(flight_spline(a1,a1,a2,a2,0,1,gc));  
    object { gaiterspline scale r rotate ga translate gp }
    #local gc=gc+(1/c);
  #end
    texture { pigment { color rgb<.3,.3,.3> } finish { ambient amb_light diffuse dif_light roughness .01 specular .5 } }
  }
#end

#declare upper_arm=     //      upper arm is built from the sholder @ 0,0,0 direction up (elbow @ +y)
  object {
    difference {
      #ifdef (quickrender)
        box { -1,1 rotate <90,0,0> scale <.05,.275,.04> translate <0,.25,0> }
      #else
        superellipsoid { <.4,.2> rotate <90,0,0> scale <.05,.275,.04> translate <0,.25,0> }
      #end
      cylinder { <-.035,0,0>,<.035,0,0>,.075 translate <0,.5,0> }
    }
    texture { t209_tex }                                                                     
  }

#declare lower_arm=     //      lower armis built from the elbow @ 0,0,0 direction down (ankle @ -y)
  union {
    #ifdef (quickrender)
      box { -1,1 rotate <90,0,0> scale <.035,.275,.03> translate <0,.25,0> rotate <-10,0,0> translate <0,-.5,0> }
      box { -1,1 rotate <90,0,0> scale <.035,.075,.03> translate <0,-.035,0> rotate <90,0,0> }        
    #else
      superellipsoid { <.4,.2> rotate <90,0,0> scale <.035,.275,.03> translate <0,.25,0> rotate <-10,0,0> translate <0,-.5,0> }
      superellipsoid { <.4,.2> rotate <90,0,0> scale <.035,.075,.03> translate <0,-.035,0> rotate <90,0,0> }        
    #end
    texture { t209_tex }
  }
#macro finger(ang,tex_jitter)
  union {
    object { full_front_toe scale .5 texture { t209_tex translate tex_jitter rotate tex_jitter } rotate <135*ang,0,0> translate <0,-.01,.06> rotate <45*ang,0,0> }
    object { full_toe scale .5 texture { t209_tex translate tex_jitter*2 rotate tex_jitter } rotate <45*ang,0,0> }
    translate <0,-.04,0>
    texture { t209_tex }
  }
#end  
#macro hand_const(hand_clos,lr,hand_ang,hand_pos)
  union {
    object { finger(hand_clos.y,1+5*lr) rotate <0,180,0> translate <0,0,-.075> }
    object { finger(hand_clos.z,2+5*lr) scale <.8,1,1> translate <0,0,.055> rotate <0,35,0> translate < .015,0,0> }
    object { finger(hand_clos.x,3+5*lr) scale <.8,1,1> translate <0,0,.055> rotate <0,-35,0> translate <-.015,0,0> }
    cone { <0,-.015,0>,.049,<0,-.05,0>,.0425 texture { t209_tex } } 
    object { toe_plate scale .5 rotate <0,180,0> translate <0,0,-.075> }
    object { toe_plate scale .5 translate <0,0,.055> rotate <0, 35,0> translate < .015,0,0> }
    object { toe_plate scale .5 translate <0,0,.055> rotate <0,-35,0> translate <-.015,0,0> }
    sphere { 0,.09 scale .5 texture { t209_legtex } }
    #if (lr=0)
      scale <-1,1,1>
    #end
    rotate <0,hand_ang.y,0>
    rotate <hand_ang.x,0,hand_ang.z>
    translate hand_pos
  }
#end


#macro charlton(c_pos,c_ang,c_tail,c_spine,c_head,c_feet,c_afeet,c_f_open,c_arm_flag,c_h_pos,c_h_ang,c_h_open)
  
  union {

    object { mac_tail(c_tail,c_spine,c_head) translate -cog_pos }//rotate <0,-cog_ang.y,0> }
    
//  New Arm Calcs  
    #local l_elbow_out=<0,0,0>;
    #local r_elbow_out=<0,0,0>;
     
    #local l_sho=vrotate(<-.2,-.18,0>,sho_ang)+sho_pos;
    #local r_sho=vrotate(<.2,-.18,0>,sho_ang)+sho_pos;
    
    cylinder { l_sho,r_sho,.05 texture { t209_tex } }
    
    #local l_wrist=vrotate(c_h_pos[0]-c_pos+vrotate(y*.075,c_h_ang[0]),-c_ang)-l_sho;
    #local r_wrist=vrotate(c_h_pos[1]-c_pos+vrotate(y*.075,c_h_ang[1]),-c_ang)-r_sho;
    
    #local l_wrist=ivrotate(l_wrist,-sho_ang);
    #local r_wrist=ivrotate(r_wrist,-sho_ang);

    #local l_s_wri=vrotate(<0,-.1,0>,sho_ang);
    #local r_s_wri=vrotate(<0,-.1,0>,sho_ang);
    #local l_wrist=(flight_spline(l_wrist,l_wrist,l_s_wri,l_s_wri,0,1,c_arm_flag[0]));
    #local r_wrist=(flight_spline(r_wrist,r_wrist,r_s_wri,r_s_wri,0,1,c_arm_flag[1]));
            
    #local l_wrist=ivrotate(l_wrist,-l_elbow_out);
    #local r_wrist=ivrotate(r_wrist,-r_elbow_out);
    
    #local t_l_wri=-l_wrist;                                     // set up temp vars as this is
    #local t_r_wri=-r_wrist;                                     // a 'destructive' calculation
    
    #local l_sho_z=-degrees(atan2(t_l_wri.x,t_l_wri.y));        // calc outward angle at hip
    #local r_sho_z=-degrees(atan2(t_r_wri.x,t_r_wri.y));        // ie legs apart/legs together
    
    #local t_l_wri=vrotate(t_l_wri,<0,0,-l_sho_z>);             // adjust temp vars to account
    #local t_r_wri=vrotate(t_r_wri,<0,0,-r_sho_z>);             // for outward hip
    
    #local l_sw_x=degrees(atan2(t_l_wri.z,t_l_wri.y));          // calc angle between hip
    #local r_sw_x=degrees(atan2(t_r_wri.z,t_r_wri.y));          // and angle (adjusted vars)
    
    #local t_l_wri=vrotate(t_l_wri,<l_sw_x,0,0>);               // adjust again
    #local t_r_wri=vrotate(t_r_wri,<r_sw_x,0,0>);
    
    // t_l_wri should now lie directly below the shoulder pivot; the          
    // angles to acheive this position are known ( <l_sw_x,0,l_sho_z> ) 
        
    #local l_reach=vlength(t_l_wri);
    #local r_reach=vlength(t_r_wri);
    
    #if (l_reach>.98)
      #render "arm reach corrected (left)\n" 
      #local l_reach=.98;
    #else
      #if(l_reach<.1)
        #render "arm compression error (left)\n"
        #local l_reach=.1;
      #end
    #end
    #if (r_reach>.98)
      #render "arm reach corrected (right)\n" 
      #local r_reach=.98;
    #else
      #if(r_reach<.1)
        #render "arm compression error (right)\n"
        #local r_reach=.1;
      #end
    #end
    #render concat("arm reach =",str(l_reach,0,5)," (left)\n")
    #render concat("arm reach =",str(r_reach,0,5)," (right)\n")
    
    #local l_lower_s=( l_reach*l_reach + .5*.5 - .5*.5 ) / ( 2*l_reach );       // use the one that matches the longer limb
    #local l_upper_s=( l_reach*l_reach - .5*.5 + .5*.5 ) / ( 2*l_reach );       // in this case, lower.      

    #local r_lower_s=( r_reach*r_reach + .5*.5 - .5*.5 ) / ( 2*r_reach );       // use the one that matches the longer limb
    #local r_upper_s=( r_reach*r_reach - .5*.5 + .5*.5 ) / ( 2*r_reach );       // in this case, lower.      

    #local l_elbow_ax=-degrees(acos(l_lower_s/.5))+l_sw_x;
    #local l_sho_ax=-180+degrees(acos((l_reach-l_lower_s)/.5));
    
    #local r_elbow_ax=-degrees(acos(r_lower_s/.5))+r_sw_x;
    #local r_sho_ax=-180+degrees(acos((r_reach-r_lower_s)/.5));


    #local l_wrist=vrotate(<0,.5,0>,<l_sw_x+l_sho_ax,0,0>);
    #local l_wrist=l_wrist+vrotate(<0,-.5,0>,<l_elbow_ax,0,0>);
    #local l_wrist=vrotate(l_wrist,<0,0,l_sho_z>);
    #local l_wrist=vrotate(l_wrist,l_elbow_out);
    #local l_wrist=vrotate(l_wrist,sho_ang)+l_sho;
    
    #local r_wrist=vrotate(<0,.5,0>,<r_sw_x+r_sho_ax,0,0>);
    #local r_wrist=r_wrist+vrotate(<0,-.5,0>,<r_elbow_ax,0,0>);
    #local r_wrist=vrotate(r_wrist,<0,0,r_sho_z>);
    #local r_wrist=vrotate(r_wrist,r_elbow_out);
    #local r_wrist=vrotate(r_wrist,sho_ang)+r_sho;
    
    #local l_wrist_a=<l_elbow_ax,0,l_sho_z>;
    #local r_wrist_a=<r_elbow_ax,0,r_sho_z>;
    
    #local l_hand_a=c_h_ang[0]-c_ang*y;
    #local r_hand_a=c_h_ang[1]-c_ang*y;
    
    object { upper_arm scale <-1,1,1> rotate <l_sw_x+l_sho_ax,0,l_sho_z> rotate l_elbow_out rotate sho_ang translate l_sho }
    object { upper_arm scale < 1,1,1> rotate <r_sw_x+r_sho_ax,0,r_sho_z> rotate r_elbow_out rotate sho_ang translate r_sho }
    object { lower_arm scale < 1,1,1> rotate <l_elbow_ax,0,0> translate vrotate(<0,.5,0>,<l_sw_x+l_sho_ax,0,0>) rotate <0,0,l_sho_z> rotate l_elbow_out rotate sho_ang translate l_sho }
    object { lower_arm scale <-1,1,1> rotate <r_elbow_ax,0,0> translate vrotate(<0,.5,0>,<r_sw_x+r_sho_ax,0,0>) rotate <0,0,r_sho_z> rotate r_elbow_out rotate sho_ang translate r_sho }
    hand_const(c_h_open[0],0,l_hand_a,l_wrist)
    hand_const(c_h_open[1],1,r_hand_a,r_wrist)//c_h_open[1],1,r_hand_a,r_wrist)

  
    #local l_knee_out=<0,5,0>;
    #local r_knee_out=<0,-5,0>;
     
    #local l_hip=vrotate(<-.5,0,0>,hip_ang)+hip_pos;
    #local r_hip=vrotate(<.5,0,0>,hip_ang)+hip_pos;
    
    #local l_ankle=vrotate(c_feet[0]-c_pos+vrotate(y*.15,c_afeet[0]),-c_ang)-l_hip;
    #local r_ankle=vrotate(c_feet[1]-c_pos+vrotate(y*.15,c_afeet[1]),-c_ang)-r_hip;

    #local l_ankle=ivrotate(l_ankle,-hip_ang);
    #local r_ankle=ivrotate(r_ankle,-hip_ang);
        
    #local l_ankle=ivrotate(l_ankle,-l_knee_out);
    #local r_ankle=ivrotate(r_ankle,-r_knee_out);
        
    #local t_l_ank=-l_ankle;                                     // set up temp vars as this is
    #local t_r_ank=-r_ankle;                                     // a 'destructive' calculation
    
    #local l_hip_z=-degrees(atan2(t_l_ank.x,t_l_ank.y));        // calc outward angle at hip
    #local r_hip_z=-degrees(atan2(t_r_ank.x,t_r_ank.y));        // ie legs apart/legs together
    
    #local t_l_ank=vrotate(t_l_ank,<0,0,-l_hip_z>);             // adjust temp vars to account
    #local t_r_ank=vrotate(t_r_ank,<0,0,-r_hip_z>);             // for outward hip
    
    #local l_ha_x=degrees(atan2(t_l_ank.z,t_l_ank.y));          // calc angle between hip
    #local r_ha_x=degrees(atan2(t_r_ank.z,t_r_ank.y));          // and angle (adjusted vars)
    
    #local t_l_ank=vrotate(t_l_ank,<l_ha_x,0,0>);               // adjust again
    #local t_r_ank=vrotate(t_r_ank,<r_ha_x,0,0>);
    
    // t_l_ank should now lie directly below the hip pivot; the          
    // angles to acheive this position are known ( <l_ha_x,0,l_hip_z> ) 
    
    #local l_reach=vlength(t_l_ank);
    #local r_reach=vlength(t_r_ank);
    
    #if (l_reach>1.74)
      #render "leg reach corrected (left)\n" 
      #local l_reach=1.74;
    #else
      #if(l_reach<.26)
        #render "leg compression error (left)\n"
        #local l_reach=.26;
      #end
    #end
    #if (r_reach>1.74)
      #render "leg reach corrected (right)\n" 
      #local r_reach=1.74;
    #else
      #if(r_reach<.26)
        #render "leg compression error (right)\n"
        #local r_reach=.26;
      #end
    #end
    #render concat("leg reach =",str(l_reach,0,5)," (left)\n")
    #render concat("leg reach =",str(r_reach,0,5)," (right)\n")
    
    #local l_lower_s=( l_reach*l_reach + 1*1 - .75*.75 ) / ( 2*l_reach );       // use the one that matches the longer limb
    #local l_upper_s=( l_reach*l_reach - 1*1 + .75*.75 ) / ( 2*l_reach );       // in this case, lower.      

    #local r_lower_s=( r_reach*r_reach + 1*1 - .75*.75 ) / ( 2*r_reach );       // use the one that matches the longer limb
    #local r_upper_s=( r_reach*r_reach - 1*1 + .75*.75 ) / ( 2*r_reach );       // in this case, lower.      

    #local l_knee_ax=-degrees(acos(l_lower_s/1))+l_ha_x;
    #local l_hip_ax=-180+degrees(acos((l_reach-l_lower_s)/.75));
    
    #local r_knee_ax=-degrees(acos(r_lower_s/1))+r_ha_x;
    #local r_hip_ax=-180+degrees(acos((r_reach-r_lower_s)/.75));


    #local l_ankle=vrotate(<0,.75,0>,<l_ha_x+l_hip_ax,0,0>);
    #local l_ankle=l_ankle+vrotate(<0,-1,0>,<l_knee_ax,0,0>);
    #local l_ankle=vrotate(l_ankle,<0,0,l_hip_z>);
    #local l_ankle=vrotate(l_ankle,l_knee_out);
    #local l_ankle=vrotate(l_ankle,hip_ang)+l_hip;
    
    #local r_ankle=vrotate(<0,.75,0>,<r_ha_x+r_hip_ax,0,0>);
    #local r_ankle=r_ankle+vrotate(<0,-1,0>,<r_knee_ax,0,0>);
    #local r_ankle=vrotate(r_ankle,<0,0,r_hip_z>);
    #local r_ankle=vrotate(r_ankle,r_knee_out);
    #local r_ankle=vrotate(r_ankle,hip_ang)+r_hip;
   
    #local l_ankle_a=<l_knee_ax,0,l_hip_z>;
    #local r_ankle_a=<r_knee_ax,0,r_hip_z>;
    
    #local l_foot_a=c_afeet[0]-c_ang*y;
    #local r_foot_a=c_afeet[1]-c_ang*y;

#render "Chrome Z_Axis adjusters\n"
#render "Hip: "
#render concat ("<",str(l_hip.x,0,5),",",str(l_hip.y,0,5),",",str(l_hip.z,0,5),">")
#render "(L) ,"
#render concat ("<",str(r_hip.x,0,5),",",str(r_hip.y,0,5),",",str(r_hip.z,0,5),">")
#render "(R)\n"
#render "Ankle: "
#render concat ("<",str(l_ankle.x,0,5),",",str(l_ankle.y,0,5),",",str(l_ankle.z,0,5),">")
#render "(L) ,"
#render concat ("<",str(r_ankle.x,0,5),",",str(r_ankle.y,0,5),",",str(r_ankle.z,0,5),">")
#render "(R)\n"
    
    //gaitor ( vrotate(<-.25,0,0>,hip_ang)+hip_pos,vrotate(<0.15,0,0>,<0,0,l_hip_z>)+l_hip,hip_ang,<0,0,l_hip_z>,1,5)
    gaitor ( vrotate(<-.25,0,0>,hip_ang)+hip_pos,vrotate(<0.15,0,0>,<0,0,l_hip_z>+hip_ang)+l_hip,hip_ang,<0,0,l_hip_z>+l_knee_out,1,5)
    gaitor ( vrotate(<0.25,0,0>,hip_ang)+hip_pos,vrotate(<-.15,0,0>,<0,0,r_hip_z>+hip_ang)+r_hip,hip_ang,<0,0,r_hip_z>+r_knee_out,1,5)      
               
    object { upper_leg scale <-1,1,1> rotate <l_ha_x+l_hip_ax,0,l_hip_z> rotate l_knee_out rotate hip_ang translate l_hip }
    object { upper_leg scale < 1,1,1> rotate <r_ha_x+r_hip_ax,0,r_hip_z> rotate r_knee_out rotate hip_ang translate r_hip }
    object { lower_leg scale < 1,1,1> rotate <l_knee_ax,0,0> translate vrotate(<0,.75,0>,<l_ha_x+l_hip_ax,0,0>) rotate <0,0,l_hip_z> rotate l_knee_out rotate hip_ang translate l_hip }
    object { lower_leg scale <-1,1,1> rotate <r_knee_ax,0,0> translate vrotate(<0,.75,0>,<r_ha_x+r_hip_ax,0,0>) rotate <0,0,r_hip_z> rotate r_knee_out rotate hip_ang translate r_hip }
    foot_plate(c_f_open[0],0,l_foot_a,l_ankle)
    foot_plate(c_f_open[1],1,r_foot_a,r_ankle)

    //rotate <0,c_ang.y,0>
    //rotate <c_ang.x,0,c_ang.z>
    rotate c_ang
    translate c_pos

#render concat ("Absolute Pos <",str(c_pos.x,0,5),",",str(c_pos.y,0,5),",",str(c_pos.z,0,5),">\n")
  }
#end