// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.
//

/*

Some notes to those who might want to tinker in the POV files:

I guess you're probably looking for Charlton (he's in the file CHARLTON.INC)
I make no appologies for my POV code being a bit unreadable - 3 months is not
a long time to create such a creature, and I havn't had time to re-write
Charlton - this is effectively Beta-test POV source!

Making Charlton walk is a bit of a black-art in itself, but the following
might help:

A loop is run in this file, this loop runs from 0 up to the current value
of the clock variable and is used to 'step' Charlton's variables through
their key-points (actually, the loop starts at -2, but this is just to make
sure Charlton has 'settled' for the first frame of the anim.)

For any frame, three key-points must be calculated:
  t_foot (target position for the foot to be moved)
  l_foot (source position for the foot to be moved)
  o_foot (stationary position for the foot not being moved)

c_pos is the position of Charlton's centre of gravity (COG); for any step it
starts at the current COG position (half way between l_foot and o_foot) with
an initial velocity in the direction of o_foot (the foot which is not
moving). The final position of c_pos will be half-way between o_foor and
t_foot, with a velocity away from o_foot.

his gives a comfortable looking 'wobble' to Charlton's step, and also ensures
that his COG pre-empts his movement - ie he will lean toward his intended
motion.

The motion_bob value cleans up this COG motion by causing him to bob up and
down slightly with each step. To finish off the illusion, the motion_lean
spline dictates how much Charlton leans his hips (and hence twists his spine)
with each step.

As Charlton speeds up his walk, the SR, ST, and FS variables come into play.
FS adjusts his foot spread as he walks - FS=1 will cause him to place his
feet 0.5 units out from his COG (makes him wobble sideways more) FS=0 causes
him to walk one-foot in front of the other (more comfortable look to his
walk, but he cannot stop when FS=0 as this would reslult in him placing his
feet on top of each other) ST is the step-time (time between steps - .5 =
half a second per step) SR is the step ratio - as Charlton makes the
transition into a run, it is necessary to reduce the amount of time his feet
remain in contact with the floor. the SR variable does this - SR=0
(theoretically impossible) both feet remain on the floor at all times (i.e.
he picks up and moves his foot v.v.fast) SR=.5 means 50% of the time, his
foot is in the air. SR=1 will cause him to try and keep both feet off the
floor at all times (imagine him stood on a hot-plate)


*/

#declare main_run=on;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "metals.inc"

global_settings {
  assumed_gamma 1.6
  max_intersections 350
  max_trace_level 350
}

#declare pen_light=.2;
#declare amb_light=.15;
#declare dif_light=.85;

//#declare quickrender=on;
//#declare bowl_off=on;

#if (clock<=60)
  #declare scene_clock=clock;
#else
  #declare scene_clock=60;
#end



#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#declare sky_color=
  texture {
    pigment {
      gradient y
      color_map {
        [ 0 MidnightBlue*.2 ]
        [ 1 color <.4,.6,.8> ]
      }
    }
    finish {
      ambient 1
    }
  }

#declare sky_cloud=
  texture {
    pigment {
      bozo
      turbulence .2
      lambda 1.5
      omega .85
      octaves 11
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.4 color rgbt<1,1,1,1> ]
        [ 0.8 color rgbt<1,1,1,.5> ]
        [ 2 color rgbt<1,1,1,0> ]
      }
    }
    finish {
      ambient 1
    }
    scale <.5,.05,.5>
    scale .25
    rotate <0,-40,0>
  }


object {
  sphere { <0,0,0> 1 inverse  }
  texture { sky_color }
  texture { sky_cloud translate <0,-.006,0> }
  translate <0,-.93,0>
  scale 10000
  translate <0,1,0>
  hollow
  no_shadow
}

#declare gold_col=<1,.875,.575>;
#declare gold_fin=
  finish {
    brilliance 5
    ambient amb_light
    diffuse dif_light
    reflection gold_col/2
    metallic 
    specular 0.70
    roughness .01
  }

#declare half_award=
  difference {
    sphere { 0,1 scale <1,1,.2> }
    box { <-1.1,-1.1,0>,<1.1,1.1,1.1> }
    texture { 
      pigment { color rgb gold_col } 
      finish { gold_fin }
    }
    texture { 
      pigment {
        image_map {
          gif "irtc2.gif"
          once
          transmit 255,1
        }
      }
      finish { 
        gold_fin
      }
      translate <-.5,-.5,0>
      scale 1.4
    }          
    texture { 
      pigment {
        image_map {
          gif "irtc.gif"
          once
          transmit 0,1
        }
      }
      finish { 
        ambient amb_light+.3      
        diffuse dif_light
        roughness .1
        specular .5
      }
      translate <-.5,-.5,0>
      scale 1.8
    }
    scale .5          
  }

#declare award=
  union {
    object { half_award translate <0,0,-.0001> }
    object { half_award rotate <0,180,0> translate <0,0,.0001> }
    rotate <-90,0,0> 
  } 
#declare tc=scene_clock-.0001;
#while (tc<=scene_clock)
  #declare awp=(flight_spline(<25,7,-25>,<25,7,-15>,<15,6,-15>,<15,5,-10>,0,3,tc));
  #declare awp=(flight_spline(awp,awp+<0,-1,5>,<10,3,0>,<7,2,-3>,3,6,tc));
  #declare awp=(flight_spline(awp,awp+<-3,-1,-3>,<1.5,.2,-3.5>,<1,.2,-3.25>,6,9,tc));
  #declare awp=(flight_spline(awp,awp+<-.5,0,.25>,<-1.5,1,-3>,<-3,2,-5>,9,12,tc));

  #declare awp=(flight_spline(awp,awp+<-1.5,1,-2>,<-5,4,-9>,<-4,4,-12>,12,15,tc));
  #declare awp=(flight_spline(awp,awp+<+1,0,-3>,<-2,4,-18>,<2,4,-18>,15,18,tc));        //  ENDS OVER STEREO
  #declare awp=(flight_spline(awp,awp+<4,0,0>,<6,1,-14>,<2,1,-14>,18,21,tc));           //  PASSING STACKED CD'S
  #declare awp=(flight_spline(awp,awp+<-4,0,0>,<-3,0,-14>,<1,0,-14>,21,24,tc));         //  TOP SHELF EXAMINATION
  #declare awp=(flight_spline(awp,awp+<4,0,0>,<4,-1.5,-12>,<0,-1.25,-12>,24,27,tc));
  
  #declare awp=(flight_spline(awp,awp+<-4,.25,0>,<-5,-1,-10>,<-8,-1,-13>,27,30,tc));
  #declare awp=(flight_spline(awp,awp+<-3,0,-3>,<-12,-2,-17>,<-16,-2,-17>,30,33,tc));
  #declare awp=(flight_spline(awp,awp+<-4,0,0>,<-19,-2,-14>,<-19,-2,-10>,33,36,tc));
  
  #declare awp=(flight_spline(awp,awp+<0,0,-4>,<-18,-2,-16>,<-14,-2,-16>,45,50,tc));
  #declare awp=(flight_spline(awp,awp+<3,0,0>,<-8,-2,-13>,<-6,-2,-11>,50,55,tc));
  #declare awp=(flight_spline(awp,awp+<2,0,2>,<0,-2.25,-9.75>,<2.4,-2.25,-9.8>,55,60,tc));
  
  //object { award rotate <0,180+180*tc,0> translate awp } //translate <3.9,1,-4.3> }  
  #declare tc=tc+.5;
#end
object { award rotate <0,180*scene_clock,0> translate awp } //translate <3.9,1,-4.3> }  
//-----------------------------------------------------------------------------------
#declare weed_clock=-clock*360/4;

#include "fishbowl.inc"
object { fishbowl rotate <0,20,0> translate <2.25,0,-2.5> }

//-----------------------------------------------------------------------------------
 #declare f_clock=0;                                                          
 #declare fish_mouth=0;
 #declare shock=on;
 #declare eyelid=1.2;  
 #declare iris=.7;
 #declare eye_down=0;
 #declare eye_right=0;
 #declare head_dip=0;
 #declare head_rise=0;
 #declare head_tilt_right=0;
 #declare sympathy_twist=10;    //      outer of eyelids down
 #declare blind_upperbreak=0;
 #declare blind_lowerbreak=0;
 #declare f_clock=clock;
 #declare swim_power=.5;
 #declare view=1;
 #declare fish_pos=<2.25,1,-2.5>;
 #declare fish_elevation=0;
 #declare fish_downright=0;
 #declare fish_right=20;

 #declare rf_downplane=0;        // right fin downplane angle (sub-talk)
 #declare lf_downplane=0;        // left fin downplane angle 
 #declare rf_down=0;             // right fin 
 #declare lf_down=0;             // left fin 
 #declare rf_back=10;             // right fin rearward angle (swingwing) typ -10 to +20
 #declare lf_back=10;             // left fin rearward angle (swingwing) typ -10 to +20

#declare bp_freq=clock;
#declare bp_mag=10;
  
#declare lf_downplane=-bp_mag-bp_mag*cos(bp_freq*2*pi);
#declare lf_back=-2*bp_mag*sin(bp_freq*2*pi);
#declare rf_downplane=-bp_mag-bp_mag*cos(bp_freq*2*pi);
#declare rf_back=-2*bp_mag*sin(bp_freq*2*pi);

#declare face_ang=(flight_spline(<0,20,0>,<0,-70,0>,<0,50,0>,<0,50,0>,6,10,clock));
#declare fish_rtft=<2.25,1,-2.5>+vrotate(<0,0,-.85>,face_ang);          //   position; rotated to face target.
#declare fish_park=<2.25,.6,-2.5>;
#declare fish_pos=(flight_spline(fish_park,fish_park,fish_rtft,fish_rtft,4,7,clock));
#declare fish_right=(flight_spline(fish_right,fish_right,face_ang.y,face_ang.y,6,7,clock));
#declare fish_right=fish_right+(flight_spline(0,0,40,40,8,11,clock));
#declare fish_right=fish_right+(flight_spline(0,0,-30,-30,11,14,clock));
#declare fish_elevation=(flight_spline(fish_elevation,fish_elevation,20,20,4,6,clock));
#declare eye_down=(flight_spline(eye_down,eye_down,30,30,4,6,clock));
#declare head_dip=(flight_spline(head_dip,head_dip,20,20,4,6,clock));
#declare fish_elevation=(flight_spline(fish_elevation,fish_elevation,10,10,7,8,clock));
#declare eye_down=(flight_spline(eye_down,eye_down,10,10,7,8,clock));
#declare fish_pos=fish_pos-<0,(flight_spline(0,0,.2,.2,7,8,clock)),0>;

#include "goldfish.inc"

  object { fish 
    scale .065    //      make him slightly bigger in scene1
    rotate <fish_downright,0,0>
    rotate <0,-90,0> 
    rotate <fish_elevation,0,0>
    rotate <0,fish_right,0>
    translate (fish_pos)
  }

//-----------------------------------------------------------------------------------

#include "bug3.inc"
#render "bug 1\n"                                                                            
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,150,0>;
#local bug_pos=<1,0,-4.7>;

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,0,foot_pos[i0].z>; 
  #local i0=i0+1;
#end


#local m_clock=clock;
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=4;
#local march_time=-1;

#while (march_time<40)
  
    #local m_pos=(flight_spline(bug_pos,<1,0,-4.7>,<1,0,-4.7>,<0,0,-5.4>,19,28,march_time+.1));
    #local m_angle=(flight_spline(bug_ang,<0,100,0>,<0,70,0>,<0,60,0>,19,28,march_time+.1));
    
    #local m_pos=(flight_spline(m_pos,<-.5,0,-5.4>,<-1,0,-5.4>,<-1.5,0,-5.4>,28,32,march_time+.1));
    #local m_angle=(flight_spline(m_angle,<0,65,0>,<0,90,0>,<0,90,0>,28,32,march_time+.1));

    #local m_pos=(flight_spline(m_pos,<-1.75,0,-5.4>,<-2,0,-5.5>,<-2.25,0,-5.5>,32,34.5,march_time+.1));
    #local m_angle=(flight_spline(m_angle,<0,90,0>,<0,60,0>,<0,60,0>,34,35.5,march_time+.1));    
    
    #local tgt_pos=(<m_pos.x,0,m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #if (abs(vlength(foot_pos[firing_order[foot]]-tgt_pos))>.0001)
      #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,0,tgt_pos.z>,firing_order[foot],march_time,m_clock,foot_pos) );
    #end
    #local foot=foot+1;
  
    #if (foot>5)
      #local foot=0;
    #end
    #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
    
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;



#local bug_eye=<0,-.1,.5>;      //right,up,iris
#local bug_eyelid=<1,0,0>;      
#local bug_head=<0,0,0>;        //down,right,twist        
#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<5,0,0>;

#declare nudge=<.05,0,0>;

#declare nudge_time=(flight_spline(0,0,0,1,16.5,17,clock));
#declare nudge_time=(flight_spline(nudge_time,0,0,0,17,17.25,clock));
#declare nudge_time=(flight_spline(nudge_time,nudge_time,0,1,17.25,17.5,clock));
#declare nudge_time=(flight_spline(nudge_time,0,0,0,17.5,18,clock));
#declare bug_pos=bug_pos+nudge*nudge_time;

#declare bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<-.1,0,0>,<0,0,0>,17,17.5,clock));
#declare bug_eyelid=(flight_spline(bug_eyelid,<1.2,0,0>,<1.2,0,0>,<0,0,0>,18,18.5,clock)); 
#declare bug_eyelid=(flight_spline(bug_eyelid,<1.2,0,0>,<1.2,0,0>,<0,0,0>,18.5,19,clock));

#declare bug_eye=(flight_spline(bug_eye,bug_eye,<0,.1,.25>,<-.4,.1,.25>,19.5,21,clock));
#declare bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.6,1,.5>,19.5,21.5,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<.1,-.5,0>,<.1,-.5,0>,19,21,clock));
#declare bug_ang=bug_ang+(flight_spline(<0,0,0>,<0,0,0>,<0,-10,0>,<0,-10,0>,19.5,21.5,clock));

#declare bug_eye=(flight_spline(bug_eye,bug_eye,<0,0,.5>,<0,0,.5>,19,25,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<0,0,0>,<0,0,0>,19,25,clock));
#declare bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<0,0,0>,<0,0,0>,19,25,clock));

#declare bug_head=(flight_spline(bug_head,bug_head,<0,-.5,0>,<0,-.5,0>,30,32,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<0,.25,0>,<0,.25,0>,32,36,clock));

#declare bug_head=(flight_spline(bug_head,bug_head,<0,-.5,0>,<0,-.5,0>,46,46.5,clock));

#declare bug_head=bug_head+(flight_spline(<0,0,0>,<0,-.25,0>,<0,-.25,0>,<0,0,0>,49,49.25,clock));
#declare bug_head=bug_head+(flight_spline(<0,0,0>,<0,.3,0>,<0,.3,0>,<0,0,0>,49.25,49.5,clock));
#declare bug_head=bug_head+(flight_spline(<0,0,0>,<0,-.25,0>,<0,-.25,0>,<0,0,0>,49.5,49.75,clock));
#declare bug_head=bug_head+(flight_spline(<0,0,0>,<0,.3,0>,<0,.3,0>,<0,0,0>,49.75,50,clock));

#declare bug_head=(flight_spline(bug_head,bug_head,<0,.25,0>,<0,.25,0>,50,53.5,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<0,-.5,0>,<0,-.5,0>,53.5,54,clock));

//#declare bug_head=bug_head+(flight_spline(<0,0,0>,<.5,0,0>,<.5,0,0>,<0,0,0>,54.5,54.75,clock));
//#declare bug_head=bug_head+(flight_spline(<0,0,0>,<-.3,0,0>,<-.3,0,0>,<0,0,0>,54.75,55,clock));
//#declare bug_head=bug_head+(flight_spline(<0,0,0>,<.5,0,0>,<.5,0,0>,<0,0,0>,55,55.25,clock));
//#declare bug_head=bug_head+(flight_spline(<0,0,0>,<-.3,0,0>,<-.3,0,0>,<0,0,0>,55.25,55.5,clock));

#declare bug_ang=bug_ang+(flight_spline(<0,0,0>,<0,0,0>,<15,0,0>,<15,0,0>,35,37,clock));

object { bug_macro(bug_pos+.12*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

//-----------------------------------------------------------------------------------

#declare door_open=.9;
#declare handle_angle=0;
#include "room.inc"

//-----------------------------------------------------------------------------------

#include "charlton.inc"

#declare swish=array[4] { 1,30,40,60 }

/*
#declare swish[1]=swish[1]+(flight_spline(0,0,10,10,6,7,clock));
#declare swish[1]=swish[1]+(flight_spline(0,0,-10,-10,9,10,clock));
#declare swish[2]=swish[2]+(flight_spline(0,0,40,40,6,7,clock));
#declare swish[2]=swish[2]+(flight_spline(0,0,-40,-40,9,10,clock));
#declare swish[3]=swish[3]+(flight_spline(0,0,50,50,6,7,clock));
#declare swish[3]=swish[3]+(flight_spline(0,0,-50,-50,9,10,clock));
*/

#declare c_feet=array[2] { <0,0,-3.4>,<0,0,-4.6> }   // global
#declare c_afeet=array[2] { <0,90,0>,<0,90,0> }      // global

#declare spi_clk=0;
#declare spi_clk=(flight_spline(spi_clk,.25,.5,.75,40,54,scene_clock));
#declare spi_clk=(flight_spline(spi_clk,.5,.25,0,55.25,55.75,scene_clock));
#declare c_tail=array[4] { <5,swish[0]*sin(2*pi*scene_clock),0>,<-30,swish[1]*sin(2*pi*(scene_clock-.5)),0>,<-10,swish[2]*sin(2*pi*(scene_clock-1)),0>,<50,swish[3]*sin(2*pi*(scene_clock-1.5)),0> }
#declare c_spines=array[4] { <10-40*spi_clk,0,0>,<-10-20*spi_clk,0,0>,<-30-15*spi_clk,0,40>,<-35-10*spi_clk,0,0> }

#declare c_f_open=array[2] { 0,0 }
#declare c_head=<10,0,0>;

#declare t209_float=array[2] { <-1,0,0>,<1,0,0> }

#declare c_pos=<-3,0,-2>;
#declare c_ang=<0,135,0>;

// walk loop
#declare t_pos=c_pos;
#declare t_ang=c_ang;
#declare step_clock=scene_clock;
#declare foot_sel=0;
#declare move_clk=7;
#declare st=.5;                 //      step time
#declare sr=.4;                 //      step ratio
#declare fs=.5;                 //      foot spread
#declare motion_bob=1.2;
#declare motion_lean=0;

#declare c_feet[0]=c_pos+vrotate(t209_float[0]*fs,c_ang);       //      init foot positions.
#declare c_feet[1]=c_pos+vrotate(t209_float[1]*fs,c_ang);
#declare c_afeet[0]=c_ang;
#declare c_afeet[1]=c_ang;


#while (move_clk<=step_clock+st)

  //#declare st=(flight_spline(.5,1.5,1.5,.5,1,9,move_clk));
  //#declare sr=(flight_spline(.4,.8,.8,.4,1,9,move_clk));
  
  #declare l_pos=t_pos;
  #declare l_ang=t_ang;
    
  #declare t_pos=(flight_spline(t_pos,<-2,0,-3>,<-1,0,-4>,<0,0,-5>,11,13,move_clk+st)); // step up to bug
  #declare t_ang=(flight_spline(t_ang,<0,135,0>,<0,135,0>,<0,120,0>,11,13,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,<0,135,0>,<0,135,0>,<0,120,0>,11,13,step_clock));
  
  #declare t_pos=(flight_spline(t_pos,t_pos,<-.5,0,-4.5>,<-.5,0,-4.5>,19.5,20,move_clk+st));// step back 
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,133,0>,<0,145,0>,19.5,20,move_clk+st));    // and turn to face south
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,135,0>,<0,145,0>,19.5,20,step_clock));    // and turn to face south
  //#declare fs=(flight_spline(fs,.4,.4,1,5,9,move_clk));
  
  #declare t_pos=(flight_spline(t_pos,t_pos,<-.65,0,-5.25>,<-.65,0,-5.25>,24,25,move_clk+st));  // to edge of table
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,165,0>,<0,180,0>,24,25,move_clk+st));    // and turn to face full south
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,165,0>,<0,180,0>,24,25,step_clock));
  
  #if (step_clock>27)
    #declare st=.5;
    #declare sr=(flight_spline(.7,.7,.45,.45,27,31,move_clk));
    #declare fs=(flight_spline(.25,.25,.5,.5,27,31,move_clk));
    #declare fs=(flight_spline(fs,.25,.25,.5,32,36,move_clk));
    #declare fs=(flight_spline(fs,.25,.25,.5,37,40,move_clk));
    #declare fs=(flight_spline(fs,.25,.25,.5,40,43,move_clk));
    #declare fs=(flight_spline(fs,.25,.25,.5,43,47,move_clk));
    #declare fs=(flight_spline(fs,.25,.25,.5,50,53,move_clk));
    #declare t_pos=<0,0,-6.25>;
    #declare t_ang=<0,270,0>;
    #declare c_ang=t_ang;
  #end
  
  #declare t_pos=(flight_spline(t_pos,<-2,0,-8>,<-4,0,-11>,<-6,0,-12>,27,31,move_clk));
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,225,0>,<0,225,0>,27,31,move_clk+st));    // and turn to face full south
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,225,0>,<0,225,0>,27,31,step_clock));    // and turn to face full south

  #declare t_ang=(flight_spline(t_ang,t_ang,<0,325,0>,<0,325,0>,31.5,33,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,325,0>,<0,325,0>,31,33,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-6,0,-12>+<-6,0,9>/3,<-6,0,-12>+<-6,0,9>*2/3,<-6,0,-12>+<-6,0,9>,32,36,move_clk+st));
  
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,235,0>,<0,235,0>,36.25,38,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,235,0>,<0,235,0>,36,38,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-12,0,-2>+<-7,0,-6>/3,<-12,0,-2>+<-7,0,-6>*2/3,<-12,0,-2>+<-7,0,-6>,36.5,40,move_clk+st));

  #declare t_ang=(flight_spline(t_ang,t_ang,<0,145,0>,<0,145,0>,39.25,41,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,145,0>,<0,145,0>,39,41,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-19,0,-8>+<5,0,-9>/3,<-19,0,-8>+<5,0,-9>*2/3,<-19,0,-8>+<5,0,-9>,38.5,43.25,move_clk+st));
    
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,55,0>,<0,55,0>,43,44,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,55,0>,<0,55,0>,43,44,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-14,0,-17>+<7,0,5>/3,<-14,0,-17>+<7,0,5>*2/3,<-14,0,-17>+<7,0,5>,43.25,47,move_clk+st));

  #declare t_ang=(flight_spline(t_ang,t_ang,<0,10,0>,<0,10,0>,46.4,46.9,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,10,0>,<0,10,0>,46.5,47.5,step_clock));
  
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,-35,0>,<0,-35,0>,50.25,51,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,-35,0>,<0,-35,0>,50.25,51,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-7,0,-11.5>+<-4,0,8>/3,<-7,0,-11.5>+<-4,0,8>*2/3,<-7,0,-11.5>+<-4,0,8>,50.25,53,move_clk+st));
  
  #declare t_ang=(flight_spline(t_ang,t_ang,<0,-155,0>,<0,-155,0>,53.25,54,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,-155,0>,<0,-155,0>,53.25,54,step_clock));
  #declare t_pos=(flight_spline(t_pos,<-11,0,-3.5>+<0,0,.25>/3,<-11,0,-3.5>+<0,0,.25>*2/3,<-11,0,-3.5>+<0,0,.25>,53.25,54,move_clk+st));

  #declare t_ang=(flight_spline(t_ang,t_ang,<0,-225,0>,<0,-225,0>,55.75,56.5,move_clk+st));                                               
  #declare c_ang=(flight_spline(c_ang,c_ang,<0,-225,0>,<0,-225,0>,55.75,56.5,step_clock));
  
  // run startup
  #declare fs=(flight_spline(fs,fs,.3,.3,56.5,57,move_clk));
  #declare st=(flight_spline(st,.39,.34,.31,56.5,60,move_clk));
  #declare sr=(flight_spline(sr,.6,.8,.9,56.5,60,move_clk));
  //#declare t_pos=(flight_spline(t_pos,<-9,0,-5.25>,<-6,0,-9>,<2,0,-10>,56.5,60,move_clk+st));
  //                           <-11,0,-3.25>
  #declare t_pos=(flight_spline(t_pos,<-10,0,-4.25>,<-6,0,-9>,<2,0,-10>,56.5,60,move_clk+st));
  #declare t_ang=(flight_spline(t_ang,<0,-240,0>,<0,-255,0>,<0,-270,0>,56.5,60,move_clk+st));
  #declare c_ang=(flight_spline(c_ang,<0,-240,0>,<0,-255,0>,<0,-270,0>,56,60,step_clock));
  
                                               
  #declare tread_stop=0;
  #switch (move_clk)
    #range (47.1,49.9)
      #declare tread_stop=1;
      #break
  #end
  
  #declare fm_stt=move_clk+(st/2)-(sr*st);  
  #declare fm_fin=move_clk+(st/2)+(sr*st);
  #declare t_foot=t_pos+vrotate(t209_float[foot_sel]*fs,t_ang);
  #declare o_foot=l_pos+vrotate(t209_float[mod(foot_sel+1,2)]*fs,l_ang);        //c_feet[mod(foot_sel+1,2)];  
  
  #if ( abs(vlength(c_feet[foot_sel]-t_foot))>.001 & (tread_stop=0))
    #declare c_feet[foot_sel]=(flight_spline(c_feet[foot_sel],c_feet[foot_sel]+y*.5,t_foot+y*.5,t_foot,fm_stt,fm_fin,step_clock));
    
    #declare fm_stt=move_clk+(st/2)-(sr*st)/1.25;
    #declare fm_mid=move_clk+(st/2);
    #declare fm_fin=move_clk+(st/2)+(sr*st)/1.25;
    
    #declare c_f_open[foot_sel]=(flight_spline(c_f_open[foot_sel],.8,.8,0,fm_stt,fm_fin,step_clock));                                // close feet during step time
    
    #declare c_afeet[foot_sel]=(flight_spline(c_afeet[foot_sel],c_afeet[foot_sel],t_ang,t_ang,fm_stt,fm_mid,step_clock));
    #declare c_afeet[foot_sel]=c_afeet[foot_sel]+(flight_spline(<0,0,0>,<60,0,0>,<-60,0,0>,<0,0,0>,fm_mid,fm_fin,step_clock));    // heel up us foot lifts, heel down as foot lowers
    
    #declare motion_bob=(flight_spline(motion_bob,1.2,1.3,1.3,move_clk,move_clk+(st/2),step_clock));
    #declare motion_bob=(flight_spline(motion_bob,1.3,1.2,1.2,move_clk+(st/2),move_clk+st,step_clock));         
    
    #declare motion_lean=motion_lean+(flight_spline(motion_lean,(foot_sel-.5)*fs,(foot_sel-.5)*fs,0,move_clk,move_clk+st,step_clock));
    
    #declare midexit=(o_foot+t_foot)/2;
    #declare midw1=(c_pos+o_foot)/2;
    #declare midw2=(midexit+o_foot)/2;
    #declare c_pos=(flight_spline(c_pos,midw1,midw2,midexit,move_clk,move_clk+st,step_clock));
  #else 
    
  #end
     
  
  #declare foot_sel=mod(foot_sel+1,2);
  #declare move_clk=move_clk+st;
#end

#declare c_pos=c_pos+y*motion_bob;
//#declare c_ang=t_ang;

#declare c_h_pos=array[2] { c_pos+vrotate(<-.2,-.45,.25>,c_ang) , c_pos+vrotate(<.2,-.45,.25>,c_ang) }
#declare c_h_ang=array[2] { c_ang-x*60,c_ang-x*60 }
#declare c_h_open=array[2] { <1,1,1>,<1,1,1> }
#declare arm_lock=array[2] { 1,1 }

#declare c_tail[0]=c_tail[0]+<0,0,20*motion_lean>;
#declare c_tail[1]=c_tail[1]+<0,0,5*motion_lean>;
#declare c_tail[2]=c_tail[2]+<0,0,-5*motion_lean>;
#declare c_head=c_head+<0,-5*motion_lean,2*motion_lean>;



// manual adjustments to 'program'
#declare c_ang=c_ang+(flight_spline(<0,0,0>,<0,0,0>,<0,10,0>,<0,10,0>,14,15,scene_clock));
#declare c_ang=c_ang+(flight_spline(<0,0,0>,<0,0,0>,<0,-20,0>,<0,-20,0>,15,16,scene_clock));
#declare c_ang=c_ang+(flight_spline(<0,0,0>,<0,0,0>,<0,10,0>,<0,10,0>,19,20,scene_clock));        

#declare c_pos=c_pos+(flight_spline(<0,0,0>,<0,0,0>,<.1,-.2,-.05>,<.1,-.2,-.05>,15.5,16,scene_clock));
#declare c_pos=c_pos-(flight_spline(<0,0,0>,<0,0,0>,<.1,-.2,-.05>,<.1,-.2,-.05>,19,19.5,scene_clock));

#declare c_tail[0]=c_tail[0]+(flight_spline(<0,0,0>,<0,0,0>,<10,0,0>,<10,0,0>,14,15,scene_clock));
#declare c_tail[0]=c_tail[0]+(flight_spline(<0,0,0>,<0,0,0>,<-10,0,0>,<-10,0,0>,15,16,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<10,30,0>,<10,30,0>,14,15,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<10,-60,0>,<10,-60,0>,15,16,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<-20,30,0>,<-20,30,0>,19,20,scene_clock));

#declare c_h_open[0]=(flight_spline(c_h_open[0],c_h_open[0],<.3,.3,.3>,<.3,.3,.3>,16,16.5,scene_clock));
#declare c_h_open[0]=(flight_spline(c_h_open[0],c_h_open[0],<1,1,1>,<1,1,1>,18,18.5,scene_clock));
#declare c_h_pos[0]=(flight_spline(c_h_pos[0],c_h_pos[0]-y*.2,<.77,.25,-4.65>,<.77,.25,-4.65>,16,17,scene_clock))+nudge*nudge_time;
#declare c_h_pos[0]=(flight_spline(c_h_pos[0],c_h_pos[0],c_pos+vrotate(<-.2,-.45,.25>,c_ang),c_pos+vrotate(<-.2,-.45,.25>,c_ang),18,19,scene_clock));
#declare arm_lock[0]=(flight_spline(arm_lock[0],arm_lock[0],0,0,15.5,16.5,scene_clock));
#declare arm_lock[0]=(flight_spline(arm_lock[0],arm_lock[0],1,1,17.5,18.5,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<10,30,0>,<10,30,0>,20,21,scene_clock));
#declare c_h_pos[1]=(flight_spline(c_h_pos[1],c_h_pos[1]+<-.95,-.1,-.25>,c_h_pos[1]+<-.95,-.1,-.25>,c_h_pos[1],21,23,scene_clock)); //      award position
#declare arm_lock[1]=(flight_spline(arm_lock[1],arm_lock[1],0,0,21,22,scene_clock));
#declare arm_lock[1]=(flight_spline(arm_lock[1],arm_lock[1],1,1,22,23,scene_clock));
//#declare c_h_open[1]=(flight_spline(c_h_open[1],c_h_open[1],<1,1,.3>,<1,1,.3>,21,22,scene_clock));
//#declare c_h_open[1]=(flight_spline(c_h_open[1],c_h_open[1],<1,1,1>,<1,1,1>,22,23,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<10,-60,0>,<10,-60,0>,22,23,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<-20,30,0>,<-20,30,0>,23,24,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,90,0>,<0,90,0>,<0,0,0>,30,32,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,-90,0>,<0,-90,0>,<0,0,0>,35.5,37,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,-90,0>,<0,-90,0>,<0,0,0>,42.5,43.75,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,-90,0>,<0,-90,0>,<0,-45,0>,46.75,47.75,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,90,0>,<0,70,0>,<0,45,0>,47.75,51,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<-20,0,0>,<-20,0,0>,<0,0,0>,48.5,50,scene_clock));
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,-20>,<0,0,-20>,<0,0,0>,48.5,49.75,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,-90,0>,<0,-90,0>,<0,0,0>,52.75,53.5,scene_clock));

#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<0,45,0>,<0,45,0>,53.5,54.75,scene_clock));//right
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<0,-90,0>,<0,-90,0>,54.75,56,scene_clock));//left
#declare c_head=c_head+(flight_spline(<0,0,0>,<0,0,0>,<0,45,0>,<0,45,0>,56,56.5,scene_clock));//straighten

#declare int_pos=awp+<0,3,0>;
#if (vlength(int_pos-c_pos)>1.7) 
  #declare int_pos=c_pos+vnormalize(int_pos-c_pos)*1.7;
#end
#declare int_pos0=int_pos+vrotate(<-.5,0,0>,<0,30,0>);
#declare int_pos1=int_pos+vrotate(<-.5,0,0>,<0,-30,0>);

#declare c_h_ang[0]=(flight_spline(c_h_ang[0],c_h_ang[0],c_ang+<-60,40,40>,c_ang+<-60,40,40>,59.3,59.7,scene_clock));
#declare c_h_ang[1]=(flight_spline(c_h_ang[1],c_h_ang[1],c_ang+<-60,-40,-40>,c_ang+<-60,-40,-40>,59.3,59.7,scene_clock));
#declare c_h_pos[0]=(flight_spline(c_h_pos[0],c_h_pos[0]+<.1,-.3,-.15>,<int_pos0.x,c_h_pos[0].y,c_h_pos[0].z-.1>,int_pos0,59.5,60,scene_clock));
#declare c_h_pos[1]=(flight_spline(c_h_pos[1],c_h_pos[1]+<.1,-.3,+.15>,<int_pos1.x,c_h_pos[1].y,c_h_pos[1].z+.1>,int_pos1,59.5,60,scene_clock));
#declare c_h_open[0]=(flight_spline(c_h_open[0],c_h_open[0],<.3,.7,.3>,<.3,.7,.3>,59.5,60,scene_clock));
#declare c_h_open[1]=(flight_spline(c_h_open[1],c_h_open[1],<.3,.7,.3>,<.3,.7,.3>,59.5,60,scene_clock));
#declare arm_lock[0]=(flight_spline(arm_lock[0],arm_lock[0],0,0,59.3,59.6,scene_clock));
#declare arm_lock[1]=(flight_spline(arm_lock[1],arm_lock[1],0,0,59.3,59.6,scene_clock));


#if (scene_clock<27)
#declare j_clock=(scene_clock-25)*1.5+25;
#declare c_ang=c_ang+(flight_spline(<0,0,0>,<0,-30,0>,<0,60,0>,<0,90,0>,25,27,j_clock));
#declare c_pos=c_pos+(flight_spline(<0,0,0>,<0,-.1,.1>,<0,-.75,.25>,<0,0,-.5>,25,26,j_clock));
#declare c_pos=c_pos+(flight_spline(<0,0,0>,<0,.75,-.75>,<0,.75,-1.5>,<0,-4,-2.25>,26,27,j_clock));
#declare c_feet[0]=c_feet[0]+(flight_spline(<0,0,0>,<0,1,-1>,<-.5,1,-2.5>,<-.5,-3,-3.5>,26.02,26.92,j_clock));
#declare c_feet[1]=c_feet[1]+(flight_spline(<0,0,0>,<0,1,-.75>,<.5,1,-1.75>,<.5,-3,-2.5>,26.,26.9,j_clock));
#declare c_afeet[0]=c_afeet[0]+(flight_spline(<0,0,0>,<-20,0,0>,<0,90,20>,<0,90,0>,26.02,26.82,j_clock));
#declare c_afeet[1]=c_afeet[1]+(flight_spline(<0,0,0>,<-20,0,0>,<0,90,20>,<0,90,0>,26.,26.8,j_clock));
#declare c_f_open[0]=c_f_open[0]+(flight_spline(0,.8,.8,0,26.02,26.82,j_clock));
#declare c_f_open[1]=c_f_open[1]+(flight_spline(0,.8,.8,0,26.,26.8,j_clock));
#else
#declare c_pos=c_pos+<0,-3,0>;
#declare c_feet[0]=c_feet[0]+<0,-3,0>;
#declare c_feet[1]=c_feet[1]+<0,-3,0>;
#declare c_h_pos[0]=c_h_pos[0]+<0,-3,0>;
#declare c_h_pos[1]=c_h_pos[1]+<0,-3,0>;
#end
#render concat("r_hand @ ",str(c_h_open[1].x,0,0),"\n")
object { charlton(c_pos,c_ang,c_tail,c_spines,c_head,c_feet,c_afeet,c_f_open,arm_lock,c_h_pos,c_h_ang,c_h_open) }

//cylinder { c_feet[0],c_feet[0]+y*.3,.08 texture { pigment { color White } finish { ambient amb_light diffuse dif_light } } } // nail his feet
//cylinder { c_feet[1],c_feet[1]+y*.3,.08 texture { pigment { color White } finish { ambient amb_light diffuse dif_light } } } // (for testing)

//-----------------------------------------------------------------------------------

//#declare cam_loc=<2,1.2,-4.5>;        //      goldfish test_cam
//#declare cam_tgt=<2.25,.3,-2.5>;

#declare cam_loc=<-3,.2,-2.2>;  
//#declare cam_loc=<-2,.8,-2.5>;        //      T(0) - Fish, Bug and Charlton are asleap.
#declare cam_tgt=<4,1,-5.5>;

//#declare cam_loc=<-2,.8,-2.5>;        //      T(0++ badge entered and camera panned)
//#declare cam_tgt=<-1,.8,-8>;
 
//#declare cam_loc=<.45,75.25,-4>;      //      Plan View
//#declare cam_tgt=<.45,.15,-3.9>;

#declare cam_loc=(flight_spline(cam_loc,cam_loc,<0,1,-1.5>,<0,1,-1.5>,14,19,clock));
#declare cam_tgt=(flight_spline(cam_tgt,cam_tgt,<0,.8,-6>,<0,.8,-6>,13.8,19.2,clock));

#declare cam_loc=(flight_spline(cam_loc,cam_loc,<1,1.5,-6.25>,<1,1.5,-6.25>,24,35,clock));
#declare cam_tgt=(flight_spline(cam_tgt,cam_tgt,<-3,.4,-7.1>,<-3,.4,-7.1>,24,35,clock));

#declare cam_fol=(flight_spline(1.45,1.45,1.35,1.35,26,30,clock));

#declare cam_loc=(flight_spline(cam_loc,cam_loc,<2.2,-2,-6.25>,<2.2,-2,-6.25>,58,60,clock));
#declare cam_tgt=(flight_spline(cam_tgt,cam_tgt,<1.9,-2,-7.1>,<1.9,-2,-7.1>,58,60,clock));
                  
#declare cam_loc=(flight_spline(cam_loc,cam_loc,awp+<-.2,2,.1>,awp+<-.2,2,.1>,67,70,clock));
#declare cam_tgt=(flight_spline(cam_tgt,cam_tgt,awp+<-.2,0,0>,awp+<-.2,0,0>,66,70,clock));

#declare lamp1_pos=<0,20,10>;
#declare lamp2_pos=<3,20,-10>;
#declare dev_lamp=cam_loc+y*1;

//light_source { 0 color 1/2 translate lamp1_pos }
//light_source { 0 color 1/2 translate lamp2_pos }

light_source { 0 color (1-pen_light)/2 translate lamp1_pos }
light_source { 0 color (1-pen_light)/2 translate lamp2_pos }


light_source { 0 color pen_light translate <0,40,0> shadowless}
light_source { 0 color pen_light translate <0,-40,0> shadowless}

#if (clock>60 & clock<71)
  #declare cam_dir=vnormalize(cam_tgt-cam_loc);
  #declare cam_head=180*atan2(cam_dir.x,cam_dir.z)/pi;
  #declare cam_dir=vrotate(cam_dir,<0,-cam_head,0>);
  #declare cam_ang=-180*atan2(cam_dir.y,cam_dir.z)/pi;
  #declare dimmer=(flight_spline(1,1,.75,.75,60,61,clock));
  #declare dimmer=(flight_spline(dimmer,dimmer,1,1,65,66,clock));

/*  #declare sph_dim=(flight_spline(1,1,0,0,65,66,clock));
  //sphere { 0,6.5 translate <c_pos.x,3.501,c_pos.z+.75> 
  box { <-10,-2.99,-15>,<10,10,10> 
    texture { 
      pigment { 
        rgbf <1,1,1,sph_dim>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    hollow
    no_shadow
  }*/
  
  #declare t1dim=(flight_spline(1,1,0,0,60.25,61,clock));
  #declare t1dim=(flight_spline(t1dim,t1dim,1,1,63.25,64,clock));
  
  #declare t2dim=(flight_spline(1,1,0,0,63,63.75,clock));
  #declare t2dim=(flight_spline(t2dim,t2dim,1,1,65,65.75,clock));
  union {
    box { <-4,-4,0.01>,<4,4,.1>
      texture { 
        pigment { 
          rgbf <1,1,1,dimmer>
        }
        finish {
          ambient 0
          diffuse 0
        }
      }
    }
    union {
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "Will Charlton"  
        1,0
        translate <-3,2,0>
        scale <.1,.1,.0001>
      }
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "catch his prize ?"
        1,0
        translate <-3.75,0,0>
        scale <.1,.1,.0001>
      }
      texture { 
        pigment { 
          rgbf <1,1,1,t1dim>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
    }  
    object {
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "It's up to you."
        1,0
        translate <-3.25,-2.5,0>
        scale <.1,.1,.0001>
      }
      texture { 
        pigment { 
          rgbf <1,1,1,t2dim>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
    }
    translate <0,0,1>
    rotate <cam_ang,cam_head,0>
    translate cam_loc 
    no_shadow
  }

#end      

#if (clock<0)
  #declare cam_dir=vnormalize(cam_tgt-cam_loc);
  #declare cam_head=180*atan2(cam_dir.x,cam_dir.z)/pi;
  #declare cam_dir=vrotate(cam_dir,<0,-cam_head,0>);
  #declare cam_ang=-180*atan2(cam_dir.y,cam_dir.z)/pi;
  #declare dimmer=(flight_spline(0,0,1,1,-2.5,-.5,clock));
    
  #declare t1dim=(flight_spline(0,0,1,1,-3,-2,clock));
  
  #declare t2dim=(flight_spline(1,1,0,0,-4,-3,clock));
  #declare t2dim=(flight_spline(t2dim,t2dim,1,1,-1,0,clock));
  union {
    box { <-.3,-.3,0.5>,<.3,.3,.51>
      texture { 
        pigment { 
          rgbf <1,1,1,dimmer>
        }
        finish {
          ambient 0
          diffuse 0
        }
      }
    }
    union {
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "For a claw"  
        1,0
        translate <-2.3,1,0>
        scale <.02,.02,.0001>
      }
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "full of gold"
        1,0
        translate <-2.55,-.5,0>
        scale <.02,.02,.0001>
      }
      texture { 
        pigment { 
          rgbf <1,1,1,t1dim>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
    }  
    object {
      text {
        ttf "c:\winnt\fonts\comic.ttf"
        "an animation by Duncan Gray."
        1,0
        translate <-4.5,-6,0>
        scale <.0075,.0075,.0001>
      }
      texture { 
        pigment { 
          rgbf <1,1,1,t2dim>
        }
        finish {
          ambient 1
          diffuse 0
        }
      }
    }
    translate <0,0,.15>
    rotate <cam_ang,cam_head,0>
    translate cam_loc 
    no_shadow
  }
  #declare cl_op=(flight_spline(.2,.2,.9,.9,-5,-2,clock));
  #declare cl_pos=(flight_spline(0,0,.1,.2,-3,0,clock));
  #declare cl_ang=(flight_spline(0,0,70,70,-3,0,clock));
  union { 
    object { foot_plate(cl_op,0,<30+10*cl_op,0,0>,<0,0,0>) }
    object { lower_leg translate <0,1,0> }
    rotate <-70,-60,0>
    translate <0,0,1>
    rotate <0,cl_ang,0>
    translate <0,0,-1>
    scale .15
    
    translate <cl_pos,.01+cl_pos,.2>
    rotate <cam_ang,cam_head,0>
    translate cam_loc 

  }
  light_source { 0 color 1-dimmer translate <2,10,20> }

#end      

camera
{           
  location cam_loc
  direction <0,0,cam_fol>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}


//-----------------------------------------------------------------------------------

#render concat("Clock = ",str(clock,0,5),"\n")
#render concat("Frame = ",str(clock*25,0,0),"\n")

//-----------------------------------------------------------------------------------
