// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.
//
#render concat( "weed clock value currently " , str(weed_clock,-1,5) ,".\n" )

#declare Glass_Texture =
  texture {
    pigment { 
      color rgbf <0.8, 0.8, 0.8, 0.9>
    }
    finish  {
      ambient 0.1
      diffuse 0.1
      #ifdef (quickrender)
      #else
        reflection 0.16
      #end
      specular 0.8
      roughness 0.003
      //phong 1
      //phong_size 400
    }
  }
  
#declare Water_Texture=
  texture {
    pigment { 
      color rgbf <0.96, 0.96, 0.98, 0.95>
    }
    finish  {
      ambient amb_light
      diffuse 0.1
      #ifdef (quickrender)
      #else
      reflection 0.2
      #end
      specular 0.8
      roughness 0.000001
      //phong 1
      //phong_size 400
    }
  }
  
#declare Gravel_Texture=
  texture {
    pigment {
      color rgb<.8,.8,.05>
    }
    finish { 
      ambient amb_light
      diffuse dif_light
      roughness 0.2
      specular 0.05
    }
    normal {
      crackle .15
      scale .25
    }
  }

  
#declare glass_bowl=
  union {                            
    difference {       
      sphere { 0,10.5 }
      sphere { 0,10 }  
      cylinder { <0,0,0>,<0,20,0>,5 }
    }
    torus { 5,1 translate <0,-10,0> }
    torus { 5,1 translate <0,10,0> }
    texture { Glass_Texture }
    interior { ior 1.51 }       //      crown glass
  }


#declare quicker_bowl=
  difference {
    union {
      sphere { 0,10.5 }
      torus { 5,1 translate <0,-10,0> }
      torus { 5,1 translate <0,10,0> }
    }
    cylinder { <0,9,0>,<0,11,0>,4.1 }
                  
    texture { Glass_Texture }
    interior { ior .89 }       //      blend of water and glass effect 
                                //      (cheat - dont put water in the solid bowl)
  }
    
#declare water=
  intersection {
    sphere { 0,9.99999999 }
    box { <-11,-11,-11>,<11,7.5,11> }
    texture { Water_Texture }
    interior { 
      ior 1.33                  //      water
    }
    hollow on
  }                
  
#declare gravel=
  intersection {    
    union {
      height_field {
        tga "gravel.tga"
        //smooth      
        translate <-.5,0,-.5>
        scale <20,2,20>
      }
      box { <-20,-20,-20>,<20,.0001,20> }
      translate < 0,-6,0>
    }
    sphere { 0,10.3 }
    texture { Gravel_Texture }
    hollow
  }


  
#declare bridge_texture=
  texture {
    pigment {
      marble
      turbulence 0.5
      color_map {
        [ 0 color rgb<.9,.8,.5> ]
        [ .2 color rgb<.95,.85,.7> ]
        [ .5 color rgb<.9,.7,.55> ]
        [ .8 color rgb<.95,.85,.75> ]
        [ 1 color rgb<.9,.7,.6> ]
      }
      scale <2,1,1>
    }
    finish {
      ambient amb_light
      diffuse dif_light
      roughness .1
      specular .3
    }
    rotate <0,90,0>
  }
  
#declare bridge_arch=  
      prism {
        cubic_spline 
        -.5,.5,
        13,
        <1,.5>,
       <1,.5>,
       <.95,0>,
       <.95,-.5>,
       <.05,-.5>,
       <.05,0>,
       <0,.5>,
       <0,.5>,
       <.15,.6>,
       <.5,1>,
       <.85,.6>,
       <1,.5>,
       <1,.5>
       /*
        <1,.5>,
        <1,.5>,
        <.9,0>,
        <.9,0>,
        <.1,0>,
        <.1,0>,
        <0,.5>,
        <0,.5>,
        <.15,.6>,
        <.5,1>,
        <.85,.6>,
        <1,.5>,
        <1,.5>
         */
        translate <-.5,0,0>
        rotate <-90,0,0>
        scale <15,5,1>       
      }
#declare bridge_deck=  
   difference {
     prism {
       cubic_spline 
       -6,6,
       13,
       <1,.5>,
       <1,.5>,
       <.95,0>,
       <.95,0>,
       <.05,0>,
       <.05,0>,
       <0,.5>,
       <0,.5>,
       <.15,.6>,
       <.5,1>,
       <.85,.6>,
       <1,.5>,
       <1,.5>
       
       translate <-.5,0,-.48>
       rotate <-90,0,0>
       scale <13,7,1>
     }
     plane { -z,0 rotate <10,0,0> translate <0,0,2> }
     plane { z,0 rotate <-10,0,0> translate <0,0,-2> }
   }
               
#declare bridge=
  object {
    difference {
      union {
        object { bridge_deck }
        object { bridge_arch rotate <3,0,0> translate <0,0,2> }
        object { bridge_arch rotate <-3,0,0> translate <0,0,-2> }
      }
      cylinder { <0,0,-10>,<0,0,10>,3 }        
      plane { -x,0 rotate <0,0,-20> translate <5,0,0> }
      plane { x,0 rotate <0,0,20> translate <-5,0,0> }
      plane { y,-2 }
    } 
    scale <.9,.9,.6>
    texture { bridge_texture }
  }
//#declare weed_clock=-clock*360;
#macro spiral_helix (weed_thickness,local_weed_clock)     //      clock is 'waft' factor
  union {
    #declare p_thick=weed_thickness;
    #declare t_thick=weed_thickness;
    #declare w_clock=0;
    #declare w_prev=-1;
    #while (w_clock<360 & t_thick>.5)
      #declare p3=w_prev/36;
      #declare p1=p3/8*sin(radians(w_prev)) + p3/20*sin(radians(w_prev+local_weed_clock));
      #declare p2=p3/8*cos(radians(w_prev));
      
      #declare t3=w_clock/36;
      #declare t1=t3/8*sin(radians(w_clock)) + t3/20*sin(radians(w_clock+local_weed_clock));
      #declare t2=t3/8*cos(radians(w_clock));
      
      cylinder { <p1,p3,p2>,<t1,t3,t2>,.1*t_thick }
      sphere { <t1,t3,t2>,(.1*t_thick) }
      #declare w_prev=w_clock;
      #declare w_clock=w_clock+20;
      #declare p_thick=t_thick;
      #declare t_thick=t_thick*.95;
    #end
  }
#end  
#declare weed_i=
  union {                     
    union {
      object { spiral_helix (1.6,weed_clock) }
      object { spiral_helix (1.4,weed_clock+60) rotate <0,120,0> }
      object { spiral_helix (1.2,weed_clock+120) rotate <0,-120,0> }
      scale <.3,1,.3>
      rotate <0,180,0>
    }
    union {
      object { spiral_helix (1.0,weed_clock+180) }
      object { spiral_helix (0.8,weed_clock+240) rotate <0,120,0> }
      object { spiral_helix (0.6,weed_clock+300) rotate <0,-120,0> }
      scale <.6,1,.6>
    }
  }

  
#declare weed=
  object {
    object { weed_i }
    texture {
      pigment {
        color rgb<.6,.74,.62>
      }
      finish {
        ambient amb_light
        diffuse dif_light
      }
    }
  }

#declare bubble=sphere { 0,.075 }
#declare bubbles=
intersection {
  union {
    #local bubble_seed=seed(42);
    #local bubble_machine=-3;
    #while (bubble_machine<clock)
      #local bubble_number=<rand(bubble_seed)-.5,0,rand(bubble_seed)-.5>;
      #if (bubble_machine>clock-2.1)
        #local bubble_pos=<0,(clock-bubble_machine),0>;
        object { bubble scale (clock-bubble_machine)+2 translate bubble_pos*7+bubble_number*(clock-bubble_machine) }
      #end
      #local bubble_machine=bubble_machine+.075;
    #end
  }
  box { <-3,0,-3>,<3,14,3> }
  texture{pigment{color rgbf<1,1,1,1>}finish{roughness .1 specular 1}}
}

#declare fishbowl=
  union {             

    object { weed translate <-4,-5,-3> }
    object { weed rotate<0,-90,0> translate <3.5,-5.5,4.5> }
    object { weed rotate<0,90,0> translate <4.5,-5,4> }
    object { gravel }

    object { bridge rotate <5,-5,0> translate <0,-4,.5> }

    
    #ifdef (bowl_off)
    #else
      object { quicker_bowl }
    #end


    translate <0,11.0001,0>
    scale <1,10/11,1>
    scale .1
  }
  
  