// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.

#include "bits.inc"

#declare floor_texture=
  texture { 
    pigment { bumps
      scale .1
      color_map {
        [ 0 color White*.5 ]
        [ .5 color White*.4 ]
        [ 1 color White*.5 ]
      }
    }
    finish { ambient amb_light diffuse dif_light }
    //normal { bumps .2 scale .05 }
  }
/*  texture {                             
    pigment { 
    checker color White*.9 color White*.5 scale 2
    //color rgb<.5,.5,.5>
    }
    finish { ambient amb_light diffuse dif_light }
  }*/
  
#declare wall_texture=
  texture {                             
    pigment { color rgb<1,.99,.75> }
    finish { 
      ambient amb_light 
      diffuse dif_light 
      roughness .25
      specular .1
    }
  }
  
#declare ceiling_texture=
  texture {                             
    pigment { color rgb<1,1,1> }
    finish { 
      ambient amb_light 
      diffuse dif_light 
      roughness .25
      specular .2
    }
  }

#declare glass=
  texture {
    pigment { color rgbf <0.8, 0.8, 0.8, 0.98> }
    finish  { 
      ambient amb_light
      diffuse dif_light //0.3
      reflection 0.2
      specular 0.8
      roughness 0.003
      irid {
        0.2
        thickness .5
        turbulence .5
      }
    }
  }
#declare tabletexture=
  texture {
    pigment {
      wood
      frequency 6
      poly_wave 1
      sine_wave
      turbulence .04
      octaves 6
      lambda 2
      omega .65
      color_map {
        [ 0 color rgb<.5,.4,.1> ]
        [ .5 color rgb<.7,.5,.2> ]
        [ 1 color rgb<.5,.4,.1> ]
      } 
      scale 2
    }
    finish {
      ambient amb_light
      diffuse .5
      #ifdef (quickrender)
      #else
        reflection 0.15
      #end
      specular 0.8
      roughness 0.003
    }
    #ifdef (quickrender)
    #else
    normal {
      bumps .005
      scale .025
    }
    #end
    rotate <1,0,0>
  }
      
      
#declare tabletop=
intersection {
  union {
    torus { 1,.14 translate <-4,0,2> }
    torus { 1,.14 translate <4,0,2> }
    torus { 1,.14 translate <-4,0,-2> }
    torus { 1,.14 translate <4,0,-2> }
    cylinder { <0,-.15,0>,<0,.15,0>,1 translate <-4,0,-2> }
    cylinder { <0,-.15,0>,<0,.15,0>,1 translate <4,0,-2> }
    cylinder { <0,-.15,0>,<0,.15,0>,1 translate <-4,0,2> }
    cylinder { <0,-.15,0>,<0,.15,0>,1 translate <4,0,2> }
    cylinder { <-4,0,0>,<4,0,0>,.14 translate <0,0,3> }
    cylinder { <-4,0,0>,<4,0,0>,.14 translate <0,0,-3> }
    cylinder { <0,0,2>,<0,0,-2>,.14 translate <-5,0,0> }
    cylinder { <0,0,2>,<0,0,-2>,.14 translate <5,0,0> }
    box { <-5,-.15,-2>,<5,.15,2> }
    box { <-4,-.15,-3>,<4,.15,3> } 
  }
  box { <-6,-.14,-6>,<6,.14,6> }
  translate <0,-.14,0>
  texture { tabletexture rotate <0,90,0> translate <0,0,0> }
}
#declare torusquarter=
  intersection {
    torus { 2,.15 }
    box { <-2.2,-.2,0>,<0,.2,2.2> }
    rotate <-90,0,0>
  }
#declare tablelegs=
  union {
    union { 
      object { torusquarter translate <-2,-2,3> }
      object { torusquarter translate <-2,-2,3> scale <-1,1,1> }
      cylinder { <-2,0,3>,<2,0,3>,.15 }
      cylinder { <-4,-2,3>,<-4,-5,3>,.15 }
      cylinder { <4,-2,3>,<4,-5,3>,.15 }
      translate <0,0,-.05>
    }
    union {
      object { torusquarter translate <-2,-2,-3> }
      object { torusquarter translate <-2,-2,-3> scale <-1,1,1> }
      cylinder { <-2,0,-3>,<2,0,-3>,.15 }
      cylinder { <-4,-2,-3>,<-4,-5,-3>,.15 }
      cylinder { <4,-2,-3>,<4,-5,-3>,.15 }
      translate <0,0,.05>
    }
                                        
    cylinder { <2,0,-3>,<2,0,3>,.1 translate <2,-2,0> }
    cylinder { <-2,0,-3>,<-2,0,3>,.1 translate <-2,-2,0> }

    cylinder { <2,0,-3>,<2,0,3>,.1 rotate <0,0,45> translate <2,-2,0> }
    cylinder { <-2,0,-3>,<-2,0,3>,.1 rotate <0,0,-45> translate <-2,-2,0> }
        
    cylinder { <2,0,-3>,<2,0,3>,.1 }
    cylinder { <-2,0,-3>,<-2,0,3>,.1 }    
    
    texture { T_Chrome_2D }
    translate <0,-.15-.28,0>
  }

#declare table=  
  union { 
    object { tabletop }
    object { tablelegs }
  }

#declare fabric=
  texture {
    pigment {
      color rgb<.17,.17,.17>
    }
    finish {
      ambient amb_light 
      diffuse dif_light
      roughness .05
      specular .4
    }
    #ifdef (quickrender)
    #else
      normal {
        crackle .05 
        poly_wave .5 
        
        scale .1
      }
    #end
  }

#declare button_punch=
  difference { 
    cylinder { <0,0,0>,<0,1,0>,1 }
    torus { 1,.8 }
    sphere { 0,.2 }
    translate <0,-.8,0>
    scale <.8,.2,.8>
  }
#ifdef(quickrender)
  #declare cushion=
    box { <-1,-1,-1>,<1,1,1> scale <2.5,1,3>
    texture { fabric }
  }
#else  
  #declare cushion=
  difference {
    superellipsoid { <.2,.35> rotate <90,0,0> scale <2.5,1,3> }
    object { button_punch translate <.75,1,.9> }
    object { button_punch translate <-.75,1,.9> }
    object { button_punch translate <.75,1,-.9> }
    object { button_punch translate <-.75,1,-.9> }
    texture { fabric }
  }
#end  
#declare chair_end=
  union {
    object { cushion rotate <0,0,90> translate <0,2.5,1.5> }
    box { <-.8,0,-2.6>,<.8,2,2.6> translate <0,0,1.5> texture { fabric rotate <-90,0,0> } }
  }
#declare chair_box=
  box { <-2.5,.1,-1>,<2.5,2,3> texture { fabric rotate <-90,0,0> } }
  
#declare chair_seat=
  object { cushion scale <1,1,.75> translate <0,2,.5> }
  
#declare chair_back=
  object { cushion translate <0,0,3> rotate <-70,0,0> translate <0,2.4,3> }
  
#declare chair_mod=
  union {
    object { chair_seat }
    object { chair_back }
  }
  
#declare chair=
  union {
    object { chair_mod }
    object { chair_box }
    object { chair_end translate <-3.4,0,0> }
    object { chair_end scale <-1.1,1,1> translate <3.4,0,0> }
    translate <0,0,-6.5>
  }
  
#declare sofa=
  union { 
    object { chair_mod }
    object { chair_mod translate <-5,0,0> }
    object { chair_mod translate <5,0,0> }
    object { chair_box scale <3.1,1,1> }
    object { chair_end translate <-8.5,0,0> }
    object { chair_end scale <-1,1,1> translate <8.5,0,0> }
    translate <0,0,-6.5>
  }




#declare handle=
  union {
    difference {
      intersection {
        superellipsoid { <.2,.2> }
        box { <-1.1,-.2,-1.1>,<1.1,.2,1.1> }
      }
      superellipsoid { <.2,.2> scale <.9,1,.8> }
      box { <-.5,-.3,-.3>,<.5,.3,-1.1> }
      translate <0,0,-.9>
      rotate <-30*handle_angle,0,0>
    }
    superellipsoid { <.1,.1> scale <.6,1,.5> }
    scale .5
    texture { T_Chrome_5A }
  }
      
#declare vert_b=box { <0,0,0>,<.5,19.9,1> }
#declare hori_b=box { <0,0,1>,<.5,2,7> scale <.9999,1,1> }
#declare vert_c=cylinder { <0,0,0>,<0,19.9,0>,.22 translate <.25,0,0> }
#declare hori_c=cylinder { <0,0,1>,<0,0,7>,.22 translate <.25,0,0> }
#declare door=
  union {
    union {
      #ifdef (quickrender)
        box { <0,0,0>,<.5,19.9,8> }
      #else
        object { vert_b }
        object { vert_b translate <0,0,7> }
        object { vert_b scale <.9998,1,1> translate <0,0,3.5> }
        object { hori_b }
        object { hori_b translate <0,9,0> }
        object { hori_b translate <0,17.9,0> }
      
        object { vert_c translate <0,0,1> }
        object { vert_c translate <0,0,3.5> }
        object { vert_c translate <0,0,4.5> }
        object { vert_c translate <0,0,7> }
      
        object { hori_c translate <0,2,0> }
        object { hori_c translate <0,9,0> }
        object { hori_c translate <0,11,0> }
        object { hori_c translate <0,17.9,0> }
      
        box { <.2,.2,.2>,<.3,19.7,7.9> }
      #end
      
      texture { 
        pigment { 
          color rgb<1,1,1>
        }
        finish { 
          ambient amb_light 
          diffuse dif_light 
          roughness .2
          specular .5 
        }
      }
    }
    object { handle translate <.25,10,7.5> }
    rotate <0,-door_open*90,0>
    translate <20,-2.9,-19>    
  }
#declare jam=
  union {
    intersection { 
      superellipsoid { <.2,.2> }
      box { <-1.1,-.5,0>,<1.1,.5,1.1> }
    }
    box { <0,-.5,0>,<.6,.5,1.2> }
    translate <0,.5,-1>
    scale <.525,20.6,.6>
  }
#declare door_frame=
  union {
    object { jam translate <20.5,-3,-19.05> }
    object { jam scale <1,1,-1> translate <20.5,-3,-10.95> }
    object { jam scale <1,8.6/20,1> rotate <90,0,0> translate <20.5,17.001,-19.3> }
    box { <0.01,0,-.2>,<.99,.05,9> translate <20,-3,-19.05> }
    texture { 
      pigment { 
        color rgb<1,1,1>
      }
      finish { 
        ambient amb_light 
        diffuse dif_light 
        roughness .2
        specular .5 
      }
    }
  }

#declare light_sw=
  union {
    superellipsoid { <.1,.1> translate <1,0,0> scale .5 }
    box { <0,-.2,.2>,<.2,.2,.05> rotate <0,0,5>  translate <-.05,0,0> }
    box { <0,-.2,-.2>,<.2,.2,-.05> rotate <0,0,5> translate <-.05,0,0> }
    translate <19.9,10,-8>
    texture { 
      pigment {
        color rgb<1,1,1>
      }
      finish {
        ambient amb_light
        diffuse dif_light
        roughness .05
        specular .3
      }
    }
  }    

#declare blind_tex=
  texture {    
    pigment {
      color rgb<.1,.1,.1>
    }
    finish {
      ambient amb_light
      diffuse dif_light
      reflection .2
      roughness .01
      specular .6
    }
  }
#declare blind=
  difference {
    cylinder { <0,0,-4.9>,<0,0,9.9>,.5 }
    box { <-1,-1,-5>,<1,.25,10> }
    translate <0,-.25-.125,0>
    rotate <0,0,20>    
  }
#declare blinds=
  union {
    #declare bc=19;
    #while ( bc>5 )
      object { blind translate <0,bc,0> }
      #declare bc=bc-.4;
    #end
    texture { blind_tex }
  }
#declare room=                                                          
  difference {
    union {
      box { <-21,-6,-21>,<23,36,21> }   //      room
      box { <20.5,-6,-30>,<31,36,-8> }  //      corridor
    }
    box { <19,5,-5>,<24,19,10> }         //      window
    box { <-20,-7,-20>,<20,37,20> }     //      inside of room
    box { <21,-7,-35>,<30,37,-9> }      //      inside of corridor 10x wide
    box { <19,0,-19.2>,<24,20.4,-10.8> translate <0,-3.2,0> }    //      door cutout 8x Wide, 20x High
    texture { wall_texture }
  }
#declare skirt_board=
  union { 
    box { <-1,-1,-1>,<1,1,1> }
    cylinder { <0,1,1>,<0,1,-1>,1 }
    translate <0,.9,0>
    scale <.1,.2,20>
     
    texture { 
      pigment { 
        color rgb<1,1,1>
      }
      finish { 
        ambient amb_light 
        diffuse dif_light 
        roughness .2
        specular .5 
      }
    }
  }
#declare skirt_boards=
  difference {
    union {
      object { skirt_board translate <20,-3,0> }
      object { skirt_board translate <-20,-3,0> }
      object { skirt_board rotate <0,90,0> translate <0,-3,20> }
      object { skirt_board rotate <0,90,0> translate <0,-3,-20> }
    }
    box { <19,0,-19.2>,<24,20.4,-10.8> translate <0,-3.2,0> }
  }
object { door_frame }
object { light_sw }
object { door }
object { room }
object { skirt_boards }
object { blinds translate <21,0,0> }  
object { speaker rotate <0,178,0> translate <8.5,-3,-18> }
object { speaker rotate <0,182,0> translate <-8.5,-3,-18> }
//object { tv_set rotate <0,90,0> translate <18,-3,-6> }
object { tv_set rotate <0,90,0> translate <18,-3,5> }
 
object { stereo rotate <0,180,0> translate <0,-3,-19> }
object { table rotate <0,0,0> translate <2,0,-3> }
object { sofa rotate <0,0,0> translate <5,-3,20> }
object { chair rotate <0,-40,0> translate <-17,-3,18> }
object { chair rotate <0,-120,0> translate <-17,-3,-12> }
/*
object { sofa rotate <0,-90,0> translate <-20,-3,-5> }
object { chair rotate <0,-15,0> translate <-7.5,-3,17> }
object { chair rotate <0,25,0> translate <10,-3,17> }
*/


plane { y,0 texture { floor_texture } translate <0,-3,0> }
box { <-22,0,-22>,<31,1,22> texture { ceiling_texture } translate <0,28,0> }