/**************************************************************

            ==================================
            Star Wars - The POV-Ray Collection
            ==================================

PILOT.INC - 3D model description file for use with the
Persistence of Vision Ray-Tracer, v3.0 or higher

POV-Ray code copyright (c) 1998 Howard Day

This model is provided for personal use only. Any use of this
model for commercial gain or profit is strictly forbidden -
please see the accompanying README.TXT and Conditions of Use
before using or distributing this model.

'Star Wars' and all associated images, designs and trademarks,
(including the designs of the vehicles and objects depicted in
the Star Wars POV-Ray Collection, except where otherwise
stated) are copyright (c) 1997 Lucasfilm Ltd.

**************************************************************/


/***************************************************************************/
//		pilot.inc
/***************************************************************************/
//		Pilot Plugin for POV-Ray 3.x

//		Created by Hero Ngauv, 1997
//  Edited by Howard Day, 1998

/***************************************************************************/
#include "colors.inc"
#include "textures.inc"
/***************************************************************************/
/***************************************************************************/
#declare T = 0.25;	//threshold
#declare R = 1.5;	//radius
#declare S = 0.83;//1	//strength
#declare Breasts = 0.2;
#declare Suit_Color = 2;
#declare Height = 32;
#declare Size = (Height/8); // (1.02109375)
/***************************************************************************/
/***************************************************************************/
//		texture.inc
/***************************************************************************/
#declare EW_PilotHelmetTex =
texture {
pigment {
image_map{
gif "helmet.GIF"
interpolate 2
}
}
finish {
ambient 0.2
diffuse 1
phong .25
}
scale <27,31.5,1>
rotate <90,0,0>
translate <-13.5,0,-17.5>
}
#ifndef (Skin_Color)
  #declare Skin_Color = 1;
  #end
#if (Skin_Color = 1)
  #declare Skin_Pigment = color (Flesh*8+Wheat*2+Gold*5)/15;
  #end
#if (Skin_Color = 2)
  #declare Skin_Pigment = color (Flesh*6+Copper*2+BakersChoc+Gold*6)/15;
  #end
#if (Skin_Color = 3)
  #declare Skin_Pigment = color (Flesh*2+Copper*2+BakersChoc*9+Gold*2)/15;
  #end
#if (Skin_Color = 4)
  #declare Skin_Pigment = color (Flesh*0+Copper*0+BakersChoc*15+Gold*0)/17.5;
  #end
#ifndef (Hair_Color)
  #declare Hair_Color = DarkWood;
  #end
#ifndef (Eye_Color)
  #declare Eye_Color = SkyBlue/2+Blue/2;
  #end
/***************************************************************************/
#declare Base =
texture{
//  pigment{ White }
//  pigment{ color (Flesh*6+Copper*2+BakersChoc+Gold*6)/15 }
  pigment{ color (Flesh*8+Wheat*2+Gold*5)/15 }
//  pigment{ Blue }
/*  pigment{
    White
//    image_map{ gif "front4.gif" interpolate 2 }
    translate <-0.5,0,0>
    scale <1,2,1>
    scale <Size*4.3,Size*4.3,1>
    translate <0,-Size*4.675,0>
  }*/
  finish{
    ambient 0
    diffuse 1
    //specular 0.35
    roughness 0.005
    brilliance 2.1
    //reflection 0.35
  }
//  normal{ wrinkles 0.5 }
}

#declare Base2 =
texture{
//  pigment{ White }
//  pigment{ color (Flesh*6+Copper*2+BakersChoc+Gold*6)/15 }
  pigment{ color (Flesh*8+Wheat*2+Gold*5)/15 }
//  pigment{ Red }
/*  pigment{
    White
//    image_map{ gif "back4.gif" interpolate 2 }
    translate <-0.5,0,0>
    scale <1,2,1>
    scale <Size*4.3,Size*4.3,1>
    translate <0,-Size*4.675,0>
    rotate <0,180,0>
  }*/
  finish{
    ambient 0
    diffuse 1
    //specular 0.35
    roughness 0.005
    brilliance 2.1
    //reflection 0.35
  }
//  normal{ wrinkles 0.5 }
}

#ifndef (Hair_Texture)
#declare Hair_Texture =
texture{
  pigment{ Hair_Color }
  normal{ bumps 0.5 scale <0.02,1,1> }
}
#end

#ifndef (Skin_Texture)
#declare Skin_Texture =
texture{
  pigment{ color Skin_Pigment }
  finish{ ambient 0.15 diffuse 0.85 }
}
#end

#ifndef (Head_Texture)
#declare Head_Texture =
texture{
  pigment{ color Skin_Pigment }
  finish{ ambient 0.15 diffuse 0.85 }
}
#end

#declare Eye_Texture =
texture{
  pigment{
    wood
    color_map{
      [0.0 rgb 0.1]
      [0.1 rgb 0.1]
      [0.1 Eye_Color]
      [0.3 Eye_Color]
      [0.4 White]
      [1.0 White]
    }
    scale 2
  }
  finish{
    ambient 0.125
    diffuse 0.15
    specular 0.15
    roughness 0.002
    brilliance 0.75
  }
}     

#ifndef (Suit_Pigment)
#declare Suit_Pigment = pigment {colour rgb <1,.45,.25>}
#end

#ifndef (Visor_Pigment)
#declare Visor_Pigment = pigment {rgbt <2,1,0,.85>}
#end 

#ifndef (Suit_Texture)
#declare Suit_Texture =
texture{
  pigment{ Suit_Pigment }
  finish{
    ambient 0.2
    diffuse 1

  }
  normal {bumps 0.3 scale <0.02, 0.04, 0.02> scale 45 bump_size .5}
}
#end



#ifndef (Armor_Texture)
#declare Armor_Texture = 
texture{
  pigment{ gradient y
  color_map {
[0 rgb .65]
[.5 rgb 1]
[1 rgb .65]
  }
  }
  finish{
    ambient 0.05
    diffuse 1
    brilliance 1.25
  }
scale .375
}        
#end


#ifndef (Foot_Texture)
#declare Foot_Texture =
texture{
  pigment{ rgb 0.25 }
  finish{
    ambient 0
    diffuse 1
    phong .5
    }
  normal{ bumps 0.1 scale Size*0.1 }
}
#end

#ifndef (Hand_Texture)
#declare Hand_Texture =
texture{
//  Flesh_Texture
  pigment{ rgb 0.25 }
  finish{
    ambient 0
    diffuse 1
    phong .5
    }

}
#end
/***************************************************************************/
/***************************************************************************/
//		rotation.inc
/***************************************************************************/
//			Listing of Rotation Names

//Note:  Refer to this list rather than going
//       through the whole file.  Saves *LOTS* of time.

/*
For these, use:
  #declare Name_Of_Rotation =
    transform{
      (These can be in any order.)
      rotate x * angle
      rotate y * angle
      rotate z * angle
      (Due to POV-Ray's order of operation, don't use: rotate <x,y,z>)
    }

  Head_Rotation
  Neck_Rotation
  Torso_Rotation

  R_Arm_Rotation
    R_Elbow_Rotation
      R_Hand_Rotation

  L_Arm_Rotation
    L_Elbow_Rotation
      L_Hand_Rotation

  R_Leg_Rotation
    R_Shin_Rotation
      R_Foot_Rotation

  R_Leg_Rotation
    R_Shin_Rotation
      R_Foot_Rotation

For these, use:
  #declare Hand_Position = "name of hand position"

  Hand_Position
    "relaxed"
    "flat"
    "fist"
    "pointing finger"
    "the finger"
    "gun"
    "peace"

Or...you can rotate each individual finger/thumb:
  (Use the same transform setup as the limbs above.)
  "Curve" means how much the fingers will curve from the knuckle.
  "Rotation" means what the rotation for the ENTIRE finger.

  R_Index_Curve
  R_Index_Rotation
  R_Middle_Curve
  R_Middle_Rotation
  R_Ring_Curve
  R_Ring_Rotation
  R_Pinky_Curve
  R_Pinky_Rotation
  R_Thumb_Curve
  R_Thumb_Rotation

  L_Index_Curve
  L_Index_Rotation
  L_Middle_Curve
  L_Middle_Rotation
  L_Ring_Curve
  L_Ring_Rotation
  L_Pinky_Curve
  L_Pinky_Rotation
  L_Thumb_Curve
  L_Thumb_Rotation
*/
/***************************************************************************/
//			The Head
/***************************************************************************/
#ifndef (Head_Rotation)
  #declare Head_Rotation = transform{ rotate 0 }
  #end
#ifndef (Neck_Rotation)
  #declare Neck_Rotation = transform{ rotate 0 }
  #end
/***************************************************************************/
//			The Torso
/***************************************************************************/
#ifndef (Torso_Rotation)
  #declare Torso_Rotation = transform{ rotate 0 }
  #end
/***************************************************************************/
//			The Arms
/***************************************************************************/
#ifndef (R_Arm_Rotation)
  #declare R_Arm_Rotation =
    transform{
      rotate y*0
      rotate z*5
      rotate x*0
    }
  #end
#ifndef (L_Arm_Rotation)
  #declare L_Arm_Rotation =
    transform{
      rotate y*0
      rotate z*-5
      rotate x*0
    }
  #end
#ifndef (R_Elbow_Rotation)
  #declare R_Elbow_Rotation =
    transform{
      rotate x*0
    }
  #end
#ifndef (L_Elbow_Rotation)
  #declare L_Elbow_Rotation =
    transform{
      rotate x*0
    }
  #end

#ifndef (R_Hand_Rotation)
  #declare R_Hand_Rotation =
    transform{
      rotate z*0
      rotate x*0
    }
  #end
#ifndef (L_Hand_Rotation)
  #declare L_Hand_Rotation =
    transform{
      rotate z*0
      rotate x*0
    }
  #end
/***************************************************************************/
//				The Legs
/***************************************************************************/
#ifndef (R_Leg_Rotation)
  #declare R_Leg_Rotation =
    transform{
      rotate y*0
      rotate z*0
      rotate x*0
    }
  #end
#ifndef (L_Leg_Rotation)
  #declare L_Leg_Rotation =
    transform{
      rotate y*0
      rotate z*0
      rotate x*0
    }
  #end

#ifndef (R_Shin_Rotation)
  #declare R_Shin_Rotation =
    transform{
      rotate x*0
    }
  #end
#ifndef (L_Shin_Rotation)
  #declare L_Shin_Rotation =
    transform{
      rotate x*0
    }
  #end

#ifndef (R_Foot_Rotation)
  #declare R_Foot_Rotation =
    transform{
      rotate y*0
      rotate z*0
      rotate x*0
    }
  #end
#ifndef (L_Foot_Rotation)
  #declare L_Foot_Rotation =
    transform{
      rotate y*0
      rotate z*0
      rotate x*0
    }
  #end
/***************************************************************************/
//				The Hands
//			(with preset hand positions)
/***************************************************************************/
#ifndef (R_Hand_Position) #declare R_Hand_Position = "relaxed" #end
#ifndef (L_Hand_Position) #declare L_Hand_Position = "relaxed" #end

#if (strcmp(R_Hand_Position, "relaxed" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*10 }
  #declare R_Index_Rotation = transform{ rotate x*10 }
  #declare R_Middle_Curve = transform{ rotate x*10 }
  #declare R_Middle_Rotation = transform{ rotate x*10 }
  #declare R_Ring_Curve = transform{ rotate x*10 }
  #declare R_Ring_Rotation = transform{ rotate x*10 }
  #declare R_Pinky_Curve = transform{ rotate x*10 }
  #declare R_Pinky_Rotation = transform{ rotate x*10 }
  #declare R_Thumb_Curve = 10;
  #declare R_Thumb_Rotation = transform{ rotate z*35 rotate y*60 }
#end
#if (strcmp(L_Hand_Position, "relaxed" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*10 }
  #declare L_Index_Rotation = transform{ rotate x*10 }
  #declare L_Middle_Curve = transform{ rotate x*10 }
  #declare L_Middle_Rotation = transform{ rotate x*10 }
  #declare L_Ring_Curve = transform{ rotate x*10 }
  #declare L_Ring_Rotation = transform{ rotate x*10 }
  #declare L_Pinky_Curve = transform{ rotate x*10 }
  #declare L_Pinky_Rotation = transform{ rotate x*10 }
  #declare L_Thumb_Curve = 10;
  #declare L_Thumb_Rotation = transform{ rotate -z*35 rotate -y*60 }
#end

#if (strcmp(R_Hand_Position, "flat" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*0 }
  #declare R_Index_Rotation = transform{ rotate x*0 }
  #declare R_Middle_Curve = transform{ rotate x*0 }
  #declare R_Middle_Rotation = transform{ rotate x*0 }
  #declare R_Ring_Curve = transform{ rotate x*0 }
  #declare R_Ring_Rotation = transform{ rotate x*0 }
  #declare R_Pinky_Curve = transform{ rotate x*0 }
  #declare R_Pinky_Rotation = transform{ rotate x*0 }
  #declare R_Thumb_Curve = 0;
  #declare R_Thumb_Rotation = transform{ rotate z*10 rotate y*0 }
#end
#if (strcmp(L_Hand_Position, "flat" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*0 }
  #declare L_Index_Rotation = transform{ rotate x*0 }
  #declare L_Middle_Curve = transform{ rotate x*0 }
  #declare L_Middle_Rotation = transform{ rotate x*0 }
  #declare L_Ring_Curve = transform{ rotate x*0 }
  #declare L_Ring_Rotation = transform{ rotate x*0 }
  #declare L_Pinky_Curve = transform{ rotate x*0 }
  #declare L_Pinky_Rotation = transform{ rotate x*0 }
  #declare L_Thumb_Curve = 0;
  #declare L_Thumb_Rotation = transform{ rotate z*-10 rotate -y*0 }
#end

#if (strcmp(R_Hand_Position, "fist" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*80 }
  #declare R_Index_Rotation = transform{ rotate x*80 }
  #declare R_Middle_Curve = transform{ rotate x*80 }
  #declare R_Middle_Rotation = transform{ rotate x*80 }
  #declare R_Ring_Curve = transform{ rotate x*80 }
  #declare R_Ring_Rotation = transform{ rotate x*80 }
  #declare R_Pinky_Curve = transform{ rotate x*80 }
  #declare R_Pinky_Rotation = transform{ rotate x*80 }
  #declare R_Thumb_Curve = 70;
  #declare R_Thumb_Rotation = transform{ rotate z*60 rotate y*80 }
#end
#if (strcmp(L_Hand_Position, "fist" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*80 }
  #declare L_Index_Rotation = transform{ rotate x*80 }
  #declare L_Middle_Curve = transform{ rotate x*80 }
  #declare L_Middle_Rotation = transform{ rotate x*80 }
  #declare L_Ring_Curve = transform{ rotate x*80 }
  #declare L_Ring_Rotation = transform{ rotate x*80 }
  #declare L_Pinky_Curve = transform{ rotate x*80 }
  #declare L_Pinky_Rotation = transform{ rotate x*80 }
  #declare L_Thumb_Curve = 70;
  #declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*80 }
#end

#if (strcmp(R_Hand_Position, "pointing finger" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*10 }
  #declare R_Index_Rotation = transform{ rotate x*-10 }
  #declare R_Middle_Curve = transform{ rotate x*80 }
  #declare R_Middle_Rotation = transform{ rotate x*80 }
  #declare R_Ring_Curve = transform{ rotate x*70 }
  #declare R_Ring_Rotation = transform{ rotate x*80 }
  #declare R_Pinky_Curve = transform{ rotate x*60 }
  #declare R_Pinky_Rotation = transform{ rotate x*80 }
  #declare R_Thumb_Curve = 40;
  #declare R_Thumb_Rotation = transform{ rotate z*60 rotate y*100 }
#end
#if (strcmp(L_Hand_Position, "pointing finger" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*10 }
  #declare L_Index_Rotation = transform{ rotate x*-10 }
  #declare L_Middle_Curve = transform{ rotate x*80 }
  #declare L_Middle_Rotation = transform{ rotate x*80 }
  #declare L_Ring_Curve = transform{ rotate x*70 }
  #declare L_Ring_Rotation = transform{ rotate x*80 }
  #declare L_Pinky_Curve = transform{ rotate x*60 }
  #declare L_Pinky_Rotation = transform{ rotate x*80 }
  #declare L_Thumb_Curve = 40;
  #declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*100 }
#end

#if (strcmp(R_Hand_Position, "the finger" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*80 }
  #declare R_Index_Rotation = transform{ rotate y*15 rotate x*80 }
  #declare R_Middle_Curve = transform{ rotate x*10 }
  #declare R_Middle_Rotation = transform{ rotate x*10 }
  #declare R_Ring_Curve = transform{ rotate x*70 }
  #declare R_Ring_Rotation = transform{ rotate y*-20 rotate x*80 }
  #declare R_Pinky_Curve = transform{ rotate x*70 }
  #declare R_Pinky_Rotation = transform{ rotate y*-20 rotate x*80 }
  #declare R_Thumb_Curve = 70;
  #declare R_Thumb_Rotation = transform{ rotate z*60 rotate y*80 }
#end
#if (strcmp(L_Hand_Position, "the finger" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*80 }
  #declare L_Index_Rotation = transform{ rotate -y*15 rotate x*80 }
  #declare L_Middle_Curve = transform{ rotate x*10 }
  #declare L_Middle_Rotation = transform{ rotate x*10 }
  #declare L_Ring_Curve = transform{ rotate x*70 }
  #declare L_Ring_Rotation = transform{ rotate y*20 rotate x*80 }
  #declare L_Pinky_Curve = transform{ rotate x*70 }
  #declare L_Pinky_Rotation = transform{ rotate y*20 rotate x*80 }
  #declare L_Thumb_Curve = 70;
  #declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*80 }
#end

#if (strcmp(R_Hand_Position, "gun" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*10 }
  #declare R_Index_Rotation = transform{ rotate x*-20 }
  #declare R_Middle_Curve = transform{ rotate x*10 }
  #declare R_Middle_Rotation = transform{ rotate x*-20 }
  #declare R_Ring_Curve = transform{ rotate x*80 }
  #declare R_Ring_Rotation = transform{ rotate x*80 }
  #declare R_Pinky_Curve = transform{ rotate x*80 }
  #declare R_Pinky_Rotation = transform{ rotate x*80 }
  #declare R_Thumb_Curve = 5;
  #declare R_Thumb_Rotation = transform{ rotate z*10 rotate y*0 }
#end
#if (strcmp(L_Hand_Position, "gun" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*10 }
  #declare L_Index_Rotation = transform{ rotate x*-20 }
  #declare L_Middle_Curve = transform{ rotate x*10 }
  #declare L_Middle_Rotation = transform{ rotate x*-20 }
  #declare L_Ring_Curve = transform{ rotate x*80 }
  #declare L_Ring_Rotation = transform{ rotate x*80 }
  #declare L_Pinky_Curve = transform{ rotate x*80 }
  #declare L_Pinky_Rotation = transform{ rotate x*80 }
  #declare L_Thumb_Curve = 5;
  #declare L_Thumb_Rotation = transform{ rotate -z*10 rotate -y*0 }
#end

#if (strcmp(R_Hand_Position, "peace" ) = 0)
  #declare R_Index_Curve = transform{ rotate x*0 }
  #declare R_Index_Rotation = transform{ rotate z*20 rotate x*0 }
  #declare R_Middle_Curve = transform{ rotate x*0 }
  #declare R_Middle_Rotation = transform{ rotate -z*20 rotate x*0 }
  #declare R_Ring_Curve = transform{ rotate x*80 }
  #declare R_Ring_Rotation = transform{ rotate y*-20 rotate x*80 }
  #declare R_Pinky_Curve = transform{ rotate x*70 }
  #declare R_Pinky_Rotation = transform{ rotate y*-20 rotate x*80 }
  #declare R_Thumb_Curve = 30;
  #declare R_Thumb_Rotation = transform{ rotate z*60 rotate y*110 }
#end
#if (strcmp(L_Hand_Position, "peace" ) = 0)
  #declare L_Index_Curve = transform{ rotate x*0 }
  #declare L_Index_Rotation = transform{ rotate -z*20 rotate x*0 }
  #declare L_Middle_Curve = transform{ rotate x*0 }
  #declare L_Middle_Rotation = transform{ rotate z*20 rotate x*0 }
  #declare L_Ring_Curve = transform{ rotate x*80 }
  #declare L_Ring_Rotation = transform{ rotate y*20 rotate x*80 }
  #declare L_Pinky_Curve = transform{ rotate x*70 }
  #declare L_Pinky_Rotation = transform{ rotate y*20 rotate x*80 }
  #declare L_Thumb_Curve = 30;
  #declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*110 }
#end
/***************************************************************************/
#ifndef (R_Index_Rotation)
  #declare R_Index_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (R_Index_Curve)
  #declare R_Index_Curve =
    transform{ rotate x*0 }
  #end
#ifndef (L_Index_Rotation)
  #declare L_Index_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (L_Index_Curve)
  #declare L_Index_Curve =
    transform{ rotate x*0 }
  #end

#ifndef (R_Middle_Rotation)
  #declare R_Middle_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (R_Middle_Curve)
  #declare R_Middle_Curve =
    transform{ rotate x*0 }
  #end
#ifndef (L_Middle_Rotation)
  #declare L_Middle_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (L_Middle_Curve)
  #declare L_Middle_Curve =
    transform{ rotate x*0 }
  #end

#ifndef (R_Ring_Rotation)
  #declare R_Ring_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (R_Ring_Curve)
  #declare R_Ring_Curve =
    transform{ rotate x*0 }
  #end
#ifndef (L_Ring_Rotation)
  #declare L_Ring_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (L_Ring_Curve)
  #declare L_Ring_Curve =
    transform{ rotate x*0 }
  #end

#ifndef (R_Pinky_Rotation)
  #declare R_Pinky_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (R_Pinky_Curve)
  #declare R_Pinky_Curve =
    transform{ rotate x*0 }
  #end
#ifndef (L_Pinky_Rotation)
  #declare L_Pinky_Rotation =
    transform{
      rotate x*0
      rotate z*0
    }
  #end
#ifndef (L_Pinky_Curve)
  #declare L_Pinky_Curve =
    transform{ rotate x*0 }
  #end

#ifndef (R_Thumb_Rotation)
  #declare R_Thumb_Rotation =
    transform{
      rotate z*10
      rotate y*0
    }
  #end
#ifndef (R_Thumb_Curve)
  #declare R_Thumb_Curve = 0;
  #end
#declare R_Thumb_Angle = transform{ rotate x*R_Thumb_Curve }
#declare R_Thumb_Curve2 = R_Thumb_Curve;
#if (R_Thumb_Curve2 > 25)
  #declare R_Thumb_Curve2 = 10;
  #end
#ifndef (R_Thumb_Angle2)
  #declare R_Thumb_Angle2 =
    transform{ rotate x*R_Thumb_Curve2 }
  #end
#ifndef (L_Thumb_Rotation)
  #declare L_Thumb_Rotation =
    transform{
      rotate z*10
      rotate y*0
    }
  #end
#ifndef (L_Thumb_Curve)
  #declare L_Thumb_Curve = 0;
  #end
#declare L_Thumb_Angle = transform{ rotate x*L_Thumb_Curve }
#declare L_Thumb_Curve2 = L_Thumb_Curve;
#if (L_Thumb_Curve2 > 25)
  #declare L_Thumb_Curve2 = 10;
  #end
#ifndef (L_Thumb_Angle2)
  #declare L_Thumb_Angle2 =
    transform{ rotate x*L_Thumb_Curve2 }
  #end
/***************************************************************************/
/***************************************************************************/
//		arms.inc
/***************************************************************************/
#if (Gender = 1)
#declare Upper_Arm =
blob{
  threshold T

  //the main arm
  sphere{ 0,R,S scale Size/2.75 translate <0,0,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,-Size/6,0> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <Size/12,-Size/2,Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <-Size/12,-Size/2,Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <Size/12,-Size/2,-Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <-Size/12,-Size/2,-Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <Size/12,-Size/1.5,Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <-Size/12,-Size/1.5,Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <Size/12,-Size/1.5,-Size/12> }
  sphere{ 0,R,S scale <Size/4*0.85,Size/2,Size/4> translate <-Size/12,-Size/1.5,-Size/12> }

  //the biceps
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <Size/32,-Size/1.25,Size/6> }
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <Size/16,-Size/1.5,Size/6> }
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <Size/32,-Size/1.75,Size/6> }
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <-Size/32,-Size/1.25,Size/6> }
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <-Size/16,-Size/1.5,Size/6> }
  sphere{ 0,R,S scale <Size/4.75*0.85,Size/4,Size/4.75> translate <-Size/32,-Size/1.75,Size/6> }

  //the elbow
  sphere{ 0,R,S scale Size/3.5 translate <0,-Size*1.25,0> }
  scale <1,.9,1>
}
#end

#if (Gender = 2)
#declare Upper_Arm =
blob{
  threshold T

  //the main arm
  sphere{ 0,R,S scale Size/3.5 translate <0,0,0> }
  sphere{ 0,R,S scale Size/3.5 translate <0,-Size/6,0> }
  sphere{ 0,R,S scale <Size/3.75,Size/2,Size/3.5> translate <0,-Size/2,0> }
  sphere{ 0,R,S scale <Size/3.75,Size/2,Size/3.5> translate <0,-Size/1.5,0> }

  //the biceps
  sphere{ 0,R,S scale <Size/5.5,Size/4,Size/5.75> translate <0,-Size/1.25,Size/7.5> }
  sphere{ 0,R,S scale <Size/5.5,Size/4,Size/5.75> translate <0,-Size/1.5,Size/7.5> }
  sphere{ 0,R,S scale <Size/5.5,Size/4,Size/5.75> translate <0,-Size/1.75,Size/7.5> }

  //the elbow
  sphere{ 0,R,S scale Size/4.5 translate <0,-Size*1.,0> }
  sphere{ 0,R,S scale Size/4.5 translate <0,-Size*1.25,0> }
  scale <1,.9,1>
}
#end
/***************************************************************************/
#if (Gender = 1)
#declare Forearm =
blob{
  threshold T

  //the joint
  sphere{ 0,R,S scale Size/3.5 translate <0,0,0> }

  //the rest of the forearm
  sphere{ 0,R,S scale <Size/5*0.85,Size/2,Size/4.5> translate <Size/16,-Size*1/3,Size/16> }
  sphere{ 0,R,S scale <Size/5*0.85,Size/2,Size/4.5> translate <-Size/16,-Size*1/3,Size/16> }
  sphere{ 0,R,S scale <Size/5*0.85,Size/2,Size/4.5> translate <Size/16,-Size*1/3,-Size/16> }
  sphere{ 0,R,S scale <Size/5*0.85,Size/2,Size/4.5> translate <-Size/16,-Size*1/3,-Size/16> }

  sphere{ 0,R,S scale <Size/7*0.85,Size/2,Size/5> translate <0,-Size*2/3,Size/20> }
  sphere{ 0,R,S scale <Size/7*0.85,Size/2,Size/5> translate <0,-Size*2/3,-Size/20> }
  sphere{ 0,R,S scale <Size/7*0.85,Size/2,Size/5> translate <Size/24,-Size*2/3,0>}
  sphere{ 0,R,S scale <Size/7*0.85,Size/2,Size/5> translate <-Size/24,-Size*2/3,0>}

  sphere{ 0,R,S scale <Size/8,Size/5.5,Size/5.5> translate <0,-Size*17/16,Size/24>}
  scale <1,.9,1>
}
#end

#if (Gender = 2)
#declare Forearm =
blob{
  threshold T

  //the joint
  sphere{ 0,R,S scale Size/4.5 translate <0,0,0> }

  //the rest of the forearm
  sphere{ 0,R,S scale <Size/6.05,Size/2,Size/5.0> translate <Size/16,-Size*1/3,Size/16> }
  sphere{ 0,R,S scale <Size/6.05,Size/2,Size/5.0> translate <-Size/16,-Size*1/3,Size/16> }
  sphere{ 0,R,S scale <Size/6.05,Size/2,Size/5.0> translate <Size/16,-Size*1/3,-Size/16> }
  sphere{ 0,R,S scale <Size/6.05,Size/2,Size/5.0> translate <-Size/16,-Size*1/3,-Size/16> }

  sphere{ 0,R,S scale <Size/6.5,Size/2,Size/6> translate <0,-Size*0.65,Size/20> }
  sphere{ 0,R,S scale <Size/6.5,Size/2,Size/6> translate <0,-Size*0.65,-Size/20> }
  sphere{ 0,R,S scale <Size/8.5,Size/2,Size/6> translate <Size/24,-Size*0.65,0> }
  sphere{ 0,R,S scale <Size/8.5,Size/2,Size/6> translate <-Size/24,-Size*0.65,0> }

  sphere{ 0,R,S scale <Size/8,Size/5.75,Size/5.75> translate <0,-Size*17/16,Size/32> }
  scale <1,.9,1>
}
#end
/***************************************************************************/
/***************************************************************************/
//		legs.inc
/***************************************************************************/
#ifndef (Height)
  #declare Height = 16*2;
  #end
#declare Size = Height/8;
/***************************************************************************/
#declare T = 0.25;	//threshold
#declare R = 1.5;	//radius
//#declare S = 0.83//1	//strength
/***************************************************************************/
#if (Gender = 1)
#declare Thigh =
blob{
  threshold T

  //hip
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,-Size*0.5,-Size/16> }

  //thigh
  sphere{ 0,R,S scale <Size/3*0.85,Size,Size/3> translate <Size/8,-Size*1,Size/8> }
  sphere{ 0,R,S scale <Size/3*0.85,Size,Size/3> translate <-Size/8,-Size*1,Size/8> }
  sphere{ 0,R,S scale <Size/3*0.85,Size,Size/3> translate <Size/8,-Size*1,-Size/8> }
  sphere{ 0,R,S scale <Size/3*0.85,Size,Size/3> translate <-Size/8,-Size*1,-Size/8> }

  //knee
  sphere{ 0,R,S scale Size/3 translate <0,-Size*2,0> }
}
#end

#if (Gender = 2)
#declare Thigh =
blob{
  threshold T

  //hip
  sphere{ 0,R,S scale Size/2.1 translate <0,Size*0,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.1 translate <0,-Size*0.5,-Size/16*1> }

  //thigh
  sphere{ 0,R,S scale <Size/3.25*0.95,Size,Size/3.25> translate <Size/16,-Size*1,Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.95,Size,Size/3.25> translate <-Size/16,-Size*1,Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.95,Size,Size/3.25> translate <Size/16,-Size*1,-Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.95,Size,Size/3.25> translate <-Size/16,-Size*1,-Size/16> }

  sphere{ 0,R,S scale <Size/3.25*0.9,Size*0.625,Size/3.25*1> translate <Size/16,-Size*1.1,Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.9,Size*0.625,Size/3.25*1> translate <-Size/16,-Size*1.1,Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.9,Size*0.625,Size/3.25*1> translate <Size/16,-Size*1.1,-Size/16> }
  sphere{ 0,R,S scale <Size/3.25*0.9,Size*0.625,Size/3.25*1> translate <-Size/16,-Size*1.1,-Size/16> }

  //knee
  sphere{ 0,R,S scale Size/3*<0.85,1,1> translate <0,-Size*1.75,0> }
  sphere{ 0,R,S scale Size/3*<0.85,1,1> translate <0,-Size*2,0> }

}
#end
/***************************************************************************/
#if (Gender = 1)
#declare Shin =
blob{
  threshold T

  //knee
  sphere{ 0,R,S scale Size/3*<0.85,1,1> translate <0,0,0> }
  sphere{ 0,R,S scale Size/3*<0.85,1,1> translate <0,-Size/6,Size/16> }
  sphere{ 0,R,S scale Size/3*<0.85,1,1> translate <0,Size/16,Size/16> }

  //top half of shin
  sphere{ 0,R,S scale <Size/3.5*0.95,Size/2,Size/3.5> translate <0,-Size/2,Size/8> }
  sphere{ 0,R,S scale <Size/3.95*0.95,Size/2,Size/3.5> translate <Size/8,-Size/2,-Size/8> }
  sphere{ 0,R,S scale <Size/3.95*0.95,Size/2,Size/3.5> translate <-Size/8,-Size/2,-Size/8> }

  //bottom half of shin
  sphere{ 0,R,S scale <Size/4*0.95,Size/2,Size/4> translate <0,-Size/1,Size/8> }
  sphere{ 0,R,S scale <Size/4.5*0.95,Size/2,Size/4> translate <Size/16,-Size/1,-Size/8> }
  sphere{ 0,R,S scale <Size/4.5*0.95,Size/2,Size/4> translate <-Size/16,-Size/1,-Size/8> }
  sphere{ 0,R,S scale <Size/3.5*0.95,Size/2,Size/3.5> translate <0,-Size*1.5,0> }

  //calf
  sphere{ 0,R,S scale <Size/3*0.95,Size/2,Size/3> translate <0,-Size/2,-Size/6> }

  //ankle
  sphere{ 0,R,S scale Size/4 translate <0,-Size*1.75,0> }
}
#end

#if (Gender = 2)
#declare Shin =
blob{
  threshold T

  //knee
  sphere{ 0,R,S scale Size/3.5 translate <0,0,0> }
  sphere{ 0,R,S scale Size/3.5 translate <0,-Size/6,Size/16> }
  sphere{ 0,R,S scale Size/3.5 translate <0,Size/16,Size/16> }
  sphere{ 0,R,S scale Size/3.5 translate <0,Size/16,0> }

  //top half shin
  sphere{ 0,R,S scale <Size/4,Size/2,Size/4> translate <0,-Size/2,Size/16> }
  sphere{ 0,R,S scale <Size/4,Size/2,Size/4> translate <Size/16,-Size/2,-Size/16> }
  sphere{ 0,R,S scale <Size/4,Size/2,Size/4> translate <-Size/16,-Size/2,-Size/16> }
  //bottom half shin
  sphere{ 0,R,S scale <Size/4.5,Size/2,Size/4.5> translate <0,-Size/1,Size/12> }
  sphere{ 0,R,S scale <Size/4.5,Size/2,Size/4.5> translate <Size/16,-Size/1,-Size/12> }
  sphere{ 0,R,S scale <Size/4.5,Size/2,Size/4.5> translate <-Size/16,-Size/1,-Size/12> }
  sphere{ 0,R,S scale <Size/4.75,Size/2,Size/4.75> translate <0,-Size*1.5,0> }

  //calf
  sphere{ 0,R,S scale <Size/4,Size/2,Size/4> translate <0,-Size/2,-Size/8> }

  //ankle
  sphere{ 0,R,S scale Size/5 translate <0,-Size*1.75,0> }

}
#end
/***************************************************************************/
#if (Gender = 1)
#declare Foot =
blob{
  threshold T

  //ankle
  //sphere{ 0,R,S scale Size/3.25 translate <0,Size/4,0> }
  sphere{ 0,R,S scale Size/4 translate <0,0,0> }

  //heel
  //sphere{ 0,R,S scale Size/4.25 translate <0,0,-Size/8> }
  sphere{ 0,R,S scale Size/4.25 translate <0,-Size/8,-Size/8> }

  //foot
  sphere{ 0,R,S scale <Size/3.75,Size/4,Size/2.25> translate <0,-Size/12,Size/16> }
  sphere{ 0,R,S scale <Size/3.75,Size/6,Size/2.75> translate <0,-Size/4,Size*0> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2> translate <0,-Size/6,Size*0.25> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/4,Size*0.25> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*0.65> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.375> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.25> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.125> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.75> translate <0,-Size/3,Size*0> }

scale .8
}
#end

#if (Gender = 2)
#declare Foot =
blob{
  threshold T

  //ankle
  //sphere{ 0,R,S scale Size/3.25 translate <0,Size/4,0> }
  sphere{ 0,R,S scale Size/4 translate <0,0,0> }

  //heel
  //sphere{ 0,R,S scale Size/4.25 translate <0,0,-Size/8> }
  sphere{ 0,R,S scale Size/4.25 translate <0,-Size/8,-Size/8> }

  //foot
  sphere{ 0,R,S scale <Size/3.75,Size/4,Size/2.25> translate <0,-Size/12,Size/16> }
  sphere{ 0,R,S scale <Size/3.75,Size/6,Size/2.75> translate <0,-Size/4,Size*0> }
  sphere{ 0,R,S scale <Size/3.95,Size/7,Size/2> translate <0,-Size/6,Size*0.25> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/4,Size*0.25+0.2*Size> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*0.625+0.05*Size> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.375+0.2*Size> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.25+0.2*Size> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.25> translate <0,-Size/3,Size*1.25*0.125+0.2*Size> }
  sphere{ 0,R,S scale <Size/3.95,Size/8,Size/2.75> translate <0,-Size/3,-Size*0.125+0.2*Size> }

scale .7

}
#end
/***************************************************************************/
/***************************************************************************/
//		chest.inc
/***************************************************************************/
#declare Chest =
blob{
  threshold T

  //the shoulders
  #if(Gender = 1)
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }
    #end
  #if(Gender = 2)
//  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    #end

  //the chest
  #if(Gender = 1)
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }
    #end
  #if(Gender = 2)
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }

    #end

  //the hips and abdomen
  #if(Gender = 1)
  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }
    #end
  #if(Gender = 2)
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }

    #end
}
/***************************************************************************/
#declare Back =
blob{
  threshold T

  //the shoulders
  #if(Gender = 1)
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }
    #end
  #if(Gender = 2)
//  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    #end

  //the hips and abdomen
  #if(Gender = 1)
  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
    #end
  #if(Gender = 2)
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  #end
scale <.85,1,.9>
}
#declare ChestArmor =
union {

#if (Gender = 1)
union {
difference {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>
}
plane {y,0 texture {Armor_Texture} translate <0,1.25*Size,0>}
plane {x,0 texture {Armor_Texture} translate <-.9*Size,0,0>}
plane {-x,0 texture {Armor_Texture} translate <.9*Size,0,0>}
cylinder {<0,0,0>,<0,1,0>,1 texture {Armor_Texture} scale <.25*Size,100*Size,.25*Size> rotate <90,0,0> translate <0,2.5*Size,0>}
}
difference {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>*1.025
}
plane {y,0 translate <0,1.05*Size,0>}
plane {-y,0 translate <0,1.25*Size,0>}
texture {Hand_Texture}
}
intersection {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 22.5*z
  translate <-.25*Size,1.06*Size,0>
texture {Hand_Texture}
}
texture {Hand_Texture}
}
intersection {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 22.5*z
  translate <-.25*Size,1.06*Size,0>
texture {Hand_Texture}
scale <-1,1,1>
}
texture {Hand_Texture}
}

intersection {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 0
  translate <0,.24*Size,0>
texture {Armor_Texture}
scale <1,1,1>
}
plane {y,0 translate <0,1.06*Size,0>}
texture {Armor_Texture}
}
difference {
blob {
  threshold T

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/3> translate <-Size*0.25*0.95,Size*1.5,Size*0.3*0.85> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.75,Size*0.1> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <Size*0.25*0.85,Size*1.5,Size*0.2> }
  sphere{ 0,R,S scale <Size*0.6*0.95,Size*0.65,Size/2>*0.85 translate <-Size*0.25*0.85,Size*1.5,Size*0.2> }

  sphere{ 0,R,S scale Size/2 translate <Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.75,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.25,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.75,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.75*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/5*0.85,Size*0.0,0> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.5*0.85,Size*0.0,0> }

  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale <Size,Size/2,Size/2> translate <-Size/8,Size*2,-Size/8> }
  sphere{ 0,R,S scale Size/2.75 translate <Size*0.85,Size*1.9,0> }
  sphere{ 0,R,S scale Size/2.75 translate <-Size*0.85,Size*1.9,0> }

  sphere{ 0,R,S scale Size/2 translate <Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <Size/2.65*0.85,Size*0.0,-Size*0.175> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.0> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.1,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.02> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2,Size*1.5,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.5*0.85,Size*1.0,-Size*0.15> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/3*0.75,Size*0.5,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.1,-Size*0.175> }
  sphere{ 0,R,S scale Size/2.15 translate <-Size/2.65*0.85,Size*0.0,-Size*0.175> }
scale <1,1.005,1.2>*1.025
}
plane {y,0 translate <0,.05*Size,0>}
plane {-y,0 translate <0,.25*Size,0>}
texture {Armor_Texture}
}
}
#end
#if (Gender = 2)
difference {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }

scale <1,1.005,1.2>
}
plane {y,0 texture {Armor_Texture} translate <0,1.25*Size,0>}
plane {x,0 texture {Armor_Texture} translate <-.9*Size,0,0>}
plane {-x,0 texture {Armor_Texture} translate <.9*Size,0,0>}
cylinder {<0,0,0>,<0,1,0>,1 texture {Armor_Texture} scale <.25*Size,100*Size,.25*Size> rotate <90,0,0> translate <0,2.5*Size,0>}
}

difference {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }

scale <1,1.005,1.2>*1.025
}
plane {y,0 translate <0,1.05*Size,0>}
plane {-y,0 translate <0,1.25*Size,0>}
texture {Hand_Texture}
}
intersection {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }

scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 22.5*z
  translate <-.25*Size,1.06*Size,0>
texture {Hand_Texture}
}
texture {Hand_Texture}
}
intersection {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 22.5*z
  translate <-.25*Size,1.06*Size,0>
texture {Hand_Texture}
}
scale <-1,1,1>
texture {Hand_Texture}
}

intersection {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }

scale <1,1.005,1.2>*1.025
}
box
{
  <-.125*.5, 0, 0>*Size
  < .25*.5,  4,  2>*Size
  rotate 0
  translate <0,.24*Size,0>
texture {Armor_Texture}
scale <1,1,1>
}
plane {y,0 translate <0,1.06*Size,0>}
texture {Armor_Texture}
}

difference {
blob {
  threshold T
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,0> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,0> }
  sphere{ 0,R,S scale Size/3.90 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.90 translate <-Size*0.85,Size*1.9,-Size*0.05> }
    sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.2,Size*1.075,Size*Breasts*0.01> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.325,Size*1.4,Size*Breasts*0.35> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.325,Size*1.6,Size*Breasts*0.05> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <Size*0.3,Size*1.7,Size*Breasts*0.0126> }
  sphere{ 0,R,S*2 scale Size*0.3375+z*Size*0.1 translate <-Size*0.3,Size*1.7,Size*Breasts*0.0126> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <Size*0.3,Size*1.85,Size*Breasts*0.0125> }
//
  sphere{ 0,R,S*2 scale Size*0.325+z*Size*0.1 translate <-Size*0.3,Size*1.85,Size*Breasts*0.0125> }

  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.3,Size*Breasts*0.35*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.5,Size*Breasts*0.05*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <Size*0,Size*1.6,Size*Breasts*0.026*0.55> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <Size*0,Size*1.75,Size*Breasts*0.0125*0.55> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.3,Size*Breasts*0.35*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.5,Size*Breasts*0.05*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.116,Size*1.6,Size*Breasts*0.026*0.7> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.116,Size*1.75,Size*Breasts*0.0125*0.7> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.3,Size*Breasts*0.35*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.5,Size*Breasts*0.05*0.85> }
  sphere{ 0,R,S*2 scale Size*0.35+z*Size*0.1 translate <-Size*0.233,Size*1.6,Size*Breasts*0.026*0.85> }
//
  sphere{ 0,R,S*2 scale Size*0.3+z*Size*0.1 translate <-Size*0.233,Size*1.75,Size*Breasts*0.0125*0.85> }
sphere{ 0,R,S scale Size/2.5 translate <Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*1.25,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.875> translate <0,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.75*<1,1,0.875> translate <0,Size*0.75,0> }
  sphere{ 0,R,S scale Size/2.5*<1,1,0.75> translate <0,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.75 translate <0,Size*0.25,0> }
  sphere{ 0,R,S scale Size/2.5 translate <0,Size*0.0,Size*0.05> }
  sphere{ 0,R,S scale Size/2.5 translate <-Size/2.25*0.85,Size*1.5,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,0> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size*0.03> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size*0.03> }
  //
    sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <Size/2.25,Size*1.8,-Size/8> }
//
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.75> translate <-Size/2.25,Size*1.8,-Size/8> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*2,-Size*0.025> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale <Size*0.75,Size/2.5,Size/2.5> translate <-Size/5*0.5,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/3.35 translate <-Size*0.85,Size*1.9,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <0,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <0,Size*0.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2 translate <0,Size*0.0,-Size*0.05> }
  sphere{ 0,R,S scale Size/2 translate <-Size/2.25*0.85,Size*1.5,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.875> translate <-Size/4.25*0.85,Size*1.0,-Size*0.075> }
  sphere{ 0,R,S scale Size/2.25*<1,1,0.75> translate <-Size/3.75*0.5,Size*0.5,0> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.1,-Size/16*1> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.65,Size*0.2,-Size/16*3.65/2> }
  sphere{ 0,R,S scale Size/2.2 translate <-Size/2.5*0.85,-Size*0.0,-Size/16*3.65/2> }

scale <1,1.005,1.2>*1.025
}
plane {y,0 translate <0,.05*Size,0>}
plane {-y,0 translate <0,.25*Size,0>}
texture {Armor_Texture}
}
#end

union
{
box
{
  <-.5*.75, 0, .5>*Size
  < .5*.75,  .75,  1.25>*Size
rotate -30*x
translate <0,.75*Size,0>
texture {Hand_Texture}
}
union {
           // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.1, 0.1, 0.1 >*Size
               rotate < 60, 0, 0 >
               translate < 0.245, 1.6076, 1.6084 >*Size
               texture{pigment {rgb .9}}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.1, 0.1, 0.1 >*Size
               rotate < 60, 0, 0 >
               translate < 0, 1.608, 1.6081 >*Size
               texture{pigment {rgb .9}}
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 0.1, 0.1, 0.1 >*Size
               rotate < 60, 0, 0 >
               translate < -0.245, 1.6076, 1.6084 >*Size
            }

                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.6125, 0.1, 0.1201 >*Size
                     rotate < -30, 0, 0 >
                     translate < -0.30625, 1.366, 1.6799 >*Size
                     texture{pigment {rgb <0,.5,1>}}
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.6125, 0.1, 0.1201 >*Size
                     rotate < -30, 0, 0 >
                     translate < -0.30625, 1.2069, 1.7718 >*Size
                     texture{pigment {rgb <0,.5,1>}}
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.1, 0.1, 0.1201 >*Size
                     rotate < -30, 0, 0 >
                     translate < -0.30625, 1.1008, 1.833 >*Size
                     texture{pigment {rgb <0,.5,1>}}
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.1, 0.1, 0.1201 >*Size
                     rotate < -30, 0, 0 >
                     translate < -0.1225, 1.1008, 1.833 >*Size
                  }
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 0.18375, 0.18375, 0.1201 >*Size
                     rotate < -30, 0, 0 >
                     translate < 0.1225, 0.99468, 1.8943 >*Size
                  }
pigment {rgb .75}
translate <0,.3,-.85>*Size
}
#if (Gender =1)
rotate <30,0,0>
translate <0,.7,-.8>*Size
#end
}
}

/***************************************************************************/
/***************************************************************************/
//		hands.inc
/***************************************************************************/
//				The Index Finger
/***************************************************************************/
#declare Index1 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*1/3,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/3,0> }
}
#declare Index2 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*5/24,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*5/24,0> }
}
#declare Index3 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*1/6,0>, R*Size/8,S }
}

#declare Index1_2 =
union{
  object{ Index1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Index1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Index2_2 =
union{
  object{ Index2 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Index2 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Index3_2 =
union{
  object{ Index3 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Index3 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
//				The Middle Finger
/***************************************************************************/
#declare Middle1 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*3/8,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/3,0> }
}
#declare Middle2 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*5/24,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*5/24,0> }
}
#declare Middle3 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*5/24,0>, R*Size/8,S }
}

#declare Middle1_2 =
union{
  object{ Middle1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Middle1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Middle2_2 =
union{
  object{ Middle2 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Middle2 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Middle3_2 =
union{
  object{ Middle3 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Middle3 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
//				The Ring Finger
/***************************************************************************/
#declare Ring1 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*3/8,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/3,0> }
}
#declare Ring2 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*5/24,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*5/24,0> }
}
#declare Ring3 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*5/24,0>, R*Size/8,S }
}

#declare Ring1_2 =
union{
  object{ Ring1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Ring1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Ring2_2 =
union{
  object{ Ring2 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Ring2 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Ring3_2 =
union{
  object{ Ring3 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Ring3 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
//				The Pinky Finger
/***************************************************************************/
#declare Pinky1 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*1/4,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/4,0> }
}
#declare Pinky2 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*1/6,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/6,0> }
}
#declare Pinky3 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*1/6,0>, R*Size/8,S }
}

#declare Pinky1_2 =
union{
  object{ Pinky1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Pinky1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Pinky2_2 =
union{
  object{ Pinky2 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Pinky2 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Pinky3_2 =
union{
  object{ Pinky3 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Pinky3 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
//				The Thumb
/***************************************************************************/
#declare R_Thumb1 =
blob{
  threshold T

  //the slanted thumb-pad-type-thing
  sphere{ 0,R,S scale <Size*9/50,Size*3/10,Size*9/60> translate <Size*1/16,Size*3/20,0> }

  //the joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/3,0> }
}
#declare L_Thumb1 =
blob{
  threshold T

  //the slanted thumb-pad-type-thing
  sphere{ 0,R,S scale <Size*9/50,Size*3/10,Size*9/60> translate <-Size*1/16,Size*3/20,0> }

  //the joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/3,0> }
}
#declare Thumb2 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*9/40,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/5,0> }
}
#declare Thumb3 =
blob{
  threshold T

  //parent joint
  sphere{ 0,R,S scale Size/10 }

  //main piece
  cylinder{ 0, <0,Size*9/40,0>, R*Size/8,S }

  //child joint
  sphere{ 0,R,S scale Size/10 translate <0,Size*1/5,0> }
}

#declare R_Thumb1_2 =
union{
  object{ R_Thumb1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ R_Thumb1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare L_Thumb1_2 =
union{
  object{ L_Thumb1 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ L_Thumb1 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Thumb2_2 =
union{
  object{ Thumb2 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Thumb2 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare Thumb3_2 =
union{
  object{ Thumb3 translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ Thumb3 translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
//			Construct The Fingers
/***************************************************************************/
#declare R_Index_Finger =
union{
  object{ Index1_2 }
  union{
    object{ Index2_2 }
    object{ Index3_2
      transform R_Index_Curve
      translate <0,Size*5/24,0>
    }
    transform R_Index_Curve
    translate <0,Size*1/3,0>
  }
  transform R_Index_Rotation
}
#declare L_Index_Finger =
union{
  object{ Index1_2 }
  union{
    object{ Index2_2 }
    object{ Index3_2
      transform L_Index_Curve
      translate <0,Size*5/24,0>
    }
    transform L_Index_Curve
    translate <0,Size*1/3,0>
  }
  transform L_Index_Rotation
}
#declare R_Middle_Finger =
union{
  object{ Middle1_2 }
  union{
    object{ Middle2_2 }
    object{ Middle3_2
      transform R_Middle_Curve
      translate <0,Size*5/24,0>
    }
    transform R_Middle_Curve
    translate <0,Size*3/8,0>
  }
  transform R_Middle_Rotation
}
#declare L_Middle_Finger =
union{
  object{ Middle1_2 }
  union{
    object{ Middle2_2 }
    object{ Middle3_2
      transform L_Middle_Curve
      translate <0,Size*5/24,0>
    }
    transform L_Middle_Curve
    translate <0,Size*3/8,0>
  }
  transform L_Middle_Rotation
}
#declare R_Ring_Finger =
union{
  object{ Ring1_2 }
  union{
    object{ Ring2_2 }
    object{ Ring3_2
      transform R_Ring_Curve
      translate <0,Size*5/24,0>
    }
    transform R_Ring_Curve
    translate <0,Size*3/8,0>
  }
  transform R_Ring_Rotation
}
#declare L_Ring_Finger =
union{
  object{ Ring1_2 }
  union{
    object{ Ring2_2 }
    object{ Ring3_2
      transform L_Ring_Curve
      translate <0,Size*5/24,0>
    }
    transform L_Ring_Curve
    translate <0,Size*3/8,0>
  }
  transform L_Ring_Rotation
}
#declare R_Pinky_Finger =
union{
  object{ Pinky1_2 }
  union{
    object{ Pinky2_2 }
    object{ Pinky3_2
      transform R_Pinky_Curve
      translate <0,Size*1/6,0>
    }
    transform R_Pinky_Curve
    translate <0,Size*1/4,0>
  }
  transform R_Pinky_Rotation
}
#declare L_Pinky_Finger =
union{
  object{ Pinky1_2 }
  union{
    object{ Pinky2_2 }
    object{ Pinky3_2
      transform L_Pinky_Curve
      translate <0,Size*1/6,0>
    }
    transform L_Pinky_Curve
    translate <0,Size*1/4,0>
  }
  transform L_Pinky_Rotation
}
#declare R_Thumb =
union{
  object{ R_Thumb1_2 }
  union{
    object{ Thumb2_2 }
    object{ Thumb3_2
      transform R_Thumb_Angle
      translate <0,Size*9/40,0>
    }
    transform R_Thumb_Angle2
    rotate <0,0,0>
    translate <0,Size*1/3,0>
  }
  transform R_Thumb_Rotation
}
#declare L_Thumb =
union{
  object{ L_Thumb1_2 }
  union{
    object{ Thumb2_2 }
    object{ Thumb3_2
      transform L_Thumb_Angle
      translate <0,Size*9/40,0>
    }
    transform L_Thumb_Angle2
    rotate <0,0,0>
    translate <0,Size*1/3,0>
  }
  transform L_Thumb_Rotation
}
/***************************************************************************/
//				The Palm
/***************************************************************************/
#declare R_Palm =
blob{
  threshold T

  //the knuckles
  sphere{ 0,R,S scale Size/10 translate <-Size*1/4,0,0> }
  sphere{ 0,R,S scale Size/10 translate <0,0,0> }
  sphere{ 0,R,S scale Size/10 translate <Size*1/4,0,0> }
  sphere{ 0,R,S scale Size/10 translate <Size*1/2,0,0> }
  sphere{ 0,R,S scale Size/8.0 translate <-Size*1/8,-Size*1/16,0> }
  sphere{ 0,R,S scale Size/8.0 translate <Size*1/8,-Size*1/16,0> }
  sphere{ 0,R,S scale Size/8.0 translate <Size*3/8,-Size*1/16,0> }

  //back of the hand near the knuckles
  sphere{ 0,R,S scale Size/8 translate <-Size/4,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <0,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <Size/4,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <Size/2,-Size/8,0> }

  //slanted thumb-pad-type-thing
  sphere{ 0,R,S scale <Size*9/50,Size*3/10,Size*9/60> translate <Size*1/16,Size*3/20,0>
    transform R_Thumb_Rotation translate <-Size*3/8,-Size/2,0>
  }

  //back of the hand
  sphere{ 0,R,S scale <Size*1/7,Size*1/3,Size*1/7> translate <-Size*2/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <-Size*1/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <Size*0/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <Size*1/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <Size*2/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <Size*3/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/7,Size*1/3,Size*1/8> rotate <0,0,-15> translate <Size*7/16,-Size*1/4,0> }

  //section near the wrist
  sphere{ 0,R,S scale Size*1/6 translate <-Size*2/8,-Size*9/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*1/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*0/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*1/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*2/8,-Size*10/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <Size*3/8,-Size*10/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <Size*4/8,-Size*9/16,0> }

  sphere{ 0,R,S scale Size*1/6 translate <-Size*1/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*0/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*1/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*2/8,-Size*8/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <Size*3/8,-Size*8/16,0> }

  //start of the fingers
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform R_Index_Rotation translate <-Size*1/4,0,0>
  }
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform R_Middle_Rotation translate <Size*0/4,0,0>
  }
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform R_Ring_Rotation translate <Size*1/4,0,0>
  }
  cylinder{ 0, <0,Size*1/4,0>, R*Size*1/16,S
    transform R_Pinky_Rotation translate <Size*2/4,0,0>
  }

}
#declare L_Palm =
blob{
  threshold T

  //the knuckles
  sphere{ 0,R,S scale Size/10 translate <Size*1/4,0,0> }
  sphere{ 0,R,S scale Size/10 translate <0,0,0> }
  sphere{ 0,R,S scale Size/10 translate <-Size*1/4,0,0> }
  sphere{ 0,R,S scale Size/10 translate <-Size*1/2,0,0> }
  sphere{ 0,R,S scale Size/8.0 translate <Size*1/8,-Size*1/16,0> }
  sphere{ 0,R,S scale Size/8.0 translate <-Size*1/8,-Size*1/16,0> }
  sphere{ 0,R,S scale Size/8.0 translate <-Size*3/8,-Size*1/16,0> }

  //back of the hand near the knuckles
  sphere{ 0,R,S scale Size/8 translate <Size/4,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <0,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <-Size/4,-Size/8,0> }
  sphere{ 0,R,S scale Size/8 translate <-Size/2,-Size/8,0> }

  //slanted thumb-pad-type-thing
  sphere{ 0,R,S scale <Size*9/50,Size*3/10,Size*9/60> translate <-Size*1/16,Size*3/20,0>
    transform L_Thumb_Rotation translate <Size*3/8,-Size/2,0>
  }

  //back of the hand
  sphere{ 0,R,S scale <Size*1/7,Size*1/3,Size*1/7> translate <Size*2/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <Size*1/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <-Size*0/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <-Size*1/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <-Size*2/8,-Size*1/4,-Size*1/32> }
  sphere{ 0,R,S scale <Size*1/4,Size*1/3,Size*1/8> translate <-Size*3/8,-Size*1/4,0> }
  sphere{ 0,R,S scale <Size*1/7,Size*1/3,Size*1/8> rotate <0,0,15> translate <-Size*7/16,-Size*1/4,0> }

  //section near the wrist
  sphere{ 0,R,S scale Size*1/6 translate <Size*2/8,-Size*9/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <Size*1/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*0/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*1/8,-Size*10/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*2/8,-Size*10/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <-Size*3/8,-Size*10/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <-Size*4/8,-Size*9/16,0> }

  sphere{ 0,R,S scale Size*1/6 translate <Size*1/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*0/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*1/8,-Size*8/16,0> }
  sphere{ 0,R,S scale Size*1/6 translate <-Size*2/8,-Size*8/16,0> }
//  sphere{ 0,R,S scale Size*1/7 translate <-Size*3/8,-Size*8/16,0> }

  //start of the fingers
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform L_Index_Rotation translate <Size*1/4,0,0>
  }
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform L_Middle_Rotation translate <-Size*0/4,0,0>
  }
  cylinder{ 0, <0,Size*1/3,0>, R*Size*1/16,S
    transform L_Ring_Rotation translate <-Size*1/4,0,0>
  }
  cylinder{ 0, <0,Size*1/4,0>, R*Size*1/16,S
    transform L_Pinky_Rotation translate <-Size*2/4,0,0>
  }

}
#declare R_Palm2 =
union{
  object{ R_Palm translate <0,Size/256,0>
    texture{ Hand_Texture }
  }
  object{ R_Palm translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ R_Palm translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
#declare L_Palm2 =
union{
  object{ L_Palm translate <0,Size/256,0>
    texture{ Hand_Texture }
  }
  object{ L_Palm translate <0,0,Size/256>
    texture{ Hand_Texture }
  }
  object{ L_Palm translate <0,0,-Size/256>
    texture{ Hand_Texture }
  }
}
/***************************************************************************/
#declare R_Hand =
union{
  object{ R_Thumb translate <-Size*3/8,-Size/2,0> }
  object{ R_Index_Finger translate <-Size/4,0,0> }
  object{ R_Middle_Finger translate <0,0,0> }
  object{ R_Ring_Finger translate <Size/4,0,0> }
  object{ R_Pinky_Finger translate <Size/2,0,0> }
  object{ R_Palm2 }
}
#declare L_Hand =
union{
  object{ L_Thumb translate <Size*3/8,-Size/2,0> }
  object{ L_Index_Finger translate <Size/4,0,0> }
  object{ L_Middle_Finger translate <0,0,0> }
  object{ L_Ring_Finger translate <-Size/4,0,0> }
  object{ L_Pinky_Finger translate <-Size/2,0,0> }
  object{ L_Palm2 }
}
/***************************************************************************/
/***************************************************************************/
//		head.inc
/***************************************************************************/
#declare Head =
union{

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 15, 15, 15 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < 0, 0, 90 >
                           translate < 11, 0, 0 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           rotate < 0, 0, -90 >
                           translate < -11, 0, -5.8775e-39 >
                        }
                        // Object type: Box
                        // Name: NoName
                        object
                        {
                           box { < 0, 0, 0 >, < 1, 1, 1 > }

                           scale < 24, 21, 20 >
                           translate < -12, -16, -20 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 20, 1, 20 >
                           translate < 0, -8, 8 >
                        }
                     }
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 10 }

                     scale < 0.2, 0.2, 0.2 >
                     rotate < 0, 0, 90 >
                     translate < 11, -3.965e-22, 0 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 10 }

                     scale < 0.2, 0.2, 0.2 >
                     rotate < 0, 0, 90 >
                     translate < -11, 2.2096e-22, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 6, 26, 6 >
                     rotate < 0, 0, 90 >
                     translate < 13, 9.5691e-23, 0 >
                  }
               }
            }
            // Object type: Union
            // Name: 'or'
            object
            {
               merge
               {
                  // Object type: Difference
                  // Name: 'and not'
                  object
                  {
                     difference
                     {
                        // Object type: Sphere
                        // Name: NoName
                        object
                        {
                           sphere { < 0, 0, 0 >, 1 }

                           scale < 14.475, 14.475, 14.475 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 19.3, 0.965, 19.3 >
                           rotate < 0, 0, 90 >
                           translate < 10.615, 0, 0 >
                        }
                        // Object type: Disc
                        // Name: NoName
                        object
                        {
                           disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                           scale < 19.3, 0.965, 19.3 >
                           rotate < 0, 0, -90 >
                           translate < -10.615, 0, 0 >
                        }
                     }
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 10 }

                     scale < 0.193, 0.193, 0.193 >
                     rotate < 0, 0, 90 >
                     translate < 10.615, 0, 0 >
                  }
                  // Object type: Torus
                  // Name: NoName
                  object
                  {
                     torus { 30, 10 }

                     scale < 0.193, 0.193, 0.193 >
                     rotate < 0, 0, 90 >
                     translate < -10.615, 0, 0 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 5.79, 25.09, 5.79 >
                     rotate < 0, 0, 90 >
                     translate < 12.545, 0, 0 >
                  }
               }
            }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 40, 5.8301, 0.25 >
         rotate < 30, 0, 0 >
         translate < -20, -2, -4 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 40, 5.8301, 0.25 >
         rotate < 30, 0, 0 >
         translate < -20, -2, -3 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 40, 5.8301, 0.25 >
         rotate < 30, 0, 0 >
         translate < -20, -2, -2 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 40, 5.8301, 0.25 >
         rotate < 30, 0, 0 >
         translate < -20, -2, -1 >
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 40, 5.8301, 0.25 >
         rotate < 30, 0, 0 >
         translate < -20, -2, 0 >
      }


         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 16, 4, 16 >
               rotate < 0, 0, -90 >
               translate < -2, 0, 0 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 28.413, 0, 0 >
               translate < 0, -2, 0 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 14, 6, 14 >
               rotate < 0, 0, -90 >
               translate < -3, 0, 0 >
            }
         }
      }
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 20, 12, 5 >
               translate < -10, -7, -13 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 39, 11, 20 >
                     translate < -20, -11, -16 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 5, 20, 5 >
                     rotate < 90, 0, 0 >
                     translate < 6, 0, -15 >
                  }
                  // Object type: Cylinder
                  // Name: NoName
                  object
                  {
                     cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

                     scale < 5, 20, 5 >
                     rotate < 90, 0, 0 >
                     translate < -6, 0, -15 >
                  }
               }
               translate <0,1.5,0>
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 1, 20, 1 >
               rotate < 90, 0, 0 >
               translate < 0, 1.5, -15 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 90, -30, 0 >
               translate < 8, -4.6353e-23, -10 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < 90, 30, 0 >
               translate < -8, 1.3233e-22, -10 >
            }
            // Object type: Difference
            // Name: 'and not'
            object
            {
               difference
               {
                  // Object type: Box
                  // Name: NoName
                  object
                  {
                     box { < 0, 0, 0 >, < 1, 1, 1 > }

                     scale < 21, 12, 5 >
                     translate < -10.5, -7, -12.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.755, 1.0118, 20 >
                     // --- Shear XY --- (not correct)
                     rotate < 0, 0, -22.5 >
                     scale < 0.998738, 1, 1 >
                     rotate < 0, 0, 22.6739 >
                     // ----------------
                     rotate < 90, -28.805, 0 >
                     translate < 8.4, -2.3842e-07, -9.5 >
                  }
                  // Object type: Disc
                  // Name: NoName
                  object
                  {
                     disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

                     scale < 20.755, 1.0118, 20 >
                     // --- Shear XY --- (not correct)
                     rotate < 0, 0, -22.5 >
                     scale < 0.998738, 1, 1 >
                     rotate < 0, 0, 22.6739 >
                     // ----------------
                     rotate < 90, 28.805, 0 >
                     translate < -8.4, -2.3842e-07, -9.5 >
                  }
               }
            }
         }
texture {
pigment {Visor_Pigment}
finish {
ambient 0
diffuse 1
phong .25
}
}
}
      // Object type: Difference
      // Name: 'and not'
      object
      {
         difference
         {
            // Object type: Torus
            // Name: NoName
            object
            {
               torus { 30, 0.75 }

               scale < 0.35772, 1.1245, 0.86589*.9 >
               rotate < -40.855, 0, 0 >
               translate < 0, 5, 10.5 >
            }
            // Object type: Disc
            // Name: NoName
            object
            {
               disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

               scale < 20, 1, 20 >
               rotate < -90, 0, 0 >
               translate < 0, -1, 5.5 >
            }
         }
texture {Hand_Texture}
      }
            // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 }

         scale < 1.5, 4, 0.69338 >
         rotate < 0, -33.69, -90 >
         translate < -2, -11.5, -8.5 >
pigment {rgb 1.5}
      }
/*      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 30, 10 }

         scale < 0.38765*.75, 0.38765, 0.38765*.85 >
rotate -Head_Rotation
         rotate < -22.5, 0, 0 >
         translate < 0, -13, 1.5 >
         texture {Suit_Texture}
      }*/
}
texture {
EW_PilotHelmetTex
}
rotate 180*y
scale <.135,.155,.135>*.9
translate <0,.7,-1.65>
}
blob{
  threshold T

  //nose
  sphere{ 0,R,-S scale <Size/1,Size/50,Size/40> translate <0,-Size*0.03,Size*0.02> }
  sphere{ 0,R,S scale <Size/32,Size/28,Size/24> translate <0,Size*0.03,0> }
  sphere{ 0,R,S scale Size/24 translate <0,Size*0.02,-Size*0.02> }
  sphere{ 0,R,S*2 scale Size/32 translate <Size*0.0375,Size*0.02,-Size*0.05> }
  sphere{ 0,R,S*2 scale Size/32 translate <-Size*0.0375,Size*0.02,-Size*0.05> }
  sphere{ 0,R,S scale <Size/28,Size/16,Size/16> translate <0,Size*0.075,-Size*0.05> }
  sphere{ 0,R,S scale <Size/24,Size/16,Size/16> translate <0,Size*0.15,-Size*0.09> }

  //cheek bones
  sphere{ 0,R,S scale Size/5.5 translate <Size*0.05,Size*0.1,-Size*0.25> }
  sphere{ 0,R,S scale Size/5.5 translate <-Size*0.05,Size*0.1,-Size*0.25> }

  //cheeks
  sphere{ 0,R,S scale Size/5.5 translate <Size*0.1,Size*0.15,-Size*0.35> }
  sphere{ 0,R,S scale Size/5.5 translate <-Size*0.1,Size*0.15,-Size*0.35> }

/*
  //section behind the nose
//  sphere{ 0,R,S scale Size/5.5 translate <Size*0,Size*0.25,-Size*0.275> }
//  sphere{ 0,R,S scale Size/5.25 translate <Size*0.15,Size*0.3,-Size*0.35> }
//  sphere{ 0,R,S scale Size/5.25 translate <-Size*0.15,Size*0.3,-Size*0.35> }
*/
  //brow and forehead
  sphere{ 0,R,S scale Size/5.25 translate <Size*0,Size*0.25,-Size*0.30> }
  sphere{ 0,R,S scale Size/5.25 translate <Size*0.025,Size*0.25,-Size*0.30> }
  sphere{ 0,R,S scale Size/5.25 translate <-Size*0.025,Size*0.25,-Size*0.30> }

  //back of skull
  sphere{ 0,R,S scale Size/4.25 translate <Size*0.0,Size*0.3,-Size*0.30> }
  sphere{ 0,R,S scale Size/4.25 translate <Size*0.025,Size*0.25,-Size*0.45> }
  sphere{ 0,R,S scale Size/4.25 translate <-Size*0.025,Size*0.25,-Size*0.45> }

  //chin and cheeks
  sphere{ 0,R,S scale Size/7 translate <Size*0.0,-Size*0.05,-Size*0.15> }
  sphere{ 0,R,S scale Size/8 translate <Size*0.05,-Size*0,-Size*0.20> }
  sphere{ 0,R,S scale Size/8 translate <-Size*0.05,-Size*0,-Size*0.20> }
  sphere{ 0,R,S scale Size/8 translate <Size*0.1,Size*0,-Size*0.25> }
  sphere{ 0,R,S scale Size/8 translate <-Size*0.1,Size*0,-Size*0.25> }

  //eye sockets
  sphere{ 0,R,-S
    scale <Size/12,Size/24,Size/24>
    translate <Size/5.,Size/3.75,Size/1.80>
    translate <0,0,-Size*0.675>
    scale 3/5
  }
  sphere{ 0,R,-S
    scale <Size/12,Size/24,Size/24>
    translate <-Size/5.,Size/3.75,Size/1.80>
    translate <0,0,-Size*0.675>
    scale 3/5
  }
//  scale 5/3
//  translate <0,0,Size*0.65>
}

sphere{ 0,1
  scale <Size/12,Size/18,Size/18>
  texture{ Eye_Texture scale Size/12 rotate 5*z}
  translate <Size/5.,Size/3.75,Size/1.85>
  translate <0,0,-Size*0.685>
  scale 3/5
}
sphere{ 0,1
  scale <Size/12,Size/18,Size/18>
  texture{ Eye_Texture scale Size/12 rotate -5*z}
  translate <-Size/5.,Size/3.75,Size/1.85>
  translate <0,0,-Size*0.685>
  scale 3/5
}
  scale 5/3
  translate <0,0,Size*0.65>
translate <0,.25*Size,0>
}
/***************************************************************************/
#declare Neck =
blob{
  threshold T

  //neck
  sphere{ 0,R,S scale Size*0.2 translate <0,         -Size*0.2,Size*0.125> }
  sphere{ 0,R,S scale Size*0.2 translate <0,         -Size*0.2,-Size*0.125> }
  sphere{ 0,R,S scale Size*0.2 translate <Size*0.125 ,-Size*0.2,Size*0.0> }
  sphere{ 0,R,S scale Size*0.2 translate <-Size*0.125,-Size*0.2,-Size*0.0> }
  sphere{ 0,R,S scale Size*0.2 translate <0,         0,        Size*0.05> }
  sphere{ 0,R,S scale Size*0.2 translate <0,         0,        -Size*0.05> }
  sphere{ 0,R,S scale Size*0.2 translate <Size*0.075 ,0,        Size*0.0> }
  sphere{ 0,R,S scale Size*0.2 translate <-Size*0.075,0,        -Size*0.0> }
  sphere{ 0,R,S scale Size*0.2 translate <Size*0.0,  Size*0.25,Size*0.075> }
  sphere{ 0,R,S scale Size*0.2 translate <Size*0.0,  Size*0.25,-Size*0.075> }
  sphere{ 0,R,S scale Size*0.2 translate <Size*0.075, Size*0.25,Size*0.0> }
  sphere{ 0,R,S scale Size*0.2 translate <-Size*0.075,Size*0.25,-Size*0.0> }
}
/***************************************************************************/
#if (Gender = 1)
#declare Hair =
blob{
  threshold T

  //top
  sphere{ 0,R,S scale Size/4.2 translate <Size*0.0,Size*0.35,-Size*0.35> }
  sphere{ 0,R,S scale Size/4.2 translate <Size*0.025,Size*0.30,-Size*0.50> }
  sphere{ 0,R,S scale Size/4.2 translate <-Size*0.025,Size*0.30,-Size*0.50> }
  sphere{ 0,R,S scale Size/4.25 translate <Size*0.0,Size*0.32,-Size*0.28> }
  sphere{ 0,R,S scale Size/4.25 translate <Size*0.01,Size*0.3,-Size*0.45> }
  sphere{ 0,R,S scale Size/4.25 translate <Size*0.01,Size*0.3,-Size*0.45> }

  sphere{ 0,R,-S scale <Size/1,Size/5,Size/5> translate <Size*0.025,-Size*0.025,-Size*0.70> }
//  sphere{ 0,R,S scale Size/4.2 translate <-Size*0.02,Size*0.32,-Size*0.33> }
//  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,Size*0.05> }
//  sphere{ 0,R,S scale Size/2 translate <0,Size*0.5,-Size*0.25> }
  scale 5/3
  translate <0,-Size*0.1,Size*0.65>
}
#end
#if (Gender = 2)
#declare Hair =
blob{
  threshold T

  //top
  sphere{ 0,R,S scale Size*4 translate <0,0,0> }
}
#end
/***************************************************************************/
#declare Head2 =
union{
  object{ Head
    texture{ Head_Texture }
    #ifndef (Face)
      #declare Face =  texture {
        pigment{
        #if (Gender = 1)
          image_map{ gif "headf10.gif" interpolate 2 once }
          #end
        #if (Gender = 2)
          image_map{ gif "headf7.gif" interpolate 2 once }
          #end
        translate <-0.5,-0.05,0>
        scale <Size*1.25,Size*1.15,1>
      }
      finish{ ambient 0.15 diffuse 0.85 }
      }
    #end
    texture {Face}  
    translate <0,0,Size*1/256>
  }
  object{ Head
    texture{ Head_Texture }
    texture{
      pigment{
        #if (Gender = 1)
          image_map{ gif "headb10.gif" interpolate 2 once }
          #end
        #if (Gender = 2)
          Clear
          #end
        translate <-0.5,-0.025,0>
        scale <Size*1.25,Size*1.15,1>
      }
      finish{ ambient 0.15 diffuse 0.85 }
    }
    translate <0,0,-Size*1/256>
  }
}
#declare Neck2 =
union{
  object{ Neck translate <0,0,Size*1/256> }
  object{ Neck translate <0,0,-Size*1/256> }
}
#declare R_Thigh2 =
union{
  object{ Thigh translate <0,0,Size*1/256> }
  object{ Thigh  translate <0,0,-Size*1/256> }
}
#declare L_Thigh2 =
union{
  object{ Thigh translate <0,0,Size*1/256> }
  object{ Thigh translate <0,0,-Size*1/256> }
}
#declare R_Shin2 =
union{
  object{ Shin translate <0,Size*1/256,0> }
  object{ Shin translate <0,0,Size*1/256> }
  object{ Shin translate <0,0,-Size*1/256> }
}
#declare L_Shin2 =
union{
  object{ Shin translate <0,Size*1/256,0> }
  object{ Shin translate <0,0,Size*1/256> }
  object{ Shin translate <0,0,-Size*1/256> }
}
#declare R_Foot2 =
union{
  object{ Foot translate <0,Size*1/256,Size*1/256> }
  object{ Foot translate <0,0,Size*1/256> }
  object{ Foot translate <0,0,-Size*1/256> }
texture{ Foot_Texture }
}
#declare L_Foot2 =
union{
  object{ Foot translate <0,Size*1/256,Size*1/256> }
  object{ Foot translate <0,0,Size*1/256> }
  object{ Foot translate <0,0,-Size*1/256> }
texture{ Foot_Texture }
}
#declare R_Upper_Arm2 =
union{
  object{ Upper_Arm translate <0,0,Size*1/256> }
  object{ Upper_Arm translate <0,0,-Size*1/256> }
}
#declare L_Upper_Arm2 =
union{
  object{ Upper_Arm translate <0,0,Size*1/256> }
  object{ Upper_Arm translate <0,0,-Size*1/256> }
}
#declare R_Forearm2 =
union{
  object{ Forearm translate <-Size*1/256,0,0> }
  object{ Forearm translate <Size*1/256,0,0> }
  object{ Forearm translate <Size*1/256,Size*1/256,0> }
  texture {Hand_Texture}
}
#declare L_Forearm2 =
union{
  object{ Forearm translate <-Size*1/256,0,0> }
  object{ Forearm translate <Size*1/256,0,0> }
  object{ Forearm translate <Size*1/256,Size*1/256,0> }
  texture {Hand_Texture}
}
/***************************************************************************/
#declare Pilot =union{
  union{
    object{ Chest

      translate <0,0,Size*1/256>
    }
	object{ ChestArmor
      texture{ Armor_Texture }
      translate <0,0,Size*1/256>
    }
    object{ Back

      translate <0,0,Size*-1/256>
    }
    union{
      object{ Neck2 }
      object{ Head2
        #if (Gender = 1)
          scale <0.925,1,1>
        #end
        #if (Gender = 2)
          scale <0.875,1,1>
        #end
        rotate Head_Rotation
        #if (Gender = 1)
          translate <0,Size*0.225,Size/8>
        #end
        #if (Gender = 2)
          translate <0,Size*0.175,Size/12>
        #end
      }
      transform Neck_Rotation
//      translate <0,Size*0.25,Size/8>
      #if (Gender = 1)
        translate <0,Size*2.5,-Size/12>
      #end
      #if (Gender = 2)
        translate <0,Size*2.5,-Size/20>
      #end
    }

  #if (Gender = 1)
  union{	//right arm
    object{ R_Upper_Arm2 }
    union{
      object{ R_Forearm2 }
      object{ R_Hand scale 18/32 rotate <180,90,0> translate <0,-Size*8/16,Size*1/16>
        transform R_Hand_Rotation
        translate <0,-Size*14/16,0>
      }
      transform R_Elbow_Rotation
      translate <0,-Size*1.25,0>
    }
    rotate <0,0,3>
    transform R_Arm_Rotation
    translate <Size*0.85,Size*1.9,-Size/16>
  }
  union{	//left arm
    object{ L_Upper_Arm2 }
    union{
      object{ L_Forearm2 scale <-1,1,1> }
      object{ L_Hand scale 18/32 rotate <180,-90,0> translate <0,-Size*8/16,Size*1/16>
        transform L_Hand_Rotation
        translate <0,-Size*14/16,0>
      }
      transform L_Elbow_Rotation
      translate <0,-Size*1.25,0>
    }
    rotate <0,0,-3>
    transform L_Arm_Rotation
    translate <-Size*0.85,Size*1.9,-Size/16>
  }
  #end
  #if (Gender = 2)
  union{	//right arm
    object{ R_Upper_Arm2 }
    union{
      object{ R_Forearm2 }
      object{ R_Hand scale 17/32 rotate <180,90,0> translate <0,-Size*9/16,Size*3/32>
        transform R_Hand_Rotation
        translate <0,-Size*14/16,0>
      }
      transform R_Elbow_Rotation
      translate <0,-Size*1.25,0>
    }
    rotate <0,0,3>
    transform R_Arm_Rotation
    translate <Size*0.8,Size*1.9,-Size/16>
  }
  union{	//left arm
    object{ L_Upper_Arm2 }
    union{
      object{ L_Forearm2 scale <-1,1,1> }
      object{ L_Hand scale 17/32 rotate <180,-90,0> translate <0,-Size*9/16,Size*3/32>
        transform L_Hand_Rotation
        translate <0,-Size*14/16,0>
      }
      transform L_Elbow_Rotation
      translate <0,-Size*1.25,0>
    }
    rotate <0,0,-3>
    transform L_Arm_Rotation
    translate <-Size*0.8,Size*1.9,-Size/16>
  }
  #end
    transform Torso_Rotation
  }

#if (Gender = 1)
  union{	//right leg
    object{ R_Thigh2 }
    union{
      object{ R_Shin2 }
      object{ R_Foot2
        transform R_Foot_Rotation
        translate <0,-Size*2,0>
      }
      transform R_Shin_Rotation
      translate <0,-Size*2,0>
    }
    transform R_Leg_Rotation
    translate <Size/2.5*0.85,0,0>
  }
  union{	//left leg
    object{ L_Thigh2 }
    union{
      object{ L_Shin2 }
      object{ L_Foot2
        transform L_Foot_Rotation
        translate <0,-Size*2,0>
      }
      transform L_Shin_Rotation
      translate <0,-Size*2,0>
    }
    transform L_Leg_Rotation
    translate <-Size/2.5*0.85,0,0>
  }
#end
#if (Gender = 2)
  union{	//right leg
    object{ R_Thigh2 }
    union{
      object{ R_Shin2 }
      object{ R_Foot2
        transform R_Foot_Rotation
        translate <0,-Size*2,0>
      }
      transform R_Shin_Rotation
      translate <0,-Size*2,0>
    }
    transform R_Leg_Rotation
    translate <Size/2.75*0.9,0,0>
  }
  union{	//left leg
    object{ L_Thigh2 }
    union{
      object{ L_Shin2 }
      object{ L_Foot2
        transform L_Foot_Rotation
        translate <0,-Size*2,0>
      }
      transform L_Shin_Rotation
      translate <0,-Size*2,0>
    }
    transform L_Leg_Rotation
    translate <-Size/2.75*0.9,0,0>
  }
#end
texture{ Suit_Texture }
scale (1/16)
}
