#ifndef (My_Clock)
  #declare My_Clock = 0;
#end

#ifndef (End)
  #declare End = 10;
#end

#declare inside = texture {
  pigment {       
    granite      
    color_map { 
      [0  color rgb <0.5, 0.5, 0.5>]      
      [0.5  color rgb <0.7, 0.7, 0.7>]
      [1  color rgb <0.5, 0.5, 0.5>]
    }
  }
}   

#declare panels = difference {
  box {
    <-3.0, 0.4, 12.0>  
    < 3.0, 2.2, 20.0>  
  } 
  difference{
    box {
    <-5,-5,17.95>
    < 5, 5,22>
    }
    cone
    {
      <0, 1.0, 17.9>, 1.6,
      <0, 1.08, 21.0>, 1.2
      scale <3,0.95,1> 
    }
  }  
  box {
    <-1.2, 0.0, 14.9>  
    < 1.2, 2.6, 18.0> 
  }  
  box {
    <-2.7, -0.3, -1.05>  
    < 2.7,  0.3,  1.05>
    rotate -3*x    
    translate <0, 2.45, 19>
  }
  box {
    <-2.1, 2.09, 14.4>  
    < 2.1, 2.6, 18.0> 
  }   
  cone
  {
    <0, 0.4, 17.9>, 0.5,
    <0, 0.4, 20.0>, 0.4
    scale <1.5, 1.5, 1>
  }
  box {
    <-2, -2, 14.9>  
    < 2,  2,  17.99>
    rotate 45*z
    scale <1,0.5,1>    
    translate <0, 2.5, 0>
  }   
  texture {inside scale 3}  
}

#declare scopecolor1 = pigment { 
  wood 
  color_map {
    [0 color rgb <0, 0.5, 0.2>]
    [1 color rgb <0, 1, 0.2>]
  } 
  scale 0.3
  translate -0.25*y
  phase -2*My_Clock
} 

#declare radar = union {
  #declare scope = union {
    box
    {
      <-0.20, -0.25, -0.1>  // one corner position <X1 Y1 Z1>
      < 0.20,  0.25,  0.1>  // other corner position <X2 Y2 Z2>
    }
    box
    {
      <-0.25, -0.20, -0.1>  // one corner position <X1 Y1 Z1>
      < 0.25,  0.20,  0.1>  // other corner position <X2 Y2 Z2>
    }   
    cylinder { <-0.20, -0.20, -0.1>, <-0.20, -0.20, 0.1>, 0.05 }
    cylinder { < 0.20, -0.20, -0.1>, < 0.20, -0.20, 0.1>, 0.05 }
    cylinder { <-0.20, 0.20, -0.1>, <-0.20, 0.20, 0.1>, 0.05 }
    cylinder { < 0.20, 0.20, -0.1>, < 0.20, 0.20, 0.1>, 0.05 }      
  }
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  #ifndef (scopecolor1)
    #declare scopecolor1 = pigment 
     { color rgb <0, 0, 0> }
  #end  
  object { scope scale <0.85, 0.85, 1.002> pigment { scopecolor1 } finish {ambient 0.5}} 

}

#declare scopecolor2 = pigment { 
  gradient x 
  color_map {
    [0.0 color rgb <0.3, 0.0, 0.0>]
    [0.4 color rgb <0.6, 0.0, 0.0>]
    [0.5 color rgb <1, 0.0, 0.0>]
    [0.6 color rgb <0.6, 0.0, 0.0>]
    [1.0 color rgb <0.3, 0.0, 0.0>]
  } 
  scale 0.43
  translate -0.2*x
  phase 0.5*sin(2*My_Clock*pi)
} 

#declare radar2 = union {
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  object { scope scale <0.85, 0.85, 1.002> pigment { scopecolor2 } finish {ambient 0.8}} 
} 

#declare scopecolor2 = pigment { image_map { png "status1.png" once} translate <-0.5, -0.5, 0> scale <.5, .43, 1>  } 
#declare shields = union {
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  object { scope scale <0.85, 0.85, 1.002> pigment { scopecolor2 } finish {ambient 0.8}}
}  

#declare scopecolor3 = pigment { image_map { png "status2.png" once} translate <-0.5, -0.5, 0> scale <.43, .43, 1>  }
#if ((1+sin(6*pi*(My_Clock))) > 1.5)
  #declare scopecolor3 = pigment { image_map { png "status3.png" once} translate <-0.5, -0.5, 0> scale <.43, .43, 1>  }
#end   
#declare shields2 = union {
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  object { scope scale <0.85, 0.85, 1.002> pigment { scopecolor3 } finish {ambient 0.8}}
} 

#declare picture = box {
  <-1, -1, 0>
  < 0,  0, 0>
  scale <.684, .872, 1>
  pigment { image_map { png "Christy.png" /*interpolate 2 once*/} scale <0.7, 0.9, 1> translate <0, 0, 0> } 
} 

#declare frame1 = mod(int(My_Clock*15),75)+1;
#declare screen1 = concat("targe",str(frame1,-3,0),".bmp")  
//#declare screen1 = "target1.bmp" 
#declare monitor1 = union {
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  object { scope scale <0.85, 0.85, 1.002> 
    pigment { image_map { sys screen1 once} translate <-0.5, -0.5, 0> scale <.48, .43, 1>  }
    finish { ambient 0.4 phong 0.1 reflection 0.1 }
  } 
  object { scope scale <0.85, 0.85, 1.003> pigment {color rgbt <0,1,0,0.8> }}         
  object { scope scale <1,1,5> translate 0.4*z texture {inside}} 
  merge {
    cylinder { .05*y, -.05*y, 0.005 }
    cylinder { .05*x, -.05*x, 0.005 }
    pigment { color rgbt <0,1,0,0.75>}
    finish {ambient 1} 
    scale <1,1,0.1>
    translate -0.1*z
  }  
  text { ttf "arial.ttf" "TARGET" 1, 0.1*x
  pigment { color rgbt <0,1,0,0.75> }
  finish { ambient 1 }
  translate -2.1*x translate -0.375*y translate -1.5*z 
  scale 0.07 
  translate -0.17*y
  no_shadow  
  }
}     

#declare cockpit1 = union {
  object { panels }
  object { radar translate <0, 1.75, 18> }  
  object { radar2 scale 0.5 translate <-0.55, 1.85, 18> }
  object { shields scale 1 rotate 5*x translate <-0.9, 1.40, 18> }
  object { picture scale 0.25 rotate 15*z translate <0.85, 2, 17.99>}
  object { monitor1 scale 0.8 rotate 35*x rotate 25*y translate <1, 1.8, 17.8> }
  translate <0,-1,-14.6>
}
  
#declare cockpit2 = union {
  object { panels }
  object { radar translate <0, 1.75, 18> }  
  object { radar2 scale 0.5 translate <-0.55, 1.85, 18> }
  object { shields2 scale 1 rotate 5*x translate <-0.9, 1.40, 18> }   
  object { monitor1 scale 0.8 translate -0.1*z rotate 35*x rotate 25*y translate <0.7, 1.8, 17.2> }  
  translate <0,-1,-14.6>
}