//
// PUrsuit animation
//
// By Michael Sobers
// 12/17/00
//
// POVRay 3.1
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc" 
#include "spline.mcr" 

#declare GREY = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.10
        metallic
        reflection 0.05
    }
    pigment { rgb <0.8, 0.8, 0.8> }
}

#declare DIRT = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 3
          lambda 3 //3 to 6
          omega 0.4 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.4  color rgbt <1, 1, 1, 0.9>] 
           [0.49 color rgbt <0.5, 0.1, 0.05, 0.5>]     
           [0.5  color rgbt <0.3, 0.1, 0.03, 0.8>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.5
    } 
} 

#declare DUST = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 5
          lambda 4 //3 to 6
          omega 0.3 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.3  color rgbt <1, 1, 1, 0.9>] 
           [0.4 color rgbt <0.5, 0.3, 0.1, 0.8>]     
           [0.5  color rgbt <0.65, 0.3, 0.05, 0.6>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.6
    } 
}

#declare DARK = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.8
    }
    pigment { rgb <0.000, 0.000, 0.239> }
}

#declare laser = media {
  emission 1.1
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    cylindrical
    ramp_wave
    turbulence 0.1
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.05 color rgb <0.0, 1, 0.2>]
      [0.8 color rgb <0.3, 1, 0.3>]
      [1.0 color rgb <0.6, 1, 0.4>]
    } scale 0.6
  } rotate 90*z
} 



////////////////////////

// Sky
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0 color rgb <0.6, 0.4, 0.4>]
      [0.3 color rgb <0.4, 0.2, 0.2>]
      [1.0 color rgb <0.1, 0.1, 0.6>]
    }  
    scale 2
    translate -1
  }
  pigment {
    wrinkles
    turbulence .5
    octaves 6
    lambda 5 //3 to 6
    omega 0.3 //0.2 to 0.6
    color_map {
      [0 color rgbt <1, 1, 1, 1>]
      [0.5 color rgbt <0.98, 0.99, 0.99, .8>]
      [1 color rgbt <1, 1, 1, 1>]
    }
    scale <.8, .1, .8>
  }  
}

fog {
  distance 1500
  color rgbt<0.4, .45, .45, .5>
  fog_type 2
  fog_offset 1
  fog_alt 70
  turbulence 0.2
  turb_depth 0.3
 
} 

light_source{ <-10000,30000, -500> White }
       
////////////////////////    

#declare land_visible  = true;
#declare craft_visible = true;  

#declare ab = 0.6;
#declare bf = 0.05;
#declare df = 0.1;    

///////////////////////

#declare Start    = 0.0;
#declare End      = 45.0;
#declare My_Clock = Start+(End-Start)*clock; 

#declare temp = 0.6+sin(3*My_Clock*pi)*0.35;
#declare engine = media {
  emission 0.5
  intervals 40
  samples 1, 1
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 0.01
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.2 color rgb <1, 0.2, 0.3>]
      [temp color rgb <1, 0.5, 0.7>]
      [1.0 color rgb <1, 0.8, 0.7>]
    } scale 1
  } 
} 
             
#declare Flight_1 = create_spline_from_file ("flight1.spl", create_hermite_spline 
  + spline_file_points (44)
  + spline_sampling (1)
/*  + spline_cache_file ("f1cashe")*/) 

evaluate_spline (Flight_1, 
      even_spline_spacing (true)
      + spline_clock (My_Clock/End))
      
#declare ship_location = spline_pos;        
  
//preview_spline (Flight_1, spline_radius (3) + show_spline_tangents (true))  

#declare follow = true;

#switch (My_Clock)
  #range (0,3)
    #declare camera_location = <3,20,50>;
    #declare camera_look_at = <0,0,0>;
    #declare follow = true;  
  #break
  #range (3,5)
    #declare camera_location = <-0.5,8.25,1.5>;
    #declare camera_look_at =  <-0.9,7.6,3> + (My_Clock-3)*<1.8,0.2,0.2>/3; 
    #declare camera_angle = 40; 
    #declare follow = true;
  #break       
  #range (5,6)
    #declare camera_location = <-0.5,8.25,1.5>;
    #declare camera_look_at =  <-0.9,7.6,3> + (My_Clock-3)*<1.8,0.2,0.2>/3;
    #declare camera_angle = 40 - (My_Clock-5)*18; 
    #declare follow = true;
  #break  
  #range (6,7) 
    #declare camera_location = <-0.5,8.25,1.5>;
    #declare camera_look_at =  <-0.9,7.6,3> + <1.8,0.2,0.2> + sin(0.5*(My_Clock-6)*pi)*<0.19,0.05,0>;
    #declare camera_angle = 22 - sin(0.5*(My_Clock-6)*pi)*21; 
    #declare follow = true;
  #break 
  #range (7,9)
    #declare camera_location = <-0.5,8.25,1.5>;
    #declare camera_look_at =  <-0.87,7.55,3>;
    #declare camera_angle = 40 - 20*sin(0.25*(My_Clock-7)*pi);
    #declare follow = true;   
  #break  
  #range (9,10)
    #declare camera_location = <0.5,8.25,1.5>;
    #declare camera_look_at =  <0.9,7.8,3.2> + sin(0.5*(My_Clock-9)*pi)*<-0.15,0.1,0>;
    #declare camera_angle = 20 - sin(0.25*(My_Clock-9)*pi)*5; 
    #declare follow = true;     
  #break
  #range (10,11) 
    #declare camera_location = <0.5,8.25,1.5>;
    #declare camera_look_at =  <0.9,7.8,3.2> + <-0.15,0.1,0>;
    #declare camera_angle = 20 - sin(0.25*(My_Clock-9)*pi)*5; 
    #declare follow = true;
  #break 
  #range (14.25,14.75)  // transition to look into hangar
    #declare camera_location = <-390,-28,200>;
    #declare camera_look_at =  <-430, -26, 290> + (ship_location-<-430, -26, 290>)*sin((My_Clock-13.75)*pi); 
    #declare follow = false; //Don't follow flight1 spline    
  #break
  #range (14.75,15.5) // hang tight wile the lights come up
    #declare camera_location = <-390,-28,200>;
    #declare camera_look_at =  <-430, -26, 290>; 
    #declare follow = false; //Don't follow flight1 spline    
  #break 
  #range (15.5,17.5)  // transition
    #declare camera_location = <-390,-28,200> + <50,20,-50>*(1+sin(0.5*(My_Clock-16.5)*pi))*0.5 + <0,0,-50>*sin(0.5*(My_Clock-15.5)*pi);
    #declare camera_look_at =  <-430, -26, 290> + <40,40,0>*(1+sin(0.5*(My_Clock-16.5)*pi))*0.5;  
    #declare follow = false; //Don't follow flight1 spline    
  #break 
  #range (17.5,21) // shields up
    #declare camera_location = <0,10,-70>;
    #declare camera_look_at = <0,0,0>;
    #declare follow = true;
  #break
  #range (21,24)
    #declare camera_location = <0,20,50>;
    #declare camera_look_at = <0,10,-30>;
    #declare follow = true;
  #break           
  #else 
    #declare camera_location = <0,18,-61>;
    #declare camera_look_at =  <0,11,50>; 
    #declare follow = true;  
#end  //switch
  

camera{     
    location camera_location
    #ifdef (camera_angle) 
      angle camera_angle
    #end  
    look_at camera_look_at
    #if (follow)
      animate_by_spline (Flight_1, 
      even_spline_spacing (true)
      + spline_clock (My_Clock/End)
      + auto_banking (ab)
      + direction_foresight (df)
      + banking_foresight (bf)
      )   
    #end       
  }

light_source { 
  camera_location 0.3*White   
  fade_distance 2.5
  fade_power 3.0
  shadowless 
      animate_by_spline (Flight_1, 
      even_spline_spacing (true)
      + spline_clock (My_Clock/End)
      + auto_banking (ab)
      + direction_foresight (df)
      + banking_foresight (bf)
      )     
}

#if (land_visible)

#declare wave = texture {
  normal { 
      gradient z
      phase My_Clock*pi
      scale <1, 2, 5>
      sine_wave
  } 
  pigment { color rgbt <0.1, 0.1, 0.6, 0.5> } 
  finish { phong 0.6 reflection 0.2 }
}

#declare bump = texture { 
  pigment { color rgbt <0.22, 0.2, 0.4, 0.4> } 
  finish { phong 0.6 reflection 0.2 }
  normal {bumps 0.5}
  scale <5, 1, 5>
  translate <My_Clock, My_Clock, My_Clock>
}                 

box
{
  <-2000, -80, -2000>  // one corner position <X1 Y1 Z1>
  < 2000,  -110,  6000>  // other corner position <X2 Y2 Z2>
  texture { bump }
  hollow on
} 

#end // if land_visible 

#macro bluelight (position, bluelight_brightness)
  intersection {
    sphere
    {
      <0, 0, 0>
      1.0       
      scale <2,2,1>
      texture {
        finish { ambient bluelight_brightness diffuse 0.8 }
        pigment { 
          wood 
          turbulence 0.2 
          color_map {
           [0  color rgb <0.3, 0.3, 0.5>]
           [0.7  color rgb <0.1, 0.1, 0.4>]
           [1  color rgb <0.6, 0.6, 1>]
          }
          scale 1
          rotate 2*My_Clock*y
          rotate 5*My_Clock*x
          translate x*My_Clock*3
        }
      }
      scale 4
      translate position
    }
    box { <-45, -7.9, -100> < 45,  25,  -19>  }
    rotate -10*y
    translate <-430, -35, 350>
    no_shadow  
  }
#end

#declare redlight = union {
  merge {
    sphere { <0, 0, 0> 0.5 }
    cylinder { <0, 0, 0> <0, 0.85, 0> 0.5 }
    pigment { color rgbf <1.0, 0.1, 0, 0.6 > }
    finish { ambient 0.8 diffuse 0.6 }
  }
  disc {
    <0, 0, 0> z, 0.3
    rotate 8*x
    translate < 0, 0, 0.1 >
    rotate 540*My_Clock*y 
  }
  cylinder { 
    <0, 0.84, 0> <0, 1.0, 0> 0.7
    pigment { rgb <0.647, 0.647, 0.647> }
    finish { ambient 0.7 diffuse 0.5 }
  }                                   
  light_source{ <0, 0, 0> color rgb <0.8, 0.0, 0.0> 
    looks_like { sphere { 
        <0, 0, 0> 0.1 
        pigment { color White } 
        finish { ambient 1}
        }
    }
    fade_distance 50
    fade_power 5.0
  }     
} 

#if (land_visible)

difference {
  height_field {
      png "groundmap2.png"
      smooth
      pigment {       
      granite      
        color_map { 
          [0  color rgb <0.3, 0.1, 0.03>]      
          [0.5  color rgb <0.9, 0.5, 0.3>]
          [1  color rgb <0.5, 0.3, 0.1>]
        }
      } 
      translate <-.5, -.5, -.5>
      scale <4000, 200, 4000>   
      rotate -90*y
  }
  box {
    <-45, -7.9, -100> 
    < 45,  25,  -19>
    rotate -10*y 
    translate <-430, -35, 350>
    texture {
      finish {
          ambient 0.20
          diffuse 0.30
      }
      pigment { rgb <0.647, 0.647, 0.647> }
    }
  }
  hollow
} 

#end // if land_visible 

#declare bluelight_intensity = <0.1, 0.1, 0.1>;
#declare bright = 0.2;

#if (My_Clock > 14.75)
 #if (My_Clock < 15.25)
  #declare bright = 0.6*sin((My_Clock-14.75)*pi)+0.2;
  #declare bluelight_intensity = <0.3, 0.3, 0.35>*sin((My_Clock-14.75)*pi);
 #else
   #declare bright = 0.8;
   #declare bluelight_intensity = <0.3, 0.3, 0.35>;
 #end
#end  
  
bluelight (<-44, 24, -40>, bright)
bluelight  (<44, 24, -25>, bright)
bluelight (<-44, 24, -90>, bright)
bluelight (<44, 24, -70>, bright)

light_source { 
  0*x // light's position (translated below)
  color rgb bluelight_intensity
  translate <24, 24, -90> 
  rotate -10*y   
  translate <-430, -35, 350>
  fade_distance 60
  fade_power 2.0
}

light_source { 
  0*x // light's position (translated below)
  color rgb bluelight_intensity
  translate <-24, 24, -90> 
  rotate -10*y   
  translate <-430, -35, 350>
  fade_distance 60
  fade_power 2.0  
} 

object { redlight translate <0, 24, -70> rotate -10*y translate <-430, -35, 350> }  
//light_source { camera_location color 0.5*White }

#if (land_visible)

difference {
 height_field {
    png "groundmap3.png"
    smooth
    pigment {       
    granite      
      color_map { 
        [0  color rgb <0.3, 0.1, 0.03>]      
        [0.5  color rgb <0.9, 0.5, 0.3>]
        [1  color rgb <0.5, 0.3, 0.1>]
      }
    } 
    translate <-.5, -.5, -.5>
    scale <4000, 200, 4000>   
    rotate -90*y
    matrix < 1, 0, 0,
             0, 1, 0, 
             0, 0, -1,
             0, 0, 0>
    translate <0, 0, 4000 >
  }

  cylinder
  { 150*z, -20*z, 45
    texture {
      finish {
          ambient 0.10
          diffuse 0.30
      }
      pigment { rgb <0.647, 0.647, 0.647> }
    }  
  scale <2, 1, 1>  
  rotate 50*y
  translate <-450, -10, 2850>
  }
}  

#declare ring = torus
{
  45,
  1
  scale <1,0.5,1>     
  rotate 90*x
  scale <2, 1, 1>  
}

#declare ring_number = 0;
#while (ring_number < 8)
  object { ring   
    translate <0, 0, 10+15*ring_number>  
    rotate 50*y
    translate <-450, -10, 2850>    
    texture {
      finish {
          ambient 0.5+0.4*sin(pi*ring_number/4+6*My_Clock*pi)
          diffuse 0.30
      }
      pigment { rgb <0.7, 0.7, 1> }
    }    
  }
  #declare ring_number = ring_number + 1;
#end  

light_source { 
  40*z // light's position (translated below)
  color rgb <0.2, 0.2, 0.4>
  rotate 50*y   
  translate <-450, 30, 2850>
  fade_distance 40
  fade_power 2.0  
}

intersection {
  union{
    height_field {
        png "groundmap2.png"
        smooth
        translate <-.5, -.5, -.5>
        scale <4000, 200, 4000>   
        rotate -90*y
    }
    height_field {
      png "groundmap3.png"
      smooth
      translate <-.5, -.5, -.5>
      scale <4000, 200, 4000>   
      rotate -90*y
      matrix < 1, 0, 0,
               0, 1, 0, 
               0, 0, -1,
               0, 0, 0>
      translate <0, 0, 4000 >
    } 
  }
  box {
    <500, 80, 0>
    <700, 110, -300>  
  }   
  texture {
    gradient y
    texture_map { 
     [0 pigment { color rgbt <1, 1, 1, 1>}]
     [0.8 DUST scale 20]
    }
    scale <1,20,1>
  }  
  translate .001*y     
}  

#end // #if (land_visible)

//////////////////////////////////////////////////////

#declare x1 = sin(4*My_Clock);
#declare y1 = sin(2.5*My_Clock);
#declare z1 = sin(2*My_Clock);

/*Pilot***************************************************************************/
#declare Gender = 1; 
#declare move = pow(sin(0.5*(My_Clock+0.2)*pi),8);
#if (My_Clock > 6.3)
  #declare move =0; 
#end
#declare Head_Rotation = <15*sin(My_Clock*pi/2),-30*sin(My_Clock*pi),0>; 
#declare Neck_Rotation = transform {rotate (15-15*move)*x}
#declare Torso_Rotation = transform {rotate (-15+20*move)*x}
#declare L_Arm_Rotation = transform {rotate (-20-20*move)*x rotate 10*y rotate -20*z}
#declare L_Elbow_Rotation = transform {rotate 40*y rotate 0*z rotate -50*x}
#declare L_Hand_Position = "fist" 
#declare R_Hand_Position = "custom"
#declare R_Index_Curve = transform{ rotate x*20 }
#declare R_Index_Rotation = transform{ rotate x*(20-30*move)}
#declare R_Middle_Curve = transform{ rotate x*(20+60*move) }
#declare R_Middle_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Ring_Curve = transform{ rotate x*(20+50*move) }
#declare R_Ring_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Pinky_Curve = transform{ rotate x*(20+40*move) }
#declare R_Pinky_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Thumb_Curve = (20+20*move);
#declare R_Thumb_Rotation = transform{ rotate z*(-35+95*move) rotate y*(-60+160*move) }

#declare R_Arm_Rotation = transform {rotate (-20-63*move)*x rotate (-4*move)*y rotate 20*z}
#declare R_Elbow_Rotation = transform {rotate (-10-50*move)*y rotate (-60+50*move)*x  rotate 0*z}
#declare L_Leg_Rotation = transform {rotate -90*x rotate -3*y rotate 5*z}
#declare R_Leg_Rotation = transform {rotate -90*x rotate 3*y rotate -5*z}
#declare L_Shin_Rotation = transform {rotate <17,2,0>}
#declare R_Shin_Rotation = transform {rotate <17,2,0>}

#ifdef (Suit_Texture) 
  #undef Suit_Texture
#end
#declare Suit_Pigment = pigment {colour rgb <0.2,.55,.7>}

#include "pilot.inc"
/***************************************************************************/

#if (craft_visible)

#include "ship.inc" 

object {
 #if ((My_Clock > 7) & (My_Clock < 9)) 
  union{ object { ship1a } object { Pilot scale 2.7 translate <0,0,1>} } 
 #else
  union{ object { ship1 } object { Pilot scale 2.7 translate <0,0,1>} object { shield1 }}
 #end 
  #if (My_Clock < 3)
    rotate (1.5*cos(1.6*My_Clock)-1.5*cos(2.6*My_Clock))*z  
  #end  
  translate <0, 7, 0> 
  #if (My_Clock < 3)
    translate (1+0.5*sin(My_Clock))*<z1,y1,x1>
  #end  
  animate_by_spline (Flight_1, 
  even_spline_spacing (true)
  + spline_clock (My_Clock/End)
  + auto_banking (ab)
//  + max_banking_angle (Float)
//  + auto_rotate (Vector/Float)    // Fraction for pitch/heading
  + direction_foresight (df)
  + banking_foresight (bf)
  )

}   

object {
  union{ object { ship1a } object { Pilot scale 2.7 translate <0,0,1>} object { shield2 }}
  rotate (1.5*cos(1.5*My_Clock)-1.5*cos(2.5*My_Clock))*z
  #if (My_Clock > 9.5)   
    rotate (6.5*cos(10.5*My_Clock)-2.5*cos(30*My_Clock))*z
  #end
  translate <25, -7, -10> 
  #if (My_Clock > 6)
    #if (My_Clock < 9.5)
      translate (1+0.5*sin(0.8*My_Clock))*<x1,y1,z1> 
    #else  
      translate 3*(1+0.5*sin(0.8*My_Clock))*<x1,y1,0.5*z1>     
    #end
  #end
  animate_by_spline (Flight_1, 
  even_spline_spacing (true)
  + spline_clock (My_Clock/End)
  + auto_banking (ab)
//  + max_banking_angle (Float)
//  + auto_rotate (Vector/Float)    // Fraction for pitch/heading
  + direction_foresight (df)
  + banking_foresight (bf)
  )
  
}  

object {
  union{ object { ship1 } object { Pilot scale 2.7 translate <0,0,1>} object { shield3 }} 
  rotate (1.5*cos(1.7*My_Clock)-1.5*cos(2.3*My_Clock))*z  
  translate <-25, -7, -10> 
  #if (My_Clock > 6)
    translate (1+0.5*sin(1.2*My_Clock))*<y1,x1,y1>  
  #end
  animate_by_spline (Flight_1, 
  even_spline_spacing (true)
  + spline_clock (My_Clock/End)
  + auto_banking (ab)
//  + max_banking_angle (Float)
//  + auto_rotate (Vector/Float)    // Fraction for pitch/heading
  + direction_foresight (df)
  + banking_foresight (bf)
  )  
   
} 

#end // #if (craft_visible) 

