// Persistence of Vision Ray Tracer Scene Description File
// File: ship.inc
// Vers: 3.1
// Desc: Include File for Ship
// Date: 12/17/00
// Auth: Michael Sobers
//

#version 3.1;

#include "colors.inc"
#include "cockpit.inc"

#ifndef (SHIP_SKIN)
  #declare SHIP_SKIN = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.01
        metallic
        reflection 0.05
    }
    pigment { rgb <0.8, 0.8, 0.8> }
  } 
#end  

#ifndef (DIRT)
  #declare DIRT = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 3
          lambda 3 //3 to 6
          omega 0.4 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.4  color rgbt <1, 1, 1, 0.9>] 
           [0.49 color rgbt <0.5, 0.1, 0.05, 0.5>]     
           [0.5  color rgbt <0.3, 0.1, 0.03, 0.8>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
      }
      scale 0.5 
  } 
#end  

#ifndef (GLASS)
  #declare GLASS = texture {
    pigment { color rgbt <0.0,0.8,0.3,0.87> }  
    finish { reflection 0.2 }
  }
#end   

#ifndef (GLASS2)
  #declare GLASS2 = texture {
    pigment { color rgbt <0.05,0.0,0.3,0.87> }  
    finish { reflection 0.8 }
  }
#end 

#declare DARK = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.8
        reflection 0.3
    }
    pigment { rgb <0.05, 0, 0.2> }
}

#ifndef (My_Clock) 
  #declare My_Clock = 0;
#end  
  
#declare temp = 0.6+sin(3*My_Clock*pi)*0.35;
#ifndef (ENGINE_GLOW)
  #declare ENGINE_GLOW = media {
  emission 1.5
  intervals 40
  samples 1, 1
  confidence 0.9999
  variance 1/1000
  density {
    cylindrical
    ramp_wave
    turbulence 0.05
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.2 color rgb <.3, 0.2, 1>]
      [temp color rgb <.5, 0.5, 1>]
      [1.0 color rgb <.5, 0.7, 1>]
    } scale 1
  } 
} 
#end 
 
#ifndef (TURBINE)
  #declare TURBINE = media {
  emission 0.6
  intervals 40
  samples 1, 1
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    turbulence 0.5
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.14 color rgb <0, 0, 0.5>]      
      [0.15 color rgb <1, 0.2, .3>] 
      [0.3 color rgb <1, 0.2, .3>]     
      [0.31 color rgb <0, 0, 0.5>]
      [0.4 color rgb <0, 0, 0>]            
      [0.44 color rgb <1, 0.2, 0.3>]      
      [0.55 color rgb <1, 0.2, .3>] 
      [0.6 color rgb <1, 0.2, .3>]
      [0.61 color rgb <0, 0, 0.5>]
      [0.7 color rgb <0,0,0>]              
      [0.84 color rgb <0, 0, 0.5>] 
      [0.85 color rgb <1, 0.2, 0.3>]                 
      [1.0 color rgb <1, 0.2, .3>]
    } scale 0.3 rotate My_Clock*720*z
  } 
} 
#end  

#ifndef (INLET_GLOW)
  #declare INLET_GLOW = media {
  emission 0.2
  intervals 40
  samples 1, 1
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 0.2
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.6 color rgb <.5, 0.2, .3>]
      [0.8 color rgb <1, 0.3, .2>]
      [1.0 color rgb <1, 0.4, .3>]
    } 
  } 
} 
#end  

#declare SHIELD_GLOW = texture {
   pigment {
     wrinkles
     turbulence .6
     octaves 3
     lambda 3 //3 to 6
     omega 0.4 //0.2 to 0.6
     color_map {
      [0 color rgbt <1, 0.6, 1, 1>]
      [0.56 color rgbt <1, 0.5, 1, .9>]
      [0.56 color rgbt <1, 0.5, 1, 0.7>]
      [0.60 color rgbt <0.5, 0.5, 1, 0.7>]
      [0.64 color rgbt <1, 0.5, 1, 0.7>]
      [0.64 color rgbt <1, 0.5, 1, 0.9>]
      [1 color rgbt <1, 0.6, 1, 1>]
     }        
     scale 10 translate <0,0,10*My_Clock>
   }
   finish { diffuse 0 ambient 1 } 
}  
 
// SHIP TYPE 1----------------------------------------

#declare wings = union {
  difference {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <1,1,3> rotate 30*y translate <0.4,0,0.8>}
      sphere   { <0.4,0,1.56>, 0.5, -0.3 } 
      sphere   { <0.6,0,0.4>, 0.5, -0.2 }
      scale <1,0.1,1>
    }
    box { <-0.01,-1,-1> <-2,1,2> }  
    box { <-1,-1,0> <2,1,-2> } 
    sphere { 0, 0.08 scale <1,1,2> rotate 5*y translate <0.83,0,1.6>}  
    rotate -3*z
  }   
  difference {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <1,1,3> rotate 30*y translate <0.4,0,0.8>}
      sphere   { <0.4,0,1.56>, 0.5, -0.3 } 
      sphere   { <0.6,0,0.4>, 0.5, -0.2 }
      scale <1,0.1,1>
    }
    box { <-0.01,-1,-1> <-2,1,2> }  
    box { <-1,-1,0> <2,1,-2> }   
    sphere { 0, 0.08 scale <1,1,2> rotate 5*y translate <0.83,0,1.6>} 
    rotate 183*z
  } 
  texture { SHIP_SKIN }
  normal { 
    bump_map { 
      gif "wing.gif" 
      map_type 0
      interpolate 2 
      bump_size 1.0
    }     
    rotate 90*x
    translate <0.5,0,-0.15>
    scale <2.8,2.2,2.2>
  }
  scale <1,1,1.1> 
  translate 0.1*z
}

#declare tail = difference {
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <1.2,1,2.8> rotate 25*y translate <0.4,0,1.1>}
    sphere   { <0.3,0,1.7>, 0.6, -0.7 } 
    scale <1,0.1,1> 
    rotate 90*z
  }           
  box { <-1,0,0> <1,-1,3> }  
  texture { SHIP_SKIN }
  normal { 
    bump_map { 
      gif "tail.gif" 
      map_type 0
      interpolate 2 
      bump_size 1.0
    }     
    rotate 90*y
    translate <0,-0.08,-1.05>
    scale <1,1.15,2.2>
  }
}    

#declare inlet_side =  union {
  difference {
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,1,0.5> translate <0.25,0.1,1.5>}
      cylinder { <0.05,0.08,0.21>, <0.3,0.1,1.4>, 0.2, 2 }
      sphere { 0, 0.8, -1.8 scale <1,0.5,2> rotate -15*x translate <0,0.2,0>}
    }  
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,1,0.5> translate <0.25,0.1,1.5>}
      cylinder { <0.05,0.08,0.21>, <0.3,0.1,1.4>, 0.2, 2 }
      sphere { 0, 0.8, -1.8 scale <1,0.5,2> rotate -15*x translate <0,0.2,0>}
      scale <.99,.99,1>
    }  
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,0.85,0.8> translate <0.25,0.12,1.5>}    
    }
    texture { SHIP_SKIN }
    texture { DIRT }   
  }
  difference {
    blob {
      threshold 0.6
      sphere { 0, 0.4, 1 }    
      hollow on
      texture { pigment { color rgbt <1,1,1,1>}} 
    }
    blob { 
      threshold 0.6
      sphere { 0, 0.4, 1 }    
      texture { pigment { color rgbt <1,1,1,1>}}
      scale 0.5 
    }        
    interior { media {INLET_GLOW}}
    scale 0.95*<1,0.85,0.8> translate <0.25,0.12,1.45>
  }    
  blob 
  {
    threshold 0.6
    sphere { 0, 0.4, 1 }    
    hollow on
    texture { pigment { color rgbt <1,1,1,1>}} 
    interior { media {TURBINE}}
    scale 0.9*<1,0.85,0.8> translate <0.25,0.12,1.45>  
  }    
}

#declare inlet = union {
  object {inlet_side}
  object {inlet_side scale <-1,1,1> }   
  difference {
    blob 
    { 
      threshold 0.6
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.04,0.16>}  
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1.2 scale <1.0,1.4,1.9> translate<0,0.04,0.26>}
      texture { SHIP_SKIN }
      texture { DIRT }             
    } 
    blob 
    { 
      threshold 0.6
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.04,0.14>}  
    }       
  }       
}

#declare fuselage = difference {
  union {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
      sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
      sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>}
      texture { SHIP_SKIN }
      texture { DIRT }   
    } 
    object { inlet }  
   
  }
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
    sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
    sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>}
    scale <.9,.9,.99> 
    texture { SHIP_SKIN }    
  }  
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { SHIP_SKIN }
  }
  normal { 
    bump_map { 
      gif "scales2.gif" 
      map_type 2
      interpolate 2
      bump_size 1.0
    }     
    scale 0.1
    rotate 70*x 
  }  
}  

#declare canopy = difference {
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { GLASS }  
  }    
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale 0.9*<0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { GLASS }  
  }     
  hollow
  interior{ior 1.1}     
}   

#declare exhaust = blob 
{ 
  threshold 0.6
  cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.039,0.139>} 
  hollow on
  texture { pigment { color rgbt <1,1,1,1>}} 
  interior { media {ENGINE_GLOW}}
}   

#declare ship1 = union {
  union {
    object { fuselage scale <1,1,1>}  
    object { canopy }
    object { wings scale <0.9,1,1.3> texture {DIRT}}  
    object { tail scale <0.9,0.8,1> texture {DIRT}}  
    object { exhaust }  
    translate <0,-0.1,-1.8> 
    scale <10,9,10> 
  }
  difference {
    object { cockpit1 }
    difference {
      box { <-4,-4,-4>, <4,4,8> }
      blob
      {
        threshold 0.6
        sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
        sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
        sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>} 
        scale <.9,.9,.99>
        translate <0,-0.1,-1.8>         
        scale <10,9,10>
      }
    }   
  }  
}   

#declare ship1a = union {
  union {
    object { fuselage scale <1,1,1>}  
    object { canopy }
    object { wings scale <0.9,1,1.3> texture {DIRT}}  
    object { tail scale <0.9,0.8,1> texture {DIRT}}  
    object { exhaust }  
    translate <0,-0.1,-1.8> 
    scale <10,9,10> 
  }
  difference {
    object { cockpit2 }
    difference {
      box { <-4,-4,-4>, <4,4,8> }
      blob
      {
        threshold 0.6
        sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
        sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
        sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>} 
        scale <.9,.9,.99>
        translate <0,-0.1,-1.8>         
        scale <10,9,10>
      }
    }   
  }  
}

// SHIP TYPE 2 ---------------------------------------//
#declare wings = union {
  difference {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <1,1,3> rotate 30*y translate <0.4,0,0.8>}
      sphere   { <0.4,0,1.56>, 0.5, -0.3 } 
      sphere   { <0.6,0,0.4>, 0.5, -0.2 }
      scale <1,0.1,1>
    }
    box { <-0.01,-1,-1> <-2,1,2> }  
    box { <-1,-1,0> <2,1,-2> } 
    sphere { 0, 0.08 scale <1,1,2> rotate 5*y translate <0.83,0,1.6>}  
    rotate -3*z
  }   
  difference {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <1,1,3> rotate 30*y translate <0.4,0,0.8>}
      sphere   { <0.4,0,1.56>, 0.5, -0.3 } 
      sphere   { <0.6,0,0.4>, 0.5, -0.2 }
      scale <1,0.1,1>
    }
    box { <-0.01,-1,-1> <-2,1,2> }  
    box { <-1,-1,0> <2,1,-2> }   
    sphere { 0, 0.08 scale <1,1,2> rotate 5*y translate <0.83,0,1.6>} 
    rotate 183*z
  } 
  texture { DARK }
  normal { 
    bump_map { 
      gif "wing.gif" 
      map_type 0
      interpolate 2 
      bump_size 1.0
    }     
    rotate 90*x
    translate <0.5,0,-0.15>
    scale <2.8,2.2,2.2>
  }
  scale <1,1,1.1> 
  translate 0.1*z
}

#declare tail = difference {
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <1.2,1,2.8> rotate 25*y translate <0.4,0,1.1>}
    sphere   { <0.3,0,1.7>, 0.6, -0.7 } 
    scale <1,0.1,1> 
    rotate 90*z
  }           
  box { <-1,0,0> <1,-1,3> }  
  texture { DARK }
  normal { 
    bump_map { 
      gif "tail.gif" 
      map_type 0
      interpolate 2 
      bump_size 1.0
    }     
    rotate 90*y
    translate <0,-0.08,-1.05>
    scale <1,1.15,2.2>
  }
}    

#declare inlet_side =  union {
  difference {
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,1,0.5> translate <0.25,0.1,1.5>}
      cylinder { <0.05,0.08,0.21>, <0.3,0.1,1.4>, 0.2, 2 }
      sphere { 0, 0.8, -1.8 scale <1,0.5,2> rotate -15*x translate <0,0.2,0>}
    }  
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,1,0.5> translate <0.25,0.1,1.5>}
      cylinder { <0.05,0.08,0.21>, <0.3,0.1,1.4>, 0.2, 2 }
      sphere { 0, 0.8, -1.8 scale <1,0.5,2> rotate -15*x translate <0,0.2,0>}
      scale <.99,.99,1>
    }  
    blob 
    {
      threshold 0.6
      sphere { 0, 0.4, 1 scale <1,0.85,0.8> translate <0.25,0.12,1.5>}    
    }
    texture { DARK }
  }
  difference {
    blob {
      threshold 0.6
      sphere { 0, 0.4, 1 }    
      hollow on
      texture { pigment { color rgbt <1,1,1,1>}} 
    }
    blob { 
      threshold 0.6
      sphere { 0, 0.4, 1 }    
      texture { pigment { color rgbt <1,1,1,1>}}
      scale 0.5 
    }        
    interior { media {INLET_GLOW}}
    scale 0.95*<1,0.85,0.8> translate <0.25,0.12,1.45>
  }    
  blob 
  {
    threshold 0.6
    sphere { 0, 0.4, 1 }    
    hollow on
    texture { pigment { color rgbt <1,1,1,1>}} 
    interior { media {TURBINE}}
    scale 0.9*<1,0.85,0.8> translate <0.25,0.12,1.45>  
  }    
}

#declare inlet = union {
  object {inlet_side}
  object {inlet_side scale <-1,1,1> }   
  difference {
    blob 
    { 
      threshold 0.6
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.04,0.16>}  
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1.2 scale <1.0,1.4,1.9> translate<0,0.04,0.26>}
      texture {DARK}
    } 
    blob 
    { 
      threshold 0.6
      cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.04,0.14>}  
    }       
  }       
}

#declare fuselage = difference {
  union {
    blob
    {
      threshold 0.6
      sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
      sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
      sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>}
      texture { DARK }
    } 
    object { inlet }  
   
  }
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.9,1.4,3.5> translate <0,0,1.3>}
    sphere { 0, 0.75, -1 scale <5,1.2,3.5> translate <0,-0.65,1.3>}
    sphere { 0, 0.5, -0.3 scale <5,1,3> rotate 0*x translate <0,0.5,0.1>}
    scale <.9,.9,.99> 
    texture { DARK }    
  }  
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { DARK }
  }
  normal { 
    bump_map { 
      gif "scales2.gif" 
      map_type 2
      interpolate 2
      bump_size 1.0
    }     
    scale 0.1
    rotate 70*x 
  }  
}  

#declare canopy = difference {
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale <0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { GLASS2 }  
  }    
  blob
  {
    threshold 0.6
    sphere { 0, 0.75, 1 scale 0.9*<0.65,0.6,1.5> rotate 13*x translate <0,0.25,1.9>}
    texture { GLASS2 }  
  }     
  hollow  
}   

#declare exhaust = blob 
{ 
  threshold 0.6
  cylinder { <-.1,0,0>,<.1,0,0>, 0.1, 1 scale <1.1,1.3,0.6> translate<0,0.039,0.139>} 
  hollow on
  texture { pigment { color rgbt <1,1,1,1>}} 
  interior { media {ENGINE_GLOW}}
}   


#declare ship2 = union {
    object { fuselage scale <1,1,1>}  
    object { canopy }
    object { wings scale <0.9,1,1.3> }  
    object { tail scale <0.9,0.8,1> }  
    object { exhaust }  
    translate <0,-0.1,-1.8> 
    scale <10,9,10> 
}


//**********************************Shields******************

#declare shield_coverage = 0;

#if (My_Clock > 18.0 )
 #if (My_Clock > 38.0 )
   #declare shield_coverage = 1-1.2*(My_Clock-38);
 #else
   #declare shield_coverage = 1.2*(My_Clock-18);
 #end
#end  

#declare shield_coverage = 0;

#declare shield1 = difference {
    sphere { 0 12 scale <1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }}
    sphere { 0 12 scale 0.97*<1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }}    
    box {<-12.01,-5.01,17.01-36.02*shield_coverage> <12.01,7.01,-19.01> 
      texture { 
        pigment { color rgbt <0.7,0.7,1,0.4> }
        finish { ambient 1 diffuse 0 }
      }
    }  
    hollow on 
    no_shadow
}

#declare shield_coverage = 0; // use this line for title photo only

#if (My_Clock > 19.3 )
 #declare shield_coverage = 1.2*(My_Clock-19.3);
 #if (shield_coverage > 0.6) 
   #declare shield_coverage = 0.6 + 0.025*(sin(6*My_Clock)+3*sin(20*My_Clock));   
 #end
#end 

#declare shield_coverage = 0;  // use this line for title photo only

#declare shield2 = difference {
    sphere { 0 12 scale <1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }} 
    sphere { 0 12 scale 0.97*<1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }}    
    box {<-12.01,-5.01,17.01-36.02*shield_coverage> <12.01,7.01,-19.01> 
      texture { 
        pigment { color rgbt <0.7,0.7,1,0.4> }
        finish { ambient 1 diffuse 0 }
      }
    }  
    hollow on
    no_shadow
}                            

#declare shield_coverage = 0;

#if (My_Clock > 18.8 )
 #declare shield_coverage = 1.2*(My_Clock-18.8);
#end 

#declare shield_coverage = 0; // use this line for title photo only      
      
#declare shield3 = difference {
    sphere { 0 12 scale <1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }}
    sphere { 0 12 scale 0.97*<1,0.5,1.5> translate <0,1,-1> texture { SHIELD_GLOW }}    
    box {<-12.01,-5.01,17.01-36.02*shield_coverage> <12.01,7.01,-19.01> 
      texture { 
        pigment { color rgbt <0.7,0.7,1,0.4> }
        finish { ambient 1 diffuse 0 }
      }
    }  
    hollow on
    no_shadow
}