//      Copyright 2000-2001 Andrew Bowcock
#ifdef(Component_inc_Temp)
// do nothing
#else
#debug "Parsing 'components.inc'\n"
#declare Component_inc_Temp = version;


//Components


#include "glass.inc"
#include "colors.inc"
#include "metals.inc"
#include "consts.inc"
#include "screws.inc"
#include "mytextures.inc"

#declare leaddiameter=1;
#declare wirediameter=1;
#declare leadtexture=T_Silver_1A
#declare legtexture=T_Silver_1A 

#macro maincamera()
        #declare campos=<3,3,30>;
        #declare lookpos=<0,0,15>;
        camera {
                location campos
                sky <0,0,1>
                look_at lookpos
                }
#end


#macro table()
        #declare thick=1;
        #declare xo=-500;
        #declare yo=-500;
        #declare xm=1000;
        #declare ym=1000;
        box{<xo,yo,0>,<xo+xm,yo+ym,-thick> pigment{colour rgb<0,.1,.2>}}
#end

#macro tablelight()
        #if (quality>5)
                light_source {<0,10,40> color 1.7 area_light <0,4, 0>, <4, 0, 0>, 4, 4}
                #else
                light_source {<0,10,40> color 1.7}
        #end
#end

#macro tablelight2()
        #if (quality>5)
                light_source {<0,10,100> color 2 area_light <0,4, 0>, <4, 0, 0>, 4, 4}
                #else
                light_source {<0,10,100> color 2}
        #end
#end


#macro board(xo,yo,xm,ym)
        #declare thick=1;
        box{<xo,yo,0>,<xo+xm,yo+ym,-thick>
                //pigment{colour rgb<.1,.4,.1>}}
                pigment {
                    bozo
                    frequency 3            // <- add this line
                    color_map {
                      [0.00 color rgb<.8,.8,.8>]
                      [0.1 color rgb<.2,1,.2>]
                      [1.00 color rgb<.4,1,.2>]
                    }
                    //rotate -45*z
                  }
          }	      
#end

#macro resistor(band1,band2,band3,tolerance)
        #declare leaddiameter=.4;
        #declare length=5;
        #declare diameter=1.2;
        #declare leadlength=5.5;
        #declare bendrad=.6;
        union{
        blob{
                threshold 1
                cylinder{<-length,0,0>,<length,0,0>,diameter,2 scale<1/2,1,1>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,.2 scale <.2,1,1> translate<length/2.6,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,.2 scale <.2,1,1> translate<-length/2.6,0,0>}

                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,4.2 scale<.07,1,1> pigment{colour band1} translate<-2*length/5,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,-4 scale<.07,1,1> translate<-2*length/5,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,4.2 scale<.07,1,1> pigment{colour band2} translate<-length/5,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,-4 scale<.07,1,1> translate<-length/5,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,4.2 scale<.07,1,1> pigment{colour band3} }
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,-4 scale<.07,1,1> }
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,4.2 scale<.07,1,1> pigment{colour tolerance} translate<length/5,0,0>}
                cylinder{<-length/4,0,0>,<length/4,0,0>,diameter,-4 scale<.07,1,1> translate<length/5,0,0>}

                pigment{colour LightWood}
             }
         object{leadbend(bendrad,90) translate<leadlength/2,0,0>}
         object{leadbend(bendrad,90) rotate <0,0,180> translate<-leadlength/2,0,0> } 
         cylinder{<-leadlength/2,0,0>,<leadlength/2,0,0>,leaddiameter/2 texture {leadtexture}}
         cylinder{<bendrad+leadlength/2,0,-diameter/2>,<bendrad+leadlength/2,0,-diameter/2-leadlength/4>,leaddiameter/2 texture {leadtexture}}
         cylinder{<-bendrad-leadlength/2,0,-diameter/2>,<-bendrad-leadlength/2,0,-diameter/2-leadlength/4>,leaddiameter/2 texture {leadtexture}}
         }
#end

#macro leadbend(Radius,angl)
        intersection{
                box{<0,-leaddiameter,-Radius-leaddiameter/2>,<Radius+leaddiameter/2,leaddiameter,Radius+leaddiameter/2>}
                box{<-Radius-leaddiameter/2,-leaddiameter,-Radius-leaddiameter/2>,<0,leaddiameter,Radius+leaddiameter/2> rotate <0,angl,0>}
                torus{Radius,leaddiameter/2}
                texture{leadtexture}
                translate<0,0,-Radius>
        }
#end

#macro resistorbank(rbpins)
        #declare pinspace=2.5;
        union{
                blob{
                        cylinder{<0,-(rbpins-1)*pinspace,0><0,(rbpins-1)*pinspace,0>,pinspace,3 scale <.5,.5,1>}
                        #declare pincount=1;
                        #while (pincount<rbpins)
                                cylinder{<0,(pincount-rbpins/2)*pinspace,0>
                                         <0,(pincount-rbpins/2)*pinspace,-pinspace*.8>,pinspace/2,3}
                                #declare pincount=pincount+1;
                        #end
                        scale <.6,1,1>
                        pigment{DarkBrown}
                      }
                 #declare pincount=1;
                 #while (pincount<rbpins)
                         cylinder{<0,(pincount-rbpins/2)*pinspace,0><0,(pincount-rbpins/2)*pinspace,-pinspace>,pinspace/8 texture {T_Silver_1A}}
                         #declare pincount=pincount+1;
                 #end
             translate z*pinspace*1.5
             }    
#end

#macro chip(chiplegs,wide,chipref)
        #declare legspace=2.5;
        #declare length=legspace*chiplegs/2;
        #if (wide=0)
                #declare wide=5;
                #else
                #declare wide=12;
        #end
        #declare height=3.5;
        //#debug concat(chipref," wide = ",str(wide,4,4),chipref," long = ",str(length,4,4),chr(13))
        union{
        box{<-length/1.99,-wide/1.99,height/3>,<length/1.99,wide/1.99,height/2> pigment{color Gray15}}
        difference{
                box{<-length/2,-wide/2,height/2>,<length/2,wide/2,height> }
                cylinder{<-length/2+wide/8,0,height*.9>,<-length/2+wide/8,0,height*1.01>,wide/8 pigment{colour Gray10}}
                box{<-length/2+wide/8,-wide/8,height*.9>,<-length/1.99,wide/8,height*1.01>pigment{colour Gray10}}
                pigment{color Gray20}
                }
        #declare legcount=0;
        #if (quality>3)
                #while (legcount<chiplegs/2)
                        #declare legcount=legcount+1;
                        object{leg() translate<length/2-legspace*(legcount-.5),wide/2,height/2>}
                        object{leg() rotate <0,0,180> translate<length/2-legspace*(legcount-.5),-wide/2,height/2>}
                #end
                 text { ttf "timrom.ttf" chipref .4, 0 rotate<0,180,0> scale<wide/4,wide/4,1> pigment { Gray75} translate<2,0,height*1.01>  }
         #end
         }
#end

#macro leg()
    #declare legwidth=1.1;
    #declare standoff=.6;
    #declare thick=.1;
    #declare leglength=3;
    union{
    box{<-legwidth/2,0,0>,<legwidth/2,standoff,thick> texture {legtexture}}
    box{<-legwidth/2,standoff-thick,0>,<legwidth/2,standoff,-leglength/2> texture {legtexture}}   
    box{<-legwidth/4,standoff-thick,0>,<legwidth/4,standoff,-leglength> texture {legtexture}}
    }
                
#end

#macro chip_surfacemount(xlegs,ylegs)         // 3.5 mm high
        #declare legpitch=.5;
        union{
        object{chamferbox(xlegs*legpitch,ylegs*legpitch,2,.5,.5) translate z*1.5 pigment{rgb .2}}
        #declare legcount=0;
        #while (legcount<xlegs)
                object{leg_surfacemount(legpitch) translate <(legcount+.5-xlegs/2)*legpitch,-ylegs/2*legpitch,0>}
                object{leg_surfacemount(legpitch) rotate z*180 translate <(legcount+.5-xlegs/2)*legpitch,ylegs/2*legpitch,0>}
                #declare legcount=legcount+1;
        #end
        #declare legcount=0;
        #if (quality>3)
                #while (legcount<ylegs)
                        object{leg_surfacemount(legpitch) rotate z*90 translate <xlegs/2*legpitch,(legcount+.5-ylegs/2)*legpitch,0>}
                        object{leg_surfacemount(legpitch) rotate z*-90 translate <-xlegs/2*legpitch,(legcount+.5-ylegs/2)*legpitch,0>}
                        #declare legcount=legcount+1;
                #end
        #end
        }
#end

#macro leg_surfacemount(legpitch)
        /*difference{
                box{<-legpitch/4,0>  <legpitch/4,-legpitch,2>}
                cylinder{<-legpitch,-legpitch*2,0> <legpitch,-legpitch*2,0>,legpitch*2 scale <1,1,1/legpitch> translate z*1.5*legpitch}
                texture{T_Silver_1A}
                }*/
          #declare theta=90;
          #declare phi=-40;
          #declare leaddiameter=1;
          #declare xs=0;
          #declare ys=0;
          #declare zs=10;
          union{
          wirepiece(0,-2,5)
          wirepiece(0,-4,2)
          wirepiece(0,-6,0)
          texture{T_Silver_1A}
          scale <legpitch/2,.4,.1>
                
                }
                
#end


#macro micropro()
        #declare legpitch=2.5;
        #declare xlegs=17;
        #declare ylegs=17;
        union{
                object{chamferbox(xlegs*legpitch,ylegs*legpitch,2,.5,.5) translate z*4
                         pigment{image_map{gif "microtop.gif"} rotate x*180 scale <xlegs*legpitch,ylegs*legpitch,1> translate <xlegs*legpitch/2,ylegs*legpitch/2,1>}
                         }
                difference{
                        box{<-xlegs*legpitch/2-2,-ylegs*legpitch/2-2,0><xlegs*legpitch/2-2,ylegs*legpitch/2-2,3> pigment {rgb.1}}
                        #declare legcount=0;
                        #if (quality>3)
                                #while (legcount<xlegs)
                                        cylinder{0,<0,0,6>,.4 translate <(legcount+.5-xlegs/2)*legpitch,-ylegs/2*legpitch,0>}
                                        cylinder{0,<0,0,6>,.4 translate <(legcount+.5-xlegs/2)*legpitch,ylegs/2*legpitch,0>}
                                        #declare legcount=legcount+1;
                                #end
                                #declare legcount=0;
                                #while (legcount<ylegs)
                                        cylinder{0,<0,0,6>,.4 translate <xlegs/2*legpitch,(legcount+.5-ylegs/2)*legpitch,0>}
                                        cylinder{0,<0,0,6>,.4 translate <-xlegs/2*legpitch,(legcount+.5-ylegs/2)*legpitch,0>}
                                        #declare legcount=legcount+1;
                                #end
                        #end
                        pigment {rgb 0}
                        }
        }
#end



#macro electrolytic(height,rad)
        union{
                blob{   
                        threshold .1
                        cylinder{<0,0,0>,<0,0,height*20>,rad,20 scale <1,1,.05>}
                        cylinder{<0,0,-1>,<0,0,height+1>,rad*.90,-50}
                        sphere{<0,0,0>,rad,-16 scale <1,1,.8> translate z*height*.2}
                        pigment{image_map{gif "capcover.gif" map_type 2} rotate x*90 scale <1,1,height>}
                     }
                cylinder{<0,0,height*.94>,<0,0,height*.98>,rad*.95 texture{T_Silver_1A}}
                cylinder{<0,0,height*.02>,<0,0,height*.06>,rad*.95 texture{T_Silver_1A}}
                //cylinder{<0,-rad/2,0>,<0,-rad/2,-height>,leaddiameter/3 texture {T_Silver_1A}}
                //cylinder{<0,rad/2,0>,<0,rad/2,-height>,leaddiameter/3 texture {T_Silver_1A}}
               
              }

#end

#macro capacitorbead(beadrad,capstamp)
    union{
        blob{
                sphere{0,beadrad,3 scale<.5,1,1>}
                cylinder{0,<0,-beadrad*.4,-beadrad*.6>,beadrad/4,3}
                cylinder{0,<0,beadrad*.4,-beadrad*.6>,beadrad/4,3}
                scale <.6,1,1>
                pigment{image_map{gif capstamp map_type 1}}
            }
        cylinder{0,<0,-beadrad*.8,-beadrad*1.2>,beadrad/20 texture{T_Silver_1A}} 
        cylinder{0,<0,beadrad*.8,-beadrad*1.2>,beadrad/20 texture{T_Silver_1A}} 
        translate beadrad*z
        }
#end

#macro fuse()
        #declare fuselength=20;
        #declare fusediam=5;
        union{
        difference{
                cylinder{<-fuselength/2,0,0>,<fuselength/2,0,0>,fusediam*.46}
                cylinder{<-fuselength/1.99,0,0>,<fuselength/1.99,0,0>,fusediam*.4}
                hollow
                pigment{rgbt <0,0,0,1>}
                   interior{I_Glass}
                   interior{ior Crown_Glass_Ior}
                   
                  }
        difference{   
                 cylinder{<fuselength/1.99,0,0><fuselength/4,0,0>,fusediam*.5}
                 cylinder{<fuselength/1.99,0,0><fuselength/4,0,0>,fusediam*.46}
                 texture{T_Silver_1A}
                 }
        difference{   
                 cylinder{<-fuselength/1.99,0,0><-fuselength/4,0,0>,fusediam*.5}
                 cylinder{<-fuselength/1.99,0,0><-fuselength/4,0,0>,fusediam*.46}
                 texture{T_Silver_1A}
                 }
         cylinder{<-fuselength/2,0,fusediam*.2>,<fuselength/2,0,0>,fusediam*.01 texture{T_Silver_1A}}
             }         
#end          

#macro led(ledon)
        #declare ledheight=3.5;
        #declare leddiam=2;
        #declare leglength=10;
        
        union{  
              merge{
                cylinder{<0,0,0><0,0,ledheight-leddiam/2>,leddiam/2}
                sphere{<0,0,ledheight-leddiam/2>,leddiam/2}
                difference{
                        cylinder{<0,0,0>,<0,0,ledheight/6>,leddiam*1.3/2}
                        box{<-leddiam/2,leddiam/2,-1><leddiam/2,leddiam,ledheight/5>}
                          }
                hollow
                pigment {rgbt <1,.4,.4,.4>}
                interior{media {absorption rgb <0,2,2> scattering{1 <1,0,0>}}

                 fade_distance .2  fade_power 2
                 }
                 }
                cylinder{<0,-leddiam/3,ledheight/3>,<0,-leddiam/3,-leglength>,leaddiameter/3 texture {T_Silver_1A}}
                cylinder{<0,leddiam/3,ledheight/3>,<0,leddiam/3,-leglength>,leaddiameter/3 texture {T_Silver_1A}}
                box{<-leddiam/4,-leddiam/4,ledheight/3>,<leddiam/4,leddiam/4,ledheight/3.04>  texture {T_Silver_1A}} 
                #if (ledon>=1)
                        light_source{<0,0,ledheight/3> colour <2,1,1>}
                #end
              }
#end

#macro battery()
        #declare boxheight=44;
        #declare boxwidth=26;
        #declare boxdepth=18;
        #declare topchamfer=1;
        #declare sidechamfer=3;
        
      union{
        union{
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>,<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<-boxwidth/2+sidechamfer/2,-boxdepth/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
        box{<boxwidth/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>,<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2> }
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/8>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>pigment{colour Gray15}}
        box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/8>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>pigment{colour Gray15}}
       
        difference{
                union{
                        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2> }
                        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
                        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
                        cylinder{<-boxwidth/2+sidechamfer/2,0,0><boxwidth/2-sidechamfer/2,0,0> 1 scale<1,sidechamfer/2,topchamfer/2> translate<0,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
                     
                        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,0,boxheight/2-topchamfer/2>}
                        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<boxwidth/2-sidechamfer/2,0,boxheight/2-topchamfer/2>}
                        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<-boxwidth/2+sidechamfer/2,0,-boxheight/2+topchamfer/2>}
                        cylinder{<0,-boxdepth/2+sidechamfer/2,0><0,boxdepth/2-sidechamfer/2,0> 1 scale<sidechamfer/2,1,topchamfer/2> translate<+boxwidth/2-sidechamfer/2,0,-boxheight/2+topchamfer/2>}
        
                        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,0>}
                        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,0>}
                        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,0>}
                        cylinder{<0,0,-boxheight/2+topchamfer/2><0,0,boxheight/2-topchamfer/2> 1 scale<sidechamfer/2,sidechamfer/2,1> translate<+boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,0>}
                        object{batterycorner() rotate<0,0,-45> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
                        object{batterycorner() rotate<0,0,-45> translate<boxwidth/2-sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
                        object{batterycorner() rotate<0,0,45> translate<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
                        object{batterycorner() rotate<0,0,45> translate<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
                        object{batterycorner() rotate<0,0,45> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2-topchamfer/2>}
                        object{batterycorner() rotate<0,0,45> translate<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2+topchamfer/2>}
                        object{batterycorner() rotate<0,0,-45> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer/2>}
                        object{batterycorner() rotate<0,0,-45> translate<-boxwidth/2+sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer/2>}
                      }  
                      box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,boxheight/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,boxheight/2-topchamfer> pigment {colour Black}}
                      box{<-boxwidth/2+sidechamfer/2,boxdepth/2-sidechamfer/2,-boxheight/2>,<boxwidth/2-sidechamfer/2,-boxdepth/2+sidechamfer/2,-boxheight/2+topchamfer> pigment {colour Black}}
                     
                    }
        
        pigment {image_map {gif"DuracellPP9.gif" map_type 2} rotate<90,0,0> scale <1,1,boxheight> translate z*boxheight/2 }
        //rotate z*-80
        }
        object{terminalplus() translate<boxwidth/4,0,boxheight/2>}
        object{terminalminus() translate<-boxwidth/4,0,boxheight/2>}
      }

#end

#macro batterycorner()
        difference{
        sphere{<0,0,0>1 scale<sidechamfer/2,sidechamfer/2,topchamfer/2>}
        box{<-.2,-sidechamfer,-topchamfer>,<.2,sidechamfer,topchamfer> }
        }
#end                  

#macro terminalplus()
        #declare termheight=3;
        #declare termrad=8;
        #declare thickratio=20;
        
         difference{   
                        union{
                                cylinder{<0,0,0>,<0,0,termheight/2>,termrad/2}
                                torus{termrad/2,termrad/16  rotate <90,0,0> scale <1,1,2> translate z*termheight*3/4}
                                
                             }
                        merge{
                              //cylinder{<0,0,termheight/thickratio>,<0,0,termheight/2+.3>,termrad*(1-thickratio)/thickratio/2 pigment{colour Blue}}
                              cylinder{<0,0,0>,<0,0,termheight*19/32>,termrad*(1-thickratio)/thickratio/2 }
                              torus{termrad/2,termrad/16*(1-thickratio)/thickratio  rotate <90,0,0> scale z*2 translate z*termheight*3/4 }
                              box{<-termrad/1.8,-termrad/1.8,termheight*3/4><-termrad/4.4,-termrad/4.4,termheight>}
                              box{<-termrad/1.8,termrad/1.8,termheight*3/4><-termrad/4.4,termrad/4.4,termheight>}
                              box{<termrad/1.8,-termrad/1.8,termheight*3/4><termrad/4.4,-termrad/4.4,termheight>}
                              box{<termrad/1.8,termrad/1.8,termheight*3/4><termrad/4.4,termrad/4.4,termheight>}
                              box{<termrad/2.7,termrad/2.7,termheight/2><-termrad/2.7,-termrad/2.7,termheight*3/4> }
                             }
                texture{T_Silver_2B}
            }
#end


#macro terminalminus()
        #declare termheight=3;
        #declare termrad=8;
        #declare thickratio=20;
        union{
                difference{
                        cylinder{<0,0,0>,<0,0,termheight>,termrad*3/8}
                        cylinder{<0,0,0>,<0,0,termheight+1>,termrad*3/8*(1-1/thickratio)}
                           }
                cylinder{<0,0,0>,<0,0,termheight/thickratio>termrad/2}
                torus{termrad*11/32,termrad*1/32 rotate <90,0,0> translate <0,0,termheight>}
                texture{T_Silver_2B}
            }
#end




#macro vertices()
        //sphere{<10,10,10>,leaddiameter*.2}
        light_source{<10,10,50>,colour 1}
        light_source{<10,50,10>,colour 1}
        light_source{<50,10,10>,colour 1}
        //cylinder{<0,0,0>,<10,0,0> leaddiameter/2 pigment{colour Red}}
        //cylinder{<0,0,0>,<0,10,0> leaddiameter/2 pigment{colour Blue}}
        //cylinder{<0,0,0>,<0,0,10> leaddiameter/2 pigment{colour Black}}
        box{<-4,-4,-4><30,-3,30> pigment{colour Gray50}}
        box{<-4,-4,-4><-3,30,30> pigment{colour Gray60}}
        box{<-4,-4,-4><30,30,-3> pigment{colour Gray70}}
#end

#macro lamp(lit)
        #declare bulbrad=7.1;
        #declare bulblength=15;
        #declare screwrad=5.5;                      
        #declare screwheight=5;
    union{
        #if (quality>5)
        /*blob{
                threshold 0.4
                sphere{<0,0,bulblength-bulbrad/2>,bulbrad,4 }
                sphere{<0,0,bulblength-bulbrad*1.2>,bulbrad/2,4}
                sphere{<0,0,bulblength-bulbrad/2>,bulbrad*.625,-8 }
                sphere{<0,0,bulblength-bulbrad*1.2>,bulbrad/2*.625,-8}
                hollow
                interior{ior 0.997
                        //fade_distance 3
                        //media{scattering{1,<0,0,1>}}
                        }
                texture {T_Glass3}//pigment{rgbt<.8,.8,.8,.9>}
                         //finish{reflection 0.2 phong 1} T_Glass3 }

            }
        */
        
        #end
        union{
                #declare sht=0;         //screw starts at ground level
                #declare theta=0;
                #declare phi=0;
                #declare leaddiameter=1;
                #declare xs=0;
                #declare ys=-screwrad/2;
                #declare zs=0;
                wirepiece(0,-screwrad/2+leaddiameter,0)
                #while (sht<screwheight)
                        wirepiece(0,screwrad/2,sht)
                        wirepiece(0,-screwrad/2,sht+screwheight/10)
                        #declare sht=sht+screwheight/7;
                #end
                wirepiece(0,screwrad/2,sht-screwheight/7)
                cone{<0,0,0>,screwrad/2,<0,0,-screwheight/5>,screwrad/5}
                texture{leadtexture}

            }
            
            object{filament() translate z*filheight}
         #if (lit)
            light_source{<-fillength/2,0,filheight+filrad*2> colour <.5,.5,.4> }
            light_source{<0,0,filheight+filrad*2> colour <.5,.5,.4> }
            light_source{<fillength/2,0,filheight+filrad*2> colour <.5,.5,.4> }
            light_source{<-fillength/2,0,filheight> colour <.5,.5,.4> shadowless}
            light_source{<0,0,filheight> colour <.5,.5,.4> shadowless}
            light_source{<fillength/2,0,filheight> colour <.5,.5,.4> shadowless}
                  
            sphere{<0,0,0> bulbrad*.96
                hollow
                pigment{rgbt<.4,.4,.2,.7>}
                interior{ior 0.985
                         media{scattering {1,<.4,.2,0>}
                               density {spherical scale bulbrad*.96}
                        }}
                //texture{T_Glass1}
                translate <0,0,filheight>
                   }
            #else
            intersection {
   sphere{<0,0,bulblength-bulbrad/2>,bulbrad }
//   sphere { <0, 0, 0>, 7 translate <-0.75, 0, 0> }
   interior{I_Glass}
   interior{ior 1.7}//Flint_Glass_Ior}
   texture {
       T_Glass3
       finish {
          //reflection 0                  // Over-ride reflection
       }
   }
}
            /*
            difference{
                sphere{<0,0,bulblength-bulbrad/2>,bulbrad }
                sphere{<0,0,bulblength-bulbrad/2>,bulbrad*.99}
                hollow
                //pigment{rgbt<0,0,0,1>}
                //interior{I_Glass
                         ior 0.997}
                texture {T_Glass3}
                //transmit 1
                
                }
                */
         #end
            }
#end

#macro filament()
        union{
                #declare filrad=.4;      //radius of filament coil
                #declare fillength=2;     //length of filament
                #declare filheight=bulblength-bulbrad/2;
                #declare noofcoils=6;
                #declare leaddiameter=.1;
                #declare theta=-90;
                #declare phi=90;
                #declare xs=-fillength/2;
                #declare ys=-filrad;
                #declare zs=-screwheight*1.5;
                wirepiece(-fillength/2,-filrad,0)
                #declare windcount=0;
                #while (windcount<noofcoils)
                        wirepiece(-fillength/2+windcount*fillength/noofcoils,filrad,0)
                        wirepiece(-fillength/2+windcount*fillength/noofcoils,-filrad,0)
                        #declare windcount=windcount+1;
                #end
                wirepiece(fillength/2,filrad,0)
                wirepiece(fillength/2,filrad,-screwheight*1.5)
                pigment {colour rgb<5,5,5>}
         }
#end

#macro wirepiecetest(xe,ye,ze)              //phi is rotation about z axis
                                            //theta is elevation from x-y plane
        
        #declare theta=mod(theta+450,360)-90;
        #declare phi=mod(phi+360,360);
        #declare x0=xe-xs;
        #declare y0=ye-ys;
        #declare z0=ze-zs;
        #declare l=sqrt(x0*x0+y0*y0+z0*z0);
        #declare phi1=asin(y0/sqrt(x0*x0+y0*y0));
        #if (x0<0 & y0>=0) #declare phi1=pi-phi1; #end
        #if (x0<0 & y0<0) #declare phi1=-pi-phi1; #end
        
        #declare xp=cos(theta*pi/180)*cos(phi*pi/180);
        #declare yp=cos(theta*pi/180)*sin(phi*pi/180);
        #declare zp=-sin(theta*pi/180);
        
        //rotate <x0,y0,z0> -phi about z axis
        #declare xi=sqrt(x0*x0+y0*y0)*cos(-pi/180*phi+phi1);
        #declare yi=sqrt(x0*x0+y0*y0)*sin(-pi/180*phi+phi1);
        #declare zi=z0;
        
        
        #declare theta1=-asin(zi/sqrt(xi*xi+zi*zi));
        #if (xi<0) #declare theta1=pi-theta1; #end
                                           
        //rotate -theta about y axis                           
        #declare x1=sqrt(xi*xi+zi*zi)*cos(pi/180*theta-theta1);
        #declare z1=sqrt(xi*xi+zi*zi)*sin(pi/180*theta-theta1);
        #declare y1=yi;
        
        #declare d=sqrt(y1*y1+z1*z1);
        #declare r=(d*d+x1*x1)/(2*d);
        #declare theta2=asin(y1/d);
        #declare xc=0;              
        #declare yc=r*sin(theta2);
        #declare zc=r*cos(theta2);
        #if (z1<0) #declare zc=-abs(zc); #declare theta2=pi-theta2; #else #declare zc=abs(zc); #end
        #declare Alpha=360/pi*asin((l/2)/r);
        #declare crossprod=x0*xp+y0*yp+z0*zp;
        //#debug concat("Crossprod ",str(crossprod,4,4),"\n")
        #if (x0*xp+y0*yp+z0*zp<0) #declare Alpha=360-Alpha; #end

        #if(r<10000)
       union{ 
       intersection{
                #if (Alpha<180)
                intersection{
                        plane{-x,0}
                        plane{x,0 rotate <0,-Alpha,0>}
                        }
                #else
                union{
                        plane{-x,0}
                        plane{x,0 rotate <0,-Alpha,0>}
                        }
                #end
                union{
                        sphere{0,.1*(r+10) pigment{colour White}}// makes cheesewedge  
                        torus{r,leaddiameter/2}
                }
                rotate<-theta2*180/pi,0,0>
                translate<xc,yc,zc>
                rotate<0,theta,phi>
                //rotate<0,0,phi>
                translate<xs,ys,zs>
                }   
                sphere{<xe,ye,ze>,leaddiameter*1.3 pigment{colour LightBlue}}
                //cylinder{<xs,ys,zs> <5*xp,5*yp,5*zp> .1 pigment{colour Blue}}
                //sphere{<x0,y0,z0>,.5 rotate<0,0,-phi> rotate<0,-theta,0> translate<xs,ys,zs> pigment{colour Green}} // this shows the required end position of the arc
                //torus{1,.3 rotate<0,0,90> translate<xs+x1,ys+y1,zs+z1> pigment{colour White}} 
                //torus{1,.3 rotate<0,90,0> translate<xs+xd,ys+yd,zs+zd> pigment{colour Blue}} 
        }
        #else
        cylinder{<xs,ys,zs>,<xe,ye,ze>,leaddiameter/2}
        #end
        
                #debug concat("theta = ",str(theta,4,4),"\n") 
                #debug concat("phi = ",str(phi,4,4),"\n")
                #debug concat("l = ",str(l,4,4),"\n") 
                #debug concat("theta1 = ",str((theta1),4,4),"\n") 
                #debug concat("phi1 = ",str((phi1),4,4),"\n") 
                #debug concat("xs,ys,zs = <",str(xs,4,4)," ",str(ys,4,4)," ",str(zs,4,4),">\n") 
                #debug concat("xe,ye,ze = <",,str(xe,4,4)," ",str(ye,4,4)," ",str(ze,4,4),">\n")
                #debug concat("xi,yi,zi = <",str(xi,4,4)," ",str(yi,4,4)," ",str(zi,4,4),">\n") 
                #debug concat("x1,y1,z1 = <",str(x1,4,4)," ",str(y1,4,4)," ",str(z1,4,4),">\n") 
                #debug concat("xc,yc,zc = <",,str(xc,4,4)," ",str(yc,4,4)," ",str(zc,4,4),">\n") 
                #debug concat("xp,yp,zp = ",,str(xp,4,4)," ",str(yp,4,4)," ",str(zp,4,4),"\n")
                #debug concat("d = ",str(d,4,4),"\n") 
                #debug concat("r = ",str(r,4,4),"\n")
                #debug concat("theta2 = ",str((theta2),4,4),"\n") 
                #debug concat("Alpha = ",str(Alpha,4,4),"\n\n") 
        
        #declare xb=cos(Alpha*pi/180);
        #declare yb=sin(Alpha*pi/180)*sin(theta2);
        #declare zb=sin(Alpha*pi/180)*cos(theta2);
        //#debug concat("xb=",str(xb,2,2),"\n")
        #if (xb=0) #declare xb=1e-6; #end
        
        #declare beta=atan2(zb,xb);
        //#debug concat("theta = ",str(theta*180/pi,4,4),"\n")
        #declare l=sqrt(xb*xb+zb*zb);
        #declare xc=l*cos(beta-theta*pi/180);
        #declare yc=yb;
        #declare zc=l*sin(beta-theta*pi/180);
                                          
        #if (xc=0) #declare xc=1e-6; #end                                  
        #declare beta=atan2(yc,xc);
        #declare l=sqrt(xc*xc+yc*yc);
        #declare xb=l*cos(beta+phi*pi/180);
        #declare yb=l*sin(beta+phi*pi/180);
        #declare zb=zc;
        
        #declare phi=180/pi*asin(yb/sqrt(xb*xb+yb*yb));
        #if (xb<0 & yb>=0) #declare phi=180-phi; #end
        #if (xb<0 & yb<0) #declare phi=-180-phi; #end
        #declare theta=-180/pi*asin(zb/sqrt(xb*xb+yb*yb+zb*zb));
        
        //#declare phi=floor(phi*1000000+.5)/1000000;
        //#declare theta=floor(theta*1000000+.5)/1000000;
        
        
        #declare xs=xe;
        #declare ys=ye;
        #declare zs=ze;
   
        //#debug concat("xb,yb,zb = ",,str(xb,4,4)," ",str(yb,4,4)," ",str(zb,4,4),"\n")
        //#debug concat("Theta = ",str(theta,4,8),"\n")
        //#debug concat("Phi = ",str(phi,4,8),"\n\n")
                
#end 

#macro wirepiece(xe,ye,ze)              //phi is rotation about z axis
                                        //theta is elevation from x-y plane
        
        #declare theta=mod(theta+450,360)-90;
        #declare phi=mod(phi+360,360);
        #declare x0=xe-xs;
        #declare y0=ye-ys;
        #declare z0=ze-zs;
        #declare l=sqrt(x0*x0+y0*y0+z0*z0);
        #declare base=sqrt(x0*x0+y0*y0);
        #if (base=0)
                #declare phi1=0;
                #else
                #declare phi1=asin(y0/sqrt(x0*x0+y0*y0));
        #end
        #if (x0<0 & y0>=0) #declare phi1=pi-phi1; #end
        #if (x0<0 & y0<0) #declare phi1=-pi-phi1; #end
        
        #declare xp=cos(theta*pi/180)*cos(phi*pi/180);
        #declare yp=cos(theta*pi/180)*sin(phi*pi/180);
        #declare zp=-sin(theta*pi/180);
        
        //rotate <x0,y0,z0> -phi about z axis
        #declare xi=sqrt(x0*x0+y0*y0)*cos(-pi/180*phi+phi1);
        #declare yi=sqrt(x0*x0+y0*y0)*sin(-pi/180*phi+phi1);
        #declare zi=z0;
        
        
        #declare theta1=-asin(zi/sqrt(xi*xi+zi*zi));
        #if (xi<0) #declare theta1=pi-theta1; #end
                                           
        //rotate -theta about y axis                           
        #declare x1=sqrt(xi*xi+zi*zi)*cos(pi/180*theta-theta1);
        #declare z1=sqrt(xi*xi+zi*zi)*sin(pi/180*theta-theta1);
        #declare y1=yi;
        
        #declare d=sqrt(y1*y1+z1*z1);
        #if (d=0)
                #declare r=x1*x1*1e10;
                #declare theta2=0;
                #else
                #declare r=(d*d+x1*x1)/(2*d);
                #declare theta2=asin(y1/d);
        #end
        #declare xc=0;              
        #declare yc=r*sin(theta2);
        #declare zc=r*cos(theta2);
        #if (z1<0) #declare zc=-abs(zc); #declare theta2=pi-theta2; #else #declare zc=abs(zc); #end
        #declare Alpha=360/pi*asin((l/2)/r);
        #declare crossprod=x0*xp+y0*yp+z0*zp;
        //#debug concat("Crossprod ",str(crossprod,4,4),"\n")
        #if (x0*xp+y0*yp+z0*zp<0) #declare Alpha=360-Alpha; #end

        #if(r<10000)
       //union{ 
       intersection{
                #if (Alpha<180)
                intersection{
                        plane{-x,0}
                        plane{x,0 rotate <0,-Alpha,0>}
                        }
                #else
                union{
                        plane{-x,0}
                        plane{x,0 rotate <0,-Alpha,0>}
                        }
                #end
                //union{
                //        sphere{0,.5 pigment{colour White}}// makes cheesewedge  
                        torus{r,leaddiameter/2}
                //}
                rotate<-theta2*180/pi,0,0>
                translate<xc,yc,zc>
                rotate<0,theta,phi>
                //rotate<0,0,phi>
                translate<xs,ys,zs>
                }   
                //sphere{<xe,ye,ze>,leaddiameter*1.3 pigment{colour LightBlue}}
                //cylinder{<xs,ys,zs> <5*xp,5*yp,5*zp> .1 pigment{colour Blue}}
                //sphere{<x0,y0,z0>,.5 rotate<0,0,-phi> rotate<0,-theta,0> translate<xs,ys,zs> pigment{colour Green}} // this shows the required end position of the arc
                //torus{1,.3 rotate<0,0,90> translate<xs+x1,ys+y1,zs+z1> pigment{colour White}} 
                //torus{1,.3 rotate<0,90,0> translate<xs+xd,ys+yd,zs+zd> pigment{colour Blue}} 
        //}
        #else
        cylinder{<xs,ys,zs>,<xe,ye,ze>,leaddiameter/2}
        #end
        
        #declare xb=cos(Alpha*pi/180);
        #declare yb=sin(Alpha*pi/180)*sin(theta2);
        #declare zb=sin(Alpha*pi/180)*cos(theta2);
        //#debug concat("xb=",str(xb,2,2),"\n")
        #if (xb=0) #declare xb=1e-6; #end
        
        #declare beta=atan2(zb,xb);
        //#debug concat("theta = ",str(theta*180/pi,4,4),"\n")
        #declare l=sqrt(xb*xb+zb*zb);
        #declare xc=l*cos(beta-theta*pi/180);
        #declare yc=yb;
        #declare zc=l*sin(beta-theta*pi/180);
                                          
        #if (xc=0) #declare xc=1e-6; #end                                  
        #declare beta=atan2(yc,xc);
        #declare l=sqrt(xc*xc+yc*yc);
        #declare xb=l*cos(beta+phi*pi/180);
        #declare yb=l*sin(beta+phi*pi/180);
        #declare zb=zc;
        
        #declare phi=180/pi*asin(yb/sqrt(xb*xb+yb*yb));
        #if (xb<0 & yb>=0) #declare phi=180-phi; #end
        #if (xb<0 & yb<0) #declare phi=-180-phi; #end
        #declare theta=-180/pi*asin(zb/sqrt(xb*xb+yb*yb+zb*zb));
        
        //#declare phi=floor(phi*1000000+.5)/1000000;
        //#declare theta=floor(theta*1000000+.5)/1000000;
        
        
        #declare xs=xe;
        #declare ys=ye;
        #declare zs=ze;
   
        //#debug concat("xb,yb,zb = ",,str(xb,4,4)," ",str(yb,4,4)," ",str(zb,4,4),"\n")
        //#debug concat("Theta = ",str(theta,4,8),"\n")
        //#debug concat("Phi = ",str(phi,4,8),"\n\n")
#end



#macro TO92(type1,type2)
        #declare leglen=15;
        #declare legwide=0.2;
        union{
        intersection{
        
                cylinder{<0,0,0>,<0,0,4>,2}
                plane{y,0}
                pigment{colour rgb<.2,.2,.2>} 
                     }
         box{<-2,0,0>,<2,1,4> pigment{colour rgb<.2,.2,.2>}}
         #if (quality>6)
                 text {ttf "arialn.ttf" type1 .5, 0 rotate<90,0,0> pigment { Gray75} translate<-1,1.001,2>  }
                 text {ttf "arialn.ttf" type2 .5, 0 rotate<90,0,0> pigment { Gray75} translate<-1,1.001,1>  }
         #end
         box{<-legwide/2,0,0>,<legwide/2,-legwide,-leglen> texture {leadtexture}}
         box{<-3*legwide/4,0,0>,<3*legwide/4,-legwide,-2.5> texture {leadtexture}}
         box{<-1-legwide/2,0,0>,<-1+legwide/2,-legwide,-leglen> texture {leadtexture}}
         box{<-1-3*legwide/4,0,0>,<-1+3*legwide/4,-legwide,-2.5> texture {leadtexture}}
         box{<1-legwide/2,0,0>,<1+legwide/2,-legwide,-leglen> texture {leadtexture}}
         box{<1-3*legwide/4,0,0>,<1+3*legwide/4,-legwide,-2.5> texture {leadtexture}}
         }
         
#end

#macro TO3(type1,type2)
        #declare basethick=1;
        #declare baserad=12.5;
        #declare mountinghole=2;
        #declare mountingspace=30;
        #declare endrad=4;
        #declare circlerad=11;
        #declare circlethick=.2;
        #declare caprad=9.5;
        #declare capheight=6.5;
        #declare chamfer=1.5;
        #declare legspace=11;
        #declare legwide=.4;
        #declare leglength=12;
        #declare angl=asin((baserad-endrad)/(mountingspace/2));
        difference{
        union{  //base
                box{<0,0,0><mountingspace/2*cos(angl),baserad,basethick> rotate<0,0,-180/pi*angl> }
                box{<0,0,0><-mountingspace/2*cos(angl),baserad,basethick> rotate<0,0,180/pi*angl> }
                box{<0,0,0><mountingspace/2*cos(angl),-baserad,basethick> rotate<0,0,180/pi*angl> }
                box{<0,0,0><-mountingspace/2*cos(angl),-baserad,basethick> rotate<0,0,-180/pi*angl>}
                
                cylinder{<0,0,0>,<0,0,basethick>,baserad }
                cylinder{<mountingspace/2,0,0>,<mountingspace/2,0,basethick>,endrad }
                cylinder{<-mountingspace/2,0,0>,<-mountingspace/2,0,basethick>,endrad}
                
                //cap
                cylinder{<0,0,basethick>,<0,0,basethick+circlethick>,circlerad}
                cylinder{<0,0,basethick>,<0,0,basethick+capheight-chamfer>,caprad}
                cylinder{<0,0,basethick>,<0,0,basethick+capheight>,caprad-chamfer}
                torus{caprad-chamfer,chamfer rotate x*90 translate z*(capheight-chamfer+basethick)}
                
                //legs
                cylinder{<mountinghole/2,legspace/2,0>,<mountinghole/2,legspace/2,-leglength>legwide/2}
                cylinder{<mountinghole/2,-legspace/2,0>,<mountinghole/2,-legspace/2,-leglength>legwide/2}
                #if (quality>6)
                        text { ttf "arialn.ttf" type1 1, 0 rotate<180,0,0> scale 3 pigment { Gray05} translate<-5,-1,basethick+capheight+.01>  }
                        text { ttf "arialn.ttf" type2 1, 0 rotate<180,0,0> scale 3 pigment { Gray05} translate<-5,3,basethick+capheight+.01>  }
                #end         
                
             }
         // cutout holes
         cylinder{<mountingspace/2,0,-.1>,<mountingspace/2,0,basethick+.1>,mountinghole}
         cylinder{<-mountingspace/2,0,-.1>,<-mountingspace/2,0,basethick+.1>mountinghole}
         
         cylinder{<mountinghole/2,legspace/2,-.1>,<mountinghole/2,legspace/2,basethick+.1>mountinghole}
         cylinder{<mountinghole/2,-legspace/2,-.1>,<mountinghole/2,-legspace/2,basethick+.1>mountinghole}
         
         
         texture {leadtexture}
         }
#end             

#macro TO18()
        #declare cylinderheight=5;
        #declare chamfer=.2;
        #declare cylinderrad=2.25;
        #declare circle=2.75;
        #declare tabsize=1;
        #declare circleheight=.1;
        #declare legsize=.2;
        #declare leglength=13;
        #declare legspace=1.54;
        //difference{
                union{cylinder{<0,0,0>,<0,0,cylinderheight-chamfer>,cylinderrad}   //main body
                      cylinder{<0,0,0>,<0,0,cylinderheight>,cylinderrad-chamfer}
                      torus{cylinderrad-chamfer,chamfer rotate x*90 translate z*(cylinderheight-chamfer)}
                      cylinder{<0,0,0><0,0,circleheight>,circle}                   //base
                      box{<0,-.25,0><circle+tabsize,.25,circleheight>}             //tab !!! may need rotating !!!
                      cylinder{<legspace/2,legspace/2,0><legspace/2,legspace/2,-leglength>legsize}
                      cylinder{<legspace/2,-legspace/2,0><legspace/2,-legspace/2,-leglength>legsize}
                      cylinder{<-legspace/2,legspace/2,0><-legspace/2,legspace/2,-leglength>legsize}
                //}
                texture{leadtexture}
                   }
#end


#macro TO220(type1,type2)
        #declare boxwidth=10;
        #declare boxdepth=4.5;
        #declare boxheight=8;
        #declare legwide=.9;
        #declare legspace=2.54;
        #declare leglen=13;
        #declare heatsinkheight=6;
        #declare heatsinkhole=1.5;
        union{
        difference{
                box{<-boxwidth/2,-2*boxdepth/3,0><boxwidth/2,boxdepth/3,boxheight>}
                box{<-4*boxwidth/10,-2*boxdepth/3-.1,boxheight/3><4*boxwidth/10,-2*boxdepth/3+.1,boxheight+.1> }
                box{<-boxwidth,-boxdepth,0><boxwidth,boxdepth,boxheight> rotate x*-10 translate<0,0,boxheight*.95>}
                pigment{colour Gray35}
                   }
        difference{
                 box{<-boxwidth/2,-2*boxdepth/3+1,boxheight><boxwidth/2,-2*boxdepth/3,boxheight+heatsinkheight> }
                 cylinder{<0,0,boxheight+heatsinkheight-heatsinkhole><0,-boxdepth,boxheight+heatsinkheight-heatsinkhole*2>heatsinkhole}
                 texture{leadtexture}
                  }
                box{<-4*boxwidth/10,-2*boxdepth/3+1,boxheight/3><4*boxwidth/10,-2*boxdepth/3,boxheight+.1>texture{leadtexture} }
                
                box{<-legwide/2,0,0>,<legwide/2,-legwide/4,-leglen> texture {leadtexture}}
                box{<-3*legwide/4,0,0>,<3*legwide/4,-legwide/4,-2.5> texture {leadtexture}}
                box{<-legspace-legwide/2,0,0>,<-legspace+legwide/2,-legwide/4,-leglen> texture {leadtexture}}
                box{<-legspace-3*legwide/4,0,0>,<-legspace+3*legwide/4,-legwide/4,-2.5> texture {leadtexture}}
                box{<legspace-legwide/2,0,0>,<legspace+legwide/2,-legwide/4,-leglen> texture {leadtexture}}
                box{<legspace-3*legwide/4,0,0>,<legspace+3*legwide/4,-legwide/4,-2.5> texture {leadtexture}}
                #if (quality>6)
                        text { ttf "arialn.ttf" type1 1, 0 rotate x*90  scale 1.5 pigment { Gray95} translate<-boxwidth/3,boxdepth/3+.01,boxheight/2>  }
                        text { ttf "arialn.ttf" type2 1, 0 rotate x*90  scale 1.5 pigment { Gray95} translate<-boxwidth/3,boxdepth/3+.01,boxheight/4>  }
                #end
               }
#end

#declare holepitch = 2.54;
#declare holesize=1.5;
#macro breadboard()
        #declare boardsizex=81;
        #declare boardsizey=60;
        #declare boardheight=8.5;
        union{
        difference{
                //box{<0,0,0> <boardsizex,boardsizey,boardheight> }
                object{chamferbox(boardsizex,boardsizey,boardheight,3,2) translate<boardsizex/2,boardsizey/2,boardheight/2>}
                #declare holecount=0;
                //#if (quality>3)
                #while (holecount<5)
                        object{holes5 translate <4+6*holepitch*holecount,4.5,boardheight-3>}
                        object{holes5 translate <4+6*holepitch*holecount,7.04,boardheight-3>}
                        object{holes5 translate <4+6*holepitch*holecount,60-7.04,boardheight-3>}
                        object{holes5 translate <4+6*holepitch*holecount,60-4.5,boardheight-3>}
                        #declare holecount=holecount+1;
                #end
                #declare holecount=0;
                #while (holecount<29)
                        object{holes5 rotate z*90 translate <4+holepitch*holecount,16,boardheight-3>}
                        object{holes5 rotate z*90 translate <4+holepitch*holecount,34,boardheight-3>}
                        #declare holecount=holecount+1;
                //#end
                #end
                cylinder{<boardsizex-0.5,17.5,-.1><boardsizex-0.5,17.5,5>1.25}
                cylinder{<boardsizex-0.5,42.5,-.1><boardsizex-0.5,42.5,5>1.25}
                cylinder{<8,boardsizey-0.5,-.1><8,boardsizey-0.5,5>1.25}
                cylinder{<73,boardsizey-0.5,-.1><73,boardsizey-0.5,5>1.25}
                box{<-.01,29,5><boardsizex+.01,31,10>}
                

                }
                cylinder{<-0.5,17.5,0><0.5,17.5,5>1.25}
                cylinder{<-0.5,42.5,0><0.5,42.5,5>1.25}
                cylinder{<8,-0.5,0><8,-0.5,5>1.25}
                cylinder{<73,-0.5,0><73,-0.5,5>1.25}
                pigment{colour <.8,.7,.6>}
                }                
#end

#declare hole =
        union{
                box{<-holesize/4,-holesize/4,0><holesize/4,holesize/4,5>}
                prism{  conic_sweep
                        0,2,5,
                        <-holesize,-holesize>
                        <holesize,-holesize>
                        <holesize,holesize>
                        <-holesize,holesize>
                        <-holesize,-holesize>
                        rotate x*90
                        translate z*2.3
                     }
                 bounded_by{
                 box{<-holesize,-holesize,0><holesize*5,holesize,5>}}
             }

#declare holes5=
    union{
        object{hole}
        object{hole translate x*holepitch}
        object{hole translate x*holepitch*2}
        object{hole translate x*holepitch*3}
        object{hole translate x*holepitch*4}
    }
      
        


#macro rockerswitch(pos)
    #declare boxheight=7;
    #declare boxwidth=7;
    #declare boxdepth=4;
    #declare footing=.8;
    #declare turretheight=6;
    #declare insideD=3;
    #declare outsideD=3.5;
    #declare outsideL=4.5;
    #declare insideL=4;
    #declare switchlength=10;
    #declare switchrad=1;
    #declare legspace=2.54;
    #declare leglength=4;
    union{
            difference{
                        object{chamferbox(boxwidth,boxdepth,boxheight+footing,.5,.5) translate z*(boxheight+footing)/2} //main box
                        box{<boxwidth,boxdepth/2-footing/4,-.1><-boxwidth,-boxdepth/+footing/4,footing>}
                        box{<boxwidth/2-footing,boxdepth,-.1><-boxwidth/2+footing,-boxdepth,footing>}
                        }
            difference{
                        cylinder{<0,0,footing+boxheight><0,0,footing+boxheight+turretheight>,outsideL/2}                           //
                        cylinder{<0,0,footing+boxheight><0,0,footing+boxheight+turretheight+.1>,insideL/2}                         //
                        box{<-boxwidth/2,outsideD/2,footing+boxheight><boxwidth/2,outsideL/2+1,footing+boxheight+turretheight+1>}  //
                        box{<-boxwidth/2,-outsideD/2,footing+boxheight><boxwidth/2,-outsideL/2-1,footing+boxheight+turretheight+1>}//
                       }                                                                                                          //
             box{<-boxwidth/4.5,outsideD/2,footing+boxheight><boxwidth/4.5,insideD/2,footing+boxheight+turretheight> }     //
             box{<-boxwidth/4.5,-outsideD/2,footing+boxheight><boxwidth/4.5,-insideD/2,footing+boxheight+turretheight>}    //
             union{
                   cone{<0,0,0>switchrad/2<0,0,switchlength>switchrad}   //
                   sphere{<0,0,switchlength> switchrad}                  //
                   texture{leadtexture}                                  // handle
                   rotate y*(10-20*pos)                                  //
                   translate z*(footing+boxheight)                       //
                  }     
             pigment{colour Gray35}
     }
#end     



#macro individuals()
        background{rgb<0,.2,.4>}
        //light_source {<-260,-260,350> color .5}
        //light_source {<-260,260,350> color .5}
        light_source {<-350,50,350> color 1}
        light_source {<250,50,100> color Red}
        light_source {<-250,150,250> color Yellow}
        light_source {<10,50,250> color Blue}
        
        camera {
          location <25,50,20>
          sky <0,0,1>
          look_at <5, 10, 10>
        }
        object{resistor(Red,Red,Black,Gold) translate<8,5,0>}
        object{resistor(Yellow,Green,Black,Gold) translate<8,8,0>}
        object{resistor(Blue,Yellow,Red,Gold) translate<8,11,0>}
        object{resistor(Brown,Black,Green,Gold) translate<8,14,0>}
        object{resistor(Brown,Black,Red,Gold) translate<8,17,0>}
        object{resistor(Brown,Black,Red,Gold) translate<8,20,0>}
        object{resistor(Blue,Yellow,Blue,Gold) translate<8,23,0>}
        object{chip(14,0,"74LS04") translate<6,-10,0>}
        object{fuse() translate <15,-5,0>}
        object{electrolytic(5,2)}
        object{led(0) translate<0,8,0>}
        object{led(0) translate<0,4,0>}
        //object{battery() translate<-50,-30,22> }
        object{TO92(" 2N","3819") translate <-6,7,0>}
        object{TO3("2N3055","  9501") translate <-22,0,0>}
        object{TO220("LM340TS"," 7805 P+") translate <0,-36,10>}
        object{TO18() translate <20,5,0>}
        //object{breadboard() translate <-30,-80,0>}
        //object{rockerswitch(on) translate<-30,20,0>}
        
        object{screwterminal() translate<20,-12,0>}
        object{screwterminal() translate<24.95,-12,0>}
        //object{screwterminal() rotate z*180 translate<30,-12,0>}
        //object{screwterminal() rotate z*180 translate<34.95,-12,0>}
#end





#declare screwr1=seed(123);
#macro screwterminal()

#declare boxwidth=4.95;
#declare boxplus=4;
#declare boxminus=3;
#declare boxh1=7;
#declare boxh2=3;
#declare thick=0.25;
#declare screwD=3;
#declare legsize=.5;
#declare screwturn=rand(screwr1)*360;
   union{
        difference{
                union{
                        box{<-boxwidth/2,-boxminus,0><boxwidth/2,boxplus,boxh1>}
                        box{<-boxwidth/2*.99,-boxminus+thick,boxh1><boxwidth/2*.99,boxplus,boxh1+boxh2>}
                        box{<-boxwidth/2,boxplus-thick,0><-boxwidth/2-thick*2,boxplus-3*thick,boxh1>}
                      }
                 box{<-legsize/2,legsize,-.01><legsize/2,-boxminus-.01,thick+.01>}
                 box{<-boxwidth/2+thick,boxplus-thick,thick><boxwidth/2-thick,-boxminus-.01,boxh1-thick>}
                 cylinder{<0,0,boxh1/2><0,0,boxh1+boxh2+.01>screwD*.56}
                 cylinder{<0,screwD*.85,boxh1/2><0,screwD*.85,boxh1+boxh2+.01>screwD*.13}
                 box{<-boxwidth/2,0,0><boxwidth/2,boxh1,2*boxh2> rotate x*32 translate <0,boxplus,boxh1>}
                 box{<-boxwidth/2,0,0><boxwidth/2,-boxh1,2*boxh2> rotate x*-20 translate <0,-boxminus,boxh1>}
                 box{<boxwidth/2+.01,boxplus-thick,0><boxwidth/2-thick*2,boxplus-3*thick,boxh1>}
                 pigment{colour Gray80}
                 }
          difference{
                union{
                        cylinder{<0,0,boxh1><0,0,boxh1+.9*boxh2>screwD/2}
                        box{<-boxwidth/2+2*thick,boxplus-2*thick,2*thick><boxwidth/2-2*thick,-boxminus+2*thick,boxh1-2*thick>}
                        box{<-boxwidth/4,-boxminus+1.9*thick,boxh1*.6><boxwidth/4,-boxminus+thick*1.8,boxh1/1.05>}
                     }

                     box{<-screwD/8,-screwD,boxh1+boxh2*.75><screwD/8,screwD,boxh1+boxh2*.95> rotate z*screwturn}
                     //#debug concat(str(screwturn,4,4),"\n")
                     cylinder{<0,boxplus,boxh1/2><0,-boxminus+2*thick-.01,boxh1/2>boxwidth/3}
                     texture{leadtexture}
                     }
                    }
                 
#end

#macro mainsocket(switch_on)
        #declare holex=5;
        #declare holey=8;
        #declare hole1=prism{  conic_sweep
                        0,2,5,
                        <-holex,-holey>
                        <holex,-holey>
                        <holex,holey>
                        <-holex,holey>
                        <-holex,-holey>
                        rotate x*90
                     }
       #declare holex=11;
        #declare holey=5;
        #declare hole2=prism{  conic_sweep
                        0,2,5,
                        <-holex,-holey>
                        <holex,-holey>
                        <holex,holey>
                        <-holex,holey>
                        <-holex,-holey>
                        rotate x*90
                     }
     union{            
        difference{
                object{chamferbox(84,84,11,2,7) translate z*5}
                cylinder{<0,-31,5><0,-31,11>,3} //screw
                cylinder{<0,31,5><0,31,11>,3}   //holes
                
                box{<-21,-24,5> <-17,-17,11>} // 3 main holes
                object{hole1 translate <-19,-20.5,10>}
                box{<-21,-2,5> <-17,5,11>}
                object{hole1 translate <-19,1.5,10>}
                box{<0,-11.5,5> <9,-7.5,11>}
                object{hole2 translate <4.5,-9.5,10> }
                
                box{<8,15,5> <33,26,11>}        // hole for switch
                
                pigment{White}
                  }
         object{chamferbox(20,9.8,6,1,1)        //switch
                 rotate y*(15-30*switch_on)
                 translate <21.5,20.5,10>
                 pigment{White}
                 }
         object{screwhead_slot(3) translate<0,-31,9.5>}
         object{screwhead_slot(3) translate<0,31,9.5>}

         object{chamferbox(8,2,4,.8,.8)        //earth connection
                 rotate y*21
                 translate <3,-9.5,6>
                 texture{T_Copper_1A}
                 }
         //translate <19,5,0>                
       }  
#end

#macro mainplug()
        #declare th=16;
        #declare cr1=7;
        #declare cr2=10;
        #declare pcx=10;
        #declare pcy=5;
        #declare chamfr=2;
        #declare pinx=4;
        #declare piny=7;
        #declare pinz=16;
        #declare plugshape=
        union{
              cylinder{<-pcx,-pcy,0-2*chamfr><-pcx,-pcy,0>,cr2}
              torus{cr2,chamfr rotate x*90 translate <-pcx,-pcy,-chamfr>}
              cylinder{<-pcx,pcy,0-2*chamfr><-pcx,pcy,0>,cr2}
              torus{cr2,chamfr rotate x*90 translate <-pcx,pcy,-chamfr>}
              cylinder{<pcx,-pcy,0-2*chamfr><pcx,-pcy,0>,cr1}
              torus{cr1,chamfr rotate x*90 translate <pcx,-pcy,-chamfr>}
              cylinder{<pcx,pcy,0-2*chamfr><pcx,pcy,0>,cr1}
              torus{cr1,chamfr rotate x*90 translate <pcx,pcy,-chamfr>}
                
              cylinder{<-pcx-cr2,-pcy,-chamfr> <-pcx-cr2,pcy,-chamfr>,chamfr}
              cylinder{<pcx+cr1,-pcy,-chamfr> <pcx+cr1,pcy,-chamfr>,chamfr }
              cylinder{<-pcx,-pcy-cr2,-chamfr> <pcx,-pcy-cr1,-chamfr>,chamfr}
              cylinder{<-pcx,pcy+cr2,-chamfr> <pcx,pcy+cr1,-chamfr>,chamfr}
              
              box{0,<pcx*2,pcy*3,-chamfr*2> rotate z*asin((cr2-cr1)/(2*pcx))*180/pi translate <-pcx,-pcy-cr2,0>}
              box{0,<pcx*2,-pcy*3,-chamfr*2> rotate -z*asin((cr2-cr1)/(2*pcx))*180/pi translate <-pcx,pcy+cr2,0>}
              pigment{White}
              
             }
        #declare pin=difference{
                        box{<-pinx/2,-piny/2,0><pinx/2,piny/2,-pinz>}
                        box{<-pinx,-piny/2,0><-pinx/2,piny/2,-6> rotate y*-20 translate <-pinx/14,0,3-pinz>}
                        box{<pinx,-piny/2,0><pinx/2,piny/2,-6> rotate y*20 translate <pinx/14,0,3-pinz> }
                        box{<-pinx/2,-piny,0><pinx/2,-piny/2,-6> rotate x*20 translate <0,-piny/14,3-pinz>}
                        box{<-pinx/2,piny,0><pinx/2,piny/2,-6> rotate x*-20 translate <0,piny/14,3-pinz>}
                        texture {T_Copper_2B}
                        
                     }
        union{
        object{plugshape translate z*th}
        text{ttf "arialn.ttf" "FUSED" .1,0 rotate <0,180,-90> scale 4 pigment{rgb .7} translate <-pcx*1.5,-pcy,th+.05>} 
        object{pin translate <-13,-8,0>}
        object{pin translate <-13,8,0>}
        object{pin rotate z*90 translate <10,0,0>}
        difference{
                object{plugshape scale <1,1,th/chamfr/2> translate z*th}
                cylinder{<-2*pcx,-4*pcy,th*.4>,<2*pcx,-4*pcy,th*.8>,2*cr2/3}
                cylinder{<-2*pcx,4*pcy,th*.4>,<2*pcx,4*pcy,th*.8>,2*cr2/3}
                cylinder{<-3*pcx,0,th/2><0,0,th/2>,th*.3}
                pigment{White}
                }
             }
#end


#macro plug_d25()
        union{
           prism{cubic_spline -7,-15,11
                <-20,0><-28,2><-30,10><-23,13><23,13><30,10><28,2><20,0><-20,0><-28,2><-30,10>
                rotate z*90
                scale<1,1.4,1.1>
                }
              difference{
                   prism{cubic_spline -10,0,11
                        <-20,0><-28,2><-30,10><-23,13><23,13><30,10><28,2><20,0><-20,0><-28,2><-30,10>
                        rotate z*90
                       }
                   box{<-10,-27,4><9,27,10>}
                   #if (quality>3)
                           #declare cutcount=1;
                           #declare cuts=25;
                           #declare cutspace=2;
                           #while (cutcount<=cuts)
                                cylinder{0,<0,cutspace*.8,0>,4 translate <1,cutcount*cutspace-26,7>}
                                #declare cutcount=cutcount+1;
                           #end
                    #end
                     }
              #if (quality>3)
                      #declare cutcount=1;
                      #declare cuts=25;
                      #declare cutspace=2;
                      #while (cutcount<=cuts)
                           cylinder{0,<0,cutspace*.4,0>,1 translate <1,cutcount*cutspace-26+cutspace*.2,3> texture{T_Gold_1A}}
                           box{0,<7,cutspace*.4,1> translate <1,cutcount*cutspace-26+cutspace*.2,3> texture{T_Gold_1A}}
                           cylinder{0,<0,cutspace*.4,0>,1 translate <1,cutcount*cutspace-26+cutspace*.2,11> texture{T_Gold_1A}}
                           box{0,<7,cutspace*.4,-1> translate <1,cutcount*cutspace-26+cutspace*.2,11> texture{T_Gold_1A}}
                           #declare cutcount=cutcount+1;
                      #end
               #end
          }
#end

#macro plug_slot1(cuts,cutspace)        // length = cuts*cutspace+10
        union{                          // origin in centre of lower side
              difference{
                   object{chamferbox(8,cuts*cutspace+10,8,3,1) translate <-4,0,4>}
                   box{<-9,-cuts*cutspace/2-2,3><7,cuts*cutspace/2+2,5>}
                   #if (quality>3)
                           #declare cutcount=1;
                           #while (cutcount<=cuts)
                                cylinder{0,<0,cutspace*.8,0>,3 translate <-7,cutcount*cutspace-cuts*cutspace/2-1,4>}
                                #declare cutcount=cutcount+1;
                           #end
                    #end
                     }
              #declare cutcount=1;
              #while (cutcount<=cuts)
                   cylinder{0,<0,cutspace*.4,0>,1 translate <-7,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,2> texture{T_Gold_1A}}
                   box{0,<7,cutspace*.4,1> translate <-7,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,6> texture{T_Gold_1A}}
                   cylinder{0,<0,cutspace*.4,0>,1 translate <-7,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,6> texture{T_Gold_1A}}
                   box{0,<7,cutspace*.4,-1> translate <-7,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,6> texture{T_Gold_1A}}
                   #declare cutcount=cutcount+1;
              #end
          }
#end

#macro plug_pci()
        union{
        object{plug_slot1(15,2) translate y*25} // from y=5
        object{plug_slot1(31,2) translate y*75} // to y=111  
        }
#end

#macro vidconnector()
        union{
                difference{
                        union{
                                object{chamferbox(16,10,10,1,1) translate z*5}  // main bulk
                                object{chamferbox(24,10,3,1,1) translate z*1.5} //base
                             }
                        box{<9,-4,-.01><11.5,0,3.01>}        // cutouts each side of base
                        box{<-9,-4,-.01><-11.0,5,3.01>}
                        box{<-7,-6,3.1> <7,3,8>}
                        box{<-7,-4,-.01> <7,3,8>}
                          }
                #declare pincount=0;
                #while (pincount<8)
                          object{Lshape(5,4,.4,.4,2,0) rotate <0,180,0> translate <pincount-4,0,5> texture {T_Copper_2C}}
                          #declare pincount=pincount+1;
                #end
                object{Lshape(6,2,3,.1,.5,.5) rotate z*180 translate <12,2,3> texture{T_Brass_1A}}
                object{Lshape(6,2,3,.1,.5,.5) rotate z*180 translate <-9,2,3> texture{T_Brass_1A}}
                object{screwhead_allen(1.5) rotate x*90 translate <-10.5,2.5,6>}
                object{screwhead_allen(1.5) rotate x*90 translate <10.5,2.5,6>}
                object{chamferbox(24,2,12,1,1) translate <0,4,7>}               // front end
                text{ttf "arialn.ttf" "VIDEO OUT" .01, 0 scale 2 rotate <90,0,180> translate <2.99,2.99,11> pigment {rgb .6}}
                texture{T_Greyplastic}
                translate y*-5
              }
#end

#macro plug_DIMM()
        #declare cuts=72;
        #declare cutspace=1;
        #declare plugend=union{
                                box{<.5,0,0> <3.5,1.2,6>}
                                box{<1,0,0> <3,1.2,10>}
                                box{<.5,2,0> <1.5,6,6>}
                                box{<.5,3,0> <1.5,6,10>}
                                box{<.5,4.5,9> <4.5,6,10>}
                                union{
                                        box{<.5,1.5,0> <3,2,12>}
                                        difference{
                                                cylinder{<.5,1,12><3,1,12>1}
                                                cylinder{<0,1,12><3.5,1,12>.5}
                                                plane{z,12}
                                                }
                                        texture{T_Silver_1A}
                                      }
                              }
                                
        union{
              object{plugend translate y*(-cuts*cutspace/2-4)}
              object{plugend rotate z*180 translate <4,(cuts*cutspace/2+4),0>}
              difference{
                   box{<0,-cuts*cutspace/2-4,0><4,cuts*cutspace/2+4,3>}
                   box{<1.,-cuts*cutspace/2,-1><2.5,cuts*cutspace/2,4>}
                   #if (quality>3)
                           #declare cutcount=1;
                           #while (cutcount<=cuts)
                                cylinder{0,<0,cutspace*.8,0>,2 translate <2,cutcount*cutspace-cuts*cutspace/2-1,1.5>}
                                #declare cutcount=cutcount+1;
                           #end
                    #end
                     }
              #if (quality>3)
                      #declare cutcount=1;
                      #while (cutcount<=cuts)
                           cylinder{0,<0,cutspace*.4,0>,.75 translate <1,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,1.5> texture{T_Silver_1A}}
                           cylinder{0,<0,cutspace*.4,0>,.75 translate <3,cutcount*cutspace-cuts*cutspace/2-1+cutspace*.2,1.5> texture{T_Silver_1A}}
                           #declare cutcount=cutcount+1;
                      #end
              #end
          pigment{rgb .8}
          }
#end

#macro fan(time)
        
        #declare blades=8;
        #declare fanrad=20;
        #declare fancurve=20;
        #declare fanth=.1;
        #declare Black_Metal=texture{pigment{rgb .2} finish{phong .2}}
        #declare blade=
                        intersection{
                                difference{
                                        cylinder{<-fancurve,0,0>,<-fancurve,0,fanrad>fancurve}
                                        cylinder{<-fancurve,0,-.1>,<-fancurve,0,fanrad+.1>fancurve-fanth}
                                        plane{y,0 rotate x*140/blades}
                                        plane{-y,0 rotate x*-140/blades}
                                           }
                                sphere{0,fanrad scale<.5,1,1>}
                                rotate z*25
                               }
        #declare bladeno=0;
        union{        
                #while (bladeno<blades)
                        object{blade rotate x*360*(bladeno/blades+time)}
                        #declare bladeno=bladeno+1;
                #end
                difference{
                        object{chamferbox(20,50,50,3,3)}
                        box{<-11,-22,-22><11,22,22>}
                           }
                cylinder{<-4,0,0><4,0,0>6 pigment{image_map{gif "fanlabel.gif"} scale 6 rotate y*90 rotate x*360*time translate <0,-3,-3>}}
                torus{5,1 rotate z*90 scale <.4,1,1> translate x*-4}
                torus{5,1 rotate z*90 scale <.4,1,1> translate x*4}
                height_field{gif "fantest.gif" smooth
                                water_level .01 rotate z*90
                                scale <1,44,44> translate <-9,-22,-22>}
                height_field{gif "fantest.gif" smooth
                                water_level .01 rotate z*-90
                                scale <1,44,44> translate <9,22,-22>}
                texture{Black_Metal}
               }
#end

#declare jumperrand=seed(0);
#macro jumper()
        #declare boxsize=1.9;
        #declare pinh=6;
        #declare pinsize=.5;
        union{
                box{<-boxsize/2,-boxsize/2,0><boxsize/2,boxsize/2,boxsize> pigment{rgb <.3,.1,.2>}}
                box{<-pinsize/2,-pinsize/2,0><pinsize/2,pinsize/2,pinh>
                        texture{T_Copper_1A} rotate<2*rand(jumperrand),2*rand(jumperrand),2*rand(jumperrand)>}
              }
#end


        



#end