//      Copyright 2001 Andrew Bowcock
//zapper

#include"screws.inc"
#include"knobs.inc"

#declare l1=268;        //length of main box measured along top
#declare l2=70;        //length of back slope measured along slope
#declare w=328;         //width of box
#declare d1=50;         //height of front of box
#declare a1=6.5;         //angle of slope of front
#declare a2=70;         //angle of slope of back
#declare d2=d1+l1*sin(pi/180*a1);
#declare d3=d2+l2*sin(pi/180*a2);
#declare d4=25;         //depth of main recess

#declare th=2;          //thickness of metal face

#declare m1=15;         //margin from inside of recess to edge of box
#declare m2=25;         //margin from top of recess to edge of box

#declare mainchamf=14;   //chamfer radius on corners of main box
                                                 
#declare l1g=l1*cos(pi/180*a1);
#declare l2g=l2*cos(pi/180*a2);

#declare T_Blackmetal=texture{pigment{rgb .29} finish{metallic phong 2}}
#declare T_Graymetal=texture{pigment{rgb .7} finish{phong 1}}


#macro lever()
      prism{cubic_spline 0,7,9
           <10,5><8,-10><10,-15><20,20><10,20><0,20><10,5><8,-10><10,-15>
           rotate x*90
           translate <-8,15,0>
           texture{T_Blackmetal}
           }
#end

#macro clip1()
        union{
                box{<5,-3,0><21,3,8>}
                box{<1,-3,8><21,3,10>}
                cylinder{<1,-3,9><1,3,9>1}
                texture{T_Blackmetal}
              }
#end

#macro clip2()
        union{
        height_field{gif "clip2.gif" water_level 0.01 rotate <90,0,90> scale <26,16,50> translate <-7,-8,2> texture{T_Blackmetal}}
        object{screwhead(3) translate z*4}
        box{<-8,-7,0><8,12,1.5> texture{T_Blackmetal}}
        box{<-8,9,4><8,12,1.5> texture{T_Blackmetal}}
        }
#end


#macro clips()
        union{
                object{clip1() translate <m2+30,-w/2+m2-3,0>}
                object{clip1() translate <m2+30,w/2-m2+3,0>}
                object{clip1() translate <m2+135,-w/2+m2-3,0>}
                object{clip1() translate <m2+135,w/2-m2+3,0>}
                
                object{clip2() translate <8,85,0>}
                object{clip2() translate <8,-85,0>}
              }
#end

#macro postz1()
        #declare s2=sqrt(3)/2;
        prism{-th,-d4,7,<1,0><.5,s2><-.5,s2><-1,0><-.5,-s2><.5,-s2><1,0> rotate x*90 scale <3,3,1> texture{T_Silver_1A}}
#end


#macro posts()
        union{
                object{postz1() translate <46,w/2-18,0>}
                object{postz1() translate <46,-w/2+18,0>}
                object{postz1() translate <197,w/2-18,0>}
                object{postz1() translate <197,-w/2+18,0>}
              }
#end

#macro f_screws()
        union{
                object{screwhead(3) translate <45,w/2-7,0>}
                object{screwhead(3) translate <252,w/2-7,0>}
                object{screwhead(3) translate <45,-w/2+7,0>}
                object{screwhead(3) translate <252,-w/2+7,0>}
                
                object{screwhead_cs(2) translate <46,w/2-18,-1>}
                object{screwhead_cs(2) translate <46,-w/2+18,-1>}
                object{screwhead_cs(2) translate <197,w/2-18,-1>}
                object{screwhead_cs(2) translate <197,-w/2+18,-1>}
             }
#end

#macro b_screws()
        union{
                object{screwhead(3) translate <10,w/2-7,0>}
                object{screwhead(3) translate <27,w/2-7,0>}
                object{screwhead(3) translate <10,-w/2+7,0>}
                object{screwhead(3) translate <27,-w/2+7,0>}
                object{screwhead(3) translate <l2-7,-105,0>}
                object{screwhead(3) translate <l2-7,105,0>}
              }
#end

#macro knobs()
        union{
                object{knob1() translate<52,-w/2+43,0> texture{T_Blackmetal}}
                object{rocker1() translate<52,-w/2+87,0> texture{T_Blackmetal}}
             }
#end
                

#macro f_rim()

                union{
                        box{<-1,-w/2+mainchamf,-10><0,w/2-mainchamf,3>}
                        box{<mainchamf,-w/2-1,-10><l1,-w/2,3>}
                        box{<mainchamf,w/2+1,-10><l1,w/2,3>}
                      intersection{
                        difference{
                                cylinder{<mainchamf,-w/2+mainchamf,-10><mainchamf,-w/2+mainchamf,3> mainchamf+1}
                                cylinder{<mainchamf,-w/2+mainchamf,-11><mainchamf,-w/2+mainchamf,4> mainchamf}
                                   }
                        box{<-1,-w/2-1,-11><mainchamf,-w/2+mainchamf,3>}
                             }
                      intersection{
                        difference{
                                cylinder{<mainchamf,w/2-mainchamf,-10><mainchamf,w/2-mainchamf,3> mainchamf+1}
                                cylinder{<mainchamf,w/2-mainchamf,-11><mainchamf,w/2-mainchamf,4> mainchamf}
                                   }
                        box{<-1,w/2+1,-11><mainchamf,w/2-mainchamf,3>}
                             }
                      texture{T_Blackmetal}
                      normal{bumps}
                      }
#end                

#macro b_rim()

                union{
                        box{<l2+1,-w/2+mainchamf,-10><l2,w/2-mainchamf,3>}
                        box{<0,-w/2-1,-10><l2-mainchamf,-w/2,3>}
                        box{<0,w/2+1,-10><l2-mainchamf,w/2,3>}
                      intersection{
                        difference{
                                cylinder{<l2-mainchamf,-w/2+mainchamf,-10><l2-mainchamf,-w/2+mainchamf,3> mainchamf+1}
                                cylinder{<l2-mainchamf,-w/2+mainchamf,-11><l2-mainchamf,-w/2+mainchamf,4> mainchamf}
                                   }
                        box{<l2+1,-w/2-1,-11><l2-mainchamf,-w/2+mainchamf,3>}
                             }
                      intersection{
                        difference{
                                cylinder{<l2-mainchamf,w/2-mainchamf,-10><l2-mainchamf,w/2-mainchamf,3> mainchamf+1}
                                cylinder{<l2-mainchamf,w/2-mainchamf,-11><l2-mainchamf,w/2-mainchamf,4> mainchamf}
                                   }
                        box{<l2+1,w/2+1,-11><l2-mainchamf,w/2-mainchamf,3>}
                             }
                      texture{T_Blackmetal}
                      normal{bumps}
                      }
#end                

#macro grill()
        #declare grillw=w-20;
        #declare grilll=l1-30;
        #declare grillh=20;
        #declare barsx=8;
        #declare barsy=6;
        #declare leaddiameter=2;
        union{
                #declare nbx=1;
                #while (nbx<barsx)
                        #declare xs=0;
                        #declare ys=0;
                        #declare zs=0;
                        #declare phi=0;
                        #declare theta=90;
                        union{
                                wirepiece(0,0,grillh-2)
                                wirepiece(0,2,grillh)
                                wirepiece(0,grillw-2,grillh)
                                wirepiece(0,grillw,grillh-2)
                                wirepiece(0,grillw,0)
                                translate <grilll*nbx/barsx,-grillw/2,0>
                              }
                        #declare nbx=nbx+1;
                #end
                #declare nby=1;
                #while (nby<barsy)
                        #declare xs=0;
                        #declare ys=0;
                        #declare zs=0;
                        #declare phi=0;
                        #declare theta=90;
                        union{
                                wirepiece(0,0,grillh-2)
                                wirepiece(2,0,grillh)
                                wirepiece(grilll-2,0,grillh)
                                wirepiece(grilll,0,grillh-2)
                                wirepiece(grilll,0,0)
                                translate <10,grillw*(nby/barsy-.5),-2>
                              }
                        #declare nby=nby+1;
                #end
              texture {T_Silver_1A}
              }
#end

#macro bluebars()
        #declare bluebar=
                union{
                        light_source{<0,0,-10> colour Blue*.2
                                looks_like{
                                        union{
                                                cylinder{<0,-(w-80)/2,-10><0,(w-80)/2,-10> 10 pigment{rgbt <.3,.3,1,0>} finish{ambient .2 diffuse 0}}
                                                cylinder{<0,-(w-80)/2,-10><0,(w-80)/2,-10> 12 pigment{rgbt <.3,.3,1,.9>} finish{ambient .2 diffuse 0}}
                                              }
                                          }
                                    }
                        cylinder{<0,-(w-80)/2,-10><0,-(w-80)/2+10,-10> 11 pigment{rgb .4}}
                        cylinder{<0,(w-80)/2,-10><0,(w-80)/2-10,-10> 11 pigment{rgb .4}}
                        //cylinder{<0,-(w-50)/2,0><0,(w-50)/2,0> 20 pigment{rgbt <.2,.2,1,.9>}hollow}
                        //cylinder{<0,-(w-50)/2,0><0,(w-50)/2,0> 40 pigment{rgbt <.02,.02,1,.99>}hollow}
                     }
        union{
                object{bluebar translate x*l1/3}
                object{bluebar translate x*2*l1/3}
             }
#end

#macro frontbox()
        difference{
                   union{
                        cylinder{<mainchamf,w/2-mainchamf,0><mainchamf,w/2-mainchamf,d2>,mainchamf}
                        cylinder{<mainchamf,-w/2+mainchamf,0><mainchamf,-w/2+mainchamf,d2>,mainchamf}
                        cylinder{<l1g-mainchamf,w/2-mainchamf,0><l1g-mainchamf,w/2-mainchamf,d2>,mainchamf}
                        cylinder{<l1g-mainchamf,-w/2+mainchamf,0><l1g-mainchamf,-w/2+mainchamf,d2>,mainchamf}
                        box{<0,-w/2+mainchamf,0><l1g,w/2-mainchamf,d2>}
                        box{<mainchamf,-w/2,0><l1g-mainchamf,w/2,d2>}
                        
                        }
                   union{
                        box{<0,-w/2-1,0><l1+1,w/2+1,(d2-d1)/cos(pi/180*a1)+1>} // main surface of frontbox
                        box{<m1,-w/2+m1,-th><l1-m1,w/2-m1,-d4>}                //recess
                        cylinder{<l1/2,-w/2+m1,0> <l1/2,w/2-m1,0>,(l1-2*m1)/2  //mirrored back
                                        scale <1,1,.1>
                                        translate <m1,0,-d4>
                                        pigment {rgb .1}
                                        normal {bumps .04 scale 10}
                                        finish{reflection .7 diffuse 0}}
                        cylinder{<m2+mainchamf,w/2-mainchamf-m2,1><m2+mainchamf,w/2-mainchamf-m2,-th-1>,mainchamf}      //rounded corners of cutout
                        cylinder{<m2+mainchamf,-w/2+mainchamf+m2,1><m2+mainchamf,-w/2+mainchamf+m2,-th-1>,mainchamf}
                        cylinder{<l1-m2-mainchamf,w/2-mainchamf-m2,1><l1-m2-mainchamf,w/2-mainchamf-m2,-th-1>,mainchamf}
                        cylinder{<l1-m2-mainchamf,-w/2+mainchamf+m2,1><l1-m2-mainchamf,-w/2+mainchamf+m2,-th-1>,mainchamf}
                        
                        
                        box{<m2,-w/2+mainchamf+m2,1><l1-m2,w/2-mainchamf-m2,-th-1>}                                    //panel cutout
                        box{<mainchamf+m2,-w/2+m2,m2><l1-mainchamf-m2,w/2-m2,-th-1>}
                        
                        cone{<46,w/2-19,-th>2<46,w/2-18,1>3}
                        cone{<46,-w/2+19,-th>2<46,-w/2+18,1>3}
                        cone{<197,w/2-19,-th>2<197,w/2-18,1>3}
                        cone{<197,-w/2+19,-th>2<197,-w/2+18,1>3}
                        
                        rotate y*-a1 translate z*d1
                        }
                texture{T_Graymetal}
                //normal{bumps}
              }
                        //cylinder{<l1-m2-mainchamf,-w/2+mainchamf+m2,1><l1-m2-mainchamf,-w/2+mainchamf+m2,-th-1>,mainchamf pigment{rgb <1,0,0>} rotate y*-a1 translate z*d1}
              object{clips() rotate y*-a1 translate z*d1}
              object{f_screws()rotate y*-a1 translate z*d1}
              object{f_rim() rotate y*-a1 translate z*d1}
              object{posts() rotate y*-a1 translate z*d1}
              object{grill() rotate y*-a1 translate z*d1}
              object{bluebars() rotate y*-a1 translate z*d1}
              
#end

#macro backbox()
        difference{
                   union{
                        cylinder{<mainchamf,w/2-mainchamf,0><mainchamf,w/2-mainchamf,d3>,mainchamf}
                        cylinder{<mainchamf,-w/2+mainchamf,0><mainchamf,-w/2+mainchamf,d3>,mainchamf}
                        cylinder{<l2g-mainchamf,w/2-mainchamf,0><l2g-mainchamf,w/2-mainchamf,d3>,mainchamf}
                        cylinder{<l2g-mainchamf,-w/2+mainchamf,0><l2g-mainchamf,-w/2+mainchamf,d3>,mainchamf}
                        box{<0,-w/2+mainchamf,0><l2g,w/2-mainchamf,d3>}
                        box{<mainchamf,-w/2,0><l2g-mainchamf,w/2,d3>}
                        }
                   box{<0,-w/2-1,0><l2+1,w/2+1,(d3-d2)/cos(pi/180*a2)+1>
                        //pigment{image_map{gif "DigiacFront.gif"} rotate z*90 rotate y*180 scale <l2,w,1> translate <0,w/2,0>}
                        rotate y*-a2 translate z*d2
                        }
                   translate x*l1g
                texture{T_Graymetal}
                //normal{bumps}
              }
              object{b_rim() rotate y*-a2 translate <l1g,0,d2>}
              object{b_screws() rotate y*-a2 translate <l1g,0,d2>}
              object{knobs() rotate y*-a2 translate <l1g,0,d2>}
              //object{functionbox() translate <40,20,0> rotate y*-a2 translate <l1g,0,d2>}
#end

#macro zapper()
        union{
        frontbox()
        backbox()
        }
#end

#macro zap()
        union{
        light_source{<10,-5,15> colour <1,1,3>}
        height_field{gif "zap.gif" water_level .01
                        pigment{
                                gradient y
                                color_map{
                                        [0.0 rgbt <0,0,0.5,.5>]
                                        [0.1 rgbt <0.1, 0.1, 0.8,.5>]
                                        [0.2 rgbt <0.1, .5, 0.8,.5>]
                                        [0.3 rgbt <0, 0, 1,.5>]
                                        [0.5 rgbt <0.1, 1, 0.8,.5>]
                                        [0.7 rgbt <.1, 0.3, 1,.5>]
                                        [0.9 rgbt <0.1, 0.1, 0.8,.5>]
                                        [1.0 rgbt <0,0,1,.5>]
                                          }
                              }
                      finish{ambient 2}
                      scale <20,1,35>
                      rotate z*180
                     }
               }
#end