// Persistence of Vision Ray Tracer Scene Description File
// File: StandStill.pov
// Vers: 3.1, megaPov 0.7
// Desc: 
// Date: 
// Auth: JE and DJ


#version 3.1;
#version unofficial MegaPov 0.7;

#include "colors.inc"
#include "textures.inc"
#include "tweed.inc"
#include "cameras.inc" // Camera Shot Definitions
#include "newgrass.inc" // Grass Definition
global_settings { assumed_gamma 1.0 
                  max_trace_level 15 }

// Create the clock and it's global slowdown
#switch(CamShot)
  #range(1,10)
    #declare anim_clock = clock;
    #break
  #range(11,17)
    #declare anim_clock = c11_s + sin((clock-c10_e)/(c17_e - c10_e)*pi/4)*10;
    #break
  #else
    #declare anim_clock = c11_s + 10;
#end

#render concat("\nanim_clock is " + str (anim_clock,6,6))
#render concat("\nShot is " + str(CamShot,3,3) )
#render concat("\nlocal clock is " + str (c_local_clock,6,6))
#render concat("\nLength of Animation is " + str(c19_e,6,6))

// Camera to find general placement of objects in relation to the DEM file
#declare DEMcam =
camera {
  location <0, 1.5, -3>  // east, up, north
  scale 1.000000 // moves camera to allow for DEM width, if needed
  scale 36515.746094 // moves camera to allow for DEM true size (feet)
  right (4/3)*x
  up y
  look_at 0
  angle 20
}


// Textures for Background Mountains
#declare RoughRocksTexture= 
  texture {
    pigment { spotted 
              color_map { [ 0.0 IndianRed ][1.0 VeryDarkBrown ] } }
    normal { granite 4 scale 12}  }

#declare LightSandTexture =
  texture { 
    pigment { granite 
              color_map { [ 0.0 Flesh] [0.5 LightWood ][1.0 Tan] } }
    normal { granite 12} }

#declare DarkSandTexture = 
  texture { 
    pigment { agate 
              color_map { [ 0.0 VeryDarkBrown] [0.5 MediumWood ][1.0 DarkTan] } }
    normal { granite 12} }

#declare YetAnotherSandDune =
    texture { 
    pigment { crackle 
              color_map { [ 0.0 Copper] [0.5 MediumWood ][1.0 Gold] } }
    normal { granite 12} }

height_field {
  tga "VISTA24000.tga"
  texture {  bozo scallop_wave      
            scale 0.25 frequency 3 turbulence 0.5
            texture_map { [0.00 DarkSandTexture ]  [0.13 LightSandTexture ] 
                          [0.15 LightSandTexture]  [0.47 RoughRocksTexture]  
                          [0.50 RoughRocksTexture] [0.63 YetAnotherSandDune ] 
                          [0.65 YetAnotherSandDune] [1.00 DarkSandTexture] } 
           }
  translate <-0.5, -0.02066, -0.5>
  rotate -55*y
  translate <-0.06,0,0.144>
  scale <1.000000, 5.888141, 1.274933>
  scale <1,1.5,1> // restore DEM aspect ratios (e,u,n)
  scale 36515.746094 // scale DEM to true size (feet)
  scale 12
}

// Ground
plane { y, 0.0 
        pigment {crackle scale 18
                 color_map { [0.0 Clear][ 0.05 Clear ]
                             [0.05 MediumWood] [0.1 LightWood]
                             [1.0 Tan] } }
        normal { crackle scale 18 
                 slope_map {[0.0 <0,0>] [0.05 <0,5> ] [ 0.1 <2,0> ] }    } 
        } 

plane { y, -0.01 pigment { color VeryDarkBrown*0.5 } }

light_source{ <0, 50000, 0>  color White rotate <-30,0,-30>}

// Clock
#declare secondrotation = -6*anim_clock;
#declare minuterotation = -8/12*360; // 40 minutes
#declare hourrotation = -2/12*360; // 2pm
#switch (CamShot)
#range (1,10)
  #declare facepos = <0,60,0.99>;
  #break
#case (11)
  #declare facepos = <0,60,0.99> - <0,2,0>*c_local_clock;
  #break
#case (13)
  #declare facepos = <0,40,0.99> - <0,3,0>*c_local_clock;
  #break
#case (15)
  #declare facepos = <0,20,0.99> - <0,4,0>*c_local_clock;
  #break
#case (17)
  #declare facepos = <0,12,0.99> - <0,5,0>*c_local_clock;
  #break
#range(18,19)
  #declare facepos = <0,7,0.99>;
#end

#include "grandfather.inc"
object { Grandfatherclock   rotate <0,15,0> translate <48,0,36>}

// sky
sky_sphere { pigment { gradient y color_map { [0.0 color rgb <0.3,0.3,0.5>] [1.0 color blue 0.5] } } }

// cloud layer
plane { y 40000 hollow 
          pigment { wrinkles scale <70000,70000,70000> turbulence sin(clock/4)*0.4 
                    color_map { [0.05 rgb 1 ] [0.35 rgbf 1 ] } 
                    translate <800*anim_clock,2,500*anim_clock>}
          finish { ambient 0.7 }}

 // fog
fog {
  fog_type   2
  distance   400
  color      Bronze2 // gray
  fog_offset 6
  fog_alt    12
  turbulence 1.8+sin(anim_clock)
  //translate <1*clock,0,0>
}

#declare weed_start = <-180,0,120>;
#declare weed_end = <800,0,500>;
//cylinder { weed_start weed_end 2 pigment { rgb 1 } finish{ phong 1 } translate 12*y}
object { Tumbleweed
         //translate <0,-12,-0>
         scale 1.5
         rotate -100*anim_clock*z 

//         rotate degrees(-1*atan2((500-120),(800+180)))*y
//         translate weed_start + (anim_clock/37)*(weed_end-weed_start)


//         translate 2.5*pi*anim_clock*x //tumble behind clock (?)
         translate 4*pi*anim_clock*x
         translate (15 +(18*sin( pi/6 + (pi/3)*(3*anim_clock/(2*37)) ))*abs(cos(3*pi*anim_clock/37)))*y
         rotate degrees(-1*atan2((500-120),(800+180)))*y
         translate weed_start
         }
//

//camera { WeedCam }
// tree\
#if (CamShot < 18 )
  #include "dalitree.inc"
#else 
  #include "dalitree2.inc"
#end
object { dalitree scale <1,1.5,1> rotate 10*y translate <-144,0,208> }


// Grass
#declare Blade_Height_Min = 30;
#declare Blade_Height_Max = 36;
#declare Blade_Detail = 8;
#declare Blade_Angle_Max = 30;
#declare Blade_Angle_Min = 15;
#declare Blade_Seed = seed(351);
//#declare Blade_Density = 0.5;
#declare Patch_Shape = 0;
#declare Clump_Radius_Minimum = 1;
#declare Clump_Radius_Maximum = 8;
#declare PlotPoints = false;
#declare Grass_Center = <-50,0,0>;
#declare Blade_Width = 0.25;
#declare ColorBlades = true;
#declare Wind_Direction = <8,0,5>;
#declare Wind_Strength = 1;
#declare Wind_Frequency = 1;
#declare Grass_Clock = anim_clock;
//PlantPatch()
#declare BladeCount = 50;
#declare cnt = 0;
#while (cnt < BladeCount)
  #declare here = GetBladePosition(Patch_Shape);
  DrawBlade(here)
  #declare cnt = cnt + 1;
#end

height_field  { tga "sandpile.tga"
                texture { LightSandTexture } 
                translate <-0.5,-0.01,-0.5>
                scale <18,3,18>
                translate Grass_Center }

// Rock by D. Jones
#declare SofaRock =
blob { threshold 0.45
  sphere {
    <0, 1, 0> // center of sphere <X Y Z>
    15       // radius of sphere
    .65
    scale <2,1.25,1>
  }             
  sphere {
    <-5, 3.75, 0>
    6
    .85
    scale <1,1.5,.85>
  }               
  texture {
    normal { bumps .75 scale .275 } 
    pigment {
      image_map{
        tga "stone.tga" // the file to read (iff/gif/tga/png/sys)
        map_type 2   // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 0  // 0=none, 1=linear, 2=bilinear, 4=normalized distance
      } // image_map
      rotate -45*y
    } //pigment
  } }

object { SofaRock scale 8 translate <-68,0,600> }

// Vulture by D. Jones
sphere { <0, 0, 0>  1
         pigment { image_map { tga "vulture.tga" 
                   map_type 1 
                   interpolate 2 } } 
         scale 84
         translate <120,0,0>
         rotate <0,-anim_clock*(360/5),0>
         translate <-400,600,1800> 
}


// Sun 
#if (CamShot = 6) 
disc
{
  <0, 0, 0>  // center position
  z,         // normal vector
  1.2,       // outer radius
  0        // optional hole radius
  pigment { spherical
            pigment_map { [ 0.00 rgbf 1 ]
                          [ 0.15 spiral1 3 scale 0.1 turbulence 0.05 lambda 1.5 octaves 2 omega 2 color_map { [ 0.0 rgb <1,1,0> ] [1.0 rgbf 1 ] } phase -clock]
                          [ 0.35 rgb <1,1,0> ]
                        } }
  finish { ambient 1 }
  rotate -90*x
  scale 10000
  translate 50001*y
  rotate <-30,0,-30> 
//  no_shadow
}
#end


// Cameras
#declare scenecam =
camera { cylinder 1
         location <0,36,-60>
         angle 2*degrees(atan2(8/9,1))
         up 1*y
         right 16/9*x
         look_at <0,36,0> }

#declare grasscam = 
camera { location <0,24,-48>
         direction 1.5*z
         right 16/9*x
         look_at <0,18,0>
         translate <-50,0,0>
}
#declare weedcam = camera {
  location <48,72,-48>
  right 16/9*x
  look_at <0,0,0>
  translate 4*pi*31*x 
  translate 12*y
  rotate degrees(-1*atan2((500-120),(800+180)))*y
  translate weed_start }


//         translate 4*pi*anim_clock*x
//         translate (15 +(18*sin( pi/6 + (pi/3)*(3*anim_clock/(2*37)) ))*abs(cos(3*pi*anim_clock/37)))*y
//         rotate degrees(-1*atan2((500-120),(800+180)))*y
//         translate weed_start


#declare vulturecam = camera {
  right 16/9*x
  direction 2.25*z
  location <0,36,-60>
  look_at <-400,600,1800>  
}

#declare clockcam = 
camera { location <0,3,-60>
         right 16/9*x
         direction 2.25*z
         look_at <0,0,0> 
         rotate 15*y
         translate <48,facepos.y,36>}

#declare suncam = 
camera { location  <0.0, 0.5, -4.0>
         direction 2.5*z
         right     16/9*x
         look_at   vrotate(<0,50000,0>,<-30,0,-30>) }

#switch(CamShot)
  #case(1) camera { scenecam } 
  #break
  #case(2) camera { clockcam } 
  #break
  #case(3) 
    camera { clockcam } // also with Title 
    #declare image_filter = pow(c_local_clock,10);
    #render concat("Image Filter is " + str(image_filter,6,6))
    box { <0,0,0> <1,1,0>
      pigment { image_map { tga "astime2.tga" map_type 0interpolate 2 transmit all image_filter} }
      finish { ambient 0.5 }
      no_reflection no_shadow hollow
      translate <-0.5,-0.5,0>
      scale 3*<16,9,1>
      rotate 15*y
      translate <48,60,36>
 }
  #break
  #case(4) camera { grasscam } 
  #break
  #case(5) camera { scenecam } 
  #break
  #case(6) camera { suncam } 
  #break
  #case(7) camera { scenecam } 
  #break
  #case(8) camera { vulturecam } 
  #break
  #case(9) camera { scenecam } 
  #break
  #case(10) camera { clockcam } // with title
    #declare image_filter = pow(c_local_clock,10);
    #render concat("Image Filter is " + str(image_filter,6,6))
    box { <0,0,0> <1,1,0>
      pigment { image_map { tga "standstill2.tga" map_type 0interpolate 2 transmit all image_filter} }
      finish { ambient 0.5 }
      no_reflection no_shadow hollow
      translate <-0.5,-0.5,0>
      scale 3*<16,9,1>
      rotate 15*y
      translate <48,60,36>
    }  
  #break
  #case(11) 
    camera { clockcam } 
  #break
  #case(12) 
    camera { grasscam } 
  #break
  #case(13) camera { clockcam }
	#break
	#case(14) camera { weedcam } 
	#break
	#case(15) camera { clockcam } 
	#break
	#case(16) camera { vulturecam } 
	#break
	#case(17) camera { clockcam } 
	#break
	#case(18) camera { scenecam } 
	#break
	#case(19) camera { titlecam } 
	#break
#else
  camera { scenecam }
#end




