// Persistence of Vision Ray Tracer Scene Description File
// File: clokface.pov
// Vers: 3.1
// Desc: This file creates the clockface and the hands
//       It needs to be run several times and +q1
//       to create the following files
//       These files are rendered with MakeBumpMap = true
//         clokface.tga
//         clokfacebump.tga
//         clokfacebevel.tga (See line 110 or so)
//       These files are rendered with MakeBumpMap = false
//         hourhand.tga
//         minutehand.tga
//         secondhand.tga
// Date: 4/9/01
// Auth: David Jones, Josh English

#include "colors.inc"
#include "textures.inc"

camera {
  location <0, 0, -1300>
  look_at <0, 0, 0>
  right 1*x
  orthographic
}

light_source { <0, 00, -999> 2*<1,1,1> }
//light_source { <0, 0, 700>  <1,1,1> }

#declare MakeBumpMap = false;

plane {
  z, 0
  texture {
  #if(MakeBumpMap)
    pigment { rgb 0 }
  #else
    pigment {SkyBlue}
  #end
} 
  translate <0,0,1000> }



#declare Ring=600;
  #while (Ring>5)
    difference {
      cylinder {
        <0,0,0>, <0,0,1>, Ring  }
      cylinder {
        <0,0,-1>, <0,0,2>, Ring-19.9999 }  
      texture {
        #if(MakeBumpMap)
          pigment { rgb 0 }
        #else
          pigment { Silver*(.75+abs(sin((5/3)*Ring/300))/8) }
        #end 
        finish { metallic } } }                       
    #declare Ring=Ring-20;
  #end //while

#declare RomanI =
  union {
    cylinder { <0,50,0> <0,-50,0> 15 }
    cylinder { < 20, 50, 0> <-20, 50, 0> 15 }
    sphere { <20,50,0> 15 }
    sphere { <-20,50,0> 15 }
    cylinder { < 20, -50, 0> <-20, -50, 0> 15 }
    sphere { < 20, -50, 0> 15 }
    sphere { <-20, -50, 0> 15 }
  } //union of RomanI

#declare RomanV =
  union {
    object {
      cylinder { < 0,  50, 0> <-0, -50, 0>  15 }
      rotate <0,0,15>
      translate <-17.5,0,0> }  
    object {
      cylinder { < 0,  50, 0> <-0, -50, 0>  15 }
      rotate <0,0,-15>
      translate <17.5,0,0> }  
    sphere { <0,-50, 0> 15 }
    cylinder { < 45, 50, 0> <-45, 50, 0> 15 }
    sphere { < 45, 50, 0> 15 }
    sphere { <-45, 50, 0> 15 }
    cylinder { < 45, -50, 0> <-45, -50, 0> 15 }
    sphere { < 45, -50, 0> 15 }
    sphere { <-45, -50, 0> 15 }
  } //union of RomanV  



#declare RomanX =
  union {
    object {
      cylinder { <0, 60, 0> <0,-60, 0>  15 }
      rotate <0,0,40> }   
    object {
      cylinder { <0, 60, 0> <0,-60, 0> 15 }
      rotate <0,0,-40> }  
    sphere { <0,0,0> 15 }
    cylinder { < 50, 50, 0> <-50, 50, 0> 15 }
    sphere { < 50, 50, 0> 15 }
    sphere { <-50, 50, 0> 15 }
    cylinder { < 50, -50, 0> <-50, -50, 0> 15 }
    sphere { < 50, -50, 0> 15 }
    sphere { <-50, -50, 0> 15 }
  } //union of RomanX  

#if (MakeBumpMap)
  #declare LetterTexture = 
    texture {
      pigment { gradient z scale 15 } } // 5 for bevel, 15 for smooth
#else
  #declare LetterTexture =
    texture {
      pigment { Gold*1.5 }
      finish {
        metallic 
        specular 1 } } 
#end


#declare LetterRadius = 450;
object { //one
   RomanI 
   texture { LetterTexture }
   rotate <0,0,360/12*1>
   translate <0,LetterRadius,0>
   rotate <0,0,-360/12*1>     
} //one

object { //two
  union {
    object { RomanI translate <-20,0,0> }
    object { RomanI translate < 20,0,0> }
  } //union
  texture { LetterTexture }
  rotate <0,0,360/12*2>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*2>     
} //two

object { //three
  union {
    object { RomanI translate <-40,0,0> }
    object { RomanI translate < 0,0,0> }
    object { RomanI translate < 40,0,0> }
  } //union

  texture { LetterTexture }
  rotate <0,0,360/12*3>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*3>     
}//three

object { //four
  union {
    object { RomanV translate <50,0,0> }
    object { RomanI translate <-10,0,0> }
  } //union
  texture { LetterTexture }
  translate <-32.5,0,0>
  rotate <0,0,360/12*4>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*4>     
}//four

object { //five
  RomanV
  texture { LetterTexture }
  rotate <0,0,360/12*5>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*5>     
} //five

object { //six
  union {
    object { RomanV translate <-50,0,0> }
    object { RomanI translate < 10,0,0> }
  } //union
  texture { LetterTexture }
  translate <32.5,0,0>
  rotate <0,0,360/12*6>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*6>     
}//six

object { //seven
  union {
    object { RomanV translate < -60,0,0> }
    object { RomanI translate < 0,0,0> }
    object { RomanI translate <40,0,0> }
  } //union
  texture { LetterTexture }
  translate <17.5,0,0>
  rotate <0,0,360/12*7>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*7>     
}//seven

object { //eight
  union {
    object { RomanV translate <-70,0,0> }
    object { RomanI translate <-10,0,0> }
    object { RomanI translate < 30,0,0> }
    object { RomanI translate < 70,0,0> }
  } //union
  texture { LetterTexture }
  translate <12.5,0,0>
  rotate <0,0,360/12*8>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*8>     
}//eight

object { //nine
  union {
    object { RomanX translate <50,0,0> }
    object { RomanI translate < -10,0,0> }
  } //union
  texture { LetterTexture }
  translate <-35,0,0>
  rotate <0,0,360/12*9>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*9>     
}//nine

object { //ten
  RomanX
  texture { LetterTexture }
  rotate <0,0,360/12*10>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*10>     
} //ten

object { //eleven
  union {
    object { RomanX translate <-50,0,0> }
    object { RomanI translate < 10,0,0> }
  } //union
  texture { LetterTexture }
  translate <35,0,0>
  rotate <0,0,360/12*11>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*11>     
}//eleven

object { //twelve
  union {
    object { RomanX translate < -60,0,0> }
    object { RomanI translate < 0,0,0> }
    object { RomanI translate <40,0,0> }
  } //union
  texture { LetterTexture } 
  translate <25,0,0>
  rotate <0,0,360/12*12>
  translate <0,LetterRadius,0>
  rotate <0,0,-360/12*12>     
}//twelve

//object { //hour hand
//  union {
//    sphere { < 0, 0, -25 > 20 }
//    cylinder { < 0, 0,-25> <100/3,25,-25> 7.5 }
//    cylinder { < 0, 0,-25> <-100/3,25,-25> 7.5 }
//    cylinder { <-100/3,25,-25> < 100/3,25,-25> 7.5 }
//    sphere { < 100/3,25,-25> 7.5 }
//    sphere { <-100/3,25,-25> 7.5 }
//    cylinder { <25,  25, -25> <25, 250, -25>  7.5 }
//    cylinder { <-25,  25, -25> <-25, 250, -25> 7.5 }
//    cylinder { <0,  25, -25> <0, 250, -25> 7.5 }
//    cylinder { <-100/3,250,-25> < 100/3,250,-25> 7.5 }
//    sphere { <-100/3,250,-25> 7.5 }
//    sphere { < 100/3,250,-25> 7.5 }
//    difference {
//      box { <-100/3, 250, -18> < 100/3, 350, -32> }
//      object {
//        cylinder { <0, 0, 0> <0, 0, -35> 1 }
//        scale <45,100,1>
//        translate <50,350,0>
//      } //object  
//      object {
//        cylinder { <0, 0, 0> <0, 0, -35> 1 }
//        scale <45,100,1>
//        translate <-50,350,0>
//      } //object  
//    } // difference    
//  } //union
//  texture {
//    pigment { DarkSlateBlue/1.25 }
//    finish {
//      metallic 
//      specular 1/3
//    } //finish
//  } // textire 
// // rotate <0,0,-60>  
//} //object hour hand  

//object { //minute hand
//  union {
//    sphere { < 0, 0, -25 > 20 }
//    cylinder { < 0, 0,-25> <100/3,25,-25> 7.5}
//    cylinder { < 0, 0,-25> <-100/3,25,-25> 7.5 }
//    cylinder { <-100/3,25,-25> < 100/3,25,-25> 7.5 }
//    sphere { < 100/3,25,-25> 7.5 }
//    sphere { <-100/3,25,-25> 7.5 }
//    cylinder { <25,  25, -25> <25, 350, -25> 7.5 }
//    cylinder { <-25,  25, -25> <-25, 350, -25> 7.5 }
//    cylinder { <0,  25, -25> <0, 350, -25> 7.5 }
//    cylinder { <-100/3,350,-25> < 100/3,350,-25> 7.5 }
//    sphere { <-100/3,350,-25> 7.5 }
//    sphere { < 100/3,350,-25> 7.5 }
//    difference {
//      box { <-100/3, 350, -18> < 100/3, 450, -32> }
//      object {
//        cylinder { <0, 0, 0> <0, 0, -35> 1 }
//        scale <45,100,1>
//        translate <50,450,0> } //object  
//      object {
//        cylinder { <0, 0, 0> <0, 0, -35> 1 }
//        scale <45,100,1>
//        translate <-50,450,0> } }  } //union
//  texture {
//    pigment { DarkSlateBlue/1.25 }
//    finish {
//      metallic 
//      specular 1/3 }  } // textire
////  rotate <0,0,-275> 
//} //object minute hand  

//union {
//  sphere { < 0, 0, -25 > 20 }
//  cylinder { <0,0,-50> <0,450,-50> 7.5 }  
//  texture {
//    pigment { DarkSlateBlue/1.25 }
//    finish {
//      metallic 
//      specular 1/3 } } 
// // rotate <0,0,-190>
//} 




