#include "colors.inc"         
#macro SphToRec (rho, theta, phi) rho*<sin(phi)*cos(theta), sin(phi)*sin(theta), cos(phi)> #end                                
#macro PlrToRec (rho, theta, zed) <rho*cos(theta),zed,rho*sin(theta)> #end
#macro BXform(rho, theta, zed) <zed,rho*sin(theta),rho*cos(theta)> #end

#declare dalitree =
blob { threshold 0.45
  
  #declare RockHeight=20;  //base of tree
    #while (RockHeight>-1)
      #declare RockRadius=2+2.5*pow((1-sin( (pi/2)*(RockHeight/20) )),1.25);
      #declare RockX=0.23*sin(2*pi*RockHeight/17)+sin(2*pi*20/200)-.1;
      #declare RockZ=0.27*cos(2*pi*RockHeight/13)+cos(2*pi*20/200)+.23;
      #declare RockAng=2*pi;
      #while (RockAng>0)
        sphere { PlrToRec(RockRadius, RockAng, RockHeight)  // builds ring for that level
                 + <RockX,0,RockZ>  //translates ring
                ((RockRadius*3*pi)/(pi/.2))
               .75 }
        #declare RockAng=RockAng-0.15;
      #end
    #declare RockHeight=RockHeight-.5;
  #end
  
  
  #declare RockHeight=20.5;  //main trunk of tree
    #while (RockHeight<80.1)
      #declare RockRadius=2+0.19*pow((1-sin( (pi/2)*(RockHeight/20) )),1.1);
      #declare RockX=0.23*sin(2*pi*RockHeight/17)+sin(2*pi*20/200)-.1;
      #declare RockZ=0.27*cos(2*pi*RockHeight/13)+cos(2*pi*20/200)+.23;
      #declare RockAng=2*pi;
      #while (RockAng>0)
        sphere { PlrToRec(RockRadius, RockAng, RockHeight)  // builds ring for that level
                 + <RockX,0,RockZ>  //translates ring
                ((RockRadius*3*pi)/(pi/.2))
               .75 }
        #declare RockAng=RockAng-0.15;
      #end
    #declare RockHeight=RockHeight+.5;
  #end

//y goes to x, x goes to z, z goes to y
//#declare RockHeight=60; // start of branch
//    #while (RockHeight>-1)
//      #declare RockRadius=1+1.25*pow((1-sin( (pi/2)*(RockHeight/20) )),1.25);
//      #declare RockX=0.23*sin(2*pi*RockHeight/17)+sin(2*pi*20/200)-.1;
//      #declare RockZ=0.27*cos(2*pi*RockHeight/13)+cos(2*pi*20/200)+.23;
//      #declare RockAng=2*pi;
//      #while (RockAng>0)
//        sphere { BXform(RockRadius, RockAng, RockHeight)  // builds ring for that level
//                + <1,40+RockHeight/5+RockX  + 10*sin(pi/3) - 10*sin( (2+(RockHeight/60)*3)/pi ),RockZ+.35>  //translates ring
//                ((RockRadius*3*pi)/(pi/.2))
//               .75 }
//        #declare RockAng=RockAng-1/4;
//      #end
//    #declare RockHeight=RockHeight-1/3;
//  #end 
  
  #declare RockHeight=0;  //second half of branch
    #while (RockHeight<60.1)
      #declare RockRadius=1+1.25*pow((1-sin( (pi/2)*((RockHeight-30)/20) )),1.25)/4;
      #declare RockX=0.23*sin(2*pi*RockHeight/17)+sin(2*pi*20/200)-.1;
      #declare RockZ=0.27*cos(2*pi*RockHeight/13)+cos(2*pi*20/200)+.23;
      #declare RockAng=2*pi;
      #while (RockAng>0)
        sphere { BXform(RockRadius, RockAng, RockHeight)  // builds ring for that level
                 + <1,46+(RockHeight-30)/6+RockX  - 25*sin(pi/3) + 25*sin( (2+(RockHeight/60)*4)*pi/6) ,RockZ+.35>  //translates ring
                ((RockRadius*3*pi)/(pi/.2))
               .75 }
        #declare RockAng=RockAng-1/4;
      #end
    #declare RockHeight=RockHeight+1/3;
  #end
  
  #declare RockHeight=20;  // sub-branch
    #while (RockHeight>0)
      #declare RockRadius=.5+1*(1-pow((sin( (pi/2)*(RockHeight/20) )),1.1));
      #declare RockX=0.23*sin(2*pi*RockHeight/11)+sin(2*pi*20/200); //+ pow(RockHeight/5,2.5);
      #declare RockZ=0.27*cos(2*pi*RockHeight/7)+cos(2*pi*20/200) + .25;
      #declare RockAng=2*pi;
      #while (RockAng>0)
        sphere { PlrToRec(RockRadius, RockAng, -RockHeight/1.1)  // builds ring for that level
                 + <RockX,0,RockZ>  //translates ring
                 + <30,47,1>
                ((RockRadius*3*pi)/(pi/.2))
               .75 }
        #declare RockAng=RockAng-1/4;
      #end
    #declare RockHeight=RockHeight-1/5;
  #end
  texture { pigment { Grey*1.5 }}
}

