// Persistence of Vision Ray Tracer Scene Description File
// File: newgrass.inc
// Vers: 3.1
// Desc: Updated version of the grasspatch macro
// Date: 3-9-2001
// Auth: JRE

#include "colors.inc"

#declare HelloGrassPatch = true;

// Global Options
#declare Grass_Rotation = 0; // only about the y axis
#declare Grass_Center = <0,0,0>; // regular vector
#declare BladeCount = 100;

// Patch Type 0 : Circular Clump
#declare grassseed = seed(4493);// 4 digit prime number
#declare Clump_Radius_Minimum = 0.15;
#declare Clump_Radius_Maximum = 1;
#declare Spread_Correction = 2;

// Patch Type 1 : Square Patch
#declare Patch_X_Minimum = -2.5;
#declare Patch_X_Maximum = 2.5;
#declare Patch_Z_Minimum = -2.5;
#declare Patch_Z_Maximum = 2.5;

// Patch Type 2 : Polygon Patch
#declare Patch_Sides = 3;
// uses Clump_Radius_Minimum, Clump_Radius_Maximum,Spread_Correction 

// Patch Type 3 : Curve Path... goes along a bezier curve
#declare Patch_Path = array[4] { <-3,0,0>, <-1,0,5>, <1,0,-5> <3,0,0> }

// Code for the Individual Blades
#declare Blade_Detail = 6;
#declare Blade_Height_Min = 1.5; //In POV Units
#declare Blade_Height_Max = 2.5; //In POV Units
#declare Blade_Width = 0.05; //in POV Units
#declare Blade_Angle_Min = 0;
#declare Blade_Angle_Max = 35;

// Code for the Wind that moves the blades
#declare Wind_Direction = <8,0,5>;
#declare Wind_Strength = 1; // Between 0 and 1
#declare Wind_Frequency = 1; // How fast the wind moves
#declare Grass_Clock = clock;
#declare bladeseed = seed(5261);// Another 4 digit prime number

// Splines to color the grass
#declare MixedGrass = array [4] 
 { <0,0.6,0>, <1,0.5,0>, <1,1,0>, <0,0.3,0> }
//889-1300 intertrut portland 

// ***********************************
// ****** THE INDIVIDUAL MACROS ******
// ***********************************
// ** DO NOT EDIT BEYOND THIS POINT **
// ***********************************

#macro GetClumpPosition() //Returns a vector
  #local Clump_Radius_Range = Clump_Radius_Maximum-Clump_Radius_Minimum;
  #local subr = pow(rand(grassseed),Spread_Correction);
  #local subr = Clump_Radius_Minimum + subr*Clump_Radius_Range;
  #local thispoint = <subr,0,0>;
  #local thispoint = vrotate(thispoint,<0,rand(grassseed)*360,0>);
  thispoint
#end

#macro GetPatchPosition()
  #local X_Range = Patch_X_Maximum- Patch_X_Minimum;
  #local Z_Range = Patch_Z_Maximum- Patch_Z_Minimum;
  #local px = Patch_X_Minimum + rand(grassseed)*X_Range;
  #local pz = Patch_Z_Minimum + rand(grassseed)*Z_Range;
  #local thispoint = <px,0,pz>;
  thispoint
#end


#macro GetPolyPosition()
  #local PolyIntAngle = 360/Patch_Sides;
  #local Clump_Radius_Range = Clump_Radius_Maximum-Clump_Radius_Minimum;
  #local subr = pow(rand(grassseed),Spread_Correction);
  #local subr = Clump_Radius_Minimum + subr*Clump_Radius_Range;
  #local trgt = vrotate(<subr,0,0>,<0,PolyIntAngle,0>);
  #local here = <subr,0,0> + rand(grassseed)*(trgt-<subr,0,0>);
  #local seg = int(rand(grassseed)*(Patch_Sides + 1));
  #local here = vrotate(here,<0,seg*PolyIntAngle,0>);
  here
#end


#macro GetPathPosition()
  #local ReturnPostition(Patch_Path,rand(grasseed)
#end


// Get Blade Position based on shape. This adds the global changes of rotation and 
#macro GetBladePosition(shape)
  #switch(shape)
    #case(1)
      #local here = GetPatchPosition();
      #break
    #case(2)
      #local here = GetPolyPosition();
      #break
    #case(3)
      #local here = GetCurvePosition();
      #break
    #else // assume circular
      #local here = GetClumpPosition();
    #end // switch
  #local here = vrotate(here,<0,Grass_Rotation,0>)+Grass_Center;
  here
#end


#macro ColorBlade(id,d)
  #local m = 1 - d;
  #local this = id[0]*pow(m,3) +  id[1]*d*3*pow(m,2) +  id[2]*3*pow(d,2)*m + id[3]*pow(d,3);
  this
#end


#macro DrawBlade(pos)
  #local cnt = 0;
  #local thisH = Blade_Height_Min + rand(bladeseed)*(Blade_Height_Max - Blade_Height_Min);
  #local thisA = Blade_Angle_Min + rand(bladeseed)*(Blade_Angle_Max - Blade_Angle_Min);
  #local thisR = rand(bladeseed)*360;
  #local thisW = vnormalize(Wind_Direction);
  #local thisO = rand(bladeseed)*0.5; // Offset clock value on each blade
  #local thisC = ColorBlade(MixedGrass,rand(bladeseed));

  #while ( cnt <= Blade_Detail )
    #local thisP = cnt/Blade_Detail;
    #local here = <0,thisH*thisP,0>;
    #local here = vrotate(here,<0,0,thisA*thisP>) ;
    #local here = vrotate(here,<0,thisR,0>);
    #local thisS = Wind_Strength*pow(sin(pi*Wind_Frequency*(Grass_Clock+thisO)),2);
    #local here = here + thisW*thisS*thisP;//*(thisH(Blade_Height_Max - Blade_Height_Min);
    #local here = here + pos;
    sphere { here Blade_Width*(1-thisP) pigment { rgb thisC} }
    #if ( cnt > 0 )
      #local lastP = (cnt-1)/Blade_Detail;
      #local there = <0,thisH*lastP,0>;
      #local there = vrotate(there,<0,0,thisA*lastP>) ;
      #local there = vrotate(there,<0,thisR,0>);
      #local there = there + thisW*thisS*lastP;//*(Blade_Height_Max - Blade_Height_Min);
      #local there = there + pos;
      cone { there Blade_Width*(1-lastP) here Blade_Width*(1-thisP)  pigment { rgb thisC } }
    #end
    #local cnt = cnt + 1;
  #end
#end

//// Code for testing
//#version 3.1;
////#version unofficial MegaPov 0.7;
//
//#include "colors.inc"
//
//global_settings{ assumed_gamma 1.0}
//
//// ----------------------------------------
//camera{ location  <0.0, 3.5, -6.0>
//        direction 1*z right 4/3*x
//        look_at   <0.0, 0.0,  0.0> }
//
//sky_sphere { pigment { gradient y
//                       color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } } }
//
//light_source { <-30, 30, -30> color rgb 1.0 }
//
//// ----------------------------------------
//plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}
//
//
//#declare cnt = 0;
//
// // Test
//#declare Patch_Shape = 1;
//#while (cnt < BladeCount)
//  #declare here = GetBladePosition(Patch_Shape);
//  //sphere { here 0.05 pigment { rgb <0,0.3,0> } }
//  DrawBlade(here)
//  #declare cnt = cnt + 1;
//#end
//
//
////#declare grassobj =
////height_field { tga "newgrasstest.tga" 
////               pigment { rgb 1 }
////               translate <-0.5,0,-0.5>
////               scale <4,1,4> }
////
////object { grassobj}
////
////#declare Patch_Shape = 0;
////#while (cnt < BladeCount)
////  #local here = GetBladePosition(Patch_Shape) ;
////  #local there = trace(grassobj,here+<0,2,0>,<0,-1,0>);
////  //sphere { there 0.05 pigment { rgb <0,0.3,0> } }
////   DrawBlade(there) 
////  #declare cnt = cnt + 1;
////#end
//
//#declare DrawBoundary = false;
//#if ( DrawBoundary)
//// Boundaries
//#switch(Patch_Shape)
//  #case(1)
//    union { 
//      sphere { <Patch_X_Minimum,0,Patch_Z_Minimum> 0.05 }
//      sphere { <Patch_X_Minimum,0,Patch_Z_Maximum> 0.05 }
//      sphere { <Patch_X_Maximum,0,Patch_Z_Minimum> 0.05 }
//      sphere { <Patch_X_Maximum,0,Patch_Z_Maximum> 0.05 }
//      cylinder { <Patch_X_Minimum,0,Patch_Z_Minimum> <Patch_X_Minimum,0,Patch_Z_Maximum> 0.05 }
//      cylinder { <Patch_X_Maximum,0,Patch_Z_Minimum> <Patch_X_Maximum,0,Patch_Z_Maximum> 0.05 }
//      cylinder { <Patch_X_Minimum,0,Patch_Z_Minimum> <Patch_X_Maximum,0,Patch_Z_Minimum> 0.05 }
//      cylinder { <Patch_X_Minimum,0,Patch_Z_Maximum> <Patch_X_Maximum,0,Patch_Z_Maximum> 0.05 }
//    pigment { rgb <1,1,0> }
//    rotate <0,Grass_Rotation,0>
//    translate Grass_Center }
//    #break
//  #case(2)
//    #declare IntAngle = 360/Patch_Sides;
//    union { 
//      #declare c = 0;
//      #while ( c < Patch_Sides )
//        sphere { vrotate(<Clump_Radius_Minimum,0,0>,<0,c*IntAngle,0>) 0.03 }
//        sphere { vrotate(<Clump_Radius_Maximum,0,0>,<0,c*IntAngle,0>) 0.03 }
//        cylinder { vrotate(<Clump_Radius_Minimum,0,0>,<0,c*IntAngle,0>)
//                   vrotate(<Clump_Radius_Minimum,0,0>,<0,(c+1)*IntAngle,0>) 0.03 }
//        cylinder { vrotate(<Clump_Radius_Maximum,0,0>,<0,c*IntAngle,0>)
//                   vrotate(<Clump_Radius_Maximum,0,0>,<0,(c+1)*IntAngle,0>) 0.03 }
//        #declare c = c + 1;
//      #end
//      pigment { rgb <1,1,0> } }
//    #break
//  #case(3)
//    #break
//  #else
//    #if (Clump_Radius_Minimum > 0 )
//      torus { Clump_Radius_Minimum 0.05 pigment { rgb <1,1,0> } }
//    #end
//    torus { Clump_Radius_Maximum 0.05 pigment { rgb <1,1,0> } }
//#end
//
//#end
// 