#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#local r=0.015;
#local a=0.003;
#local rp=0.005;
#local ap=0.019;

// the following parameters needs to be set:

//#local phi=0.5*pi/2;
//#local psi=0;
//#local theta=0.5*pi/2;
//#local xs=0;
//#local ys=0;
//#local zs=0.015;

// The animation was done by using the values given in the data file.

#local f=600;

object {
  union {
    difference {
      sphere {<0,a*f,0>,r*f}
      cylinder {<0,a*f,0>,<0,(a+r)*f,0>,0.7*r*f}
    }
    sphere {<0,ap*f,0>,rp*f}
    cylinder {<0,a*f,0>,<0,ap*f,0>,rp*f}
    texture {EMBWood1 rotate <90,45>}
  }
  rotate <0,-psi*180/pi,0>
  rotate <theta*180/pi,0,0>
  rotate <0,(pi/2-phi)*180/pi,0>
  translate <-ys*f,zs*f,xs*f>
}


object {
  plane {y,0}
//  pigment {checker color Black color White scale 5 }
  pigment {Gray50}
}

object {
  plane {z,-100}
  pigment {Gray70}
}

camera {
  location <0, 30, 50>
  look_at <0, 10, 0>
}

object {
  light_source {
  <50, 100, 100>
  rgb <2, 2, 2>
//  spotlight
//  radius 3
//  falloff 13
//  tightness 10
//  point_at <0, 10, 0>
  }
}

