// moon transformation
// Franco Bedeschi may-june 2001
// contact me at fbedeschi@tiscalinet.it

//global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"

//moon parameters
#declare dmoon=20400;                    //earth-moon distance
#declare alfamoon=30*pi/180;             //vert degree
#declare phmoon=0;                       //horz degree
#declare xmoon=dmoon*sin(phmoon);        //polar
#declare ymoon=dmoon*sin(alfamoon);      //coords
#declare zmoon=dmoon*cos(alfamoon);      //of the moon

//sunlight parameters
#declare ksun=clock;
#declare dsun=150000000;
#declare alfasun=0;                      //vert degree
#declare phsun=ksun*pi/180;              //horz degree
#declare xsun=xmoon+dsun*cos(phsun);     //earth centered
#declare ysun=ymoon+dsun*sin(alfasun);   //orbit
#declare zsun=zmoon+dsun*sin(phsun);     //of the sun !!!

camera {
   location  <0, 0.002,0>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <xmoon, ymoon/4, zmoon>
   angle 90
}
 
//the moving sun-light
light_source {<0,0,0> color White
        looks_like {sphere {<0,0,0>,1400000}} 
        translate <xsun,ysun, zsun>
        }

light_source {<0,0,0> color White}

// moon
sphere { <0,0,0>, 1750
        pigment {bozo
         color_map {
          [0.0 0.1 color rgb <1, 1, 1>
                   color rgb <.8, .8, .8>]
          [0.1 0.5 color rgb <0.8, 0.8, 0.8>
                   color rgb <1, 1, 1>]
          [0.5 1.0 color rgb <0.6, 0.6, 0.6>
                   color rgb <1, 1, 1>]
         }
        scale 300
        } 
       finish{
         ambient .1
         diffuse .9
         reflection 1
         reflection_exponent .5
       }
       translate <xmoon, ymoon, zmoon>
      }
          
#declare city= union { triangle {<-1, 1, 0>, <1, -1, 0>, <-1, -1, 0>}
                       triangle {<-1, 1, 0>, <1, -1, 0>, < 1,  1, 0>}
                     }
                       
object {city
        pigment{image_map{ gif "city.gif" once transmit all .15}} 
        scale <1280,960,1>
        translate <-700,-400,400>
       }
               