#init_spline {
  "cam_pos_x",
  #declare a=0;
  #while (a<dimension_size(camera_location,1))
    <camera_location[a].t,camera_location[a].x>
    #declare a=a+1;
  #end
  }

#init_spline {
  "cam_pos_y",
  #declare a=0;
  #while (a<dimension_size(camera_location,1))
    <camera_location[a].t,camera_location[a].y>
    #declare a=a+1;
  #end
  }

#init_spline {
  "cam_pos_z",
  #declare a=0;
  #while (a<dimension_size(camera_location,1))
    <camera_location[a].t,camera_location[a].z>
    #declare a=a+1;
  #end
  }
  
#init_spline {
  "cam_look_x",
  #declare a=0;
  #while (a<dimension_size(camera_lookat,1))
    <camera_lookat[a].t,camera_lookat[a].x>
    #declare a=a+1;
  #end
  }

#init_spline {
  "cam_look_y",
  #declare a=0;
  #while (a<dimension_size(camera_lookat,1))
    <camera_lookat[a].t,camera_lookat[a].y>
    #declare a=a+1;
  #end
  }

#init_spline {
  "cam_look_z",
  #declare a=0;
  #while (a<dimension_size(camera_lookat,1))
    <camera_lookat[a].t,camera_lookat[a].z>
    #declare a=a+1;
  #end
  }

#init_spline {
  "cam_angle",
  #declare a=0;
  #while (a<dimension_size(camera_angle,1))
    <camera_angle[a].y,camera_angle[a].x>
    #declare a=a+1;
  #end
  }            

#macro eval_camera_location(time)
  #declare cam_location=<eval_spline("cam_pos_x",time),eval_spline("cam_pos_y",time),eval_spline("cam_pos_z",time)>;
  cam_location
#end

#macro eval_camera_lookat(time)
  #declare cam_lookat=<eval_spline("cam_look_x",time),eval_spline("cam_look_y",time),eval_spline("cam_look_z",time)>;
  cam_lookat
#end

#macro eval_camera_angle(time)
  #declare cam_angle=eval_spline("cam_angle",time);
  cam_angle
#end

#macro display_motion_path(sphere_size,init_clock,fin_clock,clock_step,display_lookat,highlight)
  #declare splineclock = init_clock;
  #while (splineclock <= fin_clock)
    #declare progress = (splineclock-init_clock)/(fin_clock-init_clock);
    #declare pos = eval_camera_location(splineclock);
    sphere {
      pos,sphere_size
      pigment { color rgb <1,progress,progress> }
      finish { ambient 1 diffuse 0 }
      }
    #if (display_lookat)
      #declare lookat = eval_camera_lookat(splineclock);
      cylinder {
        pos, lookat, sphere_size/3
        pigment { color rgb <1,progress,progress> }
        finish { ambient 1 diffuse 0 }
        }
      #end  
    #declare splineclock = splineclock + clock_step;
    sphere { 
      #declare pos = eval_camera_location(highlight);
      pos,sphere_size*3
      pigment { color rgb <0,0,1> }
      finish { ambient 1 diffuse 0 }
      }
    #if (display_lookat)
      #declare lookat = eval_camera_lookat(highlight);
      cylinder {
        pos, lookat, sphere_size
        pigment { color rgb <0,0,1> }
        finish { ambient 1 diffuse 0 }
        }
      #end   
    #end
  #end
  
  
