#include "ConversionUnits.inc"
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

// Parameters
#ifndef (hand)
  #declare doLeftHand = true;
#else
  #if (hand = 0)  
    #declare doLeftHand = true;
  #else
    #declare doLeftHand = false;
  #end
#end

#ifndef (Finger1Angle1)      
  #declare Finger1Angle1 = 10;
#end
#ifndef (Finger1Angle2)  
  #declare Finger1Angle2 = 10;
#end  
#ifndef (Finger1Angle3)
  #declare Finger1Angle3 = 10;
#end  

#ifndef (Finger2Angle1)      
  #declare Finger2Angle1 = 15;
#end
#ifndef (Finger2Angle2)  
  #declare Finger2Angle2 = 15;
#end  
#ifndef (Finger2Angle3)
  #declare Finger2Angle3 = 15;
#end  

#ifndef (Finger3Angle1)      
  #declare Finger3Angle1 = 20;
#end
#ifndef (Finger3Angle2)  
  #declare Finger3Angle2 = 20;
#end  
#ifndef (Finger3Angle3)
  #declare Finger3Angle3 = 20;
#end  

#ifndef (Finger4Angle1)      
  #declare Finger4Angle1 = 30;
#end
#ifndef (Finger4Angle2)  
  #declare Finger4Angle2 = 30;
#end  
#ifndef (Finger4Angle3)
  #declare Finger4Angle3 = 30;
#end  

#ifndef (ThumbAngle1)      
  #declare ThumbAngle1 = 30;
#end
#ifndef (ThumbAngle2)  
  #declare ThumbAngle2 = 30;
#end                 
#ifndef (ThumbJoint2TransverseAngle)
  #define ThumbJoint2TransverseAngle = 0;
#end  
#ifndef (ThumbAngle3)
  #declare ThumbAngle3 = 30;
#end  

#ifndef (WristAngle)
  #declare WristAngle = 15;
#end
  
#if (doLeftHand)
  #declare multFactor = 1;
#else
  #declare multFactor = -1;
#end

#ifndef (SkinTexture)
  #declare SkinTexture =
      texture {
        pigment {
          //color rgb <0.5, 0.25, 0.125>
          color rgb <0.8, 0.5, 0.25>
        } 
        finish { ambient 0.2 }
        normal {
          bumps 0.1
          scale 0.1
        }
      }
#end

#ifndef (NailTexture)
  #declare NailTexture = 
      texture {
        SkinTexture
        finish { phong 1 }
        //normal { }
      }
#end              

#macro multVect( pVector )
  <multFactor*pVector.x, pVector.y, pVector.z>
#end
        

// the Base knuckle
#declare startLoc = <0, 0, 0>;
#declare currAngle = <0, 0, 0>;

#macro DrawFingerTip( pLength, pRadius )
  difference {
    union {
      cylinder {
        <0, 0, 0>
        <0, pLength, 0>
        pRadius
      }
      sphere {
        <0, pLength, 0>
        pRadius
      }
      sphere {
        <0, 0, 0>
        pRadius
      }      
    }  
    // remove the nail cutout
    difference {
      union {
        sphere { <0, 0, 0> pRadius-1*mm }
        cylinder { <0, 0, 0> <0, 1, 0> pRadius-1*mm }
        scale <1, 1, 0.2>
        translate <0, pLength, pRadius>
      }
      cylinder { <0, 0, 0> <0, 1, 0> pRadius - 1*mm }    
      texture { NailTexture }
    }
        
    texture {SkinTexture}
  }
#end


#macro DrawFinger( pFirstJointAngle, pSecondJointAngle, pThirdJointAngle, pLength, pRadius )
union {
  union {
    // Fingertip
    object {
      DrawFingerTip( 0.8*pLength, pRadius )
      rotate pThirdJointAngle * -x
      translate pLength*y
    }
    cone {
      <0, pLength, 0>
      pRadius
      <0, 0, 0>
      (pRadius + 1*mm)
    }
    sphere {
      <0, 0, 0>
      (pRadius + 1*mm)
    }   
    texture {SkinTexture}
    rotate pSecondJointAngle * -x 
    translate pLength*y
  }  
  cylinder {
    <0, 0*cm, 0>
    <0, pLength, 0>
    (pRadius + 1*mm)
  }
  // First joint
  sphere {
    <0, 0, 0>
    (pRadius + 1*mm)
  }
  #ifdef (__ring)
    object { __ring }
  #end
  texture {SkinTexture}
  rotate pFirstJointAngle * -x
  translate 0*y
}
#end

#declare aHand = 
    union {
      union {
        #declare loc1 = <-2*cm, -2*mm, -5*mm>;
        #declare loc2 = <0, 0, 0>;
        #declare loc3 = <2*cm, -1*mm, -3*mm>;
        #declare loc4 = <4*cm, -8*mm, -8*mm>;
        

        #ifdef (Finger1Ring)
          #declare __ring = Finger1Ring;
        #end                      
        object { DrawFinger( Finger1Angle1, Finger1Angle2, Finger1Angle3, 2.35*cm, 8*mm ) rotate multFactor*5*z translate multVect( loc1 ) }              
        #ifdef (__ring)
          #undef __ring
        #end  
        
        #ifdef (Finger2Ring)
          #declare __ring = Finger2Ring;
        #end                      
        object { DrawFinger( Finger2Angle1, Finger2Angle2, Finger2Angle3, 2.5*cm, 8*mm ) translate multVect( loc2 ) }              
        #ifdef (__ring)
          #undef __ring    
        #end
                  
        #ifdef (Finger3Ring)
          #declare __ring = Finger3Ring;
        #end                      
        object { DrawFinger( Finger3Angle1, Finger3Angle2, Finger3Angle3, 2.35*cm, 8*mm ) rotate -5*multFactor*z translate multVect( loc3 ) }
        #ifdef (__ring)
          #undef __ring   
        #end  
                   
        #ifdef (Finger4Ring)
          #declare __ring = Finger4Ring;
        #end                      
        object { DrawFinger( Finger4Angle1, Finger4Angle2, Finger4Angle3, 2.1*cm, 7*mm ) rotate -10*multFactor*z translate multVect( loc4 ) }              
        #ifdef (__ring)
          #undef __ring
        #end  
        
        #declare ThumbJoint1Angle = ThumbAngle1;   // 0 => flat to hand, 90=> Sticking out from hand
        #declare ThumbJoint2Angle = ThumbAngle2; 
        #declare ThumbJoint3Angle = ThumbAngle3; 
        
        blob {
          threshold 0.2
          //sphere { <-2*cm, -2*mm, 0>, 8*mm, 2 }
          #declare anOffset = 8*mm*y;
          cylinder { multVect(loc1-anOffset), multVect( loc2-anOffset ), 1*cm, 2}
          cylinder { multVect(loc2-anOffset), multVect( loc3-anOffset ), 1*cm, 2}
          cylinder { multVect(loc3-anOffset), multVect( loc4-anOffset ), 1*cm, 2} 
                                      
          #declare counter = 13;
          #declare counter1 = 1;
          #while (counter < 70 )                              
            #declare anOffset = counter*mm*y;
            #if (counter1/10 + 1 > 2.3)
              #declare aSize = 2.3;
            #else
              #declare aSize = counter1/10 + 1;
            #end
            #if (counter1 > 3)
              #declare inwardsOffset = 3 + 3*(counter1-3);
            #else
              #declare inwardsOffset = counter1;
            #end         
            cylinder { multVect( loc1-anOffset+inwardsOffset*mm*x ), multVect( loc2-anOffset ), aSize*cm, 2}
            cylinder { multVect( loc2-anOffset ), multVect( loc3-anOffset ), aSize*cm, 2}
            cylinder { multVect( loc3-anOffset ), multVect( loc4-anOffset ), aSize*cm, 2} 
            #declare counter = counter + 7;
            #declare counter1 = counter1 + 1;
          #end
          cylinder { <multFactor*10*mm, -72*mm, -5*mm>, <multFactor*26*mm, -72*mm, -5*mm>, 2.3*cm, 2 } 
          cylinder { <multFactor*18*mm, -82*mm, -5*mm>, <multFactor*26*mm, -82*mm, -5*mm>, 2.5*cm, 2 } 
          cylinder { <multFactor*20*mm, -92*mm, -5*mm>, <multFactor*28*mm, -92*mm, -5*mm>, 2.7*cm, 2 } 
          cylinder { <multFactor*15*mm, -102*mm, -5*mm>, <multFactor*30*mm, -102*mm, -5*mm>, 2.9*cm, 2 } 
        
          // Draw the thumb. Now the thumb has a pivot point about in line with the 
          // longest finger, and about the same distance back from it.
          #declare ThumbOffsetPoint = multVect( loc2 - 7.3*cm*y);
          cylinder { <0, 0, 0> <0, 4.5*cm, 0> 1.7*cm 2 rotate multFactor*45*z rotate -y*multFactor*ThumbJoint1Angle translate ThumbOffsetPoint }
          
          // Create the webbing that goes between the thumb and the next finger
          
          //cylinder { <-2*cm, -25*mm, 0>, <1*cm, -25*mm, 0>, 1.4*cm, 2}
          //cylinder { <1*cm, -25*mm, 0>, <4*cm, -33*mm, -5*mm>, 1.4*cm, 2}
          texture {SkinTexture}
        }
          
        // Create the actual thumb
        union { 
          object {
            DrawFingerTip( 3*cm, 11*mm )
            rotate -x*ThumbJoint3Angle
            translate 2.4*cm*y
          }
          cone { <0, 0, 0> 14*mm <0, 2.4*cm, 0> 11*mm }
          sphere { <0, 0, 0> 11*mm }
          rotate ThumbJoint2Angle * -x 
          rotate ThumbJoint2TransverseAngle * z
          texture { SkinTexture }
          rotate multFactor*30*-y
          
          // Now move this point to the end of the thumb
          translate <0, 4.5*cm, 0>
          rotate multFactor*45*z
          rotate -y *multFactor* ThumbJoint1Angle
          translate ThumbOffsetPoint
        }  
        translate 102*mm*y
        rotate WristAngle*-x
        translate -102*mm*y
      }
      // and the arm
      cone { <multFactor*2*cm, -25*cm, -5*mm> 4*cm <multFactor*2*cm, -10*cm, -5*mm> 2.75*cm scale <1, 1, 0.909> texture { SkinTexture}  }
    }
    
object { aHand }
   