// This file will control the scenes and act as the storyboard

#declare ActualFPS=25;
#declare NumberOfFrames = final_frame - initial_frame + 1;
#declare TotalTime = NumberOfFrames / ActualFPS;
#debug concat( "Total animation time = ", str( TotalTime, 4, 4), " seconds.\n" )
#declare time = clock * TotalTime;

#macro IsTime( startTime, endTime )
  ((startTime <= time) & (time <= endTime))
#end

#macro ComputeClock(startTime, endTime)             
  // At clock = startTime/ActualFPS, vClock = 0
  // At clock = endTime/ActualFPS, vCLock = 1
  // Thus   (y = mx + b) => (y = (y2-y1)/(x2-x1)x + y1)
  //        => vClock = ((1-0)/((endTIme/ActualFPS) - (startTime/ActualFPS)))(clock) + startTime/ActualFPS
  //        => vCLock = (1/ ((endTime-startTime)/ActualFPS)) * clock + startTime/ActualFPS
  //        => vCLock = clock * ActualFPS / (endTime - startTime) + startTime / ActualFPS
  #declare vClock = clock - (startTime / ActualFPS) (endTime - startTime) / ActualFPS;   
#end

#if IsTIme(0, 5)
  #debug( "Peaceful scene...." ); 
  ComputeClock(0, 5)
#end                             

/*#if IsTIme( 5, 10)
  #debug
*/  