#include "metals.inc"
#include "glass.inc"
#include "colors.inc"
//#include "hanger.pov"

/*global_settings {ambient_light rgb<1, 1, 1>}

camera {
  location <000,5000,3500>
  sky <0,0,50>
  look_at <0,0,0>
  //orthographic
}*/

/*camera {
  location <000,6000,1000>
  sky <0,0,50>
  look_at <0,0,1000>
  orthographic
}*/


/*light_source{<-7000,5000,7000> rgb<1.5,1.5,1.5>}

plane{
  <0,0,1>,-1500
  pigment{rgb<0.5,0,0>}
}*/

#declare hullmetal = 
  texture{
    pigment{rgbf<0.9,0.9,0.9,0.0>}  
    finish{ambient 0.5}
  }
#declare hullmetal =
  texture{
    T_Chrome_2C
  }

#declare latticetex = texture{finish{reflection 1}}
#declare blueglowtex = texture{
      pigment{rgb<0.7,0.7,2>}
      finish{
        ambient rgb<1,1,1> 
      }
    }  
  
#declare enginetex = texture{
	    gradient x
	    texture_map{
	    	[0 latticetex]
	    	[0.1 latticetex]
	    	[0.3 
	    		gradient y
	    		texture_map{
			    	[0 latticetex]
	    			[0.1 latticetex]
	    			[0.3 blueglowtex]
	    		}	
	    		triangle_wave
	    	]
	    }	
	    triangle_wave
	    scale 100
    }

#declare bluenesstex=texture{
		pigment{
			crackle scale 0.1
			color_map{
				[0 rgb<0,0,1>]
				[1 rgb<0,1,0>]
			}
		}	
		finish{ambient 1}
	}


#declare cannon = union{
		box{
			<100,50,50>
			<-100,-50,-200>
			texture{hullmetal}
		}
	  difference{
	  	cylinder{
	  		<0,0,0>
	  		<500,0,0>
	  		30
	  	}
	  	cylinder{
	  		<0,0,0>
	  		<550,0,0>
	  		20
	  	}
	  	texture{T_Chrome_3E}
	  }
	  scale 2
	} 
	  	
	  		

#macro ship2(forwardthrust,rearthrust, leftthrust, rightthrust)
union{
	//#declare rearthrust=0;
	//#declare forwardthrust=1;
/* Wings */  
difference{
  sphere{
    <0,0,0>,1
    texture {hullmetal}
    scale <1500,3000,375>
    rotate y*-30
  }
  cylinder{
    <0,0,4000>
    <0,0,-4000>
    1
    scale<500,2750,1>
    texture{hullmetal}
  }
  
  //Main Thrusters
  difference{
  intersection{
  cylinder{
    <0,0,4000>
    <0,0,-4000>
    1
    scale<520,2770,1>
    texture{enginetex rotate y*90}
  }
  sphere{
    <0,0,0>,1
    texture {hullmetal}
    scale <1500,3000,300>
    rotate y*-30
  }	
  }
  box{
  	<3000,600,2000>
  	<-3000,-600,-2000>
  	texture{hullmetal}
  }	
  }
  
  //Vertical Thrusters
  intersection{
    difference{ 
      difference{
        cylinder{
          <0,0,-3000>
          <0,0,3000>
          1
          texture{hullmetal}
          scale <1300,2700,1>
        }
        cylinder{
          <0,0,-3000>
          <0,0,3000>
          1
          texture{hullmetal}
          scale <700,3000,1>
        }
        cylinder{
          <0,0,-3000>
          <0,0,3000>
          1
          texture{hullmetal}
          scale <2000,600,1>
        }
      }
      sphere{
        <0,0,0>,1
        scale <1480,2980,325>
        rotate y*-30
        texture{enginetex}
      }
    }
    box{          
      <0,-3000,0>
      <3000,3000,-3000>
      rotate y*-30
    }  
  }           
}

/* Front Thrust */
#if (!(forwardthrust=0)) 
difference{
	intersection{
		cylinder{
			<511,0,-10000>
			<-1500,0,-10000>
			10500
			rotate y*-8
		}
		cylinder{
			<510,0,20000>
			<-1500.1,0,20000>
			20000
			rotate y*8
		}
	}
	box{
  	<3000,600,2000>
  	<-3000,-600,-2000>
  }
	pigment{rgbt<0,0,0,1>}
	hollow
	interior{
		media{
			emission rgb<0.5,0.5,1>*0.002*forwardthrust
		}
	}
}
#end

/* Rear Thrust */
#if (!(rearthrust=0)) 
difference{
	intersection{
		cylinder{
			<511,0,-10000>
			<-1500,0,-10000>
			10500
			rotate y*-8
		}
		cylinder{
			<510,0,20000>
			<-1500.1,0,20000>
			20000
			rotate y*8
		}
	}
	box{
  	<3000,600,2000>
  	<-3000,-600,-2000>
	}
	scale <-1,1,-1>
	pigment{rgbt<0,0,0,1>}
	hollow
	interior{
		media{
			emission rgb<0.5,0.5,1>*0.002*rearthrust
		}
	}
}
#end

/*Up Thrust Left*/
#if (!(leftthrust=0)) 
intersection{
  difference{ 
    difference{
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <1300,2700,1>
        rotate y*10
      }
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <700,3000,1>
        rotate y*-10
      }
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <2000,600,1>
      }
    }
    sphere{
      <0,0,0>,1
      scale <1480,2980,325>
      rotate y*-30
    }
  }
  box{          
    <0,-3000,0>
    <3000,3000,-3000>
    rotate y*-30
  }
  plane{-y,0}
  pigment{rgbt<0,0,0,1>}
	hollow
	interior{
		media{
			emission rgb<0.5,0.5,1>*0.002*leftthrust
		}
	}
}			
#end

/*Up Thrust Right*/
#if (!(rightthrust=0)) 
intersection{
  difference{ 
    difference{
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <1300,2700,1>
        rotate y*10
      }
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <700,3000,1>
        rotate y*-10
      }
      cylinder{
        <0,0,-3000>
        <0,0,3000>
        1
        scale <2000,600,1>
      }
    }
    sphere{
      <0,0,0>,1
      scale <1480,2980,325>
      rotate y*-30
    }
  }
  box{          
    <0,-3000,0>
    <3000,3000,-3000>
    rotate y*-30
  }
  plane{y,0}
  pigment{rgbt<0,0,0,1>}
	hollow
	interior{
		media{
			emission rgb<0.5,0.5,1>*0.002*rightthrust
		}
	}
}			
#end		


/* Body */
difference{
	union{
  	sphere{
    	<0,0,0>,1
 	    texture {hullmetal}  
 	    scale <3200,500,750>
      translate <1250,0,0>
  	}
  	intersection{
  		intersection{
  			plane{-z,-200}
  			plane{-x,0 rotate y*-30 translate x*1970}
  			inverse
  		}
  		plane{-z,-150}
  		plane{-x,0 rotate y*-30 translate x*1920}
  		sphere{
  			<0,0,0>,1
  			scale <3230,530,780>
      	translate <1250,0,0>  			
      }	
  		texture{hullmetal}
  	}	
  				
  }	
  union{
    /*box{
      <1500,-3000,250>
      <6000,3000,3000>
      texture{hullmetal}
    }*/
    intersection{
    	plane{z,250 inverse}
    	plane{x,0 rotate y*-30 translate x*2000 inverse}
    	texture{hullmetal}
    }
    difference{
	    sphere{
      	<0,0,0>,1
      	texture{hullmetal}
      	scale <3180,480,730>
      	translate <1250,0,0>
    	}
    	difference{
		    plane{
    			z,0
		    }
		    sphere{
		    	0,1
		    	scale <1500,400,300>
		    	translate x*2000
		    }	
    		texture{
	    		finish{ambient 0.2}
    			pigment{rgb<1,1,1>}
    		}			
    	}
    }
    
    //Gun Barrels
    cylinder{
    	<0,300,0>
    	<5000,300,0>
    	100
    	texture{T_Chrome_2A}
    	rotate x*-30
    }
    cylinder{
    	<0,-300,0>
    	<5000,-300,0>
    	100
    	texture{T_Chrome_2A}
    	rotate x*30
    }
    cylinder{
    	<0,300,0>
    	<5000,300,0>
    	100
    	texture{T_Chrome_2A}
    	rotate x*-70
    }
    cylinder{
    	<0,-300,0>
    	<5000,-300,0>
    	100
    	texture{T_Chrome_2A}
    	rotate x*70
    }
  }
}

/* Cockpit */
difference{
  sphere{
    <0,0,0>,1
    scale <3195,495,745>
    translate <1250,0,0>
  }
  sphere{
    <0,0,0>,1
    scale <3185,485,735>
    translate <1250,0,0>
  }
  plane{
  	z,0
  }	
  texture{
    T_Glass4
  }
  interior{
    I_Glass
  }  
}

/* Reactor */
sphere{
	<0,0,0>,1
	scale <1000,400,400>
	rotate y*-20
	translate <-800,0,300>
	texture{
		gradient x
		scale 200
		texture_map{
			[0
				gradient z
				scale 5
				translate z*-300
				texture_map{
					[0 hullmetal]
					[1 bluenesstex]
				}
				triangle_wave
			]			
			[1 hullmetal]
		}
		triangle_wave
	}	
}
object{cannon translate<750,500,1000>}
object{cannon translate<750,-500,1000>}
scale <1,1,0.7>                
translate x*-1250
}
#end


/*object{
	ship2(1,0,1,0)
	//rotate z*90
	//rotate z*90
	rotate z*360*clock
	//translate z*31000
	//translate y*-10000
}*/