#include "devmath.inc"
#include "ship4.pov"
#include "terrain.pov"

#declare ShipPos=z*3000+x*60000+x*60000*clock
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=<0,0,0>;

#switch(clock)
	#range(0,0.5)
		#declare Ship1Rot=-x*30*Smooth(clock*2);
	#break
	#range(0.5,1)
		#declare Ship1Rot=-x*30*Smooth(2-clock*2);
	#break
#end

#declare Ship2Rot=-Ship1Rot;
		

camera{
	location <75000+60000*clock,-6000,13000>
	sky z
	look_at ShipPos
}

union{
	union{
		object{
			sfod
			rotate Ship1Rot
		}
		object{
			sfod                    
			rotate Ship1Rot
			translate <-3000,3000,0>
		}
		object{
			sfod          
			rotate Ship1Rot
			translate <-3000,-3000,0>
		}
		translate y*(6000+3000*Smooth(clock))
	}
	union{
		object{
			sfod          
			rotate Ship2Rot
		}
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,3000,0>
		}
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,-3000,0>
		}
		translate y*(-6000-3000*Smooth(clock))
	}
  translate ShipPos
	//rotate z*180
}

