#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
#include "terrain.pov"

#declare Clock=clock*2/3;

#declare ShipPos=z*3000+x*230000+x*60000*Clock
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=<0,0,0>;   
#declare ShotPos=0
#switch(Clock)
	#range(0.2,1)
		#declare ShotPos=(Clock-0.2)*60000
  #break
#end 


#declare GoodShipRot=<0,0,0>;
#declare GoodShipHeading=<0,0,0>;//It is probably unnecessary to break 
																 //this into two variables, 
																 //but I don't know any matrix math,
																 //so this is simpler.
#declare GoodShipPos=<0,0,0>;
#switch (Clock)
	#range(0,0.3)
		#declare GoodShipPos=<300000,0,3000>-x*50000*Clock;
	#break	
  #range(0.3,0.6)
  	#declare GoodShipPos=<300000,0,3000>-x*50000*Clock
  											 -y*50000*Smooth((Clock-0.3)/0.3/2);
  #break
#end  
#switch(Clock)
	#range(0,0.3)
		#declare GoodShipRot=x*Smooth(Clock/0.3)*90;
		#declare GoodShipHeading=z*Smooth(Clock/0.3)*90;
	#break
	#range(0.3,0.5)
		#declare GoodShipRot=x*(90-155*Smooth((Clock-0.3)/0.2));
		#declare GoodShipHeading=z*(90-45*(Clock-0.3)/0.3);
	#break	
	#range(0.5,0.6)
		#declare GoodShipRot=x*-65;
		#declare GoodShipHeading=z*(90-45*(Clock-0.3)/0.3);
	#break	
#end		

#declare Forward=0;
#declare Right=0;
#declare Left=0;
#switch(Clock)
	#range(0,0.3)
		#declare Right=1;
	#break
	#range(0.3,0.6)
		#declare Left=1;
		#declare Forward=1;
	#break
#end			

camera{
	location <305000,0,9000>
	sky z
	look_at <270000,0,0>
}

#declare Shot=union{
	#if (!(ShotPos=0))
		sphere{
			<0,0,0>,1
			pigment{rgbft <1,0.2,0.2,0.2,0.5>}
			//finish{ambient 1}
			pigment{rgbt 1}
			hollow
			interior{
				media{
					density{spherical}
					emission rgb <1,0.001,0.001>
				}
			}
			scale <1000,200,200>
			translate x*ShotPos
		}
	#end
	}

union{
	union{
		object{
			sfod
			rotate Ship1Rot
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
		}	
			
		object{
			sfod                    
			rotate Ship1Rot
			translate <-3000,3000,0>
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
			translate <-3000,3000,0>
		}
		
		object{
			sfod          
			rotate Ship1Rot
			translate <-3000,-3000,0>
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
			translate <-3000,-3000,0>
		}
		
		translate y*6000
	}
	union{
		object{
			sfod
			rotate Ship2Rot
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
		}	
			
		object{
			sfod                    
			rotate Ship2Rot
			translate <-3000,3000,0>
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
			translate <-3000,3000,0>
		}
		
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,-3000,0>
		}
		union{
			object{
				Shot
				translate <125,380,625>
			}
			object{
				Shot
				translate <125,-380,625>
			}
			translate <-3000,-3000,0>
		}
		translate y*-6000
	}
  translate ShipPos
	//rotate z*180
}

object{
	ship2(Forward,0,Left,Right)
	rotate z*180
	rotate GoodShipRot
	rotate GoodShipHeading
	translate GoodShipPos
}	

