#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
#include "terrain.pov"

#declare Clock=clock;

#declare ShipPos=z*3000+x*290000+x*60000*Clock
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=<0,0,0>;   
#declare ShotPos=0
#switch(Clock)
	#range(0.2,1)
		#declare ShotPos=(Clock-0.2)*60000
  #break
#end 


#declare GoodShipRot=<-45,0,0>;
#declare GoodShipHeading=-<0,0,180>*Clock;//It is probably unnecessary to break 
																 //this into two variables, 
																 //but I don't know any matrix math,
																 //so this is simpler.
#declare GoodShipPos=y*-6000 
											+ vrotate(y*-12000,-z*180*Clock)
											+x*70000*Clock
											+<260000,0,3000>
											
/*#switch (Clock)
	#range(0,0.3)
		#declare GoodShipPos=<300000,0,3000>-x*50000*Clock;
	#break	
  #range(0.3,0.6)
  	#declare GoodShipPos=<300000,0,3000>-x*50000*Clock
  											 -y*50000*Smooth((Clock-0.3)/0.3/2);
  #break
#end  
#switch(Clock)
	#range(0,0.3)
		#declare GoodShipRot=x*Smooth(Clock/0.3)*90;
		#declare GoodShipHeading=z*Smooth(Clock/0.3)*90;
	#break
	#range(0.3,0.5)
		#declare GoodShipRot=x*(90-155*Smooth((Clock-0.3)/0.2));
		#declare GoodShipHeading=z*(90-45*(Clock-0.3)/0.3);
	#break	
	#range(0.5,0.6)
		#declare GoodShipRot=x*-65;
		#declare GoodShipHeading=z*(90-45*(Clock-0.3)/0.3);
	#break	
#end*/


camera{
	location <305000,-10000,15000>+x*60000*clock
	sky z
	look_at ShipPos-x*10000
}

union{
	union{
		object{
			sfod
			rotate Ship1Rot
		}
		
			
		object{
			sfod                    
			rotate Ship1Rot
			translate <-3000,3000,0>
		}
		object{
			sfod          
			rotate Ship1Rot
			translate <-3000,-3000,0>
		}
		translate y*6000
	}
	union{
		object{
			sfod
			rotate Ship2Rot
		}
	
		object{
			sfod                    
			rotate Ship2Rot
			translate <-3000,3000,0>
		}
		
		
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,-3000,0>
		}
		translate y*-6000
	}
  translate ShipPos
	//rotate z*180
}

object{
	ship2(1,0,1,0)
	rotate z*180
	rotate GoodShipRot
	rotate GoodShipHeading
	translate GoodShipPos
}	

