#include "devmath.inc"
#include "ship4.pov"
#include "ship2.pov"
#include "terrain.pov"

#declare Clock=clock;

#declare ShipPos=z*3000+x*410000-y*17000+vrotate(y*17000,-z*270*Clock)
#declare Ship1Rot=<0,0,0>;
#declare Ship2Rot=x*45
#declare ShipHeading=-z*Clock*270;   

#declare GoodShipRot=x*-45;
#declare GoodShipHeading=z*(45+Clock*225);
#declare GoodShipPos=<420000,22000,3000>+vrotate(y*30000,z*45)+vrotate(y*-30000,z*(45+Clock*225));
																 

/*#switch(Clock)
	#range(0,0.4)
		#declare GoodShipPos=GoodShipPos+x*3000*(Clock/0.4)-y*Smooth(Clock/0.4)*4000;
		#declare GoodShipRot=x*(45-90*Smooth(Clock/0.4));
		#declare GoodShipHeading=Smooth(Clock/0.2)*-30*z;
	#break
	#range(0.4,1.01)
		#declare GoodShipPos=GoodShipPos+x*3000-y*4000
													+y*20000+vrotate(y*-20000,z*90*(Clock-0.4)/0.6)*<0.7,1,1>;
		#declare GoodShipRot=x*-45;
		#declare GoodShipHeading=z*90*(Clock-0.4)/0.6;
#end*/

#declare FireTime1=0.4;
#declare FireTime2=0.5;
#declare FireTime3=0.6;

#declare FireDelay=0.1;

camera{
	location <450000,-60000,30000>
	sky z
	look_at <420000,-10000,3000>
}

/*camera{
	location <320000,3000,10000>+x*60000*Clock
	sky z
	look_at ShipPos-x*15000+y*8000
}*/

//Explosion
#macro explosion(size) 
sphere{
	0,20
	pigment{rgbt<0,0,0,1>}
	//finish{ambient 10}
	hollow
	interior{
		media{
			density{
				spherical                
				warp{turbulence 0.5 lambda 1.01}
				scale <10,10,10>
				warp{turbulence 2 octaves 9 lambda 2 omega 0.6}
				//warp{turbulence 4 octaves 0 lambda 0 omega 0}
				rotate x*-45
				//rotate z*clock*360
				translate <0,0,0>
				color_map{
					[0 	 rgb<0,0,0>*0.005]
					[0.1 rgb<0.5,0.2,0>*0.005]
					[0.5 rgb<0.5,0,0.2>*0.005]
					[1   rgb<0.5,0.2,1>*0.005]
				}	
			}
			emission rgb<0.5,0.5,0.5>
		}
	}
	scale 750*size
}
#end


union{
	union{
		union{
		#switch(Clock)
			#range(-1,2)
				object{explosion(1+Clock-FireTime2)}
				rotate <735*(1+Clock-FireTime2),
								234*(1+Clock-FireTime2),
								-464*(1+Clock-FireTime2)>
				translate z*(10000*(1+Clock-FireTime2)
							-20000*pow((1+Clock*2-FireTime2),2))
			#break
		#end
		}		
				
		union{	
		#switch(Clock)
			#range(FireTime3,2)
				object{explosion(1+Clock-FireTime3)}
				rotate <424*(1+Clock-FireTime3),
								-887*(1+Clock-FireTime3),
								-234*(1+Clock-FireTime3)>				
				translate z*(12000*(1+Clock-FireTime3)
							-20000*pow((1+Clock*2-FireTime3),2))
			#break
		#end
		translate <-3000,3000,0>
		}
		
		
		union{
		#switch(Clock)
			#range(FireTime1,2)
				object{explosion(1+Clock-FireTime1)}
				rotate <-654*(1+Clock-FireTime1),
								142*(1+Clock-FireTime1),
								-412*(1+Clock-FireTime1)>				
				translate z*(5000*(1+Clock-FireTime1)
							-20000*pow((1+Clock*2-FireTime1),2))
			#break
		#end
		translate <-3000,-3000,0>
		}
		
		translate z*3000+x*410000
		translate y*6000
		translate x*30000*pow(Clock,0.5)
	}
}

union{	
	union{
		object{
			sfod
			rotate Ship2Rot
		}
	
		object{
			sfod                    
			rotate Ship2Rot
			translate <-3000,3000,0>
		}
		
		
		object{
			sfod          
			rotate Ship2Rot
			translate <-3000,-3000,0>
		}                
		rotate ShipHeading
		translate y*-6000
	}
  translate ShipPos
	//rotate z*180
}

object{
	ship2(1,0,0,1)
	rotate GoodShipRot
	rotate GoodShipHeading
	translate GoodShipPos
}	

