// Phase 1 - Walk down the entryway - 3 seconds

#include "colors.inc"
//#declare Draft = version;
#include "e:\pc'sjunk\pov\adventure\dungeon.inc"
#include "e:\pc'sjunk\pov\adventure\staff.inc"
#include "e:\pc'sjunk\pov\adventure\light.inc"

background { colour rgb <1, 1, 1> }

// No identifier means it applies to the camera and light_source translations.
// CL designates camera look_at.
// L  designates light_source translation.
// C  designates camera translation.
// S  designates staff
#declare P1_Motion = <0, 0, 60>*clock;
#declare P1_Rotate_S = <2*abs(sin(3*pi*clock)), 0, 0>;
#declare P1_Motion_S = P1_Motion + <0, 0.5*abs(sin(3*pi*clock)), 0>;

camera {
	location <0, 15, -25>
	look_at <0, 15, -24>
	translate P1_Motion
}

light_source {
	<-1, 16, -22>
	colour White
	fade_distance 25
	fade_power 1.5
	translate P1_Motion
}

#declare Light_markers = union {
	// y-axis
	sphere { <-1, 16.2, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	sphere { <-1, 15.8, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	// x-axis
	sphere { <-1.2, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	sphere { <-0.8, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	// z-axis
	sphere { <-1, 16, -22.2>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.6> }
	}
	sphere { <-1, 16, -21.8>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.9> }
	}
	translate P1_Motion
}
//object { Light_markers }

#declare first_1o2_clock = 2*min(0.5, clock);
#declare delay_1o2_clock = 2*( max(0.5, clock) - 0.5 );
object { Light_Sphere
	rotate < 68.96/2.689*pow(first_1o2_clock, 2.689) + 68.96*delay_1o2_clock - 68.96/1.771*pow(delay_1o2_clock, 1.771),
		79.20/2.890*pow(first_1o2_clock, 2.890) + 79.20*delay_1o2_clock - 79.20/1.238*pow(delay_1o2_clock, 1.238),
		23.04/2.478*pow(first_1o2_clock, 2.478) + 23.04*delay_1o2_clock - 23.04/1.485*pow(delay_1o2_clock, 1.485) >
	translate <-1, 16, -22>
	translate P1_Motion
}

object { Staff
	rotate P1_Rotate_S
	translate <1.5, 0, -21>
	translate P1_Motion_S
}

object { Dungeon }