#include "colors.inc"
#include "stones.inc"
#include "metals.inc"
#include "e:\pc'sjunk\pov\adventure\bracket.inc"

#declare Concrete = texture {
   pigment {
      agate
      turbulence 2.0
      colour_map {
         [0.00 colour rgb <0.35, 0.35, 0.35> ]
         [0.10 colour rgb <0.35, 0.35, 0.35> ]
         [0.20 colour rgb <0.50, 0.50, 0.50> ]
         [0.60 colour rgb <0.50, 0.50, 0.50> ]
         [0.70 colour rgb <0.65, 0.65, 0.65> ]
         [0.75 colour rgb <0.65, 0.65, 0.65> ]
         [0.80 colour rgb <0.50, 0.50, 0.50> ]
         [1.00 colour rgb <0.50, 0.50, 0.50> ]
      }
   }
   normal {
      granite
      turbulence 2.0
   }
   scale 1.0
   finish { 
      reflection 0.0
      diffuse 1.0
   }
}

// Stone texture for border, derivative of T_Stone28
#declare PC_T_Stone28 =	texture {
	pigment {
		agate
		agate_turb 0.75
		frequency 6
		scale 1.75
		rotate <0, -45, 5>
		color_map { 
			[0.02 color rgbf <0.65, 0.45, 0.25, 0.0> ]
			[0.06 color rgbf <0.55, 0.40, 0.20, 0.0> ]
			[0.08 color rgbf <0.30, 0.20, 0.10, 0.0> ]
			[0.10 color rgbf <0.55, 0.40, 0.20, 0.0> ]
			[1.00 color rgbf <0.75, 0.60, 0.40, 0.0> ]
		}
	}
	normal {
		crackle 50.0
		turbulence 0.1
		lambda 2.5
		omega 0.75
		octaves 5
		scale 2.5
		frequency 1
		phase 0.25
		rotate <0, 45, 60>
	}		
}
texture {
	pigment {
		crackle
		turbulence 0.1
		lambda 2.5
		omega 0.75
		octaves 5
		scale 2.5
		frequency 1
		phase 0.25
		rotate <0, 45, 60>
		color_map { 
			[0.00 color Clear ]
			[0.25 color rgbf <0.40, 0.25, 0.15, 0.50> ]
			[0.30 color rgbf <0.00, 0.00, 0.00, 0.00> ]
			[0.35 color rgbf <0.40, 0.25, 0.15, 0.50> ]
			[0.40 color rgbf <0.45, 0.55, 0.35, 0.60> ]
			[0.65 color Clear ]
		}
	}
}

#declare Decoration = union {
	torus { 1.5, 0.15
		rotate x*90
		translate <0, 5.25, -4>
		texture { T_Stone13 }
	}
	#declare i = 0;
	#while ( i < 5 )
		union {
			cylinder { <0, 0, -4>, <0, 0.65, -4>, 0.15 }
			intersection {
				torus { 0.5, 0.15
					rotate x*90
					translate <0.5, 0.65, -4>
				}
				box { <-0.15, 0.65, -4>, <0.5, 1.3, -4.15> }
			}
			sphere { <0.5, 1.15, -4>, 0.15 }
			texture { T_Stone13 }
			rotate z*72*i
			translate <0, 5.25, 0>
		}
		#declare i = i + 1;
	#end
}

#declare Decoration_G = union {
	torus { 1.5, 0.15
		rotate x*90
		translate <0, 5.25, -4>
		texture { T_Gold_2B }
	}
	#declare i = 0;
	#while ( i < 5 )
		union {
			cylinder { <0, 0, -4>, <0, 0.65, -4>, 0.15 }
			intersection {
				torus { 0.5, 0.15
					rotate x*90
					translate <0.5, 0.65, -4>
				}
				box { <-0.15, 0.65, -4>, <0.5, 1.3, -4.15> }
			}
			sphere { <0.5, 1.15, -4>, 0.15 }
			texture { T_Gold_3B }
			rotate z*72*i
			translate <0, 5.25, 0>
		}
		#declare i = i + 1;
	#end
}

#declare Dungeon = union {
	// floor and roof, main level
	difference {
		union {
			plane { y, 0 }		// floor
			plane { -y, -30 } // roof
		}
		plane { -z, -60 }		// cut far
		plane { z, -30 }		// cut rear
		#ifndef ( Draft )
			texture { Concrete }
		#end
	}
	// walls main level
	box { <-16, 0, -30>, <-15, 30, 30> }	// entry left
	box { <15, 0, -30>, <16, 30, 30> }		// entry right
	Bracket ( <0, 90, 0>, <15, 17.5, -7.5> )
	box { <-30, 0, 60>, <75, 30, 61> }		// centre front
	Bracket ( <0, 0, 0>, <22.5, 17.5, 60> )
	box { <-61, 0, 30>, <-60, 30, 60> }		// left
	Bracket ( <0, -90, 0>, <-60, 17.5, 52.5> )
	box { <-60, 0, 29>, <-15, 30, 30> }		// left back
	Bracket ( <0, 180, 0>, <-22.5, 17.5, 30> )
	box { <15, 0, 29>, <105, 30, 30> }		// right back
	Bracket ( <0, 180, 0>, <67.5, 17.5, 30> )
	box { <105, 0, 30>, <106, 30, 60> }		// right
	Bracket ( <0, 90, 0>, <105, 17.5, 52.5> )
	// floor and roof, sloped
	difference {
		union {
			// floor
			plane { y, 0
				rotate x*10
				translate <0, 0, 60>
			}
			// roof
			difference {
				plane { -y, 0
					rotate x*10
					translate <0, 30, 60>
				}
				box { <-60, 29 - 70*tan(10*pi/180), 129.5>, <-30, 50 - 70*tan(10*pi/180), 130.5> }
			}
		}
		plane { -z, -135 }	// cut far
		plane { z, 60 }		// cut rear
		#ifndef ( Draft )
			texture { Concrete }
		#end
	}
	// walls sloped
	box { <-61, -75*tan(10*pi/180), 60>, <-60, 30, 135> }	// left
	box { <-30, -75*tan(10*pi/180), 60>, <-29, 30, 135> }	// right
	Bracket ( <0, 90, 0>, <-30, 17.5 - 75/2*tan(10*pi/180), 97.5> )
	box { <74, -75*tan(10*pi/180), 60>, <75, 30, 135> }	// far left
	box { <105, -75*tan(10*pi/180), 60>, <106, 30, 135> }	// far right
	// floor and roof, bottom level
	difference {
		union {
			plane { y, -75*tan(10*pi/180) }			// floor
			difference {
				plane { -y, -30 + 75*tan(10*pi/180) }	// roof
				box { <-47.5, 29 - 75*tan(10*pi/180), 162.5>, <-42.5, 32.5 - 75*tan(10*pi/180), 167.5>
					texture { T_Stone15 }
				}
				object { Decoration
					translate <0, -5.25, 4>
					rotate -x*90
					translate <-45, 32.5 - 75*tan(10*pi/180), 165>
				}
			}
		}
		plane { -z, -210 }	// cut far
		plane { z, 135 }		// cut rear
		#ifndef ( Draft )
			texture { Concrete }
		#end
	}
	#ifdef ( Open_SC )
		// "slime chamber" glow
		merge {
			torus { 1.5, 0.15
				rotate x*90
				translate <0, 5.25, -4>
			}  
			#declare i = 0;
			#while ( i < 5 )
				merge {
					cylinder { <0, 0, -4>, <0, 0.65, -4>, 0.15 }
					intersection {
						torus { 0.5, 0.15
							rotate x*90
							translate <0.5, 0.65, -4>
						}
						box { <-0.15, 0.6499, -4>, <0.5, 1.3, -4.15> }
					}
					sphere { <0.5, 1.15, -4>, 0.15 }
					pigment { colour rgbt <1, 1, 1, 1> }
					hollow
					rotate z*72*i
					translate <0, 5.25, 0>
				}
				#declare i = i + 1;
			#end
			pigment { colour rgbt <1, 1, 1, 1> }
			hollow
			interior {
				media {
					emission 1
					intervals 20
					density {
						agate
						phase clock
						colour_map {
							[ 0.00 colour rgb <0, 0, 0> ]
							[ 0.20 colour rgb <1, 0.2, 0.2>*2 ]
							[ 0.75 colour rgb <1, 0.3, 0.3>*3 ]
							[ 0.90 colour rgb <1, 0.5, 0.5>*3 ]
							[ 1.00 colour rgb <1, 0.8, 0.8>*3 ]
						}
						scale 0.01
					}
				}
			}
			translate <0, -5.25, 4>
			rotate -x*90
			translate <-45, 32.5 - 75*tan(10*pi/180), 165>
		}
		light_source {
			<-45, 31.5 - 75*tan(10*pi/180), 165>
			colour rgb <1, 0, 0>
			fade_power 2
			fade_distance 1.401 + 1.4
		}
	#else
		box { <-47.5, 30 - 75*tan(10*pi/180), 162.5>, <-42.5, 32.5 - 75*tan(10*pi/180), 167.5>
			texture { T_Stone15 }
		}
		object { Decoration_G
			translate <0, -5.25, 4>
			rotate -x*90
			translate <-45, 30 - 75*tan(10*pi/180), 165>
		}
	#end
	// walls room
	box { <-60, -75*tan(10*pi/180), 210>, <-30, 30-75*tan(10*pi/180), 211> }	// centre front
	box { <-15*sqrt(2), 0, 0>, <0, 30, 1>													// far left slanted
		rotate y*-45
		translate <-60, -75*tan(10*pi/180), 210>
	}
	box { <0, 0, 0>, <15*sqrt(2), 30, 1>													// far right slanted
		rotate y*45
		translate <-30, -75*tan(10*pi/180), 210>
	}
	box { <-76, -75*tan(10*pi/180), 180>, <-75, 30-75*tan(10*pi/180), 195> }	// far left
	Bracket ( <0, -90, 0>, <-75, 17.5 - 75*tan(10*pi/180), 187.5> )
	box { <-15, -75*tan(10*pi/180), 180>, <-14, 30-75*tan(10*pi/180), 195> }	// far right
	Bracket ( <0, 90, 0>, <-15, 17.5 - 75*tan(10*pi/180), 187.5> )
	box { <-15*sqrt(2), 0, 0>, <0, 30, 1>													// left slanted
		rotate y*-45
		translate <-75, -75*tan(10*pi/180), 180>
	}
	box { <0, 0, 0>, <15*sqrt(2), 30, 1>													// right slanted
		rotate y*45
		translate <-15, -75*tan(10*pi/180), 180>
	}
	box { <-91, -75*tan(10*pi/180), 150>, <-90, 30-75*tan(10*pi/180), 165> }	// left
	difference {
		box { <-90, 13 - 75*tan(10*pi/180), 155.5>, <-89, 17 - 75*tan(10*pi/180), 159.5>
			texture { T_Stone15 }
		}
		object { Decoration
			translate <0, -5.25, 4>
			rotate y*-90
			translate <-89, 15 - 75*tan(10*pi/180), 157.5>
		}
	}
	box { <0, -75*tan(10*pi/180), 150>, <1, 30-75*tan(10*pi/180), 165> }			// right
	difference {
		box { <-1, 13 - 75*tan(10*pi/180), 155.5>, <0, 17 - 75*tan(10*pi/180), 159.5>
			texture { T_Stone15 }
		}
		object { Decoration
			translate <0, -5.25, 4>
			rotate y*90
			translate <-1, 15 - 75*tan(10*pi/180), 157.5>
		}
	}
	box { <0, 0, 0>, <15*sqrt(5), 30, -1>													// left back
		rotate y*atan2(1, 2)*180/pi
		translate <-90, -75*tan(10*pi/180), 150>
	}
	Bracket ( <0, atan2(1, 2)*180/pi, 0>, <-75, 17.5 - 75*tan(10*pi/180), 142.5> )
	box { <-15*sqrt(5), 0, 0>, <0, 30, -1>													// right back
		rotate y*-atan2(1, 2)*180/pi
		translate <0, -75*tan(10*pi/180), 150>
	}
	Bracket ( <0, 180-atan2(1, 2)*180/pi, 0>, <-15, 17.5 - 75*tan(10*pi/180), 142.5> )
	// altar base
	union {
		box { <-75, -75*tan(10*pi/180), 180>, <-15, 3 - 75*tan(10*pi/180), 210> }
		box { <-90, -75*tan(10*pi/180), 176>, <0, 1.5 - 75*tan(10*pi/180), 180> }
		texture { T_Stone6
			scale 2
		}
	}
	// altar
	union {
		difference {
			box { <-8, 0, -4>, <8, 7.5, 4> }
			object { Decoration }
		}
		box { <-9, 7.5, -5>, <9, 8.5, 5> }
		torus { 3.0, 0.1
			translate <0, 8.5, 0>
			texture { T_Gold_3B }
		}
		torus { 3.75, 0.1
			translate <0, 8.5, 0>
			texture { T_Gold_3B }
		}
		texture { T_Stone15
			scale 2
		}
		translate <-45, -75*tan(10*pi/180), 200>
	}
	#ifndef ( Draft )
		texture { PC_T_Stone28 }
	#else
		pigment { colour rgb <0.65, 0.5, 0.3> }
	#end
	//test bar
/*	cylinder { <-45, -75*tan(10*pi/180), 135>, <-45, 30-75*tan(10*pi/180), 135>, 0.5
		pigment { colour rgb <0.5, 0.5, 0.5> }
	}*/
}
