#include "metals.inc"

#declare PC_Ruby = material {
	texture {
		finish {
			ambient 0.1
			diffuse 0.1
			reflection .25
			specular 1
			roughness 0.001
		}
		pigment { color rgbf <1.0, 0.1, 0.2, 0.65> }
	}
	interior { ior 2.1 }
}

#declare PC_Emerald = material {
	texture {
		finish {
			ambient 0.2
			diffuse 0.1
			reflection 0.15
			specular 1
			roughness 0.001
		}                              
		pigment { colour rgbf <0.2, 1.0, 0.2, 0.75> }
	}
	interior { ior 1.8 }
}

#declare Ruby = intersection {
	merge {
		prism {
			linear_spline
			conic_sweep
			0, 0.1, 9,
			#declare i = 0;
			#while ( i < 8 )
				<0.75*sin( pi/4*i + pi/8 ), 0.75*cos( pi/4*i + pi/8 )>,
				#declare i = i + 1;
			#end
			<0.75*sin(pi/8), 0.75*cos(pi/8)>
			translate <0, -0.1, 0>
		}
		prism {
			linear_spline
			conic_sweep
			0, 0.1, 9,
			#declare i = 0;
			#while ( i < 8 )
				<0.75*sin( pi/4*i + pi/8 ), 0.75*cos( pi/4*i + pi/8 )>,
				#declare i = i + 1;
			#end
			<0.75*sin(pi/8), 0.75*cos(pi/8)>
			rotate x*180
			translate <0, 0.1, 0>
		}
	}
	box { <-0.75, -0.05, -0.75>, <0.75, 0.05, 0.75> }
	rotate x*90
} 

#declare Emerald = intersection {
	merge {
		prism {
			linear_spline
			conic_sweep
			0, 0.1, 5,
			<-0.5, -0.75>, <-0.5, 0.75>, <0.5, 0.75>, <0.5, -0.75>, <-0.5, -0.75>
			translate <0, -0.1, 0>
		}
		prism {
			linear_spline
			conic_sweep
			0, 0.1, 5,
			<-0.5, -0.75>, <-0.5, 0.75>, <0.5, 0.75>, <0.5, -0.75>, <-0.5, -0.75>
			rotate x*180
			translate <0, 0.1, 0>
		}
	}
	box { <-0.5, -0.05, -1>, <0.5, 0.05, 1> }
	rotate x*90
}

#declare Encased_Ruby = union {
	object { Ruby
		material { PC_Ruby }
		//pigment { colour rgb <1, 0, 0> }
		//finish { ambient 0.5 }
	}
	difference {
		union {
			sphere { <0, 0, 0>, 0.1
				scale <0.85, 0.85, 0.5>
				translate <0, 0, 0.02>
			}
			difference { 
				sphere { <0, 0, 0>, 0.1
					scale <0.85, 0.85, 1>
					translate <0, 0, 0.02>
				}
				plane { z, 0.02 }
			}
		}
		object { Ruby }
	}
}

#declare Encased_Emerald = union {
	object { Emerald
		material { PC_Emerald }
		//pigment { colour rgb <0, 1, 0> }
		//finish { ambient 0.5 }
	}
	difference {
		union {
			sphere { <0, 0, 0>, 0.1
				scale <0.85, 1.1, 0.4>
				translate <0, 0, 0.02>
			}
			difference { 
				sphere { <0, 0, 0>, 0.1
					scale <0.85, 1.1, 0.8>
					translate <0, 0, 0.02>
				}
				plane { z, 0.02 }
			}
		}
		object { Emerald }
	}
}
		   
#declare Grail = union {
	difference {
		sphere { <0, 0, 0>, 1
			scale <1, 0.8, 1>
		}
		sphere { <0, 0, 0>, 0.95
			scale <1, 0.8, 1>
		}
		plane { -y, 0 }
		translate <0, 2, 0>
	}
	#declare i = 0;
	#while ( i < 4 )
		object { Encased_Ruby
			scale 3
			rotate y*-90
			rotate z*-20
			translate <0.9, 1.7, 0>
			rotate y*i*90
		}
		#declare i = i + 1;
	#end	
	#declare i = 0;
	#while ( i < 4 )
		object { Encased_Emerald
			scale 2.5
			rotate y*-90
			rotate z*-20
			translate <0.925, 1.7, 0>
			rotate y*(i*90 + 45 )
		}
		#declare i = i + 1;
	#end	
	torus { 0.2, 0.3
		translate <0, 1.15, 0>
	}
	difference {
		cylinder { <0, 0.4, 0>, <0, 0.9, 0>, 0.375 }
		torus { 0.375, 0.125
			scale <1, 4, 1>
			translate <0, 0.4, 0>
		}
		
	}
	difference {
		cylinder { <0, 0, 0>, <0, 0.4, 0>, 0.75 }
		torus { 0.75, 0.5
			scale <1, 0.6, 1>
			translate <0, 0.4, 0>
		}
	}
	difference {
		torus { 0.75, 0.1 }
		plane { y, 0 }
	}
	texture { T_Gold_4B }
}
