#include "Maketree.pov"

#local SaplingBark =
texture {
	pigment {
		gradient y
		color_map {
			[ 0 rgb <0,1,0> ]
			[ 1 rgb <0.7,0.5,0> ]
		}
		scale <1,50,1>
	}
	finish { specular 0.5 }
}
#local TreeBark = texture {
	pigment {
		spherical
		color_map {
			[ 0 rgbf <0.519997, 0.308354, 0.135210,0> ]	// Swapped...
			[ 1 rgbf <0.309987, 0.124590, 0.024811,0> ]
		}
		scale <22,42,22>
	}
	normal {
		crackle 0.25			// 0.15
		bump_size -0.75	// -1
		scale <1.6,0.45,1.6>
	}	
	finish {
		specular 0.1
		roughness 0.1
	}
}
#local BarkClock = Timer( TreeClock, 0, 0.5, true );
#declare txtTree = texture {
	average
	texture_map {
		[ (1-BarkClock) SaplingBark ]
		[ BarkClock TreeBark ]
	}
}
#declare txtLeaf =
texture {
	pigment { rgb <0,0.5,0> }
	finish { specular 0.65 }
}
#declare dofile = false;
#declare dotexture = false;

// 2
#declare rsd=8;      // random seed
#declare rd=seed(rsd);  // random stream for branches
#declare rdl=seed(rsd); // separate random stream for leaves

#declare level0=6;      // recursion level
#declare nseg0=6;       // initial number of branch segments (decreases of one at each level)
#declare nb=5;          // max number of branches per level
#declare dotop=false;   // if true, generates an extra branch on top of trunk (sometimes necessary to give more verticality)

//#declare lb0=19;        	// initial branch length
//#declare rb0=2;         	// initial branch radius
#declare lb0=12+7*TreeClock;        	// initial branch length
#declare rb0=0.3+1.7*TreeClock;         	// initial branch radius
//#declare leafproba=0.97;   // probability of leaf 0=no leaf ; 1=leaf on each segment
#declare leafproba=0.01+0.96*pow( TreeClock, 3 );   // probability of leaf 0=no leaf ; 1=leaf on each segment
	
	
#declare ab0=25;        // initial branch angle (x angle between the trunk and the first branch)
#declare qlb=0.6;       	// branch length decrease ratio (1=constant length)
#declare qrb=0.5;       	// branch radius decrease ratio (1=constant radius)
#declare qab=0.9;       		// branch angle decrease ratio (1=constant angle)
#declare stdax=10;      // stdev of x angle (angle x = ax+(0.5-rand)*stdax)
#declare stday=10;      // stdev of y angle (angle y = ay+(0.5-rand)*stday)

#declare fgnarl=0.2;    // gnarledness factor - keep it low <0.8
#declare stdlseg=0.5;     // stddev of branch segment length (0...1) (adds more randomness to branch length)

#declare twigproba=0.35; // probability to have a twig on a trunk segment
#declare rootproba=0;   // probability of root 0=no root ; 1=all [nroot] roots
#declare nroot=5;      // number of main roots;
#declare vroot=<1,-0.4,0>; // initial direction of root 
#declare yroot=<0,0.5,0>;   // initial position of root above ground

#declare v0=<0,1,0>;    // initial direction - change to give an initial orientation
#declare pos0=<0,0,0>;  // initial trunk position (no need to change this one)
#declare vpush=<-0.1,-0.1,0.1>;// direction of push (wind, gravity...) <0,-1,0> = gravity ; <0,1,0> = antigravity
#declare fpush=0.3;       // force of push
#declare aboveground=7; // constrains the branches above this level 
#declare belowsky=1000;  // constrains the branches below this level 

#declare branchproba=0.9; // probability of branch apparition 
#declare jb=0.4;        // secondary branches start after this ratio of branch length

#declare leaflevel=4;   // level where the leaves start to appear
#declare alz0=100;       // max z angle for leaf
#declare alx0=-10;      // start x angle for leaf
#declare stdalx=20;     // stddev x angle for leaf
#declare stdlsize=0.3;  // stddev of leaf size 0=constant size; size = leafsize*(1+stdlsize*rand)

//-----------------------------------------
// leaf structure parameters
//-----------------------------------------
#declare lsize=0.3;     // leaf size
#declare seg=10;        // nb of leaf segments and stalk segments : increase to smooth
#declare ll=5;          // leaf length
#declare wl=1;          // leaf width 
#declare fl=0.5;        // depth of leaf fold
#declare lpow=1;        // modifies the leaf shape : lpow=3 makes heart-shaped leaf
#declare al=100;        // leaf bending angle : the leaf bends backward until this angle
#declare apow=1;        // curve power, how slow the leaf bends
#declare ndents=0;      // dents in the leaf (8 = "oak" leaf). May require a high seg >20
#declare nlobes=1;      // number of lobes (individual leaves)
#declare alobes=0;    // angle made by all the lobes
#declare qlobes=1;    // size of the farest lobe (0.9 = size will be 0.9*leaf length)                               
#declare ls=3;          // stalk length (0=no stalk)
#declare ws=0.1;        // width of stalk
#declare as=10;         // stalk bending angle : the stalk bends forward


 #declare Leaf=object{MakeLeaf(0.3,10,5,0.6,0.2,1,100,1,0,5,160,0.9,3,0.12,10,false,"Bleh")
	texture { txtLeaf }
}

#declare LiveTree = object { MakeTree() texture { txtTree }  }