
#include "scene.inc"

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<4,0,0>translate<-1.5,-7,6>
      }

light_source{<1e+06,-1e+06,1e+06>color rgb 0.9}
light_source{<1e6,-1e+06,1e01> color rgb 0.7 shadowless}
global_settings{ambient_light rgb 0.5 }

fog{ distance 300 color rgbf<1,1,1,0.5>}
object{ground}
object{low_cloud}

#macro flag_surface(t0,t1,t2)
  // Time parameter
  #local tc = pow(t2,1.5);

  // x coords with correction for parts not tied to pole
  #local px = -t0 - pow(1-t0,10)*0.05*sin(t1*pi);

  // x wobble for movement of pole
  #local px = px - (0.5+0.5*t2)*(0.02+0.02*t1)*(sin(70*t2) + sin(72*t2));

  // y coords with decreasing droop
  #local py = (1-t0*0.1)*t1+(0.05*t0) - 0.25*t0*(1-tc);

  // z coords for waves across surface
  #local pz = t0 * (0.3 + tc*0.1) * sin(t0*0.5*pi - t2*(50+tc*60));
  #local pz = pz + (0.1 + tc*0.1) *
                 sin(sqrt(t0*t0+pow(1-0.3*t1,2))*7.5*pi - t2*(51+tc*61) );
  #local pz = pz + (0.05 + tc*0.05) *
                 sin(sqrt(t0*t0+pow(0.2*t1,2))*7.0*pi - t2*(52+tc*62) );

  (<3.2*px-0.25,pz,2.4*py + 5.4>)
#end

// Pole position
#declare fp = flag_surface( 0, 1, clock );

// Twang the pole after flag breaks free
#if (clock > 0.9)
    #declare tc = 10*(clock-0.9);
    #declare fp = fp + <0.6*(1-0.5*tc) * (0.2+sin(tc*5*pi)) + 0.25*tc,0,0>;
#end

// Pole
sphere_sweep{cubic_spline 7,
    <0,0, -2>, 0.2
    <0,0, 0>, 0.18
    <0,0, 2>, 0.16
    <0.25*fp.x,0.25*fp.y 4>, 0.14
    <0.5*fp.x,0.5*fp.y, 6>, 0.12
    <fp.x,fp.y, 8>, 0.1
    <1.5*fp.x,1.5*fp.y, 10>, 0.1
  texture{pigment{color rgb 1}finish{ambient rgb 0.5}}
  }
sphere{<fp.x,fp.y,8>, 0.15 texture{pigment{color rgb 1}finish{ambient rgb 0.5}}}

// Flag mesh point arrays
#declare ni = 40;
#declare nj = 30;
#declare p = array[ni][nj];
#declare n = array[ni][nj];
#declare dt = 0.00001;
#declare i = 0;
#while(i < ni)
  #declare t0 = i / (ni-1);
  #declare j = 0;
  #while(j < nj)
    #declare t1 = j / (nj-1);
    #declare p[i][j] = flag_surface( t0, t1, clock );
    #declare p0 = flag_surface( t0+dt, t1, clock );
    #declare p1 = flag_surface( t0, t1+dt, clock );
    #declare n[i][j] = vnormalize(vcross(p[i][j]-p0,p[i][j]-p1));
    #declare j = j + 1;
  #end
  #declare i = i + 1;
#end

// Flag mesh
mesh{
  #declare i = 0;
  #while(i < ni-1)
    #declare j = 0;
    #while(j < nj-1)

      #declare n0 = n[i][j];
      #declare p0 = p[i][j];
      #declare u0 = i / (ni-1);
      #declare v0 = j / (nj-1);

      #declare n1 = n[i][j+1];
      #declare p1 = p[i][j+1];
      #declare u1 = i / (ni-1);
      #declare v1 = (j+1) / (nj-1);

      #declare n2 = n[i+1][j+1];
      #declare p2 = p[i+1][j+1];
      #declare u2 = (i+1) / (ni-1);
      #declare v2 = (j+1) / (nj-1);

      #declare n3 = n[i+1][j];
      #declare p3 = p[i+1][j];
      #declare u3 = (i+1) / (ni-1);
      #declare v3 = j / (nj-1);

      smooth_triangle{p0,n0, p1,n1, p2,n2
                      uv_vectors <1-u0,v0>,<1-u1,v1>,<1-u2,v2>}
      smooth_triangle{p2,n2, p3,n3, p0,n0
                      uv_vectors <1-u2,v2>,<1-u3,v3>,<1-u0,v0>}

      #declare j = j + 1;
    #end
    #declare i = i + 1;
  #end
  texture{pigment{uv_mapping image_map{png "flagmap2.png"} }
          finish{ambient rgb 0.5}
         }

  // Let flag break free
  #if (clock > 0.9) 
      translate<-pow(10*(clock-0.9),1.0)*15,0,0>
  #end
}

