
#include "scene.inc"
#include "twister.inc"
#include "objects"

global_settings { max_trace_level 5 }

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<12,0,-45>translate<-45,-45,1.0>
      }

light_source{<1e6,-1e6,1e5> colour rgb 0.9}
light_source{<1e4,-1e6,1e6> colour rgb 0.3 shadowless}
global_settings{ambient_light rgb 0.6}

fog{ distance 300 color rgbf<1,1,1,0.5>}
object{ground}
object{low_cloud}

// Twister path
#declare t_path = clock;

// Building
difference{
#include "building.inc"
union{
  box{<18,-8.5,0>,<50,8.5,4.3> pigment{color rgbt<1,1,1,1>}}
  cone{<18.0,0,0>, 7.8 <18,0,4.3>, 8.1 pigment{color rgbt<1,1,1,1>}}
  translate<-30.5*t_path,0,0>
     }
}

// Twister
#declare tx = 18 - t_path * 30;
#declare twister_rotation = clock * twister_speed;
#declare twister_density = 0.8;
#declare tr = 7.5;

// Dispersal
#if(clock>0.8 )
  #declare tc = (clock-0.8) / 0.2;
  #declare twister_density = 0.8 - 0.7 * tc;
#end

make_twister( tx, 0, 70, 50, tr,
              70, twister_rotation,twister_density)

// Air debris
#declare debrisR = seed(4);
#declare ni = 4000;
#declare i = 0;
#while(i < ni)
  #declare t_debris = i/(ni-1);
  #declare start_time = 0.03 + t_debris * 0.7;
  #declare stop_time = start_time + 0.3;
  #if ((clock >= start_time) & (clock <= stop_time))
     #declare t_path = (clock - start_time) / (stop_time - start_time);
  #else
     #declare t_path = 2;
  #end

  #if (start_time<=0.1)
      #declare s = 0.3+0.5*pow(rand(debrisR),2);
  #end
  #if (start_time > 0.1)
      #declare s = 0.3+0.5*pow(rand(debrisR),2);
  #end

  #declare theta_phase = rand(debrisR) * 2 * pi;
  #declare vr = <rand(debrisR)*360,rand(debrisR)*360,rand(debrisR)*360>;

  #if (t_path <= 1.0)
    #declare r_min = tr + 0.5;
    #declare r_range = 65;
    #declare h = 25;
    #declare theta_max = 15*pi;

    #declare r = r_min + pow(t_path, 1.4) * r_range;
    #declare theta = pow(t_path,0.03) * theta_max;

    #declare dx = tx + r * cos(theta+theta_phase);
    #declare dy = r * sin(theta+theta_phase);
    #declare dz = h * sin(pow(t_path,0.9) * pi);

    make_splinter(<dx,dy,dz>, s, vr )
  #end

  #declare i = i + 1;
#end

// Ground debris
#declare R3 = seed(4);
#declare ni = 3000;
#declare i = 0;
#while(i < ni)
  #declare t_debris = i/(ni-1);
  #declare vr = <rand(R3)*20,rand(R3)*10,rand(R3)*360>;
  #declare s = 0.3+0.4*rand(R3);
  #declare theta = (pi-0.4) + rand(R3)*(pi+0.6);
  #declare sr = 10 + rand(R3) * 40;

  #if ( t_debris < (1.5*clock-0.3) )
     make_splinter(<sr*cos(theta),sr*sin(theta),0.2>, s, vr)
  #end  

  #declare i = i + 1;
#end

// Objects
#declare R1 = seed(3);
#declare ni = 40;
#declare i = 0;
#while(i < ni)

  #declare t_debris = i/(ni-1);
  #declare start_time = 0.2 + t_debris * 0.1;
  #declare stop_time = start_time + 0.3;
  #if ((clock >= start_time) & (clock <= stop_time))
     #declare t_path = (clock - start_time) / (stop_time - start_time);
  #else
     #declare t_path = 2;
  #end

  #declare theta_phase = rand(R1)*1.2*pi;
  #declare theta = clock*8*pi;

  #declare or = 12+3*t_path;
  #declare ox = tx + or * cos(theta+theta_phase);
  #declare oy = or * sin(theta+theta_phase);
  #declare oz = 2 + t_path * 50;

  #declare ax = rand(R1)*360 + clock*1500;
  #declare ay = rand(R1)*360 + clock*1700;
  #declare az = rand(R1)*360 + clock*1900;

  #if (t_path <= 1.0)
    #declare o = mod(i,4);
    make_object(o, ox, oy, oz, ax, ay, az)
  #end

  #declare i=i+1;
#end

