
#declare twister_speed = 1.5 * (final_frame - initial_frame);

#macro make_vortex_pigment(rotation, dens)

  #declare P1 = pigment{
    bozo frequency 1 turbulence 0.65 octaves 6 omega 0.6 lambda 2 scale <2,1,1>
    color_map{
      [0.0  color rgbt<0.0,0.0,0.0,1-dens>]
      [dens color rgbt<1,1,1,1-dens>]
      [0.8*dens+0.1 color rgbt<1,1,1,1>]
      [1.0  color rgbt<1,1,1,1>]
    }
    translate<-rotation,0,0>
    warp {spherical  orientation z dist_exp 1}};

   #declare P2 = pigment{
    bozo frequency 1 turbulence 0.65 octaves 6 omega 0.6 lambda 2 scale <2,1,1>
    color_map{
      [0.0  color rgbt<0.0,0.0,0.0,1-dens>]
      [dens color rgbt<1,1,1,1-dens>]
      [0.8*dens+0.1 color rgbt<1,1,1,1>]
      [1.0  color rgbt<1,1,1,1>]
         }
    translate<1-rotation,0,0>
    warp {spherical  orientation z dist_exp 1}
    rotate<0,180,0>};

  #declare twister_pigment = pigment{
    radial triangle_wave frequency 1 rotate<90,0,0>
    pigment_map{[0 P2][1 P1]} };

#end

#macro twister_surface(t0, t1, r0, r1, depth)
  #local rad = r0 + t1 * (r1 - r0);
  #local px = 0.01 + rad * cos(t0*2*pi);
  #local py = 0.01 + rad * sin(t0*2*pi);
  #local pz = -depth * pow(t1,4);
  (<px,py,pz>)
#end

#macro make_twister( tx, ty, tz, r0, r1, depth, rotation, dens )
  #local ni = 60;
  #local nj = 60;
  #local p = array[ni][nj]
  #local n = array[ni][nj]
  #local dt = 0.0001;
  #local i = 0;
  #while(i < ni)
    #local t0 = i / (ni-1);
    #local j = 0;
    #while(j < nj)
      #local t1 = j / (nj-1);
      #local p[i][j] = twister_surface(t0, t1, r0, r1, depth);
      #local p0 = twister_surface(t0+dt, t1, r0, r1, depth);
      #local p1 = twister_surface(t0, t1+dt, r0, r1, depth);
      #local n[i][j] = vnormalize(vcross(p[i][j]-p0,p[i][j]-p1));
      #local j = j + 1;
    #end
    #local i = i + 1;
  #end

  #local twister_object = mesh{
    #local i = 0;
    #while(i < ni-1)
      #local j = 0;
      #while(j < nj-1)
        #local n0 = n[i][j];
        #local p0 = p[i][j];
        #local n1 = n[i][j+1];
        #local p1 = p[i][j+1];
        #local n2 = n[i+1][j+1];
        #local p2 = p[i+1][j+1];
        #local n3 = n[i+1][j];
        #local p3 = p[i+1][j];
        smooth_triangle{p0,n0,p1,n1,p2,n2}
        smooth_triangle{p2,n2,p3,n3,p0,n0}
        #local j = j + 1;
      #end
      #local i = i + 1;
    #end
  }

  make_vortex_pigment(rotation, dens)
  object{twister_object translate<tx,ty,tz>
         texture{pigment{twister_pigment}
                 finish{ambient rgb 0.5}
                 translate<tx,ty,tz-depth>}
        }
#end

