
#include "scene.inc"
#include "twister.inc"
#include "objects.inc"

global_settings{max_trace_level 5}

camera{perspective
       location camera_location
       direction camera_direction
       right camera_right 
       up camera_up 
       rotate<90,0,0>translate<0,0,0>
      }

light_source{<1e6,-1e6,1e6>color rgb 0.9}
light_source{<-1e6,-1e6,-1e6> color rgb 0.7 shadowless}
global_settings{ambient_light rgb 1 }

object{light_cloud translate<0,0,100>}

// Twister
#declare tx = 2*cos(-clock*3*pi);
#declare ty = 2*sin(-clock*3*pi);
#declare twister_rotation = clock*twister_speed;
make_twister( tx, ty, 80, 10, 8,  80,twister_rotation, 0.9)

// Objects
#declare R1 = seed(3);
#declare ni = 40;
#declare i=0;
#while (i<ni)
  #declare ti = i / (ni-1);
  #declare theta_phase = rand(R1)*2*pi;
  #declare tr = rand(R1);
  #declare theta = clock*(3+3*(1-tr))*pi;
  #declare or = 3 + tr * 3;
  #declare ox = or * cos(theta+theta_phase);
  #declare oy = or * sin(theta+theta_phase);
  #declare oz = -40 + ti*70 + clock * 80;

  #declare ax = rand(R1)*360 + clock*1000;
  #declare ay = rand(R1)*360 + clock*1300;
  #declare az = rand(R1)*360 + clock*1500;

  #declare o = mod(i,4);
  make_object( o, ox, oy, oz, ax, ay, az )

  #declare i=i+1;
#end

