
// Glenn's POV-Ray Animation Macros
// created 6-Jan-03
// last update 8-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )
//
// Macros for use in Animations
//
// Shake(Frequency,Seed,Xindex)
//   creates a smooth randomized movement in Y-direction
//   Imagine a wiggly line that goes from <0,0,0> to <1,0,0>
//   While X and Time travels from 0 to 1,
//   Y varies randomly, with maximum amplitude of Y= +/-1
//   Velocity and position is 0 at both ends
//   Frequency is the number of cycles (shakes) per second
//   Different seeds give different randomizations
//   Macro returns the Y-value at time=Xindex
//
// Boost() creates accelleration along X
//
// Ease() creates motion along X from 0 to a given velocity
//
//

#macro Shake(Frequency,Seed,Time)
	#local Freq=Frequency;
	#local RS=seed(Seed);
	#local MySpline=
		spline {
			cubic_spline
			(-1/Freq)/10,<(-1/Freq)/10,0,0>, // this point sets the tangent to zero
			0,<0,0,0>, // this point sets the starting point to zero
			#local XTime = (1/Freq)/2; // first peak occurs here
			#while ( XTime < 0.9999 )
				XTime,<XTime,-1+rand(RS)*2,0>
//			#debug concat(" XTime: ",str(XTime,5,3),"\n")
				#local XTime = XTime + (1/Freq)/2; // increment time, two peaks per cycle
			#end
			1,<1,0,0>, // this point sets the ending point to zero
			(1+(1/Freq)/10),<1+(1/Freq)/10,0,0> // this point sets the tangent to zero
		}
/*
	#if ( Debug = 1 )
		#local KK=-0.2;
		#while ( KK < 1.3 )
			#debug concat(str(KK,5,3)," ShakeVal: ",str(MySpline(KK).y,5,3),"\n")
		#local KK = KK + 0.02;
		#end
			#debug concat("ShakeVal -1  = ",str(MySpline(-1.00).y,5,3),"\n")
			#debug concat("ShakeVal 0.95= ",str(MySpline(.95).y,5,3),"\n")
			#debug concat("ShakeVal 0.99= ",str(MySpline(.99).y,5,3),"\n")
			#debug concat("ShakeVal 1.00= ",str(MySpline(1.00).y,5,3),"\n")
			#debug concat("ShakeVal 3.00= ",str(MySpline(3.00).y,5,3),"\n")
	#end
*/
// Following is the return value of this macro:
(MySpline(Time).y)

#end



