
// Glenn's POV-Ray Animation File - Bobsled Shot 130
// created 30-Nov-02
// last update 11-Jan-03
// 2003 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
	angle 11
  location  <-5*Feet,-30*Feet, 19*Feet> // scene view
  look_at   <0*Feet,10*Feet , 15*Feet-0.6*Feet*Seconds+0.4*Feet*Seconds*Seconds >
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 35
  location  <-5*Feet,-13*Feet, 39*Feet> // scene view
  look_at   <0*Feet,10*Feet , 15*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}


//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"
object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		texture { BluePaintTex } 
	} // end union

//===============================================
//             Objects
//===============================================

#include "Bobsled.inc"

#declare SideHandle =
	intersection {
		cylinder {
			<-2,0,0>,<2,0,0>,12
		}
		cylinder {
			<-1.2,0,0>,<1.2,0,0>,11.2
			inverse
		}
		box {
			<-0.7,-13,-4>,<0.7,0,8>
		}
//		texture { GlossyBlack }
			texture { pigment { color rgb<0.1,0.13,0.13> } }
	} // end intersection

#declare SlottedSledS =
	difference {
		object { BobsledS }
		box {
			<-0.7,-13,-4>,<0.7,0,8>
			texture { pigment { color rgb<0,0,0> } }
			translate <40,0,16>
		}
	} // end difference

#declare SledGroup =
	union {
		object { SlottedSledS }
		object { SideHandle
			translate <0,10,-6> rotate x*-90 translate <0,-10,6>
			translate <40,0,16>
		}
	} // end union

#include "Athlete.inc"
#declare Brakeman = object { Athlete translate <0,0,5.0*Feet> }

#declare  Pose = 1;
// Pose Angles ( in order )
#declare HPan     = 32;   // head, positive = towards his left
#declare HTiltFwd = 15;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 60;   // twists the hand, positive = palms up
#declare REAng    = 70;  // elbow
#declare RAFwd    = 43;   // total arm
#declare RARot    = 1;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 0;    // claps hands
#declare RKnee    = 75;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 95;    // leg angle fwd
#declare RLOut    = 5;    // spread eagle
#declare LWCock   = 0;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle
#declare LETwist  = 60;  // twists the hand, positive = palms up
#declare LEAng    = 62;   // elbow
#declare LAFwd    = 46;   // total arm
#declare LARot    = 1;   // claps hands
#declare LAOut    = 16;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = -23;  // claps hands
#declare LKnee    = 110;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 70;    // leg angle fwd
#declare LLOut    = 5;    // spread eagle
#include "Athlete.inc"
#declare Pilot = object { Athlete translate <0,0,5.0*Feet> }

//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }

object { SledGroup rotate z*90 translate <0,4*Feet,13*Feet> }
object { Brakeman rotate x*(30+Seconds*3.6) translate <-1,16.1*Feet,13*Feet> }
object { Pilot rotate x*(40+Seconds*2.5) translate <22,12.5*Feet,13*Feet> }

