
// Glenn's POV-Ray Animation File - Bobsled Shot 170
// created 27-Dec-02
// last update 2-Jan-03
// 2002 Glenn McCarter  ( glenn@mccarters.net )

#include "GIncludeRH.inc"

//#include "GRuler.inc"

#version 3.5;
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}


//===============================================
//             Variables
//===============================================

#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare DoFog = 0; // 0=no fog, 1=fog
#declare LocalOrigin = <430*Feet,980*Feet,0>;
#declare Seconds = Sclock*(Sframes/FPS); // goes from 0+ to #-of-seconds in this shot

#if ( Debug = 1) #debug concat("Seconds: ",str(Seconds,5,3),"\n") #end

#declare NewOrigin = <-80*Feet,-80*Feet,6*Feet>;

#declare BTime = 0.60;
#declare B2Time = 0.93;
#switch ( Seconds )
#range (0,BTime)
	#declare SBPos = NewOrigin
		+ <30*Feet-5*Feet*Seconds,32*Feet-20*Feet*Seconds,7*Feet+12*Feet*Seconds-32*Feet*Seconds*Seconds>;
#break
#range (BTime+0.001,B2Time)
	#declare SBPos = NewOrigin
		+ <30*Feet-5*Feet*Seconds,32*Feet-20*Feet*Seconds,7*Feet+12*Feet*BTime-32*Feet*BTime*BTime>
		+ <0,0,5*Feet*(Seconds-BTime)-32*Feet*(Seconds-BTime)*(Seconds-BTime)>;
#break
#else
	#declare SBPos = NewOrigin
		+ <30*Feet-5*Feet*Seconds,32*Feet-20*Feet*Seconds,7*Feet+12*Feet*BTime-32*Feet*BTime*BTime>
		+ <0,0,5*Feet*(B2Time-BTime)-32*Feet*(B2Time-BTime)*(B2Time-BTime)>
		+ <0,0,-1.5*Feet*(Seconds-B2Time)>;
#end

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  angle 50
  location  NewOrigin+<10*Feet,10*Feet,5*Feet>
  look_at   NewOrigin+<20*Feet,20*Feet-8*Feet*Seconds-4*Feet*Seconds*Seconds,5*Feet>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
    angle 50
//    direction z*50
//  location  <2*Feet, 50*Feet, 140*Feet> // overhead
//  look_at   <3*Feet, -0*Feet, 0*Feet >
  location  <20*Feet,0*Feet, 18*Feet> // scene view
  look_at   <0*Feet,10*Feet , 16*Feet >
  }

camera {
//  Special_Cam
  Render_Cam
  }

//===============================================
//             Textures
//===============================================

#declare BluePaintTex =
	texture {
		pigment { color rgb<.36,.38,.89> }
	}

//===============================================
//             Lighting
//===============================================

#include "TrackLights.inc"
object { TrackLight translate <6*Feet,30*Feet,13*Feet> }
object { TrackLight translate <6*Feet,0*Feet,13*Feet> }
object { TrackLight translate <6*Feet,-30*Feet,13*Feet> }

//===============================================
//             Environment
//===============================================

#include "BobEnviron.inc"

object { Plain rotate x*-17 translate -LocalOrigin }
object { TrackTerrain translate -LocalOrigin }
object { NearbyMountains scale 1 rotate x*-17 translate <-1500*Feet,-1000*Feet,220*Feet> translate -LocalOrigin }
object { NearbyMountains scale 2 rotate z*180 rotate x*-17 translate <5000*Feet,1200*Feet ,-500*Feet> translate -LocalOrigin }

#include "TrackMaker.inc"
object { TotalTrack translate -LocalOrigin+<0,0,2*Feet> }

#declare StartingGround =
	union {
		box { <-40*Feet,0,-20*Feet>,<40*Feet,100*Feet,0> }
		box { <4*Feet,0,-20*Feet>,<40*Feet,40*Feet,12> }
		box { <-40*Feet,0,-20*Feet>,<-4*Feet,40*Feet,12> }
		texture { IcyTex }
	} // end union

#declare Pavilion =
	union {
		box { // roof
			<-25*Feet,0,0>,<25*Feet,30*Feet,12>
			translate <0,0,12*Feet>
		}
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <-25*Feet+22,30*Feet-22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,22,0> }
		box { <-6,-6,0>,<6,6,12*Feet> translate <25*Feet-22,30*Feet-22,0> }
		texture { BluePaintTex } 
	} // end union

#declare SnowballHill =
	height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
		png "SnowHillHF.png"
		smooth
		water_level 1/255
		double_illuminate
		rotate x*90
		scale <1,-1,1>
		scale <60*Feet,48*Feet,7*Feet>
		texture { SnowyTex }
//		rotate x*17
//		translate <-500*Feet,0,100*Feet>
	}


//===============================================
//             Objects
//===============================================

#declare RS = seed(60371);

#declare TwoFootSnowball =
	union {
		sphere { // main
			<0,0,0>,12
		}
		#declare SS = 0;
		#while (SS<40)
			sphere {
				<0,0,0>,2.4+rand(RS)*1.6
				translate <0,0,-12>
				rotate y*(360*rand(RS))
				rotate z*(360*rand(RS))
			}
			#declare SS = SS + 1;
		#end
		texture { BrightSnowyTex scale 0.3 }
		#if (Seconds < BTime)
			rotate x*360*(1.8*Seconds)
		#else
			rotate x*360*(1.8*BTime+(2.3*Seconds-BTime)+0.4*Seconds*Seconds)
		#end
		translate <0,0,12>
	} // end union

//===============================================
//             Object Placement
//===============================================

object { StartingGround translate <0,0,13*Feet> }
object { Pavilion translate <0,30*Feet,13*Feet> }

//object { SBGroundPath translate NewOrigin }
object { SnowballHill translate NewOrigin }
object { TwoFootSnowball translate SBPos }
